/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.PartitionManager;
import ucar.coord.CalendarDateFactory;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateSharer;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateUnionizer;
import ucar.coord.CoordinateUniquify;
import ucar.coord.CoordinateVert;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribCollectionWriter;
import ucar.nc2.grib.collection.GribHorizCoordSystem;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.grib.collection.PartitionCollectionProto;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

abstract class GribPartitionBuilder {
    protected static final int version = 2;
    protected final PartitionManager partitionManager;
    protected String name;
    protected Logger logger;
    protected PartitionCollectionMutable result;
    private GribCollectionWriter writer;

    protected GribPartitionBuilder(String name, PartitionManager tpc, Logger logger) {
        this.name = name;
        this.partitionManager = tpc;
        this.logger = logger;
    }

    public boolean updateNeeded(CollectionUpdateType ff) throws IOException {
        if (ff == CollectionUpdateType.never) {
            return false;
        }
        if (ff == CollectionUpdateType.always) {
            return true;
        }
        File collectionIndexFile = GribIndexCache.getExistingFileOrCache(this.partitionManager.getIndexFilename());
        if (collectionIndexFile == null) {
            return true;
        }
        if (ff == CollectionUpdateType.nocheck) {
            return false;
        }
        return this.needsUpdate(ff, collectionIndexFile);
    }

    private boolean needsUpdate(CollectionUpdateType ff, File collectionIndexFile) throws IOException {
        long collectionLastModified = collectionIndexFile.lastModified();
        HashSet<String> newFileSet = new HashSet<String>();
        for (MCollection dcm : this.partitionManager.makePartitions(CollectionUpdateType.test)) {
            String partitionIndexFilename = StringUtil2.replace(dcm.getIndexFilename(), '\\', "/");
            File partitionIndexFile = GribIndexCache.getExistingFileOrCache(partitionIndexFilename);
            if (partitionIndexFile == null) {
                return true;
            }
            if (collectionLastModified < partitionIndexFile.lastModified()) {
                return true;
            }
            newFileSet.add(partitionIndexFilename);
        }
        if (ff == CollectionUpdateType.testIndexOnly) {
            return false;
        }
        GribCdmIndex reader = new GribCdmIndex(this.logger);
        ArrayList<MFile> oldFiles = new ArrayList<MFile>();
        reader.readMFiles(collectionIndexFile.toPath(), oldFiles);
        HashSet<String> oldFileSet = new HashSet<String>();
        for (MFile oldFile : oldFiles) {
            if (!newFileSet.contains(oldFile.getPath())) {
                return true;
            }
            oldFileSet.add(oldFile.getPath());
        }
        for (String newFilename : newFileSet) {
            if (oldFileSet.contains(newFilename)) continue;
            return true;
        }
        return false;
    }

    public boolean createPartitionedIndex(CollectionUpdateType forcePartition, Formatter errlog) throws IOException {
        if (errlog == null) {
            errlog = new Formatter();
        }
        for (MCollection dcmp : this.partitionManager.makePartitions(forcePartition)) {
            dcmp.putAuxInfo("fcConfig", this.partitionManager.getAuxInfo("fcConfig"));
            this.result.addPartition(dcmp);
        }
        this.result.sortPartitions();
        int n = this.result.getPartitionSize();
        if (n == 0) {
            errlog.format("ERR Nothing in this partition = %s%n", this.result.showLocation());
            throw new IllegalStateException("Nothing in this partition =" + this.result.showLocation());
        }
        int idx = this.partitionManager.getProtoIndex(n);
        PartitionCollectionMutable.Partition canon = this.result.getPartition(idx);
        this.logger.debug("     Using canonical partition {}", (Object)canon.getDcm().getCollectionName());
        try (GribCollectionMutable gc = canon.makeGribCollection();){
            if (gc == null) {
                throw new IllegalStateException("canon.makeGribCollection failed on =" + this.result.showLocation() + " " + canon.getName() + "; errs=" + errlog);
            }
            this.result.copyInfo(gc);
            this.result.isPartitionOfPartitions = gc instanceof PartitionCollectionMutable;
        }
        GribCollectionMutable.Dataset ds2D = this.makeDataset2D(errlog);
        if (ds2D == null) {
            errlog.format(" ERR makeDataset2D failed, index not written on %s%n", this.result.showLocation());
            throw new IllegalStateException("makeDataset2D failed, index not written on =" + this.result.showLocation() + "; errs=" + errlog);
        }
        this.result.makeHorizCS();
        if (ds2D.gctype != GribCollectionImmutable.Type.TP) {
            this.makeDatasetBest(ds2D, false);
        }
        return this.writeIndex(this.result, errlog);
    }

    private GribCollectionMutable.Dataset makeDataset2D(Formatter f) throws IOException {
        FeatureCollectionConfig config = (FeatureCollectionConfig)this.partitionManager.getAuxInfo("fcConfig");
        FeatureCollectionConfig.GribIntvFilter intvMap = config != null ? config.gribConfig.intvFilter : null;
        GribCollectionMutable.Dataset ds2D = this.result.makeDataset(GribCollectionImmutable.Type.TwoD);
        int npart = this.result.getPartitionSize();
        ArrayList<CoordinateRuntime> masterRuntimes = new ArrayList<CoordinateRuntime>();
        HashMap<Object, GroupPartitions> groupMap = new HashMap<Object, GroupPartitions>(40);
        CoordinateRuntime.Builder2 runtimeAllBuilder = new CoordinateRuntime.Builder2(null);
        int countPartition = 0;
        boolean allAre1D = true;
        for (PartitionCollectionMutable.Partition tpp : this.result.getPartitions()) {
            try (GribCollectionMutable gc = tpp.makeGribCollection();){
                CoordinateRuntime partRuntime = gc.masterRuntime;
                runtimeAllBuilder.addAll(partRuntime);
                masterRuntimes.add(partRuntime);
                GribCollectionMutable.Dataset dataset = gc.getDatasetCanonical();
                if (dataset.gctype == GribCollectionImmutable.Type.SRC) {
                    for (GribCollectionMutable.GroupGC groupGC : dataset.getGroups()) {
                        for (Coordinate coord : groupGC.getCoordinates()) {
                            if (coord instanceof CoordinateTime2D) {
                                CoordinateTime2D coord2D = (CoordinateTime2D)coord;
                                if (coord2D.getNtimes() <= 1) continue;
                                allAre1D = false;
                                continue;
                            }
                            if (!(coord instanceof CoordinateTimeAbstract) || coord.getSize() <= 1) continue;
                            allAre1D = false;
                        }
                    }
                } else if (dataset.gctype != GribCollectionImmutable.Type.MRSTC && dataset.gctype != GribCollectionImmutable.Type.TP) {
                    allAre1D = false;
                }
                int groupIdx = 0;
                for (GribCollectionMutable.GroupGC g2 : dataset.groups) {
                    GroupPartitions gs = (GroupPartitions)groupMap.get(g2.getGdsHash());
                    if (gs == null) {
                        gs = new GroupPartitions(ds2D.addGroupCopy(g2), npart);
                        groupMap.put(g2.getGdsHash(), gs);
                    }
                    gs.componentGroups[countPartition] = g2;
                    gs.componentGroupIndex[countPartition] = groupIdx++;
                }
            }
            ++countPartition;
        }
        ArrayList groupPartitions = new ArrayList(groupMap.values());
        this.result.masterRuntime = (CoordinateRuntime)runtimeAllBuilder.finish();
        if (this.result.isPartitionOfPartitions) {
            CoordinateTimeAbstract.cdf = new CalendarDateFactory(this.result.masterRuntime);
        }
        if (allAre1D) {
            ds2D.gctype = GribCollectionImmutable.Type.TP;
        }
        this.result.run2part = new int[this.result.masterRuntime.getSize()];
        int partIdx = 0;
        for (CoordinateRuntime partRuntime : masterRuntimes) {
            for (Object e : partRuntime.getValues()) {
                int idx = this.result.masterRuntime.getIndex(e);
                this.result.run2part[idx] = partIdx;
            }
            ++partIdx;
        }
        for (GroupPartitions gp : groupPartitions) {
            int n;
            GribCollectionMutable.GroupGC resultGroup = gp.resultGroup;
            gp.makeVariableIndexPartitioned();
            String string = resultGroup.getId();
            String gdesc = resultGroup.getDescription();
            boolean bl = false;
            while (n < npart) {
                GribCollectionMutable.GroupGC group = gp.componentGroups[n];
                if (group == null) {
                    f.format(" INFO canonical group %s not in partition %s%n", string, this.result.getPartition(n).getName());
                } else {
                    int groupIdx = gp.componentGroupIndex[n];
                    for (int varIdx = 0; varIdx < group.variList.size(); ++varIdx) {
                        GribCollectionMutable.VariableIndex vi = group.variList.get(varIdx);
                        PartitionCollectionMutable.VariableIndexPartitioned vip = (PartitionCollectionMutable.VariableIndexPartitioned)resultGroup.findVariableByHash(vi);
                        vip.addPartition(n, groupIdx, varIdx, vi.ndups, vi.nrecords, vi.nmissing, vi);
                    }
                }
                ++n;
            }
            n = 0;
            CoordinateSharer sharify = new CoordinateSharer(n != 0);
            for (GribCollectionMutable.VariableIndex viResult : resultGroup.variList) {
                PartitionCollectionMutable.VariableIndexPartitioned vip = (PartitionCollectionMutable.VariableIndexPartitioned)viResult;
                vip.finish();
                CoordinateUnionizer unionizer = new CoordinateUnionizer(viResult.getVarid(), intvMap);
                for (int partno = 0; partno < npart; ++partno) {
                    GribCollectionMutable.VariableIndex vi;
                    GribCollectionMutable.GroupGC group = gp.componentGroups[partno];
                    if (group == null || (vi = group.findVariableByHash(viResult)) == null) continue;
                    unionizer.addCoords(vi.getCoordinates());
                }
                viResult.coords = unionizer.finish();
                sharify.addCoords(viResult.coords);
            }
            sharify.finish();
            resultGroup.coords = sharify.getUnionCoords();
            ArrayList<CoordinateTime2D> time2DCoords = new ArrayList<CoordinateTime2D>();
            HashMap<CoordinateRuntime, CoordinateRuntime> runtimes = new HashMap<CoordinateRuntime, CoordinateRuntime>();
            for (Coordinate coord : resultGroup.coords) {
                Coordinate.Type type = coord.getType();
                switch (type) {
                    case runtime: {
                        CoordinateRuntime reftime = (CoordinateRuntime)coord;
                        runtimes.put(reftime, reftime);
                        break;
                    }
                    case time2D: {
                        CoordinateTime2D t2d = (CoordinateTime2D)coord;
                        time2DCoords.add(t2d);
                    }
                }
            }
            for (CoordinateTime2D t2d : time2DCoords) {
                CoordinateRuntime runtime2D = t2d.getRuntimeCoordinate();
                CoordinateRuntime runtime = (CoordinateRuntime)runtimes.get(runtime2D);
                if (runtime != null) continue;
                this.logger.warn("HEY assignRuntimeNames failed on {} group {}", (Object)t2d.getName(), (Object)resultGroup.getId());
            }
            for (GribCollectionMutable.VariableIndex viResult : resultGroup.variList) {
                viResult.coordIndex = sharify.reindex2shared(viResult.coords);
                viResult.coords = null;
            }
        }
        CoordinateTimeAbstract.cdf = null;
        return ds2D;
    }

    private void makeDatasetBest(GribCollectionMutable.Dataset ds2D, boolean isComplete) throws IOException {
        GribCollectionMutable.Dataset dsBest = this.result.makeDataset(isComplete ? GribCollectionImmutable.Type.BestComplete : GribCollectionImmutable.Type.Best);
        int npart = this.result.getPartitionSize();
        for (GribCollectionMutable.GroupGC group2D : ds2D.groups) {
            GribCollectionMutable.GroupGC groupB = dsBest.addGroupCopy(group2D);
            groupB.isTwoD = false;
            HashMap<Coordinate, CoordinateTimeAbstract> map2DtoBest = new HashMap<Coordinate, CoordinateTimeAbstract>();
            CoordinateUniquify sharer = new CoordinateUniquify();
            for (Coordinate coord : group2D.coords) {
                if (coord instanceof CoordinateRuntime) continue;
                if (coord instanceof CoordinateTime2D) {
                    CoordinateTimeAbstract best = ((CoordinateTime2D)coord).makeBestTimeCoordinate(this.result.masterRuntime);
                    if (!isComplete) {
                        best = best.makeBestFromComplete();
                    }
                    sharer.addCoordinate(best);
                    map2DtoBest.put(coord, best);
                    continue;
                }
                sharer.addCoordinate(coord);
            }
            groupB.coords = sharer.finish();
            for (GribCollectionMutable.VariableIndex vi2d : group2D.variList) {
                PartitionCollectionMutable.VariableIndexPartitioned vip = this.result.makeVariableIndexPartitioned(groupB, vi2d, npart);
                vip.finish();
                ArrayList<Coordinate> newCoords = new ArrayList<Coordinate>();
                for (Integer groupIndex : vi2d.coordIndex) {
                    Coordinate coord2D = group2D.coords.get(groupIndex);
                    if (coord2D instanceof CoordinateRuntime) continue;
                    if (coord2D instanceof CoordinateTime2D) {
                        newCoords.add((Coordinate)map2DtoBest.get(coord2D));
                        continue;
                    }
                    newCoords.add(coord2D);
                }
                vip.coordIndex = sharer.reindex(newCoords);
            }
        }
    }

    protected abstract String getMagicStart();

    protected boolean writeIndex(PartitionCollectionMutable pc, Formatter f) throws IOException {
        File idxFile = GribIndexCache.getFileOrCache(this.partitionManager.getIndexFilename());
        if (idxFile.exists()) {
            RandomAccessFile.eject(idxFile.getPath());
            if (!idxFile.delete()) {
                this.logger.error("gc2tp cant delete " + idxFile.getPath());
            }
        }
        this.writer = new GribCollectionWriter();
        try (RandomAccessFile raf = new RandomAccessFile(idxFile.getPath(), "rw");){
            raf.order(0);
            raf.write(this.getMagicStart().getBytes(CDM.utf8Charset));
            raf.writeInt(2);
            raf.writeLong(0L);
            GribCollectionProto.GribCollection.Builder indexBuilder = GribCollectionProto.GribCollection.newBuilder();
            indexBuilder.setName(pc.getName());
            Path topDir = pc.directory.toPath();
            String pathS = StringUtil2.replace(topDir.toString(), '\\', "/");
            indexBuilder.setTopDir(pathS);
            int count = 0;
            for (PartitionCollectionMutable.Partition part : pc.partitions) {
                GribCollectionProto.MFile.Builder b = GribCollectionProto.MFile.newBuilder();
                String pathRS = this.makeReletiveFilename(pc, part);
                b.setFilename(pathRS);
                b.setLastModified(part.getLastModified());
                b.setLength(part.fileSize);
                b.setIndex(count++);
                indexBuilder.addMfiles(b.build());
            }
            indexBuilder.setCenter(pc.center);
            indexBuilder.setSubcenter(pc.subcenter);
            indexBuilder.setMaster(pc.master);
            indexBuilder.setLocal(pc.local);
            indexBuilder.setGenProcessId(pc.genProcessId);
            indexBuilder.setGenProcessType(pc.genProcessType);
            indexBuilder.setBackProcessId(pc.backProcessId);
            indexBuilder.setMasterRuntime(this.writer.writeCoordProto(pc.masterRuntime));
            for (GribHorizCoordSystem hcs : pc.horizCS) {
                indexBuilder.addGds(this.writer.writeGdsProto(hcs));
            }
            for (Object ds : pc.datasets) {
                indexBuilder.addDataset(this.writeDatasetProto(pc, (GribCollectionMutable.Dataset)ds));
            }
            ArrayList<Integer> run2partList = new ArrayList<Integer>();
            if (pc.run2part != null) {
                for (Object part : (Object)pc.run2part) {
                    run2partList.add((int)part);
                }
                indexBuilder.setExtension(PartitionCollectionProto.run2Part, run2partList);
            }
            ArrayList<PartitionCollectionProto.Partition> partProtoList = new ArrayList<PartitionCollectionProto.Partition>();
            for (PartitionCollectionMutable.Partition part : pc.partitions) {
                partProtoList.add(this.writePartitionProto(pc, part));
            }
            indexBuilder.setExtension(PartitionCollectionProto.partitions, partProtoList);
            indexBuilder.setExtension(PartitionCollectionProto.isPartitionOfPartitions, Boolean.valueOf(pc.isPartitionOfPartitions));
            GribCollectionProto.GribCollection index = indexBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt(raf, b.length);
            raf.write(b);
            f.format("Grib2PartitionIndex= %d bytes file size =  %d bytes%n%n", b.length, raf.length());
        }
        return true;
    }

    private String makeReletiveFilename(PartitionCollectionMutable pc, PartitionCollectionMutable.Partition part) {
        Path topDir = pc.directory.toPath();
        Path partPath = new File(part.getDirectory(), part.getFilename()).toPath();
        Path pathRelative = topDir.relativize(partPath);
        return StringUtil2.replace(pathRelative.toString(), '\\', "/");
    }

    private GribCollectionProto.Dataset writeDatasetProto(PartitionCollectionMutable pc, GribCollectionMutable.Dataset ds) throws IOException {
        GribCollectionProto.Dataset.Builder b = GribCollectionProto.Dataset.newBuilder();
        GribCollectionProto.Dataset.Type type = GribCollectionProto.Dataset.Type.valueOf(ds.gctype.toString());
        b.setType(type);
        for (GribCollectionMutable.GroupGC group : ds.groups) {
            b.addGroups(this.writeGroupProto(pc, group));
        }
        return b.build();
    }

    private GribCollectionProto.Group writeGroupProto(PartitionCollectionMutable pc, GribCollectionMutable.GroupGC g2) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        b.setGdsIndex(pc.findHorizCS(g2.horizCoordSys));
        b.setIsTwod(g2.isTwoD);
        for (GribCollectionMutable.VariableIndex vb : g2.variList) {
            b.addVariables(this.writeVariableProto((PartitionCollectionMutable.VariableIndexPartitioned)vb));
        }
        for (Coordinate coord : g2.coords) {
            switch (coord.getType()) {
                case runtime: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateRuntime)coord));
                    break;
                }
                case time: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTime)coord));
                    break;
                }
                case timeIntv: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTimeIntv)coord));
                    break;
                }
                case time2D: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTime2D)coord));
                    break;
                }
                case vert: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateVert)coord));
                    break;
                }
                case ens: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateEns)coord));
                }
            }
        }
        if (g2.filenose != null) {
            Object object = g2.filenose;
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Integer fileno = (int)object[i];
                b.addFileno(fileno);
            }
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(PartitionCollectionMutable.VariableIndexPartitioned vp) throws IOException {
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        b.setDiscipline(vp.discipline);
        b.setPds(ByteString.copyFrom(vp.rawPds));
        b.addIds(vp.center);
        b.addIds(vp.subcenter);
        b.setRecordsPos(vp.recordsPos);
        b.setRecordsLen(vp.recordsLen);
        Iterator iterator = vp.coordIndex.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            b.addCoordIdx(idx);
        }
        b.setNdups(vp.ndups);
        b.setNrecords(vp.nrecords);
        b.setMissing(vp.nmissing);
        if (vp.nparts > 0 && vp.partnoSA != null) {
            ArrayList<PartitionCollectionProto.PartitionVariable> pvarList = new ArrayList<PartitionCollectionProto.PartitionVariable>();
            for (int i = 0; i < vp.nparts; ++i) {
                pvarList.add(this.writePartitionVariableProto(vp.partnoSA.get(i), vp.groupnoSA.get(i), vp.varnoSA.get(i), vp.nrecords, vp.ndups, vp.nmissing));
            }
            b.setExtension(PartitionCollectionProto.partition, pvarList);
        }
        return b.build();
    }

    private PartitionCollectionProto.PartitionVariable writePartitionVariableProto(int partno, int groupno, int varno, int nrecords, int ndups, int nmissing) throws IOException {
        PartitionCollectionProto.PartitionVariable.Builder pb = PartitionCollectionProto.PartitionVariable.newBuilder();
        pb.setPartno(partno);
        pb.setGroupno(groupno);
        pb.setVarno(varno);
        pb.setNdups(ndups);
        pb.setNrecords(nrecords);
        pb.setMissing(nmissing);
        pb.setFlag(0);
        return pb.build();
    }

    private PartitionCollectionProto.Partition writePartitionProto(PartitionCollectionMutable pc, PartitionCollectionMutable.Partition p) throws IOException {
        PartitionCollectionProto.Partition.Builder b = PartitionCollectionProto.Partition.newBuilder();
        String pathRS = this.makeReletiveFilename(pc, p);
        b.setFilename(pathRS);
        b.setName(p.name);
        b.setLastModified(p.lastModified);
        b.setLength(p.fileSize);
        if (p.partitionDate != null) {
            b.setPartitionDate(p.partitionDate.getMillis());
        }
        return b.build();
    }

    protected GribCollectionProto.Parameter writeParamProto(Parameter param) throws IOException {
        GribCollectionProto.Parameter.Builder b = GribCollectionProto.Parameter.newBuilder();
        b.setName(param.getName());
        if (param.isString()) {
            b.setSdata(param.getStringValue());
        } else {
            for (int i = 0; i < param.getLength(); ++i) {
                b.addData(param.getNumericValue(i));
            }
        }
        return b.build();
    }

    private class GroupPartitions {
        GribCollectionMutable.GroupGC resultGroup;
        GribCollectionMutable.GroupGC[] componentGroups;
        int[] componentGroupIndex;
        int npart;

        GroupPartitions(GribCollectionMutable.GroupGC resultGroup, int npart) {
            this.resultGroup = resultGroup;
            this.npart = npart;
            this.componentGroups = new GribCollectionMutable.GroupGC[npart];
            this.componentGroupIndex = new int[npart];
        }

        void makeVariableIndexPartitioned() {
            HashMap<GribCollectionMutable.VariableIndex, GribCollectionMutable.VariableIndex> varMap = new HashMap<GribCollectionMutable.VariableIndex, GribCollectionMutable.VariableIndex>(2 * this.resultGroup.variList.size());
            for (GribCollectionMutable.GroupGC group : this.componentGroups) {
                if (group == null) continue;
                for (GribCollectionMutable.VariableIndex vi : group.variList) {
                    varMap.put(vi, vi);
                }
            }
            for (GribCollectionMutable.VariableIndex vi : varMap.values()) {
                GribPartitionBuilder.this.result.makeVariableIndexPartitioned(this.resultGroup, vi, this.npart);
            }
        }
    }
}

