/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import thredds.filesystem.MFileOS;
import thredds.inventory.MFile;
import ucar.unidata.util.StringUtil2;

public class GcMFile
implements MFile {
    public final File directory;
    public final String name;
    public final long lastModified;
    public final long length;
    public final int index;

    public static List<GcMFile> makeFiles(File directory, List<MFile> files, Set<Integer> allFileSet) {
        ArrayList<GcMFile> result = new ArrayList<GcMFile>(files.size());
        String dirPath = StringUtil2.replace(directory.getPath(), '\\', "/");
        for (int index : allFileSet) {
            String filename;
            MFile file = files.get(index);
            if (file.getPath().startsWith(dirPath)) {
                filename = file.getPath().substring(dirPath.length());
                if (filename.startsWith("/")) {
                    filename = filename.substring(1);
                }
            } else {
                filename = file.getPath();
            }
            result.add(new GcMFile(directory, filename, file.getLastModified(), file.getLength(), index));
        }
        return result;
    }

    public GcMFile(File directory, String name, long lastModified, long length, int index) {
        this.directory = directory;
        this.name = name;
        this.lastModified = lastModified;
        this.index = index;
        this.length = length;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public String getPath() {
        String path = new File(this.directory, this.name).getPath();
        return StringUtil2.replace(path, '\\', "/");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MFile getParent() throws IOException {
        return new MFileOS(this.directory);
    }

    @Override
    public int compareTo(MFile o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public Object getAuxInfo() {
        return null;
    }

    @Override
    public void setAuxInfo(Object info) {
    }

    public File getDirectory() {
        return this.directory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GcMFile");
        sb.append("{directory=").append(this.directory);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", lastModified=").append(new Date(this.lastModified));
        sb.append(", size=").append(this.length);
        sb.append('}');
        return sb.toString();
    }
}

