/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class GIFReader
extends FormatReader {
    private static final int MAX_STACK_SIZE = 4096;
    private boolean gctFlag;
    private int gctSize;
    private int[] gct;
    private int[] lct;
    private int[] act;
    private boolean lctFlag;
    private boolean interlace;
    private int lctSize;
    private int ix;
    private int iy;
    private int iw;
    private int ih;
    private byte[] dBlock = new byte[256];
    private int blockSize = 0;
    private int dispose = 0;
    private int lastDispose = 0;
    private boolean transparency = false;
    private int transIndex;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] pixels;
    private Vector images;
    private Vector colorTables;

    public GIFReader() {
        super("Graphics Interchange Format", "gif");
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[][] table = new byte[3][this.act.length];
        for (int i = 0; i < this.act.length; ++i) {
            table[0][i] = (byte)(this.act[i] >> 16 & 0xFF);
            table[1][i] = (byte)(this.act[i] >> 8 & 0xFF);
            table[2][i] = (byte)(this.act[i] & 0xFF);
        }
        return table;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.act = (int[])this.colorTables.get(no);
        buf = (byte[])this.images.get(no);
        if (no > 0) {
            byte[] prev = (byte[])this.images.get(no - 1);
            for (int i = 0; i < buf.length; ++i) {
                if ((this.act[buf[i] & 0xFF] & 0xFFFFFF) != 0) continue;
                buf[i] = prev[i];
            }
            this.images.setElementAt(buf, no);
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (debug) {
            this.debug("GIFReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.status("Verifying GIF format");
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        this.images = new Vector();
        this.colorTables = new Vector();
        String ident = this.in.readString(6);
        if (!ident.startsWith("GIF")) {
            throw new FormatException("Not a valid GIF file.");
        }
        this.status("Reading dimensions");
        this.core.sizeX[0] = this.in.readShort();
        this.core.sizeY[0] = this.in.readShort();
        int packed = this.in.read() & 0xFF;
        this.gctFlag = (packed & 0x80) != 0;
        this.gctSize = 2 << (packed & 7);
        this.in.skipBytes(1);
        this.in.skipBytes(1);
        if (this.gctFlag) {
            int nbytes = 3 * this.gctSize;
            byte[] c = new byte[nbytes];
            this.in.read(c);
            this.gct = new int[256];
            i = 0;
            int j = 0;
            while (i < this.gctSize) {
                int r = c[j++] & 0xFF;
                int g2 = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                this.gct[i++] = 0xFF000000 | r << 16 | g2 << 8 | b;
            }
        }
        this.status("Reading data blocks");
        boolean done = false;
        block12: while (!done) {
            int code = this.in.read() & 0xFF;
            switch (code) {
                case 44: {
                    this.ix = this.in.readShort();
                    this.iy = this.in.readShort();
                    this.iw = this.in.readShort();
                    this.ih = this.in.readShort();
                    packed = this.in.read();
                    this.lctFlag = (packed & 0x80) != 0;
                    this.interlace = (packed & 0x40) != 0;
                    this.lctSize = 2 << (packed & 7);
                    if (this.lctFlag) {
                        int nbytes = 3 * this.lctSize;
                        byte[] c = new byte[nbytes];
                        int n = 0;
                        try {
                            n = this.in.read(c);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (n < nbytes) {
                            throw new FormatException("Local color table not found");
                        }
                        this.lct = new int[256];
                        int i2 = 0;
                        int j = 0;
                        while (i2 < this.lctSize) {
                            int r = c[j++] & 0xFF;
                            int g3 = c[j++] & 0xFF;
                            int b = c[j++] & 0xFF;
                            this.lct[i2++] = 0xFF000000 | (r << 16) + (g3 << 8) | b;
                        }
                        this.act = this.lct;
                    } else {
                        this.act = this.gct;
                    }
                    int save = 0;
                    if (this.transparency) {
                        save = this.act[this.transIndex];
                        this.act[this.transIndex] = 0;
                    }
                    if (this.act == null) {
                        throw new FormatException("Color table not found.");
                    }
                    this.decodeImageData();
                    int check = 0;
                    do {
                        check = this.readBlock();
                    } while (this.blockSize > 0 && check != -1);
                    this.core.imageCount[0] = this.core.imageCount[0] + 1;
                    if (this.transparency) {
                        this.act[this.transIndex] = save;
                    }
                    this.lastDispose = this.dispose;
                    this.lct = null;
                    break;
                }
                case 33: {
                    int check;
                    code = this.in.read() & 0xFF;
                    switch (code) {
                        case 249: {
                            this.in.skipBytes(1);
                            packed = this.in.read() & 0xFF;
                            this.dispose = (packed & 0x1C) >> 1;
                            this.transparency = (packed & 1) != 0;
                            this.in.skipBytes(2);
                            this.transIndex = this.in.read() & 0xFF;
                            this.in.skipBytes(1);
                            break;
                        }
                        case 255: {
                            if (this.readBlock() == -1) {
                                done = true;
                                break;
                            }
                            String app = new String(this.dBlock, 0, 11);
                            if (app.equals("NETSCAPE2.0")) {
                                do {
                                    check = this.readBlock();
                                    if (this.blockSize <= 0) continue block12;
                                } while (check != -1);
                                break;
                            }
                            do {
                                check = this.readBlock();
                                if (this.blockSize <= 0) continue block12;
                            } while (check != -1);
                            break;
                        }
                        default: {
                            do {
                                check = this.readBlock();
                                if (this.blockSize <= 0) continue block12;
                            } while (check != -1);
                            break;
                        }
                    }
                    continue block12;
                }
                case 59: {
                    done = true;
                }
            }
        }
        this.status("Populating metadata");
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = 3;
        this.core.sizeT[0] = this.core.imageCount[0];
        this.core.currentOrder[0] = "XYCTZ";
        this.core.rgb[0] = true;
        this.core.littleEndian[0] = true;
        this.core.interleaved[0] = true;
        this.core.metadataComplete[0] = true;
        this.core.indexed[0] = true;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        this.core.pixelType[0] = 1;
        FormatTools.populatePixels(store, this);
        for (i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }

    private int readBlock() throws IOException {
        int n;
        if (this.in.getFilePointer() == this.in.length()) {
            return -1;
        }
        this.blockSize = this.in.read() & 0xFF;
        if (this.blockSize > 0) {
            try {
                int count;
                for (n = 0; n < this.blockSize && (count = this.in.read(this.dBlock, n, this.blockSize - n)) != -1; n += count) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    private void decodeImageData() throws IOException {
        int code;
        int nullCode = -1;
        int npix = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < npix) {
            this.pixels = new byte[npix];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int dataSize = this.in.read() & 0xFF;
        int clear = 1 << dataSize;
        int eoi = clear + 1;
        int available = clear + 2;
        int oldCode = nullCode;
        int codeSize = dataSize + 1;
        int codeMask = (1 << codeSize) - 1;
        for (code = 0; code < clear; ++code) {
            this.prefix[code] = 0;
            this.suffix[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < codeSize) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.dBlock[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & codeMask;
                datum >>= codeSize;
                bits -= codeSize;
                if (code > available || code == eoi) break;
                if (code == clear) {
                    codeSize = dataSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    available = clear + 2;
                    oldCode = nullCode;
                    continue;
                }
                if (oldCode == nullCode) {
                    this.pixelStack[top++] = this.suffix[code];
                    oldCode = code;
                    first = code;
                    continue;
                }
                int inCode = code;
                if (code == available) {
                    this.pixelStack[top++] = (byte)first;
                    code = oldCode;
                }
                while (code > clear) {
                    this.pixelStack[top++] = this.suffix[code];
                    code = this.prefix[code];
                }
                first = this.suffix[code] & 0xFF;
                if (available >= 4096) break;
                this.pixelStack[top++] = (byte)first;
                this.prefix[available] = (short)oldCode;
                this.suffix[available] = (byte)first;
                if ((++available & codeMask) == 0 && available < 4096) {
                    ++codeSize;
                    codeMask += available;
                }
                oldCode = inCode;
            }
            this.pixels[pi++] = this.pixelStack[--top];
            ++i;
        }
        for (i = pi; i < npix; ++i) {
            this.pixels[i] = 0;
        }
        this.setPixels();
    }

    private void setPixels() {
        byte[] dest = new byte[this.core.sizeX[0] * this.core.sizeY[0]];
        int lastImage = -1;
        if (this.lastDispose > 0) {
            int n;
            if (this.lastDispose == 3 && (n = this.core.imageCount[0] - 2) > 0) {
                lastImage = n - 1;
            }
            if (lastImage != -1) {
                byte[] prev = (byte[])this.images.get(lastImage);
                System.arraycopy(prev, 0, dest, 0, this.core.sizeX[0] * this.core.sizeY[0]);
            }
        }
        int pass = 1;
        int inc = 8;
        int iline = 0;
        for (int i = 0; i < this.ih; ++i) {
            int line = i;
            if (this.interlace) {
                if (iline >= this.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy) >= this.core.sizeY[0]) continue;
            int k = line * this.core.sizeX[0];
            int dx = k + this.ix;
            int dlim = dx + this.iw;
            if (k + this.core.sizeX[0] < dlim) {
                dlim = k + this.core.sizeX[0];
            }
            int sx = i * this.iw;
            while (dx < dlim) {
                int index = this.pixels[sx++] & 0xFF;
                dest[dx++] = (byte)index;
            }
        }
        this.colorTables.add(this.act);
        this.images.add(dest);
    }
}

