/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import loci.formats.FormatException;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.Codec;

public class LuraWaveCodec
extends BaseCodec
implements Codec {
    public static final String LICENSE_PROPERTY = "lurawave.license";
    public static final String NO_LURAWAVE_MSG = "The LuraWave decoding library, lwf_jsdk2.6.jar, is required to decode this file. Please make sure it is present in your classpath.";
    public static final String NO_LICENSE_MSG = "No LuraWave license code was specified. Please set one in the lurawave.license system property (e.g., with -Dlurawave.license=XXXX from the command line).";
    public static final String INVALID_LICENSE_MSG = "Invalid license code: ";
    protected static boolean noLuraWave;
    protected static String licenseCode;
    protected static ReflectedUniverse r;

    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("LuraWave compression not supported");
    }

    public byte[] decompress(byte[] input, Object options) throws FormatException {
        if (noLuraWave) {
            throw new FormatException(NO_LURAWAVE_MSG);
        }
        licenseCode = System.getProperty(LICENSE_PROPERTY);
        if (licenseCode == null) {
            throw new FormatException(NO_LICENSE_MSG);
        }
        r.setVar("stream", new BufferedInputStream(new ByteArrayInputStream(input), 4096));
        try {
            r.setVar("licenseCode", licenseCode);
            r.exec("lwf = new lwfDecoder(stream, null, licenseCode)");
        }
        catch (ReflectException exc) {
            throw new FormatException(INVALID_LICENSE_MSG + licenseCode, exc);
        }
        int[] image8 = null;
        try {
            int w = (Integer)r.exec("lwf.getWidth()");
            int h2 = (Integer)r.exec("lwf.getHeight()");
            image8 = new int[w * h2];
            r.setVar("image8", image8);
            r.exec("lwf.decodeToMemory(image8, -1, 1024, 0)");
        }
        catch (ReflectException exc) {
            throw new FormatException("Could not decode LuraWave data", exc);
        }
        int len = image8.length;
        byte[] output = new byte[len];
        for (int i = 0; i < len; ++i) {
            byte b0;
            output[i] = b0 = (byte)(image8[i] & 0xFF);
        }
        return output;
    }

    static {
        r = new ReflectedUniverse();
        try {
            r.exec("import com.luratech.lwf.lwfDecoder");
            r.setVar("-1", -1);
            r.setVar("1024", 1024);
            r.setVar("0", 0);
        }
        catch (ReflectException exc) {
            noLuraWave = true;
        }
    }
}

