/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.Codec;

public class Base64Codec
extends BaseCodec
implements Codec {
    private static final int FOURBYTE = 4;
    private static final byte PAD = 61;
    private static byte[] base64Alphabet;
    private static byte[] lookupBase64Alphabet;

    public byte[] compress(byte[] input, int x, int y, int[] dims, Object options) throws FormatException {
        byte k;
        byte l;
        byte b2;
        byte b1;
        int dataBits = input.length * 8;
        int fewerThan24 = dataBits % 24;
        int numTriples = dataBits / 24;
        byte[] encoded = null;
        int encodedLength = 0;
        encodedLength = fewerThan24 != 0 ? (numTriples + 1) * 4 : numTriples * 4;
        encoded = new byte[encodedLength];
        int encodedIndex = 0;
        int dataIndex = 0;
        for (int i = 0; i < numTriples; ++i) {
            dataIndex = i * 3;
            b1 = input[dataIndex];
            b2 = input[dataIndex + 1];
            byte b3 = input[dataIndex + 2];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            byte v1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte v2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte v3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            encoded[encodedIndex] = lookupBase64Alphabet[v1];
            encoded[encodedIndex + 1] = lookupBase64Alphabet[v2 | k << 4];
            encoded[encodedIndex + 2] = lookupBase64Alphabet[l << 2 | v3];
            encoded[encodedIndex + 3] = lookupBase64Alphabet[b3 & 0x3F];
            encodedIndex += 4;
        }
        dataIndex = numTriples * 3;
        if (fewerThan24 == 8) {
            b1 = input[dataIndex];
            k = (byte)(b1 & 3);
            byte v = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            encoded[encodedIndex] = lookupBase64Alphabet[v];
            encoded[encodedIndex + 1] = lookupBase64Alphabet[k << 4];
            encoded[encodedIndex + 2] = 61;
            encoded[encodedIndex + 3] = 61;
        } else if (fewerThan24 == 16) {
            b1 = input[dataIndex];
            b2 = input[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            byte v1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte v2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            encoded[encodedIndex] = lookupBase64Alphabet[v1];
            encoded[encodedIndex + 1] = lookupBase64Alphabet[v2 | k << 4];
            encoded[encodedIndex + 2] = lookupBase64Alphabet[l << 2];
            encoded[encodedIndex + 3] = 61;
        }
        return encoded;
    }

    public byte[] decompress(byte[] base64Data, Object options) throws FormatException {
        if (base64Data.length == 0) {
            return new byte[0];
        }
        int numberQuadruple = base64Data.length / 4;
        byte[] decodedData = null;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        byte b4 = 0;
        byte marker0 = 0;
        byte marker1 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        int lastData = base64Data.length;
        while (base64Data[lastData - 1] == 61) {
            if (--lastData != 0) continue;
            return new byte[0];
        }
        decodedData = new byte[lastData - numberQuadruple];
        for (int i = 0; i < numberQuadruple; ++i) {
            dataIndex = i * 4;
            marker0 = base64Data[dataIndex + 2];
            marker1 = base64Data[dataIndex + 3];
            b1 = base64Alphabet[base64Data[dataIndex]];
            b2 = base64Alphabet[base64Data[dataIndex + 1]];
            if (marker0 != 61 && marker1 != 61) {
                b3 = base64Alphabet[marker0];
                b4 = base64Alphabet[marker1];
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                decodedData[encodedIndex + 2] = (byte)(b3 << 6 | b4);
            } else if (marker0 == 61) {
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
            } else if (marker1 == 61) {
                b3 = base64Alphabet[marker0];
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
            }
            encodedIndex += 3;
        }
        return decodedData;
    }

    public byte[] base64Decode(String s2) throws FormatException {
        byte[] base64Data = s2.getBytes();
        return this.decompress(base64Data);
    }

    public static void main(String[] args) throws FormatException {
        Base64Codec c = new Base64Codec();
        c.test();
    }

    static {
        int i;
        base64Alphabet = new byte[255];
        lookupBase64Alphabet = new byte[255];
        for (i = 0; i < 255; ++i) {
            Base64Codec.base64Alphabet[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            Base64Codec.base64Alphabet[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            Base64Codec.base64Alphabet[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            Base64Codec.base64Alphabet[i] = (byte)(i - 48 + 52);
        }
        Base64Codec.base64Alphabet[43] = 62;
        Base64Codec.base64Alphabet[47] = 63;
        for (i = 0; i <= 25; ++i) {
            Base64Codec.lookupBase64Alphabet[i] = (byte)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 51) {
            Base64Codec.lookupBase64Alphabet[i] = (byte)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i <= 61) {
            Base64Codec.lookupBase64Alphabet[i] = (byte)(48 + j);
            ++i;
            ++j;
        }
        Base64Codec.lookupBase64Alphabet[62] = 43;
        Base64Codec.lookupBase64Alphabet[63] = 47;
    }
}

