/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.adde.AddeSatBands;
import edu.wisc.ssec.mcidas.adde.AddeServerInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GetAreaGUI
extends JPanel {
    AddeServerInfo asi;
    String[] sl;
    String selectedServer;
    String selectedGroup;
    String selectedDescr;
    String selectedDateTime;
    String coordType;
    String actionButtonString;
    String userName;
    String projectNumber;
    boolean serverUpdated;
    boolean groupUpdated;
    boolean descrUpdated;
    boolean multipleImages;
    ActionListener al = null;
    int baseNumLines;
    int baseNumEles;
    double resLat;
    double resLon;
    int[] bandListIndex;
    String[] bandList;
    String selectedBand;
    String selectedUnit;
    int selectedBandIndex;
    String[][][] calInfo = null;
    boolean doingRes;
    NumberFormat nf3;
    Properties dataProp;
    StringBuffer serverList;
    AreaDirectory[][] ad;
    int areaIndex;
    String[] bandNames;
    AddeSatBands asb;
    boolean closeOnAction = true;
    boolean useDefaults = false;
    boolean gotUserDefaults = false;
    String propFile;
    String cmdout = null;
    ArrayList imageList = null;
    JDialog dialog;
    private JPanel PanelSGD;
    private JPanel PanelSG;
    private JPanel PanelServer;
    private JLabel ServerLabel;
    private JComboBox ServerSelector;
    private JPanel PanelGroup;
    private JLabel jLabel2;
    private JComboBox GroupSelector;
    private JPanel PanelDescr;
    private JLabel jLabel3;
    private JComboBox DescrSelector;
    private JPanel PanelListMag;
    private JPanel PanelMag;
    private JPanel jPanel13;
    private JPanel jPanel9;
    private JSlider LMagSlider;
    private JLabel LMagLabel;
    private JPanel jPanel10;
    private JLabel EMagLabel;
    private JSlider EMagSlider;
    private JLabel DateTimeLabel;
    private JPanel PanelList;
    private JScrollPane DateTimeScrollPanel;
    private JList DateTimeList;
    private JPanel LinesElesPanel;
    private JLabel SizeLabel;
    private JPanel jPanel7;
    private JLabel NumLinesLabel;
    private JTextField NumLinesText;
    private JLabel NumElesLabel;
    private JTextField NumElesText;
    private JCheckBox userDefaultsCheckBox;
    private JPanel PanelBandUnit;
    private JPanel BandPanel;
    private JLabel BandLabel;
    private JComboBox BandBox;
    private JPanel UnitsPanel;
    private JLabel UnitLabel;
    private JComboBox UnitBox;
    private JPanel UserActionPanel;
    private JButton userActionButton;
    private JPanel PanelStatus;
    private JTextField statusLabel;
    private JPanel PanelLoc;
    private JPanel jPanel11;
    private JLabel PlaceLabel;
    private JRadioButton LatLonButton;
    private JRadioButton LinEleButton;
    private JRadioButton IDButton;
    private JPanel jPanel12;
    private JLabel LatLineLabel;
    private JLabel LonEleLabel;
    private JTextField LatLineText;
    private JTextField LonEleText;
    private ButtonGroup buttGroupLoc;
    private int LMagValue;
    private int EMagValue;
    private String calText = null;

    public GetAreaGUI(String s2) {
        this(null, false, s2, false, true, true);
    }

    public GetAreaGUI(String s2, boolean multi) {
        this(null, false, s2, multi, true, true);
    }

    public GetAreaGUI(String s2, boolean multi, boolean coa) {
        this(null, false, s2, multi, coa, true);
    }

    public GetAreaGUI(String s2, boolean multi, boolean coa, boolean modal) {
        this(null, modal, s2, multi, coa, true);
    }

    public GetAreaGUI(Frame owner, boolean modal, String s2, boolean multi, boolean coa) {
        this(owner, modal, s2, multi, coa, true);
    }

    public GetAreaGUI(Frame owner, boolean modal, String s2, boolean multi, boolean coa, boolean dodialog) {
        this.setupGUI(s2, multi, coa, owner, modal, dodialog);
    }

    private void setupGUI(String s2, boolean multi, boolean coa, Frame parent, boolean modal, boolean dod) {
        int i;
        this.serverUpdated = false;
        this.groupUpdated = false;
        this.descrUpdated = false;
        this.bandNames = null;
        this.closeOnAction = coa;
        this.selectedUnit = " ";
        this.selectedBand = " ";
        this.selectedBandIndex = -1;
        this.doingRes = false;
        this.asb = null;
        this.multipleImages = multi;
        this.nf3 = NumberFormat.getNumberInstance();
        this.nf3.setMaximumFractionDigits(3);
        this.actionButtonString = s2;
        this.asi = new AddeServerInfo();
        String[] sla = this.asi.getServerList();
        this.dataProp = new Properties();
        try {
            String path = System.getProperty("user.home");
            this.propFile = path + System.getProperty("file.separator") + "GetAreaGUI.properties";
            FileInputStream fi = new FileInputStream(this.propFile);
            this.dataProp.load(fi);
            fi.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        String usl = (String)this.dataProp.get("user|server|list");
        this.serverList = new StringBuffer();
        ArrayList<String> als = new ArrayList<String>();
        for (i = 0; i < sla.length; ++i) {
            als.add(sla[i]);
        }
        if (usl != null) {
            this.serverList.append(usl);
            StringTokenizer slt = new StringTokenizer(usl, ",");
            int n = slt.countTokens();
            for (int i2 = 0; i2 < n; ++i2) {
                als.add(slt.nextToken());
            }
        }
        this.sl = new String[als.size()];
        for (i = 0; i < als.size(); ++i) {
            this.sl[i] = (String)als.get(i);
        }
        this.selectedServer = null;
        this.selectedGroup = null;
        this.selectedDescr = null;
        this.selectedDateTime = null;
        this.baseNumLines = -1;
        this.baseNumEles = -1;
        this.initComponents();
        this.buttGroupLoc = new ButtonGroup();
        this.buttGroupLoc.add(this.LatLonButton);
        this.buttGroupLoc.add(this.LinEleButton);
        this.buttGroupLoc.add(this.IDButton);
        this.dialog = null;
        if (dod) {
            this.dialog = new JDialog(parent, "ADDE Image Data Selector", modal);
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
        }
    }

    public void show() {
        if (this.dialog != null) {
            this.dialog.show();
        }
    }

    public void setServer(String s2) {
        this.selectedServer = s2;
    }

    public String getServer() {
        return this.selectedServer;
    }

    public void setGroup(String s2) {
        this.selectedGroup = s2;
    }

    public String getGroup() {
        return this.selectedGroup;
    }

    public void setDescr(String s2) {
        this.selectedDescr = s2;
    }

    public String getDescr() {
        return this.selectedDescr;
    }

    public void setMag(String m3) {
        if (m3 != null) {
            StringTokenizer st = new StringTokenizer(m3, " ");
            int lm = Integer.parseInt(st.nextToken().trim());
            int em = Integer.parseInt(st.nextToken().trim());
            this.setLineMag(lm);
            this.setEleMag(em);
        } else {
            this.setLineMag(1);
            this.setEleMag(1);
        }
    }

    public String getMag() {
        return this.LMagValue + " " + this.EMagValue;
    }

    public void setLineMag(int m3) {
        this.LMagValue = m3;
        if (this.LMagValue > -2 && this.LMagValue < 2) {
            this.LMagValue = 1;
        }
        this.LMagSlider.setValue(this.LMagValue + 50);
        if (this.doingRes) {
            double v = this.resLat / (double)this.LMagValue;
            if (this.LMagValue < 0) {
                v = -(this.resLat * (double)this.LMagValue);
            }
            this.LMagLabel.setText("Line Resolution = " + this.nf3.format(v));
        } else {
            this.LMagLabel.setText("Line Magnification = " + this.LMagValue);
        }
    }

    public int getLinMag() {
        return this.LMagValue;
    }

    public void setEleMag(int m3) {
        this.EMagValue = m3;
        if (this.EMagValue > -2 && this.EMagValue < 2) {
            this.EMagValue = 1;
        }
        this.EMagSlider.setValue(this.EMagValue + 50);
        if (this.doingRes) {
            double v = this.resLon / (double)this.EMagValue;
            if (this.EMagValue < 0) {
                v = -(this.resLon * (double)this.EMagValue);
            }
            this.EMagLabel.setText("Element Resolution = " + this.nf3.format(v));
        } else {
            this.EMagLabel.setText("Element Magnification = " + this.EMagValue);
        }
    }

    public int getEleMag() {
        return this.EMagValue;
    }

    public void setCoordType(String c) {
        this.LatLonButton.setSelected(false);
        this.LinEleButton.setSelected(false);
        this.IDButton.setSelected(false);
        if (c.equalsIgnoreCase("E")) {
            this.LatLonButton.setSelected(true);
        }
        if (c.equalsIgnoreCase("I")) {
            this.LinEleButton.setSelected(true);
        }
        if (c.equalsIgnoreCase("S")) {
            this.IDButton.setSelected(true);
        }
        this.setLocButtonLabel();
    }

    public String getCoordType() {
        return this.coordType;
    }

    public void setLocationString(String c) {
        String locOne = " ";
        String locTwo = " ";
        if (c != null) {
            StringTokenizer st = new StringTokenizer(c, " ");
            locOne = st.nextToken();
            if (st.hasMoreTokens()) {
                locTwo = st.nextToken();
            }
        }
        this.LatLineText.setText(locOne);
        this.LonEleText.setText(locTwo);
    }

    public String getLocationString() {
        String loc = this.LatLineText.getText() + " " + this.LonEleText.getText();
        return loc;
    }

    public void setBand(String c) {
    }

    public String getBand() {
        return this.selectedBand;
    }

    public void setNumLinesEles(String c) {
        if (c == null || c.trim().length() < 3) {
            this.NumLinesText.setText(" ");
            this.NumElesText.setText(" ");
            this.baseNumLines = -1;
            this.baseNumEles = -1;
            return;
        }
        StringTokenizer st = new StringTokenizer(c, " ");
        String lin = st.nextToken();
        String ele = st.nextToken();
        this.NumLinesText.setText(lin);
        this.NumElesText.setText(ele);
        this.baseNumLines = Integer.parseInt(lin.trim());
        this.baseNumEles = Integer.parseInt(ele.trim());
    }

    public String getNumLinesEles() {
        String s2 = this.NumLinesText.getText() + " " + this.NumElesText.getText();
        return s2;
    }

    public String getDay(int index) {
        int i;
        Object[] vals = this.DateTimeList.getSelectedValues();
        this.selectedDateTime = (String)vals[index];
        String day = null;
        if (this.selectedDateTime != null && (i = this.selectedDateTime.indexOf("/")) > 0) {
            day = this.selectedDateTime.substring(0, i).trim();
        }
        return day;
    }

    public String getDay() {
        int i;
        this.selectedDateTime = (String)this.DateTimeList.getSelectedValue();
        String day = null;
        if (this.selectedDateTime != null && (i = this.selectedDateTime.indexOf("/")) > 0) {
            day = this.selectedDateTime.substring(0, i).trim();
        }
        return day;
    }

    public void setDay(String d) {
        this.setDateTime(d, this.getTime());
    }

    public String getTime(int index) {
        int i;
        Object[] vals = this.DateTimeList.getSelectedValues();
        this.selectedDateTime = (String)vals[index];
        String time = null;
        if (this.selectedDateTime != null && (i = this.selectedDateTime.indexOf("/")) > 0) {
            time = this.selectedDateTime.substring(i + 1).trim();
        }
        return time;
    }

    public String getTime() {
        int i;
        this.selectedDateTime = (String)this.DateTimeList.getSelectedValue();
        String time = null;
        if (this.selectedDateTime != null && (i = this.selectedDateTime.indexOf("/")) > 0) {
            time = this.selectedDateTime.substring(i + 1).trim();
        }
        return time;
    }

    public void setTime(String t) {
        this.setDateTime(this.getDay(), t);
    }

    public void setDateTime(String d, String t) {
        this.selectedDateTime = d + " / " + t;
    }

    public void setUnit(String c) {
    }

    public String getUnit() {
        return this.selectedUnit;
    }

    public void setCal(String c) {
        this.calText = c;
    }

    public String getCal() {
        return this.calText;
    }

    public void setDoc(String v) {
        if (v == null || v.indexOf("1") > -1) {
            // empty if block
        }
    }

    public String getDoc() {
        return "1";
    }

    public void setUserName(String c) {
        this.userName = c;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setProjectNumber(String c) {
        this.projectNumber = c;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    private void initComponents() {
        this.PanelSGD = new JPanel();
        this.PanelSG = new JPanel();
        this.PanelServer = new JPanel();
        this.ServerLabel = new JLabel();
        this.ServerSelector = new JComboBox();
        this.PanelGroup = new JPanel();
        this.jLabel2 = new JLabel();
        this.GroupSelector = new JComboBox();
        this.PanelDescr = new JPanel();
        this.jLabel3 = new JLabel();
        this.DescrSelector = new JComboBox();
        this.PanelListMag = new JPanel();
        this.PanelMag = new JPanel();
        this.jPanel13 = new JPanel();
        this.jPanel9 = new JPanel();
        this.LMagSlider = new JSlider();
        this.LMagLabel = new JLabel();
        this.jPanel10 = new JPanel();
        this.EMagLabel = new JLabel();
        this.EMagSlider = new JSlider();
        this.DateTimeLabel = new JLabel();
        this.PanelList = new JPanel();
        this.DateTimeScrollPanel = new JScrollPane();
        String[] prompt = new String[]{"Date-times of available", "images will appear here"};
        this.DateTimeList = new JList<String>(prompt);
        this.LinesElesPanel = new JPanel();
        this.SizeLabel = new JLabel();
        this.jPanel7 = new JPanel();
        this.NumLinesLabel = new JLabel();
        this.NumLinesText = new JTextField();
        this.NumElesLabel = new JLabel();
        this.NumElesText = new JTextField();
        this.userDefaultsCheckBox = new JCheckBox();
        this.PanelBandUnit = new JPanel();
        this.BandPanel = new JPanel();
        this.BandLabel = new JLabel();
        this.BandBox = new JComboBox();
        this.UnitsPanel = new JPanel();
        this.UnitLabel = new JLabel();
        this.UnitBox = new JComboBox();
        this.UserActionPanel = new JPanel();
        this.userActionButton = new JButton();
        this.PanelStatus = new JPanel();
        this.statusLabel = new JTextField();
        this.PanelLoc = new JPanel();
        this.jPanel11 = new JPanel();
        this.PlaceLabel = new JLabel();
        this.LatLonButton = new JRadioButton();
        this.LinEleButton = new JRadioButton();
        this.IDButton = new JRadioButton();
        this.jPanel12 = new JPanel();
        this.LatLineLabel = new JLabel();
        this.LonEleLabel = new JLabel();
        this.LatLineText = new JTextField();
        this.LonEleText = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setFont(new Font("SansSerif", 0, 10));
        this.PanelSGD.setLayout(new BorderLayout());
        this.PanelSGD.setMaximumSize(new Dimension(500, 160));
        this.PanelServer.setLayout(new GridLayout(2, 1));
        this.PanelServer.setBorder(new BevelBorder(0));
        this.PanelServer.setPreferredSize(new Dimension(180, 45));
        this.ServerLabel.setText("Server");
        this.ServerLabel.setToolTipText("Select an ADDE Server from the list");
        this.ServerLabel.setHorizontalAlignment(0);
        this.PanelServer.add(this.ServerLabel);
        this.ServerSelector.setToolTipText("Select an ADDE Server from the list");
        this.ServerSelector.setBackground(Color.lightGray);
        this.ServerSelector.setEditable(true);
        this.ServerSelector.setActionCommand("serverSelected");
        this.replaceList(this.ServerSelector, this.sl, "Select ADDE server");
        this.ServerSelector.setSelectedIndex(0);
        this.ServerSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetAreaGUI.this.ServerSelectorActionPerformed(evt);
            }
        });
        this.PanelServer.add(this.ServerSelector);
        this.PanelSG.add(this.PanelServer);
        this.PanelGroup.setLayout(new GridLayout(2, 1));
        this.PanelGroup.setBorder(new BevelBorder(0));
        this.PanelGroup.setPreferredSize(new Dimension(160, 45));
        this.jLabel2.setText("Dataset");
        this.jLabel2.setToolTipText("Select a dataset from the list");
        this.jLabel2.setHorizontalAlignment(0);
        this.PanelGroup.add(this.jLabel2);
        this.GroupSelector.setToolTipText("Select an ADDE data group from the list");
        this.GroupSelector.setBackground(Color.lightGray);
        this.GroupSelector.setActionCommand("groupSelected");
        this.GroupSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetAreaGUI.this.GroupSelectorActionPerformed(evt);
            }
        });
        this.PanelGroup.add(this.GroupSelector);
        this.PanelSG.add(this.PanelGroup);
        this.PanelSGD.add((Component)this.PanelSG, "North");
        this.PanelDescr.setLayout(new BorderLayout());
        this.PanelDescr.setBorder(new BevelBorder(0));
        this.PanelDescr.setMaximumSize(new Dimension(400, 50));
        this.jLabel3.setText("Data Type");
        this.jLabel3.setToolTipText("Select a Data Type; available dates and times will appear below");
        this.jLabel3.setHorizontalAlignment(0);
        this.PanelDescr.add((Component)this.jLabel3, "North");
        this.DescrSelector.setToolTipText("Select an ADDE dataset; available dates and times will appear below");
        this.DescrSelector.setBackground(Color.lightGray);
        this.DescrSelector.setName("descrType");
        this.DescrSelector.setActionCommand("descrSelected");
        this.DescrSelector.setMaximumSize(new Dimension(500, 20));
        this.DescrSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetAreaGUI.this.DescrSelectorActionPerformed(evt);
            }
        });
        this.PanelDescr.add((Component)this.DescrSelector, "South");
        this.PanelSGD.add((Component)this.PanelDescr, "South");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.PanelSGD, gridBagConstraints1);
        this.PanelListMag.setLayout(new GridBagLayout());
        this.PanelListMag.setMinimumSize(new Dimension(400, 150));
        this.PanelMag.setLayout(new BorderLayout(10, 5));
        this.jPanel13.setLayout(new BorderLayout(10, 0));
        this.jPanel13.setBorder(new BevelBorder(0));
        this.jPanel9.setLayout(new BorderLayout());
        this.LMagSlider.setToolTipText("Slide to set line magnification factor");
        this.LMagSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GetAreaGUI.this.LMagSliderStateChanged(evt);
            }
        });
        this.jPanel9.add((Component)this.LMagSlider, "South");
        this.LMagLabel.setText("Line Magnification");
        this.LMagLabel.setHorizontalAlignment(0);
        this.jPanel9.add((Component)this.LMagLabel, "North");
        this.jPanel13.add((Component)this.jPanel9, "North");
        this.jPanel10.setLayout(new BorderLayout());
        this.EMagLabel.setText("Element Magnification");
        this.EMagLabel.setHorizontalAlignment(0);
        this.jPanel10.add((Component)this.EMagLabel, "North");
        this.EMagSlider.setToolTipText("Slide to select element magnification factor");
        this.EMagSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GetAreaGUI.this.EMagSliderStateChanged(evt);
            }
        });
        this.jPanel10.add((Component)this.EMagSlider, "South");
        this.jPanel13.add((Component)this.jPanel10, "South");
        this.PanelMag.add((Component)this.jPanel13, "North");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 3;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 11;
        this.PanelListMag.add((Component)this.PanelMag, gridBagConstraints2);
        this.DateTimeLabel.setText("List of available Date / Times");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 15;
        this.PanelListMag.add((Component)this.DateTimeLabel, gridBagConstraints2);
        this.PanelList.setLayout(new BorderLayout(0, 10));
        this.PanelList.setPreferredSize(new Dimension(180, 150));
        this.PanelList.setMinimumSize(new Dimension(180, 150));
        this.DateTimeScrollPanel.setPreferredSize(new Dimension(180, 150));
        this.DateTimeScrollPanel.setMinimumSize(new Dimension(180, 150));
        this.DateTimeList.setToolTipText("Click on the date-time you want");
        this.DateTimeList.setBorder(new BevelBorder(0));
        this.DateTimeList.setName("");
        this.DateTimeList.setVisibleRowCount(10);
        if (this.multipleImages) {
            this.DateTimeList.setSelectionMode(2);
        } else {
            this.DateTimeList.setSelectionMode(0);
        }
        this.DateTimeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                GetAreaGUI.this.DateTimeListValueChanged(evt);
            }
        });
        this.DateTimeScrollPanel.setViewportView(this.DateTimeList);
        this.PanelList.add((Component)this.DateTimeScrollPanel, "Center");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridheight = 4;
        gridBagConstraints2.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints2.anchor = 11;
        this.PanelListMag.add((Component)this.PanelList, gridBagConstraints2);
        this.LinesElesPanel.setLayout(new BorderLayout());
        this.LinesElesPanel.setBorder(new BevelBorder(0));
        this.SizeLabel.setText("Size of Image to Get");
        this.SizeLabel.setToolTipText("Enter the number of lines and elements for the image you want (def=480 x 640)");
        this.SizeLabel.setHorizontalAlignment(0);
        this.LinesElesPanel.add((Component)this.SizeLabel, "North");
        this.jPanel7.setLayout(new FlowLayout(1, 5, 0));
        this.NumLinesLabel.setText("Lines:");
        this.NumLinesLabel.setToolTipText("Enter the number of image lines you want");
        this.jPanel7.add(this.NumLinesLabel);
        this.NumLinesText.setToolTipText("Enter number of lines (def=480)");
        this.NumLinesText.setColumns(5);
        this.NumLinesText.setText(" ");
        this.jPanel7.add(this.NumLinesText);
        this.NumElesLabel.setText("       Elements:");
        this.NumElesLabel.setToolTipText("Enter the number of image Elements you want");
        this.jPanel7.add(this.NumElesLabel);
        this.NumElesText.setToolTipText("Enter number of elements (def=640)");
        this.NumElesText.setColumns(5);
        this.NumElesText.setText(" ");
        this.jPanel7.add(this.NumElesText);
        this.LinesElesPanel.add((Component)this.jPanel7, "South");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(2, 0, 2, 0);
        this.PanelListMag.add((Component)this.LinesElesPanel, gridBagConstraints2);
        this.userDefaultsCheckBox.setToolTipText("Check this box to use your defaults for size and location");
        this.userDefaultsCheckBox.setSelected(false);
        this.userDefaultsCheckBox.setText("Use my defaults");
        this.userDefaultsCheckBox.setAlignmentX(0.5f);
        this.userDefaultsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetAreaGUI.this.userDefaultsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.anchor = 11;
        this.PanelListMag.add((Component)this.userDefaultsCheckBox, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.PanelListMag, gridBagConstraints1);
        this.PanelBandUnit.setLayout(new GridBagLayout());
        this.PanelBandUnit.setPreferredSize(new Dimension(500, 75));
        this.PanelBandUnit.setMinimumSize(new Dimension(300, 75));
        this.BandPanel.setLayout(new BorderLayout());
        this.BandPanel.setBorder(new SoftBevelBorder(0));
        this.BandLabel.setText("Channel");
        this.BandLabel.setToolTipText("Select channel from list");
        this.BandLabel.setHorizontalAlignment(0);
        this.BandLabel.setAlignmentX(0.5f);
        this.BandPanel.add((Component)this.BandLabel, "North");
        this.BandBox.setToolTipText("Select a band/channel number from the list or enter one");
        this.BandBox.setActionCommand("bandBoxChanged");
        this.BandBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetAreaGUI.this.BandBoxActionPerformed(evt);
            }
        });
        this.BandPanel.add((Component)this.BandBox, "West");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = -1;
        gridBagConstraints3.ipady = 5;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 5);
        this.PanelBandUnit.add((Component)this.BandPanel, gridBagConstraints3);
        this.UnitsPanel.setLayout(new BorderLayout());
        this.UnitsPanel.setBorder(new SoftBevelBorder(0));
        this.UnitLabel.setText("Unit");
        this.UnitLabel.setToolTipText("Select unit from list after selecting Band");
        this.UnitLabel.setHorizontalAlignment(0);
        this.UnitsPanel.add((Component)this.UnitLabel, "North");
        this.UnitBox.setToolTipText("Select a unit from the list or enter a units code");
        this.UnitBox.setActionCommand("unitBoxChanged");
        this.UnitBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetAreaGUI.this.UnitBoxActionPerformed(evt);
            }
        });
        this.UnitsPanel.add((Component)this.UnitBox, "West");
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = -1;
        gridBagConstraints3.ipadx = 2;
        gridBagConstraints3.ipady = 5;
        gridBagConstraints3.insets = new Insets(0, 4, 0, 4);
        this.PanelBandUnit.add((Component)this.UnitsPanel, gridBagConstraints3);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        this.add((Component)this.PanelBandUnit, gridBagConstraints1);
        this.userActionButton.setToolTipText("Click button to " + this.actionButtonString);
        this.userActionButton.setText(this.actionButtonString);
        this.userActionButton.setActionCommand("user_action");
        this.userActionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetAreaGUI.this.userActionButtonActionPerformed(evt);
            }
        });
        this.UserActionPanel.add(this.userActionButton);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        this.add((Component)this.UserActionPanel, gridBagConstraints1);
        this.statusLabel.setEditable(false);
        this.statusLabel.setColumns(40);
        this.statusLabel.setForeground(Color.white);
        this.statusLabel.setText("First pick an ADDE server");
        this.statusLabel.setBackground(Color.black);
        this.statusLabel.setPreferredSize(new Dimension(440, 20));
        this.statusLabel.setMinimumSize(new Dimension(100, 20));
        this.statusLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetAreaGUI.this.statusLabelActionPerformed(evt);
            }
        });
        this.PanelStatus.add(this.statusLabel);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 7;
        this.add((Component)this.PanelStatus, gridBagConstraints1);
        this.PanelLoc.setLayout(new BorderLayout());
        this.PanelLoc.setBorder(new BevelBorder(0));
        this.jPanel11.setLayout(new FlowLayout(1, 5, 0));
        this.PlaceLabel.setText("Location:");
        this.jPanel11.add(this.PlaceLabel);
        this.LatLonButton.setToolTipText("Click to select lat/lon coordinates");
        this.LatLonButton.setSelected(true);
        this.LatLonButton.setLabel("Lat/Lon");
        this.LatLonButton.setActionCommand("LatLonButt");
        this.LatLonButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GetAreaGUI.this.LatLonButtonStateChanged(evt);
            }
        });
        this.jPanel11.add(this.LatLonButton);
        this.LinEleButton.setToolTipText("Click to select line/element coordinates");
        this.LinEleButton.setLabel("Line/Ele");
        this.LinEleButton.setActionCommand("LineEleButt");
        this.LinEleButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GetAreaGUI.this.LinEleButtonStateChanged(evt);
            }
        });
        this.jPanel11.add(this.LinEleButton);
        this.IDButton.setToolTipText("Click to select a station ID (Note: RADAR DATA ONLY!)");
        this.IDButton.setText("Stn ID");
        this.IDButton.setActionCommand("IDButt");
        this.IDButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GetAreaGUI.this.IDButtonStateChanged(evt);
            }
        });
        this.jPanel11.add(this.IDButton);
        this.PanelLoc.add((Component)this.jPanel11, "North");
        this.jPanel12.setLayout(new GridLayout(2, 2, 5, 0));
        this.LatLineLabel.setText("Latitude");
        this.LatLineLabel.setHorizontalAlignment(0);
        this.jPanel12.add(this.LatLineLabel);
        this.LonEleLabel.setText("Longitude");
        this.LonEleLabel.setHorizontalAlignment(0);
        this.jPanel12.add(this.LonEleLabel);
        this.LatLineText.setToolTipText("Enter latitude or line coordinate or Radar Station ID");
        this.LatLineText.setText("Lat or line or stn ID value");
        this.jPanel12.add(this.LatLineText);
        this.LonEleText.setToolTipText("Enter longitude or element coordinate value");
        this.LonEleText.setText("Long or Element value");
        this.jPanel12.add(this.LonEleText);
        this.PanelLoc.add((Component)this.jPanel12, "South");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        this.add((Component)this.PanelLoc, gridBagConstraints1);
    }

    private void statusLabelActionPerformed(ActionEvent evt) {
    }

    private void userDefaultsCheckBoxActionPerformed(ActionEvent evt) {
        this.useDefaults = this.userDefaultsCheckBox.isSelected();
    }

    private void BandBoxActionPerformed(ActionEvent evt) {
        int i = this.BandBox.getSelectedIndex();
        if (i > 0) {
            this.replaceList(this.UnitBox, this.calInfo[1][i - 1], "Select Unit");
            int bi = this.bandListIndex[i - 1];
            this.selectedBand = this.bandList[i - 1];
            this.selectedBandIndex = i - 1;
            if (!this.useDefaults || !this.gotUserDefaults) {
                double clat = this.ad[this.areaIndex][bi].getCenterLatitude();
                double clon = this.ad[this.areaIndex][bi].getCenterLongitude();
                if (!Double.isNaN(clat) && !Double.isNaN(clon)) {
                    this.setCoordType("E");
                    this.setLocationString(clat + " " + clon);
                }
                this.resLat = this.ad[this.areaIndex][bi].getCenterLatitudeResolution();
                this.resLon = this.ad[this.areaIndex][bi].getCenterLongitudeResolution();
                if (!Double.isNaN(this.resLat) && !Double.isNaN(this.resLon)) {
                    this.doingRes = true;
                }
                this.setLineMag(1);
                this.setEleMag(1);
                int nlines = this.ad[this.areaIndex][bi].getLines();
                int neles = this.ad[this.areaIndex][bi].getElements();
                this.setNumLinesEles(nlines + " " + neles);
                if (this.useDefaults) {
                    this.gotUserDefaults = true;
                }
            }
        }
    }

    private void UnitBoxActionPerformed(ActionEvent evt) {
        int unitIndex = this.UnitBox.getSelectedIndex();
        if (unitIndex > 0 && this.selectedBandIndex >= 0) {
            this.selectedUnit = this.calInfo[0][this.selectedBandIndex][unitIndex - 1];
        }
    }

    private void DateTimeListValueChanged(ListSelectionEvent evt) {
        String[][] ci;
        this.selectedDateTime = (String)this.DateTimeList.getSelectedValue();
        if (this.selectedDateTime == null) {
            return;
        }
        this.areaIndex = this.DateTimeList.getSelectedIndex();
        double clat = this.ad[this.areaIndex][0].getCenterLatitude();
        double clon = this.ad[this.areaIndex][0].getCenterLongitude();
        if (!this.useDefaults || !this.gotUserDefaults) {
            if (!Double.isNaN(clat) && !Double.isNaN(clon)) {
                this.setCoordType("E");
                this.setLocationString(clat + " " + clon);
            }
            this.resLat = this.ad[this.areaIndex][0].getCenterLatitudeResolution();
            this.resLon = this.ad[this.areaIndex][0].getCenterLongitudeResolution();
            if (!Double.isNaN(this.resLat) && !Double.isNaN(this.resLon)) {
                this.doingRes = true;
            }
            this.setLineMag(1);
            this.setEleMag(1);
            int nlines = this.ad[this.areaIndex][0].getLines();
            int neles = this.ad[this.areaIndex][0].getElements();
            this.setNumLinesEles(nlines + " " + neles);
            if (this.useDefaults) {
                this.gotUserDefaults = true;
            }
        }
        ArrayList<String> arrayBandList = new ArrayList<String>();
        ArrayList<Integer> arrayBandIndex = new ArrayList<Integer>();
        ArrayList<String[][]> arrayCalInfo = new ArrayList<String[][]>();
        this.asb = new AddeSatBands(this.asi.getBandNames());
        String[] bandInfo = null;
        for (int na = 0; na < this.ad[this.areaIndex].length; ++na) {
            int nbands = this.ad[this.areaIndex][na].getNumberOfBands();
            int[] bl = this.ad[this.areaIndex][na].getBands();
            String[] sb = new String[nbands];
            Vector[] vb = this.ad[this.areaIndex][na].getCalInfo();
            int sid = this.ad[this.areaIndex][na].getSensorID();
            String srcType = this.ad[this.areaIndex][na].getSourceType();
            bandInfo = this.asb.getBandDescr(sid, srcType);
            for (int k = 0; k < nbands; ++k) {
                int vbnum;
                sb[k] = Integer.toString(bl[k]);
                arrayBandList.add(sb[k]);
                arrayBandIndex.add(new Integer(na));
                ci = new String[2][1];
                ci[0][0] = "RAW";
                ci[1][0] = "Raw values";
                if (vb[k] != null && (vbnum = vb[k].size() / 2) > 0) {
                    ci = new String[2][vbnum];
                    for (int j = 0; j < vbnum; ++j) {
                        ci[0][j] = (String)vb[k].elementAt(2 * j);
                        ci[1][j] = (String)vb[k].elementAt(2 * j + 1);
                    }
                }
                arrayCalInfo.add(ci);
            }
        }
        int ns = arrayBandList.size();
        if (ns != 0) {
            this.bandList = new String[ns];
            this.bandListIndex = new int[ns];
            String[] bandListNames = new String[ns];
            this.calInfo = new String[2][ns][];
            for (int ks = 0; ks < ns; ++ks) {
                int bn;
                this.bandList[ks] = (String)arrayBandList.get(ks);
                bandListNames[ks] = this.bandList[ks];
                if (bandInfo != null && (bn = Integer.valueOf(this.bandList[ks]).intValue()) > 0 && bn < bandInfo.length) {
                    bandListNames[ks] = this.bandList[ks] + " - " + bandInfo[bn];
                }
                this.bandListIndex[ks] = (Integer)arrayBandIndex.get(ks);
                ci = (String[][])arrayCalInfo.get(ks);
                int nc = ci[0].length;
                this.calInfo[0][ks] = ci[0];
                this.calInfo[1][ks] = ci[1];
            }
            if (this.bandList.length == 1) {
                this.replaceList(this.BandBox, bandListNames, null);
                this.replaceList(this.UnitBox, this.calInfo[1][0], "Select Unit");
                this.selectedBand = this.bandList[0];
                this.selectedBandIndex = 0;
            } else {
                this.replaceList(this.BandBox, bandListNames, "Select band");
                this.replaceList(this.UnitBox, null, " ");
                this.selectedBand = this.bandList[0];
                this.selectedBandIndex = 1;
            }
        }
        this.status("Set the other parameters you want");
    }

    public synchronized void status(String m3) {
        this.statusLabel.setText(m3);
        this.statusLabel.validate();
    }

    public void addActionListener(ActionListener o) {
        this.al = o;
    }

    public void removeActionListener(ActionListener o) {
        if (o == this.al) {
            this.al = null;
        }
    }

    private void userActionButtonActionPerformed(ActionEvent evt) {
        this.status("Processing...please wait...");
        String prop = this.getServer() + "|" + this.getGroup() + "|" + this.getDescr();
        this.dataProp.put(prop + "|CoordType", this.getCoordType());
        this.dataProp.put(prop + "|Location", this.getLocationString());
        this.dataProp.put(prop + "|Size", this.getNumLinesEles());
        this.dataProp.put(prop + "|Mag", this.getMag());
        if (this.getUserName() != null) {
            this.dataProp.put(this.getServer() + "|UserName", this.getUserName());
        }
        if (this.getProjectNumber() != null) {
            this.dataProp.put(this.getServer() + "|ProjectNumber", this.getProjectNumber());
        }
        if (this.serverList != null) {
            this.dataProp.put("user|server|list", this.serverList.toString());
        }
        try {
            FileOutputStream fo = new FileOutputStream(this.propFile);
            this.dataProp.save(fo, "GetAreaGUI");
            fo.close();
        }
        catch (Exception es) {
            // empty catch block
        }
        String loc = " ";
        if (this.coordType.equals("E")) {
            loc = "&latlon=";
        } else if (this.coordType.equals("I")) {
            loc = "&linele=";
        } else if (this.coordType.equals("S")) {
            loc = "&id=";
        }
        String up = this.getUserName();
        up = up == null || up.length() < 2 ? " " : "&user=" + this.getUserName() + "&proj=" + this.getProjectNumber();
        String un = this.getUnit();
        if (un == null || un.length() < 3) {
            un = "BRIT";
        }
        this.imageList = new ArrayList();
        if (this.multipleImages) {
            int numimages = this.DateTimeList.getSelectedIndices().length;
            StringBuffer cmdbuf = new StringBuffer();
            for (int i = 0; i < numimages; ++i) {
                String addecmd = new String("adde://" + this.getServer() + "/imagedata?group=" + this.getGroup() + "&descr=" + this.getDescr() + loc + this.getLocationString() + "&size=" + this.getNumLinesEles() + "&day=" + this.getDay(i) + "&time=" + this.getTime(i) + " " + this.getTime(i) + " I " + "&band=" + this.getBand() + "&unit=" + un + "&mag=" + this.getMag() + up + "&version=1");
                cmdbuf.append(addecmd);
                this.imageList.add(addecmd);
                if (i + 1 >= numimages) continue;
                cmdbuf.append("|");
            }
            this.cmdout = cmdbuf.toString();
        } else {
            this.cmdout = "adde://" + this.getServer() + "/imagedata?group=" + this.getGroup() + "&descr=" + this.getDescr() + loc + this.getLocationString() + "&size=" + this.getNumLinesEles() + "&day=" + this.getDay() + "&time=" + this.getTime() + " " + this.getTime() + " I " + "&band=" + this.getBand() + "&unit=" + un + "&mag=" + this.getMag() + up + "&version=1";
            this.imageList.add(this.cmdout);
        }
        System.out.println("cmdout = " + this.cmdout);
        if (this.al != null) {
            this.al.actionPerformed(new ActionEvent(this, 1001, this.cmdout));
        }
        if (this.closeOnAction && this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public List getImageList() {
        return this.imageList;
    }

    public String toString() {
        return this.cmdout;
    }

    private synchronized void setLocButtonLabel() {
        if (this.LatLonButton.isSelected()) {
            this.LatLineLabel.setText("Latitude");
            this.LonEleLabel.setText("Longitude");
            this.coordType = "E";
        } else if (this.LinEleButton.isSelected()) {
            this.LatLineLabel.setText("Image Line");
            this.LonEleLabel.setText("Image Element");
            this.coordType = "I";
        } else if (this.IDButton.isSelected()) {
            this.LatLineLabel.setText("Radar Station ID");
            this.LonEleLabel.setText(" ");
            this.coordType = "S";
        }
    }

    private void IDButtonStateChanged(ChangeEvent evt) {
        this.setLocButtonLabel();
    }

    private void LinEleButtonStateChanged(ChangeEvent evt) {
        this.setLocButtonLabel();
    }

    private void LatLonButtonStateChanged(ChangeEvent evt) {
        this.setLocButtonLabel();
    }

    private void EMagSliderStateChanged(ChangeEvent evt) {
        int v = this.EMagSlider.getValue();
        this.setEleMag(v - 50);
        if (this.baseNumEles < 1) {
            return;
        }
        int x = this.baseNumEles * this.EMagValue;
        if (this.EMagValue < 0) {
            x = this.baseNumEles / -this.EMagValue;
        }
        this.NumElesText.setText(Integer.toString(x));
    }

    private void LMagSliderStateChanged(ChangeEvent evt) {
        int v = this.LMagSlider.getValue();
        this.setLineMag(v - 50);
        this.setEleMag(v - 50);
        if (this.baseNumLines < 1) {
            return;
        }
        int x = this.baseNumLines * this.LMagValue;
        if (this.LMagValue < 0) {
            x = this.baseNumLines / -this.LMagValue;
        }
        this.NumLinesText.setText(Integer.toString(x));
    }

    private void DescrSelectorActionPerformed(ActionEvent evt) {
        if (this.serverUpdated) {
            return;
        }
        if (this.groupUpdated) {
            return;
        }
        this.areaIndex = -1;
        Thread tdsap = new Thread(){

            public void run() {
                int i = GetAreaGUI.this.DescrSelector.getSelectedIndex();
                String[] dl = GetAreaGUI.this.asi.getDatasetList();
                if (i > 0 && dl != null) {
                    GetAreaGUI.this.selectedDescr = dl[i - 1];
                    GetAreaGUI.this.status("Getting dates and times from server...may take a while!!");
                    GetAreaGUI.this.asi.setSelectedDataset(GetAreaGUI.this.selectedDescr);
                    String[] times = GetAreaGUI.this.asi.getDateTimeList();
                    GetAreaGUI.this.ad = GetAreaGUI.this.asi.getAreaDirectories();
                    GetAreaGUI.this.DateTimeList.setListData(times);
                    GetAreaGUI.this.DateTimeList.revalidate();
                    GetAreaGUI.this.status("Now pick a day & time from the list, or set a Position number");
                    String prop = GetAreaGUI.this.getServer() + "|" + GetAreaGUI.this.getGroup() + "|" + GetAreaGUI.this.getDescr();
                    String pp = (String)GetAreaGUI.this.dataProp.get(prop + "|CoordType");
                    GetAreaGUI.this.gotUserDefaults = false;
                    if (pp != null) {
                        GetAreaGUI.this.setCoordType(pp);
                        GetAreaGUI.this.gotUserDefaults = true;
                    }
                    if ((pp = (String)GetAreaGUI.this.dataProp.get(prop + "|Location")) != null) {
                        GetAreaGUI.this.setLocationString(pp);
                        GetAreaGUI.this.gotUserDefaults = true;
                    }
                    if ((pp = (String)GetAreaGUI.this.dataProp.get(prop + "|Size")) != null) {
                        GetAreaGUI.this.setNumLinesEles(pp);
                        GetAreaGUI.this.gotUserDefaults = true;
                    }
                    if ((pp = (String)GetAreaGUI.this.dataProp.get(prop + "|Mag")) != null) {
                        GetAreaGUI.this.setMag(pp);
                        GetAreaGUI.this.gotUserDefaults = true;
                    }
                }
            }
        };
        tdsap.start();
        this.doingRes = false;
        this.setLineMag(1);
        this.setEleMag(1);
        this.setCoordType("E");
        this.setLocationString(null);
        this.setNumLinesEles(null);
        String[] ld = new String[]{"Day and times for", "selected dataset will", "appear here"};
        this.DateTimeList.setListData(ld);
        this.DateTimeList.revalidate();
    }

    private void GroupSelectorActionPerformed(ActionEvent evt) {
        if (this.serverUpdated) {
            return;
        }
        this.areaIndex = -1;
        Thread tgsap = new Thread(){

            public void run() {
                GetAreaGUI.this.selectedGroup = (String)GetAreaGUI.this.GroupSelector.getSelectedItem();
                GetAreaGUI.this.asi.setSelectedGroup(GetAreaGUI.this.selectedGroup);
                GetAreaGUI.this.bandNames = GetAreaGUI.this.asi.getBandNames();
                String[] dl = GetAreaGUI.this.asi.getDatasetListDescriptions();
                GetAreaGUI.this.groupUpdated = true;
                GetAreaGUI.this.replaceList(GetAreaGUI.this.DescrSelector, dl, "Select Dataset");
                GetAreaGUI.this.groupUpdated = false;
                GetAreaGUI.this.status("Now choose a Dataset from the list");
                GetAreaGUI.this.replaceList(GetAreaGUI.this.UnitBox, null, "        ");
                GetAreaGUI.this.replaceList(GetAreaGUI.this.BandBox, null, "        ");
            }
        };
        tgsap.start();
        this.DateTimeList.removeAll();
        String[] ld = new String[]{"Day and times for", "selected dataset will", "appear here"};
        this.DateTimeList.setListData(ld);
        this.DateTimeList.revalidate();
    }

    private void ServerSelectorActionPerformed(ActionEvent evt) {
        Thread tssap = new Thread(){

            public void run() {
                GetAreaGUI.this.serverUpdated = true;
                GetAreaGUI.this.replaceList(GetAreaGUI.this.GroupSelector, null, "Please wait...");
                GetAreaGUI.this.status("Reading information from server...");
                GetAreaGUI.this.selectedServer = (String)GetAreaGUI.this.ServerSelector.getSelectedItem();
                int sstat = -1;
                while (sstat == -1) {
                    String un = GetAreaGUI.this.getUserName();
                    if (un == null || un.length() < 2) {
                        un = (String)GetAreaGUI.this.dataProp.get(GetAreaGUI.this.selectedServer + "|UserName");
                        String pn = (String)GetAreaGUI.this.dataProp.get(GetAreaGUI.this.selectedServer + "|ProjectNumber");
                        if (un != null) {
                            GetAreaGUI.this.setUserName(un);
                            GetAreaGUI.this.setProjectNumber(pn);
                            String ups = "user=" + un + "&proj=" + pn;
                            GetAreaGUI.this.asi.setUserIDandProjString(ups);
                        }
                    } else {
                        String ups = "user=" + un + "&proj=" + GetAreaGUI.this.getProjectNumber();
                        GetAreaGUI.this.asi.setUserIDandProjString(ups);
                    }
                    if ((sstat = GetAreaGUI.this.asi.setSelectedServer(GetAreaGUI.this.selectedServer, "image")) != -1) continue;
                    String pus = JOptionPane.showInputDialog("User ID and project number required by this server!\nPlease enter them here (eg., jack 1234)");
                    if (pus != null) {
                        StringTokenizer stp = new StringTokenizer(pus, " ");
                        if (stp.countTokens() != 2) continue;
                        GetAreaGUI.this.setUserName(stp.nextToken());
                        GetAreaGUI.this.setProjectNumber(stp.nextToken());
                        continue;
                    }
                    sstat = -5;
                }
                if (sstat >= 0) {
                    String prompt;
                    String[] gl;
                    if (GetAreaGUI.this.ServerSelector.getSelectedIndex() == -1) {
                        GetAreaGUI.this.ServerSelector.addItem(GetAreaGUI.this.selectedServer);
                        GetAreaGUI.this.serverList.append("," + GetAreaGUI.this.selectedServer);
                    }
                    if ((gl = GetAreaGUI.this.asi.getGroupList()) == null) {
                        GetAreaGUI.this.GroupSelector.setEditable(true);
                        prompt = "Enter the group name";
                    } else {
                        GetAreaGUI.this.GroupSelector.setEditable(false);
                        prompt = "Select group";
                    }
                    GetAreaGUI.this.replaceList(GetAreaGUI.this.GroupSelector, gl, prompt);
                    GetAreaGUI.this.serverUpdated = false;
                    GetAreaGUI.this.status("Now - " + prompt + " to use...");
                } else {
                    GetAreaGUI.this.status("Pick a different server!");
                    GetAreaGUI.this.serverUpdated = false;
                }
            }
        };
        tssap.start();
        this.areaIndex = -1;
        this.DescrSelector.removeAllItems();
        this.DateTimeList.removeAll();
        String[] ld = new String[]{"Day and times for", "selected dataset will", "appear here"};
        this.DateTimeList.setListData(ld);
        this.DateTimeList.revalidate();
        this.DescrSelector.revalidate();
    }

    private synchronized void replaceList(JComboBox b, String[] s2, String first) {
        if (b.getItemCount() > 0) {
            b.removeAllItems();
        }
        if (first != null) {
            b.addItem(first);
        }
        if (s2 != null) {
            for (int i = 0; i < s2.length; ++i) {
                b.addItem(s2[i].trim());
            }
        }
        b.setSelectedIndex(0);
        b.revalidate();
    }

    public static void main(String[] args) {
        GetAreaGUI gag = new GetAreaGUI("avoid pain", false, false);
        gag.setUserName("tomw");
        gag.setProjectNumber("1234");
        gag.show();
    }
}

