/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.Server.AbstractClause;
import dods.dap.Server.BoolFunction;
import dods.dap.Server.SDODSException;
import dods.dap.Server.SubClause;
import dods.dap.Server.TopLevelClause;
import java.util.Iterator;
import java.util.List;

public class BoolFunctionClause
extends AbstractClause
implements TopLevelClause {
    protected BoolFunction function;
    protected boolean value;

    protected BoolFunctionClause(BoolFunction function, List children) throws SDODSException {
        function.checkArgs(children);
        this.function = function;
        this.children = children;
        this.constant = true;
        for (SubClause current : children) {
            current.setParent(this);
            if (current.isConstant()) continue;
            this.constant = false;
        }
        if (this.constant) {
            this.evaluate();
        }
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean evaluate() throws SDODSException {
        if (!this.constant || !this.defined) {
            this.defined = true;
            this.value = this.function.evaluate(this.children);
        }
        return this.value;
    }

    public BoolFunction getFunction() {
        return this.function;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.function.getName());
        buf.append("(");
        Iterator it = this.children.iterator();
        if (it.hasNext()) {
            buf.append(it.next().toString());
        }
        while (it.hasNext()) {
            buf.append(",");
            buf.append(it.next().toString());
        }
        buf.append(")");
        return buf.toString();
    }
}

