/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.DConstructor;
import dods.dap.DataReadException;
import dods.dap.NoSuchVariableException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DStructure
extends DConstructor
implements ClientIO {
    protected Vector vars = new Vector();

    public DStructure() {
        this(null);
    }

    public DStructure(String n) {
        super(n);
    }

    public Object clone() {
        DStructure s2 = (DStructure)super.clone();
        s2.vars = new Vector();
        for (int i = 0; i < this.vars.size(); ++i) {
            BaseType bt = (BaseType)this.vars.elementAt(i);
            s2.vars.addElement(bt.clone());
        }
        return s2;
    }

    public String getTypeName() {
        return "Structure";
    }

    public int elementCount(boolean leaves) {
        if (!leaves) {
            return this.vars.size();
        }
        int count = 0;
        Enumeration e = this.vars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            count += bt.elementCount(leaves);
        }
        return count;
    }

    public void addVariable(BaseType v, int part) {
        v.setParent(this);
        this.vars.addElement(v);
    }

    public BaseType getVariable(String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            Enumeration e = this.vars.elements();
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DStructure: getVariable()");
    }

    public BaseType getVar(int index) throws NoSuchVariableException {
        if (index < this.vars.size()) {
            return (BaseType)this.vars.elementAt(index);
        }
        throw new NoSuchVariableException("DStructure.getVariable(" + index + " - 1)");
    }

    public Enumeration getVariables() {
        return this.vars.elements();
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        Util.uniqueNames(this.vars, this.getName(), this.getTypeName());
        if (all) {
            Enumeration e = this.vars.elements();
            while (e.hasMoreElements()) {
                BaseType bt = (BaseType)e.nextElement();
                bt.checkSemantics(true);
            }
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.println(space + this.getTypeName() + " {");
        Enumeration e = this.vars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printDecl(os, space + "    ", true, constrained);
        }
        os.print(space + "} " + this.getName());
        if (print_semi) {
            os.println(";");
        }
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        os.print("{ ");
        Enumeration e = this.vars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printVal(os, "", false);
            if (!e.hasMoreElements()) continue;
            os.print(", ");
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        Enumeration e = this.vars.elements();
        while (e.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO bt = (ClientIO)e.nextElement();
            bt.deserialize(source, sv, statusUI);
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        Enumeration e = this.vars.elements();
        while (e.hasMoreElements()) {
            ClientIO bt = (ClientIO)e.nextElement();
            bt.externalize(sink);
        }
    }
}

