/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.MapStatComponent;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.utilint.FormatUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LongDiffStat
extends MapStatComponent<Long, LongDiffStat> {
    private static final long serialVersionUID = 1L;
    private final Stat<Long> base;
    private final long validityMillis;
    private long prevValue;
    private long prevTime;
    private long diff;

    public LongDiffStat(Stat<Long> base, long validityMillis) {
        assert (base != null);
        assert (validityMillis > 0L);
        this.base = base;
        this.validityMillis = validityMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongDiffStat(LongDiffStat other) {
        this.base = other.base.copy();
        this.validityMillis = other.validityMillis;
        LongDiffStat longDiffStat = this;
        synchronized (longDiffStat) {
            LongDiffStat longDiffStat2 = other;
            synchronized (longDiffStat2) {
                this.prevValue = other.prevValue;
                this.prevTime = other.prevTime;
                this.diff = other.diff;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(long time) {
        assert (time > 0L);
        LongDiffStat longDiffStat = this;
        synchronized (longDiffStat) {
            if (this.prevTime == 0L) {
                return 0L;
            }
            if (time < this.prevTime + this.validityMillis) {
                return this.diff;
            }
        }
        long baseValue = (Long)this.base.get();
        LongDiffStat longDiffStat2 = this;
        synchronized (longDiffStat2) {
            return Math.max(baseValue - this.prevValue, 0L);
        }
    }

    public void set(long newValue) {
        this.set(newValue, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long newValue, long time) {
        assert (time > 0L);
        long baseValue = (Long)this.base.get();
        LongDiffStat longDiffStat = this;
        synchronized (longDiffStat) {
            this.prevValue = newValue;
            this.prevTime = time;
            this.diff = Math.max(baseValue - newValue, 0L);
        }
    }

    @Override
    public Long get() {
        return this.get(System.currentTimeMillis());
    }

    @Override
    public synchronized void clear() {
        this.prevValue = 0L;
        this.prevTime = 0L;
        this.diff = 0L;
    }

    @Override
    public LongDiffStat copy() {
        return new LongDiffStat(this);
    }

    @Override
    protected synchronized String getFormattedValue(boolean useCommas) {
        if (this.isNotSet()) {
            return "Unknown";
        }
        if (useCommas) {
            return FormatUtil.decimalScale0().format(this.get(System.currentTimeMillis()));
        }
        return String.valueOf(this.get(System.currentTimeMillis()));
    }

    @Override
    public synchronized boolean isNotSet() {
        return this.prevTime == 0L;
    }

    public synchronized String toString() {
        return "LongDiffStat[prevValue=" + this.prevValue + ", prevTime=" + this.prevTime + ", diff=" + this.diff + "]";
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

