/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.TestHook;
import java.util.Calendar;

public class CronScheduleParser {
    private static final String errorMess = "The format of je.env.verifySchedule is invalid. ";
    private static final int spaceNum = 4;
    private static final int fieldNum = 5;
    public static final String nullCons = "The argument should not be null.";
    public static final String cons1 = "The standard string should be '* * * * *', i.e. there are 5 fields and 4 blank spaces.";
    public static final String cons2 = "Each field can only be an int value or *.";
    public static final String cons3 = "Can not specify dayOfWeek and dayOfMonth simultaneously.";
    public static final String cons4 = "Can not specify dayOfMonth or month.";
    public static final String cons5 = "Range Error: ";
    public static final String cons6 = "If the day of the week is a concrete day, then the minute and the hour should also be concrete.";
    public static final String cons7 = "If the hour is a concrete day, then minute should also be concrete";
    private static final long millsOneDay = 86400000L;
    private static final long millsOneHour = 3600000L;
    private static final long millsOneMinute = 60000L;
    public static volatile TestHook<Calendar> setCurCalHook;
    private final long time;
    private long delay;
    private long interval;

    public CronScheduleParser(String cronSchedule) {
        this(cronSchedule, Calendar.getInstance());
    }

    public CronScheduleParser(String cronSchedule, Calendar calendar) {
        Calendar curCal = setCurCalHook != null ? setCurCalHook.getHookValue() : calendar;
        this.time = curCal.getTimeInMillis();
        this.validate(cronSchedule);
        this.parser(cronSchedule, curCal);
    }

    public static boolean checkSame(String cronvSchedule1, String cronSchedule2) {
        if (cronvSchedule1 == null && cronSchedule2 == null) {
            return true;
        }
        if (cronvSchedule1 == null || cronSchedule2 == null) {
            return false;
        }
        return cronvSchedule1.equals(cronSchedule2);
    }

    public long getTime() {
        return this.time;
    }

    public long getDelayTime() {
        return this.delay;
    }

    public long getInterval() {
        return this.interval;
    }

    private void assertDelay() {
        if (this.delay < 0L) {
            throw new IllegalStateException("Delay is negative: " + this.delay + "; interval is: " + this.interval);
        }
    }

    private void parser(String cronSchedule, Calendar curCal) {
        int curDayOfWeek = curCal.get(7);
        int curHour = curCal.get(11);
        int curMinute = curCal.get(12);
        Calendar scheduleCal = (Calendar)curCal.clone();
        scheduleCal.set(13, 0);
        scheduleCal.set(14, 0);
        String[] timeArray = cronSchedule.split(" ");
        if (!timeArray[4].equals("*")) {
            this.interval = 604800000L;
            int tmpDayOfWeek = Integer.valueOf(timeArray[4]) + 1;
            int tmpHour = Integer.valueOf(timeArray[1]);
            int tmpMinute = Integer.valueOf(timeArray[0]);
            scheduleCal.set(7, tmpDayOfWeek);
            scheduleCal.set(11, tmpHour);
            scheduleCal.set(12, tmpMinute);
            if (scheduleCal.getTimeInMillis() < curCal.getTimeInMillis()) {
                scheduleCal.add(5, 7);
            }
            this.delay = scheduleCal.getTimeInMillis() - curCal.getTimeInMillis();
            this.assertDelay();
            return;
        }
        if (!timeArray[1].equals("*")) {
            this.interval = 86400000L;
            int tmpHour = Integer.valueOf(timeArray[1]);
            int tmpMinute = Integer.valueOf(timeArray[0]);
            scheduleCal.set(7, curDayOfWeek);
            scheduleCal.set(11, tmpHour);
            scheduleCal.set(12, tmpMinute);
            if (scheduleCal.getTimeInMillis() < curCal.getTimeInMillis()) {
                scheduleCal.add(5, 1);
            }
            this.delay = scheduleCal.getTimeInMillis() - curCal.getTimeInMillis();
            this.assertDelay();
            return;
        }
        if (!timeArray[0].equals("*")) {
            this.interval = 3600000L;
            int tmpMinute = Integer.valueOf(timeArray[0]);
            scheduleCal.set(7, curDayOfWeek);
            scheduleCal.set(11, curHour);
            scheduleCal.set(12, tmpMinute);
            if (scheduleCal.getTimeInMillis() < curCal.getTimeInMillis()) {
                scheduleCal.add(10, 1);
            }
            this.delay = scheduleCal.getTimeInMillis() - curCal.getTimeInMillis();
            this.assertDelay();
            return;
        }
        if (timeArray[0].equals("*")) {
            this.interval = 60000L;
            this.delay = 0L;
            this.assertDelay();
            return;
        }
    }

    private void validate(String cronSchedule) {
        int dayOfWeek;
        int hour;
        int min2;
        String[] timeArray;
        if (cronSchedule == null) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. The argument should not be null.");
        }
        int spaceCount = 0;
        for (int i = 0; i < cronSchedule.length(); ++i) {
            char c = cronSchedule.charAt(i);
            if (c != ' ') continue;
            ++spaceCount;
        }
        if (spaceCount != 4 || cronSchedule.split(" ").length != 5) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. The standard string should be '* * * * *', i.e. there are 5 fields and 4 blank spaces.");
        }
        for (String str : timeArray = cronSchedule.split(" ")) {
            try {
                Integer.valueOf(str);
            }
            catch (NumberFormatException e) {
                if (str.equals("*")) continue;
                throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. Each field can only be an int value or *.");
            }
        }
        if (!timeArray[2].equals("*") && !timeArray[4].equals("*")) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. Can not specify dayOfWeek and dayOfMonth simultaneously.");
        }
        if (!timeArray[2].equals("*") || !timeArray[3].equals("*")) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. Can not specify dayOfMonth or month.");
        }
        if (!(timeArray[0].equals("*") || (min2 = Integer.valueOf(timeArray[0]).intValue()) >= 0 && min2 <= 59)) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. Range Error: The minute should be (0-59).");
        }
        if (!(timeArray[1].equals("*") || (hour = Integer.valueOf(timeArray[1]).intValue()) >= 0 && hour <= 23)) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. Range Error: The hour should be (0-23).");
        }
        if (!(timeArray[4].equals("*") || (dayOfWeek = Integer.valueOf(timeArray[4]).intValue()) >= 0 && dayOfWeek <= 6)) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. Range Error: The day of the week shouldbe (0-6).");
        }
        if (!timeArray[4].equals("*") && (timeArray[0].equals("*") || timeArray[1].equals("*"))) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. If the day of the week is a concrete day, then the minute and the hour should also be concrete.");
        }
        if (!timeArray[1].equals("*") && timeArray[0].equals("*")) {
            throw new IllegalArgumentException("The format of je.env.verifySchedule is invalid. If the hour is a concrete day, then minute should also be concrete");
        }
    }
}

