/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public class BtreeStats
extends DatabaseStats {
    private static final long serialVersionUID = 298825033L;
    private final StatGroup stats;

    public BtreeStats() {
        this.stats = new StatGroup("BTreeCount", "Btree node counts.");
    }

    public BtreeStats(StatGroup stats) {
        this.stats = stats;
    }

    public long getBottomInternalNodeCount() {
        return this.stats.getLong(BTreeStatDefinition.BT_COUNT_BINS);
    }

    public long getDuplicateBottomInternalNodeCount() {
        return 0L;
    }

    public long getDeletedLeafNodeCount() {
        return this.stats.getLong(BTreeStatDefinition.BT_COUNT_DELETED_LNS);
    }

    public long getDupCountLeafNodeCount() {
        return 0L;
    }

    public long getInternalNodeCount() {
        return this.stats.getLong(BTreeStatDefinition.BT_COUNT_INS);
    }

    public long getDuplicateInternalNodeCount() {
        return 0L;
    }

    public long getLeafNodeCount() {
        return this.stats.getLong(BTreeStatDefinition.BT_COUNT_LNS);
    }

    public int getMainTreeMaxDepth() {
        return this.stats.getInt(BTreeStatDefinition.BT_COUNT_MAINTREE_MAXDEPTH);
    }

    public int getDuplicateTreeMaxDepth() {
        return 0;
    }

    public long[] getINsByLevel() {
        return this.stats.getLongArray(BTreeStatDefinition.BT_COUNT_INS_BYLEVEL);
    }

    public long[] getBINsByLevel() {
        return this.stats.getLongArray(BTreeStatDefinition.BT_COUNT_BINS_BYLEVEL);
    }

    public long[] getBINEntriesHistogram() {
        return this.stats.getLongArray(BTreeStatDefinition.BT_COUNT_BIN_ENTRIES_HISTOGRAM);
    }

    public long[] getDINsByLevel() {
        return new long[0];
    }

    public long[] getDBINsByLevel() {
        return new long[0];
    }

    public long getRelatches() {
        return 0L;
    }

    public int getRootSplits() {
        return 0;
    }

    public String toString() {
        return this.stats.toString();
    }

    public String toStringVerbose() {
        return this.stats.toStringVerbose();
    }
}

