/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.BackupArchiveLocation;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Objects;

public class BackupFileLocation
implements BackupArchiveLocation {
    private volatile String nodeName;
    private volatile String baseDirectory;

    @Override
    public synchronized void initialize(String nodeName, File configFile) {
        Objects.requireNonNull(nodeName, "nodeName arg must not be null");
        Objects.requireNonNull(configFile, "configFile arg must not be null");
        if (this.baseDirectory != null) {
            throw new IllegalStateException("Already initialized");
        }
        String configFileString = configFile.getPath();
        if (!Paths.get(configFileString, new String[0]).isAbsolute()) {
            throw new IllegalArgumentException("The configuration argument for BackupFileLocation must be an absolute pathname: " + configFile);
        }
        this.nodeName = nodeName;
        this.baseDirectory = configFileString.endsWith("/") ? configFileString : configFileString + "/";
    }

    @Override
    public URL getArchiveLocation(String relativeArchivePath) {
        Objects.requireNonNull(relativeArchivePath, "relativeArchivePath arg must not be null");
        String file = relativeArchivePath.startsWith("/") ? this.baseDirectory + this.nodeName + relativeArchivePath : this.baseDirectory + this.nodeName + "/" + relativeArchivePath;
        try {
            return new URL("file", null, file);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unexpected malformed file URL for: " + file, e);
        }
    }
}

