/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridEnsembleCoord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridIndex;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class GridIndexToNC {
    private static Logger logger = LoggerFactory.getLogger(GridIndexToNC.class);
    private Map<String, GridHorizCoordSys> hcsHash = new HashMap<String, GridHorizCoordSys>(10);
    private DateFormatter formatter = new DateFormatter();
    private String indexFilename;
    private RandomAccessFile raf;

    public GridIndexToNC(String filename) {
        this.indexFilename = filename;
    }

    public GridIndexToNC(RandomAccessFile raf) {
        this.indexFilename = raf.getLocation();
        this.raf = raf;
    }

    public void open(GridIndex index, GridTableLookup lookup, int version, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        Formatter f;
        String source;
        Object hcs;
        List<GridDefRecord> hcsList = index.getHorizCoordSys();
        boolean needGroups = hcsList.size() > 1;
        for (GridDefRecord gds : hcsList) {
            Object g = null;
            if (needGroups) {
                g = new Group(ncfile, null, gds.getGroupName());
                ncfile.addGroup(null, (Group)g);
            }
            GridHorizCoordSys hcs2 = this.makeGridHorizCoordSys(gds, lookup, (Group)g);
            this.hcsHash.put(gds.getParam("GDSkey"), hcs2);
        }
        GridRecord firstRecord = null;
        List<GridRecord> records = index.getGridRecords();
        for (GridRecord gridRecord : records) {
            if (firstRecord == null) {
                firstRecord = gridRecord;
            }
            hcs = this.hcsHash.get(gridRecord.getGridDefRecordId());
            int cdmHash = gridRecord.cdmVariableHash();
            GridVariable pv = ((GridHorizCoordSys)hcs).varHash.get(cdmHash);
            if (null == pv) {
                String name = gridRecord.cdmVariableName(lookup, true, true);
                pv = this.makeGridVariable(this.indexFilename, name, (GridHorizCoordSys)hcs, lookup);
                ((GridHorizCoordSys)hcs).varHash.put(cdmHash, pv);
                String simpleName = gridRecord.getParameterDescription();
                List<GridVariable> plist = ((GridHorizCoordSys)hcs).productHash.get(simpleName);
                if (null == plist) {
                    plist = new ArrayList<GridVariable>();
                    ((GridHorizCoordSys)hcs).productHash.put(simpleName, plist);
                }
                plist.add(pv);
            }
            pv.addProduct(gridRecord);
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.4"));
        this.addExtraAttributes(firstRecord, lookup, ncfile);
        ncfile.addAttribute(null, new Attribute("title", lookup.getTitle()));
        if (lookup.getInstitution() != null) {
            ncfile.addAttribute(null, new Attribute("institution", lookup.getInstitution()));
        }
        if ((source = lookup.getSource()) != null && !source.startsWith("Unknown")) {
            ncfile.addAttribute(null, new Attribute("source", source));
        }
        ncfile.addAttribute(null, new Attribute("history", "Direct read of " + lookup.getGridType() + " into NetCDF-Java 4 API"));
        if (lookup.getComment() != null) {
            ncfile.addAttribute(null, new Attribute("comment", lookup.getComment()));
        }
        ncfile.addAttribute(null, new Attribute("featureType", FeatureType.GRID.toString()));
        ncfile.addAttribute(null, new Attribute("file_format", lookup.getGridType()));
        ncfile.addAttribute(null, new Attribute("location", ncfile.getLocation()));
        ncfile.addAttribute(null, new Attribute("_CoordinateModelRunDate", this.formatter.toDateTimeStringISO(lookup.getFirstBaseTime())));
        this.makeDenseCoordSys(ncfile, lookup, cancelTask);
        if (GridServiceProvider.debugMissing) {
            f = new Formatter(System.out);
            hcs = null;
            try {
                int count = 0;
                Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
                for (GridHorizCoordSys hcs3 : hcset) {
                    ArrayList<GridVariable> gribvars = new ArrayList<GridVariable>(hcs3.varHash.values());
                    for (GridVariable gv : gribvars) {
                        count += gv.showMissingSummary(f);
                    }
                }
                System.out.println(" total missing= " + count);
            }
            catch (Throwable throwable) {
                hcs = throwable;
                throw throwable;
            }
            finally {
                if (f != null) {
                    if (hcs != null) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)hcs).addSuppressed(throwable);
                        }
                    } else {
                        f.close();
                    }
                }
            }
        }
        if (GridServiceProvider.debugMissingDetails) {
            f = new Formatter();
            Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
            for (GridHorizCoordSys hcs4 : hcset) {
                f.format("******** Horiz Coordinate= %s%n", hcs4.getGridName());
                String lastVertDesc = null;
                ArrayList<GridVariable> gribvars = new ArrayList<GridVariable>(hcs4.varHash.values());
                Collections.sort(gribvars, new CompareGridVariableByVertName());
                for (GridVariable gv : gribvars) {
                    String vertDesc = gv.getVertName();
                    if (!vertDesc.equals(lastVertDesc)) {
                        f.format("---Vertical Coordinate= %s%n", vertDesc);
                        lastVertDesc = vertDesc;
                    }
                    gv.showMissing(f);
                }
            }
        }
    }

    protected void addExtraAttributes(GridRecord firstRecord, GridTableLookup lookup, NetcdfFile ncfile) {
    }

    protected GridEnsembleCoord addEnsembles(List<GridEnsembleCoord> ensembleCoords, List<GridRecord> recordList) {
        return null;
    }

    protected GridHorizCoordSys makeGridHorizCoordSys(GridDefRecord gds, GridTableLookup lookup, Group g) {
        return new GridHorizCoordSys(gds, lookup, g);
    }

    protected GridVariable makeGridVariable(String indexFilename, String name, GridHorizCoordSys hcs, GridTableLookup lookup) {
        return new GridVariable(indexFilename, name, hcs, lookup);
    }

    protected GridTimeCoord makeGridTimeCoord(List<GridRecord> recordList, String location) {
        return new GridTimeCoord(recordList, location);
    }

    protected GridVertCoord makeGridVertCoord(List<GridRecord> recordList, String vname, GridTableLookup lookup, GridHorizCoordSys hcs) {
        return new GridVertCoord(recordList, vname, lookup, hcs);
    }

    public GridHorizCoordSys getHorizCoordSys(GridRecord gribRecord) {
        return this.hcsHash.get(gribRecord.getGridDefRecordId());
    }

    public Map<String, GridHorizCoordSys> getHorizCoordSystems() {
        return this.hcsHash;
    }

    /*
     * WARNING - void declaration
     */
    private void makeDenseCoordSys(NetcdfFile ncfile, GridTableLookup lookup, CancelTask cancelTask) throws IOException {
        ArrayList<GridTimeCoord> timeCoords = new ArrayList<GridTimeCoord>();
        ArrayList<GridVertCoord> vertCoords = new ArrayList<GridVertCoord>();
        ArrayList<GridEnsembleCoord> ensembleCoords = new ArrayList<GridEnsembleCoord>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
        for (GridHorizCoordSys hcs : hcset) {
            Object tcs2;
            if (cancelTask != null && cancelTask.isCancel()) break;
            ArrayList<GridVariable> gribvars = new ArrayList<GridVariable>(hcs.varHash.values());
            for (GridVariable gridVariable : gribvars) {
                GridEnsembleCoord gridEnsembleCoord;
                if (cancelTask != null && cancelTask.isCancel()) break;
                List<GridRecord> recordList = gridVariable.getRecords();
                GridRecord record = recordList.get(0);
                String vname = gridVariable.makeLevelName(record, lookup);
                GridVertCoord useVertCoord = null;
                for (GridVertCoord gridVertCoord : vertCoords) {
                    if (!vname.equals(gridVertCoord.getLevelName()) || !gridVertCoord.matchLevels(recordList)) continue;
                    useVertCoord = gridVertCoord;
                }
                if (useVertCoord == null) {
                    useVertCoord = this.makeGridVertCoord(recordList, vname, lookup, hcs);
                    vertCoords.add(useVertCoord);
                }
                gridVariable.setVertCoord(useVertCoord);
                GridTimeCoord useTimeCoord = null;
                for (GridTimeCoord gtc : timeCoords) {
                    if (!gtc.matchTimes(recordList)) continue;
                    useTimeCoord = gtc;
                    break;
                }
                if (useTimeCoord == null) {
                    useTimeCoord = this.makeGridTimeCoord(recordList, ncfile.getLocation());
                    timeCoords.add(useTimeCoord);
                }
                gridVariable.setTimeCoord(useTimeCoord);
                if (!gridVariable.isEnsemble() || (gridEnsembleCoord = this.addEnsembles(ensembleCoords, recordList)) == null) continue;
                gridVariable.setEnsembleCoord(gridEnsembleCoord);
            }
            Collections.sort(timeCoords);
            int count = 0;
            for (Object tcs2 : timeCoords) {
                ((GridTimeCoord)tcs2).setSequence(count++);
                ((GridTimeCoord)tcs2).addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
            }
            boolean bl = false;
            tcs2 = ensembleCoords.iterator();
            while (tcs2.hasNext()) {
                void var13_14;
                GridEnsembleCoord gec = (GridEnsembleCoord)tcs2.next();
                gec.setSequence((int)(++var13_14));
                gec.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addDimensionsToNetcdfFile(ncfile);
            Collections.sort(vertCoords);
            int vcIndex = 0;
            String listName = null;
            int start = 0;
            for (vcIndex = 0; vcIndex < vertCoords.size(); ++vcIndex) {
                GridVertCoord gvcs = (GridVertCoord)vertCoords.get(vcIndex);
                String vname = gvcs.getLevelName();
                if (listName == null) {
                    listName = vname;
                }
                if (vname.equals(listName)) continue;
                this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
                listName = vname;
                start = vcIndex;
            }
            this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
            ArrayList<List<GridVariable>> products = new ArrayList<List<GridVariable>>(hcs.productHash.values());
            for (List list : products) {
                if (cancelTask != null && cancelTask.isCancel()) break;
                if (list.size() == 1) {
                    GridVariable pv = (GridVariable)list.get(0);
                    String name = pv.getFirstRecord().cdmVariableName(lookup, false, false);
                    Variable v = pv.makeVariable(ncfile, hcs.getGroup(), name, this.raf);
                    ncfile.addVariable(hcs.getGroup(), v);
                    continue;
                }
                HashMap<GridVertCoord, VertCollection> vcMap = new HashMap<GridVertCoord, VertCollection>();
                for (GridVariable gv3 : list) {
                    VertCollection vc = (VertCollection)vcMap.get(gv3.getVertCoord());
                    if (vc == null) {
                        vc = new VertCollection(gv3);
                        vcMap.put(gv3.getVertCoord(), vc);
                    }
                    vc.list.add(gv3);
                }
                ArrayList vclist = new ArrayList(vcMap.values());
                Collections.sort(vclist);
                boolean firstVertCoord = true;
                for (VertCollection vc : vclist) {
                    boolean hasMultipleLevels = vc.vc.getNLevels() > 1;
                    boolean noLevelOk = firstVertCoord;
                    List<GridVariable> list2 = vc.list;
                    if (list2.size() == 1) {
                        GridVariable gv4 = list2.get(0);
                        String name = gv4.getFirstRecord().cdmVariableName(lookup, !noLevelOk, false);
                        ncfile.addVariable(hcs.getGroup(), gv4.makeVariable(ncfile, hcs.getGroup(), name, this.raf));
                    } else {
                        for (GridVariable gv5 : list2) {
                            String name = gv5.getFirstRecord().cdmVariableName(lookup, !noLevelOk, true);
                            ncfile.addVariable(hcs.getGroup(), gv5.makeVariable(ncfile, hcs.getGroup(), name, this.raf));
                        }
                    }
                    firstVertCoord = false;
                }
            }
            for (GridTimeCoord gridTimeCoord : timeCoords) {
                gridTimeCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            for (GridEnsembleCoord gridEnsembleCoord : ensembleCoords) {
                gridEnsembleCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addToNetcdfFile(ncfile);
            for (GridVertCoord gridVertCoord : vertCoords) {
                gridVertCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
        }
    }

    private void makeVerticalDimensions(List<GridVertCoord> vertCoordList, NetcdfFile ncfile, Group group) {
        GridVertCoord gvcs0 = null;
        int maxLevels = 0;
        for (GridVertCoord gvcs : vertCoordList) {
            if (gvcs.getNLevels() <= maxLevels) continue;
            gvcs0 = gvcs;
            maxLevels = gvcs.getNLevels();
        }
        int seqno = 1;
        for (GridVertCoord gvcs : vertCoordList) {
            if (gvcs != gvcs0) {
                gvcs.setSequence(seqno++);
            }
            gvcs.addDimensionsToNetcdfFile(ncfile, group);
        }
    }

    private static class CompareGridVariableByNumberVertLevels
    implements Comparator {
        private CompareGridVariableByNumberVertLevels() {
        }

        public int compare(Object o1, Object o2) {
            int n2;
            GridVariable gv1 = (GridVariable)o1;
            GridVariable gv2 = (GridVariable)o2;
            int n1 = gv1.getVertCoord().getNLevels();
            if (n1 == (n2 = gv2.getVertCoord().getNLevels())) {
                return gv1.getVertCoord().getLevelName().compareTo(gv2.getVertCoord().getLevelName());
            }
            return n2 - n1;
        }
    }

    private static class CompareGridVariableByVertName
    implements Comparator {
        private CompareGridVariableByVertName() {
        }

        public int compare(Object o1, Object o2) {
            GridVariable gv1 = (GridVariable)o1;
            GridVariable gv2 = (GridVariable)o2;
            return gv1.getVertName().compareToIgnoreCase(gv2.getVertName());
        }
    }

    private static class VertCollection
    implements Comparable<VertCollection> {
        GridVertCoord vc;
        List<GridVariable> list = new ArrayList<GridVariable>(3);

        VertCollection(GridVariable gv) {
            this.vc = gv.getVertCoord();
        }

        public int hashCode() {
            return this.vc.hashCode();
        }

        public boolean equals(Object obj) {
            VertCollection oc = (VertCollection)obj;
            return this.vc.equals(oc.vc);
        }

        @Override
        public int compareTo(VertCollection o) {
            int ret = o.vc.getNLevels() - this.vc.getNLevels();
            if (ret == 0) {
                ret = this.vc.getLevelName().compareTo(o.vc.getLevelName());
            }
            return ret;
        }
    }
}

