/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationTimeSeriesCollectionFlattened;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public abstract class StationTimeSeriesCollectionImpl
extends OneNestedPointCollectionImpl
implements StationTimeSeriesFeatureCollection {
    private volatile StationHelper stationHelper;
    protected PointFeatureCollectionIterator localIterator;

    public StationTimeSeriesCollectionImpl(String name, DateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.STATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StationHelper getStationHelper() {
        if (this.stationHelper == null) {
            StationTimeSeriesCollectionImpl stationTimeSeriesCollectionImpl = this;
            synchronized (stationTimeSeriesCollectionImpl) {
                if (this.stationHelper == null) {
                    try {
                        this.stationHelper = this.createStationHelper();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        assert (this.stationHelper != null) : "We screwed this up.";
        return this.stationHelper;
    }

    protected abstract StationHelper createStationHelper() throws IOException;

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new PointFeatureCollectionIterator(){
            Iterator<StationFeature> stationIter;
            {
                this.stationIter = StationTimeSeriesCollectionImpl.this.getStationHelper().getStationFeatures().iterator();
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.stationIter.hasNext();
            }

            @Override
            public PointFeatureCollection next() throws IOException {
                return (StationTimeSeriesFeature)this.stationIter.next();
            }

            @Override
            public void setBufferSize(int bytes) {
            }

            @Override
            public void finish() {
            }
        };
    }

    @Override
    public StationTimeSeriesFeature getStationFeature(Station s) throws IOException {
        return (StationTimeSeriesFeature)this.getStationHelper().getStationFeature(s);
    }

    @Override
    public Station getStation(PointFeature feature) throws IOException {
        StationPointFeature stationFeature = (StationPointFeature)feature;
        return stationFeature.getStation();
    }

    @Override
    public List<StationFeature> getStationFeatures() throws IOException {
        return this.getStationHelper().getStationFeatures();
    }

    @Override
    public List<StationFeature> getStationFeatures(List<String> stnNames) {
        return this.getStationHelper().getStationFeaturesFromNames(stnNames);
    }

    @Override
    public List<StationFeature> getStationFeatures(LatLonRect boundingBox) throws IOException {
        return this.getStationHelper().getStationFeatures(boundingBox);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return this.subset(this.getStations(boundingBox));
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        List<StationFeature> stationsFeatures = this.getStationHelper().getStationFeatures(stations);
        return new StationTimeSeriesCollectionSubset(this, stationsFeatures);
    }

    @Override
    public StationTimeSeriesFeatureCollection subsetFeatures(List<StationFeature> stationsFeatures) throws IOException {
        return new StationTimeSeriesCollectionSubset(this, stationsFeatures);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stationNames, CalendarDateRange dateRange, List<VariableSimpleIF> varList) throws IOException {
        if (stationNames == null || stationNames.size() == 0) {
            return new StationTimeSeriesCollectionFlattened(this, dateRange);
        }
        List<StationFeature> subsetStations = this.getStationHelper().getStationFeaturesFromNames(stationNames);
        return new StationTimeSeriesCollectionFlattened(new StationTimeSeriesCollectionSubset(this, subsetStations), dateRange);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        if (boundingBox == null) {
            return new StationTimeSeriesCollectionFlattened(this, dateRange);
        }
        List<StationFeature> subsetStations = this.getStationHelper().getStationFeatures(boundingBox);
        return new StationTimeSeriesCollectionFlattened(new StationTimeSeriesCollectionSubset(this, subsetStations), dateRange);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stations, DateRange dateRange, List<VariableSimpleIF> varList) throws IOException {
        return this.flatten(stations, CalendarDateRange.of(dateRange), varList);
    }

    @Override
    public List<Station> getStations() {
        return this.getStationHelper().getStations();
    }

    @Override
    public List<Station> getStations(List<String> stnNames) {
        return this.getStationHelper().getStations(stnNames);
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        return this.getStationHelper().getStations(boundingBox);
    }

    @Override
    public Station getStation(String name) {
        return this.getStationHelper().getStation(name);
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.getStationHelper().getBoundingBox();
    }

    @Override
    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        throw new UnsupportedOperationException("StationFeatureCollection does not implement getNestedPointFeatureCollection()");
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public void finish() {
        if (this.localIterator != null) {
            this.localIterator.finish();
        }
    }

    @Override
    public StationTimeSeriesFeature next() throws IOException {
        return (StationTimeSeriesFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator(-1);
    }

    private static class StationTimeSeriesCollectionSubset
    extends StationTimeSeriesCollectionImpl {
        private final List<StationFeature> stations;

        StationTimeSeriesCollectionSubset(StationTimeSeriesCollectionImpl from, List<StationFeature> stations) {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits());
            this.stations = stations;
        }

        @Override
        protected StationHelper createStationHelper() throws IOException {
            StationHelper stationHelper = new StationHelper();
            stationHelper.setStations(this.stations);
            return stationHelper;
        }

        @Override
        public List<StationFeature> getStationFeatures() throws IOException {
            return this.getStationHelper().getStationFeatures();
        }
    }
}

