/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import opendap.dap.BaseType;
import opendap.dap.DAPNode;
import opendap.dap.DataReadException;
import opendap.dap.PrimitiveVector;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;

public class Float64PrimitiveVector
extends PrimitiveVector {
    private double[] vals;

    public Float64PrimitiveVector(BaseType var) {
        super(var);
    }

    @Override
    public int getLength() {
        return this.vals.length;
    }

    @Override
    public void setLength(int len) {
        this.vals = new double[len];
    }

    public final double getValue(int i) {
        return this.vals[i];
    }

    public final void setValue(int i, double newVal) {
        this.vals[i] = newVal;
    }

    @Override
    public void printVal(PrintWriter os, String space) {
        int len = this.vals.length;
        for (int i = 0; i < len - 1; ++i) {
            os.print(this.vals[i]);
            os.print(", ");
        }
        if (len > 0) {
            os.print(this.vals[len - 1]);
        }
    }

    @Override
    public void printSingleVal(PrintWriter os, int index) {
        os.print(this.vals[index]);
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = source.readDouble();
            if (statusUI == null) continue;
            statusUI.incrementByteCount(8);
            if (!statusUI.userCancelled()) continue;
            throw new DataReadException("User cancelled");
        }
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        for (int i = 0; i < this.vals.length; ++i) {
            sink.writeDouble(this.vals[i]);
        }
    }

    public void externalize(DataOutputStream sink, int start, int stop, int stride) throws IOException {
        for (int i = start; i <= stop; i += stride) {
            sink.writeDouble(this.vals[i]);
        }
    }

    @Override
    public Object getInternalStorage() {
        return this.vals;
    }

    @Override
    public void setInternalStorage(Object o) {
        this.vals = (double[])o;
    }

    @Override
    public PrimitiveVector subset(int start, int stop, int stride) {
        Float64PrimitiveVector n = new Float64PrimitiveVector(this.getTemplate());
        stride = Math.max(stride, 1);
        stop = Math.max(start, stop);
        int length = 1 + (stop - start) / stride;
        n.setLength(length);
        int count = 0;
        for (int i = start; i <= stop; i += stride) {
            n.setValue(count, this.vals[i]);
            ++count;
        }
        return n;
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
    }

    @Override
    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        Float64PrimitiveVector v = (Float64PrimitiveVector)super.cloneDAG(map);
        if (this.vals != null) {
            v.vals = new double[this.vals.length];
            System.arraycopy(this.vals, 0, v.vals, 0, this.vals.length);
        }
        return v;
    }
}

