/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.itadaki.bzip2.BZip2OutputStream;

public class Compress {
    public static void main(String[] args) throws IOException {
        int bytesRead;
        File outputFile;
        File inputFile;
        if (args.length == 0) {
            System.err.println("Demonstration BZip2 compressor\n\nUsage:\n  java demo.Compress <filename>\n");
            System.exit(1);
        }
        if (!(inputFile = new File(args[0])).exists() || !inputFile.canRead()) {
            System.err.println("Cannot read file " + inputFile.getPath());
            System.exit(1);
        }
        if ((outputFile = new File(String.valueOf(args[0]) + ".bz2")).exists()) {
            System.err.println("File " + outputFile.getPath() + " already exists");
            System.exit(1);
        }
        BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(inputFile));
        BufferedOutputStream fileOutputStream = new BufferedOutputStream(new FileOutputStream(outputFile), 524288);
        BZip2OutputStream outputStream = new BZip2OutputStream(fileOutputStream);
        byte[] buffer = new byte[524288];
        while ((bytesRead = ((InputStream)fileInputStream).read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.close();
    }
}

