/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.util.Stack;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ucar.nc2.util.IO;
import ucar.nc2.util.Indent;
import ucar.util.prefs.Bean;
import ucar.util.prefs.PreferencesExt;

public class XMLStore {
    private static boolean debugConvert = false;
    private static boolean debugWhichStore = false;
    private static boolean debugWriteNested = false;
    private static boolean debugWriteBean = false;
    private File prefsFile = null;
    private PreferencesExt rootPrefs = new PreferencesExt(null, "");
    private boolean showDecoderExceptions = true;
    private String outputExceptionMessage;
    private static char[] replaceChar = new char[]{'&', '<', '>', '\'', '\"', '\r', '\n'};
    private static String[] replaceWith = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;", "&#13;", "&#10;"};

    public static XMLStore createFromFile(String fileName, XMLStore storedDefaults) throws IOException {
        File prefsFile = new File(fileName);
        BufferedInputStream primIS = null;
        BufferedInputStream objIS = null;
        if (prefsFile.exists()) {
            primIS = new BufferedInputStream(new FileInputStream(prefsFile));
            objIS = new BufferedInputStream(new FileInputStream(prefsFile));
        }
        if (debugWhichStore) {
            System.out.println("XMLStore read from file " + fileName);
        }
        XMLStore store = new XMLStore(primIS, objIS, storedDefaults);
        store.prefsFile = prefsFile;
        return store;
    }

    public static XMLStore createFromInputStream(InputStream is1, InputStream is2, XMLStore storedDefaults) throws IOException {
        if (debugWhichStore) {
            System.out.println("XMLStore read from input stream " + is1);
        }
        return new XMLStore(is1, is2, storedDefaults);
    }

    public static XMLStore createFromResource(String resourceName, XMLStore storedDefaults) throws IOException {
        Class<XMLStore> c = XMLStore.class;
        InputStream primIS = c.getResourceAsStream(resourceName);
        InputStream objIS = c.getResourceAsStream(resourceName);
        if (primIS == null) {
            throw new IOException("XMLStore.createFromResource cant find <" + resourceName + ">");
        }
        if (debugWhichStore) {
            System.out.println("XMLStore read from resource " + resourceName);
        }
        return new XMLStore(primIS, objIS, storedDefaults);
    }

    public XMLStore() {
    }

    private XMLStore(InputStream primIS, InputStream objIS, XMLStore storedDefaults) throws IOException {
        if (null != primIS) {
            InputStream convertIS = this.convert2XmlDecoder(objIS);
            objIS.close();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                MySaxHandler handler = new MySaxHandler(convertIS);
                saxParser.parse(primIS, (DefaultHandler)handler);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException se) {
                System.out.println("SAXException = " + se.getMessage());
                se.printStackTrace();
                Exception see = se.getException();
                if (see != null) {
                    System.out.println("from = " + see.getMessage());
                    see.printStackTrace();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            primIS.close();
            convertIS.close();
        }
        if (storedDefaults != null) {
            this.rootPrefs.setStoredDefaults(storedDefaults.getPreferences());
        }
    }

    private XMLDecoder openBeanDecoder(InputStream objIS) {
        XMLDecoder beanDecoder = new XMLDecoder(objIS, null, new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                if (XMLStore.this.showDecoderExceptions) {
                    System.out.println("***XMLStore.read() got Exception= " + e.getClass().getName() + " " + e.getMessage());
                }
                e.printStackTrace();
            }
        });
        return beanDecoder;
    }

    private InputStream convert2XmlDecoder(InputStream is) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            doc = builder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (debugConvert) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("***XMLStore.convert2XmlDecoder = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element root = doc.getRootElement();
        Document convertDoc = new Document();
        Element convertRoot = new Element("java");
        convertRoot.setAttribute("version", "1.4.1_01");
        convertRoot.setAttribute("class", "java.beans.XMLDecoder");
        convertDoc.setRootElement(convertRoot);
        this.add(root, convertRoot);
        XMLOutputter xmlOut = new XMLOutputter();
        xmlOut.setFormat(Format.getPrettyFormat());
        if (debugConvert) {
            System.out.printf("%n************************************%n", new Object[0]);
            System.out.println("***Convert2Version2 converted = \n" + xmlOut.outputString(convertDoc) + "\n*******");
        }
        return new StringBufferInputStream(xmlOut.outputString(convertDoc));
    }

    private void add(Element elem, Element parent) {
        if (elem.getName().equals("object")) {
            parent.addContent((Element)elem.clone());
            return;
        }
        for (Object child : elem.getChildren()) {
            this.add((Element)child, parent);
        }
    }

    public static String makeStandardFilename(String appName, String storeName) {
        String dirFilename;
        File f;
        String userHome = null;
        try {
            userHome = System.getProperty("user.home");
        }
        catch (Exception e) {
            System.out.println("XMLStore.makeStandardFilename: error System.getProperty(user.home) " + e);
        }
        if (null == userHome) {
            userHome = ".";
        }
        if (!(f = new File(dirFilename = userHome + "/" + appName)).exists()) {
            f.mkdirs();
        }
        return dirFilename + "/" + storeName;
    }

    public PreferencesExt getPreferences() {
        return this.rootPrefs;
    }

    String findAttribute(Attributes atts, String what) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getLocalName(i).equals(what)) continue;
            return atts.getValue(i);
        }
        return null;
    }

    public void save() throws IOException {
        File prefTemp;
        if (this.prefsFile == null) {
            throw new UnsupportedOperationException("XMLStore is read-only");
        }
        String parentFilename = this.prefsFile.getParent();
        if (parentFilename == null) {
            prefTemp = File.createTempFile("pref", ".xml");
        } else {
            File parentFile = new File(parentFilename);
            prefTemp = File.createTempFile("pref", ".xml", parentFile);
        }
        prefTemp.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(prefTemp, false);
        this.save(fos);
        fos.close();
        File xmlBackup = new File(this.prefsFile.getAbsolutePath() + ".bak");
        if (xmlBackup.exists()) {
            xmlBackup.delete();
        }
        this.prefsFile.renameTo(xmlBackup);
        prefTemp.renameTo(this.prefsFile);
        prefTemp.delete();
    }

    public void save(OutputStream out) throws IOException {
        this.outputExceptionMessage = null;
        OutputMunger bos = new OutputMunger(out);
        PrintWriter pw = new PrintWriter(bos);
        XMLEncoder beanEncoder = new XMLEncoder(bos);
        beanEncoder.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception exception) {
                System.out.println("XMLStore.save() got Exception: abort saving the preferences!");
                exception.printStackTrace();
                XMLStore.this.outputExceptionMessage = exception.getMessage();
            }
        });
        pw.printf("<?xml version='1.0' encoding='UTF-8'?>%n", new Object[0]);
        pw.printf("<preferences EXTERNAL_XML_VERSION='1.0'>%n", new Object[0]);
        if (!this.rootPrefs.isUserNode()) {
            pw.printf("  <root type='system'>%n", new Object[0]);
        } else {
            pw.printf("  <root type='user'>%n", new Object[0]);
        }
        Indent indent = new Indent(2);
        indent.incr();
        this.writeXmlNode(bos, pw, this.rootPrefs, beanEncoder, indent);
        if (this.outputExceptionMessage != null) {
            throw new IOException(this.outputExceptionMessage);
        }
        pw.printf("  </root>%n", new Object[0]);
        pw.printf("</preferences>%n", new Object[0]);
        pw.flush();
    }

    private void writeXmlNode(OutputMunger bos, PrintWriter out, PreferencesExt prefs, XMLEncoder beanEncoder, Indent indent) throws IOException {
        indent.incr();
        if (debugWriteNested) {
            System.out.println(" writeXmlNode " + prefs);
        }
        if (debugWriteBean) {
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            System.out.println("  ClassLoader " + l.getClass().getName());
        }
        try {
            String[] keys = prefs.keysNoDefaults();
            if (keys.length == 0) {
                out.printf("%s<map/>%n", indent);
            } else {
                out.printf("%s<map>%n", indent);
                for (int i = 0; i < keys.length; ++i) {
                    Object bean;
                    Object value = prefs.getObjectNoDefaults(keys[i]);
                    if (value instanceof String) {
                        if (debugWriteNested) {
                            System.out.println("  write entry " + keys[i] + " " + value);
                        }
                        out.printf("%s  <entry key='%s' value='%s' />%n", indent, keys[i], XMLStore.quote((String)value));
                        continue;
                    }
                    if (value instanceof Bean.Collection) {
                        bean = (Bean.Collection)value;
                        if (debugWriteNested) {
                            System.out.println("  write bean collection " + keys[i]);
                        }
                        if (((Bean.Collection)bean).getCollection().isEmpty()) continue;
                        out.printf("%s  <beanCollection key='%s' class='%s' >%n", indent, keys[i], ((Bean.Collection)bean).getBeanClass().getName());
                        for (Object o : ((Bean.Collection)bean).getCollection()) {
                            out.printf("%s    <bean ", indent);
                            ((Bean.Collection)bean).writeProperties(out, o);
                            out.println("/>");
                        }
                        out.printf("%s  </beanCollection>", indent);
                        continue;
                    }
                    if (value instanceof Bean) {
                        bean = (Bean)value;
                        if (debugWriteNested) {
                            System.out.println("  write bean " + keys[i] + " " + value);
                        }
                        out.printf("%s  <bean key='%s' class='%s' ", indent, keys[i], ((Bean)bean).getBeanClass().getName());
                        ((Bean)bean).writeProperties(out);
                        out.printf("/>%n", new Object[0]);
                        continue;
                    }
                    out.printf("%s  <beanObject key='%s' >%n", indent, keys[i]);
                    out.flush();
                    bos.enterBeanStream();
                    try {
                        if (debugWriteNested || debugWriteBean) {
                            System.out.println("  write beanObject " + keys[i] + " " + value + " " + value.getClass().getName());
                        }
                        beanEncoder.writeObject(value);
                        if (debugWriteBean) {
                            System.out.println("  write bean done ");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Exception beanEncoder: " + e);
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                    beanEncoder.flush();
                    bos.exitBeanStream();
                    out.printf("%s  </beanObject>%n", indent);
                }
                out.printf("%s</map>%n", indent);
            }
            String[] kidName = prefs.childrenNames();
            for (int i = 0; i < kidName.length; ++i) {
                PreferencesExt pkid = (PreferencesExt)prefs.node(kidName[i]);
                out.printf("%s<node name='%s' >%n", indent, pkid.name());
                this.writeXmlNode(bos, out, pkid, beanEncoder, indent);
                out.printf("%s</node>%n", indent);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        indent.decr();
    }

    static String quote(String x) {
        boolean ok = true;
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            ok &= pos < 0;
        }
        if (ok) {
            return x;
        }
        StringBuffer result = new StringBuffer(x);
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            if (pos < 0) continue;
            XMLStore.replace(result, replaceChar[i], replaceWith[i]);
        }
        return result.toString();
    }

    private static void replace(StringBuffer sb, char out, String in) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != out) continue;
            sb.replace(i, i + 1, in);
            i += in.length();
        }
    }

    public static void main(String[] args) throws IOException {
        FileInputStream is = new FileInputStream("C:\\Users\\caron\\.unidata\\NetcdfUI22.xml");
        XMLStore store = new XMLStore();
        IO.copy(is, System.out);
        ((InputStream)is).close();
    }

    private class OutputMunger
    extends BufferedOutputStream {
        boolean done;
        boolean bean;
        int countNL;

        OutputMunger(OutputStream out) {
            super(out, 1024);
            this.done = false;
            this.bean = false;
            this.countNL = 0;
        }

        void enterBeanStream() {
            this.bean = true;
        }

        void exitBeanStream() {
            this.bean = false;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.done || !this.bean) {
                super.write(b);
            } else {
                if (b == 10) {
                    ++this.countNL;
                }
                if (this.countNL == 2) {
                    this.done = true;
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.done || !this.bean) {
                super.write(b, off, len);
            } else {
                for (int i = 0; i < len; ++i) {
                    this.write(b[off + i]);
                }
            }
        }
    }

    private class MySaxHandler
    extends DefaultHandler {
        private boolean debug = false;
        private boolean debugDetail = false;
        private InputStream objIS;
        private XMLDecoder beanDecoder = null;
        private Bean.Collection currentBeanCollection = null;
        private Stack stack;
        private PreferencesExt current;

        MySaxHandler(InputStream objIS) throws IOException {
            this.objIS = objIS;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("root")) {
                this.startRoot(attributes);
            } else if (qName.equalsIgnoreCase("map")) {
                this.startMap(attributes);
            } else if (qName.equalsIgnoreCase("node")) {
                this.startNode(attributes);
            } else if (qName.equalsIgnoreCase("entry")) {
                this.startEntry(attributes);
            } else if (qName.equalsIgnoreCase("bean")) {
                this.startBean(attributes);
            } else if (qName.equalsIgnoreCase("beanCollection")) {
                this.startBeanCollection(attributes);
            } else if (qName.equalsIgnoreCase("beanObject")) {
                this.startBeanObject(attributes);
            } else if (this.debugDetail) {
                System.out.println(" unprocessed startElement = " + qName);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("node")) {
                this.endNode();
            }
            if (qName.equalsIgnoreCase("beanCollection")) {
                this.endBeanCollection();
            } else if (this.debugDetail) {
                System.out.println(" unprocessed endElement = " + qName);
            }
        }

        private void startRoot(Attributes attributes) {
            if (this.debugDetail) {
                System.out.println(" startRoot ");
            }
            this.stack = new Stack();
            this.current = XMLStore.this.rootPrefs;
        }

        private void startMap(Attributes attributes) {
            if (this.debugDetail) {
                System.out.println(" startMap ");
            }
        }

        private void startNode(Attributes attributes) {
            String name = attributes.getValue("name");
            if (this.debug) {
                System.out.println(" node = " + name);
            }
            if (name.equals("dumpPane") && this.debug) {
                System.out.println("");
            }
            this.stack.push(this.current);
            this.current = (PreferencesExt)this.current.node(name);
        }

        private void startEntry(Attributes attributes) {
            String key = attributes.getValue("key");
            String values = attributes.getValue("value");
            if (this.debug) {
                System.out.println(" entry = " + key + " " + values);
            }
            this.current.put(key, values);
        }

        private void startBean(Attributes attributes) {
            String key = attributes.getValue("key");
            try {
                if (this.currentBeanCollection != null) {
                    Object value = this.currentBeanCollection.readProperties(attributes);
                    if (this.debug) {
                        System.out.println(" bean(collection) = " + key + " value= " + value);
                    }
                } else {
                    Bean value = new Bean(attributes);
                    if (this.debug) {
                        System.out.println(" bean = " + key + " value= " + value);
                    }
                    this.current.putObject(key, value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void startBeanCollection(Attributes attributes) {
            String key = attributes.getValue("key");
            try {
                this.currentBeanCollection = new Bean.Collection(attributes);
                if (this.debug) {
                    System.out.println(" beanCollection = " + key);
                }
                this.current.putObject(key, this.currentBeanCollection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void startBeanObject(Attributes attributes) {
            if (this.beanDecoder == null) {
                this.beanDecoder = XMLStore.this.openBeanDecoder(this.objIS);
            }
            String key = attributes.getValue("key");
            try {
                if (this.debug) {
                    System.out.print(" beanObject = " + key + " ");
                }
                Object value = this.beanDecoder.readObject();
                if (this.debug) {
                    System.out.println(" value= " + value);
                }
                this.current.putObject(key, value);
            }
            catch (Exception e) {
                System.out.println("#ERROR beanDecoder; beanObject key = " + key);
                e.printStackTrace();
            }
        }

        private void endBeanCollection() {
            this.currentBeanCollection = null;
        }

        private void endNode() {
            this.current = (PreferencesExt)this.stack.pop();
        }
    }
}

