/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Grib2RecordScanner {
    private static Logger log = LoggerFactory.getLogger(Grib2RecordScanner.class);
    private static final KMPMatch matcher = new KMPMatch(new byte[]{71, 82, 73, 66});
    private static final boolean debug = false;
    private static final boolean debugRepeat = false;
    private static final int maxScan = 16000;
    private Map<Long, Grib2SectionGridDefinition> gdsMap = new HashMap<Long, Grib2SectionGridDefinition>();
    private RandomAccessFile raf = null;
    private byte[] header;
    private long startPos = 0L;
    private long lastPos = 0L;
    private long repeatPos = -1L;
    private Grib2Record repeatRecord = null;
    private Grib2SectionBitMap repeatBms = null;

    public static boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            while (raf.getFilePointer() < 16000L) {
                boolean found = raf.searchForward(matcher, 16000);
                if (!found) {
                    return false;
                }
                raf.skipBytes(7);
                int edition = raf.read();
                if (edition != 2) continue;
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public Grib2RecordScanner(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        raf.seek(this.startPos);
        raf.order(0);
        this.lastPos = this.startPos;
    }

    public boolean hasNext() throws IOException {
        boolean more;
        if (this.lastPos >= this.raf.length()) {
            return false;
        }
        if (this.repeatPos > 0L) {
            if (this.nextRepeating()) {
                return true;
            }
        } else {
            this.repeatRecord = null;
            this.repeatBms = null;
        }
        long stop = 0L;
        while (true) {
            this.raf.seek(this.lastPos);
            more = this.raf.searchForward(matcher, -1);
            if (!more) break;
            stop = this.raf.getFilePointer();
            this.raf.skipBytes(7);
            int edition = this.raf.read();
            if (edition == 2) break;
            this.lastPos = this.raf.getFilePointer();
        }
        if (more) {
            int sizeHeader = (int)(stop - this.lastPos);
            this.header = new byte[sizeHeader];
            this.startPos = stop - (long)sizeHeader;
            this.raf.seek(this.startPos);
            this.raf.read(this.header);
        }
        return more;
    }

    public Grib2Record next() throws IOException {
        if (this.repeatRecord != null) {
            return new Grib2Record(this.repeatRecord);
        }
        Grib2SectionIndicator is = null;
        try {
            is = new Grib2SectionIndicator(this.raf);
            Grib2SectionIdentification ids = new Grib2SectionIdentification(this.raf);
            Grib2SectionLocalUse lus = new Grib2SectionLocalUse(this.raf);
            Grib2SectionGridDefinition gds = new Grib2SectionGridDefinition(this.raf);
            Grib2SectionProductDefinition pds = new Grib2SectionProductDefinition(this.raf);
            Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(this.raf);
            Grib2SectionBitMap bms = new Grib2SectionBitMap(this.raf);
            Grib2SectionData dataSection = new Grib2SectionData(this.raf);
            if ((long)dataSection.getMsgLength() > is.getMessageLength()) {
                this.raf.seek(drs.getStartingPosition());
                throw new IllegalStateException("Illegal Grib2SectionData Message Length");
            }
            long crc = gds.calcCRC();
            Grib2SectionGridDefinition gdsCached = this.gdsMap.get(crc);
            if (gdsCached != null) {
                gds = gdsCached;
            } else {
                this.gdsMap.put(crc, gds);
            }
            long pos = this.raf.getFilePointer();
            long ending = is.getEndPos();
            if (pos + 34L < ending) {
                this.repeatPos = pos;
                this.repeatRecord = new Grib2Record(this.header, is, ids, lus, gds, pds, drs, bms, dataSection, false);
                if (bms.getBitMapIndicator() == 0) {
                    this.repeatBms = bms;
                }
                return new Grib2Record(this.repeatRecord);
            }
            this.raf.seek(ending - 4L);
            for (int i = 0; i < 4; ++i) {
                if (this.raf.read() == 55) continue;
                log.warn("Missing End of GRIB message at pos=" + ending + " header= " + StringUtil2.cleanup(this.header) + " for=" + this.raf.getLocation());
                break;
            }
            this.lastPos = this.raf.getFilePointer();
            return new Grib2Record(this.header, is, ids, lus, gds, pds, drs, bms, dataSection, false);
        }
        catch (Throwable t) {
            long pos = is == null ? -1L : is.getStartPos();
            log.warn("Bad GRIB2 record in file {}, skipping pos={}", (Object)this.raf.getLocation(), (Object)pos);
            this.lastPos = this.raf.getFilePointer();
            if (this.hasNext()) {
                return this.next();
            }
            return null;
        }
    }

    private boolean nextRepeating() throws IOException {
        long ending;
        long pos;
        this.raf.seek(this.repeatPos);
        int length = GribNumbers.int4(this.raf);
        int section = this.raf.read();
        this.raf.seek(this.repeatPos);
        if (section == 2) {
            this.repeatRecord.setLus(new Grib2SectionLocalUse(this.raf));
            this.repeatRecord.setGdss(new Grib2SectionGridDefinition(this.raf));
            this.repeatRecord.setPdss(new Grib2SectionProductDefinition(this.raf));
            this.repeatRecord.setDrs(new Grib2SectionDataRepresentation(this.raf));
            this.repeatRecord.setBms(new Grib2SectionBitMap(this.raf), false);
            this.repeatRecord.setDataSection(new Grib2SectionData(this.raf));
            this.repeatRecord.repeat = section;
        } else if (section == 3) {
            this.repeatRecord.setGdss(new Grib2SectionGridDefinition(this.raf));
            this.repeatRecord.setPdss(new Grib2SectionProductDefinition(this.raf));
            this.repeatRecord.setDrs(new Grib2SectionDataRepresentation(this.raf));
            this.repeatRecord.setBms(new Grib2SectionBitMap(this.raf), false);
            this.repeatRecord.setDataSection(new Grib2SectionData(this.raf));
            this.repeatRecord.repeat = section;
        } else if (section == 4) {
            this.repeatRecord.setPdss(new Grib2SectionProductDefinition(this.raf));
            this.repeatRecord.setDrs(new Grib2SectionDataRepresentation(this.raf));
            this.repeatRecord.setBms(new Grib2SectionBitMap(this.raf), false);
            this.repeatRecord.setDataSection(new Grib2SectionData(this.raf));
            this.repeatRecord.repeat = section;
        } else {
            this.repeatPos = -1L;
            this.repeatRecord = null;
            this.repeatBms = null;
            return false;
        }
        Grib2SectionBitMap bms = this.repeatRecord.getBitmapSection();
        if (bms.getBitMapIndicator() == 254) {
            if (this.repeatBms == null) {
                throw new IllegalStateException("No bms in repeating section");
            }
            this.repeatRecord.setBms(this.repeatBms, true);
            this.repeatRecord.repeat += 1000;
        } else if (bms.getBitMapIndicator() == 0) {
            this.repeatBms = this.repeatRecord.getBitmapSection();
        }
        if (section == 2 || section == 3) {
            Grib2SectionGridDefinition gds = this.repeatRecord.getGDSsection();
            long crc = gds.calcCRC();
            Grib2SectionGridDefinition gdsCached = this.gdsMap.get(crc);
            if (gdsCached != null) {
                this.repeatRecord.setGdss(gdsCached);
            } else {
                this.gdsMap.put(crc, gds);
            }
        }
        if ((pos = this.raf.getFilePointer()) + 34L < (ending = this.repeatRecord.getIs().getEndPos())) {
            this.repeatPos = pos;
            return true;
        }
        this.raf.seek(ending - 4L);
        for (int i = 0; i < 4; ++i) {
            if (this.raf.read() == 55) continue;
            log.warn("  REPEAT Missing End of GRIB message at pos=" + ending + " header= " + StringUtil2.cleanup(this.header) + " for=" + this.raf.getLocation());
            break;
        }
        this.lastPos = this.raf.getFilePointer();
        this.repeatPos = -1L;
        return true;
    }

    public static Grib2Record findRecordByDrspos(RandomAccessFile raf, long drsPos) throws IOException {
        Grib2Record result = null;
        Grib2RecordScanner scanner = new Grib2RecordScanner(raf);
        long pos = Math.max(0L, drsPos - 10000L);
        raf.seek(pos);
        while (scanner.hasNext()) {
            result = scanner.next();
            if (result.getDataRepresentationSection().getStartingPosition() == drsPos) {
                return result;
            }
            if (raf.getFilePointer() <= drsPos) continue;
            break;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        RandomAccessFile raf = new RandomAccessFile("Q:/cdmUnitTest/formats/grib2/sfc_d01_20080430_1200_f00000.grb2", "r");
        Grib2RecordScanner scan = new Grib2RecordScanner(raf);
        while (scan.hasNext()) {
            scan.next();
        }
        raf.close();
    }
}

