/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib1SectionIndicator {
    static final byte[] MAGIC = new byte[]{71, 82, 73, 66};
    private final long messageLength;
    private final long startPos;

    public Grib1SectionIndicator(RandomAccessFile raf) throws IOException {
        this.startPos = raf.getFilePointer();
        byte[] b = new byte[4];
        raf.read(b);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == MAGIC[i]) continue;
            throw new IllegalArgumentException("Not a GRIB record");
        }
        this.messageLength = GribNumbers.int3(raf);
        int edition = raf.read();
        if (edition != 1) {
            throw new IllegalArgumentException("Not a GRIB-1 record");
        }
    }

    public Grib1SectionIndicator(long startPos, long messageLength) {
        this.startPos = startPos;
        this.messageLength = messageLength;
    }

    public long getMessageLength() {
        return this.messageLength;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public long getEndPos() {
        return this.startPos + this.messageLength;
    }
}

