/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.StringTokenizer;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructurePseudoDS;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.JoinMuiltdimStructure;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class GempakCdm
extends TableConfigurerImpl {
    private static final String Convention = "GEMPAK/CDM";

    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        boolean ok = false;
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        if (conv.equals(Convention)) {
            ok = true;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equals(Convention)) continue;
            ok = true;
        }
        if (!ok) {
            return false;
        }
        CF.FeatureType ftype = CF.FeatureType.getFeatureTypeFromGlobalAttribute(ds);
        if (ftype == null) {
            ftype = CF.FeatureType.point;
        }
        return ftype == CF.FeatureType.timeSeries || ftype == CF.FeatureType.timeSeriesProfile;
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        CF.FeatureType ftype = CF.FeatureType.getFeatureTypeFromGlobalAttribute(ds);
        if (ftype == null) {
            ftype = CF.FeatureType.point;
        }
        switch (ftype) {
            case point: {
                return null;
            }
            case timeSeries: {
                if (wantFeatureType == FeatureType.POINT) {
                    return this.getStationAsPointConfig(ds, errlog);
                }
                return this.getStationConfig(ds, errlog);
            }
            case timeSeriesProfile: {
                return this.getStationProfileConfig(ds, errlog);
            }
        }
        throw new IllegalStateException("unimplemented feature ftype= " + (Object)((Object)ftype));
    }

    protected TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        boolean needFinish = false;
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("GempakCdm: Must have a Latitude coordinate", new Object[0]);
            return null;
        }
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lon == null) {
            errlog.format("GempakCdm: Must have a Longitude coordinate", new Object[0]);
            return null;
        }
        if (lat.getRank() != lon.getRank()) {
            errlog.format("GempakCdm: Lat and Lon coordinate must have same rank", new Object[0]);
            return null;
        }
        boolean stnIsScalar = lat.getRank() == 0;
        boolean stnIsSingle = lat.getRank() == 1 && lat.getSize() == 1L;
        Dimension stationDim = null;
        if (!stnIsScalar) {
            if (lat.getDimension(0) != lon.getDimension(0)) {
                errlog.format("GempakCdm: Lat and Lon coordinate must have same size", new Object[0]);
                return null;
            }
            stationDim = lat.getDimension(0);
        }
        boolean hasStruct = Evaluator.hasRecordStructure(ds);
        Table.Type stationTableType = stnIsScalar ? Table.Type.Top : Table.Type.Structure;
        TableConfig stnTable = new TableConfig(stationTableType, "station");
        stnTable.featureType = FeatureType.STATION;
        stnTable.structureType = hasStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
        stnTable.dimName = stationDim.getName();
        stnTable.lat = lat.getFullName();
        stnTable.lon = lon.getFullName();
        CoordinateAxis alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (alt != null) {
            stnTable.stnAlt = alt.getFullName();
        }
        stnTable.stnId = Evaluator.findNameOfVariableWithAttributeValue(ds, "standard_name", "station_id");
        if (stnTable.stnId == null) {
            errlog.format("Must have a Station id variable with standard name station_id", new Object[0]);
            return null;
        }
        Variable stnId = ds.findVariable(stnTable.stnId);
        if (!stnIsScalar && !stnId.getDimension(0).equals(stationDim)) {
            errlog.format("GempakCdm: Station id (%s) outer dimension must match latitude/longitude dimension (%s)", stnTable.stnId, stationDim);
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("GempakCdm: Must have a Time coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        Table.Type obsTableType = null;
        Structure multidimStruct = null;
        if (obsTableType == null && (multidimStruct = Evaluator.findStructureWithDimensions(ds, stationDim, obsDim)) != null) {
            obsTableType = Table.Type.MultidimStructure;
        }
        if (obsTableType == null && time.getRank() == 2) {
            obsTableType = Table.Type.MultidimInner;
        }
        if (obsTableType == null) {
            errlog.format("GempakCdm: Cannot figure out Station/obs table structure", new Object[0]);
            return null;
        }
        TableConfig obs = new TableConfig(obsTableType, obsDim.getName());
        obs.dimName = obsDim.getName();
        obs.time = time.getFullName();
        obs.missingVar = "_isMissing";
        stnTable.addChild(obs);
        if (obsTableType == Table.Type.MultidimStructure) {
            obs.structName = multidimStruct.getFullName();
            obs.structureType = TableConfig.StructureType.Structure;
            if (multidimStruct.findVariable(time.getShortName()) == null) {
                obs.addJoin(new JoinArray(time, JoinArray.Type.raw, 0));
            }
        }
        if (obsTableType == Table.Type.MultidimInner) {
            obs.dimName = obsDim.getName();
        }
        if (needFinish) {
            ds.finish();
        }
        return stnTable;
    }

    protected TableConfig getStationAsPointConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        boolean needFinish = false;
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("GempakCdm: Must have a Latitude coordinate", new Object[0]);
            return null;
        }
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lon == null) {
            errlog.format("GempakCdm: Must have a Longitude coordinate", new Object[0]);
            return null;
        }
        if (lat.getRank() != lon.getRank()) {
            errlog.format("GempakCdm: Lat and Lon coordinate must have same rank", new Object[0]);
            return null;
        }
        boolean stnIsScalar = lat.getRank() == 0;
        boolean stnIsSingle = lat.getRank() == 1 && lat.getSize() == 1L;
        Dimension stationDim = null;
        if (!stnIsScalar) {
            if (lat.getDimension(0) != lon.getDimension(0)) {
                errlog.format("Lat and Lon coordinate must have same size", new Object[0]);
                return null;
            }
            stationDim = lat.getDimension(0);
        }
        CoordinateAxis alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("GempakCdm: Must have a Time coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        Table.Type obsTableType = Table.Type.Structure;
        Structure multidimStruct = Evaluator.findStructureWithDimensions(ds, stationDim, obsDim);
        if (multidimStruct == null) {
            errlog.format("GempakCdm: Cannot figure out StationAsPoint table structure", new Object[0]);
            return null;
        }
        TableConfig obs = new TableConfig(obsTableType, obsDim.getName());
        obs.dimName = obsDim.getName();
        obs.structName = multidimStruct.getFullName();
        obs.structureType = TableConfig.StructureType.Structure;
        obs.featureType = FeatureType.POINT;
        obs.lat = lat.getFullName();
        obs.lon = lon.getFullName();
        obs.time = time.getFullName();
        if (alt != null) {
            obs.elev = alt.getFullName();
        }
        ArrayList<String> vars = new ArrayList<String>(30);
        for (Variable v : ds.getVariables()) {
            if (v.getDimension(0) != stationDim || v.getRank() != 1 && (v.getRank() != 2 || v.getDataType() != DataType.CHAR)) continue;
            vars.add(v.getShortName());
        }
        StructurePseudoDS s = new StructurePseudoDS(ds, null, "stnStruct", vars, stationDim);
        obs.addJoin(new JoinMuiltdimStructure(s, obsDim.getLength()));
        obs.addJoin(new JoinArray(time, JoinArray.Type.modulo, obsDim.getLength()));
        if (needFinish) {
            ds.finish();
        }
        return obs;
    }

    protected TableConfig getStationProfileConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        TableConfig stnTable = this.makeStationTable(ds, errlog);
        if (stnTable == null) {
            return null;
        }
        Dimension stationDim = ds.findDimension(stnTable.dimName);
        stnTable.featureType = FeatureType.STATION_PROFILE;
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("GempakCdm: Must have a Time coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        Structure multidimStruct = Evaluator.findStructureWithDimensions(ds, stationDim, obsDim);
        if (multidimStruct == null) {
            errlog.format("GempakCdm: Cannot figure out Station/obs table structure", new Object[0]);
            return null;
        }
        TableConfig timeTable = new TableConfig(Table.Type.MultidimStructure, obsDim.getName());
        timeTable.missingVar = "_isMissing";
        timeTable.structName = multidimStruct.getFullName();
        timeTable.structureType = TableConfig.StructureType.Structure;
        timeTable.addJoin(new JoinArray(time, JoinArray.Type.level, 1));
        timeTable.time = time.getFullName();
        timeTable.feature_id = time.getFullName();
        stnTable.addChild(timeTable);
        TableConfig obsTable = new TableConfig(Table.Type.NestedStructure, obsDim.getName());
        Structure nestedStruct = Evaluator.findNestedStructure(multidimStruct);
        if (nestedStruct == null) {
            errlog.format("GempakCdm: Cannot find nested Structure for profile", new Object[0]);
            return null;
        }
        obsTable.structName = nestedStruct.getFullName();
        obsTable.nestedTableName = nestedStruct.getShortName();
        CoordinateAxis elev = this.findZAxisNotStationAlt(ds);
        if (elev == null) {
            errlog.format("GempakCdm: Cannot find profile elevation variable", new Object[0]);
            return null;
        }
        obsTable.elev = elev.getShortName();
        timeTable.addChild(obsTable);
        return stnTable;
    }

    protected TableConfig makeStationTable(NetcdfDataset ds, Formatter errlog) throws IOException {
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("GempakCdm: Must have a Latitude coordinate", new Object[0]);
            return null;
        }
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lon == null) {
            errlog.format("GempakCdm: Must have a Longitude coordinate", new Object[0]);
            return null;
        }
        if (lat.getRank() != lon.getRank()) {
            errlog.format("GempakCdm: Lat and Lon coordinate must have same rank", new Object[0]);
            return null;
        }
        Dimension stationDim = null;
        if (lat.getDimension(0) != lon.getDimension(0)) {
            errlog.format("GempakCdm: Lat and Lon coordinate must have same size", new Object[0]);
            return null;
        }
        stationDim = lat.getDimension(0);
        Table.Type stationTableType = Table.Type.Structure;
        TableConfig stnTable = new TableConfig(stationTableType, "station");
        stnTable.structureType = TableConfig.StructureType.PsuedoStructure;
        stnTable.dimName = stationDim.getName();
        stnTable.lat = lat.getFullName();
        stnTable.lon = lon.getFullName();
        stnTable.stnId = this.findNameVariableWithStandardNameAndDimension(ds, "station_id", stationDim, errlog);
        stnTable.stnDesc = this.findNameVariableWithStandardNameAndDimension(ds, "station_description", stationDim, errlog);
        stnTable.stnWmoId = this.findNameVariableWithStandardNameAndDimension(ds, "station_WMO_id", stationDim, errlog);
        stnTable.stnAlt = this.findNameVariableWithStandardNameAndDimension(ds, "surface_altitude", stationDim, errlog);
        if (stnTable.stnId == null) {
            errlog.format("Must have a Station id variable with standard name station_id", new Object[0]);
            return null;
        }
        Variable stnId = ds.findVariable(stnTable.stnId);
        if (!stnId.getDimension(0).equals(stationDim)) {
            errlog.format("GempakCdm: Station id (%s) outer dimension must match latitude/longitude dimension (%s)", stnTable.stnId, stationDim);
            return null;
        }
        return stnTable;
    }
}

