/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.util.cache.FileCache;
import ucar.unidata.geoloc.LatLonRect;

public class GridDataset
implements ucar.nc2.dt.GridDataset,
FeatureDataset {
    private NetcdfDataset ds;
    private ArrayList<GeoGrid> grids = new ArrayList();
    private Map<String, Gridset> gridsetHash = new HashMap<String, Gridset>();
    private LatLonRect llbbMax = null;
    private CalendarDateRange dateRangeMax = null;
    protected FileCache fileCache;

    public static GridDataset open(String location) throws IOException {
        return GridDataset.open(location, NetcdfDataset.getDefaultEnhanceMode());
    }

    public static GridDataset open(String location, Set<NetcdfDataset.Enhance> enhanceMode) throws IOException {
        NetcdfDataset ds = NetcdfDataset.acquireDataset(null, location, enhanceMode, -1, null, null);
        return new GridDataset(ds, null);
    }

    public GridDataset(NetcdfDataset ds) throws IOException {
        this(ds, null);
    }

    public GridDataset(NetcdfDataset ds, Formatter parseInfo) throws IOException {
        this.ds = ds;
        ds.enhance(NetcdfDataset.getDefaultEnhanceMode());
        if (parseInfo != null) {
            parseInfo.format("GridDataset look for GeoGrids\n", new Object[0]);
        }
        List<Variable> vars = ds.getVariables();
        for (Variable var : vars) {
            VariableEnhanced varDS = (VariableEnhanced)((Object)var);
            this.constructCoordinateSystems(ds, varDS, parseInfo);
        }
    }

    private void constructCoordinateSystems(NetcdfDataset ds, VariableEnhanced v, Formatter parseInfo) {
        if (v instanceof StructureDS) {
            StructureDS s = (StructureDS)v;
            List<Variable> members = s.getVariables();
            for (Variable nested : members) {
                this.constructCoordinateSystems(ds, (VariableEnhanced)((Object)nested), parseInfo);
            }
        } else {
            GridCoordSys gcs = null;
            List<CoordinateSystem> csys = v.getCoordinateSystems();
            for (CoordinateSystem cs : csys) {
                GridCoordSys gcsTry = GridCoordSys.makeGridCoordSys(parseInfo, cs, v);
                if (gcsTry == null) continue;
                gcs = gcsTry;
                if (!gcsTry.isProductSet()) continue;
                break;
            }
            if (gcs != null) {
                this.addGeoGrid((VariableDS)v, gcs, parseInfo);
            }
        }
    }

    private void makeRanges() {
        for (GridDataset.Gridset gset : this.getGridsets()) {
            CalendarDateRange dateRange;
            GridCoordSystem gcs = gset.getGeoCoordSystem();
            LatLonRect llbb = gcs.getLatLonBoundingBox();
            if (this.llbbMax == null) {
                this.llbbMax = llbb;
            } else {
                this.llbbMax.extend(llbb);
            }
            if ((dateRange = gcs.getCalendarDateRange()) == null) continue;
            if (this.dateRangeMax == null) {
                this.dateRangeMax = dateRange;
                continue;
            }
            this.dateRangeMax.extend(dateRange);
        }
    }

    @Override
    public String getTitle() {
        String title = this.ds.getTitle();
        if (title == null) {
            title = this.ds.findAttValueIgnoreCase(null, "title", null);
        }
        if (title == null) {
            title = this.getName();
        }
        return title;
    }

    @Override
    public String getDescription() {
        String desc = this.ds.findAttValueIgnoreCase(null, "description", null);
        if (desc == null) {
            desc = this.ds.findAttValueIgnoreCase(null, "history", null);
        }
        return desc == null ? this.getName() : desc;
    }

    @Override
    public String getLocation() {
        return this.ds.getLocation();
    }

    @Override
    public String getLocationURI() {
        return this.ds.getLocation();
    }

    @Override
    public DateRange getDateRange() {
        CalendarDateRange cdr = this.getCalendarDateRange();
        return cdr != null ? cdr.toDateRange() : null;
    }

    @Override
    public Date getStartDate() {
        DateRange dr = this.getDateRange();
        return dr != null ? dr.getStart().getDate() : null;
    }

    @Override
    public Date getEndDate() {
        DateRange dr = this.getDateRange();
        return dr != null ? dr.getEnd().getDate() : null;
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax;
    }

    @Override
    public CalendarDate getCalendarDateStart() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getStart();
    }

    @Override
    public CalendarDate getCalendarDateEnd() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getEnd();
    }

    @Override
    public LatLonRect getBoundingBox() {
        if (this.llbbMax == null) {
            this.makeRanges();
        }
        return this.llbbMax;
    }

    @Override
    public void calcBounds() throws IOException {
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.ds.getGlobalAttributes();
    }

    @Override
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.ds.findGlobalAttributeIgnoreCase(name);
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        ArrayList<VariableSimpleIF> result = new ArrayList<VariableSimpleIF>(this.grids.size());
        for (GridDatatype grid : this.getGrids()) {
            if (grid.getVariable() == null) continue;
            result.add(grid.getVariable());
        }
        return result;
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        return this.ds.getRootGroup().findVariable(shortName);
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.ds;
    }

    private void addGeoGrid(VariableDS varDS, GridCoordSys gcs, Formatter parseInfo) {
        Gridset gridset = this.gridsetHash.get(gcs.getName());
        if (null == gridset) {
            gridset = new Gridset(gcs);
            this.gridsetHash.put(gcs.getName(), gridset);
            if (parseInfo != null) {
                parseInfo.format(" -make new GridCoordSys= %s\n", gcs.getName());
            }
            gcs.makeVerticalTransform(this, parseInfo);
        }
        GeoGrid geogrid = new GeoGrid(this, varDS, gridset.gcc);
        this.grids.add(geogrid);
        gridset.add(geogrid);
    }

    public String getName() {
        String loc = this.ds.getLocation();
        int pos = loc.lastIndexOf(47);
        if (pos < 0) {
            pos = loc.lastIndexOf(92);
        }
        return pos < 0 ? loc : loc.substring(pos + 1);
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ds;
    }

    @Override
    public List<GridDatatype> getGrids() {
        return new ArrayList<GridDatatype>(this.grids);
    }

    @Override
    public GridDatatype findGridDatatype(String name) {
        return this.findGridByName(name);
    }

    @Override
    public List<GridDataset.Gridset> getGridsets() {
        return new ArrayList<GridDataset.Gridset>(this.gridsetHash.values());
    }

    public GeoGrid findGridByName(String fullName) {
        for (GeoGrid ggi : this.grids) {
            if (!fullName.equals(ggi.getFullName())) continue;
            return ggi;
        }
        return null;
    }

    @Override
    public GeoGrid findGridByShortName(String shortName) {
        for (GeoGrid ggi : this.grids) {
            if (!shortName.equals(ggi.getShortName())) continue;
            return ggi;
        }
        return null;
    }

    public GeoGrid findGridDatatypeByAttribute(String attName, String attValue) {
        for (GeoGrid ggi : this.grids) {
            for (Attribute att : ggi.getAttributes()) {
                if (!attName.equals(att.getName()) || !attValue.equals(att.getStringValue())) continue;
                return ggi;
            }
        }
        return null;
    }

    @Override
    public String getDetailInfo() {
        Formatter buff = new Formatter();
        this.getDetailInfo(buff);
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDetailInfo(Formatter buff) {
        this.getInfo(buff);
        buff.format("\n\n----------------------------------------------------\n", new Object[0]);
        NetcdfDatasetInfo info = null;
        try {
            info = new NetcdfDatasetInfo(this.ds.getLocation());
            buff.format("%s", info.getParseInfo());
        }
        catch (IOException e) {
            buff.format("NetcdfDatasetInfo failed", new Object[0]);
        }
        finally {
            if (info != null) {
                try {
                    info.close();
                }
                catch (IOException iOException) {}
            }
        }
        buff.format("\n\n----------------------------------------------------\n", new Object[0]);
        buff.format("%s", this.ds.toString());
        buff.format("\n\n----------------------------------------------------\n", new Object[0]);
    }

    private void getInfo(Formatter buf) {
        int countGridset = 0;
        for (Gridset gs : this.gridsetHash.values()) {
            GridCoordSystem gcs = gs.getGeoCoordSystem();
            buf.format("%nGridset %d  coordSys=%s", countGridset, gcs);
            buf.format(" LLbb=%s ", gcs.getLatLonBoundingBox());
            if (gcs.getProjection() != null && !gcs.getProjection().isLatLon()) {
                buf.format(" bb= %s", gcs.getBoundingBox());
            }
            buf.format("%n", new Object[0]);
            buf.format("Name__________________________Unit__________________________hasMissing_Description%n", new Object[0]);
            for (GridDatatype grid : gs.getGrids()) {
                buf.format("%s%n", grid.getInfo());
            }
            ++countGridset;
            buf.format("%n", new Object[0]);
        }
        buf.format("\nGeoReferencing Coordinate Axes\n", new Object[0]);
        buf.format("Name__________________________Units_______________Type______Description\n", new Object[0]);
        for (CoordinateAxis axis : this.ds.getCoordinateAxes()) {
            if (axis.getAxisType() == null) continue;
            axis.getInfo(buf);
            buf.format("\n", new Object[0]);
        }
    }

    @Override
    public FeatureType getFeatureType() {
        return FeatureType.GRID;
    }

    @Override
    public String getImplementationName() {
        return this.ds.getConventionUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.fileCache != null) {
            this.fileCache.release(this);
        } else {
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            finally {
                this.ds = null;
            }
        }
    }

    @Override
    public boolean sync() throws IOException {
        return this.ds != null ? this.ds.sync() : false;
    }

    @Override
    public void setFileCache(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public static GridDataset factory(String netcdfFileURI) throws IOException {
        return GridDataset.open(netcdfFileURI);
    }

    public class Gridset
    implements GridDataset.Gridset {
        private GridCoordSys gcc;
        private List<GridDatatype> grids = new ArrayList<GridDatatype>();

        private Gridset(GridCoordSys gcc) {
            this.gcc = gcc;
        }

        private void add(GeoGrid grid) {
            this.grids.add(grid);
        }

        @Override
        public List<GridDatatype> getGrids() {
            return this.grids;
        }

        @Override
        public GridCoordSystem getGeoCoordSystem() {
            return this.gcc;
        }

        public GridCoordSys getGeoCoordSys() {
            return this.gcc;
        }
    }
}

