/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import ucar.ma2.Array;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;

public class GridAsPointDataset {
    private List<GridDatatype> grids;
    private List<CalendarDate> dates;

    public GridAsPointDataset(List<GridDatatype> grids) {
        this.grids = grids;
        HashSet<CalendarDate> dateHash = new HashSet<CalendarDate>();
        ArrayList<CoordinateAxis1DTime> timeAxes = new ArrayList<CoordinateAxis1DTime>();
        for (GridDatatype grid : grids) {
            GridCoordSystem gcs = grid.getCoordinateSystem();
            CoordinateAxis1DTime timeAxis = gcs.getTimeAxis1D();
            if (timeAxis == null || timeAxes.contains(timeAxis)) continue;
            timeAxes.add(timeAxis);
            List<CalendarDate> timeDates = timeAxis.getCalendarDates();
            for (CalendarDate timeDate : timeDates) {
                dateHash.add(timeDate);
            }
        }
        this.dates = Arrays.asList(dateHash.toArray(new CalendarDate[dateHash.size()]));
        Collections.sort(this.dates);
    }

    public List<CalendarDate> getDates() {
        return this.dates;
    }

    public boolean hasTime(GridDatatype grid, CalendarDate date) {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1DTime timeAxis = gcs.getTimeAxis1D();
        return timeAxis != null && timeAxis.hasCalendarDate(date);
    }

    public double getMissingValue(GridDatatype grid) {
        return Double.NaN;
    }

    public Point readData(GridDatatype grid, CalendarDate date, double lat, double lon) throws IOException {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        int tidx = -1;
        if (date != null) {
            tidx = this.findTimeIndexForCalendarDate(gcs, date);
        }
        int[] xy = gcs.findXYindexFromLatLon(lat, lon, null);
        Array data = grid.readDataSlice(tidx, -1, xy[1], xy[0]);
        LatLonPoint latlon = gcs.getLatLon(xy[0], xy[1]);
        Point p = new Point();
        p.lat = latlon.getLatitude();
        p.lon = latlon.getLongitude();
        p.dataValue = data.getDouble(data.getIndex());
        return p;
    }

    public boolean hasVert(GridDatatype grid, double zCoord) {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1D zAxis = gcs.getVerticalAxis();
        if (zAxis == null) {
            return false;
        }
        return zAxis.findCoordElement(zCoord) >= 0;
    }

    public Point readData(GridDatatype grid, CalendarDate date, double zCoord, double lat, double lon) throws IOException {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        int tidx = -1;
        if (date != null) {
            tidx = this.findTimeIndexForCalendarDate(gcs, date);
        }
        CoordinateAxis1D zAxis = gcs.getVerticalAxis();
        int zidx = zAxis.findCoordElement(zCoord);
        int[] xy = gcs.findXYindexFromLatLon(lat, lon, null);
        Array data = grid.readDataSlice(tidx, zidx, xy[1], xy[0]);
        LatLonPoint latlon = gcs.getLatLon(xy[0], xy[1]);
        Point p = new Point();
        p.lat = latlon.getLatitude();
        p.lon = latlon.getLongitude();
        p.z = zAxis.getCoordValue(zidx);
        p.dataValue = data.getDouble(data.getIndex());
        return p;
    }

    public Point readData(GridDatatype grid, CalendarDate date, double ensCoord, double zCoord, double lat, double lon) throws IOException {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        int tidx = -1;
        if (date != null) {
            tidx = this.findTimeIndexForCalendarDate(gcs, date);
        }
        Point p = new Point();
        int zidx = -1;
        if (zCoord != -1.0) {
            CoordinateAxis1D zAxis = gcs.getVerticalAxis();
            zidx = zAxis.findCoordElement(zCoord);
            p.z = zAxis.getCoordValue(zidx);
        }
        int eidx = -1;
        if (ensCoord != -1.0) {
            CoordinateAxis1D ensAxis = gcs.getEnsembleAxis();
            eidx = ensAxis.findCoordElement(ensCoord);
            p.ens = ensAxis.getCoordValue(eidx);
        }
        int[] xy = gcs.findXYindexFromLatLon(lat, lon, null);
        Array data = grid.readDataSlice(0, eidx, tidx, zidx, xy[1], xy[0]);
        LatLonPoint latlon = gcs.getLatLon(xy[0], xy[1]);
        p.lat = latlon.getLatitude();
        p.lon = latlon.getLongitude();
        p.dataValue = data.getDouble(data.getIndex());
        return p;
    }

    public Point readData(GridDatatype grid, CalendarDate date, EarthLocation location, boolean bounded) throws IOException {
        if (!bounded) {
            if (location.getAltitude() == Double.NaN) {
                return this.readData(grid, date, location.getLatitude(), location.getLongitude());
            }
            return this.readData(grid, date, location.getAltitude(), location.getLatitude(), location.getLongitude());
        }
        GridCoordSystem gcs = grid.getCoordinateSystem();
        int tidx = this.findTimeIndexForCalendarDate(gcs, date);
        int[] xy = gcs.findXYindexFromLatLonBounded(location.getLatitude(), location.getLongitude(), null);
        LatLonPoint latlon = gcs.getLatLon(xy[0], xy[1]);
        Point p = new Point();
        p.lat = latlon.getLatitude();
        p.lon = latlon.getLongitude();
        int zidx = -1;
        if (location.getAltitude() != Double.NaN) {
            CoordinateAxis1D zAxis = gcs.getVerticalAxis();
            zidx = zAxis.findCoordElement(location.getAltitude());
            p.z = zAxis.getCoordValue(zidx);
        }
        Array data = grid.readDataSlice(tidx, zidx, xy[1], xy[0]);
        p.dataValue = data.getDouble(data.getIndex());
        return p;
    }

    private int findTimeIndexForCalendarDate(GridCoordSystem gcs, CalendarDate date) {
        CoordinateAxis1DTime timeAxis = gcs.getTimeAxis1D();
        return timeAxis.findTimeIndexFromCalendarDate(date);
    }

    public static void main(String[] args) throws IOException {
        GridDataset gds = GridDataset.open("Q:/cdmUnitTest/transforms/Eumetsat.VerticalPerspective.grb");
        GridDatatype grid = gds.findGridDatatype("Pixel_scene_type");
        GridCoordSystem gcs = grid.getCoordinateSystem();
        double lat = 8.0;
        double lon = 21.0;
        int[] xy = gcs.findXYindexFromLatLon(lat, lon, null);
        Array data = grid.readDataSlice(0, 0, xy[1], xy[0]);
        double val = data.getDouble(0);
        System.out.printf("Value at %f %f == %f%n", lat, lon, val);
    }

    public class Point {
        public double lat;
        public double lon;
        public double z;
        public double ens;
        public double dataValue;
    }
}

