/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class NppConvention
extends CoordSysBuilder {
    private static final String SPECTRAL_COORD_NAME = "Surface_Emissivity_Wavelengths";
    private static final String PRESSURE_COORD_NAME = "Pressure_Levels";

    public static boolean isMine(NetcdfFile ncfile) {
        if (!ncfile.getFileTypeId().equals("HDF5")) {
            return false;
        }
        Group loc = ncfile.findGroup("All_Data/VIIRS-MOD-GEO-TC_All");
        if (loc == null) {
            loc = ncfile.findGroup("All_Data/VIIRS-CLD-AGG-GEO_All");
        }
        if (loc == null) {
            loc = ncfile.findGroup("All_Data");
            Attribute att = ncfile.findGlobalAttribute("Instrument_Name");
            if (att == null || !att.getStringValue().equals("CrIS")) {
                return false;
            }
            if (null == loc.findVariable(PRESSURE_COORD_NAME)) {
                return false;
            }
        }
        if (null == loc.findVariable("Latitude")) {
            return false;
        }
        return null != loc.findVariable("Longitude");
    }

    public NppConvention() {
        this.conventionName = "NPP/NPOESS";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        ds.addAttribute(null, new Attribute("FeatureType", FeatureType.IMAGE.toString()));
        boolean hasPressureLevels = false;
        Variable spectralCoord = null;
        Group group = ds.findGroup("All_Data/VIIRS-MOD-GEO-TC_All");
        if (group == null) {
            group = ds.findGroup("All_Data/VIIRS-CLD-AGG-GEO_All");
        }
        if (group == null) {
            group = ds.findGroup("All_Data");
            hasPressureLevels = true;
            spectralCoord = group.findVariable(SPECTRAL_COORD_NAME);
        }
        Variable lat = group.findVariable("Latitude");
        lat.addAttribute(new Attribute("units", "degrees_north"));
        lat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lon = group.findVariable("Longitude");
        lon.addAttribute(new Attribute("units", "degrees_east"));
        lon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int[] shape = lat.getShape();
        assert (shape.length == 2);
        Dimension scan = new Dimension("scan", shape[0]);
        Dimension xscan = new Dimension("xscan", shape[1]);
        group.addDimension(scan);
        group.addDimension(xscan);
        lat.setDimensions("scan xscan");
        lon.setDimensions("scan xscan");
        Dimension altd = null;
        if (hasPressureLevels) {
            Variable alt = group.findVariable(PRESSURE_COORD_NAME);
            alt.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            shape = alt.getShape();
            assert (shape.length == 1);
            altd = new Dimension(PRESSURE_COORD_NAME, shape[0]);
            group.addDimension(altd);
            alt.setDimensions(PRESSURE_COORD_NAME);
        }
        Dimension spectrald = null;
        if (null != spectralCoord) {
            spectralCoord.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Spectral.toString()));
            shape = spectralCoord.getShape();
            assert (shape.length == 1);
            spectrald = new Dimension(SPECTRAL_COORD_NAME, shape[0]);
            group.addDimension(spectrald);
            spectralCoord.setDimensions(SPECTRAL_COORD_NAME);
        }
        for (Variable v : group.getVariables()) {
            int[] vs = v.getShape();
            if (vs.length == 2 && vs[0] == scan.getLength() && vs[1] == xscan.getLength()) {
                v.setDimensions("scan xscan");
                v.addAttribute(new Attribute("_CoordinateAxes", "Latitude Longitude"));
                continue;
            }
            if (vs.length == 3 && altd != null && vs[0] == altd.getLength() && vs[1] == scan.getLength() && vs[2] == xscan.getLength()) {
                v.setDimensions("Pressure_Levels scan xscan");
                v.addAttribute(new Attribute("_CoordinateAxes", "Pressure_Levels Latitude Longitude"));
                continue;
            }
            if (vs.length != 3 || spectrald == null || vs[0] != spectrald.getLength() || vs[1] != scan.getLength() || vs[2] != xscan.getLength()) continue;
            v.setDimensions("Surface_Emissivity_Wavelengths scan xscan");
            v.addAttribute(new Attribute("_CoordinateAxes", "Surface_Emissivity_Wavelengths Latitude Longitude"));
        }
        ds.finish();
    }
}

