/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import ucar.nc2.NetcdfFile;

@Immutable
public class EnumTypedef {
    private final String name;
    private final Map<Integer, String> map;
    private ArrayList<String> enumStrings;

    public EnumTypedef(String name, Map<Integer, String> map) {
        this.name = NetcdfFile.makeValidCdmObjectName(name);
        this.map = map;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.name;
    }

    public List<String> getEnumStrings() {
        if (this.enumStrings != null) {
            this.enumStrings = new ArrayList<String>(this.map.values());
            Collections.sort(this.enumStrings);
        }
        return this.enumStrings;
    }

    public Map<Integer, String> getMap() {
        return this.map;
    }

    public String lookupEnumString(int e) {
        String result = this.map.get(e);
        return result == null ? "Unknown enum value=" + e : result;
    }

    public String writeCDL(boolean strict) {
        StringBuilder buff = new StringBuilder();
        String name = strict ? NetcdfFile.escapeNameCDL(this.getName()) : this.getName();
        buff.append("  enum ").append(name).append(" { ");
        int count = 0;
        List<Object> keyset = Arrays.asList(this.map.keySet().toArray());
        for (Object key : keyset) {
            String s = this.map.get(key);
            if (0 < count++) {
                buff.append(", ");
            }
            if (strict) {
                buff.append(NetcdfFile.escapeNameCDL(s)).append(" = ").append(key);
                continue;
            }
            buff.append("'").append(s).append("' = ").append(key);
        }
        buff.append("};");
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypedef that = (EnumTypedef)o;
        if (this.map != null ? !this.map.equals(that.map) : that.map != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.map != null ? this.map.hashCode() : 0);
        return result;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("EnumTypedef %s: ", this.name);
        for (int key : this.map.keySet()) {
            f.format("%d=%s,", key, this.map.get(key));
        }
        return f.toString();
    }
}

