/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import ucar.grib.grib2.ParameterTable;
import ucar.grid.GridParameter;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.unidata.util.StringUtil;

public class GribCodeTable
implements Comparable<GribCodeTable> {
    private static Map<String, GribCodeTable> tables;
    public String name;
    public int m1;
    public int m2;
    public boolean isParameter;
    public int discipline = -1;
    public int category = -1;
    public List<TableEntry> entries = new ArrayList<TableEntry>();
    private static int[] badones;
    static String resourceName;
    static boolean showDiff;

    public static TableEntry getEntry(int discipline, int category, int number) {
        GribCodeTable table = tables.get(GribCodeTable.getId(discipline, category));
        if (table == null) {
            return null;
        }
        return table.get(number);
    }

    private static String getId(int discipline, int category) {
        return discipline + "." + category;
    }

    GribCodeTable(String name) {
        this.name = name;
        String[] s = name.split(" ");
        String id = s[2];
        String[] slist2 = id.split("\\.");
        if (slist2.length == 2) {
            this.m1 = Integer.parseInt(slist2[0]);
            this.m2 = Integer.parseInt(slist2[1]);
        } else {
            System.out.println("HEY bad= %s%n" + name);
        }
    }

    GribCodeTable(String tableName, String subtableName) {
        String[] s = tableName.split(" ");
        String id = s[2];
        String[] slist2 = id.split("\\.");
        if (slist2.length == 2) {
            this.m1 = Integer.parseInt(slist2[0]);
            this.m2 = Integer.parseInt(slist2[1]);
        } else {
            System.out.println("HEY bad= %s%n" + this.name);
        }
        this.name = subtableName;
        String[] slist = this.name.split("[ :]+");
        try {
            for (int i = 0; i < slist.length; ++i) {
                if (slist[i].equalsIgnoreCase("discipline")) {
                    this.discipline = Integer.parseInt(slist[i + 1]);
                }
                if (!slist[i].equalsIgnoreCase("category")) continue;
                this.category = Integer.parseInt(slist[i + 1]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.isParameter = this.discipline >= 0 && this.category >= 0;
    }

    void add(String line, String code, String meaning, String unit, String status) {
        this.entries.add(new TableEntry(line, code, meaning, unit, status));
    }

    TableEntry get(int value) {
        for (TableEntry p : this.entries) {
            if (p.start != value) continue;
            return p;
        }
        return null;
    }

    @Override
    public int compareTo(GribCodeTable o) {
        if (this.m1 != o.m1) {
            return this.m1 - o.m1;
        }
        if (this.m2 != o.m2) {
            return this.m2 - o.m2;
        }
        if (this.discipline != o.discipline) {
            return this.discipline - o.discipline;
        }
        return this.category - o.category;
    }

    public String toString() {
        return "GribCodeTable{name='" + this.name + '\'' + ", m1=" + this.m1 + ", m2=" + this.m2 + ", isParameter=" + this.isParameter + ", discipline=" + this.discipline + ", category=" + this.category + '}';
    }

    private boolean remove(TableEntry entry) {
        for (int i = 0; i < badones.length; i += 3) {
            if (this.discipline != badones[i] || this.category != badones[i + 1] || entry.number != badones[i + 2]) continue;
            return true;
        }
        return false;
    }

    private static List<GribCodeTable> readGribCodes(InputStream ios) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(ios);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element root = doc.getRootElement();
        HashMap<String, GribCodeTable> map = new HashMap<String, GribCodeTable>();
        tables = new HashMap<String, GribCodeTable>();
        List featList = root.getChildren("ForExport_CodeFlag_E");
        for (Element elem : featList) {
            Element unitElem;
            String line = elem.getChildTextNormalize("No");
            String tableName = elem.getChildTextNormalize("TableTitle_E");
            String code = elem.getChildTextNormalize("CodeFlag");
            String meaning = elem.getChildTextNormalize("Meaning_E");
            GribCodeTable ct = (GribCodeTable)map.get(tableName);
            if (ct == null) {
                ct = new GribCodeTable(tableName);
                map.put(tableName, ct);
            }
            String unit = (unitElem = elem.getChild("AsciiUnit_x002F_Description_E")) == null ? null : unitElem.getTextNormalize();
            Element statusElem = elem.getChild("Status");
            String status = statusElem == null ? null : statusElem.getTextNormalize();
            Element subtableElem = elem.getChild("TableSubTitle_E");
            if (subtableElem != null) {
                String subTableName = subtableElem.getTextNormalize();
                GribCodeTable cst = (GribCodeTable)map.get(subTableName);
                if (cst == null) {
                    cst = new GribCodeTable(tableName, subTableName);
                    map.put(subTableName, cst);
                    tables.put(GribCodeTable.getId(cst.discipline, cst.category), cst);
                }
                cst.add(line, code, meaning, unit, status);
                continue;
            }
            ct.add(line, code, meaning, unit, status);
        }
        ios.close();
        ArrayList<GribCodeTable> tlist = new ArrayList<GribCodeTable>(map.values());
        Collections.sort(tlist);
        for (GribCodeTable gt : tlist) {
            Collections.sort(gt.entries);
        }
        return tlist;
    }

    public static Map<String, GribCodeTable> readGribCodes() throws IOException {
        Class<GribCodeTable> c = GribCodeTable.class;
        InputStream in = c.getResourceAsStream(resourceName);
        if (in == null) {
            System.out.printf("cant open %s%n", resourceName);
            return null;
        }
        List<GribCodeTable> tlist = GribCodeTable.readGribCodes(in);
        HashMap<String, GribCodeTable> map = new HashMap<String, GribCodeTable>(2 * tlist.size());
        for (GribCodeTable ct : tlist) {
            String id = ct.m1 + "." + ct.m2;
            if (ct.isParameter) {
                id = id + "." + ct.discipline + "." + ct.category;
            }
            map.put(id, ct);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GribCodeTable> getWmoStandard() throws IOException {
        Class<GribCodeTable> c = GribCodeTable.class;
        InputStream in = c.getResourceAsStream(resourceName);
        if (in == null) {
            System.out.printf("cant open %s%n", resourceName);
            return null;
        }
        try {
            List<GribCodeTable> list = GribCodeTable.readGribCodes(in);
            return list;
        }
        finally {
            in.close();
        }
    }

    public static void main(String[] arg) throws IOException {
        Class<GribCodeTable> c = GribCodeTable.class;
        InputStream in = c.getResourceAsStream(resourceName);
        if (in == null) {
            System.out.printf("cant open %s%n", resourceName);
            return;
        }
        List<GribCodeTable> tlist = GribCodeTable.readGribCodes(in);
        for (GribCodeTable gt : tlist) {
            System.out.printf("%d.%d (%d,%d) %s %n", gt.m1, gt.m2, gt.discipline, gt.category, gt.name);
            for (TableEntry p : gt.entries) {
                System.out.printf("  %s (%d-%d) = %s %n", p.code, p.start, p.stop, p.meaning);
            }
        }
        if (showDiff) {
            int total = 0;
            int nsame = 0;
            int nsameIgn = 0;
            int ndiff = 0;
            int unknown = 0;
            System.out.printf("DIFFERENCES with current parameter table", new Object[0]);
            for (GribCodeTable gt : tlist) {
                if (!gt.isParameter) continue;
                for (TableEntry p : gt.entries) {
                    boolean sameIgnore;
                    boolean same;
                    if (p.meaning.equalsIgnoreCase("Missing") || p.start != p.stop) continue;
                    GridParameter gp = ParameterTable.getParameter(gt.discipline, gt.category, p.start);
                    String paramDesc = gp.getDescription();
                    if (paramDesc.startsWith("Unknown")) {
                        ++unknown;
                    }
                    if (same = paramDesc.equals(p.meaning)) {
                        ++nsame;
                    }
                    if (sameIgnore = paramDesc.equalsIgnoreCase(p.meaning)) {
                        ++nsameIgn;
                    } else {
                        ++ndiff;
                    }
                    ++total;
                    String state = same ? "  " : (sameIgnore ? "* " : "**");
                    System.out.printf("%s%d %d %d%n %s%n %s%n", state, gt.discipline, gt.category, p.start, p.meaning, paramDesc);
                }
            }
            System.out.printf("Total=%d same=%d sameIgn=%d dif=%d unknown=%d%n", total, nsame, nsameIgn, ndiff, unknown);
        }
    }

    static {
        badones = new int[]{0, 1, 51, 0, 6, 25, 0, 19, 22, 0, 191, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 2, 2, 0, 0, 10, 191, 0};
        resourceName = "/resources/grib/wmo/GRIB2_5_2_0_CodeFlag_E.xml";
        showDiff = true;
    }

    public class TableEntry
    implements Comparable<TableEntry> {
        public int start;
        public int stop;
        public int line;
        public int number = -1;
        public String code;
        public String meaning;
        public String name;
        public String unit;
        public String status;

        TableEntry(String line, String code, String meaning, String unit, String status) {
            this.line = Integer.parseInt(line);
            this.code = code;
            this.meaning = meaning;
            this.status = status;
            try {
                int pos = code.indexOf(45);
                if (pos > 0) {
                    this.start = Integer.parseInt(code.substring(0, pos));
                    String stops = code.substring(pos + 1);
                    this.stop = Integer.parseInt(stops);
                } else {
                    this.stop = this.start = Integer.parseInt(code);
                    this.number = this.start;
                }
            }
            catch (Exception e) {
                this.start = -1;
                this.stop = 0;
            }
            if (GribCodeTable.this.isParameter) {
                if (GribCodeTable.this.remove(this)) {
                    int pos1 = meaning.indexOf(40);
                    int pos2 = meaning.indexOf(41);
                    if (pos1 > 0 && pos2 > 0) {
                        meaning = meaning.substring(0, pos1).trim();
                    }
                }
                meaning = StringUtil.replace((String)meaning, (char)'/', (String)"-");
                meaning = StringUtil.replace((String)meaning, (char)'.', (String)"p");
                meaning = StringUtil.remove((String)meaning, (int)40);
                meaning = StringUtil.remove((String)meaning, (int)41);
                this.name = N3iosp.createValidNetcdf3ObjectName(meaning);
                if (unit != null) {
                    if (unit.equalsIgnoreCase("Proportion")) {
                        unit = "";
                    }
                    if (unit.equalsIgnoreCase("Numeric")) {
                        unit = "";
                    }
                }
                this.unit = unit;
            }
        }

        @Override
        public int compareTo(TableEntry o) {
            return this.start - o.start;
        }

        public String toString() {
            return "TableEntry{, discipline=" + GribCodeTable.this.discipline + ", category=" + GribCodeTable.this.category + ", number=" + this.number + ", org='" + this.meaning + '\'' + ", name='" + this.name + '\'' + ", unit='" + this.unit + '\'' + ", status='" + this.status + '\'' + '}';
        }
    }
}

