/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.unidata.util.EscapeStrings;

public class ParsedSectionSpec {
    private static boolean debugSelector = false;
    public final Variable v;
    public final Section section;
    public ParsedSectionSpec child;

    public static ParsedSectionSpec parseVariableSection(NetcdfFile ncfile, String variableSection) throws InvalidRangeException {
        ParsedSectionSpec outerV;
        List tokes = EscapeStrings.tokenizeEscapedName((String)variableSection);
        if (tokes.size() == 0) {
            throw new IllegalArgumentException("empty sectionSpec = " + variableSection);
        }
        String selector = (String)tokes.get(0);
        ParsedSectionSpec current = outerV = ParsedSectionSpec.parseVariableSelector(ncfile, selector);
        for (int i = 1; i < tokes.size(); ++i) {
            selector = (String)tokes.get(i);
            current = current.child = ParsedSectionSpec.parseVariableSelector(current.v, selector);
        }
        return outerV;
    }

    private static ParsedSectionSpec parseVariableSelector(Object parent, String selector) throws InvalidRangeException {
        Section section;
        String varNameEsc;
        String indexSelect = null;
        int pos1 = EscapeStrings.indexOf((String)selector, (char)'(');
        if (pos1 < 0) {
            varNameEsc = selector;
        } else {
            varNameEsc = selector.substring(0, pos1);
            int pos2 = selector.indexOf(41, pos1 + 1);
            indexSelect = selector.substring(pos1, pos2);
        }
        if (debugSelector) {
            System.out.println(" parseVariableSection <" + selector + "> = <" + varNameEsc + ">, <" + indexSelect + ">");
        }
        Variable v = null;
        if (parent instanceof NetcdfFile) {
            NetcdfFile ncfile = (NetcdfFile)parent;
            v = ncfile.findVariable(varNameEsc);
        } else if (parent instanceof Structure) {
            Structure s = (Structure)parent;
            v = s.findVariable(NetcdfFile.unescapeName(varNameEsc));
        }
        if (v == null) {
            throw new IllegalArgumentException(" cant find variable: " + varNameEsc + " in selector=" + selector);
        }
        if (v.getDataType() == DataType.SEQUENCE) {
            indexSelect = null;
        }
        if (indexSelect != null) {
            section = new Section(indexSelect);
            section = Section.fill(section, v.getShape());
        } else {
            section = v.getShapeAsSection();
        }
        return new ParsedSectionSpec(v, section);
    }

    public static String makeSectionSpecString(Variable v, List<Range> ranges) throws InvalidRangeException {
        StringBuilder sb = new StringBuilder();
        ParsedSectionSpec.makeSpec(sb, v, ranges);
        return sb.toString();
    }

    private static List<Range> makeSpec(StringBuilder sb, Variable v, List<Range> orgRanges) throws InvalidRangeException {
        if (v.isMemberOfStructure()) {
            orgRanges = ParsedSectionSpec.makeSpec(sb, v.getParentStructure(), orgRanges);
            sb.append('.');
        }
        List<Range> ranges = orgRanges == null ? v.getRanges() : orgRanges;
        sb.append(v.isMemberOfStructure() ? NetcdfFile.escapeNameSectionSpec(v.getShortName()) : NetcdfFile.makeFullNameEscapedSectionSpec(v));
        if (!v.isVariableLength() && !v.isScalar()) {
            sb.append('(');
            for (int count = 0; count < v.getRank(); ++count) {
                Range r = ranges.get(count);
                if (r == null) {
                    r = new Range(0, v.getDimension(count).getLength());
                }
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(r.first());
                sb.append(':');
                sb.append(r.last());
                sb.append(':');
                sb.append(r.stride());
            }
            sb.append(')');
        }
        return orgRanges == null ? null : ranges.subList(v.getRank(), ranges.size());
    }

    private ParsedSectionSpec(Variable v, Section section) {
        this.v = v;
        this.section = section;
        this.child = null;
    }

    public String toString() {
        return "ParsedSectionSpec{v=" + this.v.getFullName() + ", section=" + this.section + ", child=" + this.child + '}';
    }
}

