/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.ClientIO;
import opendap.dap.DAPNode;
import opendap.dap.DataReadException;
import opendap.dap.PrimitiveVector;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;

public abstract class DVector
extends BaseType
implements ClientIO {
    private PrimitiveVector vals;
    private BaseType containedvar;

    public DVector() {
    }

    @Override
    public String getTypeName() {
        return "Vector";
    }

    public DVector(String n) {
        super(n);
    }

    public BaseType getContainerVar() {
        return this.containedvar;
    }

    public void setContainerVar(BaseType var) {
        if (this.containedvar != null) {
            throw new RuntimeException("DArray with multiple variables");
        }
        this.containedvar = var;
    }

    public int getLength() {
        if (this.vals == null) {
            return 0;
        }
        return this.vals.getLength();
    }

    public void setLength(int len) {
        this.vals.setLength(len);
    }

    public void addVariable(BaseType v) {
        this.vals = v.newPrimitiveVector();
        this.setEncodedName(v.getEncodedName());
        v.setParent(this);
        this.setContainerVar(v);
    }

    public PrimitiveVector getPrimitiveVector() {
        return this.vals;
    }

    @Override
    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.print(space + this.getTypeName());
        this.vals.printDecl(os, " ", print_semi, constrained);
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        os.print("{ ");
        this.vals.printVal(os, "");
        if (print_decl_p) {
            os.println("};");
        } else {
            os.print("}");
        }
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int length2;
        int length = source.readInt();
        if (!(this.vals instanceof BaseTypePrimitiveVector) && length != (length2 = source.readInt())) {
            throw new DataReadException("Inconsistent array length read: " + length + " != " + length2);
        }
        if (length < 0) {
            throw new DataReadException("Negative array length read.");
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(8);
        }
        this.vals.setLength(length);
        this.vals.deserialize(source, sv, statusUI);
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        int length = this.vals.getLength();
        sink.writeInt(length);
        if (!(this.vals instanceof BaseTypePrimitiveVector)) {
            sink.writeInt(length);
        }
        this.vals.externalize(sink);
    }

    @Override
    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DVector v = (DVector)super.cloneDAG(map);
        v.vals = (PrimitiveVector)DVector.cloneDAG(map, this.vals);
        v.containedvar = (BaseType)DVector.cloneDAG(map, this.containedvar);
        return v;
    }
}

