# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class FunctionVersionContentList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, service_sid, function_sid, sid):
        """
        Initialize the FunctionVersionContentList

        :param Version version: Version that contains the resource
        :param service_sid: The SID of the Service that the Function Version resource is associated with
        :param function_sid: The SID of the Function that is the parent of the Function Version
        :param sid: The unique string that identifies the Function Version resource

        :returns: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentList
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentList
        """
        super(FunctionVersionContentList, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, 'function_sid': function_sid, 'sid': sid, }

    def get(self):
        """
        Constructs a FunctionVersionContentContext

        :returns: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentContext
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentContext
        """
        return FunctionVersionContentContext(
            self._version,
            service_sid=self._solution['service_sid'],
            function_sid=self._solution['function_sid'],
            sid=self._solution['sid'],
        )

    def __call__(self):
        """
        Constructs a FunctionVersionContentContext

        :returns: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentContext
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentContext
        """
        return FunctionVersionContentContext(
            self._version,
            service_sid=self._solution['service_sid'],
            function_sid=self._solution['function_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Serverless.V1.FunctionVersionContentList>'


class FunctionVersionContentPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the FunctionVersionContentPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param service_sid: The SID of the Service that the Function Version resource is associated with
        :param function_sid: The SID of the Function that is the parent of the Function Version
        :param sid: The unique string that identifies the Function Version resource

        :returns: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentPage
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentPage
        """
        super(FunctionVersionContentPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of FunctionVersionContentInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentInstance
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentInstance
        """
        return FunctionVersionContentInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            function_sid=self._solution['function_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Serverless.V1.FunctionVersionContentPage>'


class FunctionVersionContentContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, service_sid, function_sid, sid):
        """
        Initialize the FunctionVersionContentContext

        :param Version version: Version that contains the resource
        :param service_sid: The SID of the Service to fetch the Function Version content from
        :param function_sid: The SID of the Function that is the parent of the Function Version content to fetch
        :param sid: The SID that identifies the Function Version content to fetch

        :returns: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentContext
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentContext
        """
        super(FunctionVersionContentContext, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, 'function_sid': function_sid, 'sid': sid, }
        self._uri = '/Services/{service_sid}/Functions/{function_sid}/Versions/{sid}/Content'.format(**self._solution)

    def fetch(self):
        """
        Fetch the FunctionVersionContentInstance

        :returns: The fetched FunctionVersionContentInstance
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return FunctionVersionContentInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            function_sid=self._solution['function_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Serverless.V1.FunctionVersionContentContext {}>'.format(context)


class FunctionVersionContentInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, service_sid, function_sid, sid):
        """
        Initialize the FunctionVersionContentInstance

        :returns: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentInstance
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentInstance
        """
        super(FunctionVersionContentInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'service_sid': payload.get('service_sid'),
            'function_sid': payload.get('function_sid'),
            'content': payload.get('content'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'service_sid': service_sid, 'function_sid': function_sid, 'sid': sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: FunctionVersionContentContext for this FunctionVersionContentInstance
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentContext
        """
        if self._context is None:
            self._context = FunctionVersionContentContext(
                self._version,
                service_sid=self._solution['service_sid'],
                function_sid=self._solution['function_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the Function Version resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the Function Version resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def service_sid(self):
        """
        :returns: The SID of the Service that the Function Version resource is associated with
        :rtype: unicode
        """
        return self._properties['service_sid']

    @property
    def function_sid(self):
        """
        :returns: The SID of the Function that is the parent of the Function Version
        :rtype: unicode
        """
        return self._properties['function_sid']

    @property
    def content(self):
        """
        :returns: The content of the Function Version resource
        :rtype: unicode
        """
        return self._properties['content']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the FunctionVersionContentInstance

        :returns: The fetched FunctionVersionContentInstance
        :rtype: twilio.rest.serverless.v1.service.function.function_version.function_version_content.FunctionVersionContentInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Serverless.V1.FunctionVersionContentInstance {}>'.format(context)
