# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor.aio import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementMetricAlertsStatusOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_metric_alerts_status_list(self, resource_group):
        response = await self.client.metric_alerts_status.list(
            resource_group_name=resource_group.name,
            rule_name="str",
            api_version="2024-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_metric_alerts_status_list_by_name(self, resource_group):
        response = await self.client.metric_alerts_status.list_by_name(
            resource_group_name=resource_group.name,
            rule_name="str",
            status_name="str",
            api_version="2024-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...
