Thank you so much for opening a PR for P9k! Many of our best features and segments have come from the community, and we are excited to see your contribution.

To help you make the best PR, here are some guidelines:

  - The `master` branch is our *stable* branch, and the `next` branch is our development branch. If you are submitting a bug fix, please file your PR against `master`. If it is a new feature, enhancement, segment, or something similar, please submit it against `next`. For more information, please see our [Developer's Guide](https://github.com/bhilburn/powerlevel9k/wiki/Developer's-Guide).
  - We maintain unit tests for segments and features in the `test` directory. Please add unit tests for anything new you have developed! If you aren't sure how to do this, go ahead and file your PR and ask for help!
  - For running manual tests in different environments, we have Vagrant and Docker configurations. Please see the [Test README](https://github.com/bhilburn/powerlevel9k/blob/next/TESTS.md) and make sure your new feature is working as expected!
  - If your PR requires user configuration, please make sure that it includes an update to the README describing this.
  - P9k maintains a lot of useful information in our [Wiki](https://github.com/bhilburn/powerlevel9k/wiki). Depending on the content of your PR, we might ask you to update the Wiki (or provide text for us to use) to document your work. Most PRs don't require this.
  - Please make your commit messages useful! Here is a [great short guide on useful commit messages](https://code.likeagirl.io/useful-tips-for-writing-better-git-commit-messages-808770609503).

Once you have submitted your PR, P9k core contributors will review the code and work with you to get it merged. During this process, we might request changes to your code and discuss different ways of doing things. This is all part of the open source process, and our goal is to help you create the best contribution possible for P9k `=)`.

Please follow this template for creating your PR:

#### Title

Please make the title of your PR descriptive! If appropriate, please prefix the title with one of these tags:

- [Bugfix]
- [New Segment]
- [Docs]
- [Enhancement]

#### Description

Please describe the contribution your PR makes! Screenshots are especially helpful, here, if it's a new segment.

If your PR is addressing an issue, please reference the Issue number here.

#### Questions

Is there something in your PR you're not sure about or need help with? Is there a particular piece of code you would like feedback on? Let us know here!
