/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.VerticalAlignment;

public class CommandTitle
extends SingleLineCommand2<TitledDiagram> {
    public CommandTitle() {
        super(CommandTitle.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandTitle.class.getName(), RegexLeaf.start(), new RegexLeaf("title"), new RegexLeaf("(?:[%s]*:[%s]*|[%s]+)"), new RegexOr(new RegexLeaf("TITLE1", "[%g](.*)[%g]"), new RegexLeaf("TITLE2", "(.*[%pLN_.].*)")), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram diagram, LineLocation location, RegexResult arg) {
        Display s = Display.getWithNewlines(arg.getLazzy("TITLE", 0));
        diagram.setTitle(DisplayPositionned.single(s, HorizontalAlignment.CENTER, VerticalAlignment.TOP));
        return CommandExecutionResult.ok();
    }
}

