/*
 *
 * Copyright (C) 2024, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhenyu Wang <wangzhenyu@kylinos.cn>
 *
 */

#include "../../kysdk-ukenv/src/currency.h"
#include "../../kysdk-ukenv/src/gsettingmonitor.h"
#include "../../kysdk-ukenv/src/usermanual.h"
#include <QtTest>

// add necessary includes here
using namespace kdk;

class UkenvTest : public QObject
{
    Q_OBJECT

private slots:
    void usermanualTest();
    void gsettingmonitorTest();
    void currencyTest();
};

void UkenvTest::usermanualTest()
{
    UserManual userManual;
    userManual.callUserManual("messages");
}

void UkenvTest::gsettingmonitorTest()
{
    GsettingMonitor *gsetting = GsettingMonitor::getInstance();
    gsetting->getSystemFontSize();
    gsetting->getSystemTransparency();
    gsetting->getSystemTheme();

    QObject::connect(GsettingMonitor::getInstance(), &GsettingMonitor::systemFontSizeChange, [=]() {
        qDebug() << "系统字号改变 : " << GsettingMonitor::getSystemFontSize();
    });

    QObject::connect(GsettingMonitor::getInstance(), &GsettingMonitor::systemThemeChange, [=]() {
        qDebug() << "系统主题改变 : " << GsettingMonitor::getSystemTheme();
    });

    QObject::connect(GsettingMonitor::getInstance(), &GsettingMonitor::systemTransparencyChange, [=]() {
        qDebug() << "系统透明度改变 : " << GsettingMonitor::getSystemTransparency();
    });

    //    emit GsettingMonitor::systemFontSizeChange();
    //    void systemTransparencyChange();
    //    void systemThemeChange();
}

void UkenvTest::currencyTest()
{
    Currency::getAppName(kdk::AppName::KylinFontViewer);
    Currency::getAppName(kdk::AppName::KylinCalculator);
    Currency::getAppName(kdk::AppName::KylinGpuController);
    Currency::getAppName(kdk::AppName::KylinMusic);
    Currency::getAppName(kdk::AppName::KylinWeather);
    Currency::getAppName(kdk::AppName::KylinPhotoViewer);
    Currency::getAppName(kdk::AppName::KylinServiceSupport);
    Currency::getAppName(kdk::AppName::KylinPrinter);
    Currency::getAppName(kdk::AppName::KylinCalendar);
    Currency::getAppName(kdk::AppName::KylinCamera);
    Currency::getAppName(kdk::AppName::KylinNotebook);
    Currency::getAppName(kdk::AppName::KylinOsManager);
    Currency::getAppName(kdk::AppName::KylinNetworkCheck);
    Currency::getAppName(kdk::AppName::KylinGallery);
    Currency::getAppName(kdk::AppName::KylinScanner);
    Currency::getAppName(kdk::AppName::KylinMobileAssistant);
    Currency::getAppName(kdk::AppName::KylinTest);
}

QTEST_APPLESS_MAIN(UkenvTest)

#include "ukenvtest.moc"
