/* SPDX-FileCopyrightText: 1998, 1999 Alex Roberts, Evan Lawrence
 * SPDX-FileCopyrightText: 2000, 2001 Chema Celorio, Paolo Maggi
 * SPDX-FileCopyrightText: 2002, 2003 Paolo Maggi
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_UNDO_MANAGER                (gtk_source_undo_manager_get_type ())
#define GTK_SOURCE_UNDO_MANAGER(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_UNDO_MANAGER, GtkSourceUndoManager))
#define GTK_SOURCE_IS_UNDO_MANAGER(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_UNDO_MANAGER))
#define GTK_SOURCE_UNDO_MANAGER_GET_INTERFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTK_SOURCE_TYPE_UNDO_MANAGER, GtkSourceUndoManagerIface))

typedef struct _GtkSourceUndoManager       GtkSourceUndoManager;
typedef struct _GtkSourceUndoManagerIface  GtkSourceUndoManagerIface;

struct _GtkSourceUndoManagerIface
{
	GTypeInterface parent;

	/* Interface functions */
	gboolean (*can_undo)                  (GtkSourceUndoManager *manager);
	gboolean (*can_redo)                  (GtkSourceUndoManager *manager);

	void     (*undo)                      (GtkSourceUndoManager *manager);
	void     (*redo)                      (GtkSourceUndoManager *manager);

	void     (*begin_not_undoable_action) (GtkSourceUndoManager *manager);
	void     (*end_not_undoable_action)   (GtkSourceUndoManager *manager);

	/* Signals */
	void     (*can_undo_changed)          (GtkSourceUndoManager *manager);
	void     (*can_redo_changed)          (GtkSourceUndoManager *manager);
};

G_MODULE_EXPORT
GType     gtk_source_undo_manager_get_type                  (void) G_GNUC_CONST;

G_MODULE_EXPORT
gboolean  gtk_source_undo_manager_can_undo                  (GtkSourceUndoManager *manager);

G_MODULE_EXPORT
gboolean  gtk_source_undo_manager_can_redo                  (GtkSourceUndoManager *manager);

G_MODULE_EXPORT
void      gtk_source_undo_manager_undo                      (GtkSourceUndoManager *manager);

G_MODULE_EXPORT
void      gtk_source_undo_manager_redo                      (GtkSourceUndoManager *manager);

G_MODULE_EXPORT
void      gtk_source_undo_manager_begin_not_undoable_action (GtkSourceUndoManager *manager);

G_MODULE_EXPORT
void      gtk_source_undo_manager_end_not_undoable_action   (GtkSourceUndoManager *manager);

G_MODULE_EXPORT
void      gtk_source_undo_manager_can_undo_changed          (GtkSourceUndoManager *manager);

G_MODULE_EXPORT
void      gtk_source_undo_manager_can_redo_changed          (GtkSourceUndoManager *manager);

G_END_DECLS
