/* -*- c++ -*- */
/*
 * Gqrx SDR: Software defined radio receiver powered by GNU Radio and Qt
 *           https://gqrx.dk/
 *
 * Copyright 2016 Alexandru Csete OZ9AEC.
 * Copyright 2017 Youssef Touil.
 *
 * Gqrx is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * Gqrx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Gqrx; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */
#pragma once

// New two-stage FIR decimator provided by Youssef

static const int d_2_r_2_len = 69;
static const float d_2_r_2_kernel[] =
{
     0.000399985734121014f,
     0.002073370222476234f,
     0.004853019240304940f,
     0.005977464755456102f,
     0.002625480716699286f,
    -0.002713628293157090f,
    -0.003379460736391527f,
     0.001637205667907783f,
     0.004080689203761314f,
    -0.000982433398470081f,
    -0.005119016867477646f,
     0.000177424749467386f,
     0.006424890506348696f,
     0.001008090651156955f,
    -0.007915926496343137f,
    -0.002717062331286239f,
     0.009511042111613645f,
     0.005077150379032227f,
    -0.011151300589456603f,
    -0.008251061374053964f,
     0.012781117215688672f,
     0.012490374909303374f,
    -0.014344287749952384f,
    -0.018209086168089920f,
     0.015778580923975386f,
     0.026178028229057050f,
    -0.017029165534577999f,
    -0.038051941291319488f,
     0.018060406839966188f,
     0.058210457193828925f,
    -0.018831122390764166f,
    -0.102778567522516130f,
     0.019291268777910851f,
     0.317182812089170980f,
     0.480536048712957740f,
     0.317182812089170980f,
     0.019291268777910851f,
    -0.102778567522516130f,
    -0.018831122390764166f,
     0.058210457193828925f,
     0.018060406839966188f,
    -0.038051941291319488f,
    -0.017029165534577999f,
     0.026178028229057050f,
     0.015778580923975386f,
    -0.018209086168089920f,
    -0.014344287749952384f,
     0.012490374909303374f,
     0.012781117215688672f,
    -0.008251061374053964f,
    -0.011151300589456603f,
     0.005077150379032227f,
     0.009511042111613645f,
    -0.002717062331286239f,
    -0.007915926496343137f,
     0.001008090651156955f,
     0.006424890506348696f,
     0.000177424749467386f,
    -0.005119016867477646f,
    -0.000982433398470081f,
     0.004080689203761314f,
     0.001637205667907783f,
    -0.003379460736391527f,
    -0.002713628293157090f,
     0.002625480716699286f,
     0.005977464755456102f,
     0.004853019240304940f,
     0.002073370222476234f,
     0.000399985734121014f
};

static const int d_4_r_4_len = 139;
static const float d_4_r_4_kernel[] =
{
     0.000042167047949931f,
     0.000162480875041441f,
     0.000413474829003805f,
     0.000815488719349860f,
     0.001323484844111109f,
     0.001803932401530970f,
     0.002050805379425780f,
     0.001851476423100084f,
     0.001088358238163842f,
    -0.000165599354540670f,
    -0.001612840277093291f,
    -0.002799173360323900f,
    -0.003280737659419560f,
    -0.002830930204582274f,
    -0.001589296551711622f,
    -0.000060142418430366f,
     0.001072157673911288f,
     0.001252059507347206f,
     0.000346781210023729f,
    -0.001233491421169468f,
    -0.002682865592015316f,
    -0.003178340139233828f,
    -0.002320119390193667f,
    -0.000402092792444196f,
     0.001661437823975322f,
     0.002761727219457103f,
     0.002186981534424376f,
     0.000071307331744879f,
    -0.002570893712874658f,
    -0.004301512250227543f,
    -0.004015094439084645f,
    -0.001606879839533175f,
     0.001838674337622738f,
     0.004510048531846937f,
     0.004804547613530567f,
     0.002266863620581679f,
    -0.002004704037111716f,
    -0.005785548895574678f,
    -0.006849655924079080f,
    -0.004239720077392586f,
     0.001024318787772757f,
     0.006275193248599259f,
     0.008511512338709764f,
     0.006070603106211769f,
    -0.000247611530141919f,
    -0.007317511868656072f,
    -0.011170336815604164f,
    -0.009152698013614463f,
    -0.001621157345452147f,
     0.007851435931989321f,
     0.014073238852672171f,
     0.012972692080589394f,
     0.004087473189926854f,
    -0.008634954375856124f,
    -0.018413964067748419f,
    -0.019050011539439745f,
    -0.008545626179408438f,
     0.009039966712164142f,
     0.024793283315122296f,
     0.029034181171149441f,
     0.016560363014866013f,
    -0.009522346448795137f,
    -0.037569562545468192f,
    -0.051411140638474247f,
    -0.037221789978391415f,
     0.009679493935209005f,
     0.081286213859684806f,
     0.158552299980228740f,
     0.217917169253869340f,
     0.240164834839879550f,
     0.217917169253869340f,
     0.158552299980228740f,
     0.081286213859684806f,
     0.009679493935209005f,
    -0.037221789978391415f,
    -0.051411140638474247f,
    -0.037569562545468192f,
    -0.009522346448795137f,
     0.016560363014866013f,
     0.029034181171149441f,
     0.024793283315122296f,
     0.009039966712164142f,
    -0.008545626179408438f,
    -0.019050011539439745f,
    -0.018413964067748419f,
    -0.008634954375856124f,
     0.004087473189926854f,
     0.012972692080589394f,
     0.014073238852672171f,
     0.007851435931989321f,
    -0.001621157345452147f,
    -0.009152698013614463f,
    -0.011170336815604164f,
    -0.007317511868656072f,
    -0.000247611530141919f,
     0.006070603106211769f,
     0.008511512338709764f,
     0.006275193248599259f,
     0.001024318787772757f,
    -0.004239720077392586f,
    -0.006849655924079080f,
    -0.005785548895574678f,
    -0.002004704037111716f,
     0.002266863620581679f,
     0.004804547613530567f,
     0.004510048531846937f,
     0.001838674337622738f,
    -0.001606879839533175f,
    -0.004015094439084645f,
    -0.004301512250227543f,
    -0.002570893712874658f,
     0.000071307331744879f,
     0.002186981534424376f,
     0.002761727219457103f,
     0.001661437823975322f,
    -0.000402092792444196f,
    -0.002320119390193667f,
    -0.003178340139233828f,
    -0.002682865592015316f,
    -0.001233491421169468f,
     0.000346781210023729f,
     0.001252059507347206f,
     0.001072157673911288f,
    -0.000060142418430366f,
    -0.001589296551711622f,
    -0.002830930204582274f,
    -0.003280737659419560f,
    -0.002799173360323900f,
    -0.001612840277093291f,
    -0.000165599354540670f,
     0.001088358238163842f,
     0.001851476423100084f,
     0.002050805379425780f,
     0.001803932401530970f,
     0.001323484844111109f,
     0.000815488719349860f,
     0.000413474829003805f,
     0.000162480875041441f,
     0.000042167047949931f
};

static const int d_8_r_8_len = 280;
static const float d_8_r_8_kernel[] =
{
     0.000005299484859782f,
     0.000023653198869943f,
     0.000045443155025411f,
     0.000086660616597102f,
     0.000145468147843215f,
     0.000227646032445337f,
     0.000334591194217999f,
     0.000466890457500183f,
     0.000622018386430552f,
     0.000794466626663634f,
     0.000975304575250323f,
     0.001152454785657775f,
     0.001311296864337127f,
     0.001435783630074849f,
     0.001509953148215840f,
     0.001519741581366084f,
     0.001454903824191261f,
     0.001310813201213376f,
     0.001089882810057675f,
     0.000802361759738747f,
     0.000466304093914126f,
     0.000106589241438445f,
    -0.000247017317721992f,
    -0.000562646941659305f,
    -0.000809708828030606f,
    -0.000962510996013040f,
    -0.001003685261621032f,
    -0.000926952775265634f,
    -0.000738799897838057f,
    -0.000458730744403599f,
    -0.000117916487516219f,
     0.000243742648939376f,
     0.000581911777806535f,
     0.000853035291692318f,
     0.001019866746633974f,
     0.001056611000192218f,
     0.000952962453331239f,
     0.000716408838645576f,
     0.000372351073038558f,
    -0.000038150274869667f,
    -0.000462881782404900f,
    -0.000844797294892937f,
    -0.001129425716907750f,
    -0.001272432677940103f,
    -0.001246307890160262f,
    -0.001045192378203970f,
    -0.000687044203214210f,
    -0.000212653183490116f,
     0.000318579724580746f,
     0.000835734644546107f,
     0.001265542439063603f,
     0.001542487733459282f,
     0.001618487960413105f,
     0.001470755262270050f,
     0.001106608046232222f,
     0.000564346197878288f,
    -0.000090197750452171f,
    -0.000771230463597417f,
    -0.001383890554706424f,
    -0.001837132239362339f,
    -0.002056896211703681f,
    -0.001997709076123834f,
    -0.001650953765714851f,
    -0.001048413504576680f,
    -0.000260276733547870f,
     0.000612469118131840f,
     0.001450527381084600f,
     0.002132190093380017f,
     0.002550584440683641f,
     0.002629881881769309f,
     0.002338080196576415f,
     0.001694308341293216f,
     0.000769260408641065f,
    -0.000321736170028782f,
    -0.001432485915523021f,
    -0.002404976322971185f,
    -0.003091310085438950f,
    -0.003375549372556256f,
    -0.003192330168178722f,
    -0.002539372888669491f,
    -0.001481713556478757f,
    -0.000146533823587781f,
     0.001291251516558131f,
     0.002631154368260663f,
     0.003674321213032700f,
     0.004252198884660451f,
     0.004252637433548458f,
     0.003639528435255283f,
     0.002462762274858131f,
     0.000856475239499534f,
    -0.000974892854265319f,
    -0.002781496880057425f,
    -0.004301065594668099f,
    -0.005295755541230454f,
    -0.005587859925192526f,
    -0.005089203765495300f,
    -0.003819632950038145f,
    -0.001911267954229858f,
     0.000402995000090862f,
     0.002816115056235722f,
     0.004985868963592199f,
     0.006581423530514738f,
     0.007331423828496663f,
     0.007066900231758860f,
     0.005752595831756849f,
     0.003501526672561130f,
     0.000569595914029656f,
    -0.002670342281476470f,
    -0.005772755486290897f,
    -0.008277141861910673f,
    -0.009772095428011296f,
    -0.009957304065452081f,
    -0.008694779007964944f,
    -0.006041501906687299f,
    -0.002257673645446692f,
     0.002212348869418207f,
     0.006785874581560984f,
     0.010810304734210376f,
     0.013646746123386143f,
     0.014758915386036504f,
     0.013796112346034117f,
     0.010659097540521932f,
     0.005539210274923477f,
    -0.001076115841043161f,
    -0.008434444147245189f,
    -0.015584625308516726f,
    -0.021472430244782261f,
    -0.025055744331654087f,
    -0.025426655616721288f,
    -0.021926322954481325f,
    -0.014238733805135361f,
    -0.002451384366749276f,
     0.012925647002682830f,
     0.030986186274100380f,
     0.050498778538203032f,
     0.070015421670629074f,
     0.088007266252761618f,
     0.103012981470773550f,
     0.113783757663955240f,
     0.119409036455313980f,
     0.119409036455313980f,
     0.113783757663955240f,
     0.103012981470773550f,
     0.088007266252761618f,
     0.070015421670629074f,
     0.050498778538203032f,
     0.030986186274100380f,
     0.012925647002682830f,
    -0.002451384366749276f,
    -0.014238733805135361f,
    -0.021926322954481325f,
    -0.025426655616721288f,
    -0.025055744331654087f,
    -0.021472430244782261f,
    -0.015584625308516726f,
    -0.008434444147245189f,
    -0.001076115841043161f,
     0.005539210274923477f,
     0.010659097540521932f,
     0.013796112346034117f,
     0.014758915386036504f,
     0.013646746123386143f,
     0.010810304734210376f,
     0.006785874581560984f,
     0.002212348869418207f,
    -0.002257673645446692f,
    -0.006041501906687299f,
    -0.008694779007964944f,
    -0.009957304065452081f,
    -0.009772095428011296f,
    -0.008277141861910673f,
    -0.005772755486290897f,
    -0.002670342281476470f,
     0.000569595914029656f,
     0.003501526672561130f,
     0.005752595831756849f,
     0.007066900231758860f,
     0.007331423828496663f,
     0.006581423530514738f,
     0.004985868963592199f,
     0.002816115056235722f,
     0.000402995000090862f,
    -0.001911267954229858f,
    -0.003819632950038145f,
    -0.005089203765495300f,
    -0.005587859925192526f,
    -0.005295755541230454f,
    -0.004301065594668099f,
    -0.002781496880057425f,
    -0.000974892854265319f,
     0.000856475239499534f,
     0.002462762274858131f,
     0.003639528435255283f,
     0.004252637433548458f,
     0.004252198884660451f,
     0.003674321213032700f,
     0.002631154368260663f,
     0.001291251516558131f,
    -0.000146533823587781f,
    -0.001481713556478757f,
    -0.002539372888669491f,
    -0.003192330168178722f,
    -0.003375549372556256f,
    -0.003091310085438950f,
    -0.002404976322971185f,
    -0.001432485915523021f,
    -0.000321736170028782f,
     0.000769260408641065f,
     0.001694308341293216f,
     0.002338080196576415f,
     0.002629881881769309f,
     0.002550584440683641f,
     0.002132190093380017f,
     0.001450527381084600f,
     0.000612469118131840f,
    -0.000260276733547870f,
    -0.001048413504576680f,
    -0.001650953765714851f,
    -0.001997709076123834f,
    -0.002056896211703681f,
    -0.001837132239362339f,
    -0.001383890554706424f,
    -0.000771230463597417f,
    -0.000090197750452171f,
     0.000564346197878288f,
     0.001106608046232222f,
     0.001470755262270050f,
     0.001618487960413105f,
     0.001542487733459282f,
     0.001265542439063603f,
     0.000835734644546107f,
     0.000318579724580746f,
    -0.000212653183490116f,
    -0.000687044203214210f,
    -0.001045192378203970f,
    -0.001246307890160262f,
    -0.001272432677940103f,
    -0.001129425716907750f,
    -0.000844797294892937f,
    -0.000462881782404900f,
    -0.000038150274869667f,
     0.000372351073038558f,
     0.000716408838645576f,
     0.000952962453331239f,
     0.001056611000192218f,
     0.001019866746633974f,
     0.000853035291692318f,
     0.000581911777806535f,
     0.000243742648939376f,
    -0.000117916487516219f,
    -0.000458730744403599f,
    -0.000738799897838057f,
    -0.000926952775265634f,
    -0.001003685261621032f,
    -0.000962510996013040f,
    -0.000809708828030606f,
    -0.000562646941659305f,
    -0.000247017317721992f,
     0.000106589241438445f,
     0.000466304093914126f,
     0.000802361759738747f,
     0.001089882810057675f,
     0.001310813201213376f,
     0.001454903824191261f,
     0.001519741581366084f,
     0.001509953148215840f,
     0.001435783630074849f,
     0.001311296864337127f,
     0.001152454785657775f,
     0.000975304575250323f,
     0.000794466626663634f,
     0.000622018386430552f,
     0.000466890457500183f,
     0.000334591194217999f,
     0.000227646032445337f,
     0.000145468147843215f,
     0.000086660616597102f,
     0.000045443155025411f,
     0.000023653198869943f,
     0.000005299484859782f
};

static const int d_16_r_8_len = 54;
static const float d_16_r_8_kernel[] =
{
    -0.000010553664672862f,
    -0.000061498701563991f,
    -0.000169601122616288f,
    -0.000389180581238296f,
    -0.000769984128346191f,
    -0.001370862255977838f,
    -0.002239657737237394f,
    -0.003399895346870093f,
    -0.004830710741492023f,
    -0.006448450828431843f,
    -0.008091858901382079f,
    -0.009515843884697457f,
    -0.010397443295914180f,
    -0.010356613550454467f,
    -0.008992200646607676f,
    -0.005930785604319544f,
    -0.000883275448312690f,
     0.006298249742162992f,
     0.015572313369334116f,
     0.026677316967261836f,
     0.039125602626276818f,
     0.052226529544645239f,
     0.065138652777540620f,
     0.076946528099683636f,
     0.086753462256061120f,
     0.093778457566739207f,
     0.097444274566674538f,
     0.097444274566674538f,
     0.093778457566739207f,
     0.086753462256061120f,
     0.076946528099683636f,
     0.065138652777540620f,
     0.052226529544645239f,
     0.039125602626276818f,
     0.026677316967261836f,
     0.015572313369334116f,
     0.006298249742162992f,
    -0.000883275448312690f,
    -0.005930785604319544f,
    -0.008992200646607676f,
    -0.010356613550454467f,
    -0.010397443295914180f,
    -0.009515843884697457f,
    -0.008091858901382079f,
    -0.006448450828431843f,
    -0.004830710741492023f,
    -0.003399895346870093f,
    -0.002239657737237394f,
    -0.001370862255977838f,
    -0.000769984128346191f,
    -0.000389180581238296f,
    -0.000169601122616288f,
    -0.000061498701563991f,
    -0.000010553664672862f
};

static const int d_32_r_16_len = 107;
static const float d_32_r_16_kernel[] =
{
    -0.000004024163639795f,
    -0.000017672975608646f,
    -0.000028369983125930f,
    -0.000051841257358260f,
    -0.000084114931088978f,
    -0.000130374705334955f,
    -0.000193165706690690f,
    -0.000276282392544972f,
    -0.000383294466797586f,
    -0.000517836385761646f,
    -0.000683246849920059f,
    -0.000882378788952720f,
    -0.001117308161626894f,
    -0.001389043294976996f,
    -0.001697213461428019f,
    -0.002039760314912465f,
    -0.002412643435722481f,
    -0.002809577646098091f,
    -0.003221818992095683f,
    -0.003638016956253216f,
    -0.004044149516577933f,
    -0.004423556043039536f,
    -0.004757080371798020f,
    -0.005023332869090757f,
    -0.005199075945795754f,
    -0.005259732456805450f,
    -0.005180010907146506f,
    -0.004934635615957972f,
    -0.004499164222082719f,
    -0.003850869437258024f,
    -0.002969657050308204f,
    -0.001838988139263688f,
    -0.000446770521598867f,
     0.001213817123243464f,
     0.003143605116121320f,
     0.005336851770962665f,
     0.007780833517050342f,
     0.010455633416035585f,
     0.013334149150643793f,
     0.016382334116677784f,
     0.019559676833852839f,
     0.022819914826782396f,
     0.026111969807273771f,
     0.029381081811115123f,
     0.032570111325119062f,
     0.035620970792186964f,
     0.038476140562399175f,
     0.041080219701286683f,
     0.043381459308086866f,
     0.045333225316341701f,
     0.046895339212960678f,
     0.048035248704517766f,
     0.048728985952954711f,
     0.048961878385199747f,
     0.048728985952954711f,
     0.048035248704517766f,
     0.046895339212960678f,
     0.045333225316341701f,
     0.043381459308086866f,
     0.041080219701286683f,
     0.038476140562399175f,
     0.035620970792186964f,
     0.032570111325119062f,
     0.029381081811115123f,
     0.026111969807273771f,
     0.022819914826782396f,
     0.019559676833852839f,
     0.016382334116677784f,
     0.013334149150643793f,
     0.010455633416035585f,
     0.007780833517050342f,
     0.005336851770962665f,
     0.003143605116121320f,
     0.001213817123243464f,
    -0.000446770521598867f,
    -0.001838988139263688f,
    -0.002969657050308204f,
    -0.003850869437258024f,
    -0.004499164222082719f,
    -0.004934635615957972f,
    -0.005180010907146506f,
    -0.005259732456805450f,
    -0.005199075945795754f,
    -0.005023332869090757f,
    -0.004757080371798020f,
    -0.004423556043039536f,
    -0.004044149516577933f,
    -0.003638016956253216f,
    -0.003221818992095683f,
    -0.002809577646098091f,
    -0.002412643435722481f,
    -0.002039760314912465f,
    -0.001697213461428019f,
    -0.001389043294976996f,
    -0.001117308161626894f,
    -0.000882378788952720f,
    -0.000683246849920059f,
    -0.000517836385761646f,
    -0.000383294466797586f,
    -0.000276282392544972f,
    -0.000193165706690690f,
    -0.000130374705334955f,
    -0.000084114931088978f,
    -0.000051841257358260f,
    -0.000028369983125930f,
    -0.000017672975608646f,
    -0.000004024163639795f
};

static const int d_64_r_32_len = 212;
static const float d_64_r_32_kernel[] =
{
    -0.000004403823942508f,
    -0.000008963059919890f,
    -0.000007276052892980f,
    -0.000013448546764569f,
    -0.000016407338246392f,
    -0.000022821877811828f,
    -0.000029059859493782f,
    -0.000037502053326083f,
    -0.000047050128769168f,
    -0.000058647705667398f,
    -0.000072066821233235f,
    -0.000087775432302674f,
    -0.000105848488644829f,
    -0.000126598475702349f,
    -0.000150205141042045f,
    -0.000176926965601505f,
    -0.000206973701715915f,
    -0.000240575602493366f,
    -0.000277937749971926f,
    -0.000319260777052827f,
    -0.000364722541989086f,
    -0.000414482134953896f,
    -0.000468670554403767f,
    -0.000527388854339363f,
    -0.000590701722925615f,
    -0.000658633566464172f,
    -0.000731163061150287f,
    -0.000808218604975926f,
    -0.000889673345622962f,
    -0.000975340650633742f,
    -0.001064969616730599f,
    -0.001158240957389821f,
    -0.001254763178484453f,
    -0.001354069203096897f,
    -0.001455613461052586f,
    -0.001558769541846508f,
    -0.001662828458596891f,
    -0.001766997597152117f,
    -0.001870400403116935f,
    -0.001972076865069115f,
    -0.002070984841172726f,
    -0.002166002272448999f,
    -0.002255930317598858f,
    -0.002339497436442704f,
    -0.002415364439683740f,
    -0.002482130514177367f,
    -0.002538340220525754f,
    -0.002582491452580508f,
    -0.002613044332960035f,
    -0.002628431011812668f,
    -0.002627066321370591f,
    -0.002607359228695053f,
    -0.002567725018271331f,
    -0.002506598123060911f,
    -0.002422445514576562f,
    -0.002313780550524778f,
    -0.002179177170034060f,
    -0.002017284317828416f,
    -0.001826840471286680f,
    -0.001606688137875605f,
    -0.001355788185007890f,
    -0.001073233860638388f,
    -0.000758264360902667f,
    -0.000410277798843436f,
    -0.000028843430628706f,
     0.000386287004249912f,
     0.000835168966487215f,
     0.001317655958647924f,
     0.001833391650175865f,
     0.002381803404668191f,
     0.002962097316406667f,
     0.003573254853063226f,
     0.004214031187543062f,
     0.004882955288187807f,
     0.005578331822331469f,
     0.006298244909815173f,
     0.007040563748502659f,
     0.007802950114525442f,
     0.008582867722817980f,
     0.009377593413961051f,
     0.010184230117287451f,
     0.010999721518727896f,
     0.011820868346749476f,
     0.012644346170734195f,
     0.013466724590201118f,
     0.014284487677241258f,
     0.015094055520281103f,
     0.015891806704001060f,
     0.016674101548252919f,
     0.017437305919088521f,
     0.018177815416425963f,
     0.018892079736813970f,
     0.019576627004361302f,
     0.020228087861972253f,
     0.020843219113185100f,
     0.021418926707647539f,
     0.021952287867040517f,
     0.022440572154110033f,
     0.022881261295670835f,
     0.023272067580484536f,
     0.023610950665041715f,
     0.023896132633698622f,
     0.024126111175283287f,
     0.024299670755100852f,
     0.024415891678976044f,
     0.024474156966027200f,
     0.024474156966027200f,
     0.024415891678976044f,
     0.024299670755100852f,
     0.024126111175283287f,
     0.023896132633698622f,
     0.023610950665041715f,
     0.023272067580484536f,
     0.022881261295670835f,
     0.022440572154110033f,
     0.021952287867040517f,
     0.021418926707647539f,
     0.020843219113185100f,
     0.020228087861972253f,
     0.019576627004361302f,
     0.018892079736813970f,
     0.018177815416425963f,
     0.017437305919088521f,
     0.016674101548252919f,
     0.015891806704001060f,
     0.015094055520281103f,
     0.014284487677241258f,
     0.013466724590201118f,
     0.012644346170734195f,
     0.011820868346749476f,
     0.010999721518727896f,
     0.010184230117287451f,
     0.009377593413961051f,
     0.008582867722817980f,
     0.007802950114525442f,
     0.007040563748502659f,
     0.006298244909815173f,
     0.005578331822331469f,
     0.004882955288187807f,
     0.004214031187543062f,
     0.003573254853063226f,
     0.002962097316406667f,
     0.002381803404668191f,
     0.001833391650175865f,
     0.001317655958647924f,
     0.000835168966487215f,
     0.000386287004249912f,
    -0.000028843430628706f,
    -0.000410277798843436f,
    -0.000758264360902667f,
    -0.001073233860638388f,
    -0.001355788185007890f,
    -0.001606688137875605f,
    -0.001826840471286680f,
    -0.002017284317828416f,
    -0.002179177170034060f,
    -0.002313780550524778f,
    -0.002422445514576562f,
    -0.002506598123060911f,
    -0.002567725018271331f,
    -0.002607359228695053f,
    -0.002627066321370591f,
    -0.002628431011812668f,
    -0.002613044332960035f,
    -0.002582491452580508f,
    -0.002538340220525754f,
    -0.002482130514177367f,
    -0.002415364439683740f,
    -0.002339497436442704f,
    -0.002255930317598858f,
    -0.002166002272448999f,
    -0.002070984841172726f,
    -0.001972076865069115f,
    -0.001870400403116935f,
    -0.001766997597152117f,
    -0.001662828458596891f,
    -0.001558769541846508f,
    -0.001455613461052586f,
    -0.001354069203096897f,
    -0.001254763178484453f,
    -0.001158240957389821f,
    -0.001064969616730599f,
    -0.000975340650633742f,
    -0.000889673345622962f,
    -0.000808218604975926f,
    -0.000731163061150287f,
    -0.000658633566464172f,
    -0.000590701722925615f,
    -0.000527388854339363f,
    -0.000468670554403767f,
    -0.000414482134953896f,
    -0.000364722541989086f,
    -0.000319260777052827f,
    -0.000277937749971926f,
    -0.000240575602493366f,
    -0.000206973701715915f,
    -0.000176926965601505f,
    -0.000150205141042045f,
    -0.000126598475702349f,
    -0.000105848488644829f,
    -0.000087775432302674f,
    -0.000072066821233235f,
    -0.000058647705667398f,
    -0.000047050128769168f,
    -0.000037502053326083f,
    -0.000029059859493782f,
    -0.000022821877811828f,
    -0.000016407338246392f,
    -0.000013448546764569f,
    -0.000007276052892980f,
    -0.000008963059919890f,
    -0.000004403823942508f
};

static const int d_128_r_32_len = 174;
static const float d_128_r_32_kernel[] =
{
    -0.000007703161797332f,
    -0.000007067232655723f,
    -0.000010206071983051f,
    -0.000014172048980291f,
    -0.000019092331824095f,
    -0.000025093561850217f,
    -0.000032309725460887f,
    -0.000040869410108629f,
    -0.000050902771287247f,
    -0.000062527941809152f,
    -0.000075857080877625f,
    -0.000090981984892608f,
    -0.000107979276021387f,
    -0.000126895337525829f,
    -0.000147750778600044f,
    -0.000170524898241214f,
    -0.000195159646270053f,
    -0.000221543901544016f,
    -0.000249517228886741f,
    -0.000278854334896464f,
    -0.000309268991706370f,
    -0.000340399096744052f,
    -0.000371811190567229f,
    -0.000402986592324930f,
    -0.000433326971103446f,
    -0.000462142048725246f,
    -0.000488656689255886f,
    -0.000512000649038707f,
    -0.000531217622524194f,
    -0.000545257474301118f,
    -0.000552987616398289f,
    -0.000553188077307909f,
    -0.000544565488882758f,
    -0.000525751232639430f,
    -0.000495318184744208f,
    -0.000451782034515639f,
    -0.000393620779029084f,
    -0.000319279140356296f,
    -0.000227190622760720f,
    -0.000115784771504684f,
     0.000016488581452787f,
     0.000171149664304299f,
     0.000349662890884785f,
     0.000553425442457719f,
     0.000783740497411292f,
     0.001041804838025221f,
     0.001328682064289453f,
     0.001645290145967291f,
     0.001992375608565783f,
     0.002370502036550272f,
     0.002780026279675712f,
     0.003221088947286086f,
     0.003693593686280741f,
     0.004197200680900796f,
     0.004731309996663634f,
     0.005295059011515552f,
     0.005887310701543637f,
     0.006506655780921748f,
     0.007151406625936390f,
     0.007819604696828528f,
     0.008509020566706571f,
     0.009217166946123657f,
     0.009941305011649831f,
     0.010678463067957514f,
     0.011425449071796635f,
     0.012178874660574504f,
     0.012935173457761552f,
     0.013690629889370804f,
     0.014441402554104810f,
     0.015183556958199267f,
     0.015913092956531424f,
     0.016625980278750660f,
     0.017318188813430120f,
     0.017985725593062503f,
     0.018624666516886546f,
     0.019231193320663705f,
     0.019801625228558870f,
     0.020332454367773867f,
     0.020820375812973399f,
     0.021262319920613983f,
     0.021655479285054610f,
     0.021997336565315176f,
     0.022285687008084795f,
     0.022518660515178174f,
     0.022694738600454345f,
     0.022812769691468757f,
     0.022871979661449618f,
     0.022871979661449618f,
     0.022812769691468757f,
     0.022694738600454345f,
     0.022518660515178174f,
     0.022285687008084795f,
     0.021997336565315176f,
     0.021655479285054610f,
     0.021262319920613983f,
     0.020820375812973399f,
     0.020332454367773867f,
     0.019801625228558870f,
     0.019231193320663705f,
     0.018624666516886546f,
     0.017985725593062503f,
     0.017318188813430120f,
     0.016625980278750660f,
     0.015913092956531424f,
     0.015183556958199267f,
     0.014441402554104810f,
     0.013690629889370804f,
     0.012935173457761552f,
     0.012178874660574504f,
     0.011425449071796635f,
     0.010678463067957514f,
     0.009941305011649831f,
     0.009217166946123657f,
     0.008509020566706571f,
     0.007819604696828528f,
     0.007151406625936390f,
     0.006506655780921748f,
     0.005887310701543637f,
     0.005295059011515552f,
     0.004731309996663634f,
     0.004197200680900796f,
     0.003693593686280741f,
     0.003221088947286086f,
     0.002780026279675712f,
     0.002370502036550272f,
     0.001992375608565783f,
     0.001645290145967291f,
     0.001328682064289453f,
     0.001041804838025221f,
     0.000783740497411292f,
     0.000553425442457719f,
     0.000349662890884785f,
     0.000171149664304299f,
     0.000016488581452787f,
    -0.000115784771504684f,
    -0.000227190622760720f,
    -0.000319279140356296f,
    -0.000393620779029084f,
    -0.000451782034515639f,
    -0.000495318184744208f,
    -0.000525751232639430f,
    -0.000544565488882758f,
    -0.000553188077307909f,
    -0.000552987616398289f,
    -0.000545257474301118f,
    -0.000531217622524194f,
    -0.000512000649038707f,
    -0.000488656689255886f,
    -0.000462142048725246f,
    -0.000433326971103446f,
    -0.000402986592324930f,
    -0.000371811190567229f,
    -0.000340399096744052f,
    -0.000309268991706370f,
    -0.000278854334896464f,
    -0.000249517228886741f,
    -0.000221543901544016f,
    -0.000195159646270053f,
    -0.000170524898241214f,
    -0.000147750778600044f,
    -0.000126895337525829f,
    -0.000107979276021387f,
    -0.000090981984892608f,
    -0.000075857080877625f,
    -0.000062527941809152f,
    -0.000050902771287247f,
    -0.000040869410108629f,
    -0.000032309725460887f,
    -0.000025093561850217f,
    -0.000019092331824095f,
    -0.000014172048980291f,
    -0.000010206071983051f,
    -0.000007067232655723f,
    -0.000007703161797332f
};

static const int d_256_r_64_len = 348;
static const float d_256_r_64_kernel[] =
{
    -0.000006032200297229f,
    -0.000002790586794678f,
    -0.000003423524464373f,
    -0.000004141892670381f,
    -0.000004959329780957f,
    -0.000005880953015414f,
    -0.000006916263845337f,
    -0.000008064028056128f,
    -0.000009336504822940f,
    -0.000010742797132820f,
    -0.000012302324525658f,
    -0.000014003128525449f,
    -0.000015868003792231f,
    -0.000017906061357310f,
    -0.000020111369902626f,
    -0.000022508204619172f,
    -0.000025093613992638f,
    -0.000027881953296601f,
    -0.000030875236885189f,
    -0.000034086060833210f,
    -0.000037517497377010f,
    -0.000041176665997414f,
    -0.000045067469478981f,
    -0.000049199353227621f,
    -0.000053568215176887f,
    -0.000058185242147041f,
    -0.000063047547807853f,
    -0.000068158618146586f,
    -0.000073517650784389f,
    -0.000079124725926570f,
    -0.000084976788235246f,
    -0.000091070103041806f,
    -0.000097399649098627f,
    -0.000103959504668590f,
    -0.000110738977492950f,
    -0.000117729935644196f,
    -0.000124919754739577f,
    -0.000132293212128623f,
    -0.000139836270835869f,
    -0.000147529334756596f,
    -0.000155353239032747f,
    -0.000163284378055491f,
    -0.000171298895948762f,
    -0.000179368841745378f,
    -0.000187464129074148f,
    -0.000195552549576070f,
    -0.000203599379753965f,
    -0.000211565351775375f,
    -0.000219411598860001f,
    -0.000227093646507866f,
    -0.000234565855614429f,
    -0.000241779257421431f,
    -0.000248682177854843f,
    -0.000255220180724547f,
    -0.000261335292980978f,
    -0.000266967862740791f,
    -0.000272054419087176f,
    -0.000276528686849870f,
    -0.000280322370041046f,
    -0.000283363923695878f,
    -0.000285578633373008f,
    -0.000286890694598539f,
    -0.000287220112764771f,
    -0.000286486063219693f,
    -0.000284603980740463f,
    -0.000281488659987540f,
    -0.000277051522643753f,
    -0.000271202733437524f,
    -0.000263850662609383f,
    -0.000254902132867105f,
    -0.000244261829079865f,
    -0.000231834561467387f,
    -0.000217522684614226f,
    -0.000201228717970838f,
    -0.000182854056621652f,
    -0.000162300101972573f,
    -0.000139467943568298f,
    -0.000114258627064630f,
    -0.000086574168670878f,
    -0.000056316612617103f,
    -0.000023389083735015f,
     0.000012303734435184f,
     0.000050856088211618f,
     0.000092360432854175f,
     0.000136906695012963f,
     0.000184583050199368f,
     0.000235474395169584f,
     0.000289663252276950f,
     0.000347228091667187f,
     0.000408244468331575f,
     0.000472783700962668f,
     0.000540912739938505f,
     0.000612694289527581f,
     0.000688186201030564f,
     0.000767440808596336f,
     0.000850505496981770f,
     0.000937421598757782f,
     0.001028224584686942f,
     0.001122943571650730f,
     0.001221601170177604f,
     0.001324213422447449f,
     0.001430788817328081f,
     0.001541329271676986f,
     0.001655828820474164f,
     0.001774273932442011f,
     0.001896643321221287f,
     0.002022907760579356f,
     0.002153029565104709f,
     0.002286963138555204f,
     0.002424654105591249f,
     0.002566039990527927f,
     0.002711049190015392f,
     0.002859602052878106f,
     0.003011609882021581f,
     0.003166975340851216f,
     0.003325592606007947f,
     0.003487347156138999f,
     0.003652115769225347f,
     0.003819766988190932f,
     0.003990160791661657f,
     0.004163149004759460f,
     0.004338575232032592f,
     0.004516275281704776f,
     0.004696077226065694f,
     0.004877801369702575f,
     0.005061261175365414f,
     0.005246262760259225f,
     0.005432605634097002f,
     0.005620082968897619f,
     0.005808481837004595f,
     0.005997583515661679f,
     0.006187164045980849f,
     0.006376994441064236f,
     0.006566841257680600f,
     0.006756466702660143f,
     0.006945629644096785f,
     0.007134085474240178f,
     0.007321586857189369f,
     0.007507884388699728f,
     0.007692726710717013f,
     0.007875861286146892f,
     0.008057034853723447f,
     0.008235993962285608f,
     0.008412485423992495f,
     0.008586256905270668f,
     0.008757057550423931f,
     0.008924638381879985f,
     0.009088752763977616f,
     0.009249157391806035f,
     0.009405612190690901f,
     0.009557881349450560f,
     0.009705733651032743f,
     0.009848943025250930f,
     0.009987289003226731f,
     0.010120557317645952f,
     0.010248540384643352f,
     0.010371037696321509f,
     0.010487856281889540f,
     0.010598811426250850f,
     0.010703726661456589f,
     0.010802434494593470f,
     0.010894776824678817f,
     0.010980605060844476f,
     0.011059780725514858f,
     0.011132175645830765f,
     0.011197672374601442f,
     0.011256164283833567f,
     0.011307555970121824f,
     0.011351763540287503f,
     0.011388714558166329f,
     0.011418348423280301f,
     0.011440616600089638f,
     0.011455482402780947f,
     0.011462921415360990f,
     0.011462921415360990f,
     0.011455482402780947f,
     0.011440616600089638f,
     0.011418348423280301f,
     0.011388714558166329f,
     0.011351763540287503f,
     0.011307555970121824f,
     0.011256164283833567f,
     0.011197672374601442f,
     0.011132175645830765f,
     0.011059780725514858f,
     0.010980605060844476f,
     0.010894776824678817f,
     0.010802434494593470f,
     0.010703726661456589f,
     0.010598811426250850f,
     0.010487856281889540f,
     0.010371037696321509f,
     0.010248540384643352f,
     0.010120557317645952f,
     0.009987289003226731f,
     0.009848943025250930f,
     0.009705733651032743f,
     0.009557881349450560f,
     0.009405612190690901f,
     0.009249157391806035f,
     0.009088752763977616f,
     0.008924638381879985f,
     0.008757057550423931f,
     0.008586256905270668f,
     0.008412485423992495f,
     0.008235993962285608f,
     0.008057034853723447f,
     0.007875861286146892f,
     0.007692726710717013f,
     0.007507884388699728f,
     0.007321586857189369f,
     0.007134085474240178f,
     0.006945629644096785f,
     0.006756466702660143f,
     0.006566841257680600f,
     0.006376994441064236f,
     0.006187164045980849f,
     0.005997583515661679f,
     0.005808481837004595f,
     0.005620082968897619f,
     0.005432605634097002f,
     0.005246262760259225f,
     0.005061261175365414f,
     0.004877801369702575f,
     0.004696077226065694f,
     0.004516275281704776f,
     0.004338575232032592f,
     0.004163149004759460f,
     0.003990160791661657f,
     0.003819766988190932f,
     0.003652115769225347f,
     0.003487347156138999f,
     0.003325592606007947f,
     0.003166975340851216f,
     0.003011609882021581f,
     0.002859602052878106f,
     0.002711049190015392f,
     0.002566039990527927f,
     0.002424654105591249f,
     0.002286963138555204f,
     0.002153029565104709f,
     0.002022907760579356f,
     0.001896643321221287f,
     0.001774273932442011f,
     0.001655828820474164f,
     0.001541329271676986f,
     0.001430788817328081f,
     0.001324213422447449f,
     0.001221601170177604f,
     0.001122943571650730f,
     0.001028224584686942f,
     0.000937421598757782f,
     0.000850505496981770f,
     0.000767440808596336f,
     0.000688186201030564f,
     0.000612694289527581f,
     0.000540912739938505f,
     0.000472783700962668f,
     0.000408244468331575f,
     0.000347228091667187f,
     0.000289663252276950f,
     0.000235474395169584f,
     0.000184583050199368f,
     0.000136906695012963f,
     0.000092360432854175f,
     0.000050856088211618f,
     0.000012303734435184f,
    -0.000023389083735015f,
    -0.000056316612617103f,
    -0.000086574168670878f,
    -0.000114258627064630f,
    -0.000139467943568298f,
    -0.000162300101972573f,
    -0.000182854056621652f,
    -0.000201228717970838f,
    -0.000217522684614226f,
    -0.000231834561467387f,
    -0.000244261829079865f,
    -0.000254902132867105f,
    -0.000263850662609383f,
    -0.000271202733437524f,
    -0.000277051522643753f,
    -0.000281488659987540f,
    -0.000284603980740463f,
    -0.000286486063219693f,
    -0.000287220112764771f,
    -0.000286890694598539f,
    -0.000285578633373008f,
    -0.000283363923695878f,
    -0.000280322370041046f,
    -0.000276528686849870f,
    -0.000272054419087176f,
    -0.000266967862740791f,
    -0.000261335292980978f,
    -0.000255220180724547f,
    -0.000248682177854843f,
    -0.000241779257421431f,
    -0.000234565855614429f,
    -0.000227093646507866f,
    -0.000219411598860001f,
    -0.000211565351775375f,
    -0.000203599379753965f,
    -0.000195552549576070f,
    -0.000187464129074148f,
    -0.000179368841745378f,
    -0.000171298895948762f,
    -0.000163284378055491f,
    -0.000155353239032747f,
    -0.000147529334756596f,
    -0.000139836270835869f,
    -0.000132293212128623f,
    -0.000124919754739577f,
    -0.000117729935644196f,
    -0.000110738977492950f,
    -0.000103959504668590f,
    -0.000097399649098627f,
    -0.000091070103041806f,
    -0.000084976788235246f,
    -0.000079124725926570f,
    -0.000073517650784389f,
    -0.000068158618146586f,
    -0.000063047547807853f,
    -0.000058185242147041f,
    -0.000053568215176887f,
    -0.000049199353227621f,
    -0.000045067469478981f,
    -0.000041176665997414f,
    -0.000037517497377010f,
    -0.000034086060833210f,
    -0.000030875236885189f,
    -0.000027881953296601f,
    -0.000025093613992638f,
    -0.000022508204619172f,
    -0.000020111369902626f,
    -0.000017906061357310f,
    -0.000015868003792231f,
    -0.000014003128525449f,
    -0.000012302324525658f,
    -0.000010742797132820f,
    -0.000009336504822940f,
    -0.000008064028056128f,
    -0.000006916263845337f,
    -0.000005880953015414f,
    -0.000004959329780957f,
    -0.000004141892670381f,
    -0.000003423524464373f,
    -0.000002790586794678f,
    -0.000006032200297229f
};
