/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pccbase;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.pcc.defines.DeviceState;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestAccessResult;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.internal.pluginsipc.AntPluginDeviceDbProvider;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncScanController<T extends AntPluginPcc> {
    private static final String TAG = AsyncScanController.class.getSimpleName();
    private boolean isRunning = false;
    private boolean isClosed = false;
    private AsyncPccReleaseHandle currentRequest = null;
    private boolean shouldShutDown = false;
    private final Object stateLock = new Object();
    protected IAsyncScanResultReceiver scanResultReceiver;
    private T retPccObject;

    AsyncScanController(IAsyncScanResultReceiver resultReceiver, T pccObject) {
        if (resultReceiver == null) {
            throw new IllegalArgumentException("ScanResultReceiver passed from client was null");
        }
        this.scanResultReceiver = resultReceiver;
        this.retPccObject = pccObject;
    }

    protected AsyncScanController(T pccObject) {
        this.retPccObject = pccObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeScanController() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.currentRequest != null) {
                this.currentRequest.close();
            } else {
                this.closeScanControllerInternal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeScanControllerInternal() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.isRunning) {
                ((AntPluginPcc)this.retPccObject).stopAsyncScan();
                this.reportScanFailure(-2);
            } else if (this.retPccObject != null) {
                ((AntPluginPcc)this.retPccObject).closePluginConnection();
            }
        }
    }

    private void closeScanControllerDelayed() {
        this.shouldShutDown = true;
        if (this.retPccObject != null) {
            ((AntPluginPcc)this.retPccObject).closePluginConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportScanFailure(int resultCode) {
        Object object = this.stateLock;
        synchronized (object) {
            this.isRunning = false;
            if (this.retPccObject == null) {
                LogAnt.e(TAG, "Unexpected Event: ScanFailure on already null object, code: " + resultCode);
                return;
            }
            ((AntPluginPcc)this.retPccObject).closePluginConnection();
            this.retPccObject = null;
            if (this.currentRequest == null) {
                this.sendFailureToReceiver(RequestAccessResult.getValueFromInt(resultCode));
            }
        }
    }

    protected void sendFailureToReceiver(RequestAccessResult requestAccessResult) {
        this.scanResultReceiver.onSearchStopped(requestAccessResult);
    }

    protected void sendResultToReceiver(Bundle result) {
        AsyncScanResultDeviceInfo newResult = (AsyncScanResultDeviceInfo)result.getParcelable("parcelable_AsyncScanResultDeviceInfo");
        this.scanResultReceiver.onSearchResult(newResult);
    }

    protected void handleReqAccSuccess(Message msg, T retPccObject, AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver) {
        int serviceVersion = msg.getData().getInt("int_ServiceVersion", 0);
        Messenger pluginComm = (Messenger)msg.getData().get("msgr_PluginComm");
        UUID accessToken = (UUID)msg.getData().get("uuid_AccessToken");
        int initialStateCode = msg.getData().getInt("int_InitialDeviceStateCode");
        AntPluginDeviceDbProvider.DeviceDbDeviceInfo deviceInfo = (AntPluginDeviceDbProvider.DeviceDbDeviceInfo)msg.getData().getParcelable("parcelable_DeviceDbInfo");
        if (deviceInfo == null) {
            deviceInfo = new AntPluginDeviceDbProvider.DeviceDbDeviceInfo(0);
            deviceInfo.antDeviceNumber = msg.getData().getInt("int_AntDeviceID", -1);
            deviceInfo.visibleName = msg.getData().getString("str_DeviceName");
            deviceInfo.isPreferredDevice = false;
        }
        ((AntPluginPcc)retPccObject).init(deviceInfo, accessToken, pluginComm, initialStateCode, serviceVersion);
        resultReceiver.onResultReceived(retPccObject, RequestAccessResult.SUCCESS, DeviceState.getValueFromInt(initialStateCode));
        ((AntPluginPcc)retPccObject).deviceInitializedLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PccReleaseHandle<T> requestDeviceAccess(AsyncScanResultDeviceInfo deviceToConnectTo, AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        if (deviceToConnectTo == null) {
            throw new NullPointerException("deviceToConnectTo parameter was null");
        }
        Object object = this.stateLock;
        synchronized (object) {
            AsyncPccReleaseHandle ret;
            if (this.currentRequest != null) {
                throw new RuntimeException("Cannot request access while an access request is already in progress");
            }
            ((AntPluginPcc)this.retPccObject).mReleaseHandle = ret = new AsyncPccReleaseHandle(resultReceiver, stateReceiver);
            if (!this.isRunning) {
                LogAnt.e(TAG, "Attempted to connect to a device when the scan was no longer connected");
                ret.onResultReceived(null, RequestAccessResult.OTHER_FAILURE, DeviceState.DEAD);
                return ret;
            }
            this.currentRequest = ret;
            Messenger commChannel = new Messenger(new ConnectResultHandler<T>(ret, this.retPccObject, this));
            ((AntPluginPcc)this.retPccObject).connectToAsyncResult(deviceToConnectTo, commChannel, ret.stateSink);
            return ret;
        }
    }

    protected Handler getScanResultHandler() {
        return new ScanResultHandler<T>(this.retPccObject, this);
    }

    public static String getMissingDependencyPackageName() {
        return AntPluginPcc.lastMissingDependencyPkgName;
    }

    public static String getMissingDependencyName() {
        return AntPluginPcc.lastMissingDependencyName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectResultHandler<T extends AntPluginPcc>
    extends Handler {
        AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver;
        T retPccObject;
        AsyncScanController<T> controller;

        public ConnectResultHandler(AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver, T retPccObject, AsyncScanController<T> controller) {
            this.resultReceiver = resultReceiver;
            this.retPccObject = retPccObject;
            this.controller = controller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            int resultCode = msg.what;
            msg.getData().setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Object object = ((AsyncScanController)this.controller).stateLock;
            synchronized (object) {
                switch (resultCode) {
                    case 0: {
                        ((AsyncScanController)this.controller).isRunning = false;
                        this.controller.handleReqAccSuccess(msg, this.retPccObject, this.resultReceiver);
                        return;
                    }
                    case -7: {
                        this.resultReceiver.onResultReceived(null, RequestAccessResult.SEARCH_TIMEOUT, DeviceState.SEARCHING);
                        return;
                    }
                }
                RequestAccessResult code = RequestAccessResult.getValueFromInt(resultCode);
                if (code == RequestAccessResult.UNRECOGNIZED) {
                    LogAnt.e(TAG, "RequestAccess failed: Unrecognized return code (need app lib upgrade): " + code.getIntValue() + "!!!");
                } else {
                    LogAnt.e(TAG, "RequestAccess failed: " + code.toString());
                }
                ((AsyncScanController)this.controller).reportScanFailure(resultCode);
                this.resultReceiver.onResultReceived(null, code, DeviceState.DEAD);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScanResultHandler<T extends AntPluginPcc>
    extends Handler {
        AsyncScanController<T> controller;
        T retPccObject;

        public ScanResultHandler(T retPccObject, AsyncScanController<T> controller) {
            this.retPccObject = retPccObject;
            this.controller = controller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            int resultCode = msg.what;
            msg.getData().setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            LogAnt.v(TAG, "Async scan controller rcv result: " + resultCode);
            switch (resultCode) {
                case 0: {
                    Bundle retInfo = msg.getData();
                    ((AntPluginPcc)this.retPccObject).mAccessToken = (UUID)retInfo.getSerializable("uuid_AccessToken");
                    ((AntPluginPcc)this.retPccObject).mPluginMsgr = (Messenger)retInfo.getParcelable("msgr_PluginComm");
                    Object object = ((AsyncScanController)this.controller).stateLock;
                    synchronized (object) {
                        ((AsyncScanController)this.controller).isRunning = true;
                        if (((AsyncScanController)this.controller).isClosed) {
                            this.controller.closeScanController();
                        }
                    }
                    return;
                }
                case 2: {
                    this.controller.sendResultToReceiver(msg.getData());
                    return;
                }
                case -5: {
                    Bundle b = msg.getData();
                    AntPluginPcc.lastMissingDependencyPkgName = b.getString("string_DependencyPackageName");
                    AntPluginPcc.lastMissingDependencyName = b.getString("string_DependencyName");
                    LogAnt.e(TAG, "requestAccess failed, " + AntPluginPcc.lastMissingDependencyPkgName + " not installed.");
                    ((AsyncScanController)this.controller).reportScanFailure(resultCode);
                    return;
                }
                case -7: {
                    return;
                }
            }
            RequestAccessResult code = RequestAccessResult.getValueFromInt(resultCode);
            if (code == RequestAccessResult.UNRECOGNIZED) {
                LogAnt.e(TAG, "RequestAccess failed: Unrecognized return code (need app lib upgrade): " + code.getIntValue() + "!!!");
            } else {
                LogAnt.e(TAG, "RequestAccess failed: " + code.toString());
            }
            ((AsyncScanController)this.controller).reportScanFailure(resultCode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncPccReleaseHandle
    extends PccReleaseHandle<T>
    implements AntPluginPcc.IPluginAccessResultReceiver<T> {
        protected AsyncPccReleaseHandle(AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
            super(resultReceiver, stateReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void requestCancelled() {
            Object object = AsyncScanController.this.stateLock;
            synchronized (object) {
                if (AsyncScanController.this.currentRequest != null) {
                    AsyncScanController.this.closeScanControllerDelayed();
                } else {
                    AsyncScanController.this.closeScanControllerInternal();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResultReceived(T result, RequestAccessResult resultCode, DeviceState initialDeviceState) {
            Object object = this.stateLock;
            synchronized (object) {
                Object object2 = AsyncScanController.this.stateLock;
                synchronized (object2) {
                    if (!this.resultSent && resultCode == RequestAccessResult.SEARCH_TIMEOUT || resultCode == RequestAccessResult.SUCCESS) {
                        AsyncScanController.this.currentRequest = null;
                    }
                    if (AsyncScanController.this.shouldShutDown) {
                        AsyncScanController.this.closeScanControllerInternal();
                    }
                }
                this.resultSink.onResultReceived(result, resultCode, initialDeviceState);
            }
        }
    }

    public static class AsyncScanResultDeviceInfo
    implements Parcelable {
        public static final String KEY_DEFAULT_ASYNCSCANRESULTKEY = "parcelable_AsyncScanResultDeviceInfo";
        private final int ipcVersionNumber;
        public final UUID scanResultInternalIdentifier;
        private final boolean isAlreadyConnected;
        private final AntPluginDeviceDbProvider.DeviceDbDeviceInfo deviceInfo;
        public static final Parcelable.Creator<AsyncScanResultDeviceInfo> CREATOR = new Parcelable.Creator<AsyncScanResultDeviceInfo>(){

            public AsyncScanResultDeviceInfo createFromParcel(Parcel in) {
                return new AsyncScanResultDeviceInfo(in);
            }

            public AsyncScanResultDeviceInfo[] newArray(int size) {
                return new AsyncScanResultDeviceInfo[size];
            }
        };

        public AsyncScanResultDeviceInfo(UUID scanResultIdentifier, AntPluginDeviceDbProvider.DeviceDbDeviceInfo deviceInfo, boolean isAlreadyConnected) {
            this.ipcVersionNumber = 1;
            this.scanResultInternalIdentifier = scanResultIdentifier;
            this.deviceInfo = deviceInfo;
            this.isAlreadyConnected = isAlreadyConnected;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeValue((Object)this.scanResultInternalIdentifier);
            dest.writeValue((Object)this.isAlreadyConnected);
            dest.writeParcelable((Parcelable)this.deviceInfo, flags);
        }

        public AsyncScanResultDeviceInfo(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " AsyncScanResultDeviceInfo parcel with version 1 parser.");
            }
            this.scanResultInternalIdentifier = (UUID)in.readValue(null);
            this.isAlreadyConnected = (Boolean)in.readValue(null);
            this.deviceInfo = (AntPluginDeviceDbProvider.DeviceDbDeviceInfo)in.readParcelable(this.getClass().getClassLoader());
        }

        public String getDeviceDisplayName() {
            return this.deviceInfo.visibleName;
        }

        public int getAntDeviceNumber() {
            return this.deviceInfo.antDeviceNumber;
        }

        public boolean isUserRecognizedDevice() {
            return this.deviceInfo.device_dbId != null;
        }

        public boolean isUserPreferredDeviceForPlugin() {
            return this.deviceInfo.isPreferredDevice == true;
        }

        public boolean isAlreadyConnected() {
            return this.isAlreadyConnected;
        }
    }

    public static interface IAsyncScanResultReceiver {
        public void onSearchStopped(RequestAccessResult var1);

        public void onSearchResult(AsyncScanResultDeviceInfo var1);
    }
}

