// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/orgpolicy/v1/orgpolicy.proto

package orgpolicy

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// This enum can be used to set `Policies` that apply to all possible
// configuration values rather than specific values in `allowed_values` or
// `denied_values`.
//
// Settting this to `ALLOW` will mean this `Policy` allows all values.
// Similarly, setting it to `DENY` will mean no values are allowed. If
// set to either `ALLOW` or `DENY,  `allowed_values` and `denied_values`
// must be unset. Setting this to `ALL_VALUES_UNSPECIFIED` allows for
// setting `allowed_values` and `denied_values`.
type Policy_ListPolicy_AllValues int32

const (
	// Indicates that allowed_values or denied_values must be set.
	Policy_ListPolicy_ALL_VALUES_UNSPECIFIED Policy_ListPolicy_AllValues = 0
	// A policy with this set allows all values.
	Policy_ListPolicy_ALLOW Policy_ListPolicy_AllValues = 1
	// A policy with this set denies all values.
	Policy_ListPolicy_DENY Policy_ListPolicy_AllValues = 2
)

var Policy_ListPolicy_AllValues_name = map[int32]string{
	0: "ALL_VALUES_UNSPECIFIED",
	1: "ALLOW",
	2: "DENY",
}

var Policy_ListPolicy_AllValues_value = map[string]int32{
	"ALL_VALUES_UNSPECIFIED": 0,
	"ALLOW":                  1,
	"DENY":                   2,
}

func (x Policy_ListPolicy_AllValues) String() string {
	return proto.EnumName(Policy_ListPolicy_AllValues_name, int32(x))
}

func (Policy_ListPolicy_AllValues) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fc4532988da7cf50, []int{0, 0, 0}
}

// Defines a Cloud Organization `Policy` which is used to specify `Constraints`
// for configurations of Cloud Platform resources.
type Policy struct {
	// Version of the `Policy`. Default version is 0;
	Version int32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// The name of the `Constraint` the `Policy` is configuring, for example,
	// `constraints/serviceuser.services`.
	//
	// Immutable after creation.
	Constraint string `protobuf:"bytes,2,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// An opaque tag indicating the current version of the `Policy`, used for
	// concurrency control.
	//
	// When the `Policy` is returned from either a `GetPolicy` or a
	// `ListOrgPolicy` request, this `etag` indicates the version of the current
	// `Policy` to use when executing a read-modify-write loop.
	//
	// When the `Policy` is returned from a `GetEffectivePolicy` request, the
	// `etag` will be unset.
	//
	// When the `Policy` is used in a `SetOrgPolicy` method, use the `etag` value
	// that was returned from a `GetOrgPolicy` request as part of a
	// read-modify-write loop for concurrency control. Not setting the `etag`in a
	// `SetOrgPolicy` request will result in an unconditional write of the
	// `Policy`.
	Etag []byte `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// The time stamp the `Policy` was previously updated. This is set by the
	// server, not specified by the caller, and represents the last time a call to
	// `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
	// be ignored.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The field to populate is based on the `constraint_type` value in the
	// `Constraint`.
	//   `list_constraint` => `list_policy`
	//   `boolean_constraint` => `boolean_policy`
	//
	//  A `restore_default` message may be used with any `Constraint` type.
	//
	// Providing a *_policy that is incompatible with the `constraint_type` will
	// result in an `invalid_argument` error.
	//
	// Attempting to set a `Policy` with a `policy_type` not set will result in an
	// `invalid_argument` error.
	//
	// Types that are valid to be assigned to PolicyType:
	//	*Policy_ListPolicy_
	//	*Policy_BooleanPolicy_
	//	*Policy_RestoreDefault_
	PolicyType           isPolicy_PolicyType `protobuf_oneof:"policy_type"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Policy) Reset()         { *m = Policy{} }
func (m *Policy) String() string { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()    {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc4532988da7cf50, []int{0}
}

func (m *Policy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Policy.Unmarshal(m, b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return xxx_messageInfo_Policy.Size(m)
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

func (m *Policy) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *Policy) GetConstraint() string {
	if m != nil {
		return m.Constraint
	}
	return ""
}

func (m *Policy) GetEtag() []byte {
	if m != nil {
		return m.Etag
	}
	return nil
}

func (m *Policy) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

type isPolicy_PolicyType interface {
	isPolicy_PolicyType()
}

type Policy_ListPolicy_ struct {
	ListPolicy *Policy_ListPolicy `protobuf:"bytes,5,opt,name=list_policy,json=listPolicy,proto3,oneof"`
}

type Policy_BooleanPolicy_ struct {
	BooleanPolicy *Policy_BooleanPolicy `protobuf:"bytes,6,opt,name=boolean_policy,json=booleanPolicy,proto3,oneof"`
}

type Policy_RestoreDefault_ struct {
	RestoreDefault *Policy_RestoreDefault `protobuf:"bytes,7,opt,name=restore_default,json=restoreDefault,proto3,oneof"`
}

func (*Policy_ListPolicy_) isPolicy_PolicyType() {}

func (*Policy_BooleanPolicy_) isPolicy_PolicyType() {}

func (*Policy_RestoreDefault_) isPolicy_PolicyType() {}

func (m *Policy) GetPolicyType() isPolicy_PolicyType {
	if m != nil {
		return m.PolicyType
	}
	return nil
}

func (m *Policy) GetListPolicy() *Policy_ListPolicy {
	if x, ok := m.GetPolicyType().(*Policy_ListPolicy_); ok {
		return x.ListPolicy
	}
	return nil
}

func (m *Policy) GetBooleanPolicy() *Policy_BooleanPolicy {
	if x, ok := m.GetPolicyType().(*Policy_BooleanPolicy_); ok {
		return x.BooleanPolicy
	}
	return nil
}

func (m *Policy) GetRestoreDefault() *Policy_RestoreDefault {
	if x, ok := m.GetPolicyType().(*Policy_RestoreDefault_); ok {
		return x.RestoreDefault
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Policy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Policy_ListPolicy_)(nil),
		(*Policy_BooleanPolicy_)(nil),
		(*Policy_RestoreDefault_)(nil),
	}
}

// Used in `policy_type` to specify how `list_policy` behaves at this
// resource.
//
// `ListPolicy` can define specific values and subtrees of Cloud Resource
// Manager resource hierarchy (`Organizations`, `Folders`, `Projects`) that
// are allowed or denied by setting the `allowed_values` and `denied_values`
// fields. This is achieved by using the `under:` and optional `is:` prefixes.
// The `under:` prefix is used to denote resource subtree values.
// The `is:` prefix is used to denote specific values, and is required only
// if the value contains a ":". Values prefixed with "is:" are treated the
// same as values with no prefix.
// Ancestry subtrees must be in one of the following formats:
//     - "projects/<project-id>", e.g. "projects/tokyo-rain-123"
//     - "folders/<folder-id>", e.g. "folders/1234"
//     - "organizations/<organization-id>", e.g. "organizations/1234"
// The `supports_under` field of the associated `Constraint`  defines whether
// ancestry prefixes can be used. You can set `allowed_values` and
// `denied_values` in the same `Policy` if `all_values` is
// `ALL_VALUES_UNSPECIFIED`. `ALLOW` or `DENY` are used to allow or deny all
// values. If `all_values` is set to either `ALLOW` or `DENY`,
// `allowed_values` and `denied_values` must be unset.
type Policy_ListPolicy struct {
	// List of values allowed  at this resource. Can only be set if `all_values`
	// is set to `ALL_VALUES_UNSPECIFIED`.
	AllowedValues []string `protobuf:"bytes,1,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	// List of values denied at this resource. Can only be set if `all_values`
	// is set to `ALL_VALUES_UNSPECIFIED`.
	DeniedValues []string `protobuf:"bytes,2,rep,name=denied_values,json=deniedValues,proto3" json:"denied_values,omitempty"`
	// The policy all_values state.
	AllValues Policy_ListPolicy_AllValues `protobuf:"varint,3,opt,name=all_values,json=allValues,proto3,enum=google.cloud.orgpolicy.v1.Policy_ListPolicy_AllValues" json:"all_values,omitempty"`
	// Optional. The Google Cloud Console will try to default to a configuration
	// that matches the value specified in this `Policy`. If `suggested_value`
	// is not set, it will inherit the value specified higher in the hierarchy,
	// unless `inherit_from_parent` is `false`.
	SuggestedValue string `protobuf:"bytes,4,opt,name=suggested_value,json=suggestedValue,proto3" json:"suggested_value,omitempty"`
	// Determines the inheritance behavior for this `Policy`.
	//
	// By default, a `ListPolicy` set at a resource supercedes any `Policy` set
	// anywhere up the resource hierarchy. However, if `inherit_from_parent` is
	// set to `true`, then the values from the effective `Policy` of the parent
	// resource are inherited, meaning the values set in this `Policy` are
	// added to the values inherited up the hierarchy.
	//
	// Setting `Policy` hierarchies that inherit both allowed values and denied
	// values isn't recommended in most circumstances to keep the configuration
	// simple and understandable. However, it is possible to set a `Policy` with
	// `allowed_values` set that inherits a `Policy` with `denied_values` set.
	// In this case, the values that are allowed must be in `allowed_values` and
	// not present in `denied_values`.
	//
	// For example, suppose you have a `Constraint`
	// `constraints/serviceuser.services`, which has a `constraint_type` of
	// `list_constraint`, and with `constraint_default` set to `ALLOW`.
	// Suppose that at the Organization level, a `Policy` is applied that
	// restricts the allowed API activations to {`E1`, `E2`}. Then, if a
	// `Policy` is applied to a project below the Organization that has
	// `inherit_from_parent` set to `false` and field all_values set to DENY,
	// then an attempt to activate any API will be denied.
	//
	// The following examples demonstrate different possible layerings for
	// `projects/bar` parented by `organizations/foo`:
	//
	// Example 1 (no inherited values):
	//   `organizations/foo` has a `Policy` with values:
	//     {allowed_values: "E1" allowed_values:"E2"}
	//   `projects/bar` has `inherit_from_parent` `false` and values:
	//     {allowed_values: "E3" allowed_values: "E4"}
	// The accepted values at `organizations/foo` are `E1`, `E2`.
	// The accepted values at `projects/bar` are `E3`, and `E4`.
	//
	// Example 2 (inherited values):
	//   `organizations/foo` has a `Policy` with values:
	//     {allowed_values: "E1" allowed_values:"E2"}
	//   `projects/bar` has a `Policy` with values:
	//     {value: "E3" value: "E4" inherit_from_parent: true}
	// The accepted values at `organizations/foo` are `E1`, `E2`.
	// The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
	//
	// Example 3 (inheriting both allowed and denied values):
	//   `organizations/foo` has a `Policy` with values:
	//     {allowed_values: "E1" allowed_values: "E2"}
	//   `projects/bar` has a `Policy` with:
	//     {denied_values: "E1"}
	// The accepted values at `organizations/foo` are `E1`, `E2`.
	// The value accepted at `projects/bar` is `E2`.
	//
	// Example 4 (RestoreDefault):
	//   `organizations/foo` has a `Policy` with values:
	//     {allowed_values: "E1" allowed_values:"E2"}
	//   `projects/bar` has a `Policy` with values:
	//     {RestoreDefault: {}}
	// The accepted values at `organizations/foo` are `E1`, `E2`.
	// The accepted values at `projects/bar` are either all or none depending on
	// the value of `constraint_default` (if `ALLOW`, all; if
	// `DENY`, none).
	//
	// Example 5 (no policy inherits parent policy):
	//   `organizations/foo` has no `Policy` set.
	//   `projects/bar` has no `Policy` set.
	// The accepted values at both levels are either all or none depending on
	// the value of `constraint_default` (if `ALLOW`, all; if
	// `DENY`, none).
	//
	// Example 6 (ListConstraint allowing all):
	//   `organizations/foo` has a `Policy` with values:
	//     {allowed_values: "E1" allowed_values: "E2"}
	//   `projects/bar` has a `Policy` with:
	//     {all: ALLOW}
	// The accepted values at `organizations/foo` are `E1`, E2`.
	// Any value is accepted at `projects/bar`.
	//
	// Example 7 (ListConstraint allowing none):
	//   `organizations/foo` has a `Policy` with values:
	//     {allowed_values: "E1" allowed_values: "E2"}
	//   `projects/bar` has a `Policy` with:
	//     {all: DENY}
	// The accepted values at `organizations/foo` are `E1`, E2`.
	// No value is accepted at `projects/bar`.
	//
	// Example 10 (allowed and denied subtrees of Resource Manager hierarchy):
	// Given the following resource hierarchy
	//   O1->{F1, F2}; F1->{P1}; F2->{P2, P3},
	//   `organizations/foo` has a `Policy` with values:
	//     {allowed_values: "under:organizations/O1"}
	//   `projects/bar` has a `Policy` with:
	//     {allowed_values: "under:projects/P3"}
	//     {denied_values: "under:folders/F2"}
	// The accepted values at `organizations/foo` are `organizations/O1`,
	//   `folders/F1`, `folders/F2`, `projects/P1`, `projects/P2`,
	//   `projects/P3`.
	// The accepted values at `projects/bar` are `organizations/O1`,
	//   `folders/F1`, `projects/P1`.
	InheritFromParent    bool     `protobuf:"varint,5,opt,name=inherit_from_parent,json=inheritFromParent,proto3" json:"inherit_from_parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Policy_ListPolicy) Reset()         { *m = Policy_ListPolicy{} }
func (m *Policy_ListPolicy) String() string { return proto.CompactTextString(m) }
func (*Policy_ListPolicy) ProtoMessage()    {}
func (*Policy_ListPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc4532988da7cf50, []int{0, 0}
}

func (m *Policy_ListPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Policy_ListPolicy.Unmarshal(m, b)
}
func (m *Policy_ListPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Policy_ListPolicy.Marshal(b, m, deterministic)
}
func (m *Policy_ListPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy_ListPolicy.Merge(m, src)
}
func (m *Policy_ListPolicy) XXX_Size() int {
	return xxx_messageInfo_Policy_ListPolicy.Size(m)
}
func (m *Policy_ListPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy_ListPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy_ListPolicy proto.InternalMessageInfo

func (m *Policy_ListPolicy) GetAllowedValues() []string {
	if m != nil {
		return m.AllowedValues
	}
	return nil
}

func (m *Policy_ListPolicy) GetDeniedValues() []string {
	if m != nil {
		return m.DeniedValues
	}
	return nil
}

func (m *Policy_ListPolicy) GetAllValues() Policy_ListPolicy_AllValues {
	if m != nil {
		return m.AllValues
	}
	return Policy_ListPolicy_ALL_VALUES_UNSPECIFIED
}

func (m *Policy_ListPolicy) GetSuggestedValue() string {
	if m != nil {
		return m.SuggestedValue
	}
	return ""
}

func (m *Policy_ListPolicy) GetInheritFromParent() bool {
	if m != nil {
		return m.InheritFromParent
	}
	return false
}

// Used in `policy_type` to specify how `boolean_policy` will behave at this
// resource.
type Policy_BooleanPolicy struct {
	// If `true`, then the `Policy` is enforced. If `false`, then any
	// configuration is acceptable.
	//
	// Suppose you have a `Constraint`
	// `constraints/compute.disableSerialPortAccess` with `constraint_default`
	// set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
	// behavior:
	//   - If the `Policy` at this resource has enforced set to `false`, serial
	//     port connection attempts will be allowed.
	//   - If the `Policy` at this resource has enforced set to `true`, serial
	//     port connection attempts will be refused.
	//   - If the `Policy` at this resource is `RestoreDefault`, serial port
	//     connection attempts will be allowed.
	//   - If no `Policy` is set at this resource or anywhere higher in the
	//     resource hierarchy, serial port connection attempts will be allowed.
	//   - If no `Policy` is set at this resource, but one exists higher in the
	//     resource hierarchy, the behavior is as if the`Policy` were set at
	//     this resource.
	//
	// The following examples demonstrate the different possible layerings:
	//
	// Example 1 (nearest `Constraint` wins):
	//   `organizations/foo` has a `Policy` with:
	//     {enforced: false}
	//   `projects/bar` has no `Policy` set.
	// The constraint at `projects/bar` and `organizations/foo` will not be
	// enforced.
	//
	// Example 2 (enforcement gets replaced):
	//   `organizations/foo` has a `Policy` with:
	//     {enforced: false}
	//   `projects/bar` has a `Policy` with:
	//     {enforced: true}
	// The constraint at `organizations/foo` is not enforced.
	// The constraint at `projects/bar` is enforced.
	//
	// Example 3 (RestoreDefault):
	//   `organizations/foo` has a `Policy` with:
	//     {enforced: true}
	//   `projects/bar` has a `Policy` with:
	//     {RestoreDefault: {}}
	// The constraint at `organizations/foo` is enforced.
	// The constraint at `projects/bar` is not enforced, because
	// `constraint_default` for the `Constraint` is `ALLOW`.
	Enforced             bool     `protobuf:"varint,1,opt,name=enforced,proto3" json:"enforced,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Policy_BooleanPolicy) Reset()         { *m = Policy_BooleanPolicy{} }
func (m *Policy_BooleanPolicy) String() string { return proto.CompactTextString(m) }
func (*Policy_BooleanPolicy) ProtoMessage()    {}
func (*Policy_BooleanPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc4532988da7cf50, []int{0, 1}
}

func (m *Policy_BooleanPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Policy_BooleanPolicy.Unmarshal(m, b)
}
func (m *Policy_BooleanPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Policy_BooleanPolicy.Marshal(b, m, deterministic)
}
func (m *Policy_BooleanPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy_BooleanPolicy.Merge(m, src)
}
func (m *Policy_BooleanPolicy) XXX_Size() int {
	return xxx_messageInfo_Policy_BooleanPolicy.Size(m)
}
func (m *Policy_BooleanPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy_BooleanPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy_BooleanPolicy proto.InternalMessageInfo

func (m *Policy_BooleanPolicy) GetEnforced() bool {
	if m != nil {
		return m.Enforced
	}
	return false
}

// Ignores policies set above this resource and restores the
// `constraint_default` enforcement behavior of the specific `Constraint` at
// this resource.
//
// Suppose that `constraint_default` is set to `ALLOW` for the
// `Constraint` `constraints/serviceuser.services`. Suppose that organization
// foo.com sets a `Policy` at their Organization resource node that restricts
// the allowed service activations to deny all service activations. They
// could then set a `Policy` with the `policy_type` `restore_default` on
// several experimental projects, restoring the `constraint_default`
// enforcement of the `Constraint` for only those projects, allowing those
// projects to have all services activated.
type Policy_RestoreDefault struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Policy_RestoreDefault) Reset()         { *m = Policy_RestoreDefault{} }
func (m *Policy_RestoreDefault) String() string { return proto.CompactTextString(m) }
func (*Policy_RestoreDefault) ProtoMessage()    {}
func (*Policy_RestoreDefault) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc4532988da7cf50, []int{0, 2}
}

func (m *Policy_RestoreDefault) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Policy_RestoreDefault.Unmarshal(m, b)
}
func (m *Policy_RestoreDefault) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Policy_RestoreDefault.Marshal(b, m, deterministic)
}
func (m *Policy_RestoreDefault) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy_RestoreDefault.Merge(m, src)
}
func (m *Policy_RestoreDefault) XXX_Size() int {
	return xxx_messageInfo_Policy_RestoreDefault.Size(m)
}
func (m *Policy_RestoreDefault) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy_RestoreDefault.DiscardUnknown(m)
}

var xxx_messageInfo_Policy_RestoreDefault proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("google.cloud.orgpolicy.v1.Policy_ListPolicy_AllValues", Policy_ListPolicy_AllValues_name, Policy_ListPolicy_AllValues_value)
	proto.RegisterType((*Policy)(nil), "google.cloud.orgpolicy.v1.Policy")
	proto.RegisterType((*Policy_ListPolicy)(nil), "google.cloud.orgpolicy.v1.Policy.ListPolicy")
	proto.RegisterType((*Policy_BooleanPolicy)(nil), "google.cloud.orgpolicy.v1.Policy.BooleanPolicy")
	proto.RegisterType((*Policy_RestoreDefault)(nil), "google.cloud.orgpolicy.v1.Policy.RestoreDefault")
}

func init() {
	proto.RegisterFile("google/cloud/orgpolicy/v1/orgpolicy.proto", fileDescriptor_fc4532988da7cf50)
}

var fileDescriptor_fc4532988da7cf50 = []byte{
	// 620 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xdd, 0x6e, 0xd3, 0x30,
	0x14, 0x5e, 0xba, 0xad, 0x6b, 0x4f, 0xd7, 0xac, 0x18, 0x09, 0x65, 0x61, 0x40, 0x35, 0x84, 0x28,
	0x02, 0x25, 0x74, 0x48, 0x5c, 0x74, 0xdc, 0xb4, 0x5b, 0xc7, 0x26, 0x55, 0x5b, 0x95, 0xb1, 0xf2,
	0x37, 0x29, 0x72, 0x5b, 0x37, 0x44, 0x72, 0xed, 0xc8, 0x71, 0x8a, 0xf6, 0x4a, 0x5c, 0xf2, 0x10,
	0x5c, 0x20, 0x9e, 0x84, 0xa7, 0x40, 0xb5, 0x93, 0x74, 0x45, 0x4c, 0x13, 0x77, 0x3e, 0xdf, 0xf7,
	0x9d, 0xef, 0x1c, 0x9f, 0xe3, 0x04, 0x9e, 0x05, 0x9c, 0x07, 0x94, 0xb8, 0x23, 0xca, 0x93, 0xb1,
	0xcb, 0x45, 0x10, 0x71, 0x1a, 0x8e, 0xae, 0xdc, 0x59, 0x73, 0x11, 0x38, 0x91, 0xe0, 0x92, 0xa3,
	0x6d, 0x2d, 0x75, 0x94, 0xd4, 0x59, 0xb0, 0xb3, 0xa6, 0x7d, 0x3f, 0x75, 0x51, 0xc2, 0x61, 0x32,
	0x71, 0xc9, 0x34, 0x92, 0x69, 0x9e, 0xfd, 0xe8, 0x6f, 0x52, 0x86, 0x53, 0x12, 0x4b, 0x3c, 0x8d,
	0x52, 0xc1, 0x4e, 0x2a, 0xc0, 0x51, 0xe8, 0x62, 0xc6, 0xb8, 0xc4, 0x32, 0xe4, 0x2c, 0xd6, 0xec,
	0xee, 0xf7, 0x22, 0x14, 0xfb, 0xaa, 0x12, 0xb2, 0x60, 0x63, 0x46, 0x44, 0x1c, 0x72, 0x66, 0x19,
	0x75, 0xa3, 0xb1, 0xee, 0x65, 0x21, 0x7a, 0x08, 0x30, 0xe2, 0x2c, 0x96, 0x02, 0x87, 0x4c, 0x5a,
	0x85, 0xba, 0xd1, 0x28, 0x7b, 0xd7, 0x10, 0x84, 0x60, 0x8d, 0x48, 0x1c, 0x58, 0xab, 0x75, 0xa3,
	0xb1, 0xe9, 0xa9, 0x33, 0xda, 0x87, 0x4a, 0x12, 0x8d, 0xb1, 0x24, 0xfe, 0xbc, 0x21, 0x6b, 0xad,
	0x6e, 0x34, 0x2a, 0x7b, 0xb6, 0x93, 0xde, 0x32, 0xeb, 0xd6, 0x79, 0x97, 0x75, 0xeb, 0x81, 0x96,
	0xcf, 0x01, 0x74, 0x06, 0x15, 0x1a, 0xc6, 0xd2, 0xd7, 0x33, 0xb0, 0xd6, 0x55, 0xf2, 0x0b, 0xe7,
	0xc6, 0x11, 0x39, 0xfa, 0x0a, 0x4e, 0x2f, 0x8c, 0xa5, 0x3e, 0x1e, 0xaf, 0x78, 0x40, 0xf3, 0x08,
	0x7d, 0x00, 0x73, 0xc8, 0x39, 0x25, 0x98, 0x65, 0x9e, 0x45, 0xe5, 0xe9, 0xde, 0xee, 0xd9, 0xd1,
	0x79, 0xb9, 0x6d, 0x75, 0x78, 0x1d, 0x40, 0x9f, 0x61, 0x4b, 0x90, 0x58, 0x72, 0x41, 0xfc, 0x31,
	0x99, 0xe0, 0x84, 0x4a, 0x6b, 0x43, 0x59, 0xbf, 0xbc, 0xdd, 0xda, 0xd3, 0x89, 0x87, 0x3a, 0xef,
	0x78, 0xc5, 0x33, 0xc5, 0x12, 0x62, 0xff, 0x28, 0x00, 0x2c, 0xee, 0x84, 0x9e, 0x80, 0x89, 0x29,
	0xe5, 0x5f, 0xc9, 0xd8, 0x9f, 0x61, 0x9a, 0x90, 0xd8, 0x32, 0xea, 0xab, 0x8d, 0xb2, 0x57, 0x4d,
	0xd1, 0x81, 0x02, 0xd1, 0x63, 0xa8, 0x8e, 0x09, 0x0b, 0x17, 0xaa, 0x82, 0x52, 0x6d, 0x6a, 0x30,
	0x15, 0x5d, 0x00, 0x60, 0x4a, 0x33, 0xc5, 0x7c, 0x73, 0xe6, 0xde, 0xeb, 0xff, 0x99, 0xb0, 0xd3,
	0xa6, 0x54, 0x7b, 0x79, 0x65, 0x9c, 0x1d, 0xd1, 0x53, 0xd8, 0x8a, 0x93, 0x20, 0x20, 0xb1, 0xcc,
	0xca, 0xab, 0xd5, 0x97, 0x3d, 0x33, 0x87, 0x95, 0x12, 0x39, 0x70, 0x37, 0x64, 0x5f, 0x88, 0x08,
	0xa5, 0x3f, 0x11, 0x7c, 0xea, 0x47, 0x58, 0x10, 0x26, 0xd5, 0xaa, 0x4b, 0xde, 0x9d, 0x94, 0x3a,
	0x12, 0x7c, 0xda, 0x57, 0xc4, 0xee, 0x1b, 0x28, 0xe7, 0x05, 0x91, 0x0d, 0xf7, 0xda, 0xbd, 0x9e,
	0x3f, 0x68, 0xf7, 0x2e, 0xba, 0xe7, 0xfe, 0xc5, 0xe9, 0x79, 0xbf, 0x7b, 0x70, 0x72, 0x74, 0xd2,
	0x3d, 0xac, 0xad, 0xa0, 0x32, 0xac, 0xb7, 0x7b, 0xbd, 0xb3, 0xf7, 0x35, 0x03, 0x95, 0x60, 0xed,
	0xb0, 0x7b, 0xfa, 0xb1, 0x56, 0xb0, 0x9f, 0x43, 0x75, 0x69, 0x8f, 0xc8, 0x86, 0x12, 0x61, 0x13,
	0x2e, 0x46, 0x64, 0xac, 0x5e, 0x7b, 0xc9, 0xcb, 0x63, 0xbb, 0x06, 0xe6, 0xf2, 0x66, 0x3a, 0x55,
	0xa8, 0xe8, 0x49, 0xf8, 0xf2, 0x2a, 0x22, 0x9d, 0x5f, 0x06, 0x3c, 0x18, 0xf1, 0xe9, 0xcd, 0xd3,
	0xea, 0x98, 0x67, 0x22, 0xd0, 0x95, 0xfa, 0xf3, 0x97, 0xde, 0x37, 0x3e, 0x75, 0x52, 0x71, 0xc0,
	0x29, 0x66, 0xc1, 0x5c, 0xed, 0x06, 0x84, 0xa9, 0xef, 0xc0, 0xd5, 0x14, 0x8e, 0xc2, 0xf8, 0x1f,
	0x7f, 0x8a, 0xfd, 0x3c, 0xf8, 0x56, 0xd8, 0x7e, 0xab, 0x4d, 0x0e, 0x54, 0xc5, 0xbc, 0x86, 0x33,
	0x68, 0xfe, 0xcc, 0xb8, 0x4b, 0xc5, 0x5d, 0xe6, 0xdc, 0xe5, 0xa0, 0xf9, 0xbb, 0xb0, 0xa3, 0xb9,
	0x56, 0x4b, 0x91, 0xad, 0x56, 0xce, 0xb6, 0x5a, 0x83, 0xe6, 0xb0, 0xa8, 0xba, 0x78, 0xf5, 0x27,
	0x00, 0x00, 0xff, 0xff, 0x06, 0x74, 0xf5, 0xa8, 0xae, 0x04, 0x00, 0x00,
}
