// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/service.proto

package automl

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [AutoMl.CreateDataset][google.cloud.automl.v1.AutoMl.CreateDataset].
type CreateDatasetRequest struct {
	// Required. The resource name of the project to create the dataset for.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The dataset to create.
	Dataset              *Dataset `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatasetRequest) Reset()         { *m = CreateDatasetRequest{} }
func (m *CreateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDatasetRequest) ProtoMessage()    {}
func (*CreateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{0}
}

func (m *CreateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatasetRequest.Unmarshal(m, b)
}
func (m *CreateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatasetRequest.Marshal(b, m, deterministic)
}
func (m *CreateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatasetRequest.Merge(m, src)
}
func (m *CreateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDatasetRequest.Size(m)
}
func (m *CreateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatasetRequest proto.InternalMessageInfo

func (m *CreateDatasetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

// Request message for [AutoMl.GetDataset][google.cloud.automl.v1.AutoMl.GetDataset].
type GetDatasetRequest struct {
	// Required. The resource name of the dataset to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatasetRequest) Reset()         { *m = GetDatasetRequest{} }
func (m *GetDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatasetRequest) ProtoMessage()    {}
func (*GetDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{1}
}

func (m *GetDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatasetRequest.Unmarshal(m, b)
}
func (m *GetDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatasetRequest.Marshal(b, m, deterministic)
}
func (m *GetDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatasetRequest.Merge(m, src)
}
func (m *GetDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatasetRequest.Size(m)
}
func (m *GetDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatasetRequest proto.InternalMessageInfo

func (m *GetDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets].
type ListDatasetsRequest struct {
	// Required. The resource name of the project from which to list datasets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `dataset_metadata` - for existence of the case (e.g.
	//             image_classification_dataset_metadata:*). Some examples of using the filter are:
	//
	//   * `translation_dataset_metadata:*` --> The dataset has
	//                                          translation_dataset_metadata.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size. Server may return fewer results than requested.
	// If unspecified, server will pick a default size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [ListDatasetsResponse.next_page_token][google.cloud.automl.v1.ListDatasetsResponse.next_page_token] of the previous
	// [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsRequest) Reset()         { *m = ListDatasetsRequest{} }
func (m *ListDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsRequest) ProtoMessage()    {}
func (*ListDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{2}
}

func (m *ListDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsRequest.Unmarshal(m, b)
}
func (m *ListDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsRequest.Marshal(b, m, deterministic)
}
func (m *ListDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsRequest.Merge(m, src)
}
func (m *ListDatasetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsRequest.Size(m)
}
func (m *ListDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsRequest proto.InternalMessageInfo

func (m *ListDatasetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDatasetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDatasetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatasetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets].
type ListDatasetsResponse struct {
	// The datasets read.
	Datasets []*Dataset `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListDatasetsRequest.page_token][google.cloud.automl.v1.ListDatasetsRequest.page_token] to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsResponse) Reset()         { *m = ListDatasetsResponse{} }
func (m *ListDatasetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsResponse) ProtoMessage()    {}
func (*ListDatasetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{3}
}

func (m *ListDatasetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsResponse.Unmarshal(m, b)
}
func (m *ListDatasetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsResponse.Marshal(b, m, deterministic)
}
func (m *ListDatasetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsResponse.Merge(m, src)
}
func (m *ListDatasetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsResponse.Size(m)
}
func (m *ListDatasetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsResponse proto.InternalMessageInfo

func (m *ListDatasetsResponse) GetDatasets() []*Dataset {
	if m != nil {
		return m.Datasets
	}
	return nil
}

func (m *ListDatasetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [AutoMl.UpdateDataset][google.cloud.automl.v1.AutoMl.UpdateDataset]
type UpdateDatasetRequest struct {
	// Required. The dataset which replaces the resource on the server.
	Dataset *Dataset `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The update mask applies to the resource.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateDatasetRequest) Reset()         { *m = UpdateDatasetRequest{} }
func (m *UpdateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDatasetRequest) ProtoMessage()    {}
func (*UpdateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{4}
}

func (m *UpdateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDatasetRequest.Unmarshal(m, b)
}
func (m *UpdateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDatasetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDatasetRequest.Merge(m, src)
}
func (m *UpdateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDatasetRequest.Size(m)
}
func (m *UpdateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDatasetRequest proto.InternalMessageInfo

func (m *UpdateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

func (m *UpdateDatasetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [AutoMl.DeleteDataset][google.cloud.automl.v1.AutoMl.DeleteDataset].
type DeleteDatasetRequest struct {
	// Required. The resource name of the dataset to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDatasetRequest) Reset()         { *m = DeleteDatasetRequest{} }
func (m *DeleteDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDatasetRequest) ProtoMessage()    {}
func (*DeleteDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{5}
}

func (m *DeleteDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDatasetRequest.Unmarshal(m, b)
}
func (m *DeleteDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDatasetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDatasetRequest.Merge(m, src)
}
func (m *DeleteDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDatasetRequest.Size(m)
}
func (m *DeleteDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDatasetRequest proto.InternalMessageInfo

func (m *DeleteDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ImportData][google.cloud.automl.v1.AutoMl.ImportData].
type ImportDataRequest struct {
	// Required. Dataset name. Dataset must already exist. All imported
	// annotations and examples will be added.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired input location and its domain specific semantics,
	// if any.
	InputConfig          *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportDataRequest) Reset()         { *m = ImportDataRequest{} }
func (m *ImportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ImportDataRequest) ProtoMessage()    {}
func (*ImportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{6}
}

func (m *ImportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataRequest.Unmarshal(m, b)
}
func (m *ImportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataRequest.Marshal(b, m, deterministic)
}
func (m *ImportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataRequest.Merge(m, src)
}
func (m *ImportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ImportDataRequest.Size(m)
}
func (m *ImportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataRequest proto.InternalMessageInfo

func (m *ImportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportDataRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// Request message for [AutoMl.ExportData][google.cloud.automl.v1.AutoMl.ExportData].
type ExportDataRequest struct {
	// Required. The resource name of the dataset.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired output location.
	OutputConfig         *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportDataRequest) Reset()         { *m = ExportDataRequest{} }
func (m *ExportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ExportDataRequest) ProtoMessage()    {}
func (*ExportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{7}
}

func (m *ExportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataRequest.Unmarshal(m, b)
}
func (m *ExportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataRequest.Marshal(b, m, deterministic)
}
func (m *ExportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataRequest.Merge(m, src)
}
func (m *ExportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ExportDataRequest.Size(m)
}
func (m *ExportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataRequest proto.InternalMessageInfo

func (m *ExportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportDataRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request message for [AutoMl.GetAnnotationSpec][google.cloud.automl.v1.AutoMl.GetAnnotationSpec].
type GetAnnotationSpecRequest struct {
	// Required. The resource name of the annotation spec to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAnnotationSpecRequest) Reset()         { *m = GetAnnotationSpecRequest{} }
func (m *GetAnnotationSpecRequest) String() string { return proto.CompactTextString(m) }
func (*GetAnnotationSpecRequest) ProtoMessage()    {}
func (*GetAnnotationSpecRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{8}
}

func (m *GetAnnotationSpecRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAnnotationSpecRequest.Unmarshal(m, b)
}
func (m *GetAnnotationSpecRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAnnotationSpecRequest.Marshal(b, m, deterministic)
}
func (m *GetAnnotationSpecRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAnnotationSpecRequest.Merge(m, src)
}
func (m *GetAnnotationSpecRequest) XXX_Size() int {
	return xxx_messageInfo_GetAnnotationSpecRequest.Size(m)
}
func (m *GetAnnotationSpecRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAnnotationSpecRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAnnotationSpecRequest proto.InternalMessageInfo

func (m *GetAnnotationSpecRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.CreateModel][google.cloud.automl.v1.AutoMl.CreateModel].
type CreateModelRequest struct {
	// Required. Resource name of the parent project where the model is being created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The model to create.
	Model                *Model   `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateModelRequest) Reset()         { *m = CreateModelRequest{} }
func (m *CreateModelRequest) String() string { return proto.CompactTextString(m) }
func (*CreateModelRequest) ProtoMessage()    {}
func (*CreateModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{9}
}

func (m *CreateModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateModelRequest.Unmarshal(m, b)
}
func (m *CreateModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateModelRequest.Marshal(b, m, deterministic)
}
func (m *CreateModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateModelRequest.Merge(m, src)
}
func (m *CreateModelRequest) XXX_Size() int {
	return xxx_messageInfo_CreateModelRequest.Size(m)
}
func (m *CreateModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateModelRequest proto.InternalMessageInfo

func (m *CreateModelRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

// Request message for [AutoMl.GetModel][google.cloud.automl.v1.AutoMl.GetModel].
type GetModelRequest struct {
	// Required. Resource name of the model.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelRequest) Reset()         { *m = GetModelRequest{} }
func (m *GetModelRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelRequest) ProtoMessage()    {}
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{10}
}

func (m *GetModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelRequest.Unmarshal(m, b)
}
func (m *GetModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelRequest.Marshal(b, m, deterministic)
}
func (m *GetModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelRequest.Merge(m, src)
}
func (m *GetModelRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelRequest.Size(m)
}
func (m *GetModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelRequest proto.InternalMessageInfo

func (m *GetModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels].
type ListModelsRequest struct {
	// Required. Resource name of the project, from which to list the models.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `model_metadata` - for existence of the case (e.g.
	//             video_classification_model_metadata:*).
	//   * `dataset_id` - for = or !=. Some examples of using the filter are:
	//
	//   * `image_classification_model_metadata:*` --> The model has
	//                                        image_classification_model_metadata.
	//   * `dataset_id=5` --> The model was created from a dataset with ID 5.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [ListModelsResponse.next_page_token][google.cloud.automl.v1.ListModelsResponse.next_page_token] of the previous
	// [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsRequest) Reset()         { *m = ListModelsRequest{} }
func (m *ListModelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelsRequest) ProtoMessage()    {}
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{11}
}

func (m *ListModelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsRequest.Unmarshal(m, b)
}
func (m *ListModelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsRequest.Marshal(b, m, deterministic)
}
func (m *ListModelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsRequest.Merge(m, src)
}
func (m *ListModelsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelsRequest.Size(m)
}
func (m *ListModelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsRequest proto.InternalMessageInfo

func (m *ListModelsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListModelsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListModelsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels].
type ListModelsResponse struct {
	// List of models in the requested page.
	Model []*Model `protobuf:"bytes,1,rep,name=model,proto3" json:"model,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListModelsRequest.page_token][google.cloud.automl.v1.ListModelsRequest.page_token] to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsResponse) Reset()         { *m = ListModelsResponse{} }
func (m *ListModelsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelsResponse) ProtoMessage()    {}
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{12}
}

func (m *ListModelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsResponse.Unmarshal(m, b)
}
func (m *ListModelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsResponse.Marshal(b, m, deterministic)
}
func (m *ListModelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsResponse.Merge(m, src)
}
func (m *ListModelsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelsResponse.Size(m)
}
func (m *ListModelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsResponse proto.InternalMessageInfo

func (m *ListModelsResponse) GetModel() []*Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *ListModelsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [AutoMl.DeleteModel][google.cloud.automl.v1.AutoMl.DeleteModel].
type DeleteModelRequest struct {
	// Required. Resource name of the model being deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteModelRequest) Reset()         { *m = DeleteModelRequest{} }
func (m *DeleteModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteModelRequest) ProtoMessage()    {}
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{13}
}

func (m *DeleteModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteModelRequest.Unmarshal(m, b)
}
func (m *DeleteModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteModelRequest.Marshal(b, m, deterministic)
}
func (m *DeleteModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteModelRequest.Merge(m, src)
}
func (m *DeleteModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteModelRequest.Size(m)
}
func (m *DeleteModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteModelRequest proto.InternalMessageInfo

func (m *DeleteModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.UpdateModel][google.cloud.automl.v1.AutoMl.UpdateModel]
type UpdateModelRequest struct {
	// Required. The model which replaces the resource on the server.
	Model *Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The update mask applies to the resource.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateModelRequest) Reset()         { *m = UpdateModelRequest{} }
func (m *UpdateModelRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateModelRequest) ProtoMessage()    {}
func (*UpdateModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{14}
}

func (m *UpdateModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateModelRequest.Unmarshal(m, b)
}
func (m *UpdateModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateModelRequest.Marshal(b, m, deterministic)
}
func (m *UpdateModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateModelRequest.Merge(m, src)
}
func (m *UpdateModelRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateModelRequest.Size(m)
}
func (m *UpdateModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateModelRequest proto.InternalMessageInfo

func (m *UpdateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *UpdateModelRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [AutoMl.DeployModel][google.cloud.automl.v1.AutoMl.DeployModel].
type DeployModelRequest struct {
	// The per-domain specific deployment parameters.
	//
	// Types that are valid to be assigned to ModelDeploymentMetadata:
	//	*DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata
	//	*DeployModelRequest_ImageClassificationModelDeploymentMetadata
	ModelDeploymentMetadata isDeployModelRequest_ModelDeploymentMetadata `protobuf_oneof:"model_deployment_metadata"`
	// Required. Resource name of the model to deploy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployModelRequest) Reset()         { *m = DeployModelRequest{} }
func (m *DeployModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeployModelRequest) ProtoMessage()    {}
func (*DeployModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{15}
}

func (m *DeployModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployModelRequest.Unmarshal(m, b)
}
func (m *DeployModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployModelRequest.Marshal(b, m, deterministic)
}
func (m *DeployModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployModelRequest.Merge(m, src)
}
func (m *DeployModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeployModelRequest.Size(m)
}
func (m *DeployModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeployModelRequest proto.InternalMessageInfo

type isDeployModelRequest_ModelDeploymentMetadata interface {
	isDeployModelRequest_ModelDeploymentMetadata()
}

type DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata struct {
	ImageObjectDetectionModelDeploymentMetadata *ImageObjectDetectionModelDeploymentMetadata `protobuf:"bytes,2,opt,name=image_object_detection_model_deployment_metadata,json=imageObjectDetectionModelDeploymentMetadata,proto3,oneof"`
}

type DeployModelRequest_ImageClassificationModelDeploymentMetadata struct {
	ImageClassificationModelDeploymentMetadata *ImageClassificationModelDeploymentMetadata `protobuf:"bytes,4,opt,name=image_classification_model_deployment_metadata,json=imageClassificationModelDeploymentMetadata,proto3,oneof"`
}

func (*DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata) isDeployModelRequest_ModelDeploymentMetadata() {
}

func (*DeployModelRequest_ImageClassificationModelDeploymentMetadata) isDeployModelRequest_ModelDeploymentMetadata() {
}

func (m *DeployModelRequest) GetModelDeploymentMetadata() isDeployModelRequest_ModelDeploymentMetadata {
	if m != nil {
		return m.ModelDeploymentMetadata
	}
	return nil
}

func (m *DeployModelRequest) GetImageObjectDetectionModelDeploymentMetadata() *ImageObjectDetectionModelDeploymentMetadata {
	if x, ok := m.GetModelDeploymentMetadata().(*DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata); ok {
		return x.ImageObjectDetectionModelDeploymentMetadata
	}
	return nil
}

func (m *DeployModelRequest) GetImageClassificationModelDeploymentMetadata() *ImageClassificationModelDeploymentMetadata {
	if x, ok := m.GetModelDeploymentMetadata().(*DeployModelRequest_ImageClassificationModelDeploymentMetadata); ok {
		return x.ImageClassificationModelDeploymentMetadata
	}
	return nil
}

func (m *DeployModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DeployModelRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DeployModelRequest_ImageObjectDetectionModelDeploymentMetadata)(nil),
		(*DeployModelRequest_ImageClassificationModelDeploymentMetadata)(nil),
	}
}

// Request message for [AutoMl.UndeployModel][google.cloud.automl.v1.AutoMl.UndeployModel].
type UndeployModelRequest struct {
	// Required. Resource name of the model to undeploy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UndeployModelRequest) Reset()         { *m = UndeployModelRequest{} }
func (m *UndeployModelRequest) String() string { return proto.CompactTextString(m) }
func (*UndeployModelRequest) ProtoMessage()    {}
func (*UndeployModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{16}
}

func (m *UndeployModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeployModelRequest.Unmarshal(m, b)
}
func (m *UndeployModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeployModelRequest.Marshal(b, m, deterministic)
}
func (m *UndeployModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeployModelRequest.Merge(m, src)
}
func (m *UndeployModelRequest) XXX_Size() int {
	return xxx_messageInfo_UndeployModelRequest.Size(m)
}
func (m *UndeployModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeployModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UndeployModelRequest proto.InternalMessageInfo

func (m *UndeployModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ExportModel][google.cloud.automl.v1.AutoMl.ExportModel].
// Models need to be enabled for exporting, otherwise an error code will be
// returned.
type ExportModelRequest struct {
	// Required. The resource name of the model to export.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired output location and configuration.
	OutputConfig         *ModelExportOutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ExportModelRequest) Reset()         { *m = ExportModelRequest{} }
func (m *ExportModelRequest) String() string { return proto.CompactTextString(m) }
func (*ExportModelRequest) ProtoMessage()    {}
func (*ExportModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{17}
}

func (m *ExportModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportModelRequest.Unmarshal(m, b)
}
func (m *ExportModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportModelRequest.Marshal(b, m, deterministic)
}
func (m *ExportModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportModelRequest.Merge(m, src)
}
func (m *ExportModelRequest) XXX_Size() int {
	return xxx_messageInfo_ExportModelRequest.Size(m)
}
func (m *ExportModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportModelRequest proto.InternalMessageInfo

func (m *ExportModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportModelRequest) GetOutputConfig() *ModelExportOutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request message for [AutoMl.GetModelEvaluation][google.cloud.automl.v1.AutoMl.GetModelEvaluation].
type GetModelEvaluationRequest struct {
	// Required. Resource name for the model evaluation.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelEvaluationRequest) Reset()         { *m = GetModelEvaluationRequest{} }
func (m *GetModelEvaluationRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelEvaluationRequest) ProtoMessage()    {}
func (*GetModelEvaluationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{18}
}

func (m *GetModelEvaluationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelEvaluationRequest.Unmarshal(m, b)
}
func (m *GetModelEvaluationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelEvaluationRequest.Marshal(b, m, deterministic)
}
func (m *GetModelEvaluationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelEvaluationRequest.Merge(m, src)
}
func (m *GetModelEvaluationRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelEvaluationRequest.Size(m)
}
func (m *GetModelEvaluationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelEvaluationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelEvaluationRequest proto.InternalMessageInfo

func (m *GetModelEvaluationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations].
type ListModelEvaluationsRequest struct {
	// Required. Resource name of the model to list the model evaluations for.
	// If modelId is set as "-", this will list model evaluations from across all
	// models of the parent location.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. An expression for filtering the results of the request.
	//
	//   * `annotation_spec_id` - for =, !=  or existence. See example below for
	//                          the last.
	//
	// Some examples of using the filter are:
	//
	//   * `annotation_spec_id!=4` --> The model evaluation was done for
	//                             annotation spec with ID different than 4.
	//   * `NOT annotation_spec_id:*` --> The model evaluation was done for
	//                                aggregate of all annotation specs.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return.
	// Typically obtained via
	// [ListModelEvaluationsResponse.next_page_token][google.cloud.automl.v1.ListModelEvaluationsResponse.next_page_token] of the previous
	// [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelEvaluationsRequest) Reset()         { *m = ListModelEvaluationsRequest{} }
func (m *ListModelEvaluationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelEvaluationsRequest) ProtoMessage()    {}
func (*ListModelEvaluationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{19}
}

func (m *ListModelEvaluationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelEvaluationsRequest.Unmarshal(m, b)
}
func (m *ListModelEvaluationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelEvaluationsRequest.Marshal(b, m, deterministic)
}
func (m *ListModelEvaluationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelEvaluationsRequest.Merge(m, src)
}
func (m *ListModelEvaluationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelEvaluationsRequest.Size(m)
}
func (m *ListModelEvaluationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelEvaluationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelEvaluationsRequest proto.InternalMessageInfo

func (m *ListModelEvaluationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelEvaluationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListModelEvaluationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListModelEvaluationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations].
type ListModelEvaluationsResponse struct {
	// List of model evaluations in the requested page.
	ModelEvaluation []*ModelEvaluation `protobuf:"bytes,1,rep,name=model_evaluation,json=modelEvaluation,proto3" json:"model_evaluation,omitempty"`
	// A token to retrieve next page of results.
	// Pass to the [ListModelEvaluationsRequest.page_token][google.cloud.automl.v1.ListModelEvaluationsRequest.page_token] field of a new
	// [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations] request to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelEvaluationsResponse) Reset()         { *m = ListModelEvaluationsResponse{} }
func (m *ListModelEvaluationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelEvaluationsResponse) ProtoMessage()    {}
func (*ListModelEvaluationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{20}
}

func (m *ListModelEvaluationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelEvaluationsResponse.Unmarshal(m, b)
}
func (m *ListModelEvaluationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelEvaluationsResponse.Marshal(b, m, deterministic)
}
func (m *ListModelEvaluationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelEvaluationsResponse.Merge(m, src)
}
func (m *ListModelEvaluationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelEvaluationsResponse.Size(m)
}
func (m *ListModelEvaluationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelEvaluationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelEvaluationsResponse proto.InternalMessageInfo

func (m *ListModelEvaluationsResponse) GetModelEvaluation() []*ModelEvaluation {
	if m != nil {
		return m.ModelEvaluation
	}
	return nil
}

func (m *ListModelEvaluationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateDatasetRequest)(nil), "google.cloud.automl.v1.CreateDatasetRequest")
	proto.RegisterType((*GetDatasetRequest)(nil), "google.cloud.automl.v1.GetDatasetRequest")
	proto.RegisterType((*ListDatasetsRequest)(nil), "google.cloud.automl.v1.ListDatasetsRequest")
	proto.RegisterType((*ListDatasetsResponse)(nil), "google.cloud.automl.v1.ListDatasetsResponse")
	proto.RegisterType((*UpdateDatasetRequest)(nil), "google.cloud.automl.v1.UpdateDatasetRequest")
	proto.RegisterType((*DeleteDatasetRequest)(nil), "google.cloud.automl.v1.DeleteDatasetRequest")
	proto.RegisterType((*ImportDataRequest)(nil), "google.cloud.automl.v1.ImportDataRequest")
	proto.RegisterType((*ExportDataRequest)(nil), "google.cloud.automl.v1.ExportDataRequest")
	proto.RegisterType((*GetAnnotationSpecRequest)(nil), "google.cloud.automl.v1.GetAnnotationSpecRequest")
	proto.RegisterType((*CreateModelRequest)(nil), "google.cloud.automl.v1.CreateModelRequest")
	proto.RegisterType((*GetModelRequest)(nil), "google.cloud.automl.v1.GetModelRequest")
	proto.RegisterType((*ListModelsRequest)(nil), "google.cloud.automl.v1.ListModelsRequest")
	proto.RegisterType((*ListModelsResponse)(nil), "google.cloud.automl.v1.ListModelsResponse")
	proto.RegisterType((*DeleteModelRequest)(nil), "google.cloud.automl.v1.DeleteModelRequest")
	proto.RegisterType((*UpdateModelRequest)(nil), "google.cloud.automl.v1.UpdateModelRequest")
	proto.RegisterType((*DeployModelRequest)(nil), "google.cloud.automl.v1.DeployModelRequest")
	proto.RegisterType((*UndeployModelRequest)(nil), "google.cloud.automl.v1.UndeployModelRequest")
	proto.RegisterType((*ExportModelRequest)(nil), "google.cloud.automl.v1.ExportModelRequest")
	proto.RegisterType((*GetModelEvaluationRequest)(nil), "google.cloud.automl.v1.GetModelEvaluationRequest")
	proto.RegisterType((*ListModelEvaluationsRequest)(nil), "google.cloud.automl.v1.ListModelEvaluationsRequest")
	proto.RegisterType((*ListModelEvaluationsResponse)(nil), "google.cloud.automl.v1.ListModelEvaluationsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1/service.proto", fileDescriptor_d14ac936eda1c3a8)
}

var fileDescriptor_d14ac936eda1c3a8 = []byte{
	// 1781 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xcd, 0x6f, 0x1b, 0xc7,
	0x15, 0xef, 0x48, 0xb6, 0x6c, 0x3f, 0x4a, 0x75, 0x35, 0x96, 0x5d, 0x89, 0xb2, 0x60, 0x75, 0x65,
	0x5b, 0x36, 0x4d, 0x73, 0x2d, 0xc9, 0xa8, 0x6d, 0xca, 0x5f, 0x2b, 0xc9, 0x55, 0xdd, 0x4a, 0x96,
	0x4b, 0xd7, 0x06, 0xda, 0x0a, 0x25, 0x56, 0xe4, 0x88, 0xda, 0x7a, 0xb9, 0xb3, 0xe6, 0x2e, 0xe5,
	0x2f, 0xb8, 0x87, 0xb6, 0xd7, 0x02, 0x2d, 0x82, 0x00, 0xf9, 0x00, 0x82, 0x1c, 0x0d, 0xc3, 0x39,
	0xe5, 0x90, 0x43, 0x82, 0x24, 0x87, 0x20, 0x07, 0xe5, 0x12, 0x24, 0x17, 0x43, 0x48, 0x00, 0x1f,
	0x72, 0x08, 0xf2, 0x27, 0xe4, 0x14, 0xec, 0xcc, 0x2c, 0xb9, 0xcb, 0xdd, 0xe5, 0x2e, 0x65, 0x1e,
	0x72, 0xb3, 0x67, 0xde, 0x7b, 0xf3, 0x7b, 0x1f, 0xfb, 0x9b, 0xf9, 0x51, 0x70, 0xb4, 0x42, 0x69,
	0x45, 0x27, 0x72, 0x49, 0xa7, 0xf5, 0xb2, 0xac, 0xd6, 0x6d, 0x5a, 0xd5, 0xe5, 0xcd, 0x29, 0xd9,
	0x22, 0xb5, 0x4d, 0xad, 0x44, 0x72, 0x66, 0x8d, 0xda, 0x14, 0x1f, 0xe2, 0x56, 0x39, 0x66, 0x95,
	0xe3, 0x56, 0xb9, 0xcd, 0xa9, 0xf4, 0x61, 0xe1, 0xad, 0x9a, 0x9a, 0xac, 0x1a, 0x06, 0xb5, 0x55,
	0x5b, 0xa3, 0x86, 0xc5, 0xbd, 0xd2, 0xbf, 0xf6, 0xec, 0x96, 0x74, 0x8d, 0x18, 0xb6, 0xd8, 0x38,
	0xe2, 0xd9, 0x58, 0xd7, 0x88, 0x5e, 0x2e, 0xae, 0x91, 0x0d, 0x75, 0x53, 0xa3, 0x35, 0x61, 0x30,
	0xe2, 0x31, 0xa8, 0x11, 0x8b, 0xd6, 0x6b, 0x2e, 0x94, 0xb4, 0x1c, 0x01, 0xb8, 0x79, 0x7c, 0xd1,
	0x54, 0x1f, 0xea, 0x54, 0x2d, 0x0b, 0x87, 0x6c, 0xbc, 0x83, 0x65, 0x92, 0x92, 0xb0, 0x8e, 0xaa,
	0x47, 0x59, 0xb5, 0x55, 0x8b, 0xb8, 0x09, 0x48, 0x11, 0x56, 0x5a, 0x55, 0xad, 0x90, 0x96, 0x24,
	0x03, 0x36, 0x34, 0x26, 0x48, 0x95, 0x96, 0x89, 0x2e, 0x6c, 0x4e, 0xb7, 0xb3, 0x29, 0x92, 0x4d,
	0x55, 0xaf, 0xb3, 0x14, 0x84, 0xf9, 0x64, 0x84, 0x39, 0x35, 0x49, 0xcd, 0xd7, 0x9a, 0x09, 0x61,
	0xa8, 0x53, 0xa3, 0x52, 0xab, 0x1b, 0x86, 0x66, 0x54, 0x82, 0x46, 0xe3, 0xc2, 0x88, 0xfd, 0x6f,
	0xad, 0xbe, 0x2e, 0x7a, 0x55, 0x55, 0xad, 0xbb, 0xdc, 0x42, 0x7a, 0x13, 0xc1, 0xd0, 0x7c, 0x8d,
	0xa8, 0x36, 0x59, 0xe0, 0xf5, 0x29, 0x90, 0x7b, 0x75, 0x62, 0xd9, 0x58, 0x81, 0x3e, 0x53, 0xad,
	0x11, 0xc3, 0x1e, 0x46, 0xe3, 0xe8, 0xc4, 0xbe, 0xb9, 0x93, 0x2f, 0x95, 0x9e, 0x1f, 0x95, 0x09,
	0xf8, 0x8d, 0x4e, 0x4b, 0xe2, 0x0c, 0x1e, 0x5c, 0x35, 0x35, 0x2b, 0x57, 0xa2, 0x55, 0x79, 0x49,
	0x6c, 0x14, 0x84, 0x23, 0xbe, 0x0c, 0x7b, 0x44, 0xd1, 0x87, 0x7b, 0xc6, 0xd1, 0x89, 0xd4, 0xf4,
	0x91, 0x5c, 0xf8, 0x14, 0xe6, 0xc4, 0xd9, 0x73, 0xbd, 0x2f, 0x95, 0x9e, 0x82, 0xeb, 0x24, 0xdd,
	0x80, 0xc1, 0x45, 0x62, 0xb7, 0xe0, 0xba, 0x00, 0xbb, 0x0c, 0xb5, 0x4a, 0x04, 0xaa, 0x63, 0x0c,
	0xd5, 0x11, 0x18, 0x13, 0xb1, 0x5a, 0x20, 0xb9, 0xbe, 0xcc, 0x45, 0x7a, 0x8e, 0xe0, 0xc0, 0x92,
	0x66, 0xb9, 0x11, 0xad, 0x2e, 0xa6, 0x7a, 0x08, 0xfa, 0xd6, 0x35, 0xdd, 0x26, 0xb5, 0xe1, 0x5e,
	0x27, 0x44, 0x41, 0xfc, 0x0f, 0x8f, 0xc2, 0x3e, 0x53, 0xad, 0x90, 0xa2, 0xa5, 0x3d, 0x22, 0xc3,
	0xbb, 0xc6, 0xd1, 0x89, 0xdd, 0x85, 0xbd, 0xce, 0xc2, 0x2d, 0xed, 0x11, 0xc1, 0x63, 0x00, 0x6c,
	0xd3, 0xa6, 0x77, 0x89, 0x31, 0xdc, 0xc7, 0x1c, 0x99, 0xf9, 0x9f, 0x9d, 0x05, 0xe9, 0x31, 0x0c,
	0xf9, 0xd1, 0x5a, 0x26, 0x35, 0x2c, 0x82, 0x67, 0x61, 0xaf, 0xa8, 0x90, 0x35, 0x8c, 0xc6, 0x7b,
	0x13, 0xd4, 0xb5, 0xd0, 0x70, 0xc0, 0xc7, 0x61, 0xbf, 0x41, 0x1e, 0xd8, 0x45, 0xcf, 0xc1, 0x3d,
	0xec, 0xe0, 0x01, 0x67, 0xf9, 0x66, 0xe3, 0xf0, 0x37, 0x10, 0x0c, 0xdd, 0x36, 0xcb, 0xc1, 0xb9,
	0xf0, 0x34, 0x15, 0xed, 0xa0, 0xa9, 0xf8, 0x2a, 0xa4, 0xea, 0x2c, 0x2e, 0x9b, 0x42, 0x31, 0x18,
	0x69, 0x37, 0x86, 0x3b, 0xa8, 0xb9, 0xdf, 0x39, 0x83, 0xba, 0xac, 0x5a, 0x77, 0xb9, 0x3b, 0x70,
	0x1f, 0x67, 0x41, 0xfa, 0x13, 0x0c, 0x2d, 0x10, 0x9d, 0x04, 0x90, 0xbd, 0xc2, 0x64, 0xbc, 0x8d,
	0x60, 0xf0, 0x7a, 0xd5, 0xa4, 0x35, 0x56, 0xed, 0x57, 0x0f, 0x88, 0xff, 0x08, 0xfd, 0x9a, 0x61,
	0xd6, 0xed, 0x62, 0x89, 0x1a, 0xeb, 0x5a, 0x85, 0x4d, 0x45, 0x6a, 0x7a, 0x22, 0xaa, 0x54, 0xd7,
	0x1d, 0xdb, 0x79, 0x66, 0xca, 0xf3, 0x4d, 0x69, 0xcd, 0x15, 0xe9, 0x1d, 0x04, 0x83, 0xd7, 0x1e,
	0x74, 0x11, 0xdd, 0x0d, 0x18, 0xa0, 0x75, 0x3b, 0x00, 0xef, 0x68, 0x14, 0xbc, 0x15, 0x66, 0xec,
	0xc5, 0xd7, 0x4f, 0x3d, 0x4b, 0xd2, 0x2a, 0x0c, 0x2f, 0x12, 0x5b, 0x69, 0xd0, 0xf1, 0x2d, 0x93,
	0x94, 0x5c, 0x98, 0x57, 0x7d, 0x30, 0xb3, 0x0c, 0xe6, 0x71, 0x38, 0x1a, 0x0e, 0xb3, 0x25, 0x04,
	0x6f, 0xce, 0xff, 0x11, 0x60, 0x4e, 0x51, 0xcb, 0x0e, 0x67, 0x76, 0xf1, 0xab, 0x3d, 0x0f, 0xbb,
	0x19, 0x0d, 0xb3, 0x2f, 0x33, 0x35, 0x3d, 0x16, 0x95, 0x3f, 0x3b, 0x97, 0x27, 0xce, 0x1d, 0xa4,
	0x3f, 0xc0, 0xfe, 0x45, 0x62, 0xfb, 0xf0, 0x9c, 0xf3, 0x25, 0x3a, 0xc1, 0xd0, 0x8c, 0xc1, 0x68,
	0x78, 0xa2, 0xdc, 0x93, 0xe7, 0xf7, 0x0c, 0xc1, 0xa0, 0xf3, 0xa1, 0xb3, 0xb5, 0x9f, 0x3b, 0x29,
	0xdd, 0x03, 0xec, 0xc5, 0x2a, 0x28, 0x69, 0xc6, 0x2d, 0x24, 0xe7, 0xa3, 0xf6, 0x85, 0x14, 0x35,
	0x4c, 0x4c, 0x45, 0xcb, 0x80, 0xf9, 0xf7, 0xde, 0x9d, 0x72, 0xff, 0x0f, 0x01, 0xe6, 0xcc, 0xe6,
	0x8b, 0x77, 0xbe, 0x99, 0x42, 0x67, 0xb3, 0xd0, 0x05, 0x46, 0xfb, 0xac, 0xd7, 0x49, 0xd1, 0xd4,
	0xe9, 0x43, 0x1f, 0xa4, 0xe7, 0x08, 0xce, 0xb0, 0xf7, 0x48, 0x91, 0xae, 0xfd, 0x83, 0x94, 0xec,
	0x62, 0x99, 0xd8, 0xa4, 0xc4, 0xde, 0x3b, 0xfc, 0xf5, 0x50, 0x66, 0x3e, 0x55, 0x62, 0xd8, 0xc5,
	0x2a, 0xb1, 0x55, 0x87, 0x62, 0xc5, 0xf1, 0xf3, 0x91, 0x4c, 0xe3, 0xc4, 0x5b, 0x61, 0xe1, 0x16,
	0xdc, 0x68, 0xec, 0xd0, 0x85, 0x46, 0xac, 0x65, 0x11, 0xea, 0xf7, 0xbf, 0x28, 0x9c, 0xd2, 0x92,
	0x9b, 0xe3, 0xa7, 0x08, 0x72, 0x1c, 0x6e, 0x49, 0x57, 0x2d, 0x4b, 0x5b, 0xd7, 0xf8, 0x3c, 0xb6,
	0x01, 0xcb, 0xbf, 0xbb, 0xb9, 0xb6, 0x60, 0xe7, 0x7d, 0xc1, 0xa2, 0xb1, 0x66, 0xb4, 0xc4, 0xd6,
	0x3b, 0x1e, 0x9e, 0xb9, 0x51, 0x18, 0x89, 0xcc, 0x46, 0x5a, 0x81, 0xa1, 0xdb, 0x46, 0x39, 0xd8,
	0xc7, 0x1d, 0x8f, 0xea, 0x53, 0x04, 0x98, 0x13, 0x7f, 0x57, 0xe2, 0xe1, 0xbf, 0x84, 0xf3, 0xbe,
	0xdc, 0x76, 0xd6, 0x39, 0x80, 0xb8, 0x2b, 0xe0, 0xef, 0x30, 0xe2, 0x12, 0xe2, 0xb5, 0xc6, 0x9b,
	0xb6, 0xc9, 0x65, 0x5e, 0xc0, 0xa7, 0x19, 0xe0, 0x49, 0x38, 0xd6, 0x06, 0xb0, 0x27, 0x06, 0x2f,
	0xc5, 0xfb, 0x08, 0x46, 0x1b, 0xc4, 0xd3, 0xdc, 0x6d, 0xd0, 0xe5, 0x6c, 0x0b, 0x5d, 0x26, 0xaa,
	0x8a, 0x4b, 0x94, 0xa3, 0x7e, 0xa2, 0xe4, 0xf9, 0x75, 0x83, 0x2d, 0xdf, 0x42, 0x70, 0x38, 0x1c,
	0xb5, 0x20, 0xce, 0x02, 0xfc, 0xaa, 0x55, 0x08, 0x08, 0x0e, 0x9d, 0x6c, 0xdf, 0x94, 0x66, 0x7d,
	0xf6, 0x57, 0xfd, 0x0b, 0x49, 0x79, 0x75, 0xfa, 0xfb, 0x51, 0xe8, 0x53, 0xea, 0x36, 0x5d, 0xd6,
	0xf1, 0x17, 0x08, 0x06, 0x7c, 0x2a, 0x00, 0x67, 0xa3, 0x8e, 0x0f, 0x13, 0x0b, 0xe9, 0x06, 0x5b,
	0x7a, 0xd4, 0x48, 0x6e, 0xc5, 0x55, 0x23, 0x52, 0x75, 0x4b, 0x39, 0x0c, 0x7b, 0xdc, 0xd0, 0x83,
	0x8d, 0x0d, 0xf7, 0x7b, 0xdc, 0x56, 0x7e, 0xc9, 0x3b, 0x91, 0x15, 0xaf, 0xc4, 0x7f, 0x7d, 0xfd,
	0xdd, 0x6b, 0x3d, 0xe7, 0xa4, 0xac, 0xa3, 0x7c, 0x1e, 0xf3, 0xad, 0x4b, 0x66, 0x8d, 0x3a, 0x34,
	0x64, 0xc9, 0x19, 0xb9, 0x71, 0x05, 0xca, 0x99, 0x27, 0xae, 0xae, 0xb3, 0xf2, 0x8d, 0x27, 0xe6,
	0xeb, 0x08, 0xa0, 0x29, 0x1c, 0xf0, 0xc9, 0xa8, 0x54, 0x02, 0xe2, 0x22, 0x1d, 0xf7, 0x96, 0x95,
	0x66, 0xb7, 0x15, 0x36, 0x8f, 0x0c, 0x60, 0x0e, 0x73, 0x80, 0xce, 0x42, 0x04, 0xbc, 0x06, 0x3a,
	0x39, 0xf3, 0xc4, 0x21, 0xc8, 0x7e, 0xef, 0x8b, 0x1e, 0x9f, 0x8a, 0x3a, 0x2e, 0x44, 0xa5, 0xa4,
	0xb3, 0xc9, 0x8c, 0xf9, 0x60, 0x49, 0x97, 0xb6, 0x15, 0x31, 0xdd, 0x3e, 0xa8, 0x09, 0x6b, 0x89,
	0x3f, 0x44, 0x30, 0xe0, 0x7b, 0xfe, 0x47, 0x0f, 0x44, 0x98, 0x4a, 0x88, 0x2f, 0xe4, 0xdf, 0xb6,
	0x95, 0x03, 0xe2, 0xb4, 0xac, 0xe7, 0xf6, 0x64, 0x60, 0xaf, 0x4c, 0x9f, 0x65, 0x60, 0x5d, 0xc5,
	0x9e, 0xb0, 0xbe, 0xcd, 0x01, 0xf8, 0x1c, 0xc1, 0x80, 0x4f, 0x22, 0x44, 0xa3, 0x0f, 0x53, 0x12,
	0x71, 0xe3, 0xbc, 0xb1, 0xa5, 0x64, 0xe0, 0x60, 0xeb, 0xfd, 0x7e, 0xad, 0x6a, 0xda, 0x0f, 0x43,
	0x87, 0xdb, 0x33, 0x31, 0x99, 0xce, 0x26, 0xe6, 0x1b, 0x04, 0xd0, 0xd4, 0x25, 0xd1, 0x93, 0x1c,
	0xd0, 0x2e, 0x71, 0x29, 0xfc, 0x1b, 0x75, 0x98, 0xc3, 0xa0, 0x03, 0x39, 0xeb, 0xd5, 0x34, 0x2c,
	0xa1, 0x8b, 0xd2, 0xb9, 0x4e, 0x12, 0xca, 0x6b, 0x0d, 0xa0, 0x79, 0x94, 0xc1, 0xdf, 0x22, 0x80,
	0xa6, 0xb0, 0x89, 0x4e, 0x2f, 0x20, 0x7e, 0xe2, 0xd2, 0xfb, 0x4f, 0xa7, 0xe9, 0x61, 0x96, 0x9e,
	0xef, 0x72, 0xdc, 0x51, 0x7e, 0xe4, 0x81, 0x37, 0xbf, 0x8f, 0x10, 0xfb, 0x05, 0xc3, 0xaf, 0x6a,
	0xf0, 0x99, 0x36, 0x7c, 0x14, 0xaa, 0xa1, 0xd2, 0xc7, 0xa3, 0x3c, 0xfc, 0xe6, 0xd2, 0xb2, 0x77,
	0xd6, 0xae, 0xe2, 0xcb, 0x1d, 0x40, 0xf7, 0xfc, 0x98, 0xe6, 0x84, 0x62, 0xd3, 0xf7, 0x09, 0x82,
	0x94, 0x47, 0x78, 0xe1, 0x4c, 0xfb, 0x3b, 0xc1, 0xfb, 0x46, 0x89, 0x6b, 0x10, 0xd9, 0x52, 0xd2,
	0xb0, 0x9b, 0x87, 0x0d, 0xeb, 0x47, 0xbf, 0xb8, 0x0f, 0xd8, 0xdd, 0xc6, 0xd2, 0x99, 0x91, 0x32,
	0x49, 0x18, 0x8c, 0x39, 0x58, 0x79, 0xf1, 0x34, 0xff, 0x2f, 0x82, 0xbd, 0xee, 0xb3, 0x04, 0x4f,
	0xb6, 0xa9, 0x7b, 0x38, 0xf6, 0xd0, 0xab, 0x57, 0xba, 0xe0, 0xad, 0x72, 0x16, 0x67, 0x62, 0xab,
	0xcc, 0x31, 0x39, 0x15, 0x7d, 0x17, 0x01, 0x34, 0xe5, 0x53, 0xf4, 0xc0, 0x07, 0xe4, 0x60, 0x3a,
	0x93, 0xc4, 0x54, 0x70, 0xff, 0xac, 0x9f, 0xfb, 0x5d, 0x88, 0x89, 0x2a, 0x87, 0x3f, 0x45, 0x90,
	0xf2, 0xc8, 0xad, 0xe8, 0xa6, 0x07, 0x35, 0x59, 0x5c, 0xd3, 0xd7, 0x77, 0xcc, 0x9b, 0xd9, 0x4c,
	0x27, 0x55, 0x7e, 0x0f, 0x41, 0xca, 0xa3, 0xf0, 0xa2, 0x53, 0x08, 0xca, 0xc0, 0xb8, 0xde, 0xdf,
	0xda, 0x56, 0x06, 0xd9, 0x41, 0x81, 0x4b, 0xeb, 0xc2, 0xf4, 0x19, 0x06, 0x91, 0xff, 0xf6, 0x9b,
	0x08, 0xa8, 0x3b, 0xa5, 0x5b, 0xac, 0xe4, 0x0d, 0xd9, 0xd0, 0xae, 0xe4, 0xad, 0xda, 0x22, 0xae,
	0xe4, 0xe6, 0x8e, 0x4b, 0xfe, 0x5b, 0x69, 0x2a, 0x79, 0xc9, 0xf3, 0x5c, 0xf5, 0x38, 0x9c, 0xf7,
	0xa5, 0xf3, 0x72, 0xf0, 0xaa, 0xa0, 0x36, 0x2f, 0x87, 0x10, 0xb1, 0x14, 0x97, 0x50, 0x6d, 0xc7,
	0x09, 0x9d, 0x97, 0x66, 0x3a, 0x48, 0xa8, 0x6e, 0x34, 0x53, 0x7a, 0x81, 0x20, 0xe5, 0x91, 0x61,
	0xd1, 0xfd, 0x09, 0x6a, 0xb5, 0xb8, 0x74, 0xfe, 0xd9, 0xa5, 0x7b, 0xaa, 0xb3, 0x6e, 0xf1, 0x5b,
	0xca, 0x49, 0xed, 0x63, 0x04, 0x38, 0xa8, 0xdb, 0xf0, 0x54, 0x1c, 0x55, 0x06, 0x34, 0x5e, 0x3a,
	0xa9, 0x5e, 0x91, 0x96, 0xbc, 0x4d, 0xb9, 0x82, 0x2f, 0x25, 0xc6, 0x2d, 0xb7, 0x08, 0x1d, 0xf6,
	0xad, 0xbf, 0x40, 0xfc, 0x57, 0xf2, 0x56, 0x85, 0x85, 0x67, 0x62, 0x09, 0x33, 0xa8, 0x22, 0xd3,
	0x67, 0x3b, 0x73, 0x12, 0x7c, 0x7b, 0x7b, 0x5b, 0x19, 0x10, 0xf7, 0x15, 0xd7, 0x8c, 0xbe, 0xd4,
	0xda, 0xd2, 0x6e, 0xb3, 0x29, 0x81, 0xec, 0xd2, 0xd7, 0xb7, 0x94, 0x83, 0xa1, 0xea, 0xf5, 0x2b,
	0x25, 0xb7, 0x61, 0xdb, 0xa6, 0x95, 0x97, 0xe5, 0xfb, 0xf7, 0xef, 0xb7, 0x4a, 0x5b, 0xb5, 0x6e,
	0x6f, 0xf0, 0x3f, 0x1f, 0x9d, 0x36, 0x75, 0xd5, 0x5e, 0xa7, 0xb5, 0xea, 0xdc, 0x07, 0x08, 0xd2,
	0x25, 0x5a, 0x8d, 0xc8, 0x6e, 0x2e, 0xc5, 0x65, 0xe0, 0x4d, 0x67, 0xfe, 0x6e, 0xa2, 0xbf, 0x5e,
	0x14, 0x66, 0x15, 0xaa, 0xab, 0x46, 0x25, 0x47, 0x6b, 0x15, 0xb9, 0x42, 0x0c, 0x36, 0x9d, 0x72,
	0xf3, 0xb0, 0xd6, 0x3f, 0x51, 0xcd, 0xf2, 0x7f, 0x3d, 0xeb, 0x39, 0xb4, 0xc8, 0xdd, 0xe7, 0xd9,
	0x29, 0x2c, 0xf4, 0x52, 0xee, 0xce, 0xd4, 0x96, 0xbb, 0xb1, 0xca, 0x36, 0x56, 0xf9, 0x99, 0xab,
	0x77, 0xa6, 0x7e, 0xe8, 0x19, 0xe1, 0x1b, 0xf9, 0x3c, 0xdb, 0xc9, 0xe7, 0xb9, 0x4f, 0x3e, 0x7f,
	0x67, 0x6a, 0xad, 0x8f, 0x1d, 0x3b, 0xf3, 0x53, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1d, 0xe6, 0x7c,
	0x6f, 0xe6, 0x1c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AutoMlClient is the client API for AutoMl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutoMlClient interface {
	// Creates a dataset.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Updates a dataset.
	UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports data into a dataset.
	// For Tables this method can only be called on an empty Dataset.
	//
	// For Tables:
	// *   A
	// [schema_inference_version][google.cloud.automl.v1.InputConfig.params]
	//     parameter must be explicitly set.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports dataset's data to the provided output location.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an annotation spec.
	GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists models.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Deletes a model.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a model.
	UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deploys a model. If a model is already deployed, deploying it with the
	// same parameters has no effect. Deploying with different parametrs
	// (as e.g. changing
	//
	// [node_number][google.cloud.automl.v1p1beta.ImageObjectDetectionModelDeploymentMetadata.node_number])
	//  will reset the deployment state without pausing the model's availability.
	//
	// Only applicable for Text Classification, Image Object Detection , Tables, and Image Segmentation; all other domains manage
	// deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	//
	// Only applicable for Text Classification, Image Object Detection and Tables;
	// all other domains manage deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports a trained, "export-able", model to a user specified Google Cloud
	// Storage location. A model is considered export-able if and only if it has
	// an export format defined for it in
	// [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportModel(ctx context.Context, in *ExportModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a model evaluation.
	GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error)
}

type autoMlClient struct {
	cc grpc.ClientConnInterface
}

func NewAutoMlClient(cc grpc.ClientConnInterface) AutoMlClient {
	return &autoMlClient{cc}
}

func (c *autoMlClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/CreateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/UpdateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/DeleteDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ImportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ExportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error) {
	out := new(AnnotationSpec)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetAnnotationSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/CreateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/UpdateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/DeployModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/UndeployModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ExportModel(ctx context.Context, in *ExportModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ExportModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error) {
	out := new(ModelEvaluation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetModelEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error) {
	out := new(ListModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListModelEvaluations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoMlServer is the server API for AutoMl service.
type AutoMlServer interface {
	// Creates a dataset.
	CreateDataset(context.Context, *CreateDatasetRequest) (*longrunning.Operation, error)
	// Gets a dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Updates a dataset.
	UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunning.Operation, error)
	// Imports data into a dataset.
	// For Tables this method can only be called on an empty Dataset.
	//
	// For Tables:
	// *   A
	// [schema_inference_version][google.cloud.automl.v1.InputConfig.params]
	//     parameter must be explicitly set.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ImportData(context.Context, *ImportDataRequest) (*longrunning.Operation, error)
	// Exports dataset's data to the provided output location.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(context.Context, *ExportDataRequest) (*longrunning.Operation, error)
	// Gets an annotation spec.
	GetAnnotationSpec(context.Context, *GetAnnotationSpecRequest) (*AnnotationSpec, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(context.Context, *CreateModelRequest) (*longrunning.Operation, error)
	// Gets a model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists models.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Deletes a model.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunning.Operation, error)
	// Updates a model.
	UpdateModel(context.Context, *UpdateModelRequest) (*Model, error)
	// Deploys a model. If a model is already deployed, deploying it with the
	// same parameters has no effect. Deploying with different parametrs
	// (as e.g. changing
	//
	// [node_number][google.cloud.automl.v1p1beta.ImageObjectDetectionModelDeploymentMetadata.node_number])
	//  will reset the deployment state without pausing the model's availability.
	//
	// Only applicable for Text Classification, Image Object Detection , Tables, and Image Segmentation; all other domains manage
	// deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	DeployModel(context.Context, *DeployModelRequest) (*longrunning.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	//
	// Only applicable for Text Classification, Image Object Detection and Tables;
	// all other domains manage deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	UndeployModel(context.Context, *UndeployModelRequest) (*longrunning.Operation, error)
	// Exports a trained, "export-able", model to a user specified Google Cloud
	// Storage location. A model is considered export-able if and only if it has
	// an export format defined for it in
	// [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportModel(context.Context, *ExportModelRequest) (*longrunning.Operation, error)
	// Gets a model evaluation.
	GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error)
}

// UnimplementedAutoMlServer can be embedded to have forward compatible implementations.
type UnimplementedAutoMlServer struct {
}

func (*UnimplementedAutoMlServer) CreateDataset(ctx context.Context, req *CreateDatasetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (*UnimplementedAutoMlServer) GetDataset(ctx context.Context, req *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (*UnimplementedAutoMlServer) ListDatasets(ctx context.Context, req *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (*UnimplementedAutoMlServer) UpdateDataset(ctx context.Context, req *UpdateDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataset not implemented")
}
func (*UnimplementedAutoMlServer) DeleteDataset(ctx context.Context, req *DeleteDatasetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (*UnimplementedAutoMlServer) ImportData(ctx context.Context, req *ImportDataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (*UnimplementedAutoMlServer) ExportData(ctx context.Context, req *ExportDataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (*UnimplementedAutoMlServer) GetAnnotationSpec(ctx context.Context, req *GetAnnotationSpecRequest) (*AnnotationSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnnotationSpec not implemented")
}
func (*UnimplementedAutoMlServer) CreateModel(ctx context.Context, req *CreateModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModel not implemented")
}
func (*UnimplementedAutoMlServer) GetModel(ctx context.Context, req *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (*UnimplementedAutoMlServer) ListModels(ctx context.Context, req *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (*UnimplementedAutoMlServer) DeleteModel(ctx context.Context, req *DeleteModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}
func (*UnimplementedAutoMlServer) UpdateModel(ctx context.Context, req *UpdateModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModel not implemented")
}
func (*UnimplementedAutoMlServer) DeployModel(ctx context.Context, req *DeployModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployModel not implemented")
}
func (*UnimplementedAutoMlServer) UndeployModel(ctx context.Context, req *UndeployModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployModel not implemented")
}
func (*UnimplementedAutoMlServer) ExportModel(ctx context.Context, req *ExportModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportModel not implemented")
}
func (*UnimplementedAutoMlServer) GetModelEvaluation(ctx context.Context, req *GetModelEvaluationRequest) (*ModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelEvaluation not implemented")
}
func (*UnimplementedAutoMlServer) ListModelEvaluations(ctx context.Context, req *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelEvaluations not implemented")
}

func RegisterAutoMlServer(s *grpc.Server, srv AutoMlServer) {
	s.RegisterService(&_AutoMl_serviceDesc, srv)
}

func _AutoMl_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/CreateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UpdateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UpdateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/UpdateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UpdateDataset(ctx, req.(*UpdateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/DeleteDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ImportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ExportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetAnnotationSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetAnnotationSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetAnnotationSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetAnnotationSpec(ctx, req.(*GetAnnotationSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/CreateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UpdateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UpdateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/UpdateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UpdateModel(ctx, req.(*UpdateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/DeployModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeployModel(ctx, req.(*DeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UndeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UndeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/UndeployModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UndeployModel(ctx, req.(*UndeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ExportModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ExportModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ExportModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ExportModel(ctx, req.(*ExportModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetModelEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, req.(*GetModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListModelEvaluations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, req.(*ListModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutoMl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.automl.v1.AutoMl",
	HandlerType: (*AutoMlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _AutoMl_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _AutoMl_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _AutoMl_ListDatasets_Handler,
		},
		{
			MethodName: "UpdateDataset",
			Handler:    _AutoMl_UpdateDataset_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _AutoMl_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _AutoMl_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _AutoMl_ExportData_Handler,
		},
		{
			MethodName: "GetAnnotationSpec",
			Handler:    _AutoMl_GetAnnotationSpec_Handler,
		},
		{
			MethodName: "CreateModel",
			Handler:    _AutoMl_CreateModel_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _AutoMl_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _AutoMl_ListModels_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _AutoMl_DeleteModel_Handler,
		},
		{
			MethodName: "UpdateModel",
			Handler:    _AutoMl_UpdateModel_Handler,
		},
		{
			MethodName: "DeployModel",
			Handler:    _AutoMl_DeployModel_Handler,
		},
		{
			MethodName: "UndeployModel",
			Handler:    _AutoMl_UndeployModel_Handler,
		},
		{
			MethodName: "ExportModel",
			Handler:    _AutoMl_ExportModel_Handler,
		},
		{
			MethodName: "GetModelEvaluation",
			Handler:    _AutoMl_GetModelEvaluation_Handler,
		},
		{
			MethodName: "ListModelEvaluations",
			Handler:    _AutoMl_ListModelEvaluations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/automl/v1/service.proto",
}
