/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// BatchCheckItem struct for BatchCheckItem
type BatchCheckItem struct {
	TupleKey         CheckRequestTupleKey    `json:"tuple_key" yaml:"tuple_key"`
	ContextualTuples *ContextualTupleKeys    `json:"contextual_tuples,omitempty" yaml:"contextual_tuples,omitempty"`
	Context          *map[string]interface{} `json:"context,omitempty" yaml:"context,omitempty"`
	// correlation_id must be a string containing only letters, numbers, or hyphens, with length ≤ 36 characters.
	CorrelationId string `json:"correlation_id" yaml:"correlation_id"`
}

// NewBatchCheckItem instantiates a new BatchCheckItem object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBatchCheckItem(tupleKey CheckRequestTupleKey, correlationId string) *BatchCheckItem {
	this := BatchCheckItem{}
	this.TupleKey = tupleKey
	this.CorrelationId = correlationId
	return &this
}

// NewBatchCheckItemWithDefaults instantiates a new BatchCheckItem object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBatchCheckItemWithDefaults() *BatchCheckItem {
	this := BatchCheckItem{}
	return &this
}

// GetTupleKey returns the TupleKey field value
func (o *BatchCheckItem) GetTupleKey() CheckRequestTupleKey {
	if o == nil {
		var ret CheckRequestTupleKey
		return ret
	}

	return o.TupleKey
}

// GetTupleKeyOk returns a tuple with the TupleKey field value
// and a boolean to check if the value has been set.
func (o *BatchCheckItem) GetTupleKeyOk() (*CheckRequestTupleKey, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TupleKey, true
}

// SetTupleKey sets field value
func (o *BatchCheckItem) SetTupleKey(v CheckRequestTupleKey) {
	o.TupleKey = v
}

// GetContextualTuples returns the ContextualTuples field value if set, zero value otherwise.
func (o *BatchCheckItem) GetContextualTuples() ContextualTupleKeys {
	if o == nil || o.ContextualTuples == nil {
		var ret ContextualTupleKeys
		return ret
	}
	return *o.ContextualTuples
}

// GetContextualTuplesOk returns a tuple with the ContextualTuples field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BatchCheckItem) GetContextualTuplesOk() (*ContextualTupleKeys, bool) {
	if o == nil || o.ContextualTuples == nil {
		return nil, false
	}
	return o.ContextualTuples, true
}

// HasContextualTuples returns a boolean if a field has been set.
func (o *BatchCheckItem) HasContextualTuples() bool {
	if o != nil && o.ContextualTuples != nil {
		return true
	}

	return false
}

// SetContextualTuples gets a reference to the given ContextualTupleKeys and assigns it to the ContextualTuples field.
func (o *BatchCheckItem) SetContextualTuples(v ContextualTupleKeys) {
	o.ContextualTuples = &v
}

// GetContext returns the Context field value if set, zero value otherwise.
func (o *BatchCheckItem) GetContext() map[string]interface{} {
	if o == nil || o.Context == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.Context
}

// GetContextOk returns a tuple with the Context field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BatchCheckItem) GetContextOk() (*map[string]interface{}, bool) {
	if o == nil || o.Context == nil {
		return nil, false
	}
	return o.Context, true
}

// HasContext returns a boolean if a field has been set.
func (o *BatchCheckItem) HasContext() bool {
	if o != nil && o.Context != nil {
		return true
	}

	return false
}

// SetContext gets a reference to the given map[string]interface{} and assigns it to the Context field.
func (o *BatchCheckItem) SetContext(v map[string]interface{}) {
	o.Context = &v
}

// GetCorrelationId returns the CorrelationId field value
func (o *BatchCheckItem) GetCorrelationId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.CorrelationId
}

// GetCorrelationIdOk returns a tuple with the CorrelationId field value
// and a boolean to check if the value has been set.
func (o *BatchCheckItem) GetCorrelationIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.CorrelationId, true
}

// SetCorrelationId sets field value
func (o *BatchCheckItem) SetCorrelationId(v string) {
	o.CorrelationId = v
}

func (o BatchCheckItem) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["tuple_key"] = o.TupleKey
	if o.ContextualTuples != nil {
		toSerialize["contextual_tuples"] = o.ContextualTuples
	}
	if o.Context != nil {
		toSerialize["context"] = o.Context
	}
	toSerialize["correlation_id"] = o.CorrelationId
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableBatchCheckItem struct {
	value *BatchCheckItem
	isSet bool
}

func (v NullableBatchCheckItem) Get() *BatchCheckItem {
	return v.value
}

func (v *NullableBatchCheckItem) Set(val *BatchCheckItem) {
	v.value = val
	v.isSet = true
}

func (v NullableBatchCheckItem) IsSet() bool {
	return v.isSet
}

func (v *NullableBatchCheckItem) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBatchCheckItem(val *BatchCheckItem) *NullableBatchCheckItem {
	return &NullableBatchCheckItem{value: val, isSet: true}
}

func (v NullableBatchCheckItem) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBatchCheckItem) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
