// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The details of an Amazon Web Services account.
type AccountDetails struct {

	// The ID of an Amazon Web Services account.
	//
	// This member is required.
	AccountId *string

	// The email of an Amazon Web Services account.
	Email *string

	noSmithyDocumentSerde
}

// Provides details about one of the following actions that affects or that was
// taken on a resource:
//
//   - A remote IP address issued an Amazon Web Services API call
//
//   - A DNS request was received
//
//   - A remote IP address attempted to connect to an EC2 instance
//
//   - A remote IP address attempted a port probe on an EC2 instance
type Action struct {

	// The type of action that was detected. The possible action types are:
	//
	//   - NETWORK_CONNECTION
	//
	//   - AWS_API_CALL
	//
	//   - DNS_REQUEST
	//
	//   - PORT_PROBE
	ActionType *string

	// Included if ActionType is AWS_API_CALL . Provides details about the API call
	// that was detected.
	AwsApiCallAction *AwsApiCallAction

	// Included if ActionType is DNS_REQUEST . Provides details about the DNS request
	// that was detected.
	DnsRequestAction *DnsRequestAction

	// Included if ActionType is NETWORK_CONNECTION . Provides details about the
	// network connection that was detected.
	NetworkConnectionAction *NetworkConnectionAction

	// Included if ActionType is PORT_PROBE . Provides details about the port probe
	// that was detected.
	PortProbeAction *PortProbeAction

	noSmithyDocumentSerde
}

// Provides information about the IP address where the scanned port is located.
type ActionLocalIpDetails struct {

	// The IP address.
	IpAddressV4 *string

	noSmithyDocumentSerde
}

// For NetworkConnectionAction and PortProbeDetails , LocalPortDetails provides
// information about the local port that was involved in the action.
type ActionLocalPortDetails struct {

	// The number of the port.
	Port *int32

	// The port name of the local connection.
	//
	// Length Constraints: 128.
	PortName *string

	noSmithyDocumentSerde
}

// For AwsApiAction , NetworkConnectionAction , and PortProbeAction ,
// RemoteIpDetails provides information about the remote IP address that was
// involved in the action.
type ActionRemoteIpDetails struct {

	// The city where the remote IP address is located.
	City *City

	// The country where the remote IP address is located.
	Country *Country

	// The coordinates of the location of the remote IP address.
	GeoLocation *GeoLocation

	// The IP address.
	IpAddressV4 *string

	// The internet service provider (ISP) organization associated with the remote IP
	// address.
	Organization *IpOrganizationDetails

	noSmithyDocumentSerde
}

// Provides information about the remote port that was involved in an attempted
// network connection.
type ActionRemotePortDetails struct {

	// The number of the port.
	Port *int32

	// The port name of the remote connection.
	//
	// Length Constraints: 128.
	PortName *string

	noSmithyDocumentSerde
}

// An ActionTarget object.
type ActionTarget struct {

	// The ARN for the target action.
	//
	// This member is required.
	ActionTargetArn *string

	// The description of the target action.
	//
	// This member is required.
	Description *string

	// The name of the action target.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// An adjustment to the CVSS metric.
type Adjustment struct {

	// The metric to adjust.
	Metric *string

	// The reason for the adjustment.
	Reason *string

	noSmithyDocumentSerde
}

// Represents a Security Hub administrator account designated by an organization
// management account.
type AdminAccount struct {

	// The Amazon Web Services account identifier of the Security Hub administrator
	// account.
	AccountId *string

	// The current status of the Security Hub administrator account. Indicates whether
	// the account is currently enabled as a Security Hub administrator.
	Status AdminStatus

	noSmithyDocumentSerde
}

//	Information about an enabled security standard in which a security control is
//
// enabled.
type AssociatedStandard struct {

	// The unique identifier of a standard in which a control is enabled. This field
	// consists of the resource portion of the Amazon Resource Name (ARN) returned for
	// a standard in the [DescribeStandards]API response.
	//
	// [DescribeStandards]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html
	StandardsId *string

	noSmithyDocumentSerde
}

//	Options for filtering the ListConfigurationPolicyAssociations response. You
//
// can filter by the Amazon Resource Name (ARN) or universally unique identifier
// (UUID) of a configuration policy, AssociationType , or AssociationStatus .
type AssociationFilters struct {

	//  The current status of the association between a target and a configuration
	// policy.
	AssociationStatus ConfigurationPolicyAssociationStatus

	//  Indicates whether the association between a target and a configuration was
	// directly applied by the Security Hub delegated administrator or inherited from a
	// parent.
	AssociationType AssociationType

	//  The ARN or UUID of the configuration policy.
	ConfigurationPolicyId *string

	noSmithyDocumentSerde
}

// The associations between a route table and one or more subnets or a gateway.
type AssociationSetDetails struct {

	//  The state of the association between a route table and a subnet or gateway.
	AssociationState *AssociationStateDetails

	//  The ID of the internet gateway or virtual private gateway.
	GatewayId *string

	//  Indicates whether this is the main route table.
	Main *bool

	//  The ID of the association.
	RouteTableAssociationId *string

	//  The ID of the route table.
	RouteTableId *string

	//  The ID of the subnet. A subnet ID is not returned for an implicit association.
	SubnetId *string

	noSmithyDocumentSerde
}

//	Describes the state of an association between a route table and a subnet or
//
// gateway.
type AssociationStateDetails struct {

	//  The state of the association.
	State *string

	//  The status message, if applicable.
	StatusMessage *string

	noSmithyDocumentSerde
}

//	One or more actions to update finding fields if a finding matches the defined
//
// criteria of the rule.
type AutomationRulesAction struct {

	//  Specifies that the automation rule action is an update to a finding field.
	FindingFieldsUpdate *AutomationRulesFindingFieldsUpdate

	//  Specifies that the rule action should update the Types finding field. The Types
	// finding field classifies findings in the format of
	// namespace/category/classifier. For more information, see [Types taxonomy for ASFF]in the Security Hub
	// User Guide.
	//
	// [Types taxonomy for ASFF]: https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html
	Type AutomationRulesActionType

	noSmithyDocumentSerde
}

// Defines the configuration of an automation rule.
type AutomationRulesConfig struct {

	//  One or more actions to update finding fields if a finding matches the defined
	// criteria of the rule.
	Actions []AutomationRulesAction

	//  A timestamp that indicates when the rule was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedAt *time.Time

	//  The principal that created a rule.
	CreatedBy *string

	//  A set of [Amazon Web Services Security Finding Format] finding field attributes and corresponding expected values that
	// Security Hub uses to filter findings. If a rule is enabled and a finding matches
	// the conditions specified in this parameter, Security Hub applies the rule action
	// to the finding.
	//
	// [Amazon Web Services Security Finding Format]: https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html
	Criteria *AutomationRulesFindingFilters

	//  A description of the rule.
	Description *string

	// Specifies whether a rule is the last to be applied with respect to a finding
	// that matches the rule criteria. This is useful when a finding matches the
	// criteria for multiple rules, and each rule has different actions. If a rule is
	// terminal, Security Hub applies the rule action to a finding that matches the
	// rule criteria and doesn't evaluate other rules for the finding. By default, a
	// rule isn't terminal.
	IsTerminal *bool

	//  The Amazon Resource Name (ARN) of a rule.
	RuleArn *string

	//  The name of the rule.
	RuleName *string

	//  An integer ranging from 1 to 1000 that represents the order in which the rule
	// action is applied to findings. Security Hub applies rules with lower values for
	// this parameter first.
	RuleOrder *int32

	//  Whether the rule is active after it is created. If this parameter is equal to
	// ENABLED , Security Hub starts applying the rule to findings and finding updates
	// after the rule is created.
	RuleStatus RuleStatus

	//  A timestamp that indicates when the rule was most recently updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

//	Identifies the finding fields that the automation rule action updates when a
//
// finding matches the defined criteria.
type AutomationRulesFindingFieldsUpdate struct {

	//  The rule action updates the Confidence field of a finding.
	Confidence *int32

	//  The rule action updates the Criticality field of a finding.
	Criticality *int32

	// The updated note.
	Note *NoteUpdate

	//  The rule action updates the RelatedFindings field of a finding.
	RelatedFindings []RelatedFinding

	// Updates to the severity information for a finding.
	Severity *SeverityUpdate

	//  The rule action updates the Types field of a finding.
	Types []string

	//  The rule action updates the UserDefinedFields field of a finding.
	UserDefinedFields map[string]string

	//  The rule action updates the VerificationState field of a finding.
	VerificationState VerificationState

	// Used to update information about the investigation into the finding.
	Workflow *WorkflowUpdate

	noSmithyDocumentSerde
}

// The criteria that determine which findings a rule applies to.
type AutomationRulesFindingFilters struct {

	// The Amazon Web Services account ID in which a finding was generated.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 100 items.
	AwsAccountId []StringFilter

	// The name of the Amazon Web Services account in which a finding was generated.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	AwsAccountName []StringFilter

	//  The name of the company for the product that generated the finding. For
	// control-based findings, the company is Amazon Web Services.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	CompanyName []StringFilter

	// The unique identifier of a standard in which a control is enabled. This field
	// consists of the resource portion of the Amazon Resource Name (ARN) returned for
	// a standard in the [DescribeStandards]API response.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	//
	// [DescribeStandards]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html
	ComplianceAssociatedStandardsId []StringFilter

	//  The security control ID for which a finding was generated. Security control
	// IDs are the same across standards.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ComplianceSecurityControlId []StringFilter

	//  The result of a security check. This field is only used for findings generated
	// from controls.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ComplianceStatus []StringFilter

	// The likelihood that a finding accurately identifies the behavior or issue that
	// it was intended to identify. Confidence is scored on a 0–100 basis using a
	// ratio scale. A value of 0 means 0 percent confidence, and a value of 100 means
	// 100 percent confidence. For example, a data exfiltration detection based on a
	// statistical deviation of network traffic has low confidence because an actual
	// exfiltration hasn't been verified. For more information, see [Confidence]in the Security
	// Hub User Guide.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	//
	// [Confidence]: https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence
	Confidence []NumberFilter

	//  A timestamp that indicates when this finding record was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	CreatedAt []DateFilter

	//  The level of importance that is assigned to the resources that are associated
	// with a finding. Criticality is scored on a 0–100 basis, using a ratio scale
	// that supports only full integers. A score of 0 means that the underlying
	// resources have no criticality, and a score of 100 is reserved for the most
	// critical resources. For more information, see [Criticality]in the Security Hub User Guide.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	//
	// [Criticality]: https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality
	Criticality []NumberFilter

	//  A finding's description.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	Description []StringFilter

	//  A timestamp that indicates when the potential security issue captured by a
	// finding was first observed by the security findings product.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	FirstObservedAt []DateFilter

	//  The identifier for the solution-specific component that generated a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 100 items.
	GeneratorId []StringFilter

	//  The product-specific identifier for a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	Id []StringFilter

	//  A timestamp that indicates when the potential security issue captured by a
	// finding was most recently observed by the security findings product.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	LastObservedAt []DateFilter

	//  The text of a user-defined note that's added to a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	NoteText []StringFilter

	//  The timestamp of when the note was updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	NoteUpdatedAt []DateFilter

	//  The principal that created a note.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	NoteUpdatedBy []StringFilter

	//  The Amazon Resource Name (ARN) for a third-party product that generated a
	// finding in Security Hub.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ProductArn []StringFilter

	//  Provides the name of the product that generated the finding. For control-based
	// findings, the product name is Security Hub.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ProductName []StringFilter

	//  Provides the current state of a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	RecordState []StringFilter

	//  The product-generated identifier for a related finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	RelatedFindingsId []StringFilter

	//  The ARN for the product that generated a related finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	RelatedFindingsProductArn []StringFilter

	//  The Amazon Resource Name (ARN) of the application that is related to a
	// finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ResourceApplicationArn []StringFilter

	//  The name of the application that is related to a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ResourceApplicationName []StringFilter

	//  Custom fields and values about the resource that a finding pertains to.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ResourceDetailsOther []MapFilter

	//  The identifier for the given resource type. For Amazon Web Services resources
	// that are identified by Amazon Resource Names (ARNs), this is the ARN. For Amazon
	// Web Services resources that lack ARNs, this is the identifier as defined by the
	// Amazon Web Service that created the resource. For non-Amazon Web Services
	// resources, this is a unique identifier that is associated with the resource.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 100 items.
	ResourceId []StringFilter

	//  The partition in which the resource that the finding pertains to is located. A
	// partition is a group of Amazon Web Services Regions. Each Amazon Web Services
	// account is scoped to one partition.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ResourcePartition []StringFilter

	//  The Amazon Web Services Region where the resource that a finding pertains to
	// is located.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ResourceRegion []StringFilter

	//  A list of Amazon Web Services tags associated with a resource at the time the
	// finding was processed.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ResourceTags []MapFilter

	//  The type of resource that the finding pertains to.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	ResourceType []StringFilter

	//  The severity value of the finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	SeverityLabel []StringFilter

	//  Provides a URL that links to a page about the current finding in the finding
	// product.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	SourceUrl []StringFilter

	//  A finding's title.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 100 items.
	Title []StringFilter

	//  One or more finding types in the format of namespace/category/classifier that
	// classify a finding. For a list of namespaces, classifiers, and categories, see [Types taxonomy for ASFF]
	// in the Security Hub User Guide.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	//
	// [Types taxonomy for ASFF]: https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html
	Type []StringFilter

	//  A timestamp that indicates when the finding record was most recently updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	UpdatedAt []DateFilter

	//  A list of user-defined name and value string pairs added to a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	UserDefinedFields []MapFilter

	//  Provides the veracity of a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	VerificationState []StringFilter

	//  Provides information about the status of the investigation into a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 20 items.
	WorkflowStatus []StringFilter

	noSmithyDocumentSerde
}

//	Metadata for automation rules in the calling account. The response includes
//
// rules with a RuleStatus of ENABLED and DISABLED .
type AutomationRulesMetadata struct {

	//  A timestamp that indicates when the rule was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedAt *time.Time

	//  The principal that created a rule.
	CreatedBy *string

	//  A description of the rule.
	Description *string

	// Specifies whether a rule is the last to be applied with respect to a finding
	// that matches the rule criteria. This is useful when a finding matches the
	// criteria for multiple rules, and each rule has different actions. If a rule is
	// terminal, Security Hub applies the rule action to a finding that matches the
	// rule criteria and doesn't evaluate other rules for the finding. By default, a
	// rule isn't terminal.
	IsTerminal *bool

	//  The Amazon Resource Name (ARN) for the rule.
	RuleArn *string

	//  The name of the rule.
	RuleName *string

	// An integer ranging from 1 to 1000 that represents the order in which the rule
	// action is applied to findings. Security Hub applies rules with lower values for
	// this parameter first.
	RuleOrder *int32

	//  Whether the rule is active after it is created. If this parameter is equal to
	// ENABLED , Security Hub starts applying the rule to findings and finding updates
	// after the rule is created. To change the value of this parameter after creating
	// a rule, use [BatchUpdateAutomationRules]BatchUpdateAutomationRules .
	//
	// [BatchUpdateAutomationRules]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html
	RuleStatus RuleStatus

	//  A timestamp that indicates when the rule was most recently updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information about an Availability Zone.
type AvailabilityZone struct {

	// The ID of the subnet. You can specify one subnet per Availability Zone.
	SubnetId *string

	// The name of the Availability Zone.
	ZoneName *string

	noSmithyDocumentSerde
}

//	Provides details about an Amazon MQ message broker. A message broker allows
//
// software applications and components to communicate using various programming
// languages, operating systems, and formal messaging protocols.
type AwsAmazonMqBrokerDetails struct {

	//  The authentication strategy used to secure the broker. The default is SIMPLE .
	AuthenticationStrategy *string

	//  Whether automatically upgrade new minor versions for brokers, as new versions
	// are released and supported by Amazon MQ. Automatic upgrades occur during the
	// scheduled maintenance window of the broker or after a manual broker reboot.
	AutoMinorVersionUpgrade *bool

	//  The Amazon Resource Name (ARN) of the broker.
	BrokerArn *string

	//  The unique ID that Amazon MQ generates for the broker.
	BrokerId *string

	// The broker's name.
	BrokerName *string

	//  The broker's deployment mode.
	DeploymentMode *string

	//  Encryption options for the broker. Doesn’t apply to RabbitMQ brokers.
	EncryptionOptions *AwsAmazonMqBrokerEncryptionOptionsDetails

	//  The type of broker engine.
	EngineType *string

	//  The version of the broker engine.
	EngineVersion *string

	//  The broker's instance type.
	HostInstanceType *string

	//  The metadata of the Lightweight Directory Access Protocol (LDAP) server used
	// to authenticate and authorize connections to the broker. This is an optional
	// failover server.
	LdapServerMetadata *AwsAmazonMqBrokerLdapServerMetadataDetails

	//  Turns on Amazon CloudWatch logging for brokers.
	Logs *AwsAmazonMqBrokerLogsDetails

	//  The scheduled time period (UTC) during which Amazon MQ begins to apply pending
	// updates or patches to the broker.
	MaintenanceWindowStartTime *AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails

	//  Permits connections from applications outside of the VPC that hosts the
	// broker's subnets.
	PubliclyAccessible *bool

	//  The list of rules (one minimum, 125 maximum) that authorize connections to
	// brokers.
	SecurityGroups []string

	//  The broker's storage type.
	StorageType *string

	//  The list of groups that define which subnets and IP ranges the broker can use
	// from different Availability Zones.
	SubnetIds []string

	//  The list of all broker usernames for the specified broker. Doesn't apply to
	// RabbitMQ brokers.
	Users []AwsAmazonMqBrokerUsersDetails

	noSmithyDocumentSerde
}

// Provides details about broker encryption options.
type AwsAmazonMqBrokerEncryptionOptionsDetails struct {

	//  The KMS key that’s used to encrypt your data at rest. If not provided, Amazon
	// MQ will use a default KMS key to encrypt your data.
	KmsKeyId *string

	//  Specifies that an KMS key should be used for at-rest encryption. Set to true
	// by default if no value is provided (for example, for RabbitMQ brokers).
	UseAwsOwnedKey *bool

	noSmithyDocumentSerde
}

//	The metadata of the Lightweight Directory Access Protocol (LDAP) server used
//
// to authenticate and authorize connections to the broker. This is an optional
// failover server.
type AwsAmazonMqBrokerLdapServerMetadataDetails struct {

	//  Specifies the location of the LDAP server, such as Amazon Web Services
	// Directory Service for Microsoft Active Directory.
	Hosts []string

	//  The distinguished name of the node in the directory information tree (DIT) to
	// search for roles or groups.
	RoleBase *string

	//  The group name attribute in a role entry whose value is the name of that role.
	RoleName *string

	//  The LDAP search filter used to find roles within the roleBase .
	RoleSearchMatching *string

	//  The directory search scope for the role. If set to true , the scope is to
	// search the entire subtree.
	RoleSearchSubtree *bool

	//  A username for the service account, which is an account in your LDAP server
	// that has access to initiate a connection.
	ServiceAccountUsername *string

	//  Selects a particular subtree of the directory information tree (DIT) to search
	// for user entries.
	UserBase *string

	//  The name of the LDAP attribute in the user's directory entry for the user's
	// group membership.
	UserRoleName *string

	//  The LDAP search filter used to find users within the userBase .
	UserSearchMatching *string

	//  The directory search scope for the user. If set to true, the scope is to
	// search the entire subtree.
	UserSearchSubtree *bool

	noSmithyDocumentSerde
}

// Provides information about logs to be activated for the specified broker.
type AwsAmazonMqBrokerLogsDetails struct {

	//  Activates audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged. Doesn't apply to RabbitMQ brokers.
	Audit *bool

	//  The location of the CloudWatch Logs log group where audit logs are sent.
	AuditLogGroup *string

	//  Activates general logging.
	General *bool

	//  The location of the CloudWatch Logs log group where general logs are sent.
	GeneralLogGroup *string

	//  The list of information about logs that are to be turned on for the specified
	// broker.
	Pending *AwsAmazonMqBrokerLogsPendingDetails

	noSmithyDocumentSerde
}

// Provides information about logs to be activated for the specified broker.
type AwsAmazonMqBrokerLogsPendingDetails struct {

	//  Activates audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged. Doesn't apply to RabbitMQ brokers.
	Audit *bool

	//  Activates general logging.
	General *bool

	noSmithyDocumentSerde
}

//	The scheduled time period (UTC) during which Amazon MQ begins to apply pending
//
// updates or patches to the broker.
type AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails struct {

	//  The day of the week on which the maintenance window falls.
	DayOfWeek *string

	//  The time, in 24-hour format, on which the maintenance window falls.
	TimeOfDay *string

	//  The time zone in either the Country/City format or the UTC offset format. UTC
	// is the default format.
	TimeZone *string

	noSmithyDocumentSerde
}

//	Provides details about the broker usernames for the specified broker. Doesn't
//
// apply to RabbitMQ brokers.
type AwsAmazonMqBrokerUsersDetails struct {

	//  The type of change pending for the broker user.
	PendingChange *string

	//  The username of the broker user.
	Username *string

	noSmithyDocumentSerde
}

// Provided if ActionType is AWS_API_CALL . It provides details about the API call
// that was detected.
type AwsApiCallAction struct {

	// Identifies the resources that were affected by the API call.
	AffectedResources map[string]string

	// The name of the API method that was issued.
	//
	// Length Constraints: 128.
	Api *string

	// Indicates whether the API call originated from a remote IP address ( remoteip )
	// or from a DNS domain ( domain ).
	CallerType *string

	// Provided if CallerType is domain . Provides information about the DNS domain
	// that the API call originated from.
	DomainDetails *AwsApiCallActionDomainDetails

	// A timestamp that indicates when the API call was first observed.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	FirstSeen *string

	// A timestamp that indicates when the API call was most recently observed.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastSeen *string

	// Provided if CallerType is remoteIp . Provides information about the remote IP
	// address that the API call originated from.
	RemoteIpDetails *ActionRemoteIpDetails

	// The name of the Amazon Web Services service that the API method belongs to.
	//
	// Length Constraints: 128.
	ServiceName *string

	noSmithyDocumentSerde
}

// Provided if CallerType is domain . It provides information about the DNS domain
// that issued the API call.
type AwsApiCallActionDomainDetails struct {

	// The name of the DNS domain that issued the API call.
	//
	// Length Constraints: 128.
	Domain *string

	noSmithyDocumentSerde
}

// Contains information about settings for logging access for the stage.
type AwsApiGatewayAccessLogSettings struct {

	// The ARN of the CloudWatch Logs log group that receives the access logs.
	DestinationArn *string

	// A single-line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId .
	Format *string

	noSmithyDocumentSerde
}

// Contains information about settings for canary deployment in the stage.
type AwsApiGatewayCanarySettings struct {

	// The deployment identifier for the canary deployment.
	DeploymentId *string

	// The percentage of traffic that is diverted to a canary deployment.
	PercentTraffic *float64

	// Stage variables that are overridden in the canary release deployment. The
	// variables include new stage variables that are introduced in the canary.
	//
	// Each variable is represented as a string-to-string map between the stage
	// variable name and the variable value.
	StageVariableOverrides map[string]string

	// Indicates whether the canary deployment uses the stage cache.
	UseStageCache *bool

	noSmithyDocumentSerde
}

// Contains information about the endpoints for the API.
type AwsApiGatewayEndpointConfiguration struct {

	// A list of endpoint types for the REST API.
	//
	// For an edge-optimized API, the endpoint type is EDGE . For a Regional API, the
	// endpoint type is REGIONAL . For a private API, the endpoint type is PRIVATE .
	Types []string

	noSmithyDocumentSerde
}

// Defines settings for a method for the stage.
type AwsApiGatewayMethodSettings struct {

	// Indicates whether the cached responses are encrypted.
	CacheDataEncrypted *bool

	// Specifies the time to live (TTL), in seconds, for cached responses. The higher
	// the TTL, the longer the response is cached.
	CacheTtlInSeconds *int32

	// Indicates whether responses are cached and returned for requests. For responses
	// to be cached, a cache cluster must be enabled on the stage.
	CachingEnabled *bool

	// Indicates whether data trace logging is enabled for the method. Data trace
	// logging affects the log entries that are pushed to CloudWatch Logs.
	DataTraceEnabled *bool

	// The HTTP method. You can use an asterisk (*) as a wildcard to apply method
	// settings to multiple methods.
	HttpMethod *string

	// The logging level for this method. The logging level affects the log entries
	// that are pushed to CloudWatch Logs.
	//
	// If the logging level is ERROR , then the logs only include error-level entries.
	//
	// If the logging level is INFO , then the logs include both ERROR events and
	// extra informational events.
	//
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string

	// Indicates whether CloudWatch metrics are enabled for the method.
	MetricsEnabled *bool

	// Indicates whether authorization is required for a cache invalidation request.
	RequireAuthorizationForCacheControl *bool

	// The resource path for this method. Forward slashes (/) are encoded as ~1 . The
	// initial slash must include a forward slash.
	//
	// For example, the path value /resource/subresource must be encoded as
	// /~1resource~1subresource .
	//
	// To specify the root path, use only a slash (/). You can use an asterisk (*) as
	// a wildcard to apply method settings to multiple methods.
	ResourcePath *string

	// The throttling burst limit for the method.
	ThrottlingBurstLimit *int32

	// The throttling rate limit for the method.
	ThrottlingRateLimit *float64

	// Indicates how to handle unauthorized requests for cache invalidation.
	//
	// Valid values: FAIL_WITH_403 | SUCCEED_WITH_RESPONSE_HEADER |
	// SUCCEED_WITHOUT_RESPONSE_HEADER
	UnauthorizedCacheControlHeaderStrategy *string

	noSmithyDocumentSerde
}

// Contains information about a REST API in version 1 of Amazon API Gateway.
type AwsApiGatewayRestApiDetails struct {

	// The source of the API key for metering requests according to a usage plan.
	//
	// HEADER indicates whether to read the API key from the X-API-Key header of a
	// request.
	//
	// AUTHORIZER indicates whether to read the API key from the UsageIdentifierKey
	// from a custom authorizer.
	ApiKeySource *string

	// The list of binary media types supported by the REST API.
	BinaryMediaTypes []string

	// Indicates when the API was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedDate *string

	// A description of the REST API.
	Description *string

	// The endpoint configuration of the REST API.
	EndpointConfiguration *AwsApiGatewayEndpointConfiguration

	// The identifier of the REST API.
	Id *string

	// The minimum size in bytes of a payload before compression is enabled.
	//
	// If null , then compression is disabled.
	//
	// If 0, then all payloads are compressed.
	MinimumCompressionSize *int32

	// The name of the REST API.
	Name *string

	// The version identifier for the REST API.
	Version *string

	noSmithyDocumentSerde
}

// Provides information about a version 1 Amazon API Gateway stage.
type AwsApiGatewayStageDetails struct {

	// Settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings

	// Indicates whether a cache cluster is enabled for the stage.
	CacheClusterEnabled *bool

	// If a cache cluster is enabled, the size of the cache cluster.
	CacheClusterSize *string

	// If a cache cluster is enabled, the status of the cache cluster.
	CacheClusterStatus *string

	// Information about settings for canary deployment in the stage.
	CanarySettings *AwsApiGatewayCanarySettings

	// The identifier of the client certificate for the stage.
	ClientCertificateId *string

	// Indicates when the stage was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedDate *string

	// The identifier of the deployment that the stage points to.
	DeploymentId *string

	// A description of the stage.
	Description *string

	// The version of the API documentation that is associated with the stage.
	DocumentationVersion *string

	// Indicates when the stage was most recently updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastUpdatedDate *string

	// Defines the method settings for the stage.
	MethodSettings []AwsApiGatewayMethodSettings

	// The name of the stage.
	StageName *string

	// Indicates whether active tracing with X-Ray is enabled for the stage.
	TracingEnabled *bool

	// A map that defines the stage variables for the stage.
	//
	// Variable names can have alphanumeric and underscore characters.
	//
	// Variable values can contain the following characters:
	//
	//   - Uppercase and lowercase letters
	//
	//   - Numbers
	//
	//   - Special characters -._~:/?#&=,
	Variables map[string]string

	// The ARN of the web ACL associated with the stage.
	WebAclArn *string

	noSmithyDocumentSerde
}

// Contains information about a version 2 API in Amazon API Gateway.
type AwsApiGatewayV2ApiDetails struct {

	// The URI of the API.
	//
	// Uses the format  .execute-api..amazonaws.com
	//
	// The stage name is typically appended to the URI to form a complete path to a
	// deployed API stage.
	ApiEndpoint *string

	// The identifier of the API.
	ApiId *string

	// An API key selection expression. Supported only for WebSocket APIs.
	ApiKeySelectionExpression *string

	// A cross-origin resource sharing (CORS) configuration. Supported only for HTTP
	// APIs.
	CorsConfiguration *AwsCorsConfiguration

	// Indicates when the API was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedDate *string

	// A description of the API.
	Description *string

	// The name of the API.
	Name *string

	// The API protocol for the API.
	//
	// Valid values: WEBSOCKET | HTTP
	ProtocolType *string

	// The route selection expression for the API.
	//
	// For HTTP APIs, must be ${request.method} ${request.path} . This is the default
	// value for HTTP APIs.
	//
	// For WebSocket APIs, there is no default value.
	RouteSelectionExpression *string

	// The version identifier for the API.
	Version *string

	noSmithyDocumentSerde
}

// Contains route settings for a stage.
type AwsApiGatewayV2RouteSettings struct {

	// Indicates whether data trace logging is enabled. Data trace logging affects the
	// log entries that are pushed to CloudWatch Logs. Supported only for WebSocket
	// APIs.
	DataTraceEnabled *bool

	// Indicates whether detailed metrics are enabled.
	DetailedMetricsEnabled *bool

	// The logging level. The logging level affects the log entries that are pushed to
	// CloudWatch Logs. Supported only for WebSocket APIs.
	//
	// If the logging level is ERROR , then the logs only include error-level entries.
	//
	// If the logging level is INFO , then the logs include both ERROR events and
	// extra informational events.
	//
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string

	// The throttling burst limit.
	ThrottlingBurstLimit *int32

	// The throttling rate limit.
	ThrottlingRateLimit *float64

	noSmithyDocumentSerde
}

// Contains information about a version 2 stage for Amazon API Gateway.
type AwsApiGatewayV2StageDetails struct {

	// Information about settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings

	// Indicates whether the stage is managed by API Gateway.
	ApiGatewayManaged *bool

	// Indicates whether updates to an API automatically trigger a new deployment.
	AutoDeploy *bool

	// The identifier of a client certificate for a stage. Supported only for
	// WebSocket API calls.
	ClientCertificateId *string

	// Indicates when the stage was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedDate *string

	// Default route settings for the stage.
	DefaultRouteSettings *AwsApiGatewayV2RouteSettings

	// The identifier of the deployment that the stage is associated with.
	DeploymentId *string

	// The description of the stage.
	Description *string

	// The status of the last deployment of a stage. Supported only if the stage has
	// automatic deployment enabled.
	LastDeploymentStatusMessage *string

	// Indicates when the stage was most recently updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastUpdatedDate *string

	// The route settings for the stage.
	RouteSettings *AwsApiGatewayV2RouteSettings

	// The name of the stage.
	StageName *string

	// A map that defines the stage variables for the stage.
	//
	// Variable names can have alphanumeric and underscore characters.
	//
	// Variable values can contain the following characters:
	//
	//   - Uppercase and lowercase letters
	//
	//   - Numbers
	//
	//   - Special characters -._~:/?#&=,
	StageVariables map[string]string

	noSmithyDocumentSerde
}

// A list of additional authentication providers for the GraphqlApi API.
type AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails struct {

	//  The type of security configuration for your GraphQL API: API key, Identity and
	// Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or
	// Lambda.
	AuthenticationType *string

	//  The configuration for Lambda function authorization.
	LambdaAuthorizerConfig *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails

	//  The OpenID Connect configuration.
	OpenIdConnectConfig *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails

	//  The Amazon Cognito user pools configuration.
	UserPoolConfig *AwsAppSyncGraphQlApiUserPoolConfigDetails

	noSmithyDocumentSerde
}

//	Provides details about an AppSync Graph QL API, which lets you query multiple
//
// databases, microservices, and APIs from a single GraphQL endpoint.
type AwsAppSyncGraphQlApiDetails struct {

	//  A list of additional authentication providers for the GraphQL API.
	AdditionalAuthenticationProviders []AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails

	//  The unique identifier for the API.
	ApiId *string

	//  The Amazon Resource Name (ARN) of the API.
	Arn *string

	//  The type of security configuration for your GraphQL API: API key, Identity and
	// Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or
	// Lambda.
	AuthenticationType *string

	// The unique identifier for the API.
	Id *string

	//  Specifies the configuration for Lambda function authorization.
	LambdaAuthorizerConfig *AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails

	//  The Amazon CloudWatch Logs configuration.
	LogConfig *AwsAppSyncGraphQlApiLogConfigDetails

	//  The API name.
	Name *string

	//  Specifies the authorization configuration for using an OpenID Connect
	// compliant service with an AppSync GraphQL API endpoint.
	OpenIdConnectConfig *AwsAppSyncGraphQlApiOpenIdConnectConfigDetails

	//  The Amazon Cognito user pools configuration.
	UserPoolConfig *AwsAppSyncGraphQlApiUserPoolConfigDetails

	//  The Amazon Resource Name (ARN) of the WAF web access control list (web ACL)
	// associated with this GraphQL API, if one exists.
	WafWebAclArn *string

	//  Indicates whether to use X-Ray tracing for the GraphQL API.
	XrayEnabled *bool

	noSmithyDocumentSerde
}

//	Specifies the authorization configuration for using an Lambda function with
//
// your AppSync GraphQL API endpoint.
type AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails struct {

	//  The number of seconds a response should be cached for. The default is 5
	// minutes (300 seconds).
	AuthorizerResultTtlInSeconds *int32

	//  The Amazon Resource Name (ARN) of the Lambda function to be called for
	// authorization. This can be a standard Lambda ARN, a version ARN (.../v3), or an
	// alias ARN.
	AuthorizerUri *string

	//  A regular expression for validation of tokens before the Lambda function is
	// called.
	IdentityValidationExpression *string

	noSmithyDocumentSerde
}

//	Specifies the logging configuration when writing GraphQL operations and
//
// tracing to Amazon CloudWatch for an AppSync GraphQL API.
type AwsAppSyncGraphQlApiLogConfigDetails struct {

	//  The Amazon Resource Name (ARN) of the service role that AppSync assumes to
	// publish to CloudWatch Logs in your account.
	CloudWatchLogsRoleArn *string

	//  Set to TRUE to exclude sections that contain information such as headers,
	// context, and evaluated mapping templates, regardless of logging level.
	ExcludeVerboseContent *bool

	//  The field logging level.
	FieldLogLevel *string

	noSmithyDocumentSerde
}

//	Specifies the authorization configuration for using an OpenID Connect
//
// compliant service with your AppSync GraphQL API endpoint.
type AwsAppSyncGraphQlApiOpenIdConnectConfigDetails struct {

	//  The number of milliseconds that a token is valid after being authenticated.
	AuthTtL *int64

	//  The client identifier of the relying party at the OpenID identity provider.
	// This identifier is typically obtained when the relying party is registered with
	// the OpenID identity provider. You can specify a regular expression so that
	// AppSync can validate against multiple client identifiers at a time.
	ClientId *string

	//  The number of milliseconds that a token is valid after it's issued to a user.
	IatTtL *int64

	//  The issuer for the OIDC configuration. The issuer returned by discovery must
	// exactly match the value of iss in the ID token.
	Issuer *string

	noSmithyDocumentSerde
}

//	Specifies the authorization configuration for using Amazon Cognito user pools
//
// with your AppSync GraphQL API endpoint.
type AwsAppSyncGraphQlApiUserPoolConfigDetails struct {

	//  A regular expression for validating the incoming Amazon Cognito user pools app
	// client ID. If this value isn't set, no filtering is applied.
	AppIdClientRegex *string

	//  The Amazon Web Services Region in which the user pool was created.
	AwsRegion *string

	//  The action that you want your GraphQL API to take when a request that uses
	// Amazon Cognito user pools authentication doesn't match the Amazon Cognito user
	// pools configuration.
	DefaultAction *string

	//  The user pool ID.
	UserPoolId *string

	noSmithyDocumentSerde
}

//	The configuration of the workgroup, which includes the location in Amazon
//
// Simple Storage Service (Amazon S3) where query results are stored, the
// encryption option, if any, used for query results, whether Amazon CloudWatch
// metrics are enabled for the workgroup, and the limit for the amount of bytes
// scanned (cutoff) per query, if it is specified.
type AwsAthenaWorkGroupConfigurationDetails struct {

	//  The location in Amazon S3 where query and calculation results are stored and
	// the encryption option, if any, used for query and calculation results. These are
	// known as client-side settings. If workgroup settings override client-side
	// settings, then the query uses the workgroup settings.
	ResultConfiguration *AwsAthenaWorkGroupConfigurationResultConfigurationDetails

	noSmithyDocumentSerde
}

//	The location in Amazon Simple Storage Service (Amazon S3) where query and
//
// calculation results are stored and the encryption option, if any, used for query
// and calculation results. These are known as client-side settings. If workgroup
// settings override client-side settings, then the query uses the workgroup
// settings.
type AwsAthenaWorkGroupConfigurationResultConfigurationDetails struct {

	//  Specifies the method used to encrypt the user’s data stores in the Athena
	// workgroup.
	EncryptionConfiguration *AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails

	noSmithyDocumentSerde
}

//	Specifies the method used to encrypt the user’s data stores in the Athena
//
// workgroup.
type AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails struct {

	//  Indicates whether Amazon Simple Storage Service (Amazon S3) server-side
	// encryption with Amazon S3 managed keys (SSE_S3), server-side encryption with KMS
	// keys (SSE_KMS), or client-side encryption with KMS customer managed keys
	// (CSE_KMS) is used.
	EncryptionOption *string

	//  For SSE_KMS and CSE_KMS , this is the KMS key Amazon Resource Name (ARN) or ID.
	KmsKey *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon Athena workgroup.
type AwsAthenaWorkGroupDetails struct {

	//  The configuration of the workgroup, which includes the location in Amazon
	// Simple Storage Service (Amazon S3) where query results are stored, the
	// encryption option, if any, used for query results, whether Amazon CloudWatch
	// metrics are enabled for the workgroup, and the limit for the amount of bytes
	// scanned (cutoff) per query, if it is specified.
	Configuration *AwsAthenaWorkGroupConfigurationDetails

	//  The workgroup description.
	Description *string

	//  The workgroup name.
	Name *string

	//  Whether the workgroup is enabled or disabled.
	State *string

	noSmithyDocumentSerde
}

// An Availability Zone for the automatic scaling group.
type AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails struct {

	// The name of the Availability Zone.
	Value *string

	noSmithyDocumentSerde
}

// Provides details about an auto scaling group.
type AwsAutoScalingAutoScalingGroupDetails struct {

	// The list of Availability Zones for the automatic scaling group.
	AvailabilityZones []AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails

	// Indicates whether capacity rebalancing is enabled.
	CapacityRebalance *bool

	// Indicates when the auto scaling group was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedTime *string

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it
	// checks the health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int32

	// The service to use for the health checks. Valid values are EC2 or ELB .
	HealthCheckType *string

	// The name of the launch configuration.
	LaunchConfigurationName *string

	// The launch template to use.
	LaunchTemplate *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification

	// The list of load balancers associated with the group.
	LoadBalancerNames []string

	// The mixed instances policy for the automatic scaling group.
	MixedInstancesPolicy *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails

	noSmithyDocumentSerde
}

// Details about the launch template to use.
type AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification struct {

	// The identifier of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName .
	LaunchTemplateId *string

	// The name of the launch template. You must specify either LaunchTemplateId or
	// LaunchTemplateName .
	LaunchTemplateName *string

	// Identifies the version of the launch template. You can specify a version
	// identifier, or use the values $Latest or $Default .
	Version *string

	noSmithyDocumentSerde
}

// The mixed instances policy for the automatic scaling group.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails struct {

	// The instances distribution. The instances distribution specifies the
	// distribution of On-Demand Instances and Spot Instances, the maximum price to pay
	// for Spot Instances, and how the Auto Scaling group allocates instance types to
	// fulfill On-Demand and Spot capacity.
	InstancesDistribution *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails

	// The launch template to use and the instance types (overrides) to use to
	// provision EC2 instances to fulfill On-Demand and Spot capacities.
	LaunchTemplate *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails

	noSmithyDocumentSerde
}

// Information about the instances distribution.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails struct {

	// How to allocate instance types to fulfill On-Demand capacity. The valid value
	// is prioritized .
	OnDemandAllocationStrategy *string

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances.
	OnDemandBaseCapacity *int32

	// The percentage of On-Demand Instances and Spot Instances for additional
	// capacity beyond OnDemandBaseCapacity .
	OnDemandPercentageAboveBaseCapacity *int32

	// How to allocate instances across Spot Instance pools. Valid values are as
	// follows:
	//
	//   - lowest-price
	//
	//   - capacity-optimized
	//
	//   - capacity-optimized-prioritized
	SpotAllocationStrategy *string

	// The number of Spot Instance pools across which to allocate your Spot Instances.
	SpotInstancePools *int32

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	SpotMaxPrice *string

	noSmithyDocumentSerde
}

// Describes a launch template and overrides for a mixed instances policy.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails struct {

	// The launch template to use for a mixed instances policy.
	LaunchTemplateSpecification *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification

	// Property values to use to override the values in the launch template.
	Overrides []AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails

	noSmithyDocumentSerde
}

// Details about the launch template to use for a mixed instances policy.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification struct {

	// The identifier of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName .
	LaunchTemplateId *string

	// The name of the launch template. You must specify either LaunchTemplateId or
	// LaunchTemplateName .
	LaunchTemplateName *string

	// Identifies the version of the launch template. You can specify a version
	// identifier, or use the values $Latest or $Default .
	Version *string

	noSmithyDocumentSerde
}

// Property values to use to override the values in the launch template.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails struct {

	// The instance type. For example, m3.xlarge .
	InstanceType *string

	// The number of capacity units provided by the specified instance type in terms
	// of virtual CPUs, memory, storage, throughput, or other relative performance
	// characteristic.
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// A block device for the instance.
type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails struct {

	// The device name that is exposed to the EC2 instance. For example, /dev/sdh or
	// xvdh .
	DeviceName *string

	// Parameters that are used to automatically set up Amazon EBS volumes when an
	// instance is launched.
	Ebs *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails

	// Whether to suppress the device that is included in the block device mapping of
	// the Amazon Machine Image (AMI).
	//
	// If NoDevice is true , then you cannot specify Ebs .>
	NoDevice *bool

	// The name of the virtual device (for example, ephemeral0 ).
	//
	// You can provide either VirtualName or Ebs , but not both.
	VirtualName *string

	noSmithyDocumentSerde
}

// Parameters that are used to automatically set up EBS volumes when an instance
// is launched.
type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails struct {

	// Whether to delete the volume when the instance is terminated.
	DeleteOnTermination *bool

	// Whether to encrypt the volume.
	Encrypted *bool

	// The number of input/output (I/O) operations per second (IOPS) to provision for
	// the volume.
	//
	// Only supported for gp3 or io1 volumes. Required for io1 volumes. Not used with
	// standard , gp2 , st1 , or sc1 volumes.
	Iops *int32

	// The snapshot ID of the volume to use.
	//
	// You must specify either VolumeSize or SnapshotId .
	SnapshotId *string

	// The volume size, in GiBs. The following are the supported volumes sizes for
	// each volume type:
	//
	//   - gp2 and gp3: 1-16,384
	//
	//   - io1: 4-16,384
	//
	//   - st1 and sc1: 125-16,384
	//
	//   - standard: 1-1,024
	//
	// You must specify either SnapshotId or VolumeSize . If you specify both
	// SnapshotId and VolumeSize , the volume size must be equal or greater than the
	// size of the snapshot.
	VolumeSize *int32

	// The volume type. Valid values are as follows:
	//
	//   - gp2
	//
	//   - gp3
	//
	//   - io1
	//
	//   - sc1
	//
	//   - st1
	//
	//   - standard
	VolumeType *string

	noSmithyDocumentSerde
}

// Details about a launch configuration.
type AwsAutoScalingLaunchConfigurationDetails struct {

	// For Auto Scaling groups that run in a VPC, specifies whether to assign a public
	// IP address to the group's instances.
	AssociatePublicIpAddress *bool

	// Specifies the block devices for the instance.
	BlockDeviceMappings []AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails

	// The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are
	// linked to.
	ClassicLinkVpcId *string

	// The identifiers of one or more security groups for the VPC that is specified in
	// ClassicLinkVPCId .
	ClassicLinkVpcSecurityGroups []string

	// The creation date and time for the launch configuration.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedTime *string

	// Whether the launch configuration is optimized for Amazon EBS I/O.
	EbsOptimized *bool

	// The name or the ARN of the instance profile associated with the IAM role for
	// the instance. The instance profile contains the IAM role.
	IamInstanceProfile *string

	// The identifier of the Amazon Machine Image (AMI) that is used to launch EC2
	// instances.
	ImageId *string

	// Indicates the type of monitoring for instances in the group.
	InstanceMonitoring *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails

	// The instance type for the instances.
	InstanceType *string

	// The identifier of the kernel associated with the AMI.
	KernelId *string

	// The name of the key pair.
	KeyName *string

	// The name of the launch configuration.
	LaunchConfigurationName *string

	// The metadata options for the instances.
	MetadataOptions *AwsAutoScalingLaunchConfigurationMetadataOptions

	// The tenancy of the instance. An instance with dedicated tenancy runs on
	// isolated, single-tenant hardware and can only be launched into a VPC.
	PlacementTenancy *string

	// The identifier of the RAM disk associated with the AMI.
	RamdiskId *string

	// The security groups to assign to the instances in the Auto Scaling group.
	SecurityGroups []string

	// The maximum hourly price to be paid for any Spot Instance that is launched to
	// fulfill the request.
	SpotPrice *string

	// The user data to make available to the launched EC2 instances. Must be
	// base64-encoded text.
	UserData *string

	noSmithyDocumentSerde
}

// Information about the type of monitoring for instances in the group.
type AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails struct {

	// If set to true , then instances in the group launch with detailed monitoring.
	//
	// If set to false , then instances in the group launch with basic monitoring.
	Enabled *bool

	noSmithyDocumentSerde
}

// The metadata options for the instances.
type AwsAutoScalingLaunchConfigurationMetadataOptions struct {

	// Enables or disables the HTTP metadata endpoint on your instances. By default,
	// the metadata endpoint is enabled.
	HttpEndpoint *string

	// The HTTP PUT response hop limit for instance metadata requests. The larger the
	// number, the further instance metadata requests can travel.
	HttpPutResponseHopLimit *int32

	// Indicates whether token usage is required or optional for metadata requests. By
	// default, token usage is optional .
	HttpTokens *string

	noSmithyDocumentSerde
}

// Provides a list of backup options for each resource type.
type AwsBackupBackupPlanAdvancedBackupSettingsDetails struct {

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows Volume Shadow Copy Service (VSS) backup jobs. Valid values
	// are as follows:
	//
	//   - Set to WindowsVSS: enabled to enable the WindowsVSS backup option and create
	//   a Windows VSS backup.
	//
	//   - Set to WindowsVSS: disabled to create a regular backup. The WindowsVSS
	//   option is not enabled by default.
	BackupOptions map[string]string

	// The name of a resource type. The only supported resource type is Amazon EC2
	// instances with Windows VSS.
	//
	// The only valid value is EC2 .
	ResourceType *string

	noSmithyDocumentSerde
}

// Provides details about an Backup backup plan and an array of BackupRule
// objects, each of which specifies a backup rule.
type AwsBackupBackupPlanBackupPlanDetails struct {

	// A list of backup options for each resource type.
	AdvancedBackupSettings []AwsBackupBackupPlanAdvancedBackupSettingsDetails

	// The display name of a backup plan.
	BackupPlanName *string

	// An array of BackupRule objects, each of which specifies a scheduled task that
	// is used to back up a selection of resources.
	BackupPlanRule []AwsBackupBackupPlanRuleDetails

	noSmithyDocumentSerde
}

// Provides details about an Backup backup plan and an array of BackupRule
// objects, each of which specifies a backup rule.
type AwsBackupBackupPlanDetails struct {

	// Uniquely identifies the backup plan to be associated with the selection of
	// resources.
	BackupPlan *AwsBackupBackupPlanBackupPlanDetails

	// An Amazon Resource Name (ARN) that uniquely identifies the backup plan.
	BackupPlanArn *string

	// A unique ID for the backup plan.
	BackupPlanId *string

	// Unique, randomly generated, Unicode, UTF-8 encoded strings. Version IDs cannot
	// be edited.
	VersionId *string

	noSmithyDocumentSerde
}

// Provides lifecycle details for the backup plan. A lifecycle defines when a
// backup is transitioned to cold storage and when it expires.
type AwsBackupBackupPlanLifecycleDetails struct {

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than 90 days plus MoveToColdStorageAfterDays .
	DeleteAfterDays *int64

	// Specifies the number of days after creation that a recovery point is moved to
	// cold storage.
	MoveToColdStorageAfterDays *int64

	noSmithyDocumentSerde
}

// An array of CopyAction objects, each of which contains details of the copy
// operation.
type AwsBackupBackupPlanRuleCopyActionsDetails struct {

	// An Amazon Resource Name (ARN) that uniquely identifies the destination backup
	// vault for the copied backup.
	DestinationBackupVaultArn *string

	// Defines when a protected resource is transitioned to cold storage and when it
	// expires. Backup transitions and expires backups automatically according to the
	// lifecycle that you define. If you do not specify a lifecycle, Backup applies the
	// lifecycle policy of the source backup to the destination backup.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days.
	Lifecycle *AwsBackupBackupPlanLifecycleDetails

	noSmithyDocumentSerde
}

// Provides details about an array of BackupRule objects, each of which specifies
// a scheduled task that is used to back up a selection of resources.
type AwsBackupBackupPlanRuleDetails struct {

	// A value in minutes after a backup job is successfully started before it must be
	// completed, or it is canceled by Backup.
	CompletionWindowMinutes *int64

	// An array of CopyAction objects, each of which contains details of the copy
	// operation.
	CopyActions []AwsBackupBackupPlanRuleCopyActionsDetails

	// Specifies whether Backup creates continuous backups capable of point-in-time
	// restore (PITR).
	EnableContinuousBackup *bool

	// Defines when a protected resource is transitioned to cold storage and when it
	// expires. Backup transitions and expires backups automatically according to the
	// lifecycle that you define. If you do not specify a lifecycle, Backup applies the
	// lifecycle policy of the source backup to the destination backup.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days.
	Lifecycle *AwsBackupBackupPlanLifecycleDetails

	// Uniquely identifies a rule that is used to schedule the backup of a selection
	// of resources.
	RuleId *string

	// A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	RuleName *string

	// A cron expression in UTC specifying when Backup initiates a backup job.
	ScheduleExpression *string

	// A value in minutes after a backup is scheduled before a job will be canceled if
	// it doesn't start successfully.
	StartWindowMinutes *int64

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the Amazon Web Services account used to
	// create them and the Amazon Web Services Region where they are created. They
	// consist of letters, numbers, and hyphens.
	TargetBackupVault *string

	noSmithyDocumentSerde
}

// Provides details about an Backup backup vault. In Backup, a backup vault is a
// container that stores and organizes your backups.
type AwsBackupBackupVaultDetails struct {

	// A resource-based policy that is used to manage access permissions on the target
	// backup vault.
	AccessPolicy *string

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the Amazon Web Services account used to
	// create them and the Amazon Web Services Region where they are created. They
	// consist of lowercase letters, numbers, and hyphens.
	BackupVaultName *string

	// The unique ARN associated with the server-side encryption key. You can specify
	// a key to encrypt your backups from services that support full Backup management.
	// If you do not specify a key, Backup creates an KMS key for you by default.
	EncryptionKeyArn *string

	// The Amazon SNS event notifications for the specified backup vault.
	Notifications *AwsBackupBackupVaultNotificationsDetails

	noSmithyDocumentSerde
}

// Provides details about the Amazon SNS event notifications for the specified
// backup vault.
type AwsBackupBackupVaultNotificationsDetails struct {

	// An array of events that indicate the status of jobs to back up resources to the
	// backup vault. The following events are supported:
	//
	//   - BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED
	//
	//   - COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED
	//
	//   - RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED
	//
	//   - S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED
	BackupVaultEvents []string

	// The Amazon Resource Name (ARN) that uniquely identifies the Amazon SNS topic
	// for a backup vault's events.
	SnsTopicArn *string

	noSmithyDocumentSerde
}

// Specifies how long in days before a recovery point transitions to cold storage
// or is deleted.
type AwsBackupRecoveryPointCalculatedLifecycleDetails struct {

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than 90 days plus MoveToColdStorageAfterDays .
	DeleteAt *string

	// Specifies the number of days after creation that a recovery point is moved to
	// cold storage.
	MoveToColdStorageAt *string

	noSmithyDocumentSerde
}

// Contains information about the backup plan and rule that Backup used to
// initiate the recovery point backup.
type AwsBackupRecoveryPointCreatedByDetails struct {

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan.
	BackupPlanArn *string

	// Uniquely identifies a backup plan.
	BackupPlanId *string

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	BackupPlanVersion *string

	// Uniquely identifies a rule used to schedule the backup of a selection of
	// resources.
	BackupRuleId *string

	noSmithyDocumentSerde
}

// Contains detailed information about the recovery points stored in an Backup
// backup vault. A backup, or recovery point, represents the content of a resource
// at a specified time.
type AwsBackupRecoveryPointDetails struct {

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the Amazon Web Services account used to
	// create them and the Amazon Web Services Region where they are created. They
	// consist of lowercase letters, numbers, and hyphens.
	BackupVaultName *string

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *AwsBackupRecoveryPointCalculatedLifecycleDetails

	// The date and time that a job to create a recovery point is completed, in Unix
	// format and UTC. The value of CompletionDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionDate *string

	// Contains identifying information about the creation of a recovery point,
	// including the BackupPlanArn , BackupPlanId , BackupPlanVersion , and
	// BackupRuleId of the backup plan that is used to create it.
	CreatedBy *AwsBackupRecoveryPointCreatedByDetails

	// The date and time a recovery point is created, in Unix format and UTC. The
	// value of CreationDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	CreationDate *string

	// The ARN for the server-side encryption key that is used to protect your
	// backups.
	EncryptionKeyArn *string

	// Specifies the IAM role ARN used to create the target recovery point
	IamRoleArn *string

	// A Boolean value that is returned as TRUE if the specified recovery point is
	// encrypted, or FALSE if the recovery point is not encrypted.
	IsEncrypted *bool

	// The date and time that a recovery point was last restored, in Unix format and
	// UTC. The value of LastRestoreTime is accurate to milliseconds. For example, the
	// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastRestoreTime *string

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define
	Lifecycle *AwsBackupRecoveryPointLifecycleDetails

	// An ARN that uniquely identifies a recovery point.
	RecoveryPointArn *string

	// An ARN that uniquely identifies a resource. The format of the ARN depends on
	// the resource type.
	ResourceArn *string

	// The type of Amazon Web Services resource saved as a recovery point, such as an
	// Amazon EBS volume or an Amazon RDS database.
	ResourceType *string

	// The ARN for the backup vault where the recovery point was originally copied
	// from. If the recovery point is restored to the same account, this value will be
	// null.
	SourceBackupVaultArn *string

	// A status code specifying the state of the recovery point. Valid values are as
	// follows:
	//
	//   - COMPLETED
	//
	//   - DELETING
	//
	//   - EXPIRED
	//
	//   - PARTIAL
	Status *string

	// A message explaining the reason of the recovery point deletion failure.
	StatusMessage *string

	// Specifies the storage class of the recovery point. Valid values are as follows:
	//
	//   - COLD
	//
	//   - DELETED
	//
	//   - WARM
	StorageClass *string

	noSmithyDocumentSerde
}

// Contains an array of Transition objects specifying how long in days before a
// recovery point transitions to cold storage or is deleted.
type AwsBackupRecoveryPointLifecycleDetails struct {

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than 90 days plus MoveToColdStorageAfterDays .
	DeleteAfterDays *int64

	// Specifies the number of days after creation that a recovery point is moved to
	// cold storage.
	MoveToColdStorageAfterDays *int64

	noSmithyDocumentSerde
}

// Provides details about an Certificate Manager certificate.
type AwsCertificateManagerCertificateDetails struct {

	// The ARN of the private certificate authority (CA) that will be used to issue
	// the certificate.
	CertificateAuthorityArn *string

	// Indicates when the certificate was requested.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedAt *string

	// The fully qualified domain name (FQDN), such as www.example.com, that is
	// secured by the certificate.
	DomainName *string

	// Contains information about the initial validation of each domain name that
	// occurs as a result of the RequestCertificate request.
	//
	// Only provided if the certificate type is AMAZON_ISSUED .
	DomainValidationOptions []AwsCertificateManagerCertificateDomainValidationOption

	// Contains a list of Extended Key Usage X.509 v3 extension objects. Each object
	// specifies a purpose for which the certificate public key can be used and
	// consists of a name and an object identifier (OID).
	ExtendedKeyUsages []AwsCertificateManagerCertificateExtendedKeyUsage

	// For a failed certificate request, the reason for the failure.
	//
	// Valid values: NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED |
	// DOMAIN_NOT_ALLOWED | INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED |
	// CAA_ERROR | PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE |
	// PCA_REQUEST_FAILED | PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND |
	// PCA_INVALID_ARGS | PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND |
	// OTHER
	FailureReason *string

	// Indicates when the certificate was imported. Provided if the certificate type
	// is IMPORTED .
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ImportedAt *string

	// The list of ARNs for the Amazon Web Services resources that use the certificate.
	InUseBy []string

	// Indicates when the certificate was issued. Provided if the certificate type is
	// AMAZON_ISSUED .
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	IssuedAt *string

	// The name of the certificate authority that issued and signed the certificate.
	Issuer *string

	// The algorithm that was used to generate the public-private key pair.
	//
	// Valid values: RSA_2048 | RSA_1024 | RSA_4096 | EC_prime256v1 | EC_secp384r1 |
	// EC_secp521r1
	KeyAlgorithm *string

	// A list of key usage X.509 v3 extension objects.
	KeyUsages []AwsCertificateManagerCertificateKeyUsage

	// The time after which the certificate becomes invalid.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	NotAfter *string

	// The time before which the certificate is not valid.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	NotBefore *string

	// Provides a value that specifies whether to add the certificate to a
	// transparency log.
	Options *AwsCertificateManagerCertificateOptions

	// Whether the certificate is eligible for renewal.
	//
	// Valid values: ELIGIBLE | INELIGIBLE
	RenewalEligibility *string

	// Information about the status of the Certificate Manager managed renewal for the
	// certificate. Provided only when the certificate type is AMAZON_ISSUED .
	RenewalSummary *AwsCertificateManagerCertificateRenewalSummary

	// The serial number of the certificate.
	Serial *string

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string

	// The status of the certificate.
	//
	// Valid values: PENDING_VALIDATION | ISSUED | INACTIVE | EXPIRED |
	// VALIDATION_TIMED_OUT | REVOKED | FAILED
	Status *string

	// The name of the entity that is associated with the public key contained in the
	// certificate.
	Subject *string

	// One or more domain names (subject alternative names) included in the
	// certificate. This list contains the domain names that are bound to the public
	// key that is contained in the certificate.
	//
	// The subject alternative names include the canonical domain name (CN) of the
	// certificate and additional domain names that can be used to connect to the
	// website.
	SubjectAlternativeNames []string

	// The source of the certificate. For certificates that Certificate Manager
	// provides, Type is AMAZON_ISSUED . For certificates that are imported with
	// ImportCertificate , Type is IMPORTED .
	//
	// Valid values: IMPORTED | AMAZON_ISSUED | PRIVATE
	Type *string

	noSmithyDocumentSerde
}

// Contains information about one of the following:
//
//   - The initial validation of each domain name that occurs as a result of the
//     RequestCertificate request
//
//   - The validation of each domain name in the certificate, as it pertains to
//     Certificate Manager managed renewal
type AwsCertificateManagerCertificateDomainValidationOption struct {

	// A fully qualified domain name (FQDN) in the certificate.
	DomainName *string

	// The CNAME record that is added to the DNS database for domain validation.
	ResourceRecord *AwsCertificateManagerCertificateResourceRecord

	// The domain name that Certificate Manager uses to send domain validation emails.
	ValidationDomain *string

	// A list of email addresses that Certificate Manager uses to send domain
	// validation emails.
	ValidationEmails []string

	// The method used to validate the domain name.
	ValidationMethod *string

	// The validation status of the domain name.
	ValidationStatus *string

	noSmithyDocumentSerde
}

// Contains information about an extended key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateExtendedKeyUsage struct {

	// The name of an extension value. Indicates the purpose for which the certificate
	// public key can be used.
	Name *string

	// An object identifier (OID) for the extension value.
	//
	// The format is numbers separated by periods.
	OId *string

	noSmithyDocumentSerde
}

// Contains information about a key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateKeyUsage struct {

	// The key usage extension name.
	Name *string

	noSmithyDocumentSerde
}

// Contains other options for the certificate.
type AwsCertificateManagerCertificateOptions struct {

	// Whether to add the certificate to a transparency log.
	//
	// Valid values: DISABLED | ENABLED
	CertificateTransparencyLoggingPreference *string

	noSmithyDocumentSerde
}

// Contains information about the Certificate Manager managed renewal for an
// AMAZON_ISSUED certificate.
type AwsCertificateManagerCertificateRenewalSummary struct {

	// Information about the validation of each domain name in the certificate, as it
	// pertains to Certificate Manager managed renewal. Provided only when the
	// certificate type is AMAZON_ISSUED .
	DomainValidationOptions []AwsCertificateManagerCertificateDomainValidationOption

	// The status of the Certificate Manager managed renewal of the certificate.
	//
	// Valid values: PENDING_AUTO_RENEWAL | PENDING_VALIDATION | SUCCESS | FAILED
	RenewalStatus *string

	// The reason that a renewal request was unsuccessful. This attribute is used only
	// when RenewalStatus is FAILED .
	//
	// Valid values: NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED |
	// DOMAIN_NOT_ALLOWED | INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED |
	// CAA_ERROR | PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE |
	// PCA_REQUEST_FAILED | PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND |
	// PCA_INVALID_ARGS | PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND |
	// OTHER
	RenewalStatusReason *string

	// Indicates when the renewal summary was last updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	UpdatedAt *string

	noSmithyDocumentSerde
}

// Provides details about the CNAME record that is added to the DNS database for
// domain validation.
type AwsCertificateManagerCertificateResourceRecord struct {

	// The name of the resource.
	Name *string

	// The type of resource.
	Type *string

	// The value of the resource.
	Value *string

	noSmithyDocumentSerde
}

// Nests a stack as a resource in a top-level template. Nested stacks are stacks
// created as resources for another stack.
type AwsCloudFormationStackDetails struct {

	// The capabilities allowed in the stack.
	Capabilities []string

	// The time at which the stack was created.
	CreationTime *string

	// A user-defined description associated with the stack.
	Description *string

	// Boolean to enable or disable rollback on stack creation failures.
	DisableRollback *bool

	// Information about whether a stack's actual configuration differs, or has
	// drifted, from its expected configuration, as defined in the stack template and
	// any values specified as template parameters.
	DriftInformation *AwsCloudFormationStackDriftInformationDetails

	// Whether termination protection is enabled for the stack.
	EnableTerminationProtection *bool

	// The time the nested stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *string

	// The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related
	// events are published.
	NotificationArns []string

	// A list of output structures.
	Outputs []AwsCloudFormationStackOutputsDetails

	// The ARN of an IAM role that's associated with the stack.
	RoleArn *string

	// Unique identifier of the stack.
	StackId *string

	// The name associated with the stack.
	StackName *string

	// Current status of the stack.
	StackStatus *string

	// Success or failure message associated with the stack status.
	StackStatusReason *string

	// The length of time, in minutes, that CloudFormation waits for the nested stack
	// to reach the CREATE_COMPLETE state.
	TimeoutInMinutes *int32

	noSmithyDocumentSerde
}

// Provides information about the stack's conformity to its expected template
// configuration.
type AwsCloudFormationStackDriftInformationDetails struct {

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	StackDriftStatus *string

	noSmithyDocumentSerde
}

// Provides information about the CloudFormation stack output.
type AwsCloudFormationStackOutputsDetails struct {

	// A user-defined description associated with the output.
	Description *string

	// The key associated with the output.
	OutputKey *string

	// The value associated with the output.
	OutputValue *string

	noSmithyDocumentSerde
}

// Information about a cache behavior for the distribution.
type AwsCloudFrontDistributionCacheBehavior struct {

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	//   - allow-all - Viewers can use HTTP or HTTPS.
	//
	//   - redirect-to-https - CloudFront responds to HTTP requests with an HTTP status
	//   code of 301 (Moved Permanently) and the HTTPS URL. The viewer then uses the new
	//   URL to resubmit.
	//
	//   - https-only - CloudFront responds to HTTP request with an HTTP status code of
	//   403 (Forbidden).
	ViewerProtocolPolicy *string

	noSmithyDocumentSerde
}

// Provides information about caching for the CloudFront distribution.
type AwsCloudFrontDistributionCacheBehaviors struct {

	// The cache behaviors for the distribution.
	Items []AwsCloudFrontDistributionCacheBehavior

	noSmithyDocumentSerde
}

// Contains information about the default cache configuration for the CloudFront
// distribution.
type AwsCloudFrontDistributionDefaultCacheBehavior struct {

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	//   - allow-all - Viewers can use HTTP or HTTPS.
	//
	//   - redirect-to-https - CloudFront responds to HTTP requests with an HTTP status
	//   code of 301 (Moved Permanently) and the HTTPS URL. The viewer then uses the new
	//   URL to resubmit.
	//
	//   - https-only - CloudFront responds to HTTP request with an HTTP status code of
	//   403 (Forbidden).
	ViewerProtocolPolicy *string

	noSmithyDocumentSerde
}

// A CloudFront distribution configuration.
type AwsCloudFrontDistributionDetails struct {

	// Provides information about the cache configuration for the distribution.
	CacheBehaviors *AwsCloudFrontDistributionCacheBehaviors

	// The default cache behavior for the configuration.
	DefaultCacheBehavior *AwsCloudFrontDistributionDefaultCacheBehavior

	// The object that CloudFront sends in response to requests from the origin (for
	// example, index.html) when a viewer requests the root URL for the distribution
	// (http://www.example.com) instead of an object in your distribution
	// (http://www.example.com/product-description.html).
	DefaultRootObject *string

	// The domain name corresponding to the distribution.
	DomainName *string

	// The entity tag is a hash of the object.
	ETag *string

	// Indicates when that the distribution was last modified.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastModifiedTime *string

	// A complex type that controls whether access logs are written for the
	// distribution.
	Logging *AwsCloudFrontDistributionLogging

	// Provides information about the origin groups in the distribution.
	OriginGroups *AwsCloudFrontDistributionOriginGroups

	// A complex type that contains information about origins for this distribution.
	Origins *AwsCloudFrontDistributionOrigins

	// Indicates the current status of the distribution.
	Status *string

	// Provides information about the TLS/SSL configuration that the distribution uses
	// to communicate with viewers.
	ViewerCertificate *AwsCloudFrontDistributionViewerCertificate

	// A unique identifier that specifies the WAF web ACL, if any, to associate with
	// this distribution.
	WebAclId *string

	noSmithyDocumentSerde
}

// A complex type that controls whether access logs are written for the CloudFront
// distribution.
type AwsCloudFrontDistributionLogging struct {

	// The S3 bucket to store the access logs in.
	Bucket *string

	// With this field, you can enable or disable the selected distribution.
	Enabled *bool

	// Specifies whether you want CloudFront to include cookies in access logs.
	IncludeCookies *bool

	// An optional string that you want CloudFront to use as a prefix to the access
	// log filenames for this distribution.
	Prefix *string

	noSmithyDocumentSerde
}

// A custom origin. A custom origin is any origin that is not an Amazon S3 bucket,
// with one exception. An Amazon S3 bucket that is [configured with static website hosting]is a custom origin.
//
// [configured with static website hosting]: https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html
type AwsCloudFrontDistributionOriginCustomOriginConfig struct {

	// The HTTP port that CloudFront uses to connect to the origin.
	HttpPort *int32

	// The HTTPS port that CloudFront uses to connect to the origin.
	HttpsPort *int32

	// Specifies how long, in seconds, CloudFront persists its connection to the
	// origin.
	OriginKeepaliveTimeout *int32

	// Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the
	// origin.
	OriginProtocolPolicy *string

	// Specifies how long, in seconds, CloudFront waits for a response from the
	// origin.
	OriginReadTimeout *int32

	// Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to
	// your origin over HTTPS.
	OriginSslProtocols *AwsCloudFrontDistributionOriginSslProtocols

	noSmithyDocumentSerde
}

// Information about an origin group for the CloudFront distribution.
type AwsCloudFrontDistributionOriginGroup struct {

	// Provides the criteria for an origin group to fail over.
	FailoverCriteria *AwsCloudFrontDistributionOriginGroupFailover

	noSmithyDocumentSerde
}

// Provides information about when an origin group fails over.
type AwsCloudFrontDistributionOriginGroupFailover struct {

	// Information about the status codes that cause an origin group to fail over.
	StatusCodes *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes

	noSmithyDocumentSerde
}

// The status codes that cause an origin group to fail over.
type AwsCloudFrontDistributionOriginGroupFailoverStatusCodes struct {

	// The list of status code values that can cause a failover to the next origin.
	Items []int32

	// The number of status codes that can cause a failover.
	Quantity *int32

	noSmithyDocumentSerde
}

// Provides information about origin groups that are associated with the
// CloudFront distribution.
type AwsCloudFrontDistributionOriginGroups struct {

	// The list of origin groups.
	Items []AwsCloudFrontDistributionOriginGroup

	noSmithyDocumentSerde
}

// A complex type that describes the Amazon S3 bucket, HTTP server (for example, a
// web server), Elemental MediaStore, or other server from which CloudFront gets
// your files.
type AwsCloudFrontDistributionOriginItem struct {

	// An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3
	// bucket is configured with static website hosting, use this attribute. If the
	// Amazon S3 bucket is not configured with static website hosting, use the
	// S3OriginConfig type instead.
	CustomOriginConfig *AwsCloudFrontDistributionOriginCustomOriginConfig

	// Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront
	// to get objects for this origin.
	DomainName *string

	// A unique identifier for the origin or origin group.
	Id *string

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin.
	OriginPath *string

	// An origin that is an S3 bucket that is not configured with static website
	// hosting.
	S3OriginConfig *AwsCloudFrontDistributionOriginS3OriginConfig

	noSmithyDocumentSerde
}

// A complex type that contains information about origins and origin groups for
// this CloudFront distribution.
type AwsCloudFrontDistributionOrigins struct {

	// A complex type that contains origins or origin groups for this distribution.
	Items []AwsCloudFrontDistributionOriginItem

	noSmithyDocumentSerde
}

// Information about an origin that is an Amazon S3 bucket that is not configured
// with static website hosting.
type AwsCloudFrontDistributionOriginS3OriginConfig struct {

	// The CloudFront origin access identity to associate with the origin.
	OriginAccessIdentity *string

	noSmithyDocumentSerde
}

// A complex type that contains information about the SSL/TLS protocols that
// CloudFront can use when establishing an HTTPS connection with your origin.
type AwsCloudFrontDistributionOriginSslProtocols struct {

	// A list that contains allowed SSL/TLS protocols for this distribution.
	Items []string

	// The number of SSL/TLS protocols that you want to allow CloudFront to use when
	// establishing an HTTPS connection with this origin.
	Quantity *int32

	noSmithyDocumentSerde
}

// Provides information about the TLS/SSL configuration that the CloudFront
// distribution uses to communicate with viewers.
type AwsCloudFrontDistributionViewerCertificate struct {

	// The ARN of the ACM certificate. Used if the certificate is stored in ACM. If
	// you provide an ACM certificate ARN, you must also provide
	// MinimumCertificateVersion and SslSupportMethod .
	AcmCertificateArn *string

	// The identifier of the certificate. Note that in CloudFront, this attribute is
	// deprecated.
	Certificate *string

	// The source of the certificate identified by Certificate . Note that in
	// CloudFront, this attribute is deprecated.
	CertificateSource *string

	// Whether the distribution uses the CloudFront domain name. If set to false , then
	// you provide either AcmCertificateArn or IamCertificateId .
	CloudFrontDefaultCertificate *bool

	// The identifier of the IAM certificate. Used if the certificate is stored in
	// IAM. If you provide IamCertificateId , then you also must provide
	// MinimumProtocolVersion and SslSupportMethod .
	IamCertificateId *string

	// The security policy that CloudFront uses for HTTPS connections with viewers. If
	// SslSupportMethod is sni-only , then MinimumProtocolVersion must be TLSv1 or
	// higher.
	MinimumProtocolVersion *string

	// The viewers that the distribution accepts HTTPS connections from.
	SslSupportMethod *string

	noSmithyDocumentSerde
}

// Provides details about a CloudTrail trail.
type AwsCloudTrailTrailDetails struct {

	// The ARN of the log group that CloudTrail logs are delivered to.
	CloudWatchLogsLogGroupArn *string

	// The ARN of the role that the CloudWatch Events endpoint assumes when it writes
	// to the log group.
	CloudWatchLogsRoleArn *string

	// Indicates whether the trail has custom event selectors.
	HasCustomEventSelectors *bool

	// The Region where the trail was created.
	HomeRegion *string

	// Indicates whether the trail publishes events from global services such as IAM
	// to the log files.
	IncludeGlobalServiceEvents *bool

	// Indicates whether the trail applies only to the current Region or to all
	// Regions.
	IsMultiRegionTrail *bool

	// Whether the trail is created for all accounts in an organization in
	// Organizations, or only for the current Amazon Web Services account.
	IsOrganizationTrail *bool

	// The KMS key ID to use to encrypt the logs.
	KmsKeyId *string

	// Indicates whether CloudTrail log file validation is enabled.
	LogFileValidationEnabled *bool

	// The name of the trail.
	Name *string

	// The name of the S3 bucket where the log files are published.
	S3BucketName *string

	// The S3 key prefix. The key prefix is added after the name of the S3 bucket
	// where the log files are published.
	S3KeyPrefix *string

	// The ARN of the SNS topic that is used for notifications of log file delivery.
	SnsTopicArn *string

	// The name of the SNS topic that is used for notifications of log file delivery.
	SnsTopicName *string

	// The ARN of the trail.
	TrailArn *string

	noSmithyDocumentSerde
}

// Specifies an alarm and associates it with the specified metric or metric math
// expression.
type AwsCloudWatchAlarmDetails struct {

	// Indicates whether actions should be executed during any changes to the alarm
	// state.
	ActionsEnabled *bool

	// The list of actions, specified as Amazon Resource Names (ARNs) to execute when
	// this alarm transitions into an ALARM state from any other state.
	AlarmActions []string

	// The ARN of the alarm.
	AlarmArn *string

	// The time stamp of the last update to the alarm configuration.
	AlarmConfigurationUpdatedTimestamp *string

	// The description of the alarm.
	AlarmDescription *string

	// The name of the alarm. If you don't specify a name, CloudFront generates a
	// unique physical ID and uses that ID for the alarm name.
	AlarmName *string

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	ComparisonOperator *string

	// The number of datapoints that must be breaching to trigger the alarm.
	DatapointsToAlarm *int32

	// The dimensions for the metric associated with the alarm.
	Dimensions []AwsCloudWatchAlarmDimensionsDetails

	// Used only for alarms based on percentiles. If ignore , the alarm state does not
	// change during periods with too few data points to be statistically significant.
	// If evaluate or this parameter is not used, the alarm is always evaluated and
	// possibly changes state no matter how many data points are available.
	EvaluateLowSampleCountPercentile *string

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int32

	// The percentile statistic for the metric associated with the alarm.
	ExtendedStatistic *string

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an ARN.
	InsufficientDataActions []string

	// The name of the metric associated with the alarm. This is required for an alarm
	// based on a metric. For an alarm based on a math expression, you use Metrics
	// instead and you can't specify MetricName .
	MetricName *string

	// The namespace of the metric associated with the alarm. This is required for an
	// alarm based on a metric. For an alarm based on a math expression, you can't
	// specify Namespace and you use Metrics instead.
	Namespace *string

	// The actions to execute when this alarm transitions to the OK state from any
	// other state. Each action is specified as an ARN.
	OkActions []string

	// The period, in seconds, over which the statistic is applied. This is required
	// for an alarm based on a metric.
	Period *int32

	// The statistic for the metric associated with the alarm, other than percentile.
	// For percentile statistics, use ExtendedStatistic .
	//
	// For an alarm based on a metric, you must specify either Statistic or
	// ExtendedStatistic but not both.
	//
	// For an alarm based on a math expression, you can't specify Statistic . Instead,
	// you use Metrics .
	Statistic *string

	// The value to compare with the specified statistic.
	Threshold *float64

	// n an alarm based on an anomaly detection model, this is the ID of the
	// ANOMALY_DETECTION_BAND function used as the threshold for the alarm.
	ThresholdMetricId *string

	// Sets how this alarm is to handle missing data points.
	TreatMissingData *string

	// The unit of the metric associated with the alarm.
	Unit *string

	noSmithyDocumentSerde
}

// Details about the dimensions for the metric associated with the alarm.
type AwsCloudWatchAlarmDimensionsDetails struct {

	// The name of a dimension.
	Name *string

	// The value of a dimension.
	Value *string

	noSmithyDocumentSerde
}

// Information about the build artifacts for the CodeBuild project.
type AwsCodeBuildProjectArtifactsDetails struct {

	// An identifier for the artifact definition.
	ArtifactIdentifier *string

	// Indicates whether to disable encryption on the artifact. Only valid when Type
	// is S3 .
	EncryptionDisabled *bool

	// Only used when Type is S3 . The name of the S3 bucket where the artifact is
	// located.
	Location *string

	// Only used when Type is S3. The name of the artifact. Used with NamepaceType and
	// Path to determine the pattern for storing the artifact.
	Name *string

	// Only used when Type is S3 . The value to use for the namespace. Used with Name
	// and Path to determine the pattern for storing the artifact.
	NamespaceType *string

	// Whether the name specified in the buildspec file overrides the artifact name.
	OverrideArtifactName *bool

	// Only used when Type is S3 . The type of output artifact to create.
	Packaging *string

	// Only used when Type is S3 . The path to the artifact. Used with Name and
	// NamespaceType to determine the pattern for storing the artifact.
	Path *string

	// The type of build artifact.
	Type *string

	noSmithyDocumentSerde
}

// Information about an CodeBuild project.
type AwsCodeBuildProjectDetails struct {

	// Information about the build artifacts for the CodeBuild project.
	Artifacts []AwsCodeBuildProjectArtifactsDetails

	// The KMS key used to encrypt the build output artifacts.
	//
	// You can specify either the ARN of the KMS key or, if available, the KMS key
	// alias (using the format alias/alias-name).
	EncryptionKey *string

	// Information about the build environment for this build project.
	Environment *AwsCodeBuildProjectEnvironment

	// Information about logs for the build project.
	LogsConfig *AwsCodeBuildProjectLogsConfigDetails

	// The name of the build project.
	Name *string

	// Information about the secondary artifacts for the CodeBuild project.
	SecondaryArtifacts []AwsCodeBuildProjectArtifactsDetails

	// The ARN of the IAM role that enables CodeBuild to interact with dependent
	// Amazon Web Services services on behalf of the Amazon Web Services account.
	ServiceRole *string

	// Information about the build input source code for this build project.
	Source *AwsCodeBuildProjectSource

	// Information about the VPC configuration that CodeBuild accesses.
	VpcConfig *AwsCodeBuildProjectVpcConfig

	noSmithyDocumentSerde
}

// Information about the build environment for this build project.
type AwsCodeBuildProjectEnvironment struct {

	// The certificate to use with this build project.
	Certificate *string

	// A set of environment variables to make available to builds for the build
	// project.
	EnvironmentVariables []AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails

	// The type of credentials CodeBuild uses to pull images in your build.
	//
	// Valid values:
	//
	//   - CODEBUILD specifies that CodeBuild uses its own credentials. This requires
	//   that you modify your ECR repository policy to trust the CodeBuild service
	//   principal.
	//
	//   - SERVICE_ROLE specifies that CodeBuild uses your build project's service role.
	//
	// When you use a cross-account or private registry image, you must use
	// SERVICE_ROLE credentials. When you use an CodeBuild curated image, you must use
	// CODEBUILD credentials.
	ImagePullCredentialsType *string

	// Whether to allow the Docker daemon to run inside a Docker container. Set to true
	// if the build project is used to build Docker images.
	PrivilegedMode *bool

	// The credentials for access to a private registry.
	RegistryCredential *AwsCodeBuildProjectEnvironmentRegistryCredential

	// The type of build environment to use for related builds.
	//
	// The environment type ARM_CONTAINER is available only in Regions US East (N.
	// Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific
	// (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).
	//
	// The environment type LINUX_CONTAINER with compute type build.general1.2xlarge
	// is available only in Regions US East (N. Virginia), US East (N. Virginia), US
	// West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
	// (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific
	// (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
	//
	// The environment type LINUX_GPU_CONTAINER is available only in Regions US East
	// (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe
	// (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia
	// Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China
	// (Beijing), and China (Ningxia).
	//
	// Valid values: WINDOWS_CONTAINER | LINUX_CONTAINER | LINUX_GPU_CONTAINER |
	// ARM_CONTAINER
	Type *string

	noSmithyDocumentSerde
}

// Information about an environment variable that is available to builds for the
// build project.
type AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails struct {

	// The name of the environment variable.
	Name *string

	// The type of environment variable.
	Type *string

	// The value of the environment variable.
	Value *string

	noSmithyDocumentSerde
}

// The credentials for access to a private registry.
type AwsCodeBuildProjectEnvironmentRegistryCredential struct {

	// The ARN or name of credentials created using Secrets Manager.
	//
	// The credential can use the name of the credentials only if they exist in your
	// current Amazon Web Services Region.
	Credential *string

	// The service that created the credentials to access a private Docker registry.
	//
	// The valid value, SECRETS_MANAGER , is for Secrets Manager.
	CredentialProvider *string

	noSmithyDocumentSerde
}

// Information about CloudWatch Logs for the build project.
type AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails struct {

	// The group name of the logs in CloudWatch Logs.
	GroupName *string

	// The current status of the logs in CloudWatch Logs for a build project.
	Status *string

	// The prefix of the stream name of the CloudWatch Logs.
	StreamName *string

	noSmithyDocumentSerde
}

// Information about logs for the build project.
type AwsCodeBuildProjectLogsConfigDetails struct {

	// Information about CloudWatch Logs for the build project.
	CloudWatchLogs *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails

	// Information about logs built to an S3 bucket for a build project.
	S3Logs *AwsCodeBuildProjectLogsConfigS3LogsDetails

	noSmithyDocumentSerde
}

// Information about logs built to an S3 bucket for a build project.
type AwsCodeBuildProjectLogsConfigS3LogsDetails struct {

	// Whether to disable encryption of the S3 build log output.
	EncryptionDisabled *bool

	// The ARN of the S3 bucket and the path prefix for S3 logs.
	Location *string

	// The current status of the S3 build logs.
	Status *string

	noSmithyDocumentSerde
}

// Information about the build input source code for this build project.
type AwsCodeBuildProjectSource struct {

	// Information about the Git clone depth for the build project.
	GitCloneDepth *int32

	// Whether to ignore SSL warnings while connecting to the project source code.
	InsecureSsl *bool

	// Information about the location of the source code to be built.
	//
	// Valid values include:
	//
	//   - For source code settings that are specified in the source action of a
	//   pipeline in CodePipeline, location should not be specified. If it is specified,
	//   CodePipeline ignores it. This is because CodePipeline uses the settings in a
	//   pipeline's source action instead of this value.
	//
	//   - For source code in an CodeCommit repository, the HTTPS clone URL to the
	//   repository that contains the source code and the build spec file (for example,
	//   https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name ).
	//
	//   - For source code in an S3 input bucket, one of the following.
	//
	//   - The path to the ZIP file that contains the source code (for example,
	//   bucket-name/path/to/object-name.zip ).
	//
	//   - The path to the folder that contains the source code (for example,
	//   bucket-name/path/to/source-code/folder/ ).
	//
	//   - For source code in a GitHub repository, the HTTPS clone URL to the
	//   repository that contains the source and the build spec file.
	//
	//   - For source code in a Bitbucket repository, the HTTPS clone URL to the
	//   repository that contains the source and the build spec file.
	Location *string

	// The type of repository that contains the source code to be built. Valid values
	// are:
	//
	//   - BITBUCKET - The source code is in a Bitbucket repository.
	//
	//   - CODECOMMIT - The source code is in an CodeCommit repository.
	//
	//   - CODEPIPELINE - The source code settings are specified in the source action
	//   of a pipeline in CodePipeline.
	//
	//   - GITHUB - The source code is in a GitHub repository.
	//
	//   - GITHUB_ENTERPRISE - The source code is in a GitHub Enterprise repository.
	//
	//   - NO_SOURCE - The project does not have input source code.
	//
	//   - S3 - The source code is in an S3 input bucket.
	Type *string

	noSmithyDocumentSerde
}

// Information about the VPC configuration that CodeBuild accesses.
type AwsCodeBuildProjectVpcConfig struct {

	// A list of one or more security group IDs in your VPC.
	SecurityGroupIds []string

	// A list of one or more subnet IDs in your VPC.
	Subnets []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains the cross-origin resource sharing (CORS) configuration for the API.
// CORS is only supported for HTTP APIs.
type AwsCorsConfiguration struct {

	// Indicates whether the CORS request includes credentials.
	AllowCredentials *bool

	// The allowed headers for CORS requests.
	AllowHeaders []string

	// The allowed methods for CORS requests.
	AllowMethods []string

	// The allowed origins for CORS requests.
	AllowOrigins []string

	// The exposed headers for CORS requests.
	ExposeHeaders []string

	// The number of seconds for which the browser caches preflight request results.
	MaxAge *int32

	noSmithyDocumentSerde
}

//	Provides details about an Database Migration Service (DMS) endpoint. An
//
// endpoint provides connection, data store type, and location information about
// your data store.
type AwsDmsEndpointDetails struct {

	//  The Amazon Resource Name (ARN) for the SSL certificate that encrypts
	// connections between the DMS endpoint and the replication instance.
	CertificateArn *string

	//  The name of the endpoint database.
	DatabaseName *string

	//  The Amazon Resource Name (ARN) of the endpoint.
	EndpointArn *string

	//  The database endpoint identifier.
	EndpointIdentifier *string

	//  The type of endpoint. Valid values are source and target.
	EndpointType *string

	//  The type of engine for the endpoint, depending on the EndpointType value.
	EngineName *string

	//  A value that can be used for cross-account validation.
	ExternalId *string

	//  Additional attributes associated with the connection.
	ExtraConnectionAttributes *string

	//  An DMS key identifier that is used to encrypt the connection parameters for
	// the endpoint. If you don't specify a value for the KmsKeyId parameter, then DMS
	// uses your default encryption key. KMS creates the default encryption key for
	// your Amazon Web Services account. Your Amazon Web Services account has a
	// different default encryption key for each Amazon Web Services Region.
	KmsKeyId *string

	//  The port used to access the endpoint.
	Port *int32

	//  The name of the server where the endpoint database resides.
	ServerName *string

	//  The SSL mode used to connect to the endpoint. The default is none.
	SslMode *string

	//  The user name to be used to log in to the endpoint database.
	Username *string

	noSmithyDocumentSerde
}

//	Provides details about an Database Migration Service (DMS) replication
//
// instance. DMS uses a replication instance to connect to your source data store,
// read the source data, and format the data for consumption by the target data
// store.
type AwsDmsReplicationInstanceDetails struct {

	//  The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int32

	//  Indicates whether minor engine upgrades are applied automatically to the
	// replication instance during the maintenance window.
	AutoMinorVersionUpgrade *bool

	//  The Availability Zone that the replication instance is created in. The default
	// value is a random, system-chosen Availability Zone in the endpoint's Amazon Web
	// Services Region, such as us-east-1d .
	AvailabilityZone *string

	//  The engine version number of the replication instance. If an engine version
	// number is not specified when a replication instance is created, the default is
	// the latest engine version available.
	EngineVersion *string

	//  An KMS key identifier that is used to encrypt the data on the replication
	// instance. If you don't specify a value for the KmsKeyId parameter, DMS uses
	// your default encryption key. KMS creates the default encryption key for your
	// Amazon Web Services account. Your Amazon Web Services account has a different
	// default encryption key for each Amazon Web Services Region.
	KmsKeyId *string

	//  Specifies whether the replication instance is deployed across multiple
	// Availability Zones (AZs). You can't set the AvailabilityZone parameter if the
	// MultiAZ parameter is set to true .
	MultiAZ *bool

	//  The maintenance window times for the replication instance. Upgrades to the
	// replication instance are performed during this time.
	PreferredMaintenanceWindow *string

	//  Specifies the accessibility options for the replication instance. A value of
	// true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true .
	PubliclyAccessible *bool

	//  The compute and memory capacity of the replication instance as defined for the
	// specified replication instance class.
	ReplicationInstanceClass *string

	//  The replication instance identifier.
	ReplicationInstanceIdentifier *string

	//  The subnet group for the replication instance.
	ReplicationSubnetGroup *AwsDmsReplicationInstanceReplicationSubnetGroupDetails

	//  The virtual private cloud (VPC) security group for the replication instance.
	VpcSecurityGroups []AwsDmsReplicationInstanceVpcSecurityGroupsDetails

	noSmithyDocumentSerde
}

// Provides details about the replication subnet group.
type AwsDmsReplicationInstanceReplicationSubnetGroupDetails struct {

	//  The identifier of the replication subnet group.
	ReplicationSubnetGroupIdentifier *string

	noSmithyDocumentSerde
}

//	Provides details about the virtual private cloud (VPC) security group that’s
//
// associated with the replication instance.
type AwsDmsReplicationInstanceVpcSecurityGroupsDetails struct {

	//  The identifier of the VPC security group that’s associated with the
	// replication instance.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

//	Provides details about an Database Migration Service (DMS) replication task. A
//
// replication task moves a set of data from the source endpoint to the target
// endpoint.
type AwsDmsReplicationTaskDetails struct {

	//  Indicates when you want a change data capture (CDC) operation to start.
	// CCdcStartPosition or CCdcStartTime specifies when you want a CDC operation to
	// start. Only a value for one of these fields is included.
	CdcStartPosition *string

	//  Indicates the start time for a CDC operation. CdcStartPosition or CCdcStartTime
	// specifies when you want a CDC operation to start. Only a value for one of these
	// fields is included.
	CdcStartTime *string

	//  Indicates when you want a CDC operation to stop. The value can be either
	// server time or commit time.
	CdcStopPosition *string

	//  The identifier of the replication task.
	Id *string

	//  The migration type.
	MigrationType *string

	//  The Amazon Resource Name (ARN) of a replication instance.
	ReplicationInstanceArn *string

	//  The user-defined replication task identifier or name.
	ReplicationTaskIdentifier *string

	//  The settings for the replication task.
	ReplicationTaskSettings *string

	//  A display name for the resource identifier at the end of the EndpointArn
	// response parameter. If you don't specify a ResourceIdentifier value, DMS
	// generates a default identifier value for the end of EndpointArn .
	ResourceIdentifier *string

	//  The ARN of the source endpoint.
	SourceEndpointArn *string

	//  The table mappings for the replication task, in JSON format.
	TableMappings *string

	//  The ARN of the target endpoint.
	TargetEndpointArn *string

	//  Supplemental information that the task requires to migrate the data for
	// certain source and target endpoints.
	TaskData *string

	noSmithyDocumentSerde
}

// Contains a definition of an attribute for the table.
type AwsDynamoDbTableAttributeDefinition struct {

	// The name of the attribute.
	AttributeName *string

	// The type of the attribute.
	AttributeType *string

	noSmithyDocumentSerde
}

// Provides information about the billing for read/write capacity on the table.
type AwsDynamoDbTableBillingModeSummary struct {

	// The method used to charge for read and write throughput and to manage capacity.
	BillingMode *string

	// If the billing mode is PAY_PER_REQUEST , indicates when the billing mode was set
	// to that value.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastUpdateToPayPerRequestDateTime *string

	noSmithyDocumentSerde
}

// Provides details about a DynamoDB table.
type AwsDynamoDbTableDetails struct {

	// A list of attribute definitions for the table.
	AttributeDefinitions []AwsDynamoDbTableAttributeDefinition

	// Information about the billing for read/write capacity on the table.
	BillingModeSummary *AwsDynamoDbTableBillingModeSummary

	// Indicates when the table was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreationDateTime *string

	//  Indicates whether deletion protection is to be enabled (true) or disabled
	// (false) on the table.
	DeletionProtectionEnabled *bool

	// List of global secondary indexes for the table.
	GlobalSecondaryIndexes []AwsDynamoDbTableGlobalSecondaryIndex

	// The version of global tables being used.
	GlobalTableVersion *string

	// The number of items in the table.
	ItemCount *int32

	// The primary key structure for the table.
	KeySchema []AwsDynamoDbTableKeySchema

	// The ARN of the latest stream for the table.
	LatestStreamArn *string

	// The label of the latest stream. The label is not a unique identifier.
	LatestStreamLabel *string

	// The list of local secondary indexes for the table.
	LocalSecondaryIndexes []AwsDynamoDbTableLocalSecondaryIndex

	// Information about the provisioned throughput for the table.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput

	// The list of replicas of this table.
	Replicas []AwsDynamoDbTableReplica

	// Information about the restore for the table.
	RestoreSummary *AwsDynamoDbTableRestoreSummary

	// Information about the server-side encryption for the table.
	SseDescription *AwsDynamoDbTableSseDescription

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *AwsDynamoDbTableStreamSpecification

	// The identifier of the table.
	TableId *string

	// The name of the table.
	TableName *string

	// The total size of the table in bytes.
	TableSizeBytes *int64

	// The current status of the table. Valid values are as follows:
	//
	//   - ACTIVE
	//
	//   - ARCHIVED
	//
	//   - ARCHIVING
	//
	//   - CREATING
	//
	//   - DELETING
	//
	//   - INACCESSIBLE_ENCRYPTION_CREDENTIALS
	//
	//   - UPDATING
	TableStatus *string

	noSmithyDocumentSerde
}

// Information abut a global secondary index for the table.
type AwsDynamoDbTableGlobalSecondaryIndex struct {

	// Whether the index is currently backfilling.
	Backfilling *bool

	// The ARN of the index.
	IndexArn *string

	// The name of the index.
	IndexName *string

	// The total size in bytes of the index.
	IndexSizeBytes *int64

	// The current status of the index.
	//
	//   - ACTIVE
	//
	//   - CREATING
	//
	//   - DELETING
	//
	//   - UPDATING
	IndexStatus *string

	// The number of items in the index.
	ItemCount *int32

	// The key schema for the index.
	KeySchema []AwsDynamoDbTableKeySchema

	// Attributes that are copied from the table into an index.
	Projection *AwsDynamoDbTableProjection

	// Information about the provisioned throughput settings for the indexes.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput

	noSmithyDocumentSerde
}

// A component of the key schema for the DynamoDB table, a global secondary index,
// or a local secondary index.
type AwsDynamoDbTableKeySchema struct {

	// The name of the key schema attribute.
	AttributeName *string

	// The type of key used for the key schema attribute. Valid values are HASH or
	// RANGE .
	KeyType *string

	noSmithyDocumentSerde
}

// Information about a local secondary index for a DynamoDB table.
type AwsDynamoDbTableLocalSecondaryIndex struct {

	// The ARN of the index.
	IndexArn *string

	// The name of the index.
	IndexName *string

	// The complete key schema for the index.
	KeySchema []AwsDynamoDbTableKeySchema

	// Attributes that are copied from the table into the index. These are in addition
	// to the primary key attributes and index key attributes, which are automatically
	// projected.
	Projection *AwsDynamoDbTableProjection

	noSmithyDocumentSerde
}

// For global and local secondary indexes, identifies the attributes that are
// copied from the table into the index.
type AwsDynamoDbTableProjection struct {

	// The nonkey attributes that are projected into the index. For each attribute,
	// provide the attribute name.
	NonKeyAttributes []string

	// The types of attributes that are projected into the index. Valid values are as
	// follows:
	//
	//   - ALL
	//
	//   - INCLUDE
	//
	//   - KEYS_ONLY
	ProjectionType *string

	noSmithyDocumentSerde
}

// Information about the provisioned throughput for the table or for a global
// secondary index.
type AwsDynamoDbTableProvisionedThroughput struct {

	// Indicates when the provisioned throughput was last decreased.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastDecreaseDateTime *string

	// Indicates when the provisioned throughput was last increased.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastIncreaseDateTime *string

	// The number of times during the current UTC calendar day that the provisioned
	// throughput was decreased.
	NumberOfDecreasesToday *int32

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException .
	ReadCapacityUnits *int32

	// The maximum number of writes consumed per second before DynamoDB returns a
	// ThrottlingException .
	WriteCapacityUnits *int32

	noSmithyDocumentSerde
}

// Replica-specific configuration for the provisioned throughput.
type AwsDynamoDbTableProvisionedThroughputOverride struct {

	// The read capacity units for the replica.
	ReadCapacityUnits *int32

	noSmithyDocumentSerde
}

// Information about a replica of a DynamoDB table.
type AwsDynamoDbTableReplica struct {

	// List of global secondary indexes for the replica.
	GlobalSecondaryIndexes []AwsDynamoDbTableReplicaGlobalSecondaryIndex

	// The identifier of the KMS key that will be used for KMS encryption for the
	// replica.
	KmsMasterKeyId *string

	// Replica-specific configuration for the provisioned throughput.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride

	// The name of the Region where the replica is located.
	RegionName *string

	// The current status of the replica. Valid values are as follows:
	//
	//   - ACTIVE
	//
	//   - CREATING
	//
	//   - CREATION_FAILED
	//
	//   - DELETING
	//
	//   - UPDATING
	ReplicaStatus *string

	// Detailed information about the replica status.
	ReplicaStatusDescription *string

	noSmithyDocumentSerde
}

// Information about a global secondary index for a DynamoDB table replica.
type AwsDynamoDbTableReplicaGlobalSecondaryIndex struct {

	// The name of the index.
	IndexName *string

	// Replica-specific configuration for the provisioned throughput for the index.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride

	noSmithyDocumentSerde
}

// Information about the restore for the table.
type AwsDynamoDbTableRestoreSummary struct {

	// Indicates the point in time that the table was restored to.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	RestoreDateTime *string

	// Whether a restore is currently in progress.
	RestoreInProgress *bool

	// The ARN of the source backup from which the table was restored.
	SourceBackupArn *string

	// The ARN of the source table for the backup.
	SourceTableArn *string

	noSmithyDocumentSerde
}

// Information about the server-side encryption for the table.
type AwsDynamoDbTableSseDescription struct {

	// If the key is inaccessible, the date and time when DynamoDB detected that the
	// key was inaccessible.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	InaccessibleEncryptionDateTime *string

	// The ARN of the KMS key that is used for the KMS encryption.
	KmsMasterKeyArn *string

	// The type of server-side encryption.
	SseType *string

	// The status of the server-side encryption.
	Status *string

	noSmithyDocumentSerde
}

// The current DynamoDB Streams configuration for the table.
type AwsDynamoDbTableStreamSpecification struct {

	// Indicates whether DynamoDB Streams is enabled on the table.
	StreamEnabled *bool

	// Determines the information that is written to the table.
	StreamViewType *string

	noSmithyDocumentSerde
}

//	Provides details about an Active Directory that’s used to authenticate an
//
// Client VPN endpoint.
type AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails struct {

	//  The ID of the Active Directory used for authentication.
	DirectoryId *string

	noSmithyDocumentSerde
}

// Information about the authentication method used by the Client VPN endpoint.
type AwsEc2ClientVpnEndpointAuthenticationOptionsDetails struct {

	//  Information about the Active Directory, if applicable. With Active Directory
	// authentication, clients are authenticated against existing Active Directory
	// groups.
	ActiveDirectory *AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails

	//  Information about the IAM SAML identity provider, if applicable.
	FederatedAuthentication *AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails

	//  Information about the authentication certificates, if applicable.
	MutualAuthentication *AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails

	//  The authentication type used.
	Type *string

	noSmithyDocumentSerde
}

// Describes the IAM SAML identity providers used for federated authentication.
type AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails struct {

	//  The Amazon Resource Name (ARN) of the IAM SAML identity provider.
	SamlProviderArn *string

	//  The Amazon Resource Name (ARN) of the IAM SAML identity provider for the
	// self-service portal.
	SelfServiceSamlProviderArn *string

	noSmithyDocumentSerde
}

// Information about the client certificate used for authentication.
type AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails struct {

	//  The Amazon Resource Name (ARN) of the client certificate.
	ClientRootCertificateChain *string

	noSmithyDocumentSerde
}

// The options for managing connection authorization for new client connections.
type AwsEc2ClientVpnEndpointClientConnectOptionsDetails struct {

	//  Indicates whether client connect options are enabled.
	Enabled *bool

	//  The Amazon Resource Name (ARN) of the Lambda function used for connection
	// authorization.
	LambdaFunctionArn *string

	//  The status of any updates to the client connect options.
	Status *AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails

	noSmithyDocumentSerde
}

// Describes the status of the Client VPN endpoint attribute.
type AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails struct {

	//  The status code.
	Code *string

	//  The status message.
	Message *string

	noSmithyDocumentSerde
}

//	Options for enabling a customizable text banner that will be displayed on
//
// Amazon Web Services provided clients when a VPN session is established.
type AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails struct {

	//  Customizable text that will be displayed in a banner on Amazon Web Services
	// provided clients when a VPN session is established.
	BannerText *string

	//  Current state of text banner feature.
	Enabled *bool

	noSmithyDocumentSerde
}

//	Information about the client connection logging options for the Client VPN
//
// endpoint.
type AwsEc2ClientVpnEndpointConnectionLogOptionsDetails struct {

	//  The name of the Amazon CloudWatch Logs log group to which connection logging
	// data is published.
	CloudwatchLogGroup *string

	//  The name of the Amazon CloudWatch Logs log stream to which connection logging
	// data is published.
	CloudwatchLogStream *string

	//  Indicates whether client connection logging is enabled for the Client VPN
	// endpoint.
	Enabled *bool

	noSmithyDocumentSerde
}

//	Describes an Client VPN endpoint. A Client VPN endpoint is the resource that
//
// you create and configure to enable and manage client VPN sessions. It's the
// termination point for all client VPN sessions.
type AwsEc2ClientVpnEndpointDetails struct {

	//  Information about the authentication method used by the Client VPN endpoint.
	AuthenticationOptions []AwsEc2ClientVpnEndpointAuthenticationOptionsDetails

	//  The IPv4 address range, in CIDR notation, from which client IP addresses are
	// assigned.
	ClientCidrBlock *string

	//  The options for managing connection authorization for new client connections.
	ClientConnectOptions *AwsEc2ClientVpnEndpointClientConnectOptionsDetails

	//  Options for enabling a customizable text banner that will be displayed on
	// Amazon Web Services provided clients when a VPN session is established.
	ClientLoginBannerOptions *AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails

	//  The ID of the Client VPN endpoint.
	ClientVpnEndpointId *string

	//  Information about the client connection logging options for the Client VPN
	// endpoint.
	ConnectionLogOptions *AwsEc2ClientVpnEndpointConnectionLogOptionsDetails

	//  A brief description of the endpoint.
	Description *string

	//  Information about the DNS servers to be used for DNS resolution.
	DnsServer []string

	//  The IDs of the security groups for the target network.
	SecurityGroupIdSet []string

	//  The URL of the self-service portal.
	SelfServicePortalUrl *string

	//  The Amazon Resource Name (ARN) of the server certificate.
	ServerCertificateArn *string

	//  The maximum VPN session duration time in hours.
	SessionTimeoutHours *int32

	//  Indicates whether split-tunnel is enabled in the Client VPN endpoint.
	SplitTunnel *bool

	//  The transport protocol used by the Client VPN endpoint.
	TransportProtocol *string

	//  The ID of the VPC.
	VpcId *string

	//  The port number for the Client VPN endpoint.
	VpnPort *int32

	noSmithyDocumentSerde
}

// Information about an Elastic IP address.
type AwsEc2EipDetails struct {

	// The identifier that Amazon Web Services assigns to represent the allocation of
	// the Elastic IP address for use with Amazon VPC.
	AllocationId *string

	// The identifier that represents the association of the Elastic IP address with
	// an EC2 instance.
	AssociationId *string

	// The domain in which to allocate the address.
	//
	// If the address is for use with EC2 instances in a VPC, then Domain is vpc .
	// Otherwise, Domain is standard .
	Domain *string

	// The identifier of the EC2 instance.
	InstanceId *string

	// The name of the location from which the Elastic IP address is advertised.
	NetworkBorderGroup *string

	// The identifier of the network interface.
	NetworkInterfaceId *string

	// The Amazon Web Services account ID of the owner of the network interface.
	NetworkInterfaceOwnerId *string

	// The private IP address that is associated with the Elastic IP address.
	PrivateIpAddress *string

	// A public IP address that is associated with the EC2 instance.
	PublicIp *string

	// The identifier of an IP address pool. This parameter allows Amazon EC2 to
	// select an IP address from the address pool.
	PublicIpv4Pool *string

	noSmithyDocumentSerde
}

// The details of an Amazon EC2 instance.
type AwsEc2InstanceDetails struct {

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []string

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []string

	// The key name associated with the instance.
	KeyName *string

	// Indicates when the instance was launched.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LaunchedAt *string

	// Details about the metadata options for the Amazon EC2 instance.
	MetadataOptions *AwsEc2InstanceMetadataOptions

	//  Describes the type of monitoring that’s turned on for an instance.
	Monitoring *AwsEc2InstanceMonitoringDetails

	// The identifiers of the network interfaces for the EC2 instance. The details for
	// each network interface are in a corresponding AwsEc2NetworkInterfacesDetails
	// object.
	NetworkInterfaces []AwsEc2InstanceNetworkInterfacesDetails

	// The identifier of the subnet that the instance was launched in.
	SubnetId *string

	// The instance type of the instance.
	Type *string

	// The virtualization type of the Amazon Machine Image (AMI) required to launch
	// the instance.
	VirtualizationType *string

	// The identifier of the VPC that the instance was launched in.
	VpcId *string

	noSmithyDocumentSerde
}

// Metadata options that allow you to configure and secure the Amazon EC2 instance.
type AwsEc2InstanceMetadataOptions struct {

	// Enables or disables the HTTP metadata endpoint on the instance.
	HttpEndpoint *string

	// Enables or disables the IPv6 endpoint for the instance metadata service.
	HttpProtocolIpv6 *string

	// The desired HTTP PUT response hop limit for instance metadata requests. The
	// larger the number, the further instance metadata requests can travel.
	HttpPutResponseHopLimit *int32

	// The state of token usage for your instance metadata requests.
	HttpTokens *string

	// Specifies whether to allow access to instance tags from the instance metadata.
	InstanceMetadataTags *string

	noSmithyDocumentSerde
}

// The type of monitoring that’s turned on for an Amazon EC2 instance.
type AwsEc2InstanceMonitoringDetails struct {

	//  Indicates whether detailed monitoring is turned on. Otherwise, basic
	// monitoring is turned on.
	State *string

	noSmithyDocumentSerde
}

// Identifies a network interface for the Amazon EC2 instance.
type AwsEc2InstanceNetworkInterfacesDetails struct {

	// The identifier of the network interface. The details are in a corresponding
	// AwsEc2NetworkInterfacesDetails object.
	NetworkInterfaceId *string

	noSmithyDocumentSerde
}

//	Information about a block device mapping for an Amazon Elastic Compute Cloud
//
// (Amazon EC2) launch template.
type AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails struct {

	//  The device name.
	DeviceName *string

	//  Parameters used to automatically set up Amazon EBS volumes when the instance
	// is launched.
	Ebs *AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails

	//  Omits the device from the block device mapping when an empty string is
	// specified.
	NoDevice *string

	//  The virtual device name (ephemeralN). Instance store volumes are numbered
	// starting from 0. An instance type with 2 available instance store volumes can
	// specify mappings for ephemeral0 and ephemeral1 . The number of available
	// instance store volumes depends on the instance type.
	VirtualName *string

	noSmithyDocumentSerde
}

//	Parameters for a block device for an Amazon Elastic Block Store (Amazon EBS)
//
// volume in an Amazon EC2 launch template.
type AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails struct {

	//  Indicates whether the EBS volume is deleted on instance termination.
	DeleteOnTermination *bool

	//  Indicates whether the EBS volume is encrypted. Encrypted volumes can only be
	// attached to instances that support Amazon EBS encryption. If you're creating a
	// volume from a snapshot, you can't specify an encryption value.
	Encrypted *bool

	//  The number of I/O operations per second (IOPS).
	Iops *int32

	//  The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS)
	// customer managed key used for encryption.
	KmsKeyId *string

	//  The ID of the EBS snapshot.
	SnapshotId *string

	//  The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
	Throughput *int32

	//  The size of the volume, in GiBs. You must specify either a snapshot ID or a
	// volume size.
	VolumeSize *int32

	//  The volume type.
	VolumeType *string

	noSmithyDocumentSerde
}

//	Information about the target Capacity Reservation or Capacity Reservation
//
// group in which to run an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails struct {

	//  The ID of the Capacity Reservation in which to run the instance.
	CapacityReservationId *string

	//  The Amazon Resource Name (ARN) of the Capacity Reservation resource group in
	// which to run the instance.
	CapacityReservationResourceGroupArn *string

	noSmithyDocumentSerde
}

// Specifies the Capacity Reservation targeting option of an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails struct {

	//  Indicates the instance's Capacity Reservation preferences. If equal to open ,
	// the instance can run in any open Capacity Reservation that has matching
	// attributes (instance type, platform, Availability Zone). If equal to none , the
	// instance avoids running in a Capacity Reservation even if one is available. The
	// instance runs in On-Demand capacity.
	CapacityReservationPreference *string

	//  Specifies a target Capacity Reservation.
	CapacityReservationTarget *AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails

	noSmithyDocumentSerde
}

//	Specifies the CPU options for an Amazon EC2 instance. For more information,
//
// see [Optimize CPU options]in the Amazon Elastic Compute Cloud User Guide.
//
// [Optimize CPU options]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html
type AwsEc2LaunchTemplateDataCpuOptionsDetails struct {

	//  The number of CPU cores for the instance.
	CoreCount *int32

	//  The number of threads per CPU core. A value of 1 disables multithreading for
	// the instance, The default value is 2 .
	ThreadsPerCore *int32

	noSmithyDocumentSerde
}

//	Specifies the credit option for CPU usage of a T2, T3, or T3a Amazon EC2
//
// instance.
type AwsEc2LaunchTemplateDataCreditSpecificationDetails struct {

	//  The credit option for CPU usage of a T instance.
	CpuCredits *string

	noSmithyDocumentSerde
}

//	The information to include in an Amazon Elastic Compute Cloud (Amazon EC2)
//
// launch template.
type AwsEc2LaunchTemplateDataDetails struct {

	//  Information about a block device mapping for an Amazon EC2 launch template.
	BlockDeviceMappingSet []AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails

	//  Specifies an instance's Capacity Reservation targeting option. You can specify
	// only one option at a time.
	CapacityReservationSpecification *AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails

	//  Specifies the CPU options for an instance. For more information, see [Optimize CPU options] in the
	// Amazon Elastic Compute Cloud User Guide.
	//
	// [Optimize CPU options]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html
	CpuOptions *AwsEc2LaunchTemplateDataCpuOptionsDetails

	//  Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
	CreditSpecification *AwsEc2LaunchTemplateDataCreditSpecificationDetails

	//  Indicates whether to enable the instance for stop protection. For more
	// information, see [Enable stop protection]in the Amazon EC2 User Guide.
	//
	// [Enable stop protection]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection
	DisableApiStop *bool

	//  If you set this parameter to true , you can't terminate the instance using the
	// Amazon EC2 console, CLI, or API. If set to true , you can.
	DisableApiTermination *bool

	//  Indicates whether the instance is optimized for Amazon EBS I/O.
	EbsOptimized *bool

	//  Provides details about Elastic Graphics accelerators to associate with the
	// instance.
	ElasticGpuSpecificationSet []AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails

	//  The Amazon Elastic Inference accelerator for the instance.
	ElasticInferenceAcceleratorSet []AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails

	//  Indicates whether the Amazon EC2 instance is enabled for Amazon Web Services
	// Nitro Enclaves.
	EnclaveOptions *AwsEc2LaunchTemplateDataEnclaveOptionsDetails

	//  Specifies whether your Amazon EC2 instance is configured for hibernation.
	HibernationOptions *AwsEc2LaunchTemplateDataHibernationOptionsDetails

	//  The name or Amazon Resource Name (ARN) of an IAM instance profile.
	IamInstanceProfile *AwsEc2LaunchTemplateDataIamInstanceProfileDetails

	//  The ID of the Amazon Machine Image (AMI).
	ImageId *string

	//  Provides the options for specifying the instance initiated shutdown behavior.
	InstanceInitiatedShutdownBehavior *string

	//  Specifies the market (purchasing) option for an instance.
	InstanceMarketOptions *AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails

	//  The attributes for the instance types. When you specify instance attributes,
	// Amazon EC2 will identify instance types with these attributes. If you specify
	// InstanceRequirements , you can't specify InstanceType .
	InstanceRequirements *AwsEc2LaunchTemplateDataInstanceRequirementsDetails

	//  The instance type. For more information, see [Instance types] in the Amazon EC2 User Guide. If
	// you specify InstanceType , you can't specify InstanceRequirements .
	//
	// [Instance types]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
	InstanceType *string

	//  The ID of the kernel.
	KernelId *string

	//  The name of the key pair that allows users to connect to the instance.
	KeyName *string

	//  Specifies a license configuration for an instance.
	LicenseSet []AwsEc2LaunchTemplateDataLicenseSetDetails

	//  The maintenance options of your instance.
	MaintenanceOptions *AwsEc2LaunchTemplateDataMaintenanceOptionsDetails

	//  The metadata options for the instance. For more information, see [Instance metadata and user data] in the
	// Amazon EC2 User Guide.
	//
	// [Instance metadata and user data]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html
	MetadataOptions *AwsEc2LaunchTemplateDataMetadataOptionsDetails

	//  The monitoring for the instance.
	Monitoring *AwsEc2LaunchTemplateDataMonitoringDetails

	//  Specifies the parameters for a network interface that is attached to the
	// instance.
	NetworkInterfaceSet []AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails

	//  Specifies the placement of an instance.
	Placement *AwsEc2LaunchTemplateDataPlacementDetails

	//  The options for the instance hostname.
	PrivateDnsNameOptions *AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails

	//  The ID of the RAM disk.
	RamDiskId *string

	//  One or more security group IDs.
	SecurityGroupIdSet []string

	//  One or more security group names. For a nondefault VPC, you must use security
	// group IDs instead. You cannot specify both a security group ID and security name
	// in the same request.
	SecurityGroupSet []string

	//  The user data to make available to the instance.
	UserData *string

	noSmithyDocumentSerde
}

//	Provides details about an Elastic Graphics specification for an Amazon EC2
//
// launch template.
type AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails struct {

	//  The type of Elastic Graphics accelerator.
	Type *string

	noSmithyDocumentSerde
}

// Provides details for an Amazon Elastic Inference accelerator.
type AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails struct {

	//  The number of Elastic Inference accelerators to attach to the instance.
	Count *int32

	//  The type of Elastic Inference accelerator.
	Type *string

	noSmithyDocumentSerde
}

//	Indicates whether the instance is enabled for Amazon Web Services Nitro
//
// Enclaves.
type AwsEc2LaunchTemplateDataEnclaveOptionsDetails struct {

	//  If this parameter is set to true , the instance is enabled for Amazon Web
	// Services Nitro Enclaves.
	Enabled *bool

	noSmithyDocumentSerde
}

// Specifies whether your Amazon EC2 instance is configured for hibernation.
type AwsEc2LaunchTemplateDataHibernationOptionsDetails struct {

	//  If you set this parameter to true , the instance is enabled for hibernation.
	Configured *bool

	noSmithyDocumentSerde
}

//	Provides details for an Identity and Access Management (IAM) instance profile,
//
// which is a container for an IAM role for your instance.
type AwsEc2LaunchTemplateDataIamInstanceProfileDetails struct {

	//  The Amazon Resource Name (ARN) of the instance profile.
	Arn *string

	//  The name of the instance profile.
	Name *string

	noSmithyDocumentSerde
}

//	Provides details about the market (purchasing) option for an Amazon EC2
//
// instance.
type AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails struct {

	//  The market type.
	MarketType *string

	//  The options for Spot Instances.
	SpotOptions *AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails

	noSmithyDocumentSerde
}

// Provides details about the market (purchasing) options for Spot Instances.
type AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails struct {

	//  Deprecated.
	BlockDurationMinutes *int32

	//  The behavior when a Spot Instance is interrupted.
	InstanceInterruptionBehavior *string

	//  The maximum hourly price you're willing to pay for the Spot Instances.
	MaxPrice *string

	//  The Spot Instance request type.
	SpotInstanceType *string

	//  The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ), for
	// persistent requests.
	ValidUntil *string

	noSmithyDocumentSerde
}

//	The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web
//
// Services Inferentia chips) on an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails struct {

	//  The maximum number of accelerators. If this parameter isn't specified, there's
	// no maximum limit. To exclude accelerator-enabled instance types, set Max to 0 .
	Max *int32

	//  The minimum number of accelerators. If this parameter isn't specified, there's
	// no minimum limit.
	Min *int32

	noSmithyDocumentSerde
}

//	The minimum and maximum amount of memory, in MiB, for the accelerators on an
//
// Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails struct {

	//  The maximum amount of memory, in MiB. If this parameter isn't specified,
	// there's no maximum limit.
	Max *int32

	//  The minimum amount of memory, in MiB. If 0 is specified, there's no maximum
	// limit.
	Min *int32

	noSmithyDocumentSerde
}

//	The minimum and maximum baseline bandwidth to Amazon Elastic Block Store
//
// (Amazon EBS), in Mbps. For more information, see [Amazon EBS–optimized instances]in the Amazon EC2 User Guide.
//
// [Amazon EBS–optimized instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html
type AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails struct {

	//  The maximum baseline bandwidth, in Mbps. If this parameter is omitted, there's
	// no maximum limit.
	Max *int32

	//  The minimum baseline bandwidth, in Mbps. If this parameter is omitted, there's
	// no minimum limit.
	Min *int32

	noSmithyDocumentSerde
}

// The attributes for the Amazon EC2 instance types.
type AwsEc2LaunchTemplateDataInstanceRequirementsDetails struct {

	//  The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web
	// Services Inferentia chips) on an instance.
	AcceleratorCount *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails

	// Indicates whether instance types must have accelerators by specific
	// manufacturers.
	AcceleratorManufacturers []string

	//  The accelerators that must be on the instance type.
	AcceleratorNames []string

	//  The minimum and maximum amount of total accelerator memory, in MiB.
	AcceleratorTotalMemoryMiB *AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails

	// The accelerator types that must be on the instance type.
	AcceleratorTypes []string

	// Indicates whether bare metal instance types must be included, excluded, or
	// required.
	BareMetal *string

	//  The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more
	// information, see [Amazon EBS optimized instances]in the Amazon EC2 User Guide.
	//
	// [Amazon EBS optimized instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html
	BaselineEbsBandwidthMbps *AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails

	//  Indicates whether burstable performance T instance types are included,
	// excluded, or required. For more information, [Burstable performance instances]in the Amazon EC2 User Guide.
	//
	// [Burstable performance instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html
	BurstablePerformance *string

	//  The CPU manufacturers to include.
	CpuManufacturers []string

	//  The instance types to exclude.
	ExcludedInstanceTypes []string

	//  Indicates whether current or previous generation instance types are included.
	InstanceGenerations []string

	//  Indicates whether instance types with instance store volumes are included,
	// excluded, or required. For more information, see [Amazon EC2 instance store]in the Amazon EC2 User Guide.
	//
	// [Amazon EC2 instance store]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html
	LocalStorage *string

	//  The type of local storage that is required.
	LocalStorageTypes []string

	//  The minimum and maximum amount of memory per vCPU, in GiB.
	MemoryGiBPerVCpu *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails

	//  The minimum and maximum amount of memory, in MiB.
	MemoryMiB *AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails

	//  The minimum and maximum number of network interfaces.
	NetworkInterfaceCount *AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails

	//  The price protection threshold for On-Demand Instances. This is the maximum
	// you'll pay for an On-Demand Instance, expressed as a percentage above the least
	// expensive current generation M, C, or R instance type with your specified
	// attributes. When Amazon EC2 selects instance types with your attributes, it
	// excludes instance types priced above your threshold.
	//
	// The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
	//
	// A high value, such as 999999 , turns off price protection.
	OnDemandMaxPricePercentageOverLowestPrice *int32

	//  Indicates whether instance types must support hibernation for On-Demand
	// Instances.
	RequireHibernateSupport *bool

	//  The price protection threshold for Spot Instances. This is the maximum you'll
	// pay for a Spot Instance, expressed as a percentage above the least expensive
	// current generation M, C, or R instance type with your specified attributes. When
	// Amazon EC2 selects instance types with your attributes, it excludes instance
	// types priced above your threshold.
	//
	// The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
	//
	// A high value, such as 999999 , turns off price protection.
	SpotMaxPricePercentageOverLowestPrice *int32

	//  The minimum and maximum amount of total local storage, in GB.
	TotalLocalStorageGB *AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails

	//  The minimum and maximum number of vCPUs.
	VCpuCount *AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails

	noSmithyDocumentSerde
}

// The minimum and maximum amount of memory per vCPU, in GiB.
type AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails struct {

	//  The maximum amount of memory per vCPU, in GiB. If this parameter is omitted,
	// there's no maximum limit.
	Max *float64

	//  The minimum amount of memory per vCPU, in GiB. If this parameter is omitted,
	// there's no maximum limit.
	Min *float64

	noSmithyDocumentSerde
}

// The minimum and maximum amount of memory, in MiB, for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails struct {

	//  The maximum amount of memory, in MiB.
	Max *int32

	//  The minimum amount of memory, in MiB.
	Min *int32

	noSmithyDocumentSerde
}

//	The minimum and maximum number of network interfaces to be attached to an
//
// Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails struct {

	//  The maximum number of network interfaces.
	Max *int32

	//  The minimum number of network interfaces.
	Min *int32

	noSmithyDocumentSerde
}

//	The minimum and maximum amount of total local storage, in GB, that an Amazon
//
// EC2 instance uses.
type AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails struct {

	//  The maximum amount of total local storage, in GB.
	Max *float64

	//  The minimum amount of total local storage, in GB.
	Min *float64

	noSmithyDocumentSerde
}

// The minimum and maximum number of vCPUs for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails struct {

	//  The maximum number of vCPUs.
	Max *int32

	//  The minimum number of vCPUs.
	Min *int32

	noSmithyDocumentSerde
}

// Provides details about the license configuration for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataLicenseSetDetails struct {

	//  The Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string

	noSmithyDocumentSerde
}

// The maintenance options of an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataMaintenanceOptionsDetails struct {

	//  Disables the automatic recovery behavior of your instance or sets it to
	// default.
	AutoRecovery *string

	noSmithyDocumentSerde
}

// Specifies the metadata options for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataMetadataOptionsDetails struct {

	//  Enables or disables the HTTP metadata endpoint on your instances. If the
	// parameter is not specified, the default state is enabled, and you won't be able
	// to access your instance metadata.
	HttpEndpoint *string

	//  Enables or disables the IPv6 endpoint for the instance metadata service.
	HttpProtocolIpv6 *string

	//  The desired HTTP PUT response hop limit for instance metadata requests. The
	// larger the number, the further instance metadata requests can travel.
	HttpPutResponseHopLimit *int32

	//  The state of token usage for your instance metadata requests.
	HttpTokens *string

	//  When set to enabled , this parameter allows access to instance tags from the
	// instance metadata. When set to disabled , it turns off access to instance tags
	// from the instance metadata. For more information, see [Work with instance tags in instance metadata]in the Amazon EC2 User
	// Guide.
	//
	// [Work with instance tags in instance metadata]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS
	InstanceMetadataTags *string

	noSmithyDocumentSerde
}

// The monitoring for an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataMonitoringDetails struct {

	//  Enables detailed monitoring when true is specified. Otherwise, basic
	// monitoring is enabled. For more information about detailed monitoring, see [Enable or turn off detailed monitoring for your instances]in
	// the Amazon EC2 User Guide.
	//
	// [Enable or turn off detailed monitoring for your instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html
	Enabled *bool

	noSmithyDocumentSerde
}

//	One or more network interfaces to attach to an Amazon EC2 instance. If you
//
// specify a network interface, you must specify security groups and subnets as
// part of the network interface.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails struct {

	//  Indicates whether to associate a Carrier IP address with eth0 for a new
	// network interface. You use this option when you launch an instance in a
	// Wavelength Zone and want to associate a Carrier IP address with the network
	// interface. For more information, see [Carrier IP address]in the Wavelength Developer Guide.
	//
	// [Carrier IP address]: https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip
	AssociateCarrierIpAddress *bool

	//  Associates a public IPv4 address with eth0 for a new network interface.
	AssociatePublicIpAddress *bool

	//  Indicates whether the network interface is deleted when the instance is
	// terminated.
	DeleteOnTermination *bool

	//  A description for the network interface.
	Description *string

	//  The device index for the network interface attachment.
	DeviceIndex *int32

	//  The IDs of one or more security groups.
	Groups []string

	//  The type of network interface.
	InterfaceType *string

	//  The number of IPv4 prefixes to be automatically assigned to the network
	// interface. You cannot use this option if you use the Ipv4Prefixes option.
	Ipv4PrefixCount *int32

	//  One or more IPv4 prefixes to be assigned to the network interface. You cannot
	// use this option if you use the Ipv4PrefixCount option.
	Ipv4Prefixes []AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails

	//  The number of IPv6 addresses to assign to a network interface. Amazon EC2
	// automatically selects the IPv6 addresses from the subnet range. You can't use
	// this option if you use Ipv6Addresses .
	Ipv6AddressCount *int32

	//  One or more specific IPv6 addresses from the IPv6 CIDR block range of your
	// subnet. You can't use this option if you use Ipv6AddressCount .
	Ipv6Addresses []AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails

	//  The number of IPv6 prefixes to be automatically assigned to the network
	// interface. You cannot use this option if you use the Ipv6Prefix option.
	Ipv6PrefixCount *int32

	//  One or more IPv6 prefixes to be assigned to the network interface. You cannot
	// use this option if you use the Ipv6PrefixCount option.
	Ipv6Prefixes []AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails

	//  The index of the network card. Some instance types support multiple network
	// cards. The primary network interface must be assigned to network card index 0 .
	// The default is network card index 0 .
	NetworkCardIndex *int32

	//  The ID of the network interface.
	NetworkInterfaceId *string

	//  The primary private IPv4 address of the network interface.
	PrivateIpAddress *string

	//  One or more private IPv4 addresses.
	PrivateIpAddresses []AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails

	//  The number of secondary private IPv4 addresses to assign to a network
	// interface.
	SecondaryPrivateIpAddressCount *int32

	//  The ID of the subnet for the network interface.
	SubnetId *string

	noSmithyDocumentSerde
}

// Provides details on one or more IPv4 prefixes for a network interface.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails struct {

	//  The IPv4 prefix. For more information, see [Assigning prefixes to Amazon EC2 network interfaces] in the Amazon Elastic Compute
	// Cloud User Guide.
	//
	// [Assigning prefixes to Amazon EC2 network interfaces]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html
	Ipv4Prefix *string

	noSmithyDocumentSerde
}

// Specifies an IPv6 address in an Amazon EC2 launch template.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails struct {

	//  One or more specific IPv6 addresses from the IPv6 CIDR block range of your
	// subnet.
	Ipv6Address *string

	noSmithyDocumentSerde
}

//	Provides details on one or more IPv6 prefixes to be assigned to the network
//
// interface.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails struct {

	//  The IPv6 prefix.
	Ipv6Prefix *string

	noSmithyDocumentSerde
}

// One or more private IPv4 addresses.
type AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails struct {

	//  Indicates whether the private IPv4 address is the primary private IPv4
	// address. Only one IPv4 address can be designated as primary.
	Primary *bool

	//  The private IPv4 address.
	PrivateIpAddress *string

	noSmithyDocumentSerde
}

// Provides details about the placement of an Amazon EC2 instance.
type AwsEc2LaunchTemplateDataPlacementDetails struct {

	//  The affinity setting for an instance on an EC2 Dedicated Host.
	Affinity *string

	//  The Availability Zone for the instance.
	AvailabilityZone *string

	//  The name of the placement group for the instance.
	GroupName *string

	//  The ID of the Dedicated Host for the instance.
	HostId *string

	//  The Amazon Resource Name (ARN) of the host resource group in which to launch
	// the instances.
	HostResourceGroupArn *string

	//  The number of the partition the instance should launch in.
	PartitionNumber *int32

	//  Reserved for future use.
	SpreadDomain *string

	//  The tenancy of the instance (if the instance is running in a VPC). An instance
	// with a tenancy of dedicated runs on single-tenant hardware.
	Tenancy *string

	noSmithyDocumentSerde
}

// Describes the options for Amazon EC2 instance hostnames.
type AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails struct {

	//  Indicates whether to respond to DNS queries for instance hostnames with DNS
	// AAAA records.
	EnableResourceNameDnsAAAARecord *bool

	//  Indicates whether to respond to DNS queries for instance hostnames with DNS A
	// records.
	EnableResourceNameDnsARecord *bool

	//  The type of hostname for EC2 instances.
	HostnameType *string

	noSmithyDocumentSerde
}

//	Specifies the properties for creating an Amazon Elastic Compute Cloud (Amazon
//
// EC2) launch template.
type AwsEc2LaunchTemplateDetails struct {

	//  The default version of the launch template.
	DefaultVersionNumber *int64

	//  An ID for the launch template.
	Id *string

	//  The latest version of the launch template.
	LatestVersionNumber *int64

	//  The information to include in the launch template.
	LaunchTemplateData *AwsEc2LaunchTemplateDataDetails

	//  A name for the launch template.
	LaunchTemplateName *string

	noSmithyDocumentSerde
}

// An association between the network ACL and a subnet.
type AwsEc2NetworkAclAssociation struct {

	// The identifier of the association between the network ACL and the subnet.
	NetworkAclAssociationId *string

	// The identifier of the network ACL.
	NetworkAclId *string

	// The identifier of the subnet that is associated with the network ACL.
	SubnetId *string

	noSmithyDocumentSerde
}

// Contains details about an Amazon EC2 network access control list (ACL).
type AwsEc2NetworkAclDetails struct {

	// Associations between the network ACL and subnets.
	Associations []AwsEc2NetworkAclAssociation

	// The set of rules in the network ACL.
	Entries []AwsEc2NetworkAclEntry

	// Whether this is the default network ACL for the VPC.
	IsDefault *bool

	// The identifier of the network ACL.
	NetworkAclId *string

	// The identifier of the Amazon Web Services account that owns the network ACL.
	OwnerId *string

	// The identifier of the VPC for the network ACL.
	VpcId *string

	noSmithyDocumentSerde
}

// A rule for the network ACL. Each rule allows or denies access based on the IP
// address, traffic direction, port, and protocol.
type AwsEc2NetworkAclEntry struct {

	// The IPV4 network range for which to deny or allow access.
	CidrBlock *string

	// Whether the rule is an egress rule. An egress rule is a rule that applies to
	// traffic that leaves the subnet.
	Egress *bool

	// The Internet Control Message Protocol (ICMP) type and code for which to deny or
	// allow access.
	IcmpTypeCode *IcmpTypeCode

	// The IPV6 network range for which to deny or allow access.
	Ipv6CidrBlock *string

	// For TCP or UDP protocols, the range of ports that the rule applies to.
	PortRange *PortRangeFromTo

	// The protocol that the rule applies to. To deny or allow access to all
	// protocols, use the value -1 .
	Protocol *string

	// Whether the rule is used to allow access or deny access.
	RuleAction *string

	// The rule number. The rules are processed in order by their number.
	RuleNumber *int32

	noSmithyDocumentSerde
}

// Information about the network interface attachment.
type AwsEc2NetworkInterfaceAttachment struct {

	// Indicates when the attachment initiated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	AttachTime *string

	// The identifier of the network interface attachment
	AttachmentId *string

	// Indicates whether the network interface is deleted when the instance is
	// terminated.
	DeleteOnTermination *bool

	// The device index of the network interface attachment on the instance.
	DeviceIndex *int32

	// The ID of the instance.
	InstanceId *string

	// The Amazon Web Services account ID of the owner of the instance.
	InstanceOwnerId *string

	// The attachment state.
	//
	// Valid values: attaching | attached | detaching | detached
	Status *string

	noSmithyDocumentSerde
}

// Details about the network interface
type AwsEc2NetworkInterfaceDetails struct {

	// The network interface attachment.
	Attachment *AwsEc2NetworkInterfaceAttachment

	// The IPv6 addresses associated with the network interface.
	IpV6Addresses []AwsEc2NetworkInterfaceIpV6AddressDetail

	// The ID of the network interface.
	NetworkInterfaceId *string

	// The private IPv4 addresses associated with the network interface.
	PrivateIpAddresses []AwsEc2NetworkInterfacePrivateIpAddressDetail

	// The public DNS name of the network interface.
	PublicDnsName *string

	// The address of the Elastic IP address bound to the network interface.
	PublicIp *string

	// Security groups for the network interface.
	SecurityGroups []AwsEc2NetworkInterfaceSecurityGroup

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck *bool

	noSmithyDocumentSerde
}

// Provides information about an IPV6 address that is associated with the network
// interface.
type AwsEc2NetworkInterfaceIpV6AddressDetail struct {

	// The IPV6 address.
	IpV6Address *string

	noSmithyDocumentSerde
}

// Provides information about a private IPv4 address that is with the network
// interface.
type AwsEc2NetworkInterfacePrivateIpAddressDetail struct {

	// The private DNS name for the IP address.
	PrivateDnsName *string

	// The IP address.
	PrivateIpAddress *string

	noSmithyDocumentSerde
}

// A security group associated with the network interface.
type AwsEc2NetworkInterfaceSecurityGroup struct {

	// The ID of the security group.
	GroupId *string

	// The name of the security group.
	GroupName *string

	noSmithyDocumentSerde
}

// Provides details about a route table for the specified VPC.
type AwsEc2RouteTableDetails struct {

	//  The associations between a route table and one or more subnets or a gateway.
	AssociationSet []AssociationSetDetails

	//  The ID of the Amazon Web Services account that owns the route table.
	OwnerId *string

	//  Describes a virtual private gateway propagating route.
	PropagatingVgwSet []PropagatingVgwSetDetails

	//  The routes in the route table.
	RouteSet []RouteSetDetails

	//  The ID of the route table.
	RouteTableId *string

	//  The ID of the virtual private cloud (VPC).
	VpcId *string

	noSmithyDocumentSerde
}

// Details about an Amazon EC2 security group.
type AwsEc2SecurityGroupDetails struct {

	// The ID of the security group.
	GroupId *string

	// The name of the security group.
	GroupName *string

	// The inbound rules associated with the security group.
	IpPermissions []AwsEc2SecurityGroupIpPermission

	// [VPC only] The outbound rules associated with the security group.
	IpPermissionsEgress []AwsEc2SecurityGroupIpPermission

	// The Amazon Web Services account ID of the owner of the security group.
	OwnerId *string

	// [VPC only] The ID of the VPC for the security group.
	VpcId *string

	noSmithyDocumentSerde
}

// An IP permission for an EC2 security group.
type AwsEc2SecurityGroupIpPermission struct {

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number.
	//
	// A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	FromPort *int32

	// The IP protocol name ( tcp , udp , icmp , icmpv6 ) or number.
	//
	// [VPC only] Use -1 to specify all protocols.
	//
	// When authorizing security group rules, specifying -1 or a protocol number other
	// than tcp , udp , icmp , or icmpv6 allows traffic on all ports, regardless of
	// any port range you specify.
	//
	// For tcp , udp , and icmp , you must specify a port range.
	//
	// For icmpv6 , the port range is optional. If you omit the port range, traffic for
	// all types and codes is allowed.
	IpProtocol *string

	// The IPv4 ranges.
	IpRanges []AwsEc2SecurityGroupIpRange

	// The IPv6 ranges.
	Ipv6Ranges []AwsEc2SecurityGroupIpv6Range

	// [VPC only] The prefix list IDs for an Amazon Web Services service. With
	// outbound rules, this is the Amazon Web Services service to access through a VPC
	// endpoint from instances associated with the security group.
	PrefixListIds []AwsEc2SecurityGroupPrefixListId

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
	//
	// A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	ToPort *int32

	// The security group and Amazon Web Services account ID pairs.
	UserIdGroupPairs []AwsEc2SecurityGroupUserIdGroupPair

	noSmithyDocumentSerde
}

// A range of IPv4 addresses.
type AwsEc2SecurityGroupIpRange struct {

	// The IPv4 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv4 address, use the /32 prefix
	// length.
	CidrIp *string

	noSmithyDocumentSerde
}

// A range of IPv6 addresses.
type AwsEc2SecurityGroupIpv6Range struct {

	// The IPv6 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv6 address, use the /128 prefix
	// length.
	CidrIpv6 *string

	noSmithyDocumentSerde
}

// A prefix list ID.
type AwsEc2SecurityGroupPrefixListId struct {

	// The ID of the prefix.
	PrefixListId *string

	noSmithyDocumentSerde
}

// A relationship between a security group and a user.
type AwsEc2SecurityGroupUserIdGroupPair struct {

	// The ID of the security group.
	GroupId *string

	// The name of the security group.
	GroupName *string

	// The status of a VPC peering connection, if applicable.
	PeeringStatus *string

	// The ID of an Amazon Web Services account.
	//
	// For a referenced security group in another VPC, the account ID of the
	// referenced security group is returned in the response. If the referenced
	// security group is deleted, this value is not returned.
	//
	// [EC2-Classic] Required when adding or removing rules that reference a security
	// group in another VPC.
	UserId *string

	// The ID of the VPC for the referenced security group, if applicable.
	VpcId *string

	// The ID of the VPC peering connection, if applicable.
	VpcPeeringConnectionId *string

	noSmithyDocumentSerde
}

// Contains information about a subnet in Amazon EC2.
type AwsEc2SubnetDetails struct {

	// Whether to assign an IPV6 address to a network interface that is created in
	// this subnet.
	AssignIpv6AddressOnCreation *bool

	// The Availability Zone for the subnet.
	AvailabilityZone *string

	// The identifier of the Availability Zone for the subnet.
	AvailabilityZoneId *string

	// The number of available IPV4 addresses in the subnet. Does not include
	// addresses for stopped instances.
	AvailableIpAddressCount *int32

	// The IPV4 CIDR block that is assigned to the subnet.
	CidrBlock *string

	// Whether this subnet is the default subnet for the Availability Zone.
	DefaultForAz *bool

	// The IPV6 CIDR blocks that are associated with the subnet.
	Ipv6CidrBlockAssociationSet []Ipv6CidrBlockAssociation

	// Whether instances in this subnet receive a public IP address.
	MapPublicIpOnLaunch *bool

	// The identifier of the Amazon Web Services account that owns the subnet.
	OwnerId *string

	// The current state of the subnet. Valid values are available or pending .
	State *string

	// The ARN of the subnet.
	SubnetArn *string

	// The identifier of the subnet.
	SubnetId *string

	// The identifier of the VPC that contains the subnet.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about an Amazon Web Services Amazon EC2 Transit Gateway that
// interconnects virtual private clouds (VPCs) and on-premises networks.
type AwsEc2TransitGatewayDetails struct {

	// A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
	AmazonSideAsn *int32

	// The ID of the default association route table.
	AssociationDefaultRouteTableId *string

	// Turn on or turn off automatic acceptance of attachment requests.
	AutoAcceptSharedAttachments *string

	// Turn on or turn off automatic association with the default association route
	// table.
	DefaultRouteTableAssociation *string

	// Turn on or turn off automatic propagation of routes to the default propagation
	// route table.
	DefaultRouteTablePropagation *string

	// The description of the transit gateway.
	Description *string

	// Turn on or turn off DNS support.
	DnsSupport *string

	// The ID of the transit gateway.
	Id *string

	// Indicates whether multicast is supported on the transit gateway.
	MulticastSupport *string

	// The ID of the default propagation route table.
	PropagationDefaultRouteTableId *string

	// The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
	TransitGatewayCidrBlocks []string

	// Turn on or turn off Equal Cost Multipath Protocol (ECMP) support.
	VpnEcmpSupport *string

	noSmithyDocumentSerde
}

// An attachment to an Amazon EC2 volume.
type AwsEc2VolumeAttachment struct {

	// The datetime when the attachment initiated.
	AttachTime *string

	// Whether the EBS volume is deleted when the EC2 instance is terminated.
	DeleteOnTermination *bool

	// The identifier of the EC2 instance.
	InstanceId *string

	// The attachment state of the volume. Valid values are as follows:
	//
	//   - attaching
	//
	//   - attached
	//
	//   - busy
	//
	//   - detaching
	//
	//   - detached
	Status *string

	noSmithyDocumentSerde
}

// Details about an EC2 volume.
type AwsEc2VolumeDetails struct {

	// The volume attachments.
	Attachments []AwsEc2VolumeAttachment

	// Indicates when the volume was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreateTime *string

	// The device name for the volume that is attached to the instance.
	DeviceName *string

	// Specifies whether the volume is encrypted.
	Encrypted *bool

	// The ARN of the KMS key that was used to protect the volume encryption key for
	// the volume.
	KmsKeyId *string

	// The size of the volume, in GiBs.
	Size *int32

	// The snapshot from which the volume was created.
	SnapshotId *string

	// The volume state. Valid values are as follows:
	//
	//   - available
	//
	//   - creating
	//
	//   - deleted
	//
	//   - deleting
	//
	//   - error
	//
	//   - in-use
	Status *string

	// The ID of the volume.
	VolumeId *string

	// Indicates whether the volume was scanned or skipped.
	VolumeScanStatus *string

	// The volume type.
	VolumeType *string

	noSmithyDocumentSerde
}

// Details about an EC2 VPC.
type AwsEc2VpcDetails struct {

	// Information about the IPv4 CIDR blocks associated with the VPC.
	CidrBlockAssociationSet []CidrBlockAssociation

	// The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options
	// that are associated with the VPC. If the default options are associated with the
	// VPC, then this is default.
	DhcpOptionsId *string

	// Information about the IPv6 CIDR blocks associated with the VPC.
	Ipv6CidrBlockAssociationSet []Ipv6CidrBlockAssociation

	// The current state of the VPC. Valid values are available or pending .
	State *string

	noSmithyDocumentSerde
}

// Contains details about the service configuration for a VPC endpoint service.
type AwsEc2VpcEndpointServiceDetails struct {

	// Whether requests from other Amazon Web Services accounts to create an endpoint
	// to the service must first be accepted.
	AcceptanceRequired *bool

	// The Availability Zones where the service is available.
	AvailabilityZones []string

	// The DNS names for the service.
	BaseEndpointDnsNames []string

	// The ARNs of the Gateway Load Balancers for the service.
	GatewayLoadBalancerArns []string

	// Whether the service manages its VPC endpoints.
	ManagesVpcEndpoints *bool

	// The ARNs of the Network Load Balancers for the service.
	NetworkLoadBalancerArns []string

	// The private DNS name for the service.
	PrivateDnsName *string

	// The identifier of the service.
	ServiceId *string

	// The name of the service.
	ServiceName *string

	// The current state of the service. Valid values are as follows:
	//
	//   - Available
	//
	//   - Deleted
	//
	//   - Deleting
	//
	//   - Failed
	//
	//   - Pending
	ServiceState *string

	// The types for the service.
	ServiceType []AwsEc2VpcEndpointServiceServiceTypeDetails

	noSmithyDocumentSerde
}

// The service type information for a VPC endpoint service.
type AwsEc2VpcEndpointServiceServiceTypeDetails struct {

	// The type of service.
	ServiceType *string

	noSmithyDocumentSerde
}

// Provides information about a VPC peering connection between two VPCs: a
// requester VPC that you own and an accepter VPC with which to create the
// connection.
type AwsEc2VpcPeeringConnectionDetails struct {

	// Information about the accepter VPC.
	AccepterVpcInfo *AwsEc2VpcPeeringConnectionVpcInfoDetails

	// The time at which an unaccepted VPC peering connection will expire.
	ExpirationTime *string

	// Information about the requester VPC.
	RequesterVpcInfo *AwsEc2VpcPeeringConnectionVpcInfoDetails

	// The status of the VPC peering connection.
	Status *AwsEc2VpcPeeringConnectionStatusDetails

	// The ID of the VPC peering connection.
	VpcPeeringConnectionId *string

	noSmithyDocumentSerde
}

// Details about the status of the VPC peering connection.
type AwsEc2VpcPeeringConnectionStatusDetails struct {

	// The status of the VPC peering connection.
	Code *string

	// A message that provides more information about the status, if applicable.
	Message *string

	noSmithyDocumentSerde
}

// Describes a VPC in a VPC peering connection.
type AwsEc2VpcPeeringConnectionVpcInfoDetails struct {

	// The IPv4 CIDR block for the VPC.
	CidrBlock *string

	// Information about the IPv4 CIDR blocks for the VPC.
	CidrBlockSet []VpcInfoCidrBlockSetDetails

	// The IPv6 CIDR block for the VPC.
	Ipv6CidrBlockSet []VpcInfoIpv6CidrBlockSetDetails

	// The ID of the Amazon Web Services account that owns the VPC.
	OwnerId *string

	// Information about the VPC peering connection options for the accepter or
	// requester VPC.
	PeeringOptions *VpcInfoPeeringOptionsDetails

	// The Amazon Web Services Region in which the VPC is located.
	Region *string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Details about an Amazon EC2 VPN connection.
type AwsEc2VpnConnectionDetails struct {

	// The category of the VPN connection. VPN indicates an Amazon Web Services VPN
	// connection. VPN-Classic indicates an Amazon Web Services Classic VPN connection.
	Category *string

	// The configuration information for the VPN connection's customer gateway, in the
	// native XML format.
	CustomerGatewayConfiguration *string

	// The identifier of the customer gateway that is at your end of the VPN
	// connection.
	CustomerGatewayId *string

	// The VPN connection options.
	Options *AwsEc2VpnConnectionOptionsDetails

	// The static routes that are associated with the VPN connection.
	Routes []AwsEc2VpnConnectionRoutesDetails

	// The current state of the VPN connection. Valid values are as follows:
	//
	//   - available
	//
	//   - deleted
	//
	//   - deleting
	//
	//   - pending
	State *string

	// The identifier of the transit gateway that is associated with the VPN
	// connection.
	TransitGatewayId *string

	// The type of VPN connection.
	Type *string

	// Information about the VPN tunnel.
	VgwTelemetry []AwsEc2VpnConnectionVgwTelemetryDetails

	// The identifier of the VPN connection.
	VpnConnectionId *string

	// The identifier of the virtual private gateway that is at the Amazon Web
	// Services side of the VPN connection.
	VpnGatewayId *string

	noSmithyDocumentSerde
}

// VPN connection options.
type AwsEc2VpnConnectionOptionsDetails struct {

	// Whether the VPN connection uses static routes only.
	StaticRoutesOnly *bool

	// The VPN tunnel options.
	TunnelOptions []AwsEc2VpnConnectionOptionsTunnelOptionsDetails

	noSmithyDocumentSerde
}

// The VPN tunnel options.
type AwsEc2VpnConnectionOptionsTunnelOptionsDetails struct {

	// The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
	DpdTimeoutSeconds *int32

	// The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
	IkeVersions []string

	// The external IP address of the VPN tunnel.
	OutsideIpAddress *string

	// The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
	// negotiations.
	Phase1DhGroupNumbers []int32

	// The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
	// negotiations.
	Phase1EncryptionAlgorithms []string

	// The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
	// negotiations.
	Phase1IntegrityAlgorithms []string

	// The lifetime for phase 1 of the IKE negotiation, in seconds.
	Phase1LifetimeSeconds *int32

	// The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
	// negotiations.
	Phase2DhGroupNumbers []int32

	// The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
	// negotiations.
	Phase2EncryptionAlgorithms []string

	// The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
	// negotiations.
	Phase2IntegrityAlgorithms []string

	// The lifetime for phase 2 of the IKE negotiation, in seconds.
	Phase2LifetimeSeconds *int32

	// The preshared key to establish initial authentication between the virtual
	// private gateway and the customer gateway.
	PreSharedKey *string

	// The percentage of the rekey window, which is determined by
	// RekeyMarginTimeSeconds during which the rekey time is randomly selected.
	RekeyFuzzPercentage *int32

	// The margin time, in seconds, before the phase 2 lifetime expires, during which
	// the Amazon Web Services side of the VPN connection performs an IKE rekey.
	RekeyMarginTimeSeconds *int32

	// The number of packets in an IKE replay window.
	ReplayWindowSize *int32

	// The range of inside IPv4 addresses for the tunnel.
	TunnelInsideCidr *string

	noSmithyDocumentSerde
}

// A static routes associated with the VPN connection.
type AwsEc2VpnConnectionRoutesDetails struct {

	// The CIDR block associated with the local subnet of the customer data center.
	DestinationCidrBlock *string

	// The current state of the static route.
	State *string

	noSmithyDocumentSerde
}

// Information about the VPN tunnel.
type AwsEc2VpnConnectionVgwTelemetryDetails struct {

	// The number of accepted routes.
	AcceptedRouteCount *int32

	// The ARN of the VPN tunnel endpoint certificate.
	CertificateArn *string

	// The date and time of the last change in status.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastStatusChange *string

	// The Internet-routable IP address of the virtual private gateway's outside
	// interface.
	OutsideIpAddress *string

	// The status of the VPN tunnel. Valid values are DOWN or UP .
	Status *string

	// If an error occurs, a description of the error.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Information about an Amazon ECR image.
type AwsEcrContainerImageDetails struct {

	// The architecture of the image. Valid values are as follows:
	//
	//   - arm64
	//
	//   - i386
	//
	//   - x86_64
	Architecture *string

	// The sha256 digest of the image manifest.
	ImageDigest *string

	// The date and time when the image was pushed to the repository.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ImagePublishedAt *string

	// The list of tags that are associated with the image.
	ImageTags []string

	// The Amazon Web Services account identifier that is associated with the registry
	// that the image belongs to.
	RegistryId *string

	// The name of the repository that the image belongs to.
	RepositoryName *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon Elastic Container Registry repository.
type AwsEcrRepositoryDetails struct {

	// The ARN of the repository.
	Arn *string

	// The image scanning configuration for a repository.
	ImageScanningConfiguration *AwsEcrRepositoryImageScanningConfigurationDetails

	// The tag mutability setting for the repository. Valid values are IMMUTABLE or
	// MUTABLE .
	ImageTagMutability *string

	// Information about the lifecycle policy for the repository.
	LifecyclePolicy *AwsEcrRepositoryLifecyclePolicyDetails

	// The name of the repository.
	RepositoryName *string

	// The text of the repository policy.
	RepositoryPolicyText *string

	noSmithyDocumentSerde
}

// The image scanning configuration for a repository.
type AwsEcrRepositoryImageScanningConfigurationDetails struct {

	// Whether to scan images after they are pushed to a repository.
	ScanOnPush *bool

	noSmithyDocumentSerde
}

// Information about the lifecycle policy for the repository.
type AwsEcrRepositoryLifecyclePolicyDetails struct {

	// The text of the lifecycle policy.
	LifecyclePolicyText *string

	// The Amazon Web Services account identifier that is associated with the registry
	// that contains the repository.
	RegistryId *string

	noSmithyDocumentSerde
}

// Indicates whether to enable CloudWatch Container Insights for the ECS cluster.
type AwsEcsClusterClusterSettingsDetails struct {

	// The name of the setting. The valid value is containerInsights .
	Name *string

	// The value of the setting. Valid values are disabled or enabled .
	Value *string

	noSmithyDocumentSerde
}

// The run command configuration for the cluster.
type AwsEcsClusterConfigurationDetails struct {

	// Contains the run command configuration for the cluster.
	ExecuteCommandConfiguration *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails

	noSmithyDocumentSerde
}

// Contains the run command configuration for the cluster.
type AwsEcsClusterConfigurationExecuteCommandConfigurationDetails struct {

	// The identifier of the KMS key that is used to encrypt the data between the
	// local client and the container.
	KmsKeyId *string

	// The log configuration for the results of the run command actions. Required if
	// Logging is NONE .
	LogConfiguration *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails

	// The log setting to use for redirecting logs for run command results.
	Logging *string

	noSmithyDocumentSerde
}

// The log configuration for the results of the run command actions.
type AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails struct {

	// Whether to enable encryption on the CloudWatch logs.
	CloudWatchEncryptionEnabled *bool

	// The name of the CloudWatch log group to send the logs to.
	CloudWatchLogGroupName *string

	// The name of the S3 bucket to send logs to.
	S3BucketName *string

	// Whether to encrypt the logs that are sent to the S3 bucket.
	S3EncryptionEnabled *bool

	// Identifies the folder in the S3 bucket to send the logs to.
	S3KeyPrefix *string

	noSmithyDocumentSerde
}

// The default capacity provider strategy for the cluster. The default capacity
// provider strategy is used when services or tasks are run without a specified
// launch type or capacity provider strategy.
type AwsEcsClusterDefaultCapacityProviderStrategyDetails struct {

	// The minimum number of tasks to run on the specified capacity provider.
	Base *int32

	// The name of the capacity provider.
	CapacityProvider *string

	// The relative percentage of the total number of tasks launched that should use
	// the capacity provider.
	Weight *int32

	noSmithyDocumentSerde
}

// Provides details about an Amazon ECS cluster.
type AwsEcsClusterDetails struct {

	// The number of services that are running on the cluster in an ACTIVE state. You
	// can view these services with the Amazon ECS [ListServices]ListServices API operation.
	//
	// [ListServices]: https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html
	ActiveServicesCount *int32

	// The short name of one or more capacity providers to associate with the cluster.
	CapacityProviders []string

	// The Amazon Resource Name (ARN) that identifies the cluster.
	ClusterArn *string

	// A name that you use to identify your cluster.
	ClusterName *string

	// The setting to use to create the cluster. Specifically used to configure
	// whether to enable CloudWatch Container Insights for the cluster.
	ClusterSettings []AwsEcsClusterClusterSettingsDetails

	// The run command configuration for the cluster.
	Configuration *AwsEcsClusterConfigurationDetails

	// The default capacity provider strategy for the cluster. The default capacity
	// provider strategy is used when services or tasks are run without a specified
	// launch type or capacity provider strategy.
	DefaultCapacityProviderStrategy []AwsEcsClusterDefaultCapacityProviderStrategyDetails

	// The number of container instances registered into the cluster. This includes
	// container instances in both ACTIVE and DRAINING status.
	RegisteredContainerInstancesCount *int32

	// The number of tasks in the cluster that are in the RUNNING state.
	RunningTasksCount *int32

	// The status of the cluster.
	Status *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon ECS container.
type AwsEcsContainerDetails struct {

	// The image used for the container.
	Image *string

	// The mount points for data volumes in your container.
	MountPoints []AwsMountPoint

	// The name of the container.
	Name *string

	// When this parameter is true, the container is given elevated privileges on the
	// host container instance (similar to the root user).
	Privileged *bool

	noSmithyDocumentSerde
}

// Strategy item for the capacity provider strategy that the service uses.
type AwsEcsServiceCapacityProviderStrategyDetails struct {

	// The minimum number of tasks to run on the capacity provider. Only one strategy
	// item can specify a value for Base .
	//
	// The value must be between 0 and 100000.
	Base *int32

	// The short name of the capacity provider.
	CapacityProvider *string

	// The relative percentage of the total number of tasks that should use the
	// capacity provider.
	//
	// If no weight is specified, the default value is 0. At least one capacity
	// provider must have a weight greater than 0.
	//
	// The value can be between 0 and 1000.
	Weight *int32

	noSmithyDocumentSerde
}

// Determines whether a service deployment fails if a service cannot reach a
// steady state.
type AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails struct {

	// Whether to enable the deployment circuit breaker logic for the service.
	Enable *bool

	// Whether to roll back the service if a service deployment fails. If rollback is
	// enabled, when a service deployment fails, the service is rolled back to the last
	// deployment that completed successfully.
	Rollback *bool

	noSmithyDocumentSerde
}

// Optional deployment parameters for the service.
type AwsEcsServiceDeploymentConfigurationDetails struct {

	// Determines whether a service deployment fails if a service cannot reach a
	// steady state.
	DeploymentCircuitBreaker *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails

	// For a service that uses the rolling update ( ECS ) deployment type, the maximum
	// number of tasks in a service that are allowed in the RUNNING or PENDING state
	// during a deployment, and for tasks that use the EC2 launch type, when any
	// container instances are in the DRAINING state. Provided as a percentage of the
	// desired number of tasks. The default value is 200%.
	//
	// For a service that uses the blue/green ( CODE_DEPLOY ) or EXTERNAL deployment
	// types, and tasks that use the EC2 launch type, the maximum number of tasks in
	// the service that remain in the RUNNING state while the container instances are
	// in the DRAINING state.
	//
	// For the Fargate launch type, the maximum percent value is not used.
	MaximumPercent *int32

	// For a service that uses the rolling update ( ECS ) deployment type, the minimum
	// number of tasks in a service that must remain in the RUNNING state during a
	// deployment, and while any container instances are in the DRAINING state if the
	// service contains tasks using the EC2 launch type. Expressed as a percentage of
	// the desired number of tasks. The default value is 100%.
	//
	// For a service that uses the blue/green ( CODE_DEPLOY ) or EXTERNAL deployment
	// types and tasks that use the EC2 launch type, the minimum number of the tasks in
	// the service that remain in the RUNNING state while the container instances are
	// in the DRAINING state.
	//
	// For the Fargate launch type, the minimum healthy percent value is not used.
	MinimumHealthyPercent *int32

	noSmithyDocumentSerde
}

// Information about the deployment controller type that the service uses.
type AwsEcsServiceDeploymentControllerDetails struct {

	// The rolling update ( ECS ) deployment type replaces the current running version
	// of the container with the latest version.
	//
	// The blue/green ( CODE_DEPLOY ) deployment type uses the blue/green deployment
	// model that is powered by CodeDeploy. This deployment model a new deployment of a
	// service can be verified before production traffic is sent to it.
	//
	// The external ( EXTERNAL ) deployment type allows the use of any third-party
	// deployment controller for full control over the deployment process for an Amazon
	// ECS service.
	//
	// Valid values: ECS | CODE_DEPLOY | EXTERNAL
	Type *string

	noSmithyDocumentSerde
}

// Provides details about a service within an ECS cluster.
type AwsEcsServiceDetails struct {

	// The capacity provider strategy that the service uses.
	CapacityProviderStrategy []AwsEcsServiceCapacityProviderStrategyDetails

	// The ARN of the cluster that hosts the service.
	Cluster *string

	// Deployment parameters for the service. Includes the number of tasks that run
	// and the order in which to start and stop tasks.
	DeploymentConfiguration *AwsEcsServiceDeploymentConfigurationDetails

	// Contains the deployment controller type that the service uses.
	DeploymentController *AwsEcsServiceDeploymentControllerDetails

	// The number of instantiations of the task definition to run on the service.
	DesiredCount *int32

	// Whether to enable Amazon ECS managed tags for the tasks in the service.
	EnableEcsManagedTags *bool

	// Whether the execute command functionality is enabled for the service.
	EnableExecuteCommand *bool

	// After a task starts, the amount of time in seconds that the Amazon ECS service
	// scheduler ignores unhealthy Elastic Load Balancing target health checks.
	HealthCheckGracePeriodSeconds *int32

	// The launch type that the service uses.
	//
	// Valid values: EC2 | FARGATE | EXTERNAL
	LaunchType *string

	// Information about the load balancers that the service uses.
	LoadBalancers []AwsEcsServiceLoadBalancersDetails

	// The name of the service.
	Name *string

	// For tasks that use the awsvpc networking mode, the VPC subnet and security
	// group configuration.
	NetworkConfiguration *AwsEcsServiceNetworkConfigurationDetails

	// The placement constraints for the tasks in the service.
	PlacementConstraints []AwsEcsServicePlacementConstraintsDetails

	// Information about how tasks for the service are placed.
	PlacementStrategies []AwsEcsServicePlacementStrategiesDetails

	// The platform version on which to run the service. Only specified for tasks that
	// are hosted on Fargate. If a platform version is not specified, the LATEST
	// platform version is used by default.
	PlatformVersion *string

	// Indicates whether to propagate the tags from the task definition to the task or
	// from the service to the task. If no value is provided, then tags are not
	// propagated.
	//
	// Valid values: TASK_DEFINITION | SERVICE
	PropagateTags *string

	// The ARN of the IAM role that is associated with the service. The role allows
	// the Amazon ECS container agent to register container instances with an Elastic
	// Load Balancing load balancer.
	Role *string

	// The scheduling strategy to use for the service.
	//
	// The REPLICA scheduling strategy places and maintains the desired number of
	// tasks across the cluster. By default, the service scheduler spreads tasks across
	// Availability Zones. Task placement strategies and constraints are used to
	// customize task placement decisions.
	//
	// The DAEMON scheduling strategy deploys exactly one task on each active
	// container instance that meets all of the task placement constraints that are
	// specified in the cluster. The service scheduler also evaluates the task
	// placement constraints for running tasks and stops tasks that do not meet the
	// placement constraints.
	//
	// Valid values: REPLICA | DAEMON
	SchedulingStrategy *string

	// The ARN of the service.
	ServiceArn *string

	// The name of the service.
	//
	// The name can contain up to 255 characters. It can use letters, numbers,
	// underscores, and hyphens.
	ServiceName *string

	// Information about the service discovery registries to assign to the service.
	ServiceRegistries []AwsEcsServiceServiceRegistriesDetails

	// The task definition to use for tasks in the service.
	TaskDefinition *string

	noSmithyDocumentSerde
}

// Information about a load balancer that the service uses.
type AwsEcsServiceLoadBalancersDetails struct {

	// The name of the container to associate with the load balancer.
	ContainerName *string

	// The port on the container to associate with the load balancer. This port must
	// correspond to a containerPort in the task definition the tasks in the service
	// are using. For tasks that use the EC2 launch type, the container instance they
	// are launched on must allow ingress traffic on the hostPort of the port mapping.
	ContainerPort *int32

	// The name of the load balancer to associate with the Amazon ECS service or task
	// set.
	//
	// Only specified when using a Classic Load Balancer. For an Application Load
	// Balancer or a Network Load Balancer, the load balancer name is omitted.
	LoadBalancerName *string

	// The ARN of the Elastic Load Balancing target group or groups associated with a
	// service or task set.
	//
	// Only specified when using an Application Load Balancer or a Network Load
	// Balancer. For a Classic Load Balancer, the target group ARN is omitted.
	TargetGroupArn *string

	noSmithyDocumentSerde
}

// For tasks that use the awsvpc networking mode, the VPC subnet and security
// group configuration.
type AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails struct {

	// Whether the task's elastic network interface receives a public IP address. The
	// default value is DISABLED .
	//
	// Valid values: ENABLED | DISABLED
	AssignPublicIp *string

	// The IDs of the security groups associated with the task or service.
	//
	// You can provide up to five security groups.
	SecurityGroups []string

	// The IDs of the subnets associated with the task or service.
	//
	// You can provide up to 16 subnets.
	Subnets []string

	noSmithyDocumentSerde
}

// For tasks that use the awsvpc networking mode, the VPC subnet and security
// group configuration.
type AwsEcsServiceNetworkConfigurationDetails struct {

	// The VPC subnet and security group configuration.
	AwsVpcConfiguration *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails

	noSmithyDocumentSerde
}

// A placement constraint for the tasks in the service.
type AwsEcsServicePlacementConstraintsDetails struct {

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance .
	Expression *string

	// The type of constraint. Use distinctInstance to run each task in a particular
	// group on a different container instance. Use memberOf to restrict the selection
	// to a group of valid candidates.
	//
	// Valid values: distinctInstance | memberOf
	Type *string

	noSmithyDocumentSerde
}

// A placement strategy that determines how to place the tasks for the service.
type AwsEcsServicePlacementStrategiesDetails struct {

	// The field to apply the placement strategy against.
	//
	// For the spread placement strategy, valid values are instanceId (or host , which
	// has the same effect), or any platform or custom attribute that is applied to a
	// container instance, such as attribute:ecs.availability-zone .
	//
	// For the binpack placement strategy, valid values are cpu and memory .
	//
	// For the random placement strategy, this attribute is not used.
	Field *string

	// The type of placement strategy.
	//
	// The random placement strategy randomly places tasks on available candidates.
	//
	// The spread placement strategy spreads placement across available candidates
	// evenly based on the value of Field .
	//
	// The binpack strategy places tasks on available candidates that have the least
	// available amount of the resource that is specified in Field .
	//
	// Valid values: random | spread | binpack
	Type *string

	noSmithyDocumentSerde
}

// Information about a service discovery registry to assign to the service.
type AwsEcsServiceServiceRegistriesDetails struct {

	// The container name value to use for the service discovery service.
	//
	// If the task definition uses the bridge or host network mode, you must specify
	// ContainerName and ContainerPort .
	//
	// If the task definition uses the awsvpc network mode and a type SRV DNS record,
	// you must specify either ContainerName and ContainerPort , or Port , but not
	// both.
	ContainerName *string

	// The port value to use for the service discovery service.
	//
	// If the task definition uses the bridge or host network mode, you must specify
	// ContainerName and ContainerPort .
	//
	// If the task definition uses the awsvpc network mode and a type SRV DNS record,
	// you must specify either ContainerName and ContainerPort , or Port , but not
	// both.
	ContainerPort *int32

	// The port value to use for a service discovery service that specifies an SRV
	// record. This field can be used if both the awsvpc awsvpc network mode and SRV
	// records are used.
	Port *int32

	// The ARN of the service registry.
	RegistryArn *string

	noSmithyDocumentSerde
}

// A dependency that is defined for container startup and shutdown.
type AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails struct {

	// The dependency condition of the dependent container. Indicates the required
	// status of the dependent container before the current container can start. Valid
	// values are as follows:
	//
	//   - COMPLETE
	//
	//   - HEALTHY
	//
	//   - SUCCESS
	//
	//   - START
	Condition *string

	// The name of the dependent container.
	ContainerName *string

	noSmithyDocumentSerde
}

// A container definition that describes a container in the task.
type AwsEcsTaskDefinitionContainerDefinitionsDetails struct {

	// The command that is passed to the container.
	Command []string

	// The number of CPU units reserved for the container.
	Cpu *int32

	// The dependencies that are defined for container startup and shutdown.
	DependsOn []AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails

	// Whether to disable networking within the container.
	DisableNetworking *bool

	// A list of DNS search domains that are presented to the container.
	DnsSearchDomains []string

	// A list of DNS servers that are presented to the container.
	DnsServers []string

	// A key-value map of labels to add to the container.
	DockerLabels map[string]string

	// A list of strings to provide custom labels for SELinux and AppArmor multi-level
	// security systems.
	DockerSecurityOptions []string

	// The entry point that is passed to the container.
	EntryPoint []string

	// The environment variables to pass to a container.
	Environment []AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails

	// A list of files containing the environment variables to pass to a container.
	EnvironmentFiles []AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails

	// Whether the container is essential. All tasks must have at least one essential
	// container.
	Essential *bool

	// A list of hostnames and IP address mappings to append to the /etc/hosts file on
	// the container.
	ExtraHosts []AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails

	// The FireLens configuration for the container. Specifies and configures a log
	// router for container logs.
	FirelensConfiguration *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails

	// The container health check command and associated configuration parameters for
	// the container.
	HealthCheck *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails

	// The hostname to use for the container.
	Hostname *string

	// The image used to start the container.
	Image *string

	// If set to true, then containerized applications can be deployed that require
	// stdin or a tty to be allocated.
	Interactive *bool

	// A list of links for the container in the form  container_name:alias . Allows
	// containers to communicate with each other without the need for port mappings.
	Links []string

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities.
	LinuxParameters *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails

	// The log configuration specification for the container.
	LogConfiguration *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails

	// The amount (in MiB) of memory to present to the container. If the container
	// attempts to exceed the memory specified here, the container is shut down. The
	// total amount of memory reserved for all containers within a task must be lower
	// than the task memory value, if one is specified.
	Memory *int32

	// The soft limit (in MiB) of memory to reserve for the container.
	MemoryReservation *int32

	// The mount points for the data volumes in the container.
	MountPoints []AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails

	// The name of the container.
	Name *string

	// The list of port mappings for the container.
	PortMappings []AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails

	// Whether the container is given elevated privileges on the host container
	// instance. The elevated privileges are similar to the root user.
	Privileged *bool

	// Whether to allocate a TTY to the container.
	PseudoTerminal *bool

	// Whether the container is given read-only access to its root file system.
	ReadonlyRootFilesystem *bool

	// The private repository authentication credentials to use.
	RepositoryCredentials *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails

	// The secrets to pass to the container.
	Secrets []AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails

	// The number of seconds to wait before giving up on resolving dependencies for a
	// container.
	StartTimeout *int32

	// The number of seconds to wait before the container is stopped if it doesn't
	// shut down normally on its own.
	StopTimeout *int32

	// A list of namespaced kernel parameters to set in the container.
	SystemControls []AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails

	// A list of ulimits to set in the container.
	Ulimits []AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails

	// The user to use inside the container.
	//
	// The value can use one of the following formats.
	//
	//   - user
	//
	//   - user : group
	//
	//   - uid
	//
	//   - uid : gid
	//
	//   - user : gid
	//
	//   - uid : group
	User *string

	// Data volumes to mount from another container.
	VolumesFrom []AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails

	// The working directory in which to run commands inside the container.
	WorkingDirectory *string

	noSmithyDocumentSerde
}

// An environment variable to pass to the container.
type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails struct {

	// The name of the environment variable.
	Name *string

	// The value of the environment variable.
	Value *string

	noSmithyDocumentSerde
}

// A file that contain environment variables to pass to a container.
type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails struct {

	// The type of environment file. The valid value is s3 .
	Type *string

	// The ARN of the S3 object that contains the environment variable file.
	Value *string

	noSmithyDocumentSerde
}

// A hostname and IP address mapping to append to the /etc/hosts file on the
// container.
type AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails struct {

	// The hostname to use in the /etc/hosts entry.
	Hostname *string

	// The IP address to use in the /etc/hosts entry.
	IpAddress *string

	noSmithyDocumentSerde
}

// The FireLens configuration for the container. The configuration specifies and
// configures a log router for container logs.
type AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails struct {

	// The options to use to configure the log router.
	//
	// The valid option keys are as follows:
	//
	//   - enable-ecs-log-metadata . The value can be true or false .
	//
	//   - config-file-type . The value can be s3 or file .
	//
	//   - config-file-value . The value is either an S3 ARN or a file path.
	Options map[string]string

	// The log router to use. Valid values are fluentbit or fluentd .
	Type *string

	noSmithyDocumentSerde
}

// The container health check command and associated configuration parameters for
// the container.
type AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails struct {

	// The command that the container runs to determine whether it is healthy.
	Command []string

	// The time period in seconds between each health check execution. The default
	// value is 30 seconds.
	Interval *int32

	// The number of times to retry a failed health check before the container is
	// considered unhealthy. The default value is 3.
	Retries *int32

	// The optional grace period in seconds that allows containers time to bootstrap
	// before failed health checks count towards the maximum number of retries.
	StartPeriod *int32

	// The time period in seconds to wait for a health check to succeed before it is
	// considered a failure. The default value is 5.
	Timeout *int32

	noSmithyDocumentSerde
}

// The Linux capabilities for the container that are added to or dropped from the
// default configuration provided by Docker.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails struct {

	// The Linux capabilities for the container that are added to the default
	// configuration provided by Docker. Valid values are as follows:
	//
	// Valid values: "ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
	// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK"
	// | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" |
	// "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" |
	// "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" |
	// "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" |
	// "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" |
	// "SYSLOG" | "WAKE_ALARM"
	Add []string

	// The Linux capabilities for the container that are dropped from the default
	// configuration provided by Docker.
	//
	// Valid values: "ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
	// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK"
	// | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" |
	// "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" |
	// "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" |
	// "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" |
	// "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" |
	// "SYSLOG" | "WAKE_ALARM"
	Drop []string

	noSmithyDocumentSerde
}

// >Linux-specific modifications that are applied to the container, such as Linux
// kernel capabilities.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails struct {

	// The Linux capabilities for the container that are added to or dropped from the
	// default configuration provided by Docker.
	Capabilities *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails

	// The host devices to expose to the container.
	Devices []AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails

	// Whether to run an init process inside the container that forwards signals and
	// reaps processes.
	InitProcessEnabled *bool

	// The total amount of swap memory (in MiB) that a container can use.
	MaxSwap *int32

	// The value for the size (in MiB) of the /dev/shm volume.
	SharedMemorySize *int32

	// Configures the container's memory swappiness behavior. Determines how
	// aggressively pages are swapped. The higher the value, the more aggressive the
	// swappiness. The default is 60.
	Swappiness *int32

	// The container path, mount options, and size (in MiB) of the tmpfs mount.
	Tmpfs []AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails

	noSmithyDocumentSerde
}

// A host device to expose to the container.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails struct {

	// The path inside the container at which to expose the host device.
	ContainerPath *string

	// The path for the device on the host container instance.
	HostPath *string

	// The explicit permissions to provide to the container for the device. By
	// default, the container has permissions for read, write, and mknod for the
	// device.
	Permissions []string

	noSmithyDocumentSerde
}

// The container path, mount options, and size (in MiB) of a tmpfs mount.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails struct {

	// The absolute file path where the tmpfs volume is to be mounted.
	ContainerPath *string

	// The list of tmpfs volume mount options.
	//
	// Valid values: "defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev" |
	// "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" | "nomand"
	// | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind" |
	// "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" |
	// "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime"
	// | "mode" | "uid" | "gid" | "nr_inodes" | "nr_blocks" | "mpol"
	MountOptions []string

	// The maximum size (in MiB) of the tmpfs volume.
	Size *int32

	noSmithyDocumentSerde
}

// The log configuration specification for the container.
type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails struct {

	// The log driver to use for the container.
	//
	// Valid values on Fargate are as follows:
	//
	//   - awsfirelens
	//
	//   - awslogs
	//
	//   - splunk
	//
	// Valid values on Amazon EC2 are as follows:
	//
	//   - awsfirelens
	//
	//   - awslogs
	//
	//   - fluentd
	//
	//   - gelf
	//
	//   - journald
	//
	//   - json-file
	//
	//   - logentries
	//
	//   - splunk
	//
	//   - syslog
	LogDriver *string

	// The configuration options to send to the log driver. Requires version 1.19 of
	// the Docker Remote API or greater on your container instance.
	Options map[string]string

	// The secrets to pass to the log configuration.
	SecretOptions []AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails

	noSmithyDocumentSerde
}

// A secret to pass to the log configuration.
type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails struct {

	// The name of the secret.
	Name *string

	// The secret to expose to the container.
	//
	// The value is either the full ARN of the Secrets Manager secret or the full ARN
	// of the parameter in the Systems Manager Parameter Store.
	ValueFrom *string

	noSmithyDocumentSerde
}

// A mount point for the data volumes in the container.
type AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails struct {

	// The path on the container to mount the host volume at.
	ContainerPath *string

	// Whether the container has read-only access to the volume.
	ReadOnly *bool

	// The name of the volume to mount. Must match the name of a volume listed in
	// VolumeDetails for the task definition.
	SourceVolume *string

	noSmithyDocumentSerde
}

// A port mapping for the container.
type AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails struct {

	// The port number on the container that is bound to the user-specified or
	// automatically assigned host port.
	ContainerPort *int32

	// The port number on the container instance to reserve for the container.
	HostPort *int32

	// The protocol used for the port mapping. The default is tcp .
	Protocol *string

	noSmithyDocumentSerde
}

// The private repository authentication credentials to use.
type AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails struct {

	// The ARN of the secret that contains the private repository credentials.
	CredentialsParameter *string

	noSmithyDocumentSerde
}

// A resource to assign to a container.
type AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails struct {

	// The type of resource to assign to a container. Valid values are GPU or
	// InferenceAccelerator .
	Type *string

	// The value for the specified resource type.
	//
	// For GPU , the value is the number of physical GPUs the Amazon ECS container
	// agent reserves for the container.
	//
	// For InferenceAccelerator , the value should match the DeviceName attribute of
	// an entry in InferenceAccelerators .
	Value *string

	noSmithyDocumentSerde
}

// A secret to pass to the container.
type AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails struct {

	// The name of the secret.
	Name *string

	// The secret to expose to the container. The value is either the full ARN of the
	// Secrets Manager secret or the full ARN of the parameter in the Systems Manager
	// Parameter Store.
	ValueFrom *string

	noSmithyDocumentSerde
}

// A namespaced kernel parameter to set in the container.
type AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails struct {

	// The namespaced kernel parameter for which to set a value.
	Namespace *string

	// The value of the parameter.
	Value *string

	noSmithyDocumentSerde
}

// A ulimit to set in the container.
type AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails struct {

	// The hard limit for the ulimit type.
	HardLimit *int32

	// The type of the ulimit. Valid values are as follows:
	//
	//   - core
	//
	//   - cpu
	//
	//   - data
	//
	//   - fsize
	//
	//   - locks
	//
	//   - memlock
	//
	//   - msgqueue
	//
	//   - nice
	//
	//   - nofile
	//
	//   - nproc
	//
	//   - rss
	//
	//   - rtprio
	//
	//   - rttime
	//
	//   - sigpending
	//
	//   - stack
	Name *string

	// The soft limit for the ulimit type.
	SoftLimit *int32

	noSmithyDocumentSerde
}

// A data volume to mount from another container.
type AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails struct {

	// Whether the container has read-only access to the volume.
	ReadOnly *bool

	// The name of another container within the same task definition from which to
	// mount volumes.
	SourceContainer *string

	noSmithyDocumentSerde
}

// Details about a task definition. A task definition describes the container and
// volume definitions of an Amazon Elastic Container Service task.
type AwsEcsTaskDefinitionDetails struct {

	// The container definitions that describe the containers that make up the task.
	ContainerDefinitions []AwsEcsTaskDefinitionContainerDefinitionsDetails

	// The number of CPU units used by the task.Valid values are as follows:
	//
	//   - 256 (.25 vCPU)
	//
	//   - 512 (.5 vCPU)
	//
	//   - 1024 (1 vCPU)
	//
	//   - 2048 (2 vCPU)
	//
	//   - 4096 (4 vCPU)
	Cpu *string

	// The ARN of the task execution role that grants the container agent permission
	// to make API calls on behalf of the container user.
	ExecutionRoleArn *string

	// The name of a family that this task definition is registered to.
	Family *string

	// The Elastic Inference accelerators to use for the containers in the task.
	InferenceAccelerators []AwsEcsTaskDefinitionInferenceAcceleratorsDetails

	// The inter-process communication (IPC) resource namespace to use for the
	// containers in the task. Valid values are as follows:
	//
	//   - host
	//
	//   - none
	//
	//   - task
	IpcMode *string

	// The amount (in MiB) of memory used by the task.
	//
	// For tasks that are hosted on Amazon EC2, you can provide a task-level memory
	// value or a container-level memory value. For tasks that are hosted on Fargate,
	// you must use one of the [specified values]in the Amazon Elastic Container Service Developer Guide
	// , which determines your range of supported values for the Cpu and Memory
	// parameters.
	//
	// [specified values]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size
	Memory *string

	// The Docker networking mode to use for the containers in the task. Valid values
	// are as follows:
	//
	//   - awsvpc
	//
	//   - bridge
	//
	//   - host
	//
	//   - none
	NetworkMode *string

	// The process namespace to use for the containers in the task. Valid values are
	// host or task .
	PidMode *string

	// The placement constraint objects to use for tasks.
	PlacementConstraints []AwsEcsTaskDefinitionPlacementConstraintsDetails

	// The configuration details for the App Mesh proxy.
	ProxyConfiguration *AwsEcsTaskDefinitionProxyConfigurationDetails

	// The task launch types that the task definition was validated against.
	RequiresCompatibilities []string

	//  The status of the task definition.
	Status *string

	// The short name or ARN of the IAM role that grants containers in the task
	// permission to call Amazon Web Services API operations on your behalf.
	TaskRoleArn *string

	// The data volume definitions for the task.
	Volumes []AwsEcsTaskDefinitionVolumesDetails

	noSmithyDocumentSerde
}

// An Elastic Inference accelerator to use for the containers in the task.
type AwsEcsTaskDefinitionInferenceAcceleratorsDetails struct {

	// The Elastic Inference accelerator device name.
	DeviceName *string

	// The Elastic Inference accelerator type to use.
	DeviceType *string

	noSmithyDocumentSerde
}

// A placement constraint object to use for tasks.
type AwsEcsTaskDefinitionPlacementConstraintsDetails struct {

	// A cluster query language expression to apply to the constraint.
	Expression *string

	// The type of constraint.
	Type *string

	noSmithyDocumentSerde
}

// The configuration details for the App Mesh proxy.
type AwsEcsTaskDefinitionProxyConfigurationDetails struct {

	// The name of the container that will serve as the App Mesh proxy.
	ContainerName *string

	// The set of network configuration parameters to provide to the Container Network
	// Interface (CNI) plugin, specified as key-value pairs.
	ProxyConfigurationProperties []AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails

	// The proxy type.
	Type *string

	noSmithyDocumentSerde
}

// A network configuration parameter to provide to the Container Network Interface
// (CNI) plugin.
type AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails struct {

	// The name of the property.
	Name *string

	// The value of the property.
	Value *string

	noSmithyDocumentSerde
}

// A data volume to mount from another container.
type AwsEcsTaskDefinitionVolumesDetails struct {

	// Information about a Docker volume.
	DockerVolumeConfiguration *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails

	// Information about the Amazon Elastic File System file system that is used for
	// task storage.
	EfsVolumeConfiguration *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails

	// Information about a bind mount host volume.
	Host *AwsEcsTaskDefinitionVolumesHostDetails

	// The name of the data volume.
	Name *string

	noSmithyDocumentSerde
}

// Information about a Docker volume.
type AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails struct {

	// Whether to create the Docker volume automatically if it does not already exist.
	Autoprovision *bool

	// The Docker volume driver to use.
	Driver *string

	// A map of Docker driver-specific options that are passed through.
	DriverOpts map[string]string

	// Custom metadata to add to the Docker volume.
	Labels map[string]string

	// The scope for the Docker volume that determines its lifecycle. Docker volumes
	// that are scoped to a task are provisioned automatically when the task starts and
	// destroyed when the task stops. Docker volumes that are shared persist after the
	// task stops. Valid values are shared or task .
	Scope *string

	noSmithyDocumentSerde
}

type AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails struct {

	// The Amazon EFS access point identifier to use.
	AccessPointId *string

	// Whether to use the Amazon ECS task IAM role defined in a task definition when
	// mounting the Amazon EFS file system.
	Iam *string

	noSmithyDocumentSerde
}

// Information about the Amazon Elastic File System file system that is used for
// task storage.
type AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails struct {

	// The authorization configuration details for the Amazon EFS file system.
	AuthorizationConfig *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails

	// The Amazon EFS file system identifier to use.
	FilesystemId *string

	// The directory within the Amazon EFS file system to mount as the root directory
	// inside the host.
	RootDirectory *string

	// Whether to enable encryption for Amazon EFS data in transit between the Amazon
	// ECS host and the Amazon EFS server.
	TransitEncryption *string

	// The port to use when sending encrypted data between the Amazon ECS host and the
	// Amazon EFS server.
	TransitEncryptionPort *int32

	noSmithyDocumentSerde
}

// Information about a bind mount host volume.
type AwsEcsTaskDefinitionVolumesHostDetails struct {

	// The path on the host container instance that is presented to the container.
	SourcePath *string

	noSmithyDocumentSerde
}

// Provides details about a task in a cluster.
type AwsEcsTaskDetails struct {

	// The Amazon Resource Name (ARN) of the cluster that hosts the task.
	ClusterArn *string

	// The containers that are associated with the task.
	Containers []AwsEcsContainerDetails

	// The Unix timestamp for the time when the task was created. More specifically,
	// it's for the time when the task entered the PENDING state.
	CreatedAt *string

	// The name of the task group that's associated with the task.
	Group *string

	// The Unix timestamp for the time when the task started. More specifically, it's
	// for the time when the task transitioned from the PENDING state to the RUNNING
	// state.
	StartedAt *string

	// The tag specified when a task is started. If an Amazon ECS service started the
	// task, the startedBy parameter contains the deployment ID of that service.
	StartedBy *string

	// The ARN of the task definition that creates the task.
	TaskDefinitionArn *string

	// The version counter for the task.
	Version *string

	// Details about the data volume that is used in a task definition.
	Volumes []AwsEcsTaskVolumeDetails

	noSmithyDocumentSerde
}

// Provides information about a data volume that's used in a task definition.
type AwsEcsTaskVolumeDetails struct {

	// This parameter is specified when you use bind mount host volumes. The contents
	// of the host parameter determine whether your bind mount host volume persists on
	// the host container instance and where it's stored.
	Host *AwsEcsTaskVolumeHostDetails

	// The name of the volume. Up to 255 letters (uppercase and lowercase), numbers,
	// underscores, and hyphens are allowed. This name is referenced in the
	// sourceVolume parameter of container definition mountPoints .
	Name *string

	noSmithyDocumentSerde
}

// Provides details on a container instance bind mount host volume.
type AwsEcsTaskVolumeHostDetails struct {

	// When the host parameter is used, specify a sourcePath to declare the path on
	// the host container instance that's presented to the container.
	SourcePath *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon EFS access point.
type AwsEfsAccessPointDetails struct {

	// The ID of the Amazon EFS access point.
	AccessPointId *string

	// The Amazon Resource Name (ARN) of the Amazon EFS access point.
	Arn *string

	// The opaque string specified in the request to ensure idempotent creation.
	ClientToken *string

	// The ID of the Amazon EFS file system that the access point applies to.
	FileSystemId *string

	// The full POSIX identity, including the user ID, group ID, and secondary group
	// IDs on the access point, that is used for all file operations by NFS clients
	// using the access point.
	PosixUser *AwsEfsAccessPointPosixUserDetails

	// The directory on the Amazon EFS file system that the access point exposes as
	// the root directory to NFS clients using the access point.
	RootDirectory *AwsEfsAccessPointRootDirectoryDetails

	noSmithyDocumentSerde
}

// Provides details for all file system operations using this Amazon EFS access
// point.
type AwsEfsAccessPointPosixUserDetails struct {

	// The POSIX group ID used for all file system operations using this access point.
	Gid *string

	// Secondary POSIX group IDs used for all file system operations using this access
	// point.
	SecondaryGids []string

	// The POSIX user ID used for all file system operations using this access point.
	Uid *string

	noSmithyDocumentSerde
}

// Provides information about the settings that Amazon EFS uses to create the root
// directory when a client connects to an access point.
type AwsEfsAccessPointRootDirectoryCreationInfoDetails struct {

	// Specifies the POSIX group ID to apply to the root directory.
	OwnerGid *string

	// Specifies the POSIX user ID to apply to the root directory.
	OwnerUid *string

	// Specifies the POSIX permissions to apply to the root directory, in the format
	// of an octal number representing the file's mode bits.
	Permissions *string

	noSmithyDocumentSerde
}

// Provides information about the directory on the Amazon EFS file system that the
// access point exposes as the root directory to NFS clients using the access
// point.
type AwsEfsAccessPointRootDirectoryDetails struct {

	// Specifies the POSIX IDs and permissions to apply to the access point's root
	// directory.
	CreationInfo *AwsEfsAccessPointRootDirectoryCreationInfoDetails

	// Specifies the path on the Amazon EFS file system to expose as the root
	// directory to NFS clients using the access point to access the EFS file system. A
	// path can have up to four subdirectories. If the specified path does not exist,
	// you are required to provide CreationInfo .
	Path *string

	noSmithyDocumentSerde
}

// Provides details about an Amazon EKS cluster.
type AwsEksClusterDetails struct {

	// The ARN of the cluster.
	Arn *string

	// The certificate authority data for the cluster.
	CertificateAuthorityData *string

	// The status of the cluster. Valid values are as follows:
	//
	//   - ACTIVE
	//
	//   - CREATING
	//
	//   - DELETING
	//
	//   - FAILED
	//
	//   - PENDING
	//
	//   - UPDATING
	ClusterStatus *string

	// The endpoint for the Amazon EKS API server.
	Endpoint *string

	// The logging configuration for the cluster.
	Logging *AwsEksClusterLoggingDetails

	// The name of the cluster.
	Name *string

	// The VPC configuration used by the cluster control plane.
	ResourcesVpcConfig *AwsEksClusterResourcesVpcConfigDetails

	// The ARN of the IAM role that provides permissions for the Amazon EKS control
	// plane to make calls to Amazon Web Services API operations on your behalf.
	RoleArn *string

	// The Amazon EKS server version for the cluster.
	Version *string

	noSmithyDocumentSerde
}

// Details for a cluster logging configuration.
type AwsEksClusterLoggingClusterLoggingDetails struct {

	// Whether the logging types that are listed in Types are enabled.
	Enabled *bool

	// A list of logging types. Valid values are as follows:
	//
	//   - api
	//
	//   - audit
	//
	//   - authenticator
	//
	//   - controllerManager
	//
	//   - scheduler
	Types []string

	noSmithyDocumentSerde
}

// The logging configuration for an Amazon EKS cluster.
type AwsEksClusterLoggingDetails struct {

	// Cluster logging configurations.
	ClusterLogging []AwsEksClusterLoggingClusterLoggingDetails

	noSmithyDocumentSerde
}

// Information about the VPC configuration used by the cluster control plane.
type AwsEksClusterResourcesVpcConfigDetails struct {

	//  Indicates whether the Amazon EKS public API server endpoint is turned on. If
	// the Amazon EKS public API server endpoint is turned off, your cluster's
	// Kubernetes API server can only receive requests that originate from within the
	// cluster VPC.
	EndpointPublicAccess *bool

	// The security groups that are associated with the cross-account elastic network
	// interfaces that are used to allow communication between your nodes and the
	// Amazon EKS control plane.
	SecurityGroupIds []string

	// The subnets that are associated with the cluster.
	SubnetIds []string

	noSmithyDocumentSerde
}

// Contains details about an Elastic Beanstalk environment.
type AwsElasticBeanstalkEnvironmentDetails struct {

	// The name of the application that is associated with the environment.
	ApplicationName *string

	// The URL to the CNAME for this environment.
	Cname *string

	// The creation date for this environment.
	DateCreated *string

	// The date when this environment was last modified.
	DateUpdated *string

	// A description of the environment.
	Description *string

	// For load-balanced, autoscaling environments, the URL to the load balancer. For
	// single-instance environments, the IP address of the instance.
	EndpointUrl *string

	// The ARN of the environment.
	EnvironmentArn *string

	// The identifier of the environment.
	EnvironmentId *string

	// Links to other environments in the same group.
	EnvironmentLinks []AwsElasticBeanstalkEnvironmentEnvironmentLink

	// The name of the environment.
	EnvironmentName *string

	// The configuration setting for the environment.
	OptionSettings []AwsElasticBeanstalkEnvironmentOptionSetting

	// The ARN of the platform version for the environment.
	PlatformArn *string

	// The name of the solution stack that is deployed with the environment.
	SolutionStackName *string

	// The current operational status of the environment. Valid values are as follows:
	//
	//   - Aborting
	//
	//   - Launching
	//
	//   - LinkingFrom
	//
	//   - LinkingTo
	//
	//   - Ready
	//
	//   - Terminated
	//
	//   - Terminating
	//
	//   - Updating
	Status *string

	// The tier of the environment.
	Tier *AwsElasticBeanstalkEnvironmentTier

	// The application version of the environment.
	VersionLabel *string

	noSmithyDocumentSerde
}

// Contains information about a link to another environment that is in the same
// group.
type AwsElasticBeanstalkEnvironmentEnvironmentLink struct {

	// The name of the linked environment.
	EnvironmentName *string

	// The name of the environment link.
	LinkName *string

	noSmithyDocumentSerde
}

// A configuration option setting for the environment.
type AwsElasticBeanstalkEnvironmentOptionSetting struct {

	// The type of resource that the configuration option is associated with.
	Namespace *string

	// The name of the option.
	OptionName *string

	// The name of the resource.
	ResourceName *string

	// The value of the configuration setting.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about the tier of the environment.
type AwsElasticBeanstalkEnvironmentTier struct {

	// The name of the environment tier. Valid values are WebServer or Worker .
	Name *string

	// The type of environment tier. Valid values are Standard or SQS/HTTP .
	Type *string

	// The version of the environment tier.
	Version *string

	noSmithyDocumentSerde
}

// Information about an Elasticsearch domain.
type AwsElasticsearchDomainDetails struct {

	// IAM policy document specifying the access policies for the new Elasticsearch
	// domain.
	AccessPolicies *string

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsElasticsearchDomainDomainEndpointOptions

	// Unique identifier for an Elasticsearch domain.
	DomainId *string

	// Name of an Elasticsearch domain.
	//
	// Domain names are unique across all domains owned by the same account within an
	// Amazon Web Services Region.
	//
	// Domain names must start with a lowercase letter and must be between 3 and 28
	// characters.
	//
	// Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
	DomainName *string

	// Information about an OpenSearch cluster configuration.
	ElasticsearchClusterConfig *AwsElasticsearchDomainElasticsearchClusterConfigDetails

	// OpenSearch version.
	ElasticsearchVersion *string

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsElasticsearchDomainEncryptionAtRestOptions

	// Domain-specific endpoint used to submit index, search, and data upload requests
	// to an Elasticsearch domain.
	//
	// The endpoint is a service URL.
	Endpoint *string

	// The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
	Endpoints map[string]string

	// Configures the CloudWatch Logs to publish for the Elasticsearch domain.
	LogPublishingOptions *AwsElasticsearchDomainLogPublishingOptions

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsElasticsearchDomainNodeToNodeEncryptionOptions

	// Information about the status of a domain relative to the latest service
	// software.
	ServiceSoftwareOptions *AwsElasticsearchDomainServiceSoftwareOptions

	// Information that OpenSearch derives based on VPCOptions for the domain.
	VPCOptions *AwsElasticsearchDomainVPCOptions

	noSmithyDocumentSerde
}

// Additional options for the domain endpoint, such as whether to require HTTPS
// for all traffic.
type AwsElasticsearchDomainDomainEndpointOptions struct {

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool

	// The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.
	//
	// Valid values:
	//
	//   - Policy-Min-TLS-1-0-2019-07 , which supports TLSv1.0 and higher
	//
	//   - Policy-Min-TLS-1-2-2019-07 , which only supports TLSv1.2
	TLSSecurityPolicy *string

	noSmithyDocumentSerde
}

// details about the configuration of an OpenSearch cluster.
type AwsElasticsearchDomainElasticsearchClusterConfigDetails struct {

	// The number of instances to use for the master node. If this attribute is
	// specified, then DedicatedMasterEnabled must be true .
	DedicatedMasterCount *int32

	// Whether to use a dedicated master node for the Elasticsearch domain. A
	// dedicated master node performs cluster management tasks, but doesn't hold data
	// or respond to data upload requests.
	DedicatedMasterEnabled *bool

	// The hardware configuration of the computer that hosts the dedicated master
	// node. A sample value is m3.medium.elasticsearch . If this attribute is
	// specified, then DedicatedMasterEnabled must be true .
	//
	// For a list of valid values, see [Supported instance types in Amazon OpenSearch Service] in the Amazon OpenSearch Service Developer
	// Guide.
	//
	// [Supported instance types in Amazon OpenSearch Service]: https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html
	DedicatedMasterType *string

	// The number of data nodes to use in the Elasticsearch domain.
	InstanceCount *int32

	// The instance type for your data nodes. For example, m3.medium.elasticsearch .
	//
	// For a list of valid values, see [Supported instance types in Amazon OpenSearch Service] in the Amazon OpenSearch Service Developer
	// Guide.
	//
	// [Supported instance types in Amazon OpenSearch Service]: https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html
	InstanceType *string

	// Configuration options for zone awareness. Provided if ZoneAwarenessEnabled is
	// true .
	ZoneAwarenessConfig *AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails

	// Whether to enable zone awareness for the Elasticsearch domain. When zone
	// awareness is enabled, OpenSearch allocates the cluster's nodes and replica index
	// shards across Availability Zones in the same Region. This prevents data loss and
	// minimizes downtime if a node or data center fails.
	ZoneAwarenessEnabled *bool

	noSmithyDocumentSerde
}

// Configuration options for zone awareness.
type AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails struct {

	// he number of Availability Zones that the domain uses. Valid values are 2 and 3.
	// The default is 2.
	AvailabilityZoneCount *int32

	noSmithyDocumentSerde
}

// Details about the configuration for encryption at rest.
type AwsElasticsearchDomainEncryptionAtRestOptions struct {

	// Whether encryption at rest is enabled.
	Enabled *bool

	// The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a .
	KmsKeyId *string

	noSmithyDocumentSerde
}

// configures the CloudWatch Logs to publish for the Elasticsearch domain.
type AwsElasticsearchDomainLogPublishingOptions struct {

	// The log configuration.
	AuditLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig

	// Configures the OpenSearch index logs publishing.
	IndexSlowLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig

	// Configures the OpenSearch search slow log publishing.
	SearchSlowLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig

	noSmithyDocumentSerde
}

// The log configuration.
type AwsElasticsearchDomainLogPublishingOptionsLogConfig struct {

	// The ARN of the CloudWatch Logs group to publish the logs to.
	CloudWatchLogsLogGroupArn *string

	// Whether the log publishing is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Details about the configuration for node-to-node encryption.
type AwsElasticsearchDomainNodeToNodeEncryptionOptions struct {

	// Whether node-to-node encryption is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Information about the state of the domain relative to the latest service
// software.
type AwsElasticsearchDomainServiceSoftwareOptions struct {

	// The epoch time when the deployment window closes for required updates. After
	// this time, Amazon OpenSearch Service schedules the software upgrade
	// automatically.
	AutomatedUpdateDate *string

	// Whether a request to update the domain can be canceled.
	Cancellable *bool

	// The version of the service software that is currently installed on the domain.
	CurrentVersion *string

	// A more detailed description of the service software status.
	Description *string

	// The most recent version of the service software.
	NewVersion *string

	// Whether a service software update is available for the domain.
	UpdateAvailable *bool

	// The status of the service software update. Valid values are as follows:
	//
	//   - COMPLETED
	//
	//   - ELIGIBLE
	//
	//   - IN_PROGRESS
	//
	//   - NOT_ELIGIBLE
	//
	//   - PENDING_UPDATE
	UpdateStatus *string

	noSmithyDocumentSerde
}

// Information that OpenSearch derives based on VPCOptions for the domain.
type AwsElasticsearchDomainVPCOptions struct {

	// The list of Availability Zones associated with the VPC subnets.
	AvailabilityZones []string

	// The list of security group IDs associated with the VPC endpoints for the domain.
	SecurityGroupIds []string

	// A list of subnet IDs associated with the VPC endpoints for the domain.
	SubnetIds []string

	// ID for the VPC.
	VPCId *string

	noSmithyDocumentSerde
}

// Contains information about a stickiness policy that was created using
// CreateAppCookieStickinessPolicy .
type AwsElbAppCookieStickinessPolicy struct {

	// The name of the application cookie used for stickiness.
	CookieName *string

	// The mnemonic name for the policy being created. The name must be unique within
	// the set of policies for the load balancer.
	PolicyName *string

	noSmithyDocumentSerde
}

// Contains information about a stickiness policy that was created using
// CreateLBCookieStickinessPolicy .
type AwsElbLbCookieStickinessPolicy struct {

	// The amount of time, in seconds, after which the cookie is considered stale. If
	// an expiration period is not specified, the stickiness session lasts for the
	// duration of the browser session.
	CookieExpirationPeriod *int64

	// The name of the policy. The name must be unique within the set of policies for
	// the load balancer.
	PolicyName *string

	noSmithyDocumentSerde
}

// Contains information about the access log configuration for the load balancer.
type AwsElbLoadBalancerAccessLog struct {

	// The interval in minutes for publishing the access logs.
	//
	// You can publish access logs either every 5 minutes or every 60 minutes.
	EmitInterval *int32

	// Indicates whether access logs are enabled for the load balancer.
	Enabled *bool

	// The name of the S3 bucket where the access logs are stored.
	S3BucketName *string

	// The logical hierarchy that was created for the S3 bucket.
	//
	// If a prefix is not provided, the log is placed at the root level of the bucket.
	S3BucketPrefix *string

	noSmithyDocumentSerde
}

// Provides information about additional attributes for the load balancer.
type AwsElbLoadBalancerAdditionalAttribute struct {

	// The name of the attribute.
	Key *string

	// The value of the attribute.
	Value *string

	noSmithyDocumentSerde
}

// Contains attributes for the load balancer.
type AwsElbLoadBalancerAttributes struct {

	// Information about the access log configuration for the load balancer.
	//
	// If the access log is enabled, the load balancer captures detailed information
	// about all requests. It delivers the information to a specified S3 bucket.
	AccessLog *AwsElbLoadBalancerAccessLog

	// Any additional attributes for a load balancer.
	AdditionalAttributes []AwsElbLoadBalancerAdditionalAttribute

	// Information about the connection draining configuration for the load balancer.
	//
	// If connection draining is enabled, the load balancer allows existing requests
	// to complete before it shifts traffic away from a deregistered or unhealthy
	// instance.
	ConnectionDraining *AwsElbLoadBalancerConnectionDraining

	// Connection settings for the load balancer.
	//
	// If an idle timeout is configured, the load balancer allows connections to
	// remain idle for the specified duration. When a connection is idle, no data is
	// sent over the connection.
	ConnectionSettings *AwsElbLoadBalancerConnectionSettings

	// Cross-zone load balancing settings for the load balancer.
	//
	// If cross-zone load balancing is enabled, the load balancer routes the request
	// traffic evenly across all instances regardless of the Availability Zones.
	CrossZoneLoadBalancing *AwsElbLoadBalancerCrossZoneLoadBalancing

	noSmithyDocumentSerde
}

// Provides information about the configuration of an EC2 instance for the load
// balancer.
type AwsElbLoadBalancerBackendServerDescription struct {

	// The port on which the EC2 instance is listening.
	InstancePort *int32

	// The names of the policies that are enabled for the EC2 instance.
	PolicyNames []string

	noSmithyDocumentSerde
}

// Contains information about the connection draining configuration for the load
// balancer.
type AwsElbLoadBalancerConnectionDraining struct {

	// Indicates whether connection draining is enabled for the load balancer.
	Enabled *bool

	// The maximum time, in seconds, to keep the existing connections open before
	// deregistering the instances.
	Timeout *int32

	noSmithyDocumentSerde
}

// Contains connection settings for the load balancer.
type AwsElbLoadBalancerConnectionSettings struct {

	// The time, in seconds, that the connection can be idle (no data is sent over the
	// connection) before it is closed by the load balancer.
	IdleTimeout *int32

	noSmithyDocumentSerde
}

// Contains cross-zone load balancing settings for the load balancer.
type AwsElbLoadBalancerCrossZoneLoadBalancing struct {

	// Indicates whether cross-zone load balancing is enabled for the load balancer.
	Enabled *bool

	noSmithyDocumentSerde
}

// Contains details about a Classic Load Balancer.
type AwsElbLoadBalancerDetails struct {

	// The list of Availability Zones for the load balancer.
	AvailabilityZones []string

	// Information about the configuration of the EC2 instances.
	BackendServerDescriptions []AwsElbLoadBalancerBackendServerDescription

	// The name of the Amazon Route 53 hosted zone for the load balancer.
	CanonicalHostedZoneName *string

	// The ID of the Amazon Route 53 hosted zone for the load balancer.
	CanonicalHostedZoneNameID *string

	// Indicates when the load balancer was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedTime *string

	// The DNS name of the load balancer.
	DnsName *string

	// Information about the health checks that are conducted on the load balancer.
	HealthCheck *AwsElbLoadBalancerHealthCheck

	// List of EC2 instances for the load balancer.
	Instances []AwsElbLoadBalancerInstance

	// The policies that are enabled for the load balancer listeners.
	ListenerDescriptions []AwsElbLoadBalancerListenerDescription

	// The attributes for a load balancer.
	LoadBalancerAttributes *AwsElbLoadBalancerAttributes

	// The name of the load balancer.
	LoadBalancerName *string

	// The policies for a load balancer.
	Policies *AwsElbLoadBalancerPolicies

	// The type of load balancer. Only provided if the load balancer is in a VPC.
	//
	// If Scheme is internet-facing , the load balancer has a public DNS name that
	// resolves to a public IP address.
	//
	// If Scheme is internal , the load balancer has a public DNS name that resolves to
	// a private IP address.
	Scheme *string

	// The security groups for the load balancer. Only provided if the load balancer
	// is in a VPC.
	SecurityGroups []string

	// Information about the security group for the load balancer. This is the
	// security group that is used for inbound rules.
	SourceSecurityGroup *AwsElbLoadBalancerSourceSecurityGroup

	// The list of subnet identifiers for the load balancer.
	Subnets []string

	// The identifier of the VPC for the load balancer.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the health checks that are conducted on the load
// balancer.
type AwsElbLoadBalancerHealthCheck struct {

	// The number of consecutive health check successes required before the instance
	// is moved to the Healthy state.
	HealthyThreshold *int32

	// The approximate interval, in seconds, between health checks of an individual
	// instance.
	Interval *int32

	// The instance that is being checked. The target specifies the protocol and port.
	// The available protocols are TCP, SSL, HTTP, and HTTPS. The range of valid ports
	// is 1 through 65535.
	//
	// For the HTTP and HTTPS protocols, the target also specifies the ping path.
	//
	// For the TCP protocol, the target is specified as TCP: .
	//
	// For the SSL protocol, the target is specified as SSL. .
	//
	// For the HTTP and HTTPS protocols, the target is specified as  :/ .
	Target *string

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	Timeout *int32

	// The number of consecutive health check failures that must occur before the
	// instance is moved to the Unhealthy state.
	UnhealthyThreshold *int32

	noSmithyDocumentSerde
}

// Provides information about an EC2 instance for a load balancer.
type AwsElbLoadBalancerInstance struct {

	// The instance identifier.
	InstanceId *string

	noSmithyDocumentSerde
}

// Information about a load balancer listener.
type AwsElbLoadBalancerListener struct {

	// The port on which the instance is listening.
	InstancePort *int32

	// The protocol to use to route traffic to instances.
	//
	// Valid values: HTTP | HTTPS | TCP | SSL
	InstanceProtocol *string

	// The port on which the load balancer is listening.
	//
	// On EC2-VPC, you can specify any port from the range 1-65535.
	//
	// On EC2-Classic, you can specify any port from the following list: 25, 80, 443,
	// 465, 587, 1024-65535.
	LoadBalancerPort *int32

	// The load balancer transport protocol to use for routing.
	//
	// Valid values: HTTP | HTTPS | TCP | SSL
	Protocol *string

	// The ARN of the server certificate.
	SslCertificateId *string

	noSmithyDocumentSerde
}

// Lists the policies that are enabled for a load balancer listener.
type AwsElbLoadBalancerListenerDescription struct {

	// Information about the listener.
	Listener *AwsElbLoadBalancerListener

	// The policies enabled for the listener.
	PolicyNames []string

	noSmithyDocumentSerde
}

// Contains information about the policies for a load balancer.
type AwsElbLoadBalancerPolicies struct {

	// The stickiness policies that are created using CreateAppCookieStickinessPolicy .
	AppCookieStickinessPolicies []AwsElbAppCookieStickinessPolicy

	// The stickiness policies that are created using CreateLBCookieStickinessPolicy .
	LbCookieStickinessPolicies []AwsElbLbCookieStickinessPolicy

	// The policies other than the stickiness policies.
	OtherPolicies []string

	noSmithyDocumentSerde
}

// Contains information about the security group for the load balancer.
type AwsElbLoadBalancerSourceSecurityGroup struct {

	// The name of the security group.
	GroupName *string

	// The owner of the security group.
	OwnerAlias *string

	noSmithyDocumentSerde
}

// A load balancer attribute.
type AwsElbv2LoadBalancerAttribute struct {

	// The name of the load balancer attribute.
	Key *string

	// The value of the load balancer attribute.
	Value *string

	noSmithyDocumentSerde
}

// Information about a load balancer.
type AwsElbv2LoadBalancerDetails struct {

	// The Availability Zones for the load balancer.
	AvailabilityZones []AvailabilityZone

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string

	// Indicates when the load balancer was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedTime *string

	// The public DNS name of the load balancer.
	DNSName *string

	// The type of IP addresses used by the subnets for your load balancer. The
	// possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and IPv6
	// addresses).
	IpAddressType *string

	// Attributes of the load balancer.
	LoadBalancerAttributes []AwsElbv2LoadBalancerAttribute

	// The nodes of an Internet-facing load balancer have public IP addresses.
	Scheme *string

	// The IDs of the security groups for the load balancer.
	SecurityGroups []string

	// The state of the load balancer.
	State *LoadBalancerState

	// The type of load balancer.
	Type *string

	// The ID of the VPC for the load balancer.
	VpcId *string

	noSmithyDocumentSerde
}

//	A schema defines the structure of events that are sent to Amazon EventBridge.
//
// Schema registries are containers for schemas. They collect and organize schemas
// so that your schemas are in logical groups.
type AwsEventSchemasRegistryDetails struct {

	//  A description of the registry to be created.
	Description *string

	//  The Amazon Resource Name (ARN) of the registry.
	RegistryArn *string

	//  The name of the schema registry.
	RegistryName *string

	noSmithyDocumentSerde
}

//	Provides details about an Amazon EventBridge global endpoint. The endpoint can
//
// improve your application’s availability by making it Regional-fault tolerant.
type AwsEventsEndpointDetails struct {

	//  The Amazon Resource Name (ARN) of the endpoint.
	Arn *string

	//  A description of the endpoint.
	Description *string

	//  The URL subdomain of the endpoint. For example, if EndpointUrl is
	// https://abcde.veo.endpoints.event.amazonaws.com , then the EndpointId is
	// abcde.veo .
	EndpointId *string

	//  The URL of the endpoint.
	EndpointUrl *string

	//  The event buses being used by the endpoint.
	EventBuses []AwsEventsEndpointEventBusesDetails

	//  The name of the endpoint.
	Name *string

	//  Whether event replication was enabled or disabled for this endpoint. The
	// default state is ENABLED , which means you must supply a RoleArn . If you don't
	// have a RoleArn or you don't want event replication enabled, set the state to
	// DISABLED .
	ReplicationConfig *AwsEventsEndpointReplicationConfigDetails

	//  The ARN of the role used by event replication for the endpoint.
	RoleArn *string

	//  The routing configuration of the endpoint.
	RoutingConfig *AwsEventsEndpointRoutingConfigDetails

	//  The current state of the endpoint.
	State *string

	//  The reason the endpoint is in its current state.
	StateReason *string

	noSmithyDocumentSerde
}

//	Provides details about the Amazon EventBridge event buses that the endpoint is
//
// associated with.
type AwsEventsEndpointEventBusesDetails struct {

	//  The Amazon Resource Name (ARN) of the event bus that the endpoint is
	// associated with.
	EventBusArn *string

	noSmithyDocumentSerde
}

//	Indicates whether replication is enabled or disabled for the endpoint. If
//
// enabled, the endpoint can replicate all events to a secondary Amazon Web
// Services Region.
type AwsEventsEndpointReplicationConfigDetails struct {

	//  The state of event replication.
	State *string

	noSmithyDocumentSerde
}

// Provides details about the routing configuration of the endpoint.
type AwsEventsEndpointRoutingConfigDetails struct {

	//  The failover configuration for an endpoint. This includes what triggers
	// failover and what happens when it's triggered.
	FailoverConfig *AwsEventsEndpointRoutingConfigFailoverConfigDetails

	noSmithyDocumentSerde
}

//	The failover configuration for an endpoint. This includes what triggers
//
// failover and what happens when it's triggered.
type AwsEventsEndpointRoutingConfigFailoverConfigDetails struct {

	//  The main Region of the endpoint.
	Primary *AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails

	//  The Region that events are routed to when failover is triggered or event
	// replication is enabled.
	Secondary *AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails

	noSmithyDocumentSerde
}

// Provides details about the primary Amazon Web Services Region of the endpoint.
type AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails struct {

	//  The Amazon Resource Name (ARN) of the health check used by the endpoint to
	// determine whether failover is triggered.
	HealthCheck *string

	noSmithyDocumentSerde
}

//	The Amazon Web Services Region that events are routed to when failover is
//
// triggered or event replication is enabled.
type AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails struct {

	//  Defines the secondary Region.
	Route *string

	noSmithyDocumentSerde
}

//	Provides details about Amazon EventBridge event bus. An event bus is a router
//
// that receives events and delivers them to zero or more destinations, or targets.
// This can be a custom event bus which you can use to receive events from your
// custom applications and services, or it can be a partner event bus which can be
// matched to a partner event source.
type AwsEventsEventbusDetails struct {

	//  The Amazon Resource Name (ARN) of the account permitted to write events to the
	// current account.
	Arn *string

	//  The name of the event bus.
	Name *string

	//  The policy that enables the external account to send events to your account.
	Policy *string

	noSmithyDocumentSerde
}

//	An object that contains information on the status of CloudTrail as a data
//
// source for the detector.
type AwsGuardDutyDetectorDataSourcesCloudTrailDetails struct {

	//  Specifies whether CloudTrail is activated as a data source for the detector.
	Status *string

	noSmithyDocumentSerde
}

// Describes which data sources are activated for the detector.
type AwsGuardDutyDetectorDataSourcesDetails struct {

	//  An object that contains information on the status of CloudTrail as a data
	// source for the detector.
	CloudTrail *AwsGuardDutyDetectorDataSourcesCloudTrailDetails

	//  An object that contains information on the status of DNS logs as a data source
	// for the detector.
	DnsLogs *AwsGuardDutyDetectorDataSourcesDnsLogsDetails

	//  An object that contains information on the status of VPC Flow Logs as a data
	// source for the detector.
	FlowLogs *AwsGuardDutyDetectorDataSourcesFlowLogsDetails

	//  An object that contains information on the status of Kubernetes data sources
	// for the detector.
	Kubernetes *AwsGuardDutyDetectorDataSourcesKubernetesDetails

	//  An object that contains information on the status of Malware Protection as a
	// data source for the detector.
	MalwareProtection *AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails

	//  An object that contains information on the status of S3 Data event logs as a
	// data source for the detector.
	S3Logs *AwsGuardDutyDetectorDataSourcesS3LogsDetails

	noSmithyDocumentSerde
}

//	An object that contains information on the status of DNS logs as a data source
//
// for the detector.
type AwsGuardDutyDetectorDataSourcesDnsLogsDetails struct {

	//  Describes whether DNS logs is enabled as a data source for the detector.
	Status *string

	noSmithyDocumentSerde
}

//	An object that contains information on the status of VPC Flow Logs as a data
//
// source for the detector.
type AwsGuardDutyDetectorDataSourcesFlowLogsDetails struct {

	//  Describes whether VPC Flow Logs are activated as a data source for the
	// detector.
	Status *string

	noSmithyDocumentSerde
}

//	An object that contains information on the status of Kubernetes audit logs as
//
// a data source for the detector.
type AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails struct {

	//  Describes whether Kubernetes audit logs are activated as a data source for the
	// detector.
	Status *string

	noSmithyDocumentSerde
}

//	An object that contains information on the status of Kubernetes data sources
//
// for the detector.
type AwsGuardDutyDetectorDataSourcesKubernetesDetails struct {

	//  Describes whether Kubernetes audit logs are activated as a data source for the
	// detector.
	AuditLogs *AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails

	noSmithyDocumentSerde
}

//	An object that contains information on the status of Malware Protection as a
//
// data source for the detector.
type AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails struct {

	//  Describes the configuration of Malware Protection for EC2 instances with
	// findings.
	ScanEc2InstanceWithFindings *AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails

	//  The GuardDuty Malware Protection service role.
	ServiceRole *string

	noSmithyDocumentSerde
}

//	Describes the configuration of Malware Protection for EC2 instances with
//
// findings.
type AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails struct {

	//  Describes the configuration of scanning EBS volumes (Malware Protection) as a
	// data source.
	EbsVolumes *AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails

	noSmithyDocumentSerde
}

//	Describes the configuration of scanning EBS volumes (Malware Protection) as a
//
// data source.
type AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails struct {

	//  Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
	// activated as a data source.
	Reason *string

	//  Describes whether scanning EBS volumes is activated as a data source for the
	// detector.
	Status *string

	noSmithyDocumentSerde
}

//	An object that contains information on the status of S3 data event logs as a
//
// data source for the detector.
type AwsGuardDutyDetectorDataSourcesS3LogsDetails struct {

	//  A value that describes whether S3 data event logs are automatically enabled
	// for new members of an organization.
	Status *string

	noSmithyDocumentSerde
}

//	Provides details about an Amazon GuardDuty detector. A detector is an object
//
// that represents the GuardDuty service. A detector is required for GuardDuty to
// become operational.
type AwsGuardDutyDetectorDetails struct {

	//  Describes which data sources are activated for the detector.
	DataSources *AwsGuardDutyDetectorDataSourcesDetails

	//  Describes which features are activated for the detector.
	Features []AwsGuardDutyDetectorFeaturesDetails

	//  The publishing frequency of the finding.
	FindingPublishingFrequency *string

	//  The GuardDuty service role.
	ServiceRole *string

	//  The activation status of the detector.
	Status *string

	noSmithyDocumentSerde
}

// Describes which features are activated for the detector.
type AwsGuardDutyDetectorFeaturesDetails struct {

	//  Indicates the name of the feature that is activated for the detector.
	Name *string

	//  Indicates the status of the feature that is activated for the detector.
	Status *string

	noSmithyDocumentSerde
}

// IAM access key details related to a finding.
type AwsIamAccessKeyDetails struct {

	// The identifier of the access key.
	AccessKeyId *string

	// The Amazon Web Services account ID of the account for the key.
	AccountId *string

	// Indicates when the IAM access key was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedAt *string

	// The ID of the principal associated with an access key.
	PrincipalId *string

	// The name of the principal.
	PrincipalName *string

	// The type of principal associated with an access key.
	PrincipalType *string

	// Information about the session that the key was used for.
	SessionContext *AwsIamAccessKeySessionContext

	// The status of the IAM access key related to a finding.
	Status AwsIamAccessKeyStatus

	// The user associated with the IAM access key related to a finding.
	//
	// The UserName parameter has been replaced with the PrincipalName parameter
	// because access keys can also be assigned to principals that are not IAM users.
	//
	// Deprecated: This filter is deprecated. Instead, use PrincipalName.
	UserName *string

	noSmithyDocumentSerde
}

// Provides information about the session that the key was used for.
type AwsIamAccessKeySessionContext struct {

	// Attributes of the session that the key was used for.
	Attributes *AwsIamAccessKeySessionContextAttributes

	// Information about the entity that created the session.
	SessionIssuer *AwsIamAccessKeySessionContextSessionIssuer

	noSmithyDocumentSerde
}

// Attributes of the session that the key was used for.
type AwsIamAccessKeySessionContextAttributes struct {

	// Indicates when the session was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreationDate *string

	// Indicates whether the session used multi-factor authentication (MFA).
	MfaAuthenticated *bool

	noSmithyDocumentSerde
}

// Information about the entity that created the session.
type AwsIamAccessKeySessionContextSessionIssuer struct {

	// The identifier of the Amazon Web Services account that created the session.
	AccountId *string

	// The ARN of the session.
	Arn *string

	// The principal ID of the principal (user, role, or group) that created the
	// session.
	PrincipalId *string

	// The type of principal (user, role, or group) that created the session.
	Type *string

	// The name of the principal that created the session.
	UserName *string

	noSmithyDocumentSerde
}

// A managed policy that is attached to an IAM principal.
type AwsIamAttachedManagedPolicy struct {

	// The ARN of the policy.
	PolicyArn *string

	// The name of the policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Contains details about an IAM group.
type AwsIamGroupDetails struct {

	// A list of the managed policies that are attached to the IAM group.
	AttachedManagedPolicies []AwsIamAttachedManagedPolicy

	// Indicates when the IAM group was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreateDate *string

	// The identifier of the IAM group.
	GroupId *string

	// The name of the IAM group.
	GroupName *string

	// The list of inline policies that are embedded in the group.
	GroupPolicyList []AwsIamGroupPolicy

	// The path to the group.
	Path *string

	noSmithyDocumentSerde
}

// A managed policy that is attached to the IAM group.
type AwsIamGroupPolicy struct {

	// The name of the policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Information about an instance profile.
type AwsIamInstanceProfile struct {

	// The ARN of the instance profile.
	Arn *string

	// Indicates when the instance profile was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreateDate *string

	// The identifier of the instance profile.
	InstanceProfileId *string

	// The name of the instance profile.
	InstanceProfileName *string

	// The path to the instance profile.
	Path *string

	// The roles associated with the instance profile.
	Roles []AwsIamInstanceProfileRole

	noSmithyDocumentSerde
}

// Information about a role associated with an instance profile.
type AwsIamInstanceProfileRole struct {

	// The ARN of the role.
	Arn *string

	// The policy that grants an entity permission to assume the role.
	AssumeRolePolicyDocument *string

	// Indicates when the role was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreateDate *string

	// The path to the role.
	Path *string

	// The identifier of the role.
	RoleId *string

	// The name of the role.
	RoleName *string

	noSmithyDocumentSerde
}

// Information about the policy used to set the permissions boundary for an IAM
// principal.
type AwsIamPermissionsBoundary struct {

	// The ARN of the policy used to set the permissions boundary.
	PermissionsBoundaryArn *string

	// The usage type for the permissions boundary.
	PermissionsBoundaryType *string

	noSmithyDocumentSerde
}

// Represents an IAM permissions policy.
type AwsIamPolicyDetails struct {

	// The number of users, groups, and roles that the policy is attached to.
	AttachmentCount *int32

	// When the policy was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreateDate *string

	// The identifier of the default version of the policy.
	DefaultVersionId *string

	// A description of the policy.
	Description *string

	// Whether the policy can be attached to a user, group, or role.
	IsAttachable *bool

	// The path to the policy.
	Path *string

	// The number of users and roles that use the policy to set the permissions
	// boundary.
	PermissionsBoundaryUsageCount *int32

	// The unique identifier of the policy.
	PolicyId *string

	// The name of the policy.
	PolicyName *string

	// List of versions of the policy.
	PolicyVersionList []AwsIamPolicyVersion

	// When the policy was most recently updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	UpdateDate *string

	noSmithyDocumentSerde
}

// A version of an IAM policy.
type AwsIamPolicyVersion struct {

	// Indicates when the version was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreateDate *string

	// Whether the version is the default version.
	IsDefaultVersion *bool

	// The identifier of the policy version.
	VersionId *string

	noSmithyDocumentSerde
}

// Contains information about an IAM role, including all of the role's policies.
type AwsIamRoleDetails struct {

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string

	// The list of the managed policies that are attached to the role.
	AttachedManagedPolicies []AwsIamAttachedManagedPolicy

	// Indicates when the role was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreateDate *string

	// The list of instance profiles that contain this role.
	InstanceProfileList []AwsIamInstanceProfile

	// The maximum session duration (in seconds) that you want to set for the
	// specified role.
	MaxSessionDuration *int32

	// The path to the role.
	Path *string

	// Information about the policy used to set the permissions boundary for an IAM
	// principal.
	PermissionsBoundary *AwsIamPermissionsBoundary

	// The stable and unique string identifying the role.
	RoleId *string

	// The friendly name that identifies the role.
	RoleName *string

	// The list of inline policies that are embedded in the role.
	RolePolicyList []AwsIamRolePolicy

	noSmithyDocumentSerde
}

// An inline policy that is embedded in the role.
type AwsIamRolePolicy struct {

	// The name of the policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Information about an IAM user.
type AwsIamUserDetails struct {

	// A list of the managed policies that are attached to the user.
	AttachedManagedPolicies []AwsIamAttachedManagedPolicy

	// Indicates when the user was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreateDate *string

	// A list of IAM groups that the user belongs to.
	GroupList []string

	// The path to the user.
	Path *string

	// The permissions boundary for the user.
	PermissionsBoundary *AwsIamPermissionsBoundary

	// The unique identifier for the user.
	UserId *string

	// The name of the user.
	UserName *string

	// The list of inline policies that are embedded in the user.
	UserPolicyList []AwsIamUserPolicy

	noSmithyDocumentSerde
}

// Information about an inline policy that is embedded in the user.
type AwsIamUserPolicy struct {

	// The name of the policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon Kinesis data stream.
type AwsKinesisStreamDetails struct {

	// The Amazon Resource Name (ARN) of the Kinesis data stream.
	Arn *string

	// The name of the Kinesis stream. If you don't specify a name, CloudFront
	// generates a unique physical ID and uses that ID for the stream name.
	Name *string

	// The number of hours for the data records that are stored in shards to remain
	// accessible.
	RetentionPeriodHours *int32

	// The number of shards that the stream uses.
	ShardCount *int32

	// When specified, enables or updates server-side encryption using an KMS key for
	// a specified stream. Removing this property from your stack template and updating
	// your stack disables encryption.
	StreamEncryption *AwsKinesisStreamStreamEncryptionDetails

	noSmithyDocumentSerde
}

// Provides information about stream encryption.
type AwsKinesisStreamStreamEncryptionDetails struct {

	// The encryption type to use.
	EncryptionType *string

	// The globally unique identifier for the customer-managed KMS key to use for
	// encryption.
	KeyId *string

	noSmithyDocumentSerde
}

// Contains metadata about an KMS key.
type AwsKmsKeyDetails struct {

	// The twelve-digit account ID of the Amazon Web Services account that owns the
	// KMS key.
	AWSAccountId *string

	// Indicates when the KMS key was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreationDate *float64

	// A description of the KMS key.
	Description *string

	// The globally unique identifier for the KMS key.
	KeyId *string

	// The manager of the KMS key. KMS keys in your Amazon Web Services account are
	// either customer managed or Amazon Web Services managed.
	KeyManager *string

	// Whether the key has key rotation enabled.
	KeyRotationStatus *bool

	// The state of the KMS key. Valid values are as follows:
	//
	//   - Disabled
	//
	//   - Enabled
	//
	//   - PendingDeletion
	//
	//   - PendingImport
	//
	//   - Unavailable
	KeyState *string

	// The source of the KMS key material.
	//
	// When this value is AWS_KMS , KMS created the key material.
	//
	// When this value is EXTERNAL , the key material was imported from your existing
	// key management infrastructure or the KMS key lacks key material.
	//
	// When this value is AWS_CLOUDHSM , the key material was created in the CloudHSM
	// cluster associated with a custom key store.
	Origin *string

	noSmithyDocumentSerde
}

// The code for the Lambda function. You can specify either an object in Amazon
// S3, or upload a deployment package directly.
type AwsLambdaFunctionCode struct {

	// An Amazon S3 bucket in the same Amazon Web Services Region as your function.
	// The bucket can be in a different Amazon Web Services account.
	S3Bucket *string

	// The Amazon S3 key of the deployment package.
	S3Key *string

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string

	// The base64-encoded contents of the deployment package. Amazon Web Services SDK
	// and Amazon Web Services CLI clients handle the encoding for you.
	ZipFile *string

	noSmithyDocumentSerde
}

// The dead-letter queue for failed asynchronous invocations.
type AwsLambdaFunctionDeadLetterConfig struct {

	// The ARN of an SQS queue or SNS topic.
	TargetArn *string

	noSmithyDocumentSerde
}

// Details about an Lambda function's configuration.
type AwsLambdaFunctionDetails struct {

	// The instruction set architecture that the function uses. Valid values are x86_64
	// or arm64 .
	Architectures []string

	// An AwsLambdaFunctionCode object.
	Code *AwsLambdaFunctionCode

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string

	// The function's dead letter queue.
	DeadLetterConfig *AwsLambdaFunctionDeadLetterConfig

	// The function's environment variables.
	Environment *AwsLambdaFunctionEnvironment

	// The name of the function.
	FunctionName *string

	// The function that Lambda calls to begin executing your function.
	Handler *string

	// The KMS key that is used to encrypt the function's environment variables. This
	// key is only returned if you've configured a customer managed customer managed
	// key.
	KmsKeyArn *string

	// Indicates when the function was last updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastModified *string

	// The function's layers.
	Layers []AwsLambdaFunctionLayer

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string

	// The memory that is allocated to the function.
	MemorySize *int32

	// The type of deployment package that's used to deploy the function code to
	// Lambda. Set to Image for a container image and Zip for a .zip file archive.
	PackageType *string

	// The latest updated revision of the function or alias.
	RevisionId *string

	// The function's execution role.
	Role *string

	// The runtime environment for the Lambda function.
	Runtime *string

	// The amount of time that Lambda allows a function to run before stopping it.
	Timeout *int32

	// The function's X-Ray tracing configuration.
	TracingConfig *AwsLambdaFunctionTracingConfig

	// The version of the Lambda function.
	Version *string

	// The function's networking configuration.
	VpcConfig *AwsLambdaFunctionVpcConfig

	noSmithyDocumentSerde
}

// A function's environment variable settings.
type AwsLambdaFunctionEnvironment struct {

	// An AwsLambdaFunctionEnvironmentError object.
	Error *AwsLambdaFunctionEnvironmentError

	// Environment variable key-value pairs.
	Variables map[string]string

	noSmithyDocumentSerde
}

// Error messages for environment variables that could not be applied.
type AwsLambdaFunctionEnvironmentError struct {

	// The error code.
	ErrorCode *string

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// An Lambda layer.
type AwsLambdaFunctionLayer struct {

	// The ARN of the function layer.
	Arn *string

	// The size of the layer archive in bytes.
	CodeSize *int32

	noSmithyDocumentSerde
}

// The function's X-Ray tracing configuration.
type AwsLambdaFunctionTracingConfig struct {

	// The tracing mode.
	Mode *string

	noSmithyDocumentSerde
}

// The VPC security groups and subnets that are attached to a Lambda function.
type AwsLambdaFunctionVpcConfig struct {

	// A list of VPC security groups IDs.
	SecurityGroupIds []string

	// A list of VPC subnet IDs.
	SubnetIds []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Details about a Lambda layer version.
type AwsLambdaLayerVersionDetails struct {

	// The layer's compatible [function runtimes].
	//
	// The following list includes deprecated runtimes. For more information, see [Runtime deprecation policy] in
	// the Lambda Developer Guide.
	//
	// Array Members: Maximum number of 5 items.
	//
	// Valid Values: nodejs | nodejs4.3 | nodejs6.10 | nodejs8.10 | nodejs10.x |
	// nodejs12.x | nodejs14.x | nodejs16.x | java8 | java8.al2 | java11 | python2.7 |
	// python3.6 | python3.7 | python3.8 | python3.9 | dotnetcore1.0 | dotnetcore2.0 |
	// dotnetcore2.1 | dotnetcore3.1 | dotnet6 | nodejs4.3-edge | go1.x | ruby2.5 |
	// ruby2.7 | provided | provided.al2 | nodejs18.x | python3.10 | java17 | ruby3.2 |
	// python3.11 | nodejs20.x | provided.al2023 | python3.12 | java21
	//
	// [function runtimes]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html
	// [Runtime deprecation policy]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy
	CompatibleRuntimes []string

	// Indicates when the version was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedDate *string

	// The version number.
	Version *int64

	noSmithyDocumentSerde
}

// Details for a volume mount point that's used in a container definition.
type AwsMountPoint struct {

	// The path on the container to mount the host volume at.
	ContainerPath *string

	// The name of the volume to mount. Must be a volume name referenced in the name
	// parameter of task definition volume .
	SourceVolume *string

	noSmithyDocumentSerde
}

// Provides details about different modes of client authentication.
type AwsMskClusterClusterInfoClientAuthenticationDetails struct {

	//  Provides details for client authentication using SASL.
	Sasl *AwsMskClusterClusterInfoClientAuthenticationSaslDetails

	//  Provides details for client authentication using TLS.
	Tls *AwsMskClusterClusterInfoClientAuthenticationTlsDetails

	//  Provides details for allowing no client authentication.
	Unauthenticated *AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails

	noSmithyDocumentSerde
}

// Provides details for client authentication using SASL.
type AwsMskClusterClusterInfoClientAuthenticationSaslDetails struct {

	//  Provides details for SASL client authentication using IAM.
	Iam *AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails

	//  Details for SASL client authentication using SCRAM.
	Scram *AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails

	noSmithyDocumentSerde
}

// Details for SASL/IAM client authentication.
type AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails struct {

	//  Indicates whether SASL/IAM authentication is enabled or not.
	Enabled *bool

	noSmithyDocumentSerde
}

// Details for SASL/SCRAM client authentication.
type AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails struct {

	//  Indicates whether SASL/SCRAM authentication is enabled or not.
	Enabled *bool

	noSmithyDocumentSerde
}

// Provides details for client authentication using TLS.
type AwsMskClusterClusterInfoClientAuthenticationTlsDetails struct {

	//  List of Amazon Web Services Private CA Amazon Resource Names (ARNs). Amazon
	// Web Services Private CA enables creation of private certificate authority (CA)
	// hierarchies, including root and subordinate CAs, without the investment and
	// maintenance costs of operating an on-premises CA.
	CertificateAuthorityArnList []string

	//  Indicates whether TLS authentication is enabled or not.
	Enabled *bool

	noSmithyDocumentSerde
}

// Provides details for allowing no client authentication.
type AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails struct {

	//  Indicates whether unauthenticated is allowed or not.
	Enabled *bool

	noSmithyDocumentSerde
}

//	Provide details about an Amazon Managed Streaming for Apache Kafka (Amazon
//
// MSK) cluster.
type AwsMskClusterClusterInfoDetails struct {

	//  Provides information for different modes of client authentication.
	ClientAuthentication *AwsMskClusterClusterInfoClientAuthenticationDetails

	//  The name of the cluster.
	ClusterName *string

	//  The current version of the cluster.
	CurrentVersion *string

	//  Includes encryption-related information, such as the KMS key used for
	// encrypting data at rest and whether you want Amazon MSK to encrypt your data in
	// transit.
	EncryptionInfo *AwsMskClusterClusterInfoEncryptionInfoDetails

	//  Specifies the level of monitoring for the cluster.
	EnhancedMonitoring *string

	//  The number of broker nodes in the cluster.
	NumberOfBrokerNodes *int32

	noSmithyDocumentSerde
}

//	Includes encryption-related information, such as the KMS key used for
//
// encrypting data at rest and whether you want MSK to encrypt your data in
// transit.
type AwsMskClusterClusterInfoEncryptionInfoDetails struct {

	//  The data-volume encryption details. You can't update encryption at rest
	// settings for existing clusters.
	EncryptionAtRest *AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails

	//  The settings for encrypting data in transit.
	EncryptionInTransit *AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails

	noSmithyDocumentSerde
}

//	The data-volume encryption details. You can't update encryption at rest
//
// settings for existing clusters.
type AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails struct {

	//  The Amazon Resource Name (ARN) of the KMS key for encrypting data at rest. If
	// you don't specify a KMS key, MSK creates one for you and uses it.
	DataVolumeKMSKeyId *string

	noSmithyDocumentSerde
}

// The settings for encrypting data in transit.
type AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails struct {

	//  Indicates the encryption setting for data in transit between clients and
	// brokers.
	ClientBroker *string

	//  When set to true , it indicates that data communication among the broker nodes
	// of the cluster is encrypted. When set to false , the communication happens in
	// plain text. The default value is true .
	InCluster *bool

	noSmithyDocumentSerde
}

//	Provides details about an Amazon Managed Streaming for Apache Kafka (Amazon
//
// MSK) cluster.
type AwsMskClusterDetails struct {

	//  Provides information about a cluster.
	ClusterInfo *AwsMskClusterClusterInfoDetails

	noSmithyDocumentSerde
}

// Details about an Network Firewall firewall.
type AwsNetworkFirewallFirewallDetails struct {

	// Whether the firewall is protected from deletion. If set to true , then the
	// firewall cannot be deleted.
	DeleteProtection *bool

	// A description of the firewall.
	Description *string

	// The ARN of the firewall.
	FirewallArn *string

	// The identifier of the firewall.
	FirewallId *string

	// A descriptive name of the firewall.
	FirewallName *string

	// The ARN of the firewall policy.
	FirewallPolicyArn *string

	// Whether the firewall is protected from a change to the firewall policy. If set
	// to true , you cannot associate a different policy with the firewall.
	FirewallPolicyChangeProtection *bool

	// Whether the firewall is protected from a change to the subnet associations. If
	// set to true , you cannot map different subnets to the firewall.
	SubnetChangeProtection *bool

	// The public subnets that Network Firewall uses for the firewall. Each subnet
	// must belong to a different Availability Zone.
	SubnetMappings []AwsNetworkFirewallFirewallSubnetMappingsDetails

	// The identifier of the VPC where the firewall is used.
	VpcId *string

	noSmithyDocumentSerde
}

// Details about a firewall policy. A firewall policy defines the behavior of a
// network firewall.
type AwsNetworkFirewallFirewallPolicyDetails struct {

	// A description of the firewall policy.
	Description *string

	// The firewall policy configuration.
	FirewallPolicy *FirewallPolicyDetails

	// The ARN of the firewall policy.
	FirewallPolicyArn *string

	// The identifier of the firewall policy.
	FirewallPolicyId *string

	// The name of the firewall policy.
	FirewallPolicyName *string

	noSmithyDocumentSerde
}

// A public subnet that Network Firewall uses for the firewall.
type AwsNetworkFirewallFirewallSubnetMappingsDetails struct {

	// The identifier of the subnet
	SubnetId *string

	noSmithyDocumentSerde
}

// Details about an Network Firewall rule group. Rule groups are used to inspect
// and control network traffic. Stateless rule groups apply to individual packets.
// Stateful rule groups apply to packets in the context of their traffic flow.
//
// Rule groups are referenced in firewall policies.
type AwsNetworkFirewallRuleGroupDetails struct {

	// The maximum number of operating resources that this rule group can use.
	Capacity *int32

	// A description of the rule group.
	Description *string

	// Details about the rule group.
	RuleGroup *RuleGroupDetails

	// The ARN of the rule group.
	RuleGroupArn *string

	// The identifier of the rule group.
	RuleGroupId *string

	// The descriptive name of the rule group.
	RuleGroupName *string

	// The type of rule group. A rule group can be stateful or stateless.
	Type *string

	noSmithyDocumentSerde
}

// Provides information about domain access control options.
type AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails struct {

	// Enables fine-grained access control.
	Enabled *bool

	// Enables the internal user database.
	InternalUserDatabaseEnabled *bool

	// Specifies information about the master user of the domain.
	MasterUserOptions *AwsOpenSearchServiceDomainMasterUserOptionsDetails

	noSmithyDocumentSerde
}

// Details about the configuration of an OpenSearch cluster.
type AwsOpenSearchServiceDomainClusterConfigDetails struct {

	// The number of instances to use for the master node. If this attribute is
	// specified, then DedicatedMasterEnabled must be true .
	DedicatedMasterCount *int32

	// Whether to use a dedicated master node for the OpenSearch domain. A dedicated
	// master node performs cluster management tasks, but does not hold data or respond
	// to data upload requests.
	DedicatedMasterEnabled *bool

	// The hardware configuration of the computer that hosts the dedicated master node.
	//
	// If this attribute is specified, then DedicatedMasterEnabled must be true .
	DedicatedMasterType *string

	// The number of data nodes to use in the OpenSearch domain.
	InstanceCount *int32

	// The instance type for your data nodes.
	//
	// For a list of valid values, see [Supported instance types in Amazon OpenSearch Service] in the Amazon OpenSearch Service Developer
	// Guide.
	//
	// [Supported instance types in Amazon OpenSearch Service]: https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html
	InstanceType *string

	// The number of UltraWarm instances.
	WarmCount *int32

	// Whether UltraWarm is enabled.
	WarmEnabled *bool

	// The type of UltraWarm instance.
	WarmType *string

	// Configuration options for zone awareness. Provided if ZoneAwarenessEnabled is
	// true .
	ZoneAwarenessConfig *AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails

	// Whether to enable zone awareness for the OpenSearch domain. When zone awareness
	// is enabled, OpenSearch Service allocates the cluster's nodes and replica index
	// shards across Availability Zones (AZs) in the same Region. This prevents data
	// loss and minimizes downtime if a node or data center fails.
	ZoneAwarenessEnabled *bool

	noSmithyDocumentSerde
}

// Configuration options for zone awareness.
type AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails struct {

	// The number of Availability Zones that the domain uses. Valid values are 2 or 3 .
	// The default is 2 .
	AvailabilityZoneCount *int32

	noSmithyDocumentSerde
}

// Information about an Amazon OpenSearch Service domain.
type AwsOpenSearchServiceDomainDetails struct {

	// IAM policy document that specifies the access policies for the OpenSearch
	// Service domain.
	AccessPolicies *string

	// Specifies options for fine-grained access control.
	AdvancedSecurityOptions *AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails

	// The ARN of the OpenSearch Service domain.
	Arn *string

	// Details about the configuration of an OpenSearch cluster.
	ClusterConfig *AwsOpenSearchServiceDomainClusterConfigDetails

	// The domain endpoint.
	DomainEndpoint *string

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails

	// The domain endpoints. Used if the OpenSearch domain resides in a VPC.
	//
	// This is a map of key-value pairs. The key is always vpc . The value is the
	// endpoint.
	DomainEndpoints map[string]string

	// The name of the endpoint.
	DomainName *string

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails

	// The version of the domain engine.
	EngineVersion *string

	// The identifier of the domain.
	Id *string

	// Configures the CloudWatch Logs to publish for the OpenSearch domain.
	LogPublishingOptions *AwsOpenSearchServiceDomainLogPublishingOptionsDetails

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails

	// Information about the status of a domain relative to the latest service
	// software.
	ServiceSoftwareOptions *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails

	// Information that OpenSearch Service derives based on VPCOptions for the domain.
	VpcOptions *AwsOpenSearchServiceDomainVpcOptionsDetails

	noSmithyDocumentSerde
}

// Information about additional options for the domain endpoint.
type AwsOpenSearchServiceDomainDomainEndpointOptionsDetails struct {

	// The fully qualified URL for the custom endpoint.
	CustomEndpoint *string

	// The ARN for the security certificate. The certificate is managed in ACM.
	CustomEndpointCertificateArn *string

	// Whether to enable a custom endpoint for the domain.
	CustomEndpointEnabled *bool

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool

	// The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.
	TLSSecurityPolicy *string

	noSmithyDocumentSerde
}

// Details about the configuration for encryption at rest for the OpenSearch
// domain.
type AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails struct {

	// Whether encryption at rest is enabled.
	Enabled *bool

	// The KMS key ID.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Configuration details for a log publishing option.
type AwsOpenSearchServiceDomainLogPublishingOption struct {

	// The ARN of the CloudWatch Logs group to publish the logs to.
	CloudWatchLogsLogGroupArn *string

	// Whether the log publishing is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Configures the CloudWatch Logs to publish for the OpenSearch domain.
type AwsOpenSearchServiceDomainLogPublishingOptionsDetails struct {

	// Configures the OpenSearch audit logs publishing.
	AuditLogs *AwsOpenSearchServiceDomainLogPublishingOption

	// Configures the OpenSearch index logs publishing.
	IndexSlowLogs *AwsOpenSearchServiceDomainLogPublishingOption

	// Configures the OpenSearch search slow log publishing.
	SearchSlowLogs *AwsOpenSearchServiceDomainLogPublishingOption

	noSmithyDocumentSerde
}

// Specifies information about the master user of the domain.
type AwsOpenSearchServiceDomainMasterUserOptionsDetails struct {

	// The Amazon Resource Name (ARN) for the master user.
	MasterUserArn *string

	// The username for the master user.
	MasterUserName *string

	// The password for the master user.
	MasterUserPassword *string

	noSmithyDocumentSerde
}

// Provides details about the configuration for node-to-node encryption.
type AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails struct {

	// Whether node-to-node encryption is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Provides information about the state of the domain relative to the latest
// service software.
type AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails struct {

	// The epoch time when the deployment window closes for required updates. After
	// this time, OpenSearch Service schedules the software upgrade automatically.
	AutomatedUpdateDate *string

	// Whether a request to update the domain can be canceled.
	Cancellable *bool

	// The version of the service software that is currently installed on the domain.
	CurrentVersion *string

	// A more detailed description of the service software status.
	Description *string

	// The most recent version of the service software.
	NewVersion *string

	// Whether the service software update is optional.
	OptionalDeployment *bool

	// Whether a service software update is available for the domain.
	UpdateAvailable *bool

	// The status of the service software update. Valid values are as follows:
	//
	//   - COMPLETED
	//
	//   - ELIGIBLE
	//
	//   - IN_PROGRESS
	//
	//   - NOT_ELIGIBLE
	//
	//   - PENDING_UPDATE
	UpdateStatus *string

	noSmithyDocumentSerde
}

// Contains information that OpenSearch Service derives based on the VPCOptions
// for the domain.
type AwsOpenSearchServiceDomainVpcOptionsDetails struct {

	// The list of security group IDs that are associated with the VPC endpoints for
	// the domain.
	SecurityGroupIds []string

	// A list of subnet IDs that are associated with the VPC endpoints for the domain.
	SubnetIds []string

	noSmithyDocumentSerde
}

// An IAM role that is associated with the Amazon RDS DB cluster.
type AwsRdsDbClusterAssociatedRole struct {

	// The ARN of the IAM role.
	RoleArn *string

	// The status of the association between the IAM role and the DB cluster. Valid
	// values are as follows:
	//
	//   - ACTIVE
	//
	//   - INVALID
	//
	//   - PENDING
	Status *string

	noSmithyDocumentSerde
}

// Information about an Amazon RDS DB cluster.
type AwsRdsDbClusterDetails struct {

	// The status of the database activity stream. Valid values are as follows:
	//
	//   - started
	//
	//   - starting
	//
	//   - stopped
	//
	//   - stopping
	ActivityStreamStatus *string

	// For all database engines except Aurora, specifies the allocated storage size in
	// gibibytes (GiB).
	AllocatedStorage *int32

	// A list of the IAM roles that are associated with the DB cluster.
	AssociatedRoles []AwsRdsDbClusterAssociatedRole

	//  Indicates if minor version upgrades are automatically applied to the cluster.
	AutoMinorVersionUpgrade *bool

	// A list of Availability Zones (AZs) where instances in the DB cluster can be
	// created.
	AvailabilityZones []string

	// The number of days for which automated backups are retained.
	BackupRetentionPeriod *int32

	// Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ClusterCreateTime *string

	// Whether tags are copied from the DB cluster to snapshots of the DB cluster.
	CopyTagsToSnapshot *bool

	// Whether the DB cluster is a clone of a DB cluster owned by a different Amazon
	// Web Services account.
	CrossAccountClone *bool

	// A list of custom endpoints for the DB cluster.
	CustomEndpoints []string

	// The name of the database.
	DatabaseName *string

	// The DB cluster identifier that the user assigned to the cluster. This
	// identifier is the unique key that identifies a DB cluster.
	DbClusterIdentifier *string

	// The list of instances that make up the DB cluster.
	DbClusterMembers []AwsRdsDbClusterMember

	// The list of option group memberships for this DB cluster.
	DbClusterOptionGroupMemberships []AwsRdsDbClusterOptionGroupMembership

	// The name of the DB cluster parameter group for the DB cluster.
	DbClusterParameterGroup *string

	// The identifier of the DB cluster. The identifier must be unique within each
	// Amazon Web Services Region and is immutable.
	DbClusterResourceId *string

	// The subnet group that is associated with the DB cluster, including the name,
	// description, and subnets in the subnet group.
	DbSubnetGroup *string

	// Whether the DB cluster has deletion protection enabled.
	DeletionProtection *bool

	// The Active Directory domain membership records that are associated with the DB
	// cluster.
	DomainMemberships []AwsRdsDbDomainMembership

	// A list of log types that this DB cluster is configured to export to CloudWatch
	// Logs.
	EnabledCloudWatchLogsExports []string

	// The connection endpoint for the primary instance of the DB cluster.
	Endpoint *string

	// The name of the database engine to use for this DB cluster. Valid values are as
	// follows:
	//
	//   - aurora
	//
	//   - aurora-mysql
	//
	//   - aurora-postgresql
	Engine *string

	// The database engine mode of the DB cluster.Valid values are as follows:
	//
	//   - global
	//
	//   - multimaster
	//
	//   - parallelquery
	//
	//   - provisioned
	//
	//   - serverless
	EngineMode *string

	// The version number of the database engine to use.
	EngineVersion *string

	// Specifies the identifier that Amazon Route 53 assigns when you create a hosted
	// zone.
	HostedZoneId *string

	// Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
	HttpEndpointEnabled *bool

	// Whether the mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled *bool

	// The ARN of the KMS master key that is used to encrypt the database instances in
	// the DB cluster.
	KmsKeyId *string

	// The name of the master user for the DB cluster.
	MasterUsername *string

	// Whether the DB cluster has instances in multiple Availability Zones.
	MultiAz *bool

	// The port number on which the DB instances in the DB cluster accept connections.
	Port *int32

	// The range of time each day when automated backups are created, if automated
	// backups are enabled.
	//
	// Uses the format HH:MM-HH:MM . For example, 04:52-05:22 .
	PreferredBackupWindow *string

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Uses the format :HH:MM-:HH:MM .
	//
	// For the day values, use mon | tue | wed | thu | fri | sat | sun .
	//
	// For example, sun:09:32-sun:10:02 .
	PreferredMaintenanceWindow *string

	// The identifiers of the read replicas that are associated with this DB cluster.
	ReadReplicaIdentifiers []string

	// The reader endpoint for the DB cluster.
	ReaderEndpoint *string

	// The current status of this DB cluster.
	Status *string

	// Whether the DB cluster is encrypted.
	StorageEncrypted *bool

	// A list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []AwsRdsDbInstanceVpcSecurityGroup

	noSmithyDocumentSerde
}

// Information about an instance in the DB cluster.
type AwsRdsDbClusterMember struct {

	// The status of the DB cluster parameter group for this member of the DB cluster.
	DbClusterParameterGroupStatus *string

	// The instance identifier for this member of the DB cluster.
	DbInstanceIdentifier *string

	// Whether the cluster member is the primary instance for the DB cluster.
	IsClusterWriter *bool

	// Specifies the order in which an Aurora replica is promoted to the primary
	// instance when the existing primary instance fails.
	PromotionTier *int32

	noSmithyDocumentSerde
}

// Information about an option group membership for a DB cluster.
type AwsRdsDbClusterOptionGroupMembership struct {

	// The name of the DB cluster option group.
	DbClusterOptionGroupName *string

	// The status of the DB cluster option group.
	Status *string

	noSmithyDocumentSerde
}

//	Contains the name and values of a manual Amazon Relational Database Service
//
// (RDS) DB cluster snapshot attribute.
type AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute struct {

	//  The name of the manual DB cluster snapshot attribute. The attribute named
	// restore refers to the list of Amazon Web Services accounts that have permission
	// to copy or restore the manual DB cluster snapshot.
	AttributeName *string

	//  The value(s) for the manual DB cluster snapshot attribute. If the AttributeName
	// field is set to restore , then this element returns a list of IDs of the Amazon
	// Web Services accounts that are authorized to copy or restore the manual DB
	// cluster snapshot. If a value of all is in the list, then the manual DB cluster
	// snapshot is public and available for any Amazon Web Services account to copy or
	// restore.
	AttributeValues []string

	noSmithyDocumentSerde
}

// Information about an Amazon RDS DB cluster snapshot.
type AwsRdsDbClusterSnapshotDetails struct {

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int32

	// A list of Availability Zones where instances in the DB cluster can be created.
	AvailabilityZones []string

	// Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ClusterCreateTime *string

	// The DB cluster identifier.
	DbClusterIdentifier *string

	//  Contains the name and values of a manual DB cluster snapshot attribute.
	DbClusterSnapshotAttributes []AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute

	// The identifier of the DB cluster snapshot.
	DbClusterSnapshotIdentifier *string

	// The name of the database engine that you want to use for this DB instance.
	Engine *string

	// The version of the database engine to use.
	EngineVersion *string

	// Whether mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled *bool

	// The ARN of the KMS master key that is used to encrypt the database instances in
	// the DB cluster.
	KmsKeyId *string

	// The license model information for this DB cluster snapshot.
	LicenseModel *string

	// The name of the master user for the DB cluster.
	MasterUsername *string

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int32

	// The port number on which the DB instances in the DB cluster accept connections.
	Port *int32

	// Indicates when the snapshot was taken.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	SnapshotCreateTime *string

	// The type of DB cluster snapshot.
	SnapshotType *string

	// The status of this DB cluster snapshot.
	Status *string

	// Whether the DB cluster is encrypted.
	StorageEncrypted *bool

	// The VPC ID that is associated with the DB cluster snapshot.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about an Active Directory domain membership record associated with
// the DB instance.
type AwsRdsDbDomainMembership struct {

	// The identifier of the Active Directory domain.
	Domain *string

	// The fully qualified domain name of the Active Directory domain.
	Fqdn *string

	// The name of the IAM role to use when making API calls to the Directory Service.
	IamRoleName *string

	// The status of the Active Directory Domain membership for the DB instance.
	Status *string

	noSmithyDocumentSerde
}

// An IAM role associated with the DB instance.
type AwsRdsDbInstanceAssociatedRole struct {

	// The name of the feature associated with the IAM role.
	FeatureName *string

	// The ARN of the IAM role that is associated with the DB instance.
	RoleArn *string

	// Describes the state of the association between the IAM role and the DB
	// instance. The Status property returns one of the following values:
	//
	//   - ACTIVE - The IAM role ARN is associated with the DB instance and can be used
	//   to access other Amazon Web Services services on your behalf.
	//
	//   - PENDING - The IAM role ARN is being associated with the DB instance.
	//
	//   - INVALID - The IAM role ARN is associated with the DB instance. But the DB
	//   instance is unable to assume the IAM role in order to access other Amazon Web
	//   Services services on your behalf.
	Status *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB instance.
type AwsRdsDbInstanceDetails struct {

	// The amount of storage (in gigabytes) to initially allocate for the DB instance.
	AllocatedStorage *int32

	// The IAM roles associated with the DB instance.
	AssociatedRoles []AwsRdsDbInstanceAssociatedRole

	// Indicates whether minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool

	// The Availability Zone where the DB instance will be created.
	AvailabilityZone *string

	// The number of days for which to retain automated backups.
	BackupRetentionPeriod *int32

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string

	// The name of the character set that this DB instance is associated with.
	CharacterSetName *string

	// Whether to copy resource tags to snapshots of the DB instance.
	CopyTagsToSnapshot *bool

	// If the DB instance is a member of a DB cluster, contains the name of the DB
	// cluster that the DB instance is a member of.
	DBClusterIdentifier *string

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string

	// Contains a user-supplied database identifier. This identifier is the unique key
	// that identifies a DB instance.
	DBInstanceIdentifier *string

	// The meaning of this parameter differs according to the database engine you use.
	//
	// MySQL, MariaDB, SQL Server, PostgreSQL
	//
	// Contains the name of the initial database of this instance that was provided at
	// create time, if one was specified when the DB instance was created. This same
	// name is returned for the life of the DB instance.
	//
	// Oracle
	//
	// Contains the Oracle System ID (SID) of the created DB instance. Not shown when
	// the returned parameters do not apply to an Oracle DB instance.
	DBName *string

	// Specifies the port that the DB instance listens on. If the DB instance is part
	// of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int32

	// The current status of the DB instance.
	DbInstanceStatus *string

	// A list of the DB parameter groups to assign to the DB instance.
	DbParameterGroups []AwsRdsDbParameterGroup

	// A list of the DB security groups to assign to the DB instance.
	DbSecurityGroups []string

	// Information about the subnet group that is associated with the DB instance.
	DbSubnetGroup *AwsRdsDbSubnetGroup

	// The Amazon Web Services Region-unique, immutable identifier for the DB
	// instance. This identifier is found in CloudTrail log entries whenever the KMS
	// key for the DB instance is accessed.
	DbiResourceId *string

	// Indicates whether the DB instance has deletion protection enabled.
	//
	// When deletion protection is enabled, the database cannot be deleted.
	DeletionProtection *bool

	// The Active Directory domain membership records associated with the DB instance.
	DomainMemberships []AwsRdsDbDomainMembership

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	EnabledCloudWatchLogsExports []string

	// Specifies the connection endpoint.
	Endpoint *AwsRdsDbInstanceEndpoint

	// Provides the name of the database engine to use for this DB instance.
	Engine *string

	// Indicates the database engine version.
	EngineVersion *string

	// The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring
	// metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string

	// True if mapping of IAM accounts to database accounts is enabled, and otherwise
	// false.
	//
	// IAM database authentication can be enabled for the following database engines.
	//
	//   - For MySQL 5.6, minor version 5.6.34 or higher
	//
	//   - For MySQL 5.7, minor version 5.7.16 or higher
	//
	//   - Aurora 5.6 or higher
	IAMDatabaseAuthenticationEnabled *bool

	// Indicates when the DB instance was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	InstanceCreateTime *string

	// Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
	Iops *int32

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// instance.
	KmsKeyId *string

	// Specifies the latest time to which a database can be restored with
	// point-in-time restore.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LatestRestorableTime *string

	// License model information for this DB instance.
	LicenseModel *string

	// Specifies the connection endpoint.
	ListenerEndpoint *AwsRdsDbInstanceEndpoint

	// The master user name of the DB instance.
	MasterUsername *string

	// The upper limit to which Amazon RDS can automatically scale the storage of the
	// DB instance.
	MaxAllocatedStorage *int32

	// The interval, in seconds, between points when enhanced monitoring metrics are
	// collected for the DB instance.
	MonitoringInterval *int32

	// The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring
	// metrics to CloudWatch Logs.
	MonitoringRoleArn *string

	// Whether the DB instance is a multiple Availability Zone deployment.
	MultiAz *bool

	// The list of option group memberships for this DB instance.
	OptionGroupMemberships []AwsRdsDbOptionGroupMembership

	// Changes to the DB instance that are currently pending.
	PendingModifiedValues *AwsRdsDbPendingModifiedValues

	// Indicates whether Performance Insights is enabled for the DB instance.
	PerformanceInsightsEnabled *bool

	// The identifier of the KMS key used to encrypt the Performance Insights data.
	PerformanceInsightsKmsKeyId *string

	// The number of days to retain Performance Insights data.
	PerformanceInsightsRetentionPeriod *int32

	// The range of time each day when automated backups are created, if automated
	// backups are enabled.
	//
	// Uses the format HH:MM-HH:MM . For example, 04:52-05:22 .
	PreferredBackupWindow *string

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Uses the format :HH:MM-:HH:MM .
	//
	// For the day values, use mon | tue | wed | thu | fri | sat | sun .
	//
	// For example, sun:09:32-sun:10:02 .
	PreferredMaintenanceWindow *string

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []AwsRdsDbProcessorFeature

	// The order in which to promote an Aurora replica to the primary instance after a
	// failure of the existing primary instance.
	PromotionTier *int32

	// Specifies the accessibility options for the DB instance.
	//
	// A value of true specifies an Internet-facing instance with a publicly
	// resolvable DNS name, which resolves to a public IP address.
	//
	// A value of false specifies an internal instance with a DNS name that resolves
	// to a private IP address.
	PubliclyAccessible *bool

	// List of identifiers of Aurora DB clusters to which the RDS DB instance is
	// replicated as a read replica.
	ReadReplicaDBClusterIdentifiers []string

	// List of identifiers of the read replicas associated with this DB instance.
	ReadReplicaDBInstanceIdentifiers []string

	// If this DB instance is a read replica, contains the identifier of the source DB
	// instance.
	ReadReplicaSourceDBInstanceIdentifier *string

	// For a DB instance with multi-Availability Zone support, the name of the
	// secondary Availability Zone.
	SecondaryAvailabilityZone *string

	// The status of a read replica. If the instance isn't a read replica, this is
	// empty.
	StatusInfos []AwsRdsDbStatusInfo

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool

	// The storage type for the DB instance.
	StorageType *string

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string

	// The time zone of the DB instance.
	Timezone *string

	// A list of VPC security groups that the DB instance belongs to.
	VpcSecurityGroups []AwsRdsDbInstanceVpcSecurityGroup

	noSmithyDocumentSerde
}

// Specifies the connection endpoint.
type AwsRdsDbInstanceEndpoint struct {

	// Specifies the DNS address of the DB instance.
	Address *string

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string

	// Specifies the port that the database engine is listening on.
	Port *int32

	noSmithyDocumentSerde
}

// A VPC security groups that the DB instance belongs to.
type AwsRdsDbInstanceVpcSecurityGroup struct {

	// The status of the VPC security group.
	Status *string

	// The name of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

// An option group membership.
type AwsRdsDbOptionGroupMembership struct {

	// The name of the option group.
	OptionGroupName *string

	// The status of the option group membership.
	Status *string

	noSmithyDocumentSerde
}

// Provides information about a parameter group for a DB instance.
type AwsRdsDbParameterGroup struct {

	// The name of the parameter group.
	DbParameterGroupName *string

	// The status of parameter updates.
	ParameterApplyStatus *string

	noSmithyDocumentSerde
}

// Changes to a DB instance that are currently pending.
type AwsRdsDbPendingModifiedValues struct {

	// The new value of the allocated storage for the DB instance.
	AllocatedStorage *int32

	// The new backup retention period for the DB instance.
	BackupRetentionPeriod *int32

	// The new CA certificate identifier for the DB instance.
	CaCertificateIdentifier *string

	// The new DB instance class for the DB instance.
	DbInstanceClass *string

	// The new DB instance identifier for the DB instance.
	DbInstanceIdentifier *string

	// The name of the new subnet group for the DB instance.
	DbSubnetGroupName *string

	// The new engine version for the DB instance.
	EngineVersion *string

	// The new provisioned IOPS value for the DB instance.
	Iops *int32

	// The new license model value for the DB instance.
	LicenseModel *string

	// The new master user password for the DB instance.
	MasterUserPassword *string

	// Indicates that a single Availability Zone DB instance is changing to a multiple
	// Availability Zone deployment.
	MultiAZ *bool

	// A list of log types that are being enabled or disabled.
	PendingCloudWatchLogsExports *AwsRdsPendingCloudWatchLogsExports

	// The new port for the DB instance.
	Port *int32

	// Processor features that are being updated.
	ProcessorFeatures []AwsRdsDbProcessorFeature

	// The new storage type for the DB instance.
	StorageType *string

	noSmithyDocumentSerde
}

// A processor feature.
type AwsRdsDbProcessorFeature struct {

	// The name of the processor feature. Valid values are coreCount or threadsPerCore .
	Name *string

	// The value of the processor feature.
	Value *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon RDS DB security group.
type AwsRdsDbSecurityGroupDetails struct {

	// The ARN for the DB security group.
	DbSecurityGroupArn *string

	// Provides the description of the DB security group.
	DbSecurityGroupDescription *string

	// Specifies the name of the DB security group.
	DbSecurityGroupName *string

	// Contains a list of EC2 security groups.
	Ec2SecurityGroups []AwsRdsDbSecurityGroupEc2SecurityGroup

	// Contains a list of IP ranges.
	IpRanges []AwsRdsDbSecurityGroupIpRange

	// Provides the Amazon Web Services ID of the owner of a specific DB security
	// group.
	OwnerId *string

	// Provides VPC ID associated with the DB security group.
	VpcId *string

	noSmithyDocumentSerde
}

// EC2 security group information for an RDS DB security group.
type AwsRdsDbSecurityGroupEc2SecurityGroup struct {

	// Specifies the ID for the EC2 security group.
	Ec2SecurityGroupId *string

	// Specifies the name of the EC2 security group.
	Ec2SecurityGroupName *string

	// Provides the Amazon Web Services ID of the owner of the EC2 security group.
	Ec2SecurityGroupOwnerId *string

	// Provides the status of the EC2 security group.
	Status *string

	noSmithyDocumentSerde
}

// IP range information for an RDS DB security group.
type AwsRdsDbSecurityGroupIpRange struct {

	// Specifies the IP range.
	CidrIp *string

	// Specifies the status of the IP range.
	Status *string

	noSmithyDocumentSerde
}

// Provides details about an Amazon RDS DB cluster snapshot.
type AwsRdsDbSnapshotDetails struct {

	// The amount of storage (in gigabytes) to be initially allocated for the database
	// instance.
	AllocatedStorage *int32

	// Specifies the name of the Availability Zone in which the DB instance was
	// located at the time of the DB snapshot.
	AvailabilityZone *string

	// A name for the DB instance.
	DbInstanceIdentifier *string

	// The name or ARN of the DB snapshot that is used to restore the DB instance.
	DbSnapshotIdentifier *string

	// The identifier for the source DB instance.
	DbiResourceId *string

	// Whether the DB snapshot is encrypted.
	Encrypted *bool

	// The name of the database engine to use for this DB instance. Valid values are
	// as follows:
	//
	//   - aurora
	//
	//   - aurora-mysql
	//
	//   - aurora-postgresql
	//
	//   - c
	//
	//   - mariadb
	//
	//   - mysql
	//
	//   - oracle-ee
	//
	//   - oracle-se
	//
	//   - oracle-se1
	//
	//   - oracle-se2
	//
	//   - sqlserver-ee
	//
	//   - sqlserver-ex
	//
	//   - sqlserver-se
	//
	//   - sqlserver-web
	Engine *string

	// The version of the database engine.
	EngineVersion *string

	// Whether mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled *bool

	// Specifies the time in Coordinated Universal Time (UTC) when the DB instance,
	// from which the snapshot was taken, was created.
	InstanceCreateTime *string

	// The provisioned IOPS (I/O operations per second) value of the DB instance at
	// the time of the snapshot.
	Iops *int32

	// If Encrypted is true , the KMS key identifier for the encrypted DB snapshot.
	KmsKeyId *string

	// License model information for the restored DB instance.
	LicenseModel *string

	// The master user name for the DB snapshot.
	MasterUsername *string

	// The option group name for the DB snapshot.
	OptionGroupName *string

	// The percentage of the estimated data that has been transferred.
	PercentProgress *int32

	// The port that the database engine was listening on at the time of the snapshot.
	Port *int32

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []AwsRdsDbProcessorFeature

	// When the snapshot was taken in Coordinated Universal Time (UTC).
	SnapshotCreateTime *string

	// The type of the DB snapshot.
	SnapshotType *string

	// The DB snapshot ARN that the DB snapshot was copied from.
	SourceDbSnapshotIdentifier *string

	// The Amazon Web Services Region that the DB snapshot was created in or copied
	// from.
	SourceRegion *string

	// The status of this DB snapshot.
	Status *string

	// The storage type associated with the DB snapshot. Valid values are as follows:
	//
	//   - gp2
	//
	//   - io1
	//
	//   - standard
	StorageType *string

	// The ARN from the key store with which to associate the instance for TDE
	// encryption.
	TdeCredentialArn *string

	// The time zone of the DB snapshot.
	Timezone *string

	// The VPC ID associated with the DB snapshot.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about the status of a read replica.
type AwsRdsDbStatusInfo struct {

	// If the read replica is currently in an error state, provides the error details.
	Message *string

	// Whether the read replica instance is operating normally.
	Normal *bool

	// The status of the read replica instance.
	Status *string

	// The type of status. For a read replica, the status type is read replication.
	StatusType *string

	noSmithyDocumentSerde
}

// Information about the subnet group for the database instance.
type AwsRdsDbSubnetGroup struct {

	// The ARN of the subnet group.
	DbSubnetGroupArn *string

	// The description of the subnet group.
	DbSubnetGroupDescription *string

	// The name of the subnet group.
	DbSubnetGroupName *string

	// The status of the subnet group.
	SubnetGroupStatus *string

	// A list of subnets in the subnet group.
	Subnets []AwsRdsDbSubnetGroupSubnet

	// The VPC ID of the subnet group.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about a subnet in a subnet group.
type AwsRdsDbSubnetGroupSubnet struct {

	// Information about the Availability Zone for a subnet in the subnet group.
	SubnetAvailabilityZone *AwsRdsDbSubnetGroupSubnetAvailabilityZone

	// The identifier of a subnet in the subnet group.
	SubnetIdentifier *string

	// The status of a subnet in the subnet group.
	SubnetStatus *string

	noSmithyDocumentSerde
}

// An Availability Zone for a subnet in a subnet group.
type AwsRdsDbSubnetGroupSubnetAvailabilityZone struct {

	// The name of the Availability Zone for a subnet in the subnet group.
	Name *string

	noSmithyDocumentSerde
}

// Details about an Amazon RDS event notification subscription. The subscription
// allows Amazon RDS to post events to an SNS topic.
type AwsRdsEventSubscriptionDetails struct {

	// The identifier of the account that is associated with the event notification
	// subscription.
	CustSubscriptionId *string

	// The identifier of the event notification subscription.
	CustomerAwsId *string

	// Whether the event notification subscription is enabled.
	Enabled *bool

	// The list of event categories for the event notification subscription.
	EventCategoriesList []string

	// The ARN of the event notification subscription.
	EventSubscriptionArn *string

	// The ARN of the SNS topic to post the event notifications to.
	SnsTopicArn *string

	// A list of source identifiers for the event notification subscription.
	SourceIdsList []string

	// The source type for the event notification subscription.
	SourceType *string

	// The status of the event notification subscription.
	//
	// Valid values: creating | modifying | deleting | active | no-permission |
	// topic-not-exist
	Status *string

	// The datetime when the event notification subscription was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	SubscriptionCreationTime *string

	noSmithyDocumentSerde
}

// Identifies the log types to enable and disable.
type AwsRdsPendingCloudWatchLogsExports struct {

	// A list of log types that are being disabled.
	LogTypesToDisable []string

	// A list of log types that are being enabled.
	LogTypesToEnable []string

	noSmithyDocumentSerde
}

// A node in an Amazon Redshift cluster.
type AwsRedshiftClusterClusterNode struct {

	// The role of the node. A node might be a leader node or a compute node.
	NodeRole *string

	// The private IP address of the node.
	PrivateIpAddress *string

	// The public IP address of the node.
	PublicIpAddress *string

	noSmithyDocumentSerde
}

// A cluster parameter group that is associated with an Amazon Redshift cluster.
type AwsRedshiftClusterClusterParameterGroup struct {

	// The list of parameter statuses.
	ClusterParameterStatusList []AwsRedshiftClusterClusterParameterStatus

	// The status of updates to the parameters.
	ParameterApplyStatus *string

	// The name of the parameter group.
	ParameterGroupName *string

	noSmithyDocumentSerde
}

// The status of a parameter in a cluster parameter group for an Amazon Redshift
// cluster.
type AwsRedshiftClusterClusterParameterStatus struct {

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string

	// The status of the parameter. Indicates whether the parameter is in sync with
	// the database, waiting for a cluster reboot, or encountered an error when it was
	// applied.
	//
	// Valid values: in-sync | pending-reboot | applying | invalid-parameter |
	// apply-deferred | apply-error | unknown-error
	ParameterApplyStatus *string

	// The name of the parameter.
	ParameterName *string

	noSmithyDocumentSerde
}

// A security group that is associated with the cluster.
type AwsRedshiftClusterClusterSecurityGroup struct {

	// The name of the cluster security group.
	ClusterSecurityGroupName *string

	// The status of the cluster security group.
	Status *string

	noSmithyDocumentSerde
}

// You can configure Amazon Redshift to copy snapshots for a cluster to another
// Amazon Web Services Region. This parameter provides information about a
// cross-Region snapshot copy.
type AwsRedshiftClusterClusterSnapshotCopyStatus struct {

	// The destination Region that snapshots are automatically copied to when
	// cross-Region snapshot copy is enabled.
	DestinationRegion *string

	// The number of days that manual snapshots are retained in the destination Region
	// after they are copied from a source Region.
	//
	// If the value is -1 , then the manual snapshot is retained indefinitely.
	//
	// Valid values: Either -1 or an integer between 1 and 3,653
	ManualSnapshotRetentionPeriod *int32

	// The number of days to retain automated snapshots in the destination Region
	// after they are copied from a source Region.
	RetentionPeriod *int32

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string

	noSmithyDocumentSerde
}

// A time windows during which maintenance was deferred for an Amazon Redshift
// cluster.
type AwsRedshiftClusterDeferredMaintenanceWindow struct {

	// The end of the time window for which maintenance was deferred.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	DeferMaintenanceEndTime *string

	// The identifier of the maintenance window.
	DeferMaintenanceIdentifier *string

	// The start of the time window for which maintenance was deferred.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	DeferMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Details about an Amazon Redshift cluster.
type AwsRedshiftClusterDetails struct {

	// Indicates whether major version upgrades are applied automatically to the
	// cluster during the maintenance window.
	AllowVersionUpgrade *bool

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod *int32

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string

	// The availability status of the cluster for queries. Possible values are the
	// following:
	//
	//   - Available - The cluster is available for queries.
	//
	//   - Unavailable - The cluster is not available for queries.
	//
	//   - Maintenance - The cluster is intermittently available for queries due to
	//   maintenance activities.
	//
	//   - Modifying -The cluster is intermittently available for queries due to
	//   changes that modify the cluster.
	//
	//   - Failed - The cluster failed and is not available for queries.
	ClusterAvailabilityStatus *string

	// Indicates when the cluster was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ClusterCreateTime *string

	// The unique identifier of the cluster.
	ClusterIdentifier *string

	// The nodes in the cluster.
	ClusterNodes []AwsRedshiftClusterClusterNode

	// The list of cluster parameter groups that are associated with this cluster.
	ClusterParameterGroups []AwsRedshiftClusterClusterParameterGroup

	// The public key for the cluster.
	ClusterPublicKey *string

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string

	// A list of cluster security groups that are associated with the cluster.
	ClusterSecurityGroups []AwsRedshiftClusterClusterSecurityGroup

	// Information about the destination Region and retention period for the
	// cross-Region snapshot copy.
	ClusterSnapshotCopyStatus *AwsRedshiftClusterClusterSnapshotCopyStatus

	// The current status of the cluster.
	//
	// Valid values: available | available, prep-for-resize | available, resize-cleanup
	// | cancelling-resize | creating | deleting | final-snapshot | hardware-failure |
	// incompatible-hsm | incompatible-network | incompatible-parameters |
	// incompatible-restore | modifying | paused | rebooting | renaming | resizing |
	// rotating-keys | storage-full | updating-hsm
	ClusterStatus *string

	// The name of the subnet group that is associated with the cluster. This
	// parameter is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string

	// The version ID of the Amazon Redshift engine that runs on the cluster.
	ClusterVersion *string

	// The name of the initial database that was created when the cluster was created.
	//
	// The same name is returned for the life of the cluster.
	//
	// If an initial database is not specified, a database named devdev is created by
	// default.
	DBName *string

	// List of time windows during which maintenance was deferred.
	DeferredMaintenanceWindows []AwsRedshiftClusterDeferredMaintenanceWindow

	// Information about the status of the Elastic IP (EIP) address.
	ElasticIpStatus *AwsRedshiftClusterElasticIpStatus

	// The number of nodes that you can use the elastic resize method to resize the
	// cluster to.
	ElasticResizeNumberOfNodeOptions *string

	// Indicates whether the data in the cluster is encrypted at rest.
	Encrypted *bool

	// The connection endpoint.
	Endpoint *AwsRedshiftClusterEndpoint

	// Indicates whether to create the cluster with enhanced VPC routing enabled.
	EnhancedVpcRouting *bool

	// Indicates when the next snapshot is expected to be taken. The cluster must have
	// a valid snapshot schedule and have backups enabled.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ExpectedNextSnapshotScheduleTime *string

	// The status of the next expected snapshot.
	//
	// Valid values: OnTrack | Pending
	ExpectedNextSnapshotScheduleTimeStatus *string

	// Information about whether the Amazon Redshift cluster finished applying any
	// changes to hardware security module (HSM) settings that were specified in a
	// modify cluster command.
	HsmStatus *AwsRedshiftClusterHsmStatus

	// A list of IAM roles that the cluster can use to access other Amazon Web
	// Services services.
	IamRoles []AwsRedshiftClusterIamRole

	// The identifier of the KMS encryption key that is used to encrypt data in the
	// cluster.
	KmsKeyId *string

	// Information about the logging status of the cluster.
	LoggingStatus *AwsRedshiftClusterLoggingStatus

	// The name of the maintenance track for the cluster.
	MaintenanceTrackName *string

	// The default number of days to retain a manual snapshot.
	//
	// If the value is -1 , the snapshot is retained indefinitely.
	//
	// This setting doesn't change the retention period of existing snapshots.
	//
	// Valid values: Either -1 or an integer between 1 and 3,653
	ManualSnapshotRetentionPeriod *int32

	// The master user name for the cluster. This name is used to connect to the
	// database that is specified in as the value of DBName .
	MasterUsername *string

	// Indicates the start of the next maintenance window.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	NextMaintenanceWindowStartTime *string

	// The node type for the nodes in the cluster.
	NodeType *string

	// The number of compute nodes in the cluster.
	NumberOfNodes *int32

	// A list of cluster operations that are waiting to start.
	PendingActions []string

	// A list of changes to the cluster that are currently pending.
	PendingModifiedValues *AwsRedshiftClusterPendingModifiedValues

	// The weekly time range, in Universal Coordinated Time (UTC), during which system
	// maintenance can occur.
	//
	// Format:  :HH:MM-:HH:MM
	//
	// For the day values, use mon | tue | wed | thu | fri | sat | sun
	//
	// For example, sun:09:32-sun:10:02
	PreferredMaintenanceWindow *string

	// Whether the cluster can be accessed from a public network.
	PubliclyAccessible *bool

	// Information about the resize operation for the cluster.
	ResizeInfo *AwsRedshiftClusterResizeInfo

	// Information about the status of a cluster restore action. Only applies to a
	// cluster that was created by restoring a snapshot.
	RestoreStatus *AwsRedshiftClusterRestoreStatus

	// A unique identifier for the cluster snapshot schedule.
	SnapshotScheduleIdentifier *string

	// The current state of the cluster snapshot schedule.
	//
	// Valid values: MODIFYING | ACTIVE | FAILED
	SnapshotScheduleState *string

	// The identifier of the VPC that the cluster is in, if the cluster is in a VPC.
	VpcId *string

	// The list of VPC security groups that the cluster belongs to, if the cluster is
	// in a VPC.
	VpcSecurityGroups []AwsRedshiftClusterVpcSecurityGroup

	noSmithyDocumentSerde
}

// The status of the elastic IP (EIP) address for an Amazon Redshift cluster.
type AwsRedshiftClusterElasticIpStatus struct {

	// The elastic IP address for the cluster.
	ElasticIp *string

	// The status of the elastic IP address.
	Status *string

	noSmithyDocumentSerde
}

// The connection endpoint for an Amazon Redshift cluster.
type AwsRedshiftClusterEndpoint struct {

	// The DNS address of the cluster.
	Address *string

	// The port that the database engine listens on.
	Port *int32

	noSmithyDocumentSerde
}

// Information about whether an Amazon Redshift cluster finished applying any
// hardware changes to security module (HSM) settings that were specified in a
// modify cluster command.
type AwsRedshiftClusterHsmStatus struct {

	// The name of the HSM client certificate that the Amazon Redshift cluster uses to
	// retrieve the data encryption keys that are stored in an HSM.
	HsmClientCertificateIdentifier *string

	// The name of the HSM configuration that contains the information that the Amazon
	// Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string

	// Indicates whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command.
	//
	// Type: String
	//
	// Valid values: active | applying
	Status *string

	noSmithyDocumentSerde
}

// An IAM role that the cluster can use to access other Amazon Web Services
// services.
type AwsRedshiftClusterIamRole struct {

	// The status of the IAM role's association with the cluster.
	//
	// Valid values: in-sync | adding | removing
	ApplyStatus *string

	// The ARN of the IAM role.
	IamRoleArn *string

	noSmithyDocumentSerde
}

// Provides information about the logging status of the cluster.
type AwsRedshiftClusterLoggingStatus struct {

	// The name of the S3 bucket where the log files are stored.
	BucketName *string

	// The message indicating that the logs failed to be delivered.
	LastFailureMessage *string

	// The last time when logs failed to be delivered.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastFailureTime *string

	// The last time that logs were delivered successfully.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastSuccessfulDeliveryTime *string

	// Indicates whether logging is enabled.
	LoggingEnabled *bool

	// Provides the prefix applied to the log file names.
	S3KeyPrefix *string

	noSmithyDocumentSerde
}

// Changes to the Amazon Redshift cluster that are currently pending.
type AwsRedshiftClusterPendingModifiedValues struct {

	// The pending or in-progress change to the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod *int32

	// The pending or in-progress change to the identifier for the cluster.
	ClusterIdentifier *string

	// The pending or in-progress change to the cluster type.
	ClusterType *string

	// The pending or in-progress change to the service version.
	ClusterVersion *string

	// The encryption type for a cluster.
	EncryptionType *string

	// Indicates whether to create the cluster with enhanced VPC routing enabled.
	EnhancedVpcRouting *bool

	// The name of the maintenance track that the cluster changes to during the next
	// maintenance window.
	MaintenanceTrackName *string

	// The pending or in-progress change to the master user password for the cluster.
	MasterUserPassword *string

	// The pending or in-progress change to the cluster's node type.
	NodeType *string

	// The pending or in-progress change to the number of nodes in the cluster.
	NumberOfNodes *int32

	// The pending or in-progress change to whether the cluster can be connected to
	// from the public network.
	PubliclyAccessible *bool

	noSmithyDocumentSerde
}

// Information about the resize operation for the cluster.
type AwsRedshiftClusterResizeInfo struct {

	// Indicates whether the resize operation can be canceled.
	AllowCancelResize *bool

	// The type of resize operation.
	//
	// Valid values: ClassicResize
	ResizeType *string

	noSmithyDocumentSerde
}

// Information about the status of a cluster restore action. It only applies if
// the cluster was created by restoring a snapshot.
type AwsRedshiftClusterRestoreStatus struct {

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	CurrentRestoreRateInMegaBytesPerSecond *float64

	// The amount of time an in-progress restore has been running, or the amount of
	// time it took a completed restore to finish.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	ElapsedTimeInSeconds *int64

	// The estimate of the time remaining before the restore is complete. Returns 0
	// for a completed restore.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	EstimatedTimeToCompletionInSeconds *int64

	// The number of megabytes that were transferred from snapshot storage.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	ProgressInMegaBytes *int64

	// The size of the set of snapshot data that was used to restore the cluster.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	SnapshotSizeInMegaBytes *int64

	// The status of the restore action.
	//
	// Valid values: starting | restoring | completed | failed
	Status *string

	noSmithyDocumentSerde
}

// A VPC security group that the cluster belongs to, if the cluster is in a VPC.
type AwsRedshiftClusterVpcSecurityGroup struct {

	// The status of the VPC security group.
	Status *string

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

//	An object that contains an optional comment about your Amazon Route 53 hosted
//
// zone.
type AwsRoute53HostedZoneConfigDetails struct {

	//  Any comments that you include about the hosted zone.
	Comment *string

	noSmithyDocumentSerde
}

//	Provides details about a specified Amazon Route 53 hosted zone, including the
//
// four name servers assigned to the hosted zone. A hosted zone represents a
// collection of records that can be managed together, belonging to a single parent
// domain name.
type AwsRoute53HostedZoneDetails struct {

	//  An object that contains information about the specified hosted zone.
	HostedZone *AwsRoute53HostedZoneObjectDetails

	//  An object that contains a list of the authoritative name servers for a hosted
	// zone or for a reusable delegation set.
	NameServers []string

	//  An array that contains one QueryLoggingConfig element for each DNS query
	// logging configuration that is associated with the current Amazon Web Services
	// account.
	QueryLoggingConfig *AwsRoute53QueryLoggingConfigDetails

	//  An object that contains information about the Amazon Virtual Private Clouds
	// (Amazon VPCs) that are associated with the specified hosted zone.
	Vpcs []AwsRoute53HostedZoneVpcDetails

	noSmithyDocumentSerde
}

// An object that contains information about an Amazon Route 53 hosted zone.
type AwsRoute53HostedZoneObjectDetails struct {

	//  An object that includes the Comment element.
	Config *AwsRoute53HostedZoneConfigDetails

	//  The ID that Route 53 assigns to the hosted zone when you create it.
	Id *string

	//  The name of the domain. For public hosted zones, this is the name that you
	// have registered with your DNS registrar.
	Name *string

	noSmithyDocumentSerde
}

//	For private hosted zones, this is a complex type that contains information
//
// about an Amazon VPC.
type AwsRoute53HostedZoneVpcDetails struct {

	//  The identifier of an Amazon VPC.
	Id *string

	//  The Amazon Web Services Region that an Amazon VPC was created in.
	Region *string

	noSmithyDocumentSerde
}

//	Provides details about a specified Amazon Route 53 configuration for DNS query
//
// logging.
type AwsRoute53QueryLoggingConfigDetails struct {

	//  The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log group that
	// Route 53 is publishing logs to.
	CloudWatchLogsLogGroupArn *CloudWatchLogsLogGroupArnConfigDetails

	noSmithyDocumentSerde
}

//	Returns configuration information about the specified Amazon S3 access point.
//
// S3 access points are named network endpoints that are attached to buckets that
// you can use to perform S3 object operations.
type AwsS3AccessPointDetails struct {

	//  The Amazon Resource Name (ARN) of the access point.
	AccessPointArn *string

	//  The name or alias of the access point.
	Alias *string

	//  The name of the S3 bucket associated with the specified access point.
	Bucket *string

	//  The Amazon Web Services account ID associated with the S3 bucket associated
	// with this access point.
	BucketAccountId *string

	//  The name of the specified access point.
	Name *string

	//  Indicates whether this access point allows access from the public internet.
	NetworkOrigin *string

	// provides information about the Amazon S3 Public Access Block configuration for
	// accounts.
	PublicAccessBlockConfiguration *AwsS3AccountPublicAccessBlockDetails

	//  Contains the virtual private cloud (VPC) configuration for the specified
	// access point.
	VpcConfiguration *AwsS3AccessPointVpcConfigurationDetails

	noSmithyDocumentSerde
}

// The virtual private cloud (VPC) configuration for an Amazon S3 access point.
type AwsS3AccessPointVpcConfigurationDetails struct {

	//  If this field is specified, this access point will only allow connections from
	// the specified VPC ID.
	VpcId *string

	noSmithyDocumentSerde
}

// provides information about the Amazon S3 Public Access Block configuration for
// accounts.
type AwsS3AccountPublicAccessBlockDetails struct {

	// Indicates whether to reject calls to update an S3 bucket if the calls include a
	// public access control list (ACL).
	BlockPublicAcls *bool

	// Indicates whether to reject calls to update the access policy for an S3 bucket
	// or access point if the policy allows public access.
	BlockPublicPolicy *bool

	// Indicates whether Amazon S3 ignores public ACLs that are associated with an S3
	// bucket.
	IgnorePublicAcls *bool

	// Indicates whether to restrict access to an access point or S3 bucket that has a
	// public policy to only Amazon Web Services service principals and authorized
	// users within the S3 bucket owner's account.
	RestrictPublicBuckets *bool

	noSmithyDocumentSerde
}

// The lifecycle configuration for the objects in the S3 bucket.
type AwsS3BucketBucketLifecycleConfigurationDetails struct {

	// The lifecycle rules.
	Rules []AwsS3BucketBucketLifecycleConfigurationRulesDetails

	noSmithyDocumentSerde
}

// Information about what Amazon S3 does when a multipart upload is incomplete.
type AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails struct {

	// The number of days after which Amazon S3 cancels an incomplete multipart upload.
	DaysAfterInitiation *int32

	noSmithyDocumentSerde
}

// Configuration for a lifecycle rule.
type AwsS3BucketBucketLifecycleConfigurationRulesDetails struct {

	// How Amazon S3 responds when a multipart upload is incomplete. Specifically,
	// provides a number of days before Amazon S3 cancels the entire upload.
	AbortIncompleteMultipartUpload *AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails

	// The date when objects are moved or deleted.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ExpirationDate *string

	// The length in days of the lifetime for objects that are subject to the rule.
	ExpirationInDays *int32

	// Whether Amazon S3 removes a delete marker that has no noncurrent versions. If
	// set to true , the delete marker is expired. If set to false , the policy takes
	// no action.
	//
	// If you provide ExpiredObjectDeleteMarker , you cannot provide ExpirationInDays
	// or ExpirationDate .
	ExpiredObjectDeleteMarker *bool

	// Identifies the objects that a rule applies to.
	Filter *AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails

	// The unique identifier of the rule.
	ID *string

	// The number of days that an object is noncurrent before Amazon S3 can perform
	// the associated action.
	NoncurrentVersionExpirationInDays *int32

	// Transition rules that describe when noncurrent objects transition to a
	// specified storage class.
	NoncurrentVersionTransitions []AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails

	// A prefix that identifies one or more objects that the rule applies to.
	Prefix *string

	// The current status of the rule. Indicates whether the rule is currently being
	// applied.
	Status *string

	// Transition rules that indicate when objects transition to a specified storage
	// class.
	Transitions []AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails

	noSmithyDocumentSerde
}

// Identifies the objects that a rule applies to.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails struct {

	// The configuration for the filter.
	Predicate *AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails

	noSmithyDocumentSerde
}

// The configuration for the filter.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails struct {

	// The values to use for the filter.
	Operands []AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails

	// A prefix filter.
	Prefix *string

	// A tag filter.
	Tag *AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails

	// Whether to use AND or OR to join the operands. Valid values are
	// LifecycleAndOperator or LifecycleOrOperator .
	Type *string

	noSmithyDocumentSerde
}

// A value to use for the filter.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails struct {

	// Prefix text for matching objects.
	Prefix *string

	// A tag that is assigned to matching objects.
	Tag *AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails

	// The type of filter value. Valid values are LifecyclePrefixPredicate or
	// LifecycleTagPredicate .
	Type *string

	noSmithyDocumentSerde
}

// A tag that is assigned to matching objects.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails struct {

	// The tag key.
	Key *string

	// The tag value.
	Value *string

	noSmithyDocumentSerde
}

// A tag filter.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails struct {

	// The tag key.
	Key *string

	// The tag value
	Value *string

	noSmithyDocumentSerde
}

// A transition rule that describes when noncurrent objects transition to a
// specified storage class.
type AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails struct {

	// The number of days that an object is noncurrent before Amazon S3 can perform
	// the associated action.
	Days *int32

	// The class of storage to change the object to after the object is noncurrent for
	// the specified number of days.
	StorageClass *string

	noSmithyDocumentSerde
}

// A rule for when objects transition to specific storage classes.
type AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails struct {

	// A date on which to transition objects to the specified storage class. If you
	// provide Date , you cannot provide Days .
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	Date *string

	// The number of days after which to transition the object to the specified
	// storage class. If you provide Days , you cannot provide Date .
	Days *int32

	// The storage class to transition the object to. Valid values are as follows:
	//
	//   - DEEP_ARCHIVE
	//
	//   - GLACIER
	//
	//   - INTELLIGENT_TIERING
	//
	//   - ONEZONE_IA
	//
	//   - STANDARD_IA
	StorageClass *string

	noSmithyDocumentSerde
}

// Describes the versioning state of an S3 bucket.
type AwsS3BucketBucketVersioningConfiguration struct {

	// Specifies whether MFA delete is currently enabled in the S3 bucket versioning
	// configuration. If the S3 bucket was never configured with MFA delete, then this
	// attribute is not included.
	IsMfaDeleteEnabled *bool

	// The versioning status of the S3 bucket. Valid values are Enabled or Suspended .
	Status *string

	noSmithyDocumentSerde
}

// The details of an Amazon Simple Storage Service (Amazon S3) bucket.
type AwsS3BucketDetails struct {

	// The access control list for the S3 bucket.
	AccessControlList *string

	// The lifecycle configuration for objects in the specified bucket.
	BucketLifecycleConfiguration *AwsS3BucketBucketLifecycleConfigurationDetails

	// The logging configuration for the S3 bucket.
	BucketLoggingConfiguration *AwsS3BucketLoggingConfiguration

	// The notification configuration for the S3 bucket.
	BucketNotificationConfiguration *AwsS3BucketNotificationConfiguration

	// The versioning state of an S3 bucket.
	BucketVersioningConfiguration *AwsS3BucketBucketVersioningConfiguration

	// The website configuration parameters for the S3 bucket.
	BucketWebsiteConfiguration *AwsS3BucketWebsiteConfiguration

	// Indicates when the S3 bucket was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedAt *string

	//  The name of the bucket.
	Name *string

	//  Specifies which rule Amazon S3 applies by default to every new object placed
	// in the bucket.
	ObjectLockConfiguration *AwsS3BucketObjectLockConfiguration

	// The Amazon Web Services account identifier of the account that owns the S3
	// bucket.
	OwnerAccountId *string

	// The canonical user ID of the owner of the S3 bucket.
	OwnerId *string

	// The display name of the owner of the S3 bucket.
	OwnerName *string

	// Provides information about the Amazon S3 Public Access Block configuration for
	// the S3 bucket.
	PublicAccessBlockConfiguration *AwsS3AccountPublicAccessBlockDetails

	// The encryption rules that are applied to the S3 bucket.
	ServerSideEncryptionConfiguration *AwsS3BucketServerSideEncryptionConfiguration

	noSmithyDocumentSerde
}

// Information about logging for the S3 bucket
type AwsS3BucketLoggingConfiguration struct {

	// The name of the S3 bucket where log files for the S3 bucket are stored.
	DestinationBucketName *string

	// The prefix added to log files for the S3 bucket.
	LogFilePrefix *string

	noSmithyDocumentSerde
}

// The notification configuration for the S3 bucket.
type AwsS3BucketNotificationConfiguration struct {

	// Configurations for S3 bucket notifications.
	Configurations []AwsS3BucketNotificationConfigurationDetail

	noSmithyDocumentSerde
}

// Details for an S3 bucket notification configuration.
type AwsS3BucketNotificationConfigurationDetail struct {

	// The ARN of the Lambda function, Amazon SQS queue, or Amazon SNS topic that
	// generates the notification.
	Destination *string

	// The list of events that trigger a notification.
	Events []string

	// The filters that determine which S3 buckets generate notifications.
	Filter *AwsS3BucketNotificationConfigurationFilter

	// Indicates the type of notification. Notifications can be generated using Lambda
	// functions, Amazon SQS queues, or Amazon SNS topics, with corresponding valid
	// values as follows:
	//
	//   - LambdaConfiguration
	//
	//   - QueueConfiguration
	//
	//   - TopicConfiguration
	Type *string

	noSmithyDocumentSerde
}

// Filtering information for the notifications. The filtering is based on Amazon
// S3 key names.
type AwsS3BucketNotificationConfigurationFilter struct {

	// Details for an Amazon S3 filter.
	S3KeyFilter *AwsS3BucketNotificationConfigurationS3KeyFilter

	noSmithyDocumentSerde
}

// Details for an Amazon S3 filter.
type AwsS3BucketNotificationConfigurationS3KeyFilter struct {

	// The filter rules for the filter.
	FilterRules []AwsS3BucketNotificationConfigurationS3KeyFilterRule

	noSmithyDocumentSerde
}

// Details for a filter rule.
type AwsS3BucketNotificationConfigurationS3KeyFilterRule struct {

	// Indicates whether the filter is based on the prefix or suffix of the Amazon S3
	// key.
	Name AwsS3BucketNotificationConfigurationS3KeyFilterRuleName

	// The filter value.
	Value *string

	noSmithyDocumentSerde
}

//	The container element for S3 Object Lock configuration parameters. In Amazon
//
// S3, Object Lock can help prevent objects from being deleted or overwritten for a
// fixed amount of time or indefinitely.
type AwsS3BucketObjectLockConfiguration struct {

	//  Indicates whether the bucket has an Object Lock configuration enabled.
	ObjectLockEnabled *string

	//  Specifies the Object Lock rule for the specified object.
	Rule *AwsS3BucketObjectLockConfigurationRuleDetails

	noSmithyDocumentSerde
}

//	The default S3 Object Lock retention mode and period that you want to apply to
//
// new objects placed in the specified Amazon S3 bucket.
type AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails struct {

	//  The number of days that you want to specify for the default retention period.
	Days *int32

	//  The default Object Lock retention mode you want to apply to new objects placed
	// in the specified bucket.
	Mode *string

	//  The number of years that you want to specify for the default retention period.
	Years *int32

	noSmithyDocumentSerde
}

//	Specifies the S3 Object Lock rule for the specified object. In Amazon S3,
//
// Object Lock can help prevent objects from being deleted or overwritten for a
// fixed amount of time or indefinitely.
type AwsS3BucketObjectLockConfigurationRuleDetails struct {

	//  The default Object Lock retention mode and period that you want to apply to
	// new objects placed in the specified bucket.
	DefaultRetention *AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails

	noSmithyDocumentSerde
}

// Specifies the default server-side encryption to apply to new objects in the
// bucket.
type AwsS3BucketServerSideEncryptionByDefault struct {

	// KMS key ID to use for the default encryption.
	KMSMasterKeyID *string

	// Server-side encryption algorithm to use for the default encryption. Valid
	// values are aws: kms or AES256 .
	SSEAlgorithm *string

	noSmithyDocumentSerde
}

// The encryption configuration for the S3 bucket.
type AwsS3BucketServerSideEncryptionConfiguration struct {

	// The encryption rules that are applied to the S3 bucket.
	Rules []AwsS3BucketServerSideEncryptionRule

	noSmithyDocumentSerde
}

// An encryption rule to apply to the S3 bucket.
type AwsS3BucketServerSideEncryptionRule struct {

	// Specifies the default server-side encryption to apply to new objects in the
	// bucket. If a PUT object request doesn't specify any server-side encryption,
	// this default encryption is applied.
	ApplyServerSideEncryptionByDefault *AwsS3BucketServerSideEncryptionByDefault

	noSmithyDocumentSerde
}

// Website parameters for the S3 bucket.
type AwsS3BucketWebsiteConfiguration struct {

	// The name of the error document for the website.
	ErrorDocument *string

	// The name of the index document for the website.
	IndexDocumentSuffix *string

	// The redirect behavior for requests to the website.
	RedirectAllRequestsTo *AwsS3BucketWebsiteConfigurationRedirectTo

	// The rules for applying redirects for requests to the website.
	RoutingRules []AwsS3BucketWebsiteConfigurationRoutingRule

	noSmithyDocumentSerde
}

// The redirect behavior for requests to the website.
type AwsS3BucketWebsiteConfigurationRedirectTo struct {

	// The name of the host to redirect requests to.
	Hostname *string

	// The protocol to use when redirecting requests. By default, this field uses the
	// same protocol as the original request. Valid values are http or https .
	Protocol *string

	noSmithyDocumentSerde
}

// A rule for redirecting requests to the website.
type AwsS3BucketWebsiteConfigurationRoutingRule struct {

	// Provides the condition that must be met in order to apply the routing rule.
	Condition *AwsS3BucketWebsiteConfigurationRoutingRuleCondition

	// Provides the rules to redirect the request if the condition in Condition is met.
	Redirect *AwsS3BucketWebsiteConfigurationRoutingRuleRedirect

	noSmithyDocumentSerde
}

// The condition that must be met in order to apply the routing rule.
type AwsS3BucketWebsiteConfigurationRoutingRuleCondition struct {

	// Indicates to redirect the request if the HTTP error code matches this value.
	HttpErrorCodeReturnedEquals *string

	// Indicates to redirect the request if the key prefix matches this value.
	KeyPrefixEquals *string

	noSmithyDocumentSerde
}

// The rules to redirect the request if the condition in Condition is met.
type AwsS3BucketWebsiteConfigurationRoutingRuleRedirect struct {

	// The host name to use in the redirect request.
	Hostname *string

	// The HTTP redirect code to use in the response.
	HttpRedirectCode *string

	// The protocol to use to redirect the request. By default, uses the protocol from
	// the original request.
	Protocol *string

	// The object key prefix to use in the redirect request.
	//
	// Cannot be provided if ReplaceKeyWith is present.
	ReplaceKeyPrefixWith *string

	// The specific object key to use in the redirect request.
	//
	// Cannot be provided if ReplaceKeyPrefixWith is present.
	ReplaceKeyWith *string

	noSmithyDocumentSerde
}

// Details about an Amazon S3 object.
type AwsS3ObjectDetails struct {

	// A standard MIME type describing the format of the object data.
	ContentType *string

	// The opaque identifier assigned by a web server to a specific version of a
	// resource found at a URL.
	ETag *string

	// Indicates when the object was last modified.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastModified *string

	// The identifier of the KMS symmetric customer managed key that was used for the
	// object.
	SSEKMSKeyId *string

	// If the object is stored using server-side encryption, the value of the
	// server-side encryption algorithm used when storing this object in Amazon S3.
	ServerSideEncryption *string

	// The version of the object.
	VersionId *string

	noSmithyDocumentSerde
}

// Provides details about an Amazon SageMaker notebook instance.
type AwsSageMakerNotebookInstanceDetails struct {

	//  A list of Amazon Elastic Inference instance types to associate with the
	// notebook instance. Currently, only one instance type can be associated with a
	// notebook instance.
	AcceleratorTypes []string

	//  An array of up to three Git repositories associated with the notebook
	// instance. These can be either the names of Git repositories stored as resources
	// in your account, or the URL of Git repositories in [CodeCommit]or in any other Git
	// repository. These repositories are cloned at the same level as the default
	// repository of your notebook instance. For more information, see [Associating Git repositories with SageMaker notebook instances]in the Amazon
	// SageMaker Developer Guide.
	//
	// [Associating Git repositories with SageMaker notebook instances]: https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html
	// [CodeCommit]: https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html
	AdditionalCodeRepositories []string

	//  The Git repository associated with the notebook instance as its default code
	// repository. This can be either the name of a Git repository stored as a resource
	// in your account, or the URL of a Git repository in [CodeCommit]or in any other Git
	// repository. When you open a notebook instance, it opens in the directory that
	// contains this repository. For more information, see [Associating Git repositories with SageMaker notebook instances]in the Amazon SageMaker
	// Developer Guide.
	//
	// [Associating Git repositories with SageMaker notebook instances]: https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html
	// [CodeCommit]: https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html
	DefaultCodeRepository *string

	//  Sets whether SageMaker provides internet access to the notebook instance. If
	// you set this to Disabled , this notebook instance is able to access resources
	// only in your VPC, and is not be able to connect to SageMaker training and
	// endpoint services unless you configure a Network Address Translation (NAT)
	// Gateway in your VPC.
	DirectInternetAccess *string

	//  If status of the instance is Failed , the reason it failed.
	FailureReason *string

	//  Information on the IMDS configuration of the notebook instance.
	InstanceMetadataServiceConfiguration *AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails

	//  The type of machine learning (ML) compute instance to launch for the notebook
	// instance.
	InstanceType *string

	//  The Amazon Resource Name (ARN) of an Key Management Service (KMS) key that
	// SageMaker uses to encrypt data on the storage volume attached to your notebook
	// instance. The KMS key you provide must be enabled. For information, see [Enabling and disabling keys]in the
	// Key Management Service Developer Guide.
	//
	// [Enabling and disabling keys]: https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html
	KmsKeyId *string

	//  The network interface ID that SageMaker created when the instance was created.
	NetworkInterfaceId *string

	//  The Amazon Resource Name (ARN) of the notebook instance.
	NotebookInstanceArn *string

	//  The name of a notebook instance lifecycle configuration.
	NotebookInstanceLifecycleConfigName *string

	//  The name of the new notebook instance.
	NotebookInstanceName *string

	//  The status of the notebook instance.
	NotebookInstanceStatus *string

	//  The platform identifier of the notebook instance runtime environment.
	PlatformIdentifier *string

	//  The Amazon Resource Name (ARN) of the IAM role associated with the instance.
	RoleArn *string

	//  Whether root access is enabled or disabled for users of the notebook instance.
	RootAccess *string

	//  The VPC security group IDs.
	SecurityGroups []string

	//  The ID of the VPC subnet to which you have a connectivity from your ML compute
	// instance.
	SubnetId *string

	//  The URL that you use to connect to the Jupyter notebook that is running in
	// your notebook instance.
	Url *string

	//  The size, in GB, of the ML storage volume to attach to the notebook instance.
	VolumeSizeInGB *int32

	noSmithyDocumentSerde
}

//	Information on the instance metadata service (IMDS) configuration of the
//
// notebook instance.
type AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails struct {

	//  Indicates the minimum IMDS version that the notebook instance supports.
	MinimumInstanceMetadataServiceVersion *string

	noSmithyDocumentSerde
}

// Details about an Secrets Manager secret.
type AwsSecretsManagerSecretDetails struct {

	// Whether the secret is deleted.
	Deleted *bool

	// The user-provided description of the secret.
	Description *string

	// The ARN, Key ID, or alias of the KMS key used to encrypt the SecretString or
	// SecretBinary values for versions of this secret.
	KmsKeyId *string

	// The name of the secret.
	Name *string

	// Whether rotation is enabled.
	RotationEnabled *bool

	// The ARN of the Lambda function that rotates the secret.
	RotationLambdaArn *string

	// Whether the rotation occurred within the specified rotation frequency.
	RotationOccurredWithinFrequency *bool

	// Defines the rotation schedule for the secret.
	RotationRules *AwsSecretsManagerSecretRotationRules

	noSmithyDocumentSerde
}

// Defines the rotation schedule for the secret.
type AwsSecretsManagerSecretRotationRules struct {

	// The number of days after the previous rotation to rotate the secret.
	AutomaticallyAfterDays *int32

	noSmithyDocumentSerde
}

// Provides a consistent format for Security Hub findings. AwsSecurityFinding
// format allows you to share findings between Amazon Web Services security
// services and third-party solutions.
//
// A finding is a potential security issue generated either by Amazon Web Services
// services or by the integrated third-party solutions and standards checks.
type AwsSecurityFinding struct {

	// The Amazon Web Services account ID that a finding is generated in.
	//
	// Length Constraints: 12.
	//
	// This member is required.
	AwsAccountId *string

	// Indicates when the security findings provider created the potential security
	// issue that a finding captured.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	//
	// This member is required.
	CreatedAt *string

	// A finding's description. Description is a required property.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 1024.
	//
	// This member is required.
	Description *string

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plugin, or something
	// else.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 512.
	//
	// This member is required.
	GeneratorId *string

	// The security findings provider-specific identifier for a finding.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 512.
	//
	// This member is required.
	Id *string

	// The ARN generated by Security Hub that uniquely identifies a product that
	// generates findings. This can be the ARN for a third-party product that is
	// integrated with Security Hub, or the ARN for a custom integration.
	//
	// Length Constraints: Minimum length of 12. Maximum length of 2048.
	//
	// This member is required.
	ProductArn *string

	// A set of resource data types that describe the resources that the finding
	// refers to.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 32 items.
	//
	// This member is required.
	Resources []Resource

	// The schema version that a finding is formatted for. The value is 2018-10-08 .
	//
	// This member is required.
	SchemaVersion *string

	// A finding's title. Title is a required property.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 256.
	//
	// This member is required.
	Title *string

	// Indicates when the security findings provider last updated the finding record.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	//
	// This member is required.
	UpdatedAt *string

	// Provides details about an action that affects or that was taken on a resource.
	Action *Action

	// The name of the Amazon Web Services account from which a finding was generated.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 50.
	AwsAccountName *string

	// The name of the company for the product that generated the finding.
	//
	// Security Hub populates this attribute automatically for each finding. You
	// cannot update this attribute with BatchImportFindings or BatchUpdateFindings .
	// The exception to this is a custom integration.
	//
	// When you use the Security Hub console or API to filter findings by company
	// name, you use this attribute.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 128.
	CompanyName *string

	// This data type is exclusive to findings that are generated as the result of a
	// check run against a specific rule in a supported security standard, such as CIS
	// Amazon Web Services Foundations. Contains security standard-related finding
	// details.
	Compliance *Compliance

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero
	// percent confidence and 100 means 100 percent confidence.
	Confidence *int32

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and a
	// score of 100 is reserved for the most critical resources.
	Criticality *int32

	// In a BatchImportFindings request, finding providers use FindingProviderFields
	// to provide and update their own values for confidence, criticality, related
	// findings, severity, and types.
	FindingProviderFields *FindingProviderFields

	// Indicates when the security findings provider first observed the potential
	// security issue that a finding captured.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	FirstObservedAt *string

	// Provides metadata for the Amazon CodeGuru detector associated with a finding.
	// This field pertains to findings that relate to Lambda functions. Amazon
	// Inspector identifies policy violations and vulnerabilities in Lambda function
	// code based on internal detectors developed in collaboration with Amazon
	// CodeGuru. Security Hub receives those findings.
	GeneratorDetails *GeneratorDetails

	// Indicates when the security findings provider most recently observed the
	// potential security issue that a finding captured.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastObservedAt *string

	// A list of malware related to a finding.
	//
	// Array Members: Maximum number of 5 items.
	Malware []Malware

	// The details of network-related information about a finding.
	Network *Network

	// Provides information about a network path that is relevant to a finding. Each
	// entry under NetworkPath represents a component of that path.
	NetworkPath []NetworkPathComponent

	// A user-defined note added to a finding.
	Note *Note

	// Provides an overview of the patch compliance status for an instance against a
	// selected compliance standard.
	PatchSummary *PatchSummary

	// The details of process-related information about a finding.
	Process *ProcessDetails

	// A timestamp that indicates when Security Hub received a finding and begins to
	// process it.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ProcessedAt *string

	// A data type where security findings providers can include additional
	// solution-specific details that aren't part of the defined AwsSecurityFinding
	// format.
	//
	// Can contain up to 50 key-value pairs. For each key-value pair, the key can
	// contain up to 128 characters, and the value can contain up to 2048 characters.
	ProductFields map[string]string

	// The name of the product that generated the finding.
	//
	// Security Hub populates this attribute automatically for each finding. You
	// cannot update this attribute with BatchImportFindings or BatchUpdateFindings .
	// The exception to this is a custom integration.
	//
	// When you use the Security Hub console or API to filter findings by product
	// name, you use this attribute.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 128.
	ProductName *string

	// The record state of a finding.
	RecordState RecordState

	// The Region from which the finding was generated.
	//
	// Security Hub populates this attribute automatically for each finding. You
	// cannot update it using BatchImportFindings or BatchUpdateFindings .
	//
	// Length Constraints: Minimum length of 1. Maximum length of 16.
	Region *string

	// A list of related findings.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 10 items.
	RelatedFindings []RelatedFinding

	// A data type that describes the remediation options for a finding.
	Remediation *Remediation

	// Indicates whether the finding is a sample finding.
	Sample *bool

	// A finding's severity.
	Severity *Severity

	// A URL that links to a page about the current finding in the security findings
	// provider's solution.
	SourceUrl *string

	// Threat intelligence details related to a finding.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 5 items.
	ThreatIntelIndicators []ThreatIntelIndicator

	// Details about the threat detected in a security finding and the file paths that
	// were affected by the threat.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 32 items.
	Threats []Threat

	// One or more finding types in the format of namespace/category/classifier that
	// classify a finding.
	//
	// Valid namespace values are: Software and Configuration Checks | TTPs | Effects
	// | Unusual Behaviors | Sensitive Data Identifications
	//
	// Array Members: Maximum number of 50 items.
	Types []string

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	//
	// Can contain up to 50 key-value pairs. For each key-value pair, the key can
	// contain up to 128 characters, and the value can contain up to 1024 characters.
	UserDefinedFields map[string]string

	// Indicates the veracity of a finding.
	VerificationState VerificationState

	// Provides a list of vulnerabilities associated with the findings.
	Vulnerabilities []Vulnerability

	// Provides information about the status of the investigation into a finding.
	Workflow *Workflow

	// The workflow state of a finding.
	//
	// Deprecated: This filter is deprecated. Instead, use SeverityLabel or
	// FindingProviderFieldsSeverityLabel.
	WorkflowState WorkflowState

	noSmithyDocumentSerde
}

// A collection of filters that are applied to all active findings aggregated by
// Security Hub.
//
// You can filter by up to ten finding attributes. For each attribute, you can
// provide up to 20 filter values.
type AwsSecurityFindingFilters struct {

	// The Amazon Web Services account ID in which a finding is generated.
	AwsAccountId []StringFilter

	// The name of the Amazon Web Services account in which a finding is generated.
	AwsAccountName []StringFilter

	// The name of the findings provider (company) that owns the solution (product)
	// that generates findings.
	CompanyName []StringFilter

	//  The unique identifier of a standard in which a control is enabled. This field
	// consists of the resource portion of the Amazon Resource Name (ARN) returned for
	// a standard in the [DescribeStandards]API response.
	//
	// [DescribeStandards]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html
	ComplianceAssociatedStandardsId []StringFilter

	//  The unique identifier of a control across standards. Values for this field
	// typically consist of an Amazon Web Service and a number, such as APIGateway.5.
	ComplianceSecurityControlId []StringFilter

	//  The name of a security control parameter.
	ComplianceSecurityControlParametersName []StringFilter

	//  The current value of a security control parameter.
	ComplianceSecurityControlParametersValue []StringFilter

	// Exclusive to findings that are generated as the result of a check run against a
	// specific rule in a supported standard, such as CIS Amazon Web Services
	// Foundations. Contains security standard-related finding details.
	ComplianceStatus []StringFilter

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero
	// percent confidence and 100 means 100 percent confidence.
	Confidence []NumberFilter

	// A timestamp that indicates when the security findings provider created the
	// potential security issue that a finding reflects.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	CreatedAt []DateFilter

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and a
	// score of 100 is reserved for the most critical resources.
	Criticality []NumberFilter

	// A finding's description.
	Description []StringFilter

	// The finding provider value for the finding confidence. Confidence is defined as
	// the likelihood that a finding accurately identifies the behavior or issue that
	// it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero
	// percent confidence and 100 means 100 percent confidence.
	FindingProviderFieldsConfidence []NumberFilter

	// The finding provider value for the level of importance assigned to the
	// resources associated with the findings.
	//
	// A score of 0 means that the underlying resources have no criticality, and a
	// score of 100 is reserved for the most critical resources.
	FindingProviderFieldsCriticality []NumberFilter

	// The finding identifier of a related finding that is identified by the finding
	// provider.
	FindingProviderFieldsRelatedFindingsId []StringFilter

	// The ARN of the solution that generated a related finding that is identified by
	// the finding provider.
	FindingProviderFieldsRelatedFindingsProductArn []StringFilter

	// The finding provider value for the severity label.
	FindingProviderFieldsSeverityLabel []StringFilter

	// The finding provider's original value for the severity.
	FindingProviderFieldsSeverityOriginal []StringFilter

	// One or more finding types that the finding provider assigned to the finding.
	// Uses the format of namespace/category/classifier that classify a finding.
	//
	// Valid namespace values are: Software and Configuration Checks | TTPs | Effects
	// | Unusual Behaviors | Sensitive Data Identifications
	FindingProviderFieldsTypes []StringFilter

	// A timestamp that indicates when the security findings provider first observed
	// the potential security issue that a finding captured.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	FirstObservedAt []DateFilter

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plugin, etc.
	GeneratorId []StringFilter

	// The security findings provider-specific identifier for a finding.
	Id []StringFilter

	// A keyword for a finding.
	//
	// Deprecated: The Keyword property is deprecated.
	Keyword []KeywordFilter

	// A timestamp that indicates when the security findings provider most recently
	// observed the potential security issue that a finding captured.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastObservedAt []DateFilter

	// The name of the malware that was observed.
	MalwareName []StringFilter

	// The filesystem path of the malware that was observed.
	MalwarePath []StringFilter

	// The state of the malware that was observed.
	MalwareState []StringFilter

	// The type of the malware that was observed.
	MalwareType []StringFilter

	// The destination domain of network-related information about a finding.
	NetworkDestinationDomain []StringFilter

	// The destination IPv4 address of network-related information about a finding.
	NetworkDestinationIpV4 []IpFilter

	// The destination IPv6 address of network-related information about a finding.
	NetworkDestinationIpV6 []IpFilter

	// The destination port of network-related information about a finding.
	NetworkDestinationPort []NumberFilter

	// Indicates the direction of network traffic associated with a finding.
	NetworkDirection []StringFilter

	// The protocol of network-related information about a finding.
	NetworkProtocol []StringFilter

	// The source domain of network-related information about a finding.
	NetworkSourceDomain []StringFilter

	// The source IPv4 address of network-related information about a finding.
	NetworkSourceIpV4 []IpFilter

	// The source IPv6 address of network-related information about a finding.
	NetworkSourceIpV6 []IpFilter

	// The source media access control (MAC) address of network-related information
	// about a finding.
	NetworkSourceMac []StringFilter

	// The source port of network-related information about a finding.
	NetworkSourcePort []NumberFilter

	// The text of a note.
	NoteText []StringFilter

	// The timestamp of when the note was updated.
	NoteUpdatedAt []DateFilter

	// The principal that created a note.
	NoteUpdatedBy []StringFilter

	// A timestamp that identifies when the process was launched.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ProcessLaunchedAt []DateFilter

	// The name of the process.
	ProcessName []StringFilter

	// The parent process ID. This field accepts positive integers between O and
	// 2147483647 .
	ProcessParentPid []NumberFilter

	// The path to the process executable.
	ProcessPath []StringFilter

	// The process ID.
	ProcessPid []NumberFilter

	// A timestamp that identifies when the process was terminated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ProcessTerminatedAt []DateFilter

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security findings provider) after this provider's product (solution
	// that generates findings) is registered with Security Hub.
	ProductArn []StringFilter

	// A data type where security findings providers can include additional
	// solution-specific details that aren't part of the defined AwsSecurityFinding
	// format.
	ProductFields []MapFilter

	// The name of the solution (product) that generates findings.
	ProductName []StringFilter

	// The recommendation of what to do about the issue described in a finding.
	RecommendationText []StringFilter

	// The updated record state for the finding.
	RecordState []StringFilter

	// The Region from which the finding was generated.
	Region []StringFilter

	// The solution-generated identifier for a related finding.
	RelatedFindingsId []StringFilter

	// The ARN of the solution that generated a related finding.
	RelatedFindingsProductArn []StringFilter

	//  The ARN of the application that is related to a finding.
	ResourceApplicationArn []StringFilter

	//  The name of the application that is related to a finding.
	ResourceApplicationName []StringFilter

	// The IAM profile ARN of the instance.
	ResourceAwsEc2InstanceIamInstanceProfileArn []StringFilter

	// The Amazon Machine Image (AMI) ID of the instance.
	ResourceAwsEc2InstanceImageId []StringFilter

	// The IPv4 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV4Addresses []IpFilter

	// The IPv6 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV6Addresses []IpFilter

	// The key name associated with the instance.
	ResourceAwsEc2InstanceKeyName []StringFilter

	// The date and time the instance was launched.
	ResourceAwsEc2InstanceLaunchedAt []DateFilter

	// The identifier of the subnet that the instance was launched in.
	ResourceAwsEc2InstanceSubnetId []StringFilter

	// The instance type of the instance.
	ResourceAwsEc2InstanceType []StringFilter

	// The identifier of the VPC that the instance was launched in.
	ResourceAwsEc2InstanceVpcId []StringFilter

	// The creation date/time of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyCreatedAt []DateFilter

	// The name of the principal that is associated with an IAM access key.
	ResourceAwsIamAccessKeyPrincipalName []StringFilter

	// The status of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyStatus []StringFilter

	// The user associated with the IAM access key related to a finding.
	//
	// Deprecated: This filter is deprecated. Instead, use
	// ResourceAwsIamAccessKeyPrincipalName.
	ResourceAwsIamAccessKeyUserName []StringFilter

	// The name of an IAM user.
	ResourceAwsIamUserUserName []StringFilter

	// The canonical user ID of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerId []StringFilter

	// The display name of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerName []StringFilter

	// The identifier of the image related to a finding.
	ResourceContainerImageId []StringFilter

	// The name of the image related to a finding.
	ResourceContainerImageName []StringFilter

	// A timestamp that identifies when the container was started.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	ResourceContainerLaunchedAt []DateFilter

	// The name of the container related to a finding.
	ResourceContainerName []StringFilter

	// The details of a resource that doesn't have a specific subfield for the
	// resource type defined.
	ResourceDetailsOther []MapFilter

	// The canonical identifier for the given resource type.
	ResourceId []StringFilter

	// The canonical Amazon Web Services partition name that the Region is assigned to.
	ResourcePartition []StringFilter

	// The canonical Amazon Web Services external Region name where this resource is
	// located.
	ResourceRegion []StringFilter

	// A list of Amazon Web Services tags associated with a resource at the time the
	// finding was processed.
	ResourceTags []MapFilter

	// Specifies the type of the resource that details are provided for.
	ResourceType []StringFilter

	// Indicates whether or not sample findings are included in the filter results.
	Sample []BooleanFilter

	// The label of a finding's severity.
	SeverityLabel []StringFilter

	// The normalized severity of a finding.
	//
	// Deprecated: This filter is deprecated. Instead, use SeverityLabel or
	// FindingProviderFieldsSeverityLabel.
	SeverityNormalized []NumberFilter

	// The native severity as defined by the security findings provider's solution
	// that generated the finding.
	//
	// Deprecated: This filter is deprecated. Instead, use
	// FindingProviderSeverityOriginal.
	SeverityProduct []NumberFilter

	// A URL that links to a page about the current finding in the security findings
	// provider's solution.
	SourceUrl []StringFilter

	// The category of a threat intelligence indicator.
	ThreatIntelIndicatorCategory []StringFilter

	// A timestamp that identifies the last observation of a threat intelligence
	// indicator.
	ThreatIntelIndicatorLastObservedAt []DateFilter

	// The source of the threat intelligence.
	ThreatIntelIndicatorSource []StringFilter

	// The URL for more details from the source of the threat intelligence.
	ThreatIntelIndicatorSourceUrl []StringFilter

	// The type of a threat intelligence indicator.
	ThreatIntelIndicatorType []StringFilter

	// The value of a threat intelligence indicator.
	ThreatIntelIndicatorValue []StringFilter

	// A finding's title.
	Title []StringFilter

	// A finding type in the format of namespace/category/classifier that classifies a
	// finding.
	Type []StringFilter

	// A timestamp that indicates when the security findings provider last updated the
	// finding record.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	UpdatedAt []DateFilter

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields []MapFilter

	// The veracity of a finding.
	VerificationState []StringFilter

	//  Indicates whether a software vulnerability in your environment has a known
	// exploit. You can filter findings by this field only if you use Security Hub and
	// Amazon Inspector.
	VulnerabilitiesExploitAvailable []StringFilter

	//  Indicates whether a vulnerability is fixed in a newer version of the affected
	// software packages. You can filter findings by this field only if you use
	// Security Hub and Amazon Inspector.
	VulnerabilitiesFixAvailable []StringFilter

	// The workflow state of a finding.
	//
	// Note that this field is deprecated. To search for a finding based on its
	// workflow status, use WorkflowStatus .
	WorkflowState []StringFilter

	// The status of the investigation into a finding. Allowed values are the
	// following.
	//
	//   - NEW - The initial state of a finding, before it is reviewed.
	//
	// Security Hub also resets the workflow status from NOTIFIED or RESOLVED to NEW in
	//   the following cases:
	//
	//   - RecordState changes from ARCHIVED to ACTIVE .
	//
	//   - Compliance.Status changes from PASSED to either WARNING , FAILED , or
	//   NOT_AVAILABLE .
	//
	//   - NOTIFIED - Indicates that the resource owner has been notified about the
	//   security issue. Used when the initial reviewer is not the resource owner, and
	//   needs intervention from the resource owner.
	//
	// If one of the following occurs, the workflow status is changed automatically
	//   from NOTIFIED to NEW :
	//
	//   - RecordState changes from ARCHIVED to ACTIVE .
	//
	//   - Compliance.Status changes from PASSED to FAILED , WARNING , or NOT_AVAILABLE
	//   .
	//
	//   - SUPPRESSED - Indicates that you reviewed the finding and do not believe that
	//   any action is needed.
	//
	// The workflow status of a SUPPRESSED finding does not change if RecordState
	//   changes from ARCHIVED to ACTIVE .
	//
	//   - RESOLVED - The finding was reviewed and remediated and is now considered
	//   resolved.
	//
	// The finding remains RESOLVED unless one of the following occurs:
	//
	//   - RecordState changes from ARCHIVED to ACTIVE .
	//
	//   - Compliance.Status changes from PASSED to FAILED , WARNING , or NOT_AVAILABLE
	//   .
	//
	// In those cases, the workflow status is automatically reset to NEW .
	//
	// For findings from controls, if Compliance.Status is PASSED , then Security Hub
	//   automatically sets the workflow status to RESOLVED .
	WorkflowStatus []StringFilter

	noSmithyDocumentSerde
}

// Identifies which finding to get the finding history for.
type AwsSecurityFindingIdentifier struct {

	// The identifier of the finding that was specified by the finding provider.
	//
	// This member is required.
	Id *string

	// The ARN generated by Security Hub that uniquely identifies a product that
	// generates findings. This can be the ARN for a third-party product that is
	// integrated with Security Hub, or the ARN for a custom integration.
	//
	// This member is required.
	ProductArn *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon SNS topic to which notifications can be
// published.
type AwsSnsTopicDetails struct {

	// Indicates failed message delivery status for an Amazon SNS topic that is
	// subscribed to a platform application endpoint.
	ApplicationSuccessFeedbackRoleArn *string

	// Indicates failed message delivery status for an Amazon SNS topic that is
	// subscribed to an Amazon Kinesis Data Firehose endpoint.
	FirehoseFailureFeedbackRoleArn *string

	// Indicates successful message delivery status for an Amazon SNS topic that is
	// subscribed to an Amazon Kinesis Data Firehose endpoint.
	FirehoseSuccessFeedbackRoleArn *string

	// Indicates failed message delivery status for an Amazon SNS topic that is
	// subscribed to an HTTP endpoint.
	HttpFailureFeedbackRoleArn *string

	// Indicates successful message delivery status for an Amazon SNS topic that is
	// subscribed to an HTTP endpoint.
	HttpSuccessFeedbackRoleArn *string

	// The ID of an Amazon Web Services managed key for Amazon SNS or a customer
	// managed key.
	KmsMasterKeyId *string

	// The subscription's owner.
	Owner *string

	// Indicates failed message delivery status for an Amazon SNS topic that is
	// subscribed to an Amazon SQS endpoint.
	SqsFailureFeedbackRoleArn *string

	// Indicates successful message delivery status for an Amazon SNS topic that is
	// subscribed to an Amazon SQS endpoint.
	SqsSuccessFeedbackRoleArn *string

	// Subscription is an embedded property that describes the subscription endpoints
	// of an Amazon SNS topic.
	Subscription []AwsSnsTopicSubscription

	// The name of the Amazon SNS topic.
	TopicName *string

	noSmithyDocumentSerde
}

// A wrapper type for the attributes of an Amazon SNS subscription.
type AwsSnsTopicSubscription struct {

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string

	// The subscription's protocol.
	Protocol *string

	noSmithyDocumentSerde
}

// Data about a queue.
type AwsSqsQueueDetails struct {

	// The ARN of the dead-letter queue to which Amazon SQS moves messages after the
	// value of maxReceiveCount is exceeded.
	DeadLetterTargetArn *string

	// The length of time, in seconds, for which Amazon SQS can reuse a data key to
	// encrypt or decrypt messages before calling KMS again.
	KmsDataKeyReusePeriodSeconds *int32

	// The ID of an Amazon Web Services managed key for Amazon SQS or a custom KMS key.
	KmsMasterKeyId *string

	// The name of the new queue.
	QueueName *string

	noSmithyDocumentSerde
}

// Provides the details about the compliance status for a patch.
type AwsSsmComplianceSummary struct {

	// The type of resource for which the compliance was determined. For
	// AwsSsmPatchCompliance , ComplianceType is Patch .
	ComplianceType *string

	// For the patches that are compliant, the number that have a severity of CRITICAL .
	CompliantCriticalCount *int32

	// For the patches that are compliant, the number that have a severity of HIGH .
	CompliantHighCount *int32

	// For the patches that are compliant, the number that have a severity of
	// INFORMATIONAL .
	CompliantInformationalCount *int32

	// For the patches that are compliant, the number that have a severity of LOW .
	CompliantLowCount *int32

	// For the patches that are compliant, the number that have a severity of MEDIUM .
	CompliantMediumCount *int32

	// For the patches that are compliant, the number that have a severity of
	// UNSPECIFIED .
	CompliantUnspecifiedCount *int32

	// The type of execution that was used determine compliance.
	ExecutionType *string

	// For the patch items that are noncompliant, the number of items that have a
	// severity of CRITICAL .
	NonCompliantCriticalCount *int32

	// For the patches that are noncompliant, the number that have a severity of HIGH .
	NonCompliantHighCount *int32

	// For the patches that are noncompliant, the number that have a severity of
	// INFORMATIONAL .
	NonCompliantInformationalCount *int32

	// For the patches that are noncompliant, the number that have a severity of LOW .
	NonCompliantLowCount *int32

	// For the patches that are noncompliant, the number that have a severity of MEDIUM
	// .
	NonCompliantMediumCount *int32

	// For the patches that are noncompliant, the number that have a severity of
	// UNSPECIFIED .
	NonCompliantUnspecifiedCount *int32

	// The highest severity for the patches. Valid values are as follows:
	//
	//   - CRITICAL
	//
	//   - HIGH
	//
	//   - MEDIUM
	//
	//   - LOW
	//
	//   - INFORMATIONAL
	//
	//   - UNSPECIFIED
	OverallSeverity *string

	// The identifier of the patch baseline. The patch baseline lists the patches that
	// are approved for installation.
	PatchBaselineId *string

	// The identifier of the patch group for which compliance was determined. A patch
	// group uses tags to group EC2 instances that should have the same patch
	// compliance.
	PatchGroup *string

	// The current patch compliance status. Valid values are as follows:
	//
	//   - COMPLIANT
	//
	//   - NON_COMPLIANT
	//
	//   - UNSPECIFIED_DATA
	Status *string

	noSmithyDocumentSerde
}

// Provides details about the compliance for a patch.
type AwsSsmPatch struct {

	// The compliance status details for the patch.
	ComplianceSummary *AwsSsmComplianceSummary

	noSmithyDocumentSerde
}

// Provides information about the state of a patch on an instance based on the
// patch baseline that was used to patch the instance.
type AwsSsmPatchComplianceDetails struct {

	// Information about the status of a patch.
	Patch *AwsSsmPatch

	noSmithyDocumentSerde
}

//	Provides details about an Step Functions state machine, which is a workflow
//
// consisting of a series of event- driven steps.
type AwsStepFunctionStateMachineDetails struct {

	//  A user-defined or an auto-generated string that identifies a Map state. This
	// parameter is present only if the stateMachineArn specified in input is a
	// qualified state machine ARN.
	Label *string

	//  Used to set CloudWatch Logs options.
	LoggingConfiguration *AwsStepFunctionStateMachineLoggingConfigurationDetails

	//  The name of the state machine.
	Name *string

	//  The Amazon Resource Name (ARN) of the IAM role used when creating this state
	// machine.
	RoleArn *string

	//  The ARN that identifies the state machine.
	StateMachineArn *string

	//  The current status of the state machine.
	Status *string

	//  Specifies whether X-Ray tracing is enabled.
	TracingConfiguration *AwsStepFunctionStateMachineTracingConfigurationDetails

	//  The type of the state machine (STANDARD or EXPRESS).
	Type *string

	noSmithyDocumentSerde
}

//	An object describing a CloudWatch log group. For more information, see [Amazon Web Services::Logs::LogGroup] in the
//
// CloudFormation User Guide.
//
// [Amazon Web Services::Logs::LogGroup]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html
type AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails struct {

	// The ARN (ends with :* ) of the CloudWatch Logs log group to which you want your
	// logs emitted.
	LogGroupArn *string

	noSmithyDocumentSerde
}

//	An array of objects that describes where your execution history events will be
//
// logged.
type AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails struct {

	//  An object describing a CloudWatch Logs log group. For more information, see [Amazon Web Services::Logs::LogGroup]
	// in the CloudFormation User Guide.
	//
	// [Amazon Web Services::Logs::LogGroup]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html
	CloudWatchLogsLogGroup *AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails

	noSmithyDocumentSerde
}

// The LoggingConfiguration data type is used to set CloudWatch Logs options.
type AwsStepFunctionStateMachineLoggingConfigurationDetails struct {

	//  An array of objects that describes where your execution history events will be
	// logged.
	Destinations []AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails

	//  Determines whether execution data is included in your log. When set to false,
	// data is excluded.
	IncludeExecutionData *bool

	//  Defines which category of execution history events are logged.
	Level *string

	noSmithyDocumentSerde
}

// Specifies whether X-Ray tracing is enabled.
type AwsStepFunctionStateMachineTracingConfigurationDetails struct {

	//  When set to true, X-Ray tracing is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Details about a rate-based rule for global resources. A rate-based rule
// provides settings to indicate when to allow, block, or count a request.
// Rate-based rules include the number of requests that arrive over a specified
// period of time.
type AwsWafRateBasedRuleDetails struct {

	// The predicates to include in the rate-based rule.
	MatchPredicates []AwsWafRateBasedRuleMatchPredicate

	// The name of the metrics for the rate-based rule.
	MetricName *string

	// The name of the rate-based rule.
	Name *string

	// The field that WAF uses to determine whether requests are likely arriving from
	// single source and are subject to rate monitoring.
	RateKey *string

	// The maximum number of requests that have an identical value for the field
	// specified in RateKey that are allowed within a five-minute period. If the
	// number of requests exceeds RateLimit and the other predicates specified in the
	// rule are met, WAF triggers the action for the rule.
	RateLimit *int64

	// The unique identifier for the rate-based rule.
	RuleId *string

	noSmithyDocumentSerde
}

// A match predicate. A predicate might look for characteristics such as specific
// IP addresses, geographic locations, or sizes.
type AwsWafRateBasedRuleMatchPredicate struct {

	// The unique identifier for the predicate.
	DataId *string

	// If set to true , then the rule actions are performed on requests that match the
	// predicate settings.
	//
	// If set to false , then the rule actions are performed on all requests except
	// those that match the predicate settings.
	Negated *bool

	// The type of predicate. Valid values are as follows:
	//
	//   - ByteMatch
	//
	//   - GeoMatch
	//
	//   - IPMatch
	//
	//   - RegexMatch
	//
	//   - SizeConstraint
	//
	//   - SqlInjectionMatch
	//
	//   - XssMatch
	Type *string

	noSmithyDocumentSerde
}

// contains details about a rate-based rule for Regional resources. A rate-based
// rule provides settings to indicate when to allow, block, or count a request.
// Rate-based rules include the number of requests that arrive over a specified
// period of time.
type AwsWafRegionalRateBasedRuleDetails struct {

	// The predicates to include in the rate-based rule.
	MatchPredicates []AwsWafRegionalRateBasedRuleMatchPredicate

	// The name of the metrics for the rate-based rule.
	MetricName *string

	// The name of the rate-based rule.
	Name *string

	// The field that WAF uses to determine whether requests are likely arriving from
	// single source and are subject to rate monitoring.
	RateKey *string

	// The maximum number of requests that have an identical value for the field
	// specified in RateKey that are allowed within a five-minute period. If the
	// number of requests exceeds RateLimit and the other predicates specified in the
	// rule are met, WAF triggers the action for the rule.
	RateLimit *int64

	// The unique identifier for the rate-based rule.
	RuleId *string

	noSmithyDocumentSerde
}

// Details for a match predicate. A predicate might look for characteristics such
// as specific IP addresses, geographic locations, or sizes.
type AwsWafRegionalRateBasedRuleMatchPredicate struct {

	// The unique identifier for the predicate.
	DataId *string

	// If set to true , then the rule actions are performed on requests that match the
	// predicate settings.
	//
	// If set to false , then the rule actions are performed on all requests except
	// those that match the predicate settings.
	Negated *bool

	// The type of predicate. Valid values are as follows:
	//
	//   - ByteMatch
	//
	//   - GeoMatch
	//
	//   - IPMatch
	//
	//   - RegexMatch
	//
	//   - SizeConstraint
	//
	//   - SqlInjectionMatch
	//
	//   - XssMatch
	Type *string

	noSmithyDocumentSerde
}

// Provides information about an WAF Regional rule. This rule identifies the web
// requests that you want to allow, block, or count.
type AwsWafRegionalRuleDetails struct {

	// A name for the metrics for the rule.
	MetricName *string

	// A descriptive name for the rule.
	Name *string

	// Specifies the ByteMatchSet , IPSet , SqlInjectionMatchSet , XssMatchSet ,
	// RegexMatchSet , GeoMatchSet , and SizeConstraintSet objects that you want to
	// add to a rule and, for each object, indicates whether you want to negate the
	// settings.
	PredicateList []AwsWafRegionalRulePredicateListDetails

	// The ID of the rule.
	RuleId *string

	noSmithyDocumentSerde
}

// Provides information about an WAF Regional rule group. The rule group is a
// collection of rules for inspecting and controlling web requests.
type AwsWafRegionalRuleGroupDetails struct {

	// A name for the metrics for this rule group.
	MetricName *string

	// The descriptive name of the rule group.
	Name *string

	// The ID of the rule group.
	RuleGroupId *string

	// Provides information about the rule statements used to identify the web
	// requests that you want to allow, block, or count.
	Rules []AwsWafRegionalRuleGroupRulesDetails

	noSmithyDocumentSerde
}

// Describes the action that WAF should take on a web request when it matches the
// criteria defined in the rule.
type AwsWafRegionalRuleGroupRulesActionDetails struct {

	// Specifies the ByteMatchSet , IPSet , SqlInjectionMatchSet , XssMatchSet ,
	// RegexMatchSet , GeoMatchSet , and SizeConstraintSet objects that you want to
	// add to a rule and, for each object, indicates whether you want to negate the
	// settings.
	Type *string

	noSmithyDocumentSerde
}

// Provides information about the rules attached to a rule group
type AwsWafRegionalRuleGroupRulesDetails struct {

	// The action that WAF should take on a web request when it matches the criteria
	// defined in the rule.
	Action *AwsWafRegionalRuleGroupRulesActionDetails

	// If you define more than one rule in a web ACL, WAF evaluates each request
	// against the rules in order based on the value of Priority .
	Priority *int32

	// The ID for a rule.
	RuleId *string

	// The type of rule in the rule group.
	Type *string

	noSmithyDocumentSerde
}

// Provides details about the ByteMatchSet , IPSet , SqlInjectionMatchSet ,
// XssMatchSet , RegexMatchSet , GeoMatchSet , and SizeConstraintSet objects that
// you want to add to a rule and, for each object, indicates whether you want to
// negate the settings.
type AwsWafRegionalRulePredicateListDetails struct {

	// A unique identifier for a predicate in a rule, such as ByteMatchSetId or IPSetId
	// .
	DataId *string

	// Specifies if you want WAF to allow, block, or count requests based on the
	// settings in the ByteMatchSet , IPSet , SqlInjectionMatchSet , XssMatchSet ,
	// RegexMatchSet , GeoMatchSet , or SizeConstraintSet .
	Negated *bool

	// The type of predicate in a rule, such as ByteMatch or IPSet .
	Type *string

	noSmithyDocumentSerde
}

// Provides information about the web access control list (web ACL). The web ACL
// contains the rules that identify the requests that you want to allow, block, or
// count.
type AwsWafRegionalWebAclDetails struct {

	// The action to perform if none of the rules contained in the web ACL match.
	DefaultAction *string

	// A name for the metrics for this web ACL.
	MetricName *string

	// A descriptive name for the web ACL.
	Name *string

	// An array that contains the action for each rule in a web ACL, the priority of
	// the rule, and the ID of the rule.
	RulesList []AwsWafRegionalWebAclRulesListDetails

	// The ID of the web ACL.
	WebAclId *string

	noSmithyDocumentSerde
}

// The action that WAF takes when a web request matches all conditions in the
// rule, such as allow, block, or count the request.
type AwsWafRegionalWebAclRulesListActionDetails struct {

	// For actions that are associated with a rule, the action that WAF takes when a
	// web request matches all conditions in a rule.
	Type *string

	noSmithyDocumentSerde
}

// A combination of ByteMatchSet , IPSet , and/or SqlInjectionMatchSet objects
// that identify the web requests that you want to allow, block, or count.
type AwsWafRegionalWebAclRulesListDetails struct {

	// The action that WAF takes when a web request matches all conditions in the
	// rule, such as allow, block, or count the request.
	Action *AwsWafRegionalWebAclRulesListActionDetails

	// Overrides the rule evaluation result in the rule group.
	OverrideAction *AwsWafRegionalWebAclRulesListOverrideActionDetails

	// The order in which WAF evaluates the rules in a web ACL.
	Priority *int32

	// The ID of an WAF Regional rule to associate with a web ACL.
	RuleId *string

	// For actions that are associated with a rule, the action that WAF takes when a
	// web request matches all conditions in a rule.
	Type *string

	noSmithyDocumentSerde
}

// Provides details about the action to use in the place of the action that
// results from the rule group evaluation.
type AwsWafRegionalWebAclRulesListOverrideActionDetails struct {

	// Overrides the rule evaluation result in the rule group.
	Type *string

	noSmithyDocumentSerde
}

// Provides information about a WAF rule. This rule specifies the web requests
// that you want to allow, block, or count.
type AwsWafRuleDetails struct {

	// The name of the metrics for this rule.
	MetricName *string

	// A descriptive name for the rule.
	Name *string

	// Specifies the ByteMatchSet , IPSet , SqlInjectionMatchSet , XssMatchSet ,
	// RegexMatchSet , GeoMatchSet , and SizeConstraintSet objects that you want to
	// add to a rule and, for each object, indicates whether you want to negate the
	// settings.
	PredicateList []AwsWafRulePredicateListDetails

	// The ID of the WAF rule.
	RuleId *string

	noSmithyDocumentSerde
}

// Provides information about an WAF rule group. A rule group is a collection of
// rules for inspecting and controlling web requests.
type AwsWafRuleGroupDetails struct {

	// The name of the metrics for this rule group.
	MetricName *string

	// The name of the rule group.
	Name *string

	// The ID of the rule group.
	RuleGroupId *string

	// Provides information about the rules attached to the rule group. These rules
	// identify the web requests that you want to allow, block, or count.
	Rules []AwsWafRuleGroupRulesDetails

	noSmithyDocumentSerde
}

// Provides information about what action WAF should take on a web request when it
// matches the criteria defined in the rule.
type AwsWafRuleGroupRulesActionDetails struct {

	// The action that WAF should take on a web request when it matches the rule's
	// statement.
	Type *string

	noSmithyDocumentSerde
}

// Provides information about the rules attached to the rule group. These rules
// identify the web requests that you want to allow, block, or count.
type AwsWafRuleGroupRulesDetails struct {

	// Provides information about what action WAF should take on a web request when it
	// matches the criteria defined in the rule.
	Action *AwsWafRuleGroupRulesActionDetails

	// If you define more than one rule in a web ACL, WAF evaluates each request
	// against the rules in order based on the value of Priority .
	Priority *int32

	// The rule ID for a rule.
	RuleId *string

	// The type of rule.
	Type *string

	noSmithyDocumentSerde
}

// Provides details about the ByteMatchSet , IPSet , SqlInjectionMatchSet ,
// XssMatchSet , RegexMatchSet , GeoMatchSet , and SizeConstraintSet objects that
// you want to add to a rule and, for each object, indicates whether you want to
// negate the settings.
type AwsWafRulePredicateListDetails struct {

	// A unique identifier for a predicate in a rule, such as ByteMatchSetId or IPSetId
	// .
	DataId *string

	// Specifies if you want WAF to allow, block, or count requests based on the
	// settings in the ByteMatchSet , IPSet , SqlInjectionMatchSet , XssMatchSet ,
	// RegexMatchSet , GeoMatchSet , or SizeConstraintSet .
	Negated *bool

	// The type of predicate in a rule, such as ByteMatch or IPSet .
	Type *string

	noSmithyDocumentSerde
}

//	Specifies that WAF should allow the request and optionally defines additional
//
// custom handling for the request.
type AwsWafv2ActionAllowDetails struct {

	//  Defines custom handling for the web request. For information about customizing
	// web requests and responses, see [Customizing web requests and responses in WAF]in the WAF Developer Guide..
	//
	// [Customizing web requests and responses in WAF]: https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html
	CustomRequestHandling *AwsWafv2CustomRequestHandlingDetails

	noSmithyDocumentSerde
}

//	Specifies that WAF should block the request and optionally defines additional
//
// custom handling for the response to the web request.
type AwsWafv2ActionBlockDetails struct {

	//  Defines a custom response for the web request. For information, see [Customizing web requests and responses in WAF] in the
	// WAF Developer Guide..
	//
	// [Customizing web requests and responses in WAF]: https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html
	CustomResponse *AwsWafv2CustomResponseDetails

	noSmithyDocumentSerde
}

// A custom header for custom request and response handling.
type AwsWafv2CustomHttpHeader struct {

	//  The name of the custom header.
	Name *string

	//  The value of the custom header.
	Value *string

	noSmithyDocumentSerde
}

//	Custom request handling behavior that inserts custom headers into a web
//
// request. WAF uses custom request handling when the rule action doesn't block the
// request.
type AwsWafv2CustomRequestHandlingDetails struct {

	//  The HTTP headers to insert into the request.
	InsertHeaders []AwsWafv2CustomHttpHeader

	noSmithyDocumentSerde
}

//	A custom response to send to the client. You can define a custom response for
//
// rule actions and default web ACL actions that are set to block.
type AwsWafv2CustomResponseDetails struct {

	//  References the response body that you want WAF to return to the web request
	// client. You can define a custom response for a rule action or a default web ACL
	// action that is set to block.
	CustomResponseBodyKey *string

	//  The HTTP status code to return to the client. For a list of status codes that
	// you can use in your custom responses, see [Supported status codes for custom response]in the WAF Developer Guide.
	//
	// [Supported status codes for custom response]: https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html
	ResponseCode *int32

	//  The HTTP headers to use in the response.
	ResponseHeaders []AwsWafv2CustomHttpHeader

	noSmithyDocumentSerde
}

// Details about an WAFv2 rule group.
type AwsWafv2RuleGroupDetails struct {

	//  The Amazon Resource Name (ARN) of the entity.
	Arn *string

	//  The web ACL capacity units (WCUs) required for this rule group.
	Capacity *int64

	//  A description of the rule group that helps with identification.
	Description *string

	//  A unique identifier for the rule group.
	Id *string

	//  The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	Name *string

	//  The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses to
	// identify matching web requests, and parameters that govern how WAF handles them.
	Rules []AwsWafv2RulesDetails

	//  Specifies whether the rule group is for an Amazon CloudFront distribution or
	// for a regional application. A regional application can be an Application Load
	// Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an
	// Amazon Cognito user pool.
	Scope *string

	//  Defines and enables Amazon CloudWatch metrics and web request sample
	// collection.
	VisibilityConfig *AwsWafv2VisibilityConfigDetails

	noSmithyDocumentSerde
}

// Specifies that WAF should run a CAPTCHA check against the request.
type AwsWafv2RulesActionCaptchaDetails struct {

	//  Defines custom handling for the web request, used when the CAPTCHA inspection
	// determines that the request's token is valid and unexpired. For more
	// information, see [Customizing web requests and responses in WAF]in the WAF Developer Guide..
	//
	// [Customizing web requests and responses in WAF]: https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html
	CustomRequestHandling *AwsWafv2CustomRequestHandlingDetails

	noSmithyDocumentSerde
}

// Specifies that WAF should count the request.
type AwsWafv2RulesActionCountDetails struct {

	//  Defines custom handling for the web request. For more information, see [Customizing web requests and responses in WAF] in the
	// WAF Developer Guide..
	//
	// [Customizing web requests and responses in WAF]: https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html
	CustomRequestHandling *AwsWafv2CustomRequestHandlingDetails

	noSmithyDocumentSerde
}

//	The action that WAF should take on a web request when it matches a rule's
//
// statement. Settings at the web ACL level can override the rule action setting.
type AwsWafv2RulesActionDetails struct {

	//  Instructs WAF to allow the web request.
	Allow *AwsWafv2ActionAllowDetails

	//  Instructs WAF to block the web request.
	Block *AwsWafv2ActionBlockDetails

	//  Instructs WAF to run a CAPTCHA check against the web request.
	Captcha *AwsWafv2RulesActionCaptchaDetails

	//  Instructs WAF to count the web request and then continue evaluating the
	// request using the remaining rules in the web ACL.
	Count *AwsWafv2RulesActionCountDetails

	noSmithyDocumentSerde
}

//	Provides details about rules in a rule group. A rule identifies web requests
//
// that you want to allow, block, or count. Each rule includes one top-level
// Statement that WAF uses to identify matching web requests, and parameters that
// govern how WAF handles them.
type AwsWafv2RulesDetails struct {

	//  The action that WAF should take on a web request when it matches the rule
	// statement. Settings at the web ACL level can override the rule action setting.
	Action *AwsWafv2RulesActionDetails

	//  The name of the rule.
	Name *string

	//  The action to use in the place of the action that results from the rule group
	// evaluation.
	OverrideAction *string

	//  If you define more than one Rule in a WebACL, WAF evaluates each request
	// against the Rules in order based on the value of Priority . WAF processes rules
	// with lower priority first. The priorities don't need to be consecutive, but they
	// must all be different.
	Priority *int32

	//  Defines and enables Amazon CloudWatch metrics and web request sample
	// collection.
	VisibilityConfig *AwsWafv2VisibilityConfigDetails

	noSmithyDocumentSerde
}

//	Defines and enables Amazon CloudWatch metrics and web request sample
//
// collection.
type AwsWafv2VisibilityConfigDetails struct {

	//  A boolean indicating whether the associated resource sends metrics to Amazon
	// CloudWatch. For the list of available metrics, see [WAF metrics and dimensions]in the WAF Developer Guide.
	//
	// [WAF metrics and dimensions]: https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics
	CloudWatchMetricsEnabled *bool

	//  A name of the Amazon CloudWatch metric.
	MetricName *string

	//  A boolean indicating whether WAF should store a sampling of the web requests
	// that match the rules. You can view the sampled requests through the WAF console.
	SampledRequestsEnabled *bool

	noSmithyDocumentSerde
}

//	Specifies the action that Amazon CloudFront or WAF takes when a web request
//
// matches the conditions in the rule.
type AwsWafv2WebAclActionDetails struct {

	//  Specifies that WAF should allow requests by default.
	Allow *AwsWafv2ActionAllowDetails

	//  Specifies that WAF should block requests by default.
	Block *AwsWafv2ActionBlockDetails

	noSmithyDocumentSerde
}

//	Specifies how WAF should handle CAPTCHA evaluations for rules that don't have
//
// their own CaptchaConfig settings.
type AwsWafv2WebAclCaptchaConfigDetails struct {

	//  Determines how long a CAPTCHA timestamp in the token remains valid after the
	// client successfully solves a CAPTCHA puzzle.
	ImmunityTimeProperty *AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails

	noSmithyDocumentSerde
}

//	Used for CAPTCHA and challenge token settings. Determines how long a CAPTCHA
//
// or challenge timestamp remains valid after WAF updates it for a successful
// CAPTCHA or challenge response.
type AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails struct {

	//  The amount of time, in seconds, that a CAPTCHA or challenge timestamp is
	// considered valid by WAF.
	ImmunityTime *int64

	noSmithyDocumentSerde
}

// Details about an WAFv2 web Access Control List (ACL).
type AwsWafv2WebAclDetails struct {

	//  The Amazon Resource Name (ARN) of the web ACL that you want to associate with
	// the resource.
	Arn *string

	//  The web ACL capacity units (WCUs) currently being used by this web ACL.
	Capacity *int64

	//  Specifies how WAF should handle CAPTCHA evaluations for rules that don't have
	// their own CaptchaConfig settings.
	CaptchaConfig *AwsWafv2WebAclCaptchaConfigDetails

	//  The action to perform if none of the Rules contained in the web ACL match.
	DefaultAction *AwsWafv2WebAclActionDetails

	//  A description of the web ACL that helps with identification.
	Description *string

	//  A unique identifier for the web ACL.
	Id *string

	//  Indicates whether this web ACL is managed by Firewall Manager.
	ManagedbyFirewallManager *bool

	//  The name of the web ACL.
	Name *string

	//  The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses to
	// identify matching web requests, and parameters that govern how WAF handles them.
	Rules []AwsWafv2RulesDetails

	//  Defines and enables Amazon CloudWatch metrics and web request sample
	// collection.
	VisibilityConfig *AwsWafv2VisibilityConfigDetails

	noSmithyDocumentSerde
}

// Provides information about an WAF web access control list (web ACL).
type AwsWafWebAclDetails struct {

	// The action to perform if none of the rules contained in the web ACL match.
	DefaultAction *string

	// A friendly name or description of the web ACL. You can't change the name of a
	// web ACL after you create it.
	Name *string

	// An array that contains the action for each rule in a web ACL, the priority of
	// the rule, and the ID of the rule.
	Rules []AwsWafWebAclRule

	// A unique identifier for a web ACL.
	WebAclId *string

	noSmithyDocumentSerde
}

// Details for a rule in an WAF web ACL.
type AwsWafWebAclRule struct {

	// Specifies the action that CloudFront or WAF takes when a web request matches
	// the conditions in the rule.
	Action *WafAction

	// Rules to exclude from a rule group.
	ExcludedRules []WafExcludedRule

	// Use the OverrideAction to test your RuleGroup .
	//
	// Any rule in a RuleGroup can potentially block a request. If you set the
	// OverrideAction to None , the RuleGroup blocks a request if any individual rule
	// in the RuleGroup matches the request and is configured to block that request.
	//
	// However, if you first want to test the RuleGroup , set the OverrideAction to
	// Count . The RuleGroup then overrides any block action specified by individual
	// rules contained within the group. Instead of blocking matching requests, those
	// requests are counted.
	//
	// ActivatedRule | OverrideAction applies only when updating or adding a RuleGroup
	// to a web ACL. In this case you do not use ActivatedRule Action . For all other
	// update requests, ActivatedRule Action is used instead of ActivatedRule
	// OverrideAction .
	OverrideAction *WafOverrideAction

	// Specifies the order in which the rules in a web ACL are evaluated. Rules with a
	// lower value for Priority are evaluated before rules with a higher value. The
	// value must be a unique integer. If you add multiple rules to a web ACL, the
	// values do not need to be consecutive.
	Priority *int32

	// The identifier for a rule.
	RuleId *string

	// The rule type.
	//
	// Valid values: REGULAR | RATE_BASED | GROUP
	//
	// The default is REGULAR .
	Type *string

	noSmithyDocumentSerde
}

// Information about the encryption configuration for X-Ray.
type AwsXrayEncryptionConfigDetails struct {

	// The identifier of the KMS key that is used for encryption. Provided if Type is
	// KMS .
	KeyId *string

	// The current status of the encryption configuration. Valid values are ACTIVE or
	// UPDATING .
	//
	// When Status is equal to UPDATING , X-Ray might use both the old and new
	// encryption.
	Status *string

	// The type of encryption. KMS indicates that the encryption uses KMS keys. NONE
	// indicates the default encryption.
	Type *string

	noSmithyDocumentSerde
}

// A finding from a BatchUpdateFindings request that Security Hub was unable to
// update.
type BatchUpdateFindingsUnprocessedFinding struct {

	// The code associated with the error. Possible values are:
	//
	//   - ConcurrentUpdateError - Another request attempted to update the finding
	//   while this request was being processed. This error may also occur if you call [BatchUpdateFindings]
	//   BatchUpdateFindings and [BatchImportFindings]BatchImportFindings at the same time.
	//
	//   - DuplicatedFindingIdentifier - The request included two or more findings with
	//   the same FindingIdentifier .
	//
	//   - FindingNotFound - The FindingIdentifier included in the request did not
	//   match an existing finding.
	//
	//   - FindingSizeExceeded - The finding size was greater than the permissible
	//   value of 240 KB.
	//
	//   - InternalFailure - An internal service failure occurred when updating the
	//   finding.
	//
	//   - InvalidInput - The finding update contained an invalid value that did not
	//   satisfy the [Amazon Web Services Security Finding Format]syntax.
	//
	// [Amazon Web Services Security Finding Format]: https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html
	// [BatchUpdateFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html
	// [BatchImportFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html
	//
	// This member is required.
	ErrorCode *string

	// The message associated with the error. Possible values are:
	//
	//   - Concurrent finding updates detected
	//
	//   - Finding Identifier is duplicated
	//
	//   - Finding Not Found
	//
	//   - Finding size exceeded 240 KB
	//
	//   - Internal service failure
	//
	//   - Invalid Input
	//
	// This member is required.
	ErrorMessage *string

	// The identifier of the finding that was not updated.
	//
	// This member is required.
	FindingIdentifier *AwsSecurityFindingIdentifier

	noSmithyDocumentSerde
}

//	The options for customizing a security control parameter with a boolean. For a
//
// boolean parameter, the options are true and false .
type BooleanConfigurationOptions struct {

	//  The Security Hub default value for a boolean parameter.
	DefaultValue *bool

	noSmithyDocumentSerde
}

// Boolean filter for querying findings.
type BooleanFilter struct {

	// The value of the boolean.
	Value *bool

	noSmithyDocumentSerde
}

// An occurrence of sensitive data detected in a Microsoft Excel workbook,
// comma-separated value (CSV) file, or tab-separated value (TSV) file.
type Cell struct {

	// For a Microsoft Excel workbook, provides the location of the cell, as an
	// absolute cell reference, that contains the data. For example, Sheet2!C5 for cell
	// C5 on Sheet2.
	CellReference *string

	// The column number of the column that contains the data. For a Microsoft Excel
	// workbook, the column number corresponds to the alphabetical column identifiers.
	// For example, a value of 1 for Column corresponds to the A column in the
	// workbook.
	Column *int64

	// The name of the column that contains the data.
	ColumnName *string

	// The row number of the row that contains the data.
	Row *int64

	noSmithyDocumentSerde
}

// An IPv4 CIDR block association.
type CidrBlockAssociation struct {

	// The association ID for the IPv4 CIDR block.
	AssociationId *string

	// The IPv4 CIDR block.
	CidrBlock *string

	// Information about the state of the IPv4 CIDR block.
	CidrBlockState *string

	noSmithyDocumentSerde
}

// Information about a city.
type City struct {

	// The name of the city.
	CityName *string

	noSmithyDocumentSerde
}

// Details about the sensitive data that was detected on the resource.
type ClassificationResult struct {

	// Indicates whether there are additional occurrences of sensitive data that are
	// not included in the finding. This occurs when the number of occurrences exceeds
	// the maximum that can be included.
	AdditionalOccurrences *bool

	// Provides details about sensitive data that was identified based on
	// customer-defined configuration.
	CustomDataIdentifiers *CustomDataIdentifiersResult

	// The type of content that the finding applies to.
	MimeType *string

	// Provides details about sensitive data that was identified based on built-in
	// configuration.
	SensitiveData []SensitiveDataResult

	// The total size in bytes of the affected data.
	SizeClassified *int64

	// The current status of the sensitive data detection.
	Status *ClassificationStatus

	noSmithyDocumentSerde
}

// Provides details about the current status of the sensitive data detection.
type ClassificationStatus struct {

	// The code that represents the status of the sensitive data detection.
	Code *string

	// A longer description of the current status of the sensitive data detection.
	Reason *string

	noSmithyDocumentSerde
}

//	The Amazon Resource Name (ARN) and other details of the Amazon CloudWatch Logs
//
// log group that Amazon Route 53 is publishing logs to.
type CloudWatchLogsLogGroupArnConfigDetails struct {

	//  The ARN of the CloudWatch Logs log group that Route 53 is publishing logs to.
	CloudWatchLogsLogGroupArn *string

	//  The ID of the hosted zone that CloudWatch Logs is logging queries for.
	HostedZoneId *string

	//  The ID for a DNS query logging configuration.
	Id *string

	noSmithyDocumentSerde
}

//	Provides details about where a code vulnerability is located in your Lambda
//
// function.
type CodeVulnerabilitiesFilePath struct {

	//  The line number of the last line of code in which the vulnerability is
	// located.
	EndLine *int32

	//  The name of the file in which the code vulnerability is located.
	FileName *string

	//  The file path to the code in which the vulnerability is located.
	FilePath *string

	//  The line number of the first line of code in which the vulnerability is
	// located.
	StartLine *int32

	noSmithyDocumentSerde
}

// Contains finding details that are specific to control-based findings. Only
// returned for findings generated from controls.
type Compliance struct {

	// The enabled security standards in which a security control is currently
	// enabled.
	AssociatedStandards []AssociatedStandard

	// For a control, the industry or regulatory framework requirements that are
	// related to the control. The check for that control is aligned with these
	// requirements.
	//
	// Array Members: Maximum number of 32 items.
	RelatedRequirements []string

	//  The unique identifier of a control across standards. Values for this field
	// typically consist of an Amazon Web Service and a number, such as APIGateway.5.
	SecurityControlId *string

	//  An object that includes security control parameter names and values.
	SecurityControlParameters []SecurityControlParameter

	// The result of a standards check.
	//
	// The valid values for Status are as follows.
	//
	//   - PASSED - Standards check passed for all evaluated resources.
	//
	//   - WARNING - Some information is missing or this check is not supported for
	//   your configuration.
	//
	//   - FAILED - Standards check failed for at least one evaluated resource.
	//
	//   - NOT_AVAILABLE - Check could not be performed due to a service outage, API
	//   error, or because the result of the Config evaluation was NOT_APPLICABLE . If
	//   the Config evaluation result was NOT_APPLICABLE for a Security Hub control,
	//   Security Hub automatically archives the finding after 3 days.
	Status ComplianceStatus

	// For findings generated from controls, a list of reasons behind the value of
	// Status . For the list of status reason codes and their meanings, see [Standards-related information in the ASFF] in the
	// Security Hub User Guide.
	//
	// [Standards-related information in the ASFF]: https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff
	StatusReasons []StatusReason

	noSmithyDocumentSerde
}

//	The options for customizing a security control parameter.
//
// The following types satisfy this interface:
//
//	ConfigurationOptionsMemberBoolean
//	ConfigurationOptionsMemberDouble
//	ConfigurationOptionsMemberEnum
//	ConfigurationOptionsMemberEnumList
//	ConfigurationOptionsMemberInteger
//	ConfigurationOptionsMemberIntegerList
//	ConfigurationOptionsMemberString
//	ConfigurationOptionsMemberStringList
type ConfigurationOptions interface {
	isConfigurationOptions()
}

//	The options for customizing a security control parameter that is a boolean.
//
// For a boolean parameter, the options are true and false .
type ConfigurationOptionsMemberBoolean struct {
	Value BooleanConfigurationOptions

	noSmithyDocumentSerde
}

func (*ConfigurationOptionsMemberBoolean) isConfigurationOptions() {}

// The options for customizing a security control parameter that is a double.
type ConfigurationOptionsMemberDouble struct {
	Value DoubleConfigurationOptions

	noSmithyDocumentSerde
}

func (*ConfigurationOptionsMemberDouble) isConfigurationOptions() {}

// The options for customizing a security control parameter that is an enum.
type ConfigurationOptionsMemberEnum struct {
	Value EnumConfigurationOptions

	noSmithyDocumentSerde
}

func (*ConfigurationOptionsMemberEnum) isConfigurationOptions() {}

//	The options for customizing a security control parameter that is a list of
//
// enums.
type ConfigurationOptionsMemberEnumList struct {
	Value EnumListConfigurationOptions

	noSmithyDocumentSerde
}

func (*ConfigurationOptionsMemberEnumList) isConfigurationOptions() {}

// The options for customizing a security control parameter that is an integer.
type ConfigurationOptionsMemberInteger struct {
	Value IntegerConfigurationOptions

	noSmithyDocumentSerde
}

func (*ConfigurationOptionsMemberInteger) isConfigurationOptions() {}

//	The options for customizing a security control parameter that is a list of
//
// integers.
type ConfigurationOptionsMemberIntegerList struct {
	Value IntegerListConfigurationOptions

	noSmithyDocumentSerde
}

func (*ConfigurationOptionsMemberIntegerList) isConfigurationOptions() {}

//	The options for customizing a security control parameter that is a string data
//
// type.
type ConfigurationOptionsMemberString struct {
	Value StringConfigurationOptions

	noSmithyDocumentSerde
}

func (*ConfigurationOptionsMemberString) isConfigurationOptions() {}

//	The options for customizing a security control parameter that is a list of
//
// strings.
type ConfigurationOptionsMemberStringList struct {
	Value StringListConfigurationOptions

	noSmithyDocumentSerde
}

func (*ConfigurationOptionsMemberStringList) isConfigurationOptions() {}

//	Provides details about the association between an Security Hub configuration
//
// and a target account, organizational unit, or the root. An association can exist
// between a target and a configuration policy, or between a target and
// self-managed behavior.
type ConfigurationPolicyAssociation struct {

	//  The target account, organizational unit, or the root.
	Target Target

	noSmithyDocumentSerde
}

//	An object that contains the details of a configuration policy association
//
// that’s returned in a ListConfigurationPolicyAssociations request.
type ConfigurationPolicyAssociationSummary struct {

	//  The current status of the association between the specified target and the
	// configuration.
	AssociationStatus ConfigurationPolicyAssociationStatus

	//  The explanation for a FAILED value for AssociationStatus .
	AssociationStatusMessage *string

	//  Indicates whether the association between the specified target and the
	// configuration was directly applied by the Security Hub delegated administrator
	// or inherited from a parent.
	AssociationType AssociationType

	//  The universally unique identifier (UUID) of the configuration policy.
	ConfigurationPolicyId *string

	//  The identifier of the target account, organizational unit, or the root.
	TargetId *string

	//  Specifies whether the target is an Amazon Web Services account, organizational
	// unit, or the root.
	TargetType TargetType

	//  The date and time, in UTC and ISO 8601 format, that the configuration policy
	// association was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

//	An object that contains the details of an Security Hub configuration policy
//
// that’s returned in a ListConfigurationPolicies request.
type ConfigurationPolicySummary struct {

	//  The Amazon Resource Name (ARN) of the configuration policy.
	Arn *string

	//  The description of the configuration policy.
	Description *string

	//  The universally unique identifier (UUID) of the configuration policy.
	Id *string

	//  The name of the configuration policy. Alphanumeric characters and the
	// following ASCII characters are permitted: -, ., !, *, / .
	Name *string

	//  Indicates whether the service that the configuration policy applies to is
	// enabled in the policy.
	ServiceEnabled *bool

	//  The date and time, in UTC and ISO 8601 format, that the configuration policy
	// was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Container details related to a finding.
type ContainerDetails struct {

	// The runtime of the container.
	ContainerRuntime *string

	// The identifier of the container image related to a finding.
	ImageId *string

	// The name of the container image related to a finding.
	ImageName *string

	// Indicates when the container started.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LaunchedAt *string

	// The name of the container related to a finding.
	Name *string

	// When this parameter is true , the container is given elevated privileges on the
	// host container instance (similar to the root user).
	Privileged *bool

	// Provides information about the mounting of a volume in a container.
	VolumeMounts []VolumeMount

	noSmithyDocumentSerde
}

// Information about a country.
type Country struct {

	// The 2-letter ISO 3166 country code for the country.
	CountryCode *string

	// The name of the country.
	CountryName *string

	noSmithyDocumentSerde
}

// The list of detected instances of sensitive data.
type CustomDataIdentifiersDetections struct {

	// The ARN of the custom identifier that was used to detect the sensitive data.
	Arn *string

	// The total number of occurrences of sensitive data that were detected.
	Count *int64

	// he name of the custom identifier that detected the sensitive data.
	Name *string

	// Details about the sensitive data that was detected.
	Occurrences *Occurrences

	noSmithyDocumentSerde
}

// Contains an instance of sensitive data that was detected by a customer-defined
// identifier.
type CustomDataIdentifiersResult struct {

	// The list of detected instances of sensitive data.
	Detections []CustomDataIdentifiersDetections

	// The total number of occurrences of sensitive data.
	TotalCount *int64

	noSmithyDocumentSerde
}

// CVSS scores from the advisory related to the vulnerability.
type Cvss struct {

	// Adjustments to the CVSS metrics.
	Adjustments []Adjustment

	// The base CVSS score.
	BaseScore *float64

	// The base scoring vector for the CVSS score.
	BaseVector *string

	// The origin of the original CVSS score and vector.
	Source *string

	// The version of CVSS for the CVSS score.
	Version *string

	noSmithyDocumentSerde
}

// Provides details about sensitive data that was detected on a resource.
type DataClassificationDetails struct {

	// The path to the folder or file that contains the sensitive data.
	DetailedResultsLocation *string

	// The details about the sensitive data that was detected on the resource.
	Result *ClassificationResult

	noSmithyDocumentSerde
}

// A date filter for querying findings.
type DateFilter struct {

	// A date range for the date filter.
	DateRange *DateRange

	// A timestamp that provides the end date for the date filter.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	End *string

	// A timestamp that provides the start date for the date filter.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	Start *string

	noSmithyDocumentSerde
}

// A date range for the date filter.
type DateRange struct {

	// A date range unit for the date filter.
	Unit DateRangeUnit

	// A date range value for the date filter.
	Value *int32

	noSmithyDocumentSerde
}

// Provided if ActionType is DNS_REQUEST . It provides details about the DNS
// request that was detected.
type DnsRequestAction struct {

	// Indicates whether the DNS request was blocked.
	Blocked *bool

	// The DNS domain that is associated with the DNS request.
	//
	// Length Constraints: 128.
	Domain *string

	// The protocol that was used for the DNS request.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 64.
	Protocol *string

	noSmithyDocumentSerde
}

// The options for customizing a security control parameter that is a double.
type DoubleConfigurationOptions struct {

	//  The Security Hub default value for a control parameter that is a double.
	DefaultValue *float64

	//  The maximum valid value for a control parameter that is a double.
	Max *float64

	//  The minimum valid value for a control parameter that is a double.
	Min *float64

	noSmithyDocumentSerde
}

// The options for customizing a security control parameter that is an enum.
type EnumConfigurationOptions struct {

	//  The valid values for a control parameter that is an enum.
	AllowedValues []string

	//  The Security Hub default value for a control parameter that is an enum.
	DefaultValue *string

	noSmithyDocumentSerde
}

//	The options for customizing a security control parameter that is a list of
//
// enums.
type EnumListConfigurationOptions struct {

	//  The valid values for a control parameter that is a list of enums.
	AllowedValues []string

	//  The Security Hub default value for a control parameter that is a list of
	// enums.
	DefaultValue []string

	//  The maximum number of list items that an enum list control parameter can
	// accept.
	MaxItems *int32

	noSmithyDocumentSerde
}

// Provides information about the file paths that were affected by the threat.
type FilePaths struct {

	// The name of the infected or suspicious file corresponding to the hash.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 128 length.
	FileName *string

	// Path to the infected or suspicious file on the resource it was detected on.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 128 length.
	FilePath *string

	// The hash value for the infected or suspicious file.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 128 length.
	Hash *string

	// The Amazon Resource Name (ARN) of the resource on which the threat was
	// detected.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 128 length.
	ResourceId *string

	noSmithyDocumentSerde
}

// A finding aggregator. A finding aggregator contains the configuration for
// finding aggregation.
type FindingAggregator struct {

	// The ARN of the finding aggregator. You use the finding aggregator ARN to
	// retrieve details for, update, and delete the finding aggregator.
	FindingAggregatorArn *string

	noSmithyDocumentSerde
}

//	A list of events that changed the specified finding during the specified time
//
// period. Each record represents a single finding change event.
type FindingHistoryRecord struct {

	//  Identifies whether the event marks the creation of a new finding. A value of
	// True means that the finding is newly created. A value of False means that the
	// finding isn’t newly created.
	FindingCreated *bool

	// Identifies which finding to get the finding history for.
	FindingIdentifier *AwsSecurityFindingIdentifier

	//  A token for pagination purposes. Provide this token in the subsequent request
	// to [GetFindingsHistory]GetFindingsHistory to get up to an additional 100 results of history for the
	// same finding that you specified in your initial request.
	//
	// [GetFindingsHistory]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindingsHistory.html
	NextToken *string

	//  Identifies the source of the event that changed the finding. For example, an
	// integrated Amazon Web Service or third-party partner integration may call [BatchImportFindings]
	// BatchImportFindings , or an Security Hub customer may call [BatchUpdateFindings]BatchUpdateFindings .
	//
	// [BatchUpdateFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html
	// [BatchImportFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html
	UpdateSource *FindingHistoryUpdateSource

	//  A timestamp that indicates when Security Hub processed the updated finding
	// record.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	UpdateTime *time.Time

	//  An array of objects that provides details about the finding change event,
	// including the Amazon Web Services Security Finding Format (ASFF) field that
	// changed, the value of the field before the change, and the value of the field
	// after the change.
	Updates []FindingHistoryUpdate

	noSmithyDocumentSerde
}

//	An array of objects that provides details about a change to a finding,
//
// including the Amazon Web Services Security Finding Format (ASFF) field that
// changed, the value of the field before the change, and the value of the field
// after the change.
type FindingHistoryUpdate struct {

	//  The value of the ASFF field after the finding change event. To preserve
	// storage and readability, Security Hub omits this value if [FindingHistoryRecord]FindingHistoryRecord
	// exceeds database limits.
	//
	// [FindingHistoryRecord]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_FindingHistoryRecord.html
	NewValue *string

	//  The value of the ASFF field before the finding change event.
	OldValue *string

	//  The ASFF field that changed during the finding change event.
	UpdatedField *string

	noSmithyDocumentSerde
}

// Identifies the source of the finding change event.
type FindingHistoryUpdateSource struct {

	//  The identity of the source that initiated the finding change event. For
	// example, the Amazon Resource Name (ARN) of a partner that calls
	// BatchImportFindings or of a customer that calls BatchUpdateFindings.
	Identity *string

	//  Describes the type of finding change event, such as a call to [BatchImportFindings]
	// BatchImportFindings (by an integrated Amazon Web Service or third party partner
	// integration) or [BatchUpdateFindings]BatchUpdateFindings (by a Security Hub customer).
	//
	// [BatchUpdateFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html
	// [BatchImportFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html
	Type FindingHistoryUpdateSourceType

	noSmithyDocumentSerde
}

// In a [BatchImportFindings]BatchImportFindings request, finding providers use FindingProviderFields
// to provide and update values for the following fields:
//
//   - Confidence
//
//   - Criticality
//
//   - RelatedFindings
//
//   - Severity
//
//   - Types
//
// The preceding fields are nested under the FindingProviderFields object, but
// also have analogues of the same name as top-level ASFF fields. When a new
// finding is sent to Security Hub by a finding provider, Security Hub populates
// the FindingProviderFields object automatically, if it is empty, based on the
// corresponding top-level fields.
//
// Finding providers can update FindingProviderFields only by using the
// BatchImportFindings operation. Finding providers can't update this object with
// the [BatchUpdateFindings]BatchUpdateFindings operation. Customers can update the top-level fields by
// using the BatchUpdateFindings operation. Customers can't update
// FindingProviderFields .
//
// For information about how Security Hub handles updates from BatchImportFindings
// to FindingProviderFields and to the corresponding top-level attributes, see [Using FindingProviderFields]
// FindingProviderFields in the Security Hub User Guide.
//
// [Using FindingProviderFields]: https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchimportfindings.html#batchimportfindings-findingproviderfields
// [BatchUpdateFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html
// [BatchImportFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html
type FindingProviderFields struct {

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero
	// percent confidence and 100 means 100 percent confidence.
	Confidence *int32

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and a
	// score of 100 is reserved for the most critical resources.
	Criticality *int32

	// A list of findings that are related to the current finding.
	RelatedFindings []RelatedFinding

	// The severity of a finding.
	Severity *FindingProviderSeverity

	// One or more finding types in the format of namespace/category/classifier that
	// classify a finding.
	//
	// Valid namespace values are: Software and Configuration Checks | TTPs | Effects
	// | Unusual Behaviors | Sensitive Data Identifications
	Types []string

	noSmithyDocumentSerde
}

// The severity assigned to a finding by the finding provider. This object may
// include one or more of the following attributes:
//
//   - Label
//
//   - Normalized
//
//   - Original
//
//   - Product
//
// If a [BatchImportFindings]BatchImportFindings request for a new finding only provides Label or only
// provides Normalized , Security Hub automatically populates the value of the
// other field.
//
// The Normalized and Product attributes are included in the
// FindingProviderSeverity structure to preserve the historical information
// associated with the finding, even if the top-level Severity object is later
// modified using the [BatchUpdateFindings]BatchUpdateFindings operation.
//
// If the top-level Finding.Severity object is present, but
// Finding.FindingProviderFields isn't present, Security Hub creates the
// FindingProviderFields.Severity object and copies the entire Finding.Severity
// object into it. This ensures that the original, provider-supplied details are
// retained within the FindingProviderFields.Severity object, even if the
// top-level Severity object is overwritten.
//
// [BatchUpdateFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html
// [BatchImportFindings]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html
type FindingProviderSeverity struct {

	// The severity label assigned to the finding by the finding provider.
	Label SeverityLabel

	// The finding provider's original value for the severity.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 64.
	Original *string

	noSmithyDocumentSerde
}

// Defines the behavior of the firewall.
type FirewallPolicyDetails struct {

	// The stateful rule groups that are used in the firewall policy.
	StatefulRuleGroupReferences []FirewallPolicyStatefulRuleGroupReferencesDetails

	// The custom action definitions that are available to use in the firewall
	// policy's StatelessDefaultActions setting.
	StatelessCustomActions []FirewallPolicyStatelessCustomActionsDetails

	// The actions to take on a packet if it doesn't match any of the stateless rules
	// in the policy.
	//
	// You must specify a standard action ( aws:pass , aws:drop , aws:forward_to_sfe ),
	// and can optionally include a custom action from StatelessCustomActions .
	StatelessDefaultActions []string

	// The actions to take on a fragmented UDP packet if it doesn't match any of the
	// stateless rules in the policy.
	//
	// You must specify a standard action ( aws:pass , aws:drop , aws:forward_to_sfe ),
	// and can optionally include a custom action from StatelessCustomActions .
	StatelessFragmentDefaultActions []string

	// The stateless rule groups that are used in the firewall policy.
	StatelessRuleGroupReferences []FirewallPolicyStatelessRuleGroupReferencesDetails

	noSmithyDocumentSerde
}

// A stateful rule group that is used by the firewall policy.
type FirewallPolicyStatefulRuleGroupReferencesDetails struct {

	// The ARN of the stateful rule group.
	ResourceArn *string

	noSmithyDocumentSerde
}

// A custom action that can be used for stateless packet handling.
type FirewallPolicyStatelessCustomActionsDetails struct {

	// The definition of the custom action.
	ActionDefinition *StatelessCustomActionDefinition

	// The name of the custom action.
	ActionName *string

	noSmithyDocumentSerde
}

// A stateless rule group that is used by the firewall policy.
type FirewallPolicyStatelessRuleGroupReferencesDetails struct {

	// The order in which to run the stateless rule group.
	Priority *int32

	// The ARN of the stateless rule group.
	ResourceArn *string

	noSmithyDocumentSerde
}

//	Provides metadata for the Amazon CodeGuru detector associated with a finding.
//
// This field pertains to findings that relate to Lambda functions. Amazon
// Inspector identifies policy violations and vulnerabilities in Lambda function
// code based on internal detectors developed in collaboration with Amazon
// CodeGuru. Security Hub receives those findings.
type GeneratorDetails struct {

	//  The description of the detector used to identify the code vulnerability.
	Description *string

	//  An array of tags used to identify the detector associated with the finding.
	//
	// Array Members: Minimum number of 0 items. Maximum number of 10 items.
	Labels []string

	//  The name of the detector used to identify the code vulnerability.
	Name *string

	noSmithyDocumentSerde
}

// Provides the latitude and longitude coordinates of a location.
type GeoLocation struct {

	// The latitude of the location.
	Lat *float64

	// The longitude of the location.
	Lon *float64

	noSmithyDocumentSerde
}

// An Internet Control Message Protocol (ICMP) type and code.
type IcmpTypeCode struct {

	// The ICMP code for which to deny or allow access. To deny or allow all codes,
	// use the value -1 .
	Code *int32

	// The ICMP type for which to deny or allow access. To deny or allow all types,
	// use the value -1 .
	Type *int32

	noSmithyDocumentSerde
}

// The list of the findings that cannot be imported. For each finding, the list
// provides the error.
type ImportFindingsError struct {

	// The code of the error returned by the BatchImportFindings operation.
	//
	// This member is required.
	ErrorCode *string

	// The message of the error returned by the BatchImportFindings operation.
	//
	// This member is required.
	ErrorMessage *string

	// The identifier of the finding that could not be updated.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about a Security Hub insight.
type Insight struct {

	// One or more attributes used to filter the findings included in the insight. You
	// can filter by up to ten finding attributes. For each attribute, you can provide
	// up to 20 filter values. The insight only includes findings that match the
	// criteria defined in the filters.
	//
	// This member is required.
	Filters *AwsSecurityFindingFilters

	// The grouping attribute for the insight's findings. Indicates how to group the
	// matching findings, and identifies the type of item that the insight applies to.
	// For example, if an insight is grouped by resource identifier, then the insight
	// produces a list of resource identifiers.
	//
	// This member is required.
	GroupByAttribute *string

	// The ARN of a Security Hub insight.
	//
	// This member is required.
	InsightArn *string

	// The name of a Security Hub insight.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The insight results returned by the GetInsightResults operation.
type InsightResults struct {

	// The attribute that the findings are grouped by for the insight whose results
	// are returned by the GetInsightResults operation.
	//
	// This member is required.
	GroupByAttribute *string

	// The ARN of the insight whose results are returned by the GetInsightResults
	// operation.
	//
	// This member is required.
	InsightArn *string

	// The list of insight result values returned by the GetInsightResults operation.
	//
	// This member is required.
	ResultValues []InsightResultValue

	noSmithyDocumentSerde
}

// The insight result values returned by the GetInsightResults operation.
type InsightResultValue struct {

	// The number of findings returned for each GroupByAttributeValue .
	//
	// This member is required.
	Count *int32

	// The value of the attribute that the findings are grouped by for the insight
	// whose results are returned by the GetInsightResults operation.
	//
	// This member is required.
	GroupByAttributeValue *string

	noSmithyDocumentSerde
}

// The options for customizing a security control parameter that is an integer.
type IntegerConfigurationOptions struct {

	//  The Security Hub default value for a control parameter that is an integer.
	DefaultValue *int32

	//  The maximum valid value for a control parameter that is an integer.
	Max *int32

	//  The minimum valid value for a control parameter that is an integer.
	Min *int32

	noSmithyDocumentSerde
}

//	The options for customizing a security control parameter that is a list of
//
// integers.
type IntegerListConfigurationOptions struct {

	//  The Security Hub default value for a control parameter that is a list of
	// integers.
	DefaultValue []int32

	//  The maximum valid value for a control parameter that is a list of integers.
	Max *int32

	//  The maximum number of list items that an interger list control parameter can
	// accept.
	MaxItems *int32

	//  The minimum valid value for a control parameter that is a list of integers.
	Min *int32

	noSmithyDocumentSerde
}

// Details about an invitation.
type Invitation struct {

	// The account ID of the Security Hub administrator account that the invitation
	// was sent from.
	AccountId *string

	// The ID of the invitation sent to the member account.
	InvitationId *string

	// The timestamp of when the invitation was sent.
	InvitedAt *time.Time

	// The current status of the association between the member and administrator
	// accounts.
	MemberStatus *string

	noSmithyDocumentSerde
}

// The IP filter for querying findings.
type IpFilter struct {

	// A finding's CIDR value.
	Cidr *string

	noSmithyDocumentSerde
}

// Provides information about an internet provider.
type IpOrganizationDetails struct {

	// The Autonomous System Number (ASN) of the internet provider
	Asn *int32

	// The name of the organization that registered the ASN.
	AsnOrg *string

	// The ISP information for the internet provider.
	Isp *string

	// The name of the internet provider.
	Org *string

	noSmithyDocumentSerde
}

// An IPV6 CIDR block association.
type Ipv6CidrBlockAssociation struct {

	// The association ID for the IPv6 CIDR block.
	AssociationId *string

	// Information about the state of the CIDR block. Valid values are as follows:
	//
	//   - associating
	//
	//   - associated
	//
	//   - disassociating
	//
	//   - disassociated
	//
	//   - failed
	//
	//   - failing
	CidrBlockState *string

	// The IPv6 CIDR block.
	Ipv6CidrBlock *string

	noSmithyDocumentSerde
}

// A keyword filter for querying findings.
type KeywordFilter struct {

	// A value for the keyword.
	Value *string

	noSmithyDocumentSerde
}

// Information about the state of the load balancer.
type LoadBalancerState struct {

	// The state code. The initial state of the load balancer is provisioning.
	//
	// After the load balancer is fully set up and ready to route traffic, its state
	// is active.
	//
	// If the load balancer could not be set up, its state is failed.
	Code *string

	// A description of the state.
	Reason *string

	noSmithyDocumentSerde
}

// A list of malware related to a finding.
type Malware struct {

	// The name of the malware that was observed.
	//
	// Length Constraints: Minimum of 1. Maximum of 64.
	//
	// This member is required.
	Name *string

	// The file system path of the malware that was observed.
	//
	// Length Constraints: Minimum of 1. Maximum of 512.
	Path *string

	// The state of the malware that was observed.
	State MalwareState

	// The type of the malware that was observed.
	Type MalwareType

	noSmithyDocumentSerde
}

// A map filter for filtering Security Hub findings. Each map filter provides the
// field to check for, the value to check for, and the comparison operator.
type MapFilter struct {

	// The condition to apply to the key value when filtering Security Hub findings
	// with a map filter.
	//
	// To search for values that have the filter value, use one of the following
	// comparison operators:
	//
	//   - To search for values that include the filter value, use CONTAINS . For
	//   example, for the ResourceTags field, the filter Department CONTAINS Security
	//   matches findings that include the value Security for the Department tag. In
	//   the same example, a finding with a value of Security team for the Department
	//   tag is a match.
	//
	//   - To search for values that exactly match the filter value, use EQUALS . For
	//   example, for the ResourceTags field, the filter Department EQUALS Security
	//   matches findings that have the value Security for the Department tag.
	//
	// CONTAINS and EQUALS filters on the same field are joined by OR . A finding
	// matches if it matches any one of those filters. For example, the filters
	// Department CONTAINS Security OR Department CONTAINS Finance match a finding that
	// includes either Security , Finance , or both values.
	//
	// To search for values that don't have the filter value, use one of the following
	// comparison operators:
	//
	//   - To search for values that exclude the filter value, use NOT_CONTAINS . For
	//   example, for the ResourceTags field, the filter Department NOT_CONTAINS
	//   Finance matches findings that exclude the value Finance for the Department tag.
	//
	//   - To search for values other than the filter value, use NOT_EQUALS . For
	//   example, for the ResourceTags field, the filter Department NOT_EQUALS Finance
	//   matches findings that don’t have the value Finance for the Department tag.
	//
	// NOT_CONTAINS and NOT_EQUALS filters on the same field are joined by AND . A
	// finding matches only if it matches all of those filters. For example, the
	// filters Department NOT_CONTAINS Security AND Department NOT_CONTAINS Finance
	// match a finding that excludes both the Security and Finance values.
	//
	// CONTAINS filters can only be used with other CONTAINS filters. NOT_CONTAINS
	// filters can only be used with other NOT_CONTAINS filters.
	//
	// You can’t have both a CONTAINS filter and a NOT_CONTAINS filter on the same
	// field. Similarly, you can’t have both an EQUALS filter and a NOT_EQUALS filter
	// on the same field. Combining filters in this way returns an error.
	//
	// CONTAINS and NOT_CONTAINS operators can be used only with automation rules. For
	// more information, see [Automation rules]in the Security Hub User Guide.
	//
	// [Automation rules]: https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html
	Comparison MapFilterComparison

	// The key of the map filter. For example, for ResourceTags , Key identifies the
	// name of the tag. For UserDefinedFields , Key is the name of the field.
	Key *string

	// The value for the key in the map filter. Filter values are case sensitive. For
	// example, one of the values for a tag called Department might be Security . If
	// you provide security as the filter value, then there's no match.
	Value *string

	noSmithyDocumentSerde
}

// The details about a member account.
type Member struct {

	// The Amazon Web Services account ID of the member account.
	AccountId *string

	// The Amazon Web Services account ID of the Security Hub administrator account
	// associated with this member account.
	AdministratorId *string

	// The email address of the member account.
	Email *string

	// A timestamp for the date and time when the invitation was sent to the member
	// account.
	InvitedAt *time.Time

	// This is replaced by AdministratorID .
	//
	// The Amazon Web Services account ID of the Security Hub administrator account
	// associated with this member account.
	//
	// Deprecated: This field is deprecated, use AdministratorId instead.
	MasterId *string

	// The status of the relationship between the member account and its administrator
	// account.
	//
	// The status can have one of the following values:
	//
	//   - Created - Indicates that the administrator account added the member account,
	//   but has not yet invited the member account.
	//
	//   - Invited - Indicates that the administrator account invited the member
	//   account. The member account has not yet responded to the invitation.
	//
	//   - Enabled - Indicates that the member account is currently active. For
	//   manually invited member accounts, indicates that the member account accepted the
	//   invitation.
	//
	//   - Removed - Indicates that the administrator account disassociated the member
	//   account.
	//
	//   - Resigned - Indicates that the member account disassociated themselves from
	//   the administrator account.
	//
	//   - Deleted - Indicates that the administrator account deleted the member
	//   account.
	//
	//   - AccountSuspended - Indicates that an organization account was suspended from
	//   Amazon Web Services at the same time that the administrator account tried to
	//   enable the organization account as a member account.
	MemberStatus *string

	// The timestamp for the date and time when the member account was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The details of network-related information about a finding.
type Network struct {

	// The destination domain of network-related information about a finding.
	//
	// Length Constraints: Minimum of 1. Maximum of 128.
	DestinationDomain *string

	// The destination IPv4 address of network-related information about a finding.
	DestinationIpV4 *string

	// The destination IPv6 address of network-related information about a finding.
	DestinationIpV6 *string

	// The destination port of network-related information about a finding.
	DestinationPort *int32

	// The direction of network traffic associated with a finding.
	Direction NetworkDirection

	// The range of open ports that is present on the network.
	OpenPortRange *PortRange

	// The protocol of network-related information about a finding.
	//
	// Length Constraints: Minimum of 1. Maximum of 16.
	Protocol *string

	// The source domain of network-related information about a finding.
	//
	// Length Constraints: Minimum of 1. Maximum of 128.
	SourceDomain *string

	// The source IPv4 address of network-related information about a finding.
	SourceIpV4 *string

	// The source IPv6 address of network-related information about a finding.
	SourceIpV6 *string

	// The source media access control (MAC) address of network-related information
	// about a finding.
	SourceMac *string

	// The source port of network-related information about a finding.
	SourcePort *int32

	noSmithyDocumentSerde
}

// Provided if ActionType is NETWORK_CONNECTION . It provides details about the
// attempted network connection that was detected.
type NetworkConnectionAction struct {

	// Indicates whether the network connection attempt was blocked.
	Blocked *bool

	// The direction of the network connection request ( IN or OUT ).
	ConnectionDirection *string

	// Information about the port on the EC2 instance.
	LocalPortDetails *ActionLocalPortDetails

	// The protocol used to make the network connection request.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 64.
	Protocol *string

	// Information about the remote IP address that issued the network connection
	// request.
	RemoteIpDetails *ActionRemoteIpDetails

	// Information about the port on the remote IP address.
	RemotePortDetails *ActionRemotePortDetails

	noSmithyDocumentSerde
}

// Details about a network path component that occurs before or after the current
// component.
type NetworkHeader struct {

	// Information about the destination of the component.
	Destination *NetworkPathComponentDetails

	// The protocol used for the component.
	//
	// Length Constraints: Minimum of 1. Maximum of 16.
	Protocol *string

	// Information about the origin of the component.
	Source *NetworkPathComponentDetails

	noSmithyDocumentSerde
}

// Information about a network path component.
type NetworkPathComponent struct {

	// The identifier of a component in the network path.
	//
	// Length Constraints: Minimum of 1. Maximum of 32.
	ComponentId *string

	// The type of component.
	//
	// Length Constraints: Minimum of 1. Maximum of 32.
	ComponentType *string

	// Information about the component that comes after the current component in the
	// network path.
	Egress *NetworkHeader

	// Information about the component that comes before the current node in the
	// network path.
	Ingress *NetworkHeader

	noSmithyDocumentSerde
}

// Information about the destination of the next component in the network path.
type NetworkPathComponentDetails struct {

	// The IP addresses of the destination.
	Address []string

	// A list of port ranges for the destination.
	PortRanges []PortRange

	noSmithyDocumentSerde
}

// A user-defined note added to a finding.
type Note struct {

	// The text of a note.
	//
	// Length Constraints: Minimum of 1. Maximum of 512.
	//
	// This member is required.
	Text *string

	// A timestamp that indicates when the note was updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	//
	// This member is required.
	UpdatedAt *string

	// The principal that created a note.
	//
	// This member is required.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The updated note.
type NoteUpdate struct {

	// The updated note text.
	//
	// This member is required.
	Text *string

	// The principal that updated the note.
	//
	// This member is required.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// A number filter for querying findings.
type NumberFilter struct {

	// The equal-to condition to be applied to a single field when querying for
	// findings.
	Eq *float64

	//  The greater-than condition to be applied to a single field when querying for
	// findings.
	Gt *float64

	// The greater-than-equal condition to be applied to a single field when querying
	// for findings.
	Gte *float64

	//  The less-than condition to be applied to a single field when querying for
	// findings.
	Lt *float64

	// The less-than-equal condition to be applied to a single field when querying for
	// findings.
	Lte *float64

	noSmithyDocumentSerde
}

// The detected occurrences of sensitive data.
type Occurrences struct {

	// Occurrences of sensitive data detected in Microsoft Excel workbooks,
	// comma-separated value (CSV) files, or tab-separated value (TSV) files.
	Cells []Cell

	// Occurrences of sensitive data detected in a non-binary text file or a Microsoft
	// Word file. Non-binary text files include files such as HTML, XML, JSON, and TXT
	// files.
	LineRanges []Range

	// Occurrences of sensitive data detected in a binary text file.
	OffsetRanges []Range

	// Occurrences of sensitive data in an Adobe Portable Document Format (PDF) file.
	Pages []Page

	// Occurrences of sensitive data in an Apache Avro object container or an Apache
	// Parquet file.
	Records []Record

	noSmithyDocumentSerde
}

//	Provides information about the way an organization is configured in Security
//
// Hub.
type OrganizationConfiguration struct {

	//  Indicates whether the organization uses local or central configuration.
	//
	// If you use local configuration, the Security Hub delegated administrator can
	// set AutoEnable to true and AutoEnableStandards to DEFAULT . This automatically
	// enables Security Hub and default security standards in new organization
	// accounts. These new account settings must be set separately in each Amazon Web
	// Services Region, and settings may be different in each Region.
	//
	// If you use central configuration, the delegated administrator can create
	// configuration policies. Configuration policies can be used to configure Security
	// Hub, security standards, and security controls in multiple accounts and Regions.
	// If you want new organization accounts to use a specific configuration, you can
	// create a configuration policy and associate it with the root or specific
	// organizational units (OUs). New accounts will inherit the policy from the root
	// or their assigned OU.
	ConfigurationType OrganizationConfigurationConfigurationType

	//  Describes whether central configuration could be enabled as the
	// ConfigurationType for the organization. If your ConfigurationType is local
	// configuration, then the value of Status is always ENABLED .
	Status OrganizationConfigurationStatus

	//  Provides an explanation if the value of Status is equal to FAILED when
	// ConfigurationType is equal to CENTRAL .
	StatusMessage *string

	noSmithyDocumentSerde
}

// An occurrence of sensitive data in an Adobe Portable Document Format (PDF) file.
type Page struct {

	// An occurrence of sensitive data detected in a non-binary text file or a
	// Microsoft Word file. Non-binary text files include files such as HTML, XML,
	// JSON, and TXT files.
	LineRange *Range

	// An occurrence of sensitive data detected in a binary text file.
	OffsetRange *Range

	// The page number of the page that contains the sensitive data.
	PageNumber *int64

	noSmithyDocumentSerde
}

//	An object that provides the current value of a security control parameter and
//
// identifies whether it has been customized.
type ParameterConfiguration struct {

	//  Identifies whether a control parameter uses a custom user-defined value or
	// subscribes to the default Security Hub behavior.
	//
	// When ValueType is set equal to DEFAULT , the default behavior can be a specific
	// Security Hub default value, or the default behavior can be to ignore a specific
	// parameter. When ValueType is set equal to DEFAULT , Security Hub ignores
	// user-provided input for the Value field.
	//
	// When ValueType is set equal to CUSTOM , the Value field can't be empty.
	//
	// This member is required.
	ValueType ParameterValueType

	//  The current value of a control parameter.
	Value ParameterValue

	noSmithyDocumentSerde
}

//	An object that describes a security control parameter and the options for
//
// customizing it.
type ParameterDefinition struct {

	//  The options for customizing a control parameter. Customization options vary
	// based on the data type of the parameter.
	//
	// This member is required.
	ConfigurationOptions ConfigurationOptions

	//  Description of a control parameter.
	//
	// This member is required.
	Description *string

	noSmithyDocumentSerde
}

//	An object that includes the data type of a security control parameter and its
//
// current value.
//
// The following types satisfy this interface:
//
//	ParameterValueMemberBoolean
//	ParameterValueMemberDouble
//	ParameterValueMemberEnum
//	ParameterValueMemberEnumList
//	ParameterValueMemberInteger
//	ParameterValueMemberIntegerList
//	ParameterValueMemberString
//	ParameterValueMemberStringList
type ParameterValue interface {
	isParameterValue()
}

// A control parameter that is a boolean.
type ParameterValueMemberBoolean struct {
	Value bool

	noSmithyDocumentSerde
}

func (*ParameterValueMemberBoolean) isParameterValue() {}

// A control parameter that is a double.
type ParameterValueMemberDouble struct {
	Value float64

	noSmithyDocumentSerde
}

func (*ParameterValueMemberDouble) isParameterValue() {}

// A control parameter that is an enum.
type ParameterValueMemberEnum struct {
	Value string

	noSmithyDocumentSerde
}

func (*ParameterValueMemberEnum) isParameterValue() {}

// A control parameter that is a list of enums.
type ParameterValueMemberEnumList struct {
	Value []string

	noSmithyDocumentSerde
}

func (*ParameterValueMemberEnumList) isParameterValue() {}

// A control parameter that is an integer.
type ParameterValueMemberInteger struct {
	Value int32

	noSmithyDocumentSerde
}

func (*ParameterValueMemberInteger) isParameterValue() {}

// A control parameter that is a list of integers.
type ParameterValueMemberIntegerList struct {
	Value []int32

	noSmithyDocumentSerde
}

func (*ParameterValueMemberIntegerList) isParameterValue() {}

// A control parameter that is a string.
type ParameterValueMemberString struct {
	Value string

	noSmithyDocumentSerde
}

func (*ParameterValueMemberString) isParameterValue() {}

// A control parameter that is a list of strings.
type ParameterValueMemberStringList struct {
	Value []string

	noSmithyDocumentSerde
}

func (*ParameterValueMemberStringList) isParameterValue() {}

// Provides an overview of the patch compliance status for an instance against a
// selected compliance standard.
type PatchSummary struct {

	// The identifier of the compliance standard that was used to determine the patch
	// compliance status.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 256.
	//
	// This member is required.
	Id *string

	// The number of patches from the compliance standard that failed to install.
	//
	// The value can be an integer from 0 to 100000 .
	FailedCount *int32

	// The number of patches from the compliance standard that were installed
	// successfully.
	//
	// The value can be an integer from 0 to 100000 .
	InstalledCount *int32

	// The number of installed patches that are not part of the compliance standard.
	//
	// The value can be an integer from 0 to 100000 .
	InstalledOtherCount *int32

	// The number of patches that were applied, but that require the instance to be
	// rebooted in order to be marked as installed.
	//
	// The value can be an integer from 0 to 100000 .
	InstalledPendingReboot *int32

	// The number of patches that are installed but are also on a list of patches that
	// the customer rejected.
	//
	// The value can be an integer from 0 to 100000 .
	InstalledRejectedCount *int32

	// The number of patches that are part of the compliance standard but are not
	// installed. The count includes patches that failed to install.
	//
	// The value can be an integer from 0 to 100000 .
	MissingCount *int32

	// The type of patch operation performed. For Patch Manager, the values are SCAN
	// and INSTALL .
	//
	// Length Constraints: Minimum length of 1. Maximum length of 256.
	Operation *string

	// Indicates when the operation completed.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	OperationEndTime *string

	// Indicates when the operation started.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	OperationStartTime *string

	// The reboot option specified for the instance.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 256.
	RebootOption *string

	noSmithyDocumentSerde
}

//	An object that defines how Security Hub is configured. It includes whether
//
// Security Hub is enabled or disabled, a list of enabled security standards, a
// list of enabled or disabled security controls, and a list of custom parameter
// values for specified controls. If you provide a list of security controls that
// are enabled in the configuration policy, Security Hub disables all other
// controls (including newly released controls). If you provide a list of security
// controls that are disabled in the configuration policy, Security Hub enables all
// other controls (including newly released controls).
//
// The following types satisfy this interface:
//
//	PolicyMemberSecurityHub
type Policy interface {
	isPolicy()
}

// The Amazon Web Service that the configuration policy applies to.
type PolicyMemberSecurityHub struct {
	Value SecurityHubPolicy

	noSmithyDocumentSerde
}

func (*PolicyMemberSecurityHub) isPolicy() {}

// Provided if ActionType is PORT_PROBE . It provides details about the attempted
// port probe that was detected.
type PortProbeAction struct {

	// Indicates whether the port probe was blocked.
	Blocked *bool

	// Information about the ports affected by the port probe.
	PortProbeDetails []PortProbeDetail

	noSmithyDocumentSerde
}

// A port scan that was part of the port probe. For each scan, PortProbeDetails
// provides information about the local IP address and port that were scanned, and
// the remote IP address that the scan originated from.
type PortProbeDetail struct {

	// Provides information about the IP address where the scanned port is located.
	LocalIpDetails *ActionLocalIpDetails

	// Provides information about the port that was scanned.
	LocalPortDetails *ActionLocalPortDetails

	// Provides information about the remote IP address that performed the scan.
	RemoteIpDetails *ActionRemoteIpDetails

	noSmithyDocumentSerde
}

// A range of ports.
type PortRange struct {

	// The first port in the port range.
	Begin *int32

	// The last port in the port range.
	End *int32

	noSmithyDocumentSerde
}

// A range of ports.
type PortRangeFromTo struct {

	// The first port in the port range.
	From *int32

	// The last port in the port range.
	To *int32

	noSmithyDocumentSerde
}

// The details of process-related information about a finding.
type ProcessDetails struct {

	// Indicates when the process was launched.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LaunchedAt *string

	// The name of the process.
	//
	// Length Constraints: Minimum of 1. Maximum of 64.
	Name *string

	// The parent process ID. This field accepts positive integers between O and
	// 2147483647 .
	ParentPid *int32

	// The path to the process executable.
	//
	// Length Constraints: Minimum of 1. Maximum of 512.
	Path *string

	// The process ID.
	Pid *int32

	// Indicates when the process was terminated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	TerminatedAt *string

	noSmithyDocumentSerde
}

// Contains details about a product.
type Product struct {

	// The ARN assigned to the product.
	//
	// This member is required.
	ProductArn *string

	// The URL to the service or product documentation about the integration with
	// Security Hub, including how to activate the integration.
	ActivationUrl *string

	// The categories assigned to the product.
	Categories []string

	// The name of the company that provides the product.
	CompanyName *string

	// A description of the product.
	Description *string

	// The types of integration that the product supports. Available values are the
	// following.
	//
	//   - SEND_FINDINGS_TO_SECURITY_HUB - The integration sends findings to Security
	//   Hub.
	//
	//   - RECEIVE_FINDINGS_FROM_SECURITY_HUB - The integration receives findings from
	//   Security Hub.
	//
	//   - UPDATE_FINDINGS_IN_SECURITY_HUB - The integration does not send new findings
	//   to Security Hub, but does make updates to the findings that it receives from
	//   Security Hub.
	IntegrationTypes []IntegrationType

	// For integrations with Amazon Web Services services, the Amazon Web Services
	// Console URL from which to activate the service.
	//
	// For integrations with third-party products, the Amazon Web Services Marketplace
	// URL from which to subscribe to or purchase the product.
	MarketplaceUrl *string

	// The name of the product.
	ProductName *string

	// The resource policy associated with the product.
	ProductSubscriptionResourcePolicy *string

	noSmithyDocumentSerde
}

// Describes a virtual private gateway propagating route.
type PropagatingVgwSetDetails struct {

	//  The ID of the virtual private gateway.
	GatewayId *string

	noSmithyDocumentSerde
}

// Identifies where the sensitive data begins and ends.
type Range struct {

	// The number of lines (for a line range) or characters (for an offset range) from
	// the beginning of the file to the end of the sensitive data.
	End *int64

	// The number of lines (for a line range) or characters (for an offset range) from
	// the beginning of the file to the end of the sensitive data.
	Start *int64

	// In the line where the sensitive data starts, the column within the line where
	// the sensitive data starts.
	StartColumn *int64

	noSmithyDocumentSerde
}

// A recommendation on how to remediate the issue identified in a finding.
type Recommendation struct {

	// Describes the recommended steps to take to remediate an issue identified in a
	// finding.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 512 length.
	Text *string

	// A URL to a page or site that contains information about how to remediate a
	// finding.
	Url *string

	noSmithyDocumentSerde
}

// An occurrence of sensitive data in an Apache Avro object container or an Apache
// Parquet file.
type Record struct {

	// The path, as a JSONPath expression, to the field in the record that contains
	// the data. If the field name is longer than 20 characters, it is truncated. If
	// the path is longer than 250 characters, it is truncated.
	JsonPath *string

	// The record index, starting from 0, for the record that contains the data.
	RecordIndex *int64

	noSmithyDocumentSerde
}

// Details about a related finding.
type RelatedFinding struct {

	// The product-generated identifier for a related finding.
	//
	// This member is required.
	Id *string

	// The ARN of the product that generated a related finding.
	//
	// This member is required.
	ProductArn *string

	noSmithyDocumentSerde
}

// Details about the remediation steps for a finding.
type Remediation struct {

	// A recommendation on the steps to take to remediate the issue identified by a
	// finding.
	Recommendation *Recommendation

	noSmithyDocumentSerde
}

// A resource related to a finding.
type Resource struct {

	// The canonical identifier for the given resource type.
	//
	// This member is required.
	Id *string

	// The type of the resource that details are provided for. If possible, set Type
	// to one of the supported resource types. For example, if the resource is an EC2
	// instance, then set Type to AwsEc2Instance .
	//
	// If the resource does not match any of the provided types, then set Type to Other
	// .
	//
	// Length Constraints: Minimum length of 1. Maximum length of 256.
	//
	// This member is required.
	Type *string

	//  The Amazon Resource Name (ARN) of the application that is related to a
	// finding.
	ApplicationArn *string

	//  The name of the application that is related to a finding.
	ApplicationName *string

	// Contains information about sensitive data that was detected on the resource.
	DataClassification *DataClassificationDetails

	// Additional details about the resource related to a finding.
	Details *ResourceDetails

	// The canonical Amazon Web Services partition name that the Region is assigned to.
	Partition Partition

	// The canonical Amazon Web Services external Region name where this resource is
	// located.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 16.
	Region *string

	// Identifies the role of the resource in the finding. A resource is either the
	// actor or target of the finding activity,
	ResourceRole *string

	// A list of Amazon Web Services tags associated with a resource at the time the
	// finding was processed. Tags must follow [Amazon Web Services tag naming limits and requirements].
	//
	// [Amazon Web Services tag naming limits and requirements]: https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions
	Tags map[string]string

	noSmithyDocumentSerde
}

// Additional details about a resource related to a finding.
//
// To provide the details, use the object that corresponds to the resource type.
// For example, if the resource type is AwsEc2Instance , then you use the
// AwsEc2Instance object to provide the details.
//
// If the type-specific object does not contain all of the fields you want to
// populate, then you use the Other object to populate those additional fields.
//
// You also use the Other object to populate the details when the selected type
// does not have a corresponding object.
type ResourceDetails struct {

	//  Provides details about AppSync message broker. A message broker allows
	// software applications and components to communicate using various programming
	// languages, operating systems, and formal messaging protocols.
	AwsAmazonMqBroker *AwsAmazonMqBrokerDetails

	// Provides information about a REST API in version 1 of Amazon API Gateway.
	AwsApiGatewayRestApi *AwsApiGatewayRestApiDetails

	// Provides information about a version 1 Amazon API Gateway stage.
	AwsApiGatewayStage *AwsApiGatewayStageDetails

	// Provides information about a version 2 API in Amazon API Gateway.
	AwsApiGatewayV2Api *AwsApiGatewayV2ApiDetails

	// Provides information about a version 2 stage for Amazon API Gateway.
	AwsApiGatewayV2Stage *AwsApiGatewayV2StageDetails

	//  Provides details about an AppSync Graph QL API, which lets you query multiple
	// databases, microservices, and APIs from a single GraphQL endpoint.
	AwsAppSyncGraphQlApi *AwsAppSyncGraphQlApiDetails

	//  Provides information about an Amazon Athena workgroup. A workgroup helps you
	// separate users, teams, applications, or workloads. It also helps you set limits
	// on data processing and track costs.
	AwsAthenaWorkGroup *AwsAthenaWorkGroupDetails

	// Details for an autoscaling group.
	AwsAutoScalingAutoScalingGroup *AwsAutoScalingAutoScalingGroupDetails

	// Provides details about a launch configuration.
	AwsAutoScalingLaunchConfiguration *AwsAutoScalingLaunchConfigurationDetails

	// Provides details about an Backup backup plan.
	AwsBackupBackupPlan *AwsBackupBackupPlanDetails

	// Provides details about an Backup backup vault.
	AwsBackupBackupVault *AwsBackupBackupVaultDetails

	// Provides details about an Backup backup, or recovery point.
	AwsBackupRecoveryPoint *AwsBackupRecoveryPointDetails

	// Provides details about an Certificate Manager certificate.
	AwsCertificateManagerCertificate *AwsCertificateManagerCertificateDetails

	// Details about an CloudFormation stack. A stack is a collection of Amazon Web
	// Services resources that you can manage as a single unit.
	AwsCloudFormationStack *AwsCloudFormationStackDetails

	// Details about a CloudFront distribution.
	AwsCloudFrontDistribution *AwsCloudFrontDistributionDetails

	// Provides details about a CloudTrail trail.
	AwsCloudTrailTrail *AwsCloudTrailTrailDetails

	// Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and
	// receive alerts about your Amazon Web Services resources and applications across
	// multiple Regions.
	AwsCloudWatchAlarm *AwsCloudWatchAlarmDetails

	// Details for an CodeBuild project.
	AwsCodeBuildProject *AwsCodeBuildProjectDetails

	//  Provides details about an Database Migration Service (DMS) endpoint. An
	// endpoint provides connection, data store type, and location information about
	// your data store.
	AwsDmsEndpoint *AwsDmsEndpointDetails

	//  Provides details about an DMS replication instance. DMS uses a replication
	// instance to connect to your source data store, read the source data, and format
	// the data for consumption by the target data store.
	AwsDmsReplicationInstance *AwsDmsReplicationInstanceDetails

	//  Provides details about an DMS replication task. A replication task moves a set
	// of data from the source endpoint to the target endpoint.
	AwsDmsReplicationTask *AwsDmsReplicationTaskDetails

	// Details about a DynamoDB table.
	AwsDynamoDbTable *AwsDynamoDbTableDetails

	//  Provides details about an Client VPN endpoint. A Client VPN endpoint is the
	// resource that you create and configure to enable and manage client VPN sessions.
	// It's the termination point for all client VPN sessions.
	AwsEc2ClientVpnEndpoint *AwsEc2ClientVpnEndpointDetails

	// Details about an Elastic IP address.
	AwsEc2Eip *AwsEc2EipDetails

	// Details about an EC2 instance related to a finding.
	AwsEc2Instance *AwsEc2InstanceDetails

	//  Specifies the properties for creating an Amazon Elastic Compute Cloud (Amazon
	// EC2) launch template.
	AwsEc2LaunchTemplate *AwsEc2LaunchTemplateDetails

	// Details about an EC2 network access control list (ACL).
	AwsEc2NetworkAcl *AwsEc2NetworkAclDetails

	// Details for an EC2 network interface.
	AwsEc2NetworkInterface *AwsEc2NetworkInterfaceDetails

	//  Provides details about a route table. A route table contains a set of rules,
	// called routes, that determine where to direct network traffic from your subnet
	// or gateway.
	AwsEc2RouteTable *AwsEc2RouteTableDetails

	// Details for an EC2 security group.
	AwsEc2SecurityGroup *AwsEc2SecurityGroupDetails

	// Details about a subnet in Amazon EC2.
	AwsEc2Subnet *AwsEc2SubnetDetails

	// Details about an Amazon EC2 transit gateway that interconnects your virtual
	// private clouds (VPC) and on-premises networks.
	AwsEc2TransitGateway *AwsEc2TransitGatewayDetails

	// Details for an Amazon EC2 volume.
	AwsEc2Volume *AwsEc2VolumeDetails

	// Details for an Amazon EC2 VPC.
	AwsEc2Vpc *AwsEc2VpcDetails

	// Details about the service configuration for a VPC endpoint service.
	AwsEc2VpcEndpointService *AwsEc2VpcEndpointServiceDetails

	// Details about an Amazon EC2 VPC peering connection. A VPC peering connection is
	// a networking connection between two VPCs that enables you to route traffic
	// between them privately.
	AwsEc2VpcPeeringConnection *AwsEc2VpcPeeringConnectionDetails

	// Details about an Amazon EC2 VPN connection.
	AwsEc2VpnConnection *AwsEc2VpnConnectionDetails

	// Information about an Amazon ECR image.
	AwsEcrContainerImage *AwsEcrContainerImageDetails

	// Information about an Amazon Elastic Container Registry repository.
	AwsEcrRepository *AwsEcrRepositoryDetails

	// Details about an Amazon ECS cluster.
	AwsEcsCluster *AwsEcsClusterDetails

	// Provides information about a Docker container that's part of a task.
	AwsEcsContainer *AwsEcsContainerDetails

	// Details about a service within an ECS cluster.
	AwsEcsService *AwsEcsServiceDetails

	// Details about a task in a cluster.
	AwsEcsTask *AwsEcsTaskDetails

	// Details about a task definition. A task definition describes the container and
	// volume definitions of an Amazon Elastic Container Service task.
	AwsEcsTaskDefinition *AwsEcsTaskDefinitionDetails

	// Details about an Amazon EFS access point. An access point is an
	// application-specific view into an EFS file system that applies an operating
	// system user and group, and a file system path, to any file system request made
	// through the access point.
	AwsEfsAccessPoint *AwsEfsAccessPointDetails

	// Details about an Amazon EKS cluster.
	AwsEksCluster *AwsEksClusterDetails

	// Details about an Elastic Beanstalk environment.
	AwsElasticBeanstalkEnvironment *AwsElasticBeanstalkEnvironmentDetails

	// Details for an Elasticsearch domain.
	AwsElasticsearchDomain *AwsElasticsearchDomainDetails

	// Contains details about a Classic Load Balancer.
	AwsElbLoadBalancer *AwsElbLoadBalancerDetails

	// Details about a load balancer.
	AwsElbv2LoadBalancer *AwsElbv2LoadBalancerDetails

	//  A schema defines the structure of events that are sent to Amazon EventBridge.
	// Schema registries are containers for schemas. They collect and organize schemas
	// so that your schemas are in logical groups.
	AwsEventSchemasRegistry *AwsEventSchemasRegistryDetails

	//  Provides details about an Amazon EventBridge global endpoint. The endpoint can
	// improve your application’s availability by making it Regional-fault tolerant.
	AwsEventsEndpoint *AwsEventsEndpointDetails

	//  Provides details about Amazon EventBridge event bus for an endpoint. An event
	// bus is a router that receives events and delivers them to zero or more
	// destinations, or targets.
	AwsEventsEventbus *AwsEventsEventbusDetails

	//  Provides details about an Amazon GuardDuty detector. A detector is an object
	// that represents the GuardDuty service. A detector is required for GuardDuty to
	// become operational.
	AwsGuardDutyDetector *AwsGuardDutyDetectorDetails

	// Details about an IAM access key related to a finding.
	AwsIamAccessKey *AwsIamAccessKeyDetails

	// Contains details about an IAM group.
	AwsIamGroup *AwsIamGroupDetails

	// Details about an IAM permissions policy.
	AwsIamPolicy *AwsIamPolicyDetails

	// Details about an IAM role.
	AwsIamRole *AwsIamRoleDetails

	// Details about an IAM user.
	AwsIamUser *AwsIamUserDetails

	// Details about an Amazon Kinesis data stream.
	AwsKinesisStream *AwsKinesisStreamDetails

	// Details about an KMS key.
	AwsKmsKey *AwsKmsKeyDetails

	// Details about a Lambda function.
	AwsLambdaFunction *AwsLambdaFunctionDetails

	// Details for a Lambda layer version.
	AwsLambdaLayerVersion *AwsLambdaLayerVersionDetails

	//  Provides details about an Amazon Managed Streaming for Apache Kafka (Amazon
	// MSK) cluster.
	AwsMskCluster *AwsMskClusterDetails

	// Details about an Network Firewall firewall.
	AwsNetworkFirewallFirewall *AwsNetworkFirewallFirewallDetails

	// Details about an Network Firewall firewall policy.
	AwsNetworkFirewallFirewallPolicy *AwsNetworkFirewallFirewallPolicyDetails

	// Details about an Network Firewall rule group.
	AwsNetworkFirewallRuleGroup *AwsNetworkFirewallRuleGroupDetails

	// Details about an Amazon OpenSearch Service domain.
	AwsOpenSearchServiceDomain *AwsOpenSearchServiceDomainDetails

	// Details about an Amazon RDS database cluster.
	AwsRdsDbCluster *AwsRdsDbClusterDetails

	// Details about an Amazon RDS database cluster snapshot.
	AwsRdsDbClusterSnapshot *AwsRdsDbClusterSnapshotDetails

	// Details about an Amazon RDS database instance.
	AwsRdsDbInstance *AwsRdsDbInstanceDetails

	// Details about an Amazon RDS DB security group.
	AwsRdsDbSecurityGroup *AwsRdsDbSecurityGroupDetails

	// Details about an Amazon RDS database snapshot.
	AwsRdsDbSnapshot *AwsRdsDbSnapshotDetails

	// Details about an RDS event notification subscription.
	AwsRdsEventSubscription *AwsRdsEventSubscriptionDetails

	// Contains details about an Amazon Redshift cluster.
	AwsRedshiftCluster *AwsRedshiftClusterDetails

	//  Provides details about an Amazon Route 53 hosted zone, including the four name
	// servers assigned to the hosted zone. A hosted zone represents a collection of
	// records that can be managed together, belonging to a single parent domain name.
	AwsRoute53HostedZone *AwsRoute53HostedZoneDetails

	//  Provides details about an Amazon Simple Storage Service (Amazon S3) access
	// point. S3 access points are named network endpoints that are attached to S3
	// buckets that you can use to perform S3 object operations.
	AwsS3AccessPoint *AwsS3AccessPointDetails

	// Details about the Amazon S3 Public Access Block configuration for an account.
	AwsS3AccountPublicAccessBlock *AwsS3AccountPublicAccessBlockDetails

	// Details about an S3 bucket related to a finding.
	AwsS3Bucket *AwsS3BucketDetails

	// Details about an S3 object related to a finding.
	AwsS3Object *AwsS3ObjectDetails

	//  Provides details about an Amazon SageMaker notebook instance.
	AwsSageMakerNotebookInstance *AwsSageMakerNotebookInstanceDetails

	// Details about a Secrets Manager secret.
	AwsSecretsManagerSecret *AwsSecretsManagerSecretDetails

	// Details about an SNS topic.
	AwsSnsTopic *AwsSnsTopicDetails

	// Details about an SQS queue.
	AwsSqsQueue *AwsSqsQueueDetails

	// Provides information about the state of a patch on an instance based on the
	// patch baseline that was used to patch the instance.
	AwsSsmPatchCompliance *AwsSsmPatchComplianceDetails

	//  Provides details about an Step Functions state machine, which is a workflow
	// consisting of a series of event-driven steps.
	AwsStepFunctionStateMachine *AwsStepFunctionStateMachineDetails

	// Details about a rate-based rule for global resources.
	AwsWafRateBasedRule *AwsWafRateBasedRuleDetails

	// Details about a rate-based rule for Regional resources.
	AwsWafRegionalRateBasedRule *AwsWafRegionalRateBasedRuleDetails

	// Details about an WAF rule for Regional resources.
	AwsWafRegionalRule *AwsWafRegionalRuleDetails

	// Details about an WAF rule group for Regional resources.
	AwsWafRegionalRuleGroup *AwsWafRegionalRuleGroupDetails

	// Details about an WAF web access control list (web ACL) for Regional resources.
	AwsWafRegionalWebAcl *AwsWafRegionalWebAclDetails

	// Details about an WAF rule for global resources.
	AwsWafRule *AwsWafRuleDetails

	// Details about an WAF rule group for global resources.
	AwsWafRuleGroup *AwsWafRuleGroupDetails

	// Details for an WAF web ACL.
	AwsWafWebAcl *AwsWafWebAclDetails

	//  Details about an WAFv2 rule group.
	AwsWafv2RuleGroup *AwsWafv2RuleGroupDetails

	//  Details about an WAFv2 web Access Control List (ACL).
	AwsWafv2WebAcl *AwsWafv2WebAclDetails

	// Information about the encryption configuration for X-Ray.
	AwsXrayEncryptionConfig *AwsXrayEncryptionConfigDetails

	// Details about a container resource related to a finding.
	Container *ContainerDetails

	// Details about a resource that are not available in a type-specific details
	// object. Use the Other object in the following cases.
	//
	//   - The type-specific object does not contain all of the fields that you want
	//   to populate. In this case, first use the type-specific object to populate those
	//   fields. Use the Other object to populate the fields that are missing from the
	//   type-specific object.
	//
	//   - The resource type does not have a corresponding object. This includes
	//   resources for which the type is Other .
	Other map[string]string

	noSmithyDocumentSerde
}

// Details about the account that was not processed.
type Result struct {

	// An Amazon Web Services account ID of the account that was not processed.
	AccountId *string

	// The reason that the account was not processed.
	ProcessingResult *string

	noSmithyDocumentSerde
}

// Provides details about the routes in the route table.
type RouteSetDetails struct {

	//  The ID of the carrier gateway.
	CarrierGatewayId *string

	//  The Amazon Resource Name (ARN) of the core network.
	CoreNetworkArn *string

	//  The IPv4 CIDR block used for the destination match.
	DestinationCidrBlock *string

	//  The IPv6 CIDR block used for the destination match.
	DestinationIpv6CidrBlock *string

	//  The prefix of the destination Amazon Web Service.
	DestinationPrefixListId *string

	//  The ID of the egress-only internet gateway.
	EgressOnlyInternetGatewayId *string

	//  The ID of a gateway attached to your VPC.
	GatewayId *string

	//  The ID of a NAT instance in your VPC.
	InstanceId *string

	//  The ID of the Amazon Web Services account that owns the instance.
	InstanceOwnerId *string

	//  The ID of the local gateway.
	LocalGatewayId *string

	//  The ID of a NAT gateway.
	NatGatewayId *string

	//  The ID of the network interface.
	NetworkInterfaceId *string

	//  Describes how the route was created.
	Origin *string

	//  The state of the route.
	State *string

	//  The ID of a transit gateway.
	TransitGatewayId *string

	//  The ID of a VPC peering connection.
	VpcPeeringConnectionId *string

	noSmithyDocumentSerde
}

// Details about the rule group.
type RuleGroupDetails struct {

	// Additional settings to use in the specified rules.
	RuleVariables *RuleGroupVariables

	// The rules and actions for the rule group.
	//
	// For stateful rule groups, can contain RulesString , RulesSourceList , or
	// StatefulRules .
	//
	// For stateless rule groups, contains StatelessRulesAndCustomActions .
	RulesSource *RuleGroupSource

	noSmithyDocumentSerde
}

// The rules and actions for the rule group.
type RuleGroupSource struct {

	// Stateful inspection criteria for a domain list rule group. A domain list rule
	// group determines access by specific protocols to specific domains.
	RulesSourceList *RuleGroupSourceListDetails

	// Stateful inspection criteria, provided in Suricata compatible intrusion
	// prevention system (IPS) rules.
	RulesString *string

	// Suricata rule specifications.
	StatefulRules []RuleGroupSourceStatefulRulesDetails

	// The stateless rules and custom actions used by a stateless rule group.
	StatelessRulesAndCustomActions *RuleGroupSourceStatelessRulesAndCustomActionsDetails

	noSmithyDocumentSerde
}

// A custom action definition. A custom action is an optional, non-standard action
// to use for stateless packet handling.
type RuleGroupSourceCustomActionsDetails struct {

	// The definition of a custom action.
	ActionDefinition *StatelessCustomActionDefinition

	// A descriptive name of the custom action.
	ActionName *string

	noSmithyDocumentSerde
}

// Stateful inspection criteria for a domain list rule group.
type RuleGroupSourceListDetails struct {

	// Indicates whether to allow or deny access to the domains listed in Targets .
	GeneratedRulesType *string

	// The protocols that you want to inspect. Specify LS_SNI for HTTPS. Specify
	// HTTP_HOST for HTTP. You can specify either or both.
	TargetTypes []string

	// The domains that you want to inspect for in your traffic flows. You can provide
	// full domain names, or use the '.' prefix as a wildcard. For example,
	// .example.com matches all domains that end with example.com .
	Targets []string

	noSmithyDocumentSerde
}

// A Suricata rule specification.
type RuleGroupSourceStatefulRulesDetails struct {

	// Defines what Network Firewall should do with the packets in a traffic flow when
	// the flow matches the stateful rule criteria.
	Action *string

	// The stateful inspection criteria for the rule.
	Header *RuleGroupSourceStatefulRulesHeaderDetails

	// Additional options for the rule.
	RuleOptions []RuleGroupSourceStatefulRulesOptionsDetails

	noSmithyDocumentSerde
}

// The inspection criteria for a stateful rule.
type RuleGroupSourceStatefulRulesHeaderDetails struct {

	// The destination IP address or address range to inspect for, in CIDR notation.
	// To match with any address, specify ANY .
	Destination *string

	// The destination port to inspect for. You can specify an individual port, such
	// as 1994 . You also can specify a port range, such as 1990:1994 . To match with
	// any port, specify ANY .
	DestinationPort *string

	// The direction of traffic flow to inspect. If set to ANY , the inspection matches
	// bidirectional traffic, both from the source to the destination and from the
	// destination to the source. If set to FORWARD , the inspection only matches
	// traffic going from the source to the destination.
	Direction *string

	// The protocol to inspect for. To inspector for all protocols, use IP .
	Protocol *string

	// The source IP address or address range to inspect for, in CIDR notation. To
	// match with any address, specify ANY .
	Source *string

	// The source port to inspect for. You can specify an individual port, such as 1994
	// . You also can specify a port range, such as 1990:1994 . To match with any port,
	// specify ANY .
	SourcePort *string

	noSmithyDocumentSerde
}

// A rule option for a stateful rule.
type RuleGroupSourceStatefulRulesOptionsDetails struct {

	// A keyword to look for.
	Keyword *string

	// A list of settings.
	Settings []string

	noSmithyDocumentSerde
}

// The definition of the stateless rule.
type RuleGroupSourceStatelessRuleDefinition struct {

	// The actions to take on a packet that matches one of the stateless rule
	// definition's match attributes. You must specify a standard action ( aws:pass ,
	// aws:drop , or aws:forward_to_sfe ). You can then add custom actions.
	Actions []string

	// The criteria for Network Firewall to use to inspect an individual packet in a
	// stateless rule inspection.
	MatchAttributes *RuleGroupSourceStatelessRuleMatchAttributes

	noSmithyDocumentSerde
}

// Criteria for the stateless rule.
type RuleGroupSourceStatelessRuleMatchAttributes struct {

	// A list of port ranges to specify the destination ports to inspect for.
	DestinationPorts []RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts

	// The destination IP addresses and address ranges to inspect for, in CIDR
	// notation.
	Destinations []RuleGroupSourceStatelessRuleMatchAttributesDestinations

	// The protocols to inspect for.
	Protocols []int32

	// A list of port ranges to specify the source ports to inspect for.
	SourcePorts []RuleGroupSourceStatelessRuleMatchAttributesSourcePorts

	// The source IP addresses and address ranges to inspect for, in CIDR notation.
	Sources []RuleGroupSourceStatelessRuleMatchAttributesSources

	// The TCP flags and masks to inspect for.
	TcpFlags []RuleGroupSourceStatelessRuleMatchAttributesTcpFlags

	noSmithyDocumentSerde
}

// A port range to specify the destination ports to inspect for.
type RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts struct {

	// The starting port value for the port range.
	FromPort *int32

	// The ending port value for the port range.
	ToPort *int32

	noSmithyDocumentSerde
}

// A destination IP address or range.
type RuleGroupSourceStatelessRuleMatchAttributesDestinations struct {

	// An IP address or a block of IP addresses.
	AddressDefinition *string

	noSmithyDocumentSerde
}

// A port range to specify the source ports to inspect for.
type RuleGroupSourceStatelessRuleMatchAttributesSourcePorts struct {

	// The starting port value for the port range.
	FromPort *int32

	// The ending port value for the port range.
	ToPort *int32

	noSmithyDocumentSerde
}

// A source IP addresses and address range to inspect for.
type RuleGroupSourceStatelessRuleMatchAttributesSources struct {

	// An IP address or a block of IP addresses.
	AddressDefinition *string

	noSmithyDocumentSerde
}

// A set of TCP flags and masks to inspect for.
type RuleGroupSourceStatelessRuleMatchAttributesTcpFlags struct {

	// Defines the flags from the Masks setting that must be set in order for the
	// packet to match. Flags that are listed must be set. Flags that are not listed
	// must not be set.
	Flags []string

	// The set of flags to consider in the inspection. If not specified, then all
	// flags are inspected.
	Masks []string

	noSmithyDocumentSerde
}

// Stateless rules and custom actions for a stateless rule group.
type RuleGroupSourceStatelessRulesAndCustomActionsDetails struct {

	// Custom actions for the rule group.
	CustomActions []RuleGroupSourceCustomActionsDetails

	// Stateless rules for the rule group.
	StatelessRules []RuleGroupSourceStatelessRulesDetails

	noSmithyDocumentSerde
}

// A stateless rule in the rule group.
type RuleGroupSourceStatelessRulesDetails struct {

	// Indicates the order in which to run this rule relative to all of the rules in
	// the stateless rule group.
	Priority *int32

	// Provides the definition of the stateless rule.
	RuleDefinition *RuleGroupSourceStatelessRuleDefinition

	noSmithyDocumentSerde
}

// Additional settings to use in the specified rules.
type RuleGroupVariables struct {

	// A list of IP addresses and address ranges, in CIDR notation.
	IpSets *RuleGroupVariablesIpSetsDetails

	// A list of port ranges.
	PortSets *RuleGroupVariablesPortSetsDetails

	noSmithyDocumentSerde
}

// A list of IP addresses and address ranges, in CIDR notation.
type RuleGroupVariablesIpSetsDetails struct {

	// The list of IP addresses and ranges.
	Definition []string

	noSmithyDocumentSerde
}

// A list of port ranges.
type RuleGroupVariablesPortSetsDetails struct {

	// The list of port ranges.
	Definition []string

	noSmithyDocumentSerde
}

//	A security control in Security Hub describes a security best practice related
//
// to a specific resource.
type SecurityControl struct {

	//  The description of a security control across standards. This typically
	// summarizes how Security Hub evaluates the control and the conditions under which
	// it produces a failed finding. This parameter doesn't reference a specific
	// standard.
	//
	// This member is required.
	Description *string

	//  A link to Security Hub documentation that explains how to remediate a failed
	// finding for a security control.
	//
	// This member is required.
	RemediationUrl *string

	//  The Amazon Resource Name (ARN) for a security control across standards, such
	// as arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1 . This
	// parameter doesn't mention a specific standard.
	//
	// This member is required.
	SecurityControlArn *string

	//  The unique identifier of a security control across standards. Values for this
	// field typically consist of an Amazon Web Service name and a number, such as
	// APIGateway.3.
	//
	// This member is required.
	SecurityControlId *string

	//  The enablement status of a security control in a specific standard.
	//
	// This member is required.
	SecurityControlStatus ControlStatus

	//  The severity of a security control. For more information about how Security
	// Hub determines control severity, see [Assigning severity to control findings]in the Security Hub User Guide.
	//
	// [Assigning severity to control findings]: https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity
	//
	// This member is required.
	SeverityRating SeverityRating

	// The title of a security control.
	//
	// This member is required.
	Title *string

	//  The most recent reason for updating the customizable properties of a security
	// control. This differs from the UpdateReason field of the [BatchUpdateStandardsControlAssociations]
	// BatchUpdateStandardsControlAssociations API, which tracks the reason for
	// updating the enablement status of a control. This field accepts alphanumeric
	// characters in addition to white spaces, dashes, and underscores.
	//
	// [BatchUpdateStandardsControlAssociations]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html
	LastUpdateReason *string

	//  An object that identifies the name of a control parameter, its current value,
	// and whether it has been customized.
	Parameters map[string]ParameterConfiguration

	//  Identifies whether customizable properties of a security control are reflected
	// in Security Hub findings. A status of READY indicates findings include the
	// current parameter values. A status of UPDATING indicates that all findings may
	// not include the current parameter values.
	UpdateStatus UpdateStatus

	noSmithyDocumentSerde
}

//	A list of security controls and control parameter values that are included in
//
// a configuration policy.
type SecurityControlCustomParameter struct {

	//  An object that specifies parameter values for a control in a configuration
	// policy.
	Parameters map[string]ParameterConfiguration

	//  The ID of the security control.
	SecurityControlId *string

	noSmithyDocumentSerde
}

//	Provides metadata for a security control, including its unique
//
// standard-agnostic identifier, title, description, severity, availability in
// Amazon Web Services Regions, and a link to remediation steps.
type SecurityControlDefinition struct {

	//  Specifies whether a security control is available in the current Amazon Web
	// Services Region.
	//
	// This member is required.
	CurrentRegionAvailability RegionAvailabilityStatus

	//  The description of a security control across standards. This typically
	// summarizes how Security Hub evaluates the control and the conditions under which
	// it produces a failed finding. This parameter doesn't reference a specific
	// standard.
	//
	// This member is required.
	Description *string

	//  A link to Security Hub documentation that explains how to remediate a failed
	// finding for a security control.
	//
	// This member is required.
	RemediationUrl *string

	//  The unique identifier of a security control across standards. Values for this
	// field typically consist of an Amazon Web Service name and a number (for example,
	// APIGateway.3). This parameter differs from SecurityControlArn , which is a
	// unique Amazon Resource Name (ARN) assigned to a control. The ARN references the
	// security control ID (for example,
	// arn:aws:securityhub:eu-central-1:123456789012:security-control/APIGateway.3).
	//
	// This member is required.
	SecurityControlId *string

	//  The severity of a security control. For more information about how Security
	// Hub determines control severity, see [Assigning severity to control findings]in the Security Hub User Guide.
	//
	// [Assigning severity to control findings]: https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity
	//
	// This member is required.
	SeverityRating SeverityRating

	//  The title of a security control.
	//
	// This member is required.
	Title *string

	//  Security control properties that you can customize. Currently, only parameter
	// customization is supported for select controls. An empty array is returned for
	// controls that don’t support custom properties.
	CustomizableProperties []SecurityControlProperty

	//  An object that provides a security control parameter name, description, and
	// the options for customizing it. This object is excluded for a control that
	// doesn't support custom parameters.
	ParameterDefinitions map[string]ParameterDefinition

	noSmithyDocumentSerde
}

// A parameter that a security control accepts.
type SecurityControlParameter struct {

	//  The name of a
	Name *string

	//  The current value of a control parameter.
	Value []string

	noSmithyDocumentSerde
}

//	An object that defines which security controls are enabled in an Security Hub
//
// configuration policy. The enablement status of a control is aligned across all
// of the enabled standards in an account.
type SecurityControlsConfiguration struct {

	//  A list of security controls that are disabled in the configuration policy.
	// Security Hub enables all other controls (including newly released controls)
	// other than the listed controls.
	DisabledSecurityControlIdentifiers []string

	//  A list of security controls that are enabled in the configuration policy.
	// Security Hub disables all other controls (including newly released controls)
	// other than the listed controls.
	EnabledSecurityControlIdentifiers []string

	//  A list of security controls and control parameter values that are included in
	// a configuration policy.
	SecurityControlCustomParameters []SecurityControlCustomParameter

	noSmithyDocumentSerde
}

//	An object that defines how Security Hub is configured. The configuration
//
// policy includes whether Security Hub is enabled or disabled, a list of enabled
// security standards, a list of enabled or disabled security controls, and a list
// of custom parameter values for specified controls. If you provide a list of
// security controls that are enabled in the configuration policy, Security Hub
// disables all other controls (including newly released controls). If you provide
// a list of security controls that are disabled in the configuration policy,
// Security Hub enables all other controls (including newly released controls).
type SecurityHubPolicy struct {

	//  A list that defines which security standards are enabled in the configuration
	// policy.
	EnabledStandardIdentifiers []string

	//  An object that defines which security controls are enabled in the
	// configuration policy. The enablement status of a control is aligned across all
	// of the enabled standards in an account.
	SecurityControlsConfiguration *SecurityControlsConfiguration

	//  Indicates whether Security Hub is enabled in the policy.
	ServiceEnabled *bool

	noSmithyDocumentSerde
}

// The list of detected instances of sensitive data.
type SensitiveDataDetections struct {

	// The total number of occurrences of sensitive data that were detected.
	Count *int64

	// Details about the sensitive data that was detected.
	Occurrences *Occurrences

	// The type of sensitive data that was detected. For example, the type might
	// indicate that the data is an email address.
	Type *string

	noSmithyDocumentSerde
}

// Contains a detected instance of sensitive data that are based on built-in
// identifiers.
type SensitiveDataResult struct {

	// The category of sensitive data that was detected. For example, the category can
	// indicate that the sensitive data involved credentials, financial information, or
	// personal information.
	Category *string

	// The list of detected instances of sensitive data.
	Detections []SensitiveDataDetections

	// The total number of occurrences of sensitive data.
	TotalCount *int64

	noSmithyDocumentSerde
}

// The severity of the finding.
//
// The finding provider can provide the initial severity. The finding provider can
// only update the severity if it hasn't been updated using BatchUpdateFindings .
//
// The finding must have either Label or Normalized populated. If only one of
// these attributes is populated, then Security Hub automatically populates the
// other one. If neither attribute is populated, then the finding is invalid. Label
// is the preferred attribute.
type Severity struct {

	// The severity value of the finding. The allowed values are the following.
	//
	//   - INFORMATIONAL - No issue was found.
	//
	//   - LOW - The issue does not require action on its own.
	//
	//   - MEDIUM - The issue must be addressed but not urgently.
	//
	//   - HIGH - The issue must be addressed as a priority.
	//
	//   - CRITICAL - The issue must be remediated immediately to avoid it escalating.
	//
	// If you provide Normalized and do not provide Label , then Label is set
	// automatically as follows.
	//
	//   - 0 - INFORMATIONAL
	//
	//   - 1–39 - LOW
	//
	//   - 40–69 - MEDIUM
	//
	//   - 70–89 - HIGH
	//
	//   - 90–100 - CRITICAL
	Label SeverityLabel

	// Deprecated. The normalized severity of a finding. Instead of providing
	// Normalized , provide Label .
	//
	// The value of Normalized can be an integer between 0 and 100 .
	//
	// If you provide Label and do not provide Normalized , then Normalized is set
	// automatically as follows.
	//
	//   - INFORMATIONAL - 0
	//
	//   - LOW - 1
	//
	//   - MEDIUM - 40
	//
	//   - HIGH - 70
	//
	//   - CRITICAL - 90
	Normalized *int32

	// The native severity from the finding product that generated the finding.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 64.
	Original *string

	// Deprecated. This attribute isn't included in findings. Instead of providing
	// Product , provide Original .
	//
	// The native severity as defined by the Amazon Web Services service or integrated
	// partner product that generated the finding.
	Product *float64

	noSmithyDocumentSerde
}

// Updates to the severity information for a finding.
type SeverityUpdate struct {

	// The severity value of the finding. The allowed values are the following.
	//
	//   - INFORMATIONAL - No issue was found.
	//
	//   - LOW - The issue does not require action on its own.
	//
	//   - MEDIUM - The issue must be addressed but not urgently.
	//
	//   - HIGH - The issue must be addressed as a priority.
	//
	//   - CRITICAL - The issue must be remediated immediately to avoid it escalating.
	Label SeverityLabel

	// The normalized severity for the finding. This attribute is to be deprecated in
	// favor of Label .
	//
	// If you provide Normalized and do not provide Label , Label is set automatically
	// as follows.
	//
	//   - 0 - INFORMATIONAL
	//
	//   - 1–39 - LOW
	//
	//   - 40–69 - MEDIUM
	//
	//   - 70–89 - HIGH
	//
	//   - 90–100 - CRITICAL
	Normalized *int32

	// The native severity as defined by the Amazon Web Services service or integrated
	// partner product that generated the finding.
	Product *float64

	noSmithyDocumentSerde
}

// Information about a software package.
type SoftwarePackage struct {

	// The architecture used for the software package.
	Architecture *string

	// The epoch of the software package.
	Epoch *string

	// The file system path to the package manager inventory file.
	FilePath *string

	// The version of the software package in which the vulnerability has been
	// resolved.
	FixedInVersion *string

	// The name of the software package.
	Name *string

	// The source of the package.
	PackageManager *string

	// The release of the software package.
	Release *string

	// Describes the actions a customer can take to resolve the vulnerability in the
	// software package.
	Remediation *string

	// The Amazon Resource Name (ARN) of the source layer.
	SourceLayerArn *string

	// The source layer hash of the vulnerable package.
	SourceLayerHash *string

	// The version of the software package.
	Version *string

	noSmithyDocumentSerde
}

// A collection of finding attributes used to sort findings.
type SortCriterion struct {

	// The finding attribute used to sort findings.
	Field *string

	// The order used to sort findings.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Provides information about a specific security standard.
type Standard struct {

	// A description of the standard.
	Description *string

	// Whether the standard is enabled by default. When Security Hub is enabled from
	// the console, if a standard is enabled by default, the check box for that
	// standard is selected by default.
	//
	// When Security Hub is enabled using the EnableSecurityHub API operation, the
	// standard is enabled by default unless EnableDefaultStandards is set to false .
	EnabledByDefault *bool

	// The name of the standard.
	Name *string

	// The ARN of a standard.
	StandardsArn *string

	// Provides details about the management of a standard.
	StandardsManagedBy *StandardsManagedBy

	noSmithyDocumentSerde
}

// Details for an individual security standard control.
type StandardsControl struct {

	// The identifier of the security standard control.
	ControlId *string

	// The current status of the security standard control. Indicates whether the
	// control is enabled or disabled. Security Hub does not check against disabled
	// controls.
	ControlStatus ControlStatus

	// The date and time that the status of the security standard control was most
	// recently updated.
	ControlStatusUpdatedAt *time.Time

	// The longer description of the security standard control. Provides information
	// about what the control is checking for.
	Description *string

	// The reason provided for the most recent change in status for the control.
	DisabledReason *string

	// The list of requirements that are related to this control.
	RelatedRequirements []string

	// A link to remediation information for the control in the Security Hub user
	// documentation.
	RemediationUrl *string

	// The severity of findings generated from this security standard control.
	//
	// The finding severity is based on an assessment of how easy it would be to
	// compromise Amazon Web Services resources if the issue is detected.
	SeverityRating SeverityRating

	// The ARN of the security standard control.
	StandardsControlArn *string

	// The title of the security standard control.
	Title *string

	noSmithyDocumentSerde
}

// Provides details about a control's enablement status in a specified standard.
type StandardsControlAssociationDetail struct {

	//  Specifies whether a control is enabled or disabled in a specified standard.
	//
	// This member is required.
	AssociationStatus AssociationStatus

	//  The ARN of a security control across standards, such as
	// arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1 . This
	// parameter doesn't mention a specific standard.
	//
	// This member is required.
	SecurityControlArn *string

	//  The unique identifier of a security control across standards. Values for this
	// field typically consist of an Amazon Web Service name and a number, such as
	// APIGateway.3.
	//
	// This member is required.
	SecurityControlId *string

	//  The Amazon Resource Name (ARN) of a security standard.
	//
	// This member is required.
	StandardsArn *string

	//  The requirement that underlies a control in the compliance framework related
	// to the standard.
	RelatedRequirements []string

	//  Provides the input parameter that Security Hub uses to call the [UpdateStandardsControl] API. This API
	// can be used to enable or disable a control in a specified standard.
	//
	// [UpdateStandardsControl]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateStandardsControl.html
	StandardsControlArns []string

	//  The description of a control. This typically summarizes how Security Hub
	// evaluates the control and the conditions under which it produces a failed
	// finding. This parameter may reference a specific standard.
	StandardsControlDescription *string

	//  The title of a control. This field may reference a specific standard.
	StandardsControlTitle *string

	//  The time at which the enablement status of the control in the specified
	// standard was last updated.
	UpdatedAt *time.Time

	//  The reason for updating the enablement status of a control in a specified
	// standard.
	UpdatedReason *string

	noSmithyDocumentSerde
}

//	An array with one or more objects that includes a security control (identified
//
// with SecurityControlId , SecurityControlArn , or a mix of both parameters) and
// the Amazon Resource Name (ARN) of a standard. The security control ID or ARN is
// the same across standards.
type StandardsControlAssociationId struct {

	//  The unique identifier (identified with SecurityControlId , SecurityControlArn ,
	// or a mix of both parameters) of a security control across standards.
	//
	// This member is required.
	SecurityControlId *string

	//  The ARN of a standard.
	//
	// This member is required.
	StandardsArn *string

	noSmithyDocumentSerde
}

//	An array that provides the enablement status and other details for each
//
// control that applies to each enabled standard.
type StandardsControlAssociationSummary struct {

	//  The enablement status of a control in a specific standard.
	//
	// This member is required.
	AssociationStatus AssociationStatus

	//  The ARN of a control, such as
	// arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1 . This
	// parameter doesn't mention a specific standard.
	//
	// This member is required.
	SecurityControlArn *string

	//  A unique standard-agnostic identifier for a control. Values for this field
	// typically consist of an Amazon Web Service and a number, such as APIGateway.5.
	// This field doesn't reference a specific standard.
	//
	// This member is required.
	SecurityControlId *string

	//  The Amazon Resource Name (ARN) of a standard.
	//
	// This member is required.
	StandardsArn *string

	//  The requirement that underlies this control in the compliance framework
	// related to the standard.
	RelatedRequirements []string

	//  The description of a control. This typically summarizes how Security Hub
	// evaluates the control and the conditions under which it produces a failed
	// finding. The parameter may reference a specific standard.
	StandardsControlDescription *string

	//  The title of a control.
	StandardsControlTitle *string

	// The last time that a control's enablement status in a specified standard was
	// updated.
	UpdatedAt *time.Time

	// The reason for updating a control's enablement status in a specified standard.
	UpdatedReason *string

	noSmithyDocumentSerde
}

// An array of requested updates to the enablement status of controls in specified
// standards. The objects in the array include a security control ID, the Amazon
// Resource Name (ARN) of the standard, the requested enablement status, and the
// reason for updating the enablement status.
type StandardsControlAssociationUpdate struct {

	// The desired enablement status of the control in the standard.
	//
	// This member is required.
	AssociationStatus AssociationStatus

	// The unique identifier for the security control whose enablement status you want
	// to update.
	//
	// This member is required.
	SecurityControlId *string

	// The Amazon Resource Name (ARN) of the standard in which you want to update the
	// control's enablement status.
	//
	// This member is required.
	StandardsArn *string

	// The reason for updating the control's enablement status in the standard.
	UpdatedReason *string

	noSmithyDocumentSerde
}

// Provides details about the management of a security standard.
type StandardsManagedBy struct {

	// An identifier for the company that manages a specific security standard. For
	// existing standards, the value is equal to Amazon Web Services .
	Company *string

	// An identifier for the product that manages a specific security standard. For
	// existing standards, the value is equal to the Amazon Web Services service that
	// manages the standard.
	Product *string

	noSmithyDocumentSerde
}

// The reason for the current status of a standard subscription.
type StandardsStatusReason struct {

	// The reason code that represents the reason for the current status of a standard
	// subscription.
	//
	// This member is required.
	StatusReasonCode StatusReasonCode

	noSmithyDocumentSerde
}

// A resource that represents your subscription to a supported standard.
type StandardsSubscription struct {

	// The ARN of a standard.
	//
	// This member is required.
	StandardsArn *string

	// A key-value pair of input for the standard.
	//
	// This member is required.
	StandardsInput map[string]string

	// The status of the standard subscription.
	//
	// The status values are as follows:
	//
	//   - PENDING - Standard is in the process of being enabled.
	//
	//   - READY - Standard is enabled.
	//
	//   - INCOMPLETE - Standard could not be enabled completely. Some controls may not
	//   be available.
	//
	//   - DELETING - Standard is in the process of being disabled.
	//
	//   - FAILED - Standard could not be disabled.
	//
	// This member is required.
	StandardsStatus StandardsStatus

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// This member is required.
	StandardsSubscriptionArn *string

	// The reason for the current status.
	StandardsStatusReason *StandardsStatusReason

	noSmithyDocumentSerde
}

// The standard that you want to enable.
type StandardsSubscriptionRequest struct {

	// The ARN of the standard that you want to enable. To view the list of available
	// standards and their ARNs, use the DescribeStandards operation.
	//
	// This member is required.
	StandardsArn *string

	// A key-value pair of input for the standard.
	StandardsInput map[string]string

	noSmithyDocumentSerde
}

// The definition of a custom action that can be used for stateless packet
// handling.
type StatelessCustomActionDefinition struct {

	// Information about metrics to publish to CloudWatch.
	PublishMetricAction *StatelessCustomPublishMetricAction

	noSmithyDocumentSerde
}

// Information about metrics to publish to CloudWatch.
type StatelessCustomPublishMetricAction struct {

	// Defines CloudWatch dimension values to publish.
	Dimensions []StatelessCustomPublishMetricActionDimension

	noSmithyDocumentSerde
}

// Defines a CloudWatch dimension value to publish.
type StatelessCustomPublishMetricActionDimension struct {

	// The value to use for the custom metric dimension.
	Value *string

	noSmithyDocumentSerde
}

// Provides additional context for the value of Compliance.Status .
type StatusReason struct {

	// A code that represents a reason for the control status. For the list of status
	// reason codes and their meanings, see [Standards-related information in the ASFF]in the Security Hub User Guide.
	//
	// [Standards-related information in the ASFF]: https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff
	//
	// This member is required.
	ReasonCode *string

	// The corresponding description for the status reason code.
	Description *string

	noSmithyDocumentSerde
}

// The options for customizing a security control parameter that is a string.
type StringConfigurationOptions struct {

	//  The Security Hub default value for a control parameter that is a string.
	DefaultValue *string

	//  The description of the RE2 regular expression.
	ExpressionDescription *string

	//  An RE2 regular expression that Security Hub uses to validate a user-provided
	// control parameter string.
	Re2Expression *string

	noSmithyDocumentSerde
}

// A string filter for filtering Security Hub findings.
type StringFilter struct {

	// The condition to apply to a string value when filtering Security Hub findings.
	//
	// To search for values that have the filter value, use one of the following
	// comparison operators:
	//
	//   - To search for values that include the filter value, use CONTAINS . For
	//   example, the filter Title CONTAINS CloudFront matches findings that have a
	//   Title that includes the string CloudFront.
	//
	//   - To search for values that exactly match the filter value, use EQUALS . For
	//   example, the filter AwsAccountId EQUALS 123456789012 only matches findings
	//   that have an account ID of 123456789012 .
	//
	//   - To search for values that start with the filter value, use PREFIX . For
	//   example, the filter ResourceRegion PREFIX us matches findings that have a
	//   ResourceRegion that starts with us . A ResourceRegion that starts with a
	//   different value, such as af , ap , or ca , doesn't match.
	//
	// CONTAINS , EQUALS , and PREFIX filters on the same field are joined by OR . A
	// finding matches if it matches any one of those filters. For example, the filters
	// Title CONTAINS CloudFront OR Title CONTAINS CloudWatch match a finding that
	// includes either CloudFront , CloudWatch , or both strings in the title.
	//
	// To search for values that don’t have the filter value, use one of the following
	// comparison operators:
	//
	//   - To search for values that exclude the filter value, use NOT_CONTAINS . For
	//   example, the filter Title NOT_CONTAINS CloudFront matches findings that have a
	//   Title that excludes the string CloudFront.
	//
	//   - To search for values other than the filter value, use NOT_EQUALS . For
	//   example, the filter AwsAccountId NOT_EQUALS 123456789012 only matches findings
	//   that have an account ID other than 123456789012 .
	//
	//   - To search for values that don't start with the filter value, use
	//   PREFIX_NOT_EQUALS . For example, the filter ResourceRegion PREFIX_NOT_EQUALS
	//   us matches findings with a ResourceRegion that starts with a value other than
	//   us .
	//
	// NOT_CONTAINS , NOT_EQUALS , and PREFIX_NOT_EQUALS filters on the same field are
	// joined by AND . A finding matches only if it matches all of those filters. For
	// example, the filters Title NOT_CONTAINS CloudFront AND Title NOT_CONTAINS
	// CloudWatch match a finding that excludes both CloudFront and CloudWatch in the
	// title.
	//
	// You can’t have both a CONTAINS filter and a NOT_CONTAINS filter on the same
	// field. Similarly, you can't provide both an EQUALS filter and a NOT_EQUALS or
	// PREFIX_NOT_EQUALS filter on the same field. Combining filters in this way
	// returns an error. CONTAINS filters can only be used with other CONTAINS
	// filters. NOT_CONTAINS filters can only be used with other NOT_CONTAINS filters.
	//
	// You can combine PREFIX filters with NOT_EQUALS or PREFIX_NOT_EQUALS filters for
	// the same field. Security Hub first processes the PREFIX filters, and then the
	// NOT_EQUALS or PREFIX_NOT_EQUALS filters.
	//
	// For example, for the following filters, Security Hub first identifies findings
	// that have resource types that start with either AwsIam or AwsEc2 . It then
	// excludes findings that have a resource type of AwsIamPolicy and findings that
	// have a resource type of AwsEc2NetworkInterface .
	//
	//   - ResourceType PREFIX AwsIam
	//
	//   - ResourceType PREFIX AwsEc2
	//
	//   - ResourceType NOT_EQUALS AwsIamPolicy
	//
	//   - ResourceType NOT_EQUALS AwsEc2NetworkInterface
	//
	// CONTAINS and NOT_CONTAINS operators can be used only with automation rules. For
	// more information, see [Automation rules]in the Security Hub User Guide.
	//
	// [Automation rules]: https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html
	Comparison StringFilterComparison

	// The string filter value. Filter values are case sensitive. For example, the
	// product name for control-based findings is Security Hub . If you provide
	// security hub as the filter value, there's no match.
	Value *string

	noSmithyDocumentSerde
}

//	The options for customizing a security control parameter that is a list of
//
// strings.
type StringListConfigurationOptions struct {

	//  The Security Hub default value for a control parameter that is a list of
	// strings.
	DefaultValue []string

	//  The description of the RE2 regular expression.
	ExpressionDescription *string

	//  The maximum number of list items that a string list control parameter can
	// accept.
	MaxItems *int32

	//  An RE2 regular expression that Security Hub uses to validate a user-provided
	// list of strings for a control parameter.
	Re2Expression *string

	noSmithyDocumentSerde
}

//	The target account, organizational unit, or the root that is associated with
//
// an Security Hub configuration. The configuration can be a configuration policy
// or self-managed behavior.
//
// The following types satisfy this interface:
//
//	TargetMemberAccountId
//	TargetMemberOrganizationalUnitId
//	TargetMemberRootId
type Target interface {
	isTarget()
}

// The Amazon Web Services account ID of the target account.
type TargetMemberAccountId struct {
	Value string

	noSmithyDocumentSerde
}

func (*TargetMemberAccountId) isTarget() {}

// The organizational unit ID of the target organizational unit.
type TargetMemberOrganizationalUnitId struct {
	Value string

	noSmithyDocumentSerde
}

func (*TargetMemberOrganizationalUnitId) isTarget() {}

// The ID of the organization root.
type TargetMemberRootId struct {
	Value string

	noSmithyDocumentSerde
}

func (*TargetMemberRootId) isTarget() {}

// Provides information about the threat detected in a security finding and the
// file paths that were affected by the threat.
type Threat struct {

	// Provides information about the file paths that were affected by the threat.
	//
	// Array Members: Minimum number of 1 item. Maximum number of 5 items.
	FilePaths []FilePaths

	// This total number of items in which the threat has been detected.
	ItemCount *int32

	// The name of the threat.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 128 length.
	Name *string

	// The severity of the threat.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 128 length.
	Severity *string

	noSmithyDocumentSerde
}

// Details about the threat intelligence related to a finding.
type ThreatIntelIndicator struct {

	// The category of a threat intelligence indicator.
	Category ThreatIntelIndicatorCategory

	// Indicates when the most recent instance of a threat intelligence indicator was
	// observed.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	LastObservedAt *string

	// The source of the threat intelligence indicator.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 64 length.
	Source *string

	// The URL to the page or site where you can get more information about the threat
	// intelligence indicator.
	SourceUrl *string

	// The type of threat intelligence indicator.
	Type ThreatIntelIndicatorType

	// The value of a threat intelligence indicator.
	//
	// Length Constraints: Minimum of 1 length. Maximum of 512 length.
	Value *string

	noSmithyDocumentSerde
}

//	A list of objects containing RuleArn , ErrorCode , and ErrorMessage . This
//
// parameter tells you which automation rules the request didn't process and why.
type UnprocessedAutomationRule struct {

	//  The error code associated with the unprocessed automation rule.
	ErrorCode *int32

	//  An error message describing why a request didn't process a specific rule.
	ErrorMessage *string

	//  The Amazon Resource Name (ARN) for the unprocessed automation rule.
	RuleArn *string

	noSmithyDocumentSerde
}

//	An array of configuration policy associations, one for each configuration
//
// policy association identifier, that was specified in a
// BatchGetConfigurationPolicyAssociations request but couldn’t be processed due to
// an error.
type UnprocessedConfigurationPolicyAssociation struct {

	//  Configuration policy association identifiers that were specified in a
	// BatchGetConfigurationPolicyAssociations request but couldn’t be processed due to
	// an error.
	ConfigurationPolicyAssociationIdentifiers *ConfigurationPolicyAssociation

	//  An HTTP status code that identifies why the configuration policy association
	// failed.
	ErrorCode *string

	//  A string that identifies why the configuration policy association failed.
	ErrorReason *string

	noSmithyDocumentSerde
}

//	Provides details about a security control for which a response couldn't be
//
// returned.
type UnprocessedSecurityControl struct {

	//  The error code for the unprocessed security control.
	//
	// This member is required.
	ErrorCode UnprocessedErrorCode

	//  The control (identified with SecurityControlId , SecurityControlArn , or a mix
	// of both parameters) for which a response couldn't be returned.
	//
	// This member is required.
	SecurityControlId *string

	//  The reason why the security control was unprocessed.
	ErrorReason *string

	noSmithyDocumentSerde
}

//	Provides details about which control's enablement status couldn't be retrieved
//
// in a specified standard when calling [BatchUpdateStandardsControlAssociations]. This parameter also provides details
// about why the request was unprocessed.
//
// [BatchUpdateStandardsControlAssociations]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html
type UnprocessedStandardsControlAssociation struct {

	// The error code for the unprocessed standard and control association.
	//
	// This member is required.
	ErrorCode UnprocessedErrorCode

	//  An array with one or more objects that includes a security control (identified
	// with SecurityControlId , SecurityControlArn , or a mix of both parameters) and
	// the Amazon Resource Name (ARN) of a standard. This parameter shows the specific
	// controls for which the enablement status couldn't be retrieved in specified
	// standards when calling [BatchUpdateStandardsControlAssociations].
	//
	// [BatchUpdateStandardsControlAssociations]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html
	//
	// This member is required.
	StandardsControlAssociationId *StandardsControlAssociationId

	// The reason why the standard and control association was unprocessed.
	ErrorReason *string

	noSmithyDocumentSerde
}

// Provides details about which control's enablement status could not be updated
// in a specified standard when calling the [BatchUpdateStandardsControlAssociations]API. This parameter also provides
// details about why the request was unprocessed.
//
// [BatchUpdateStandardsControlAssociations]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html
type UnprocessedStandardsControlAssociationUpdate struct {

	// The error code for the unprocessed update of the control's enablement status in
	// the specified standard.
	//
	// This member is required.
	ErrorCode UnprocessedErrorCode

	// An array of control and standard associations for which an update failed when
	// calling [BatchUpdateStandardsControlAssociations].
	//
	// [BatchUpdateStandardsControlAssociations]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html
	//
	// This member is required.
	StandardsControlAssociationUpdate *StandardsControlAssociationUpdate

	// The reason why a control's enablement status in the specified standard couldn't
	// be updated.
	ErrorReason *string

	noSmithyDocumentSerde
}

// Specifies the parameters to update in an existing automation rule.
type UpdateAutomationRulesRequestItem struct {

	//  The Amazon Resource Name (ARN) for the rule.
	//
	// This member is required.
	RuleArn *string

	//  One or more actions to update finding fields if a finding matches the
	// conditions specified in Criteria .
	Actions []AutomationRulesAction

	//  A set of ASFF finding field attributes and corresponding expected values that
	// Security Hub uses to filter findings. If a rule is enabled and a finding matches
	// the conditions specified in this parameter, Security Hub applies the rule action
	// to the finding.
	Criteria *AutomationRulesFindingFilters

	//  A description of the rule.
	Description *string

	// Specifies whether a rule is the last to be applied with respect to a finding
	// that matches the rule criteria. This is useful when a finding matches the
	// criteria for multiple rules, and each rule has different actions. If a rule is
	// terminal, Security Hub applies the rule action to a finding that matches the
	// rule criteria and doesn't evaluate other rules for the finding. By default, a
	// rule isn't terminal.
	IsTerminal *bool

	//  The name of the rule.
	RuleName *string

	//  An integer ranging from 1 to 1000 that represents the order in which the rule
	// action is applied to findings. Security Hub applies rules with lower values for
	// this parameter first.
	RuleOrder *int32

	//  Whether the rule is active after it is created. If this parameter is equal to
	// ENABLED , Security Hub starts applying the rule to findings and finding updates
	// after the rule is created. To change the value of this parameter after creating
	// a rule, use [BatchUpdateAutomationRules]BatchUpdateAutomationRules .
	//
	// [BatchUpdateAutomationRules]: https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html
	RuleStatus RuleStatus

	noSmithyDocumentSerde
}

// Describes the mounting of a volume in a container.
type VolumeMount struct {

	// The path in the container at which the volume should be mounted.
	MountPath *string

	// The name of the volume.
	Name *string

	noSmithyDocumentSerde
}

// Provides details about the IPv4 CIDR blocks for the VPC.
type VpcInfoCidrBlockSetDetails struct {

	// The IPv4 CIDR block for the VPC.
	CidrBlock *string

	noSmithyDocumentSerde
}

// Provides details about the IPv6 CIDR blocks for the VPC.
type VpcInfoIpv6CidrBlockSetDetails struct {

	// The IPv6 CIDR block for the VPC.
	Ipv6CidrBlock *string

	noSmithyDocumentSerde
}

// Provides information about the VPC peering connection options for the accepter
// or requester VPC.
type VpcInfoPeeringOptionsDetails struct {

	// Indicates whether a local VPC can resolve public DNS hostnames to private IP
	// addresses when queried from instances in a peer VPC.
	AllowDnsResolutionFromRemoteVpc *bool

	// Indicates whether a local ClassicLink connection can communicate with the peer
	// VPC over the VPC peering connection.
	AllowEgressFromLocalClassicLinkToRemoteVpc *bool

	// Indicates whether a local VPC can communicate with a ClassicLink connection in
	// the peer VPC over the VPC peering connection.
	AllowEgressFromLocalVpcToRemoteClassicLink *bool

	noSmithyDocumentSerde
}

// A vulnerability associated with a finding.
type Vulnerability struct {

	// The identifier of the vulnerability.
	//
	// This member is required.
	Id *string

	// The vulnerabilities found in your Lambda function code. This field pertains to
	// findings that Security Hub receives from Amazon Inspector.
	CodeVulnerabilities []VulnerabilityCodeVulnerabilities

	// CVSS scores from the advisory related to the vulnerability.
	Cvss []Cvss

	// The Exploit Prediction Scoring System (EPSS) score for a finding.
	EpssScore *float64

	// Whether an exploit is available for a finding.
	ExploitAvailable VulnerabilityExploitAvailable

	// Specifies if all vulnerable packages in a finding have a value for
	// FixedInVersion and Remediation . This field is evaluated for each vulnerability
	// Id based on the number of vulnerable packages that have a value for both
	// FixedInVersion and Remediation . Valid values are as follows:
	//
	//   - YES if all vulnerable packages have a value for both FixedInVersion and
	//   Remediation
	//
	//   - NO if no vulnerable packages have a value for FixedInVersion and Remediation
	//
	//   - PARTIAL otherwise
	FixAvailable VulnerabilityFixAvailable

	//  The date and time of the last exploit associated with a finding discovered in
	// your environment.
	LastKnownExploitAt *string

	// A list of URLs that provide additional information about the vulnerability.
	ReferenceUrls []string

	// List of vulnerabilities that are related to this vulnerability.
	RelatedVulnerabilities []string

	// Information about the vendor that generates the vulnerability report.
	Vendor *VulnerabilityVendor

	// List of software packages that have the vulnerability.
	VulnerablePackages []SoftwarePackage

	noSmithyDocumentSerde
}

// Provides details about the vulnerabilities found in your Lambda function code.
// This field pertains to findings that Security Hub receives from Amazon
// Inspector.
type VulnerabilityCodeVulnerabilities struct {

	//  The Common Weakness Enumeration (CWE) item associated with the detected code
	// vulnerability.
	Cwes []string

	//  Provides details about where a code vulnerability is located in your Lambda
	// function.
	FilePath *CodeVulnerabilitiesFilePath

	//  The Amazon Resource Name (ARN) of the Lambda layer in which the code
	// vulnerability is located.
	SourceArn *string

	noSmithyDocumentSerde
}

// A vendor that generates a vulnerability report.
type VulnerabilityVendor struct {

	// The name of the vendor.
	//
	// This member is required.
	Name *string

	// The URL of the vulnerability advisory.
	Url *string

	// Indicates when the vulnerability advisory was created.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	VendorCreatedAt *string

	// The severity that the vendor assigned to the vulnerability.
	VendorSeverity *string

	// Indicates when the vulnerability advisory was last updated.
	//
	// This field accepts only the specified formats. Timestamps can end with Z or
	// ("+" / "-") time-hour [":" time-minute] . The time-secfrac after seconds is
	// limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are
	// valid timestamp formats with examples:
	//
	//   - YYYY-MM-DDTHH:MM:SSZ (for example, 2019-01-31T23:00:00Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ (for example, 2019-01-31T23:00:00.123456789Z )
	//
	//   - YYYY-MM-DDTHH:MM:SS+HH:MM (for example, 2024-01-04T15:25:10+17:59 )
	//
	//   - YYYY-MM-DDTHH:MM:SS-HHMM (for example, 2024-01-04T15:25:10-1759 )
	//
	//   - YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM (for example,
	//   2024-01-04T15:25:10.123456789+17:59 )
	VendorUpdatedAt *string

	noSmithyDocumentSerde
}

// Details about the action that CloudFront or WAF takes when a web request
// matches the conditions in the rule.
type WafAction struct {

	// Specifies how you want WAF to respond to requests that match the settings in a
	// rule.
	//
	// Valid settings include the following:
	//
	//   - ALLOW - WAF allows requests
	//
	//   - BLOCK - WAF blocks requests
	//
	//   - COUNT - WAF increments a counter of the requests that match all of the
	//   conditions in the rule. WAF then continues to inspect the web request based on
	//   the remaining rules in the web ACL. You can't specify COUNT for the default
	//   action for a web ACL.
	Type *string

	noSmithyDocumentSerde
}

// Details about a rule to exclude from a rule group.
type WafExcludedRule struct {

	// The unique identifier for the rule to exclude from the rule group.
	RuleId *string

	noSmithyDocumentSerde
}

// Details about an override action for a rule.
type WafOverrideAction struct {

	// COUNT overrides the action specified by the individual rule within a RuleGroup .
	//
	// If set to NONE , the rule's action takes place.
	Type *string

	noSmithyDocumentSerde
}

// Provides details about the status of the investigation into a finding.
type Workflow struct {

	// The status of the investigation into the finding. The workflow status is
	// specific to an individual finding. It does not affect the generation of new
	// findings. For example, setting the workflow status to SUPPRESSED or RESOLVED
	// does not prevent a new finding for the same issue.
	//
	// The allowed values are the following.
	//
	//   - NEW - The initial state of a finding, before it is reviewed.
	//
	// Security Hub also resets the workflow status from NOTIFIED or RESOLVED to NEW in
	//   the following cases:
	//
	//   - RecordState changes from ARCHIVED to ACTIVE .
	//
	//   - ComplianceStatus changes from PASSED to either WARNING , FAILED , or
	//   NOT_AVAILABLE .
	//
	//   - NOTIFIED - Indicates that you notified the resource owner about the security
	//   issue. Used when the initial reviewer is not the resource owner, and needs
	//   intervention from the resource owner.
	//
	//   - SUPPRESSED - Indicates that you reviewed the finding and do not believe that
	//   any action is needed. The finding is no longer updated.
	//
	//   - RESOLVED - The finding was reviewed and remediated and is now considered
	//   resolved.
	Status WorkflowStatus

	noSmithyDocumentSerde
}

// Used to update information about the investigation into the finding.
type WorkflowUpdate struct {

	// The status of the investigation into the finding. The workflow status is
	// specific to an individual finding. It does not affect the generation of new
	// findings. For example, setting the workflow status to SUPPRESSED or RESOLVED
	// does not prevent a new finding for the same issue.
	//
	// The allowed values are the following.
	//
	//   - NEW - The initial state of a finding, before it is reviewed.
	//
	// Security Hub also resets WorkFlowStatus from NOTIFIED or RESOLVED to NEW in the
	//   following cases:
	//
	//   - The record state changes from ARCHIVED to ACTIVE .
	//
	//   - The compliance status changes from PASSED to either WARNING , FAILED , or
	//   NOT_AVAILABLE .
	//
	//   - NOTIFIED - Indicates that you notified the resource owner about the security
	//   issue. Used when the initial reviewer is not the resource owner, and needs
	//   intervention from the resource owner.
	//
	//   - RESOLVED - The finding was reviewed and remediated and is now considered
	//   resolved.
	//
	//   - SUPPRESSED - Indicates that you reviewed the finding and do not believe that
	//   any action is needed. The finding is no longer updated.
	Status WorkflowStatus

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isConfigurationOptions() {}
func (*UnknownUnionMember) isParameterValue()       {}
func (*UnknownUnionMember) isPolicy()               {}
func (*UnknownUnionMember) isTarget()               {}
