// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets metadata information about a slot type.
func (c *Client) DescribeSlotType(ctx context.Context, params *DescribeSlotTypeInput, optFns ...func(*Options)) (*DescribeSlotTypeOutput, error) {
	if params == nil {
		params = &DescribeSlotTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSlotType", params, optFns, c.addOperationDescribeSlotTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSlotTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSlotTypeInput struct {

	// The identifier of the bot associated with the slot type.
	//
	// This member is required.
	BotId *string

	// The version of the bot associated with the slot type.
	//
	// This member is required.
	BotVersion *string

	// The identifier of the language and locale of the slot type to describe. The
	// string must match one of the supported locales. For more information, see
	// Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
	// .
	//
	// This member is required.
	LocaleId *string

	// The identifier of the slot type.
	//
	// This member is required.
	SlotTypeId *string

	noSmithyDocumentSerde
}

type DescribeSlotTypeOutput struct {

	// The identifier of the bot associated with the slot type.
	BotId *string

	// The version of the bot associated with the slot type.
	BotVersion *string

	// Specifications for a composite slot type.
	CompositeSlotTypeSetting *types.CompositeSlotTypeSetting

	// A timestamp of the date and time that the slot type was created.
	CreationDateTime *time.Time

	// The description specified for the slot type.
	Description *string

	// Provides information about the external source of the slot type's definition.
	ExternalSourceSetting *types.ExternalSourceSetting

	// A timestamp of the date and time that the slot type was last updated.
	LastUpdatedDateTime *time.Time

	// The language and locale specified for the slot type.
	LocaleId *string

	// The built in slot type used as a parent to this slot type.
	ParentSlotTypeSignature *string

	// The unique identifier for the slot type.
	SlotTypeId *string

	// The name specified for the slot type.
	SlotTypeName *string

	// The values that the slot type can take. Includes any synonyms for the slot type
	// values.
	SlotTypeValues []types.SlotTypeValue

	// The strategy that Amazon Lex uses to choose a value from a list of possible
	// values.
	ValueSelectionSetting *types.SlotValueSelectionSetting

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSlotTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeSlotType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeSlotType{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeSlotType"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeSlotTypeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSlotType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeSlotType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSlotType",
	}
}
