// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A collection of accounts and regions.
type AccountAggregationSource struct {

	// The 12-digit account ID of the account being aggregated.
	//
	// This member is required.
	AccountIds []string

	// If true, aggregate existing Config regions and future regions.
	AllAwsRegions bool

	// The source regions being aggregated.
	AwsRegions []string

	noSmithyDocumentSerde
}

// Indicates whether an Config rule is compliant based on account ID, region,
// compliance, and rule name. A rule is compliant if all of the resources that the
// rule evaluated comply with it. It is noncompliant if any of these resources do
// not comply.
type AggregateComplianceByConfigRule struct {

	// The 12-digit account ID of the source account.
	AccountId *string

	// The source region from where the data is aggregated.
	AwsRegion *string

	// Indicates whether an Amazon Web Services resource or Config rule is compliant
	// and provides the number of contributors that affect the compliance.
	Compliance *Compliance

	// The name of the Config rule.
	ConfigRuleName *string

	noSmithyDocumentSerde
}

// Provides aggregate compliance of the conformance pack. Indicates whether a
// conformance pack is compliant based on the name of the conformance pack, account
// ID, and region. A conformance pack is compliant if all of the rules in a
// conformance packs are compliant. It is noncompliant if any of the rules are not
// compliant. The compliance status of a conformance pack is INSUFFICIENT_DATA only
// if all rules within a conformance pack cannot be evaluated due to insufficient
// data. If some of the rules in a conformance pack are compliant but the
// compliance status of other rules in that same conformance pack is
// INSUFFICIENT_DATA, the conformance pack shows compliant.
type AggregateComplianceByConformancePack struct {

	// The 12-digit Amazon Web Services account ID of the source account.
	AccountId *string

	// The source Amazon Web Services Region from where the data is aggregated.
	AwsRegion *string

	// The compliance status of the conformance pack.
	Compliance *AggregateConformancePackCompliance

	// The name of the conformance pack.
	ConformancePackName *string

	noSmithyDocumentSerde
}

// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
type AggregateComplianceCount struct {

	// The number of compliant and noncompliant Config rules.
	ComplianceSummary *ComplianceSummary

	// The 12-digit account ID or region based on the GroupByKey value.
	GroupName *string

	noSmithyDocumentSerde
}

// Provides the number of compliant and noncompliant rules within a conformance
// pack. Also provides the compliance status of the conformance pack and the total
// rule count which includes compliant rules, noncompliant rules, and rules that
// cannot be evaluated due to insufficient data. A conformance pack is compliant if
// all of the rules in a conformance packs are compliant. It is noncompliant if any
// of the rules are not compliant. The compliance status of a conformance pack is
// INSUFFICIENT_DATA only if all rules within a conformance pack cannot be
// evaluated due to insufficient data. If some of the rules in a conformance pack
// are compliant but the compliance status of other rules in that same conformance
// pack is INSUFFICIENT_DATA, the conformance pack shows compliant.
type AggregateConformancePackCompliance struct {

	// The compliance status of the conformance pack.
	ComplianceType ConformancePackComplianceType

	// The number of compliant Config Rules.
	CompliantRuleCount int32

	// The number of noncompliant Config Rules.
	NonCompliantRuleCount int32

	// Total number of compliant rules, noncompliant rules, and the rules that do not
	// have any applicable resources to evaluate upon resulting in insufficient data.
	TotalRuleCount int32

	noSmithyDocumentSerde
}

// The number of conformance packs that are compliant and noncompliant.
type AggregateConformancePackComplianceCount struct {

	// Number of compliant conformance packs.
	CompliantConformancePackCount int32

	// Number of noncompliant conformance packs.
	NonCompliantConformancePackCount int32

	noSmithyDocumentSerde
}

// Filters the conformance packs based on an account ID, region, compliance type,
// and the name of the conformance pack.
type AggregateConformancePackComplianceFilters struct {

	// The 12-digit Amazon Web Services account ID of the source account.
	AccountId *string

	// The source Amazon Web Services Region from where the data is aggregated.
	AwsRegion *string

	// The compliance status of the conformance pack.
	ComplianceType ConformancePackComplianceType

	// The name of the conformance pack.
	ConformancePackName *string

	noSmithyDocumentSerde
}

// Provides a summary of compliance based on either account ID or region.
type AggregateConformancePackComplianceSummary struct {

	// Returns an AggregateConformancePackComplianceCount object.
	ComplianceSummary *AggregateConformancePackComplianceCount

	// Groups the result based on Amazon Web Services account ID or Amazon Web
	// Services Region.
	GroupName *string

	noSmithyDocumentSerde
}

// Filters the results based on account ID and region.
type AggregateConformancePackComplianceSummaryFilters struct {

	// The 12-digit Amazon Web Services account ID of the source account.
	AccountId *string

	// The source Amazon Web Services Region from where the data is aggregated.
	AwsRegion *string

	noSmithyDocumentSerde
}

// The current sync status between the source and the aggregator account.
type AggregatedSourceStatus struct {

	// The region authorized to collect aggregated data.
	AwsRegion *string

	// The error code that Config returned when the source account aggregation last
	// failed.
	LastErrorCode *string

	// The message indicating that the source account aggregation failed due to an
	// error.
	LastErrorMessage *string

	// Filters the last updated status type.
	//   - Valid value FAILED indicates errors while moving data.
	//   - Valid value SUCCEEDED indicates the data was successfully moved.
	//   - Valid value OUTDATED indicates the data is not the most recent.
	LastUpdateStatus AggregatedSourceStatusType

	// The time of the last update.
	LastUpdateTime *time.Time

	// The source account ID or an organization.
	SourceId *string

	// The source account or an organization.
	SourceType AggregatedSourceType

	noSmithyDocumentSerde
}

// The details of an Config evaluation for an account ID and region in an
// aggregator. Provides the Amazon Web Services resource that was evaluated, the
// compliance of the resource, related time stamps, and supplementary information.
type AggregateEvaluationResult struct {

	// The 12-digit account ID of the source account.
	AccountId *string

	// Supplementary information about how the agrregate evaluation determined the
	// compliance.
	Annotation *string

	// The source region from where the data is aggregated.
	AwsRegion *string

	// The resource compliance status. For the AggregationEvaluationResult data type,
	// Config supports only the COMPLIANT and NON_COMPLIANT . Config does not support
	// the NOT_APPLICABLE and INSUFFICIENT_DATA value.
	ComplianceType ComplianceType

	// The time when the Config rule evaluated the Amazon Web Services resource.
	ConfigRuleInvokedTime *time.Time

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier

	// The time when Config recorded the aggregate evaluation result.
	ResultRecordedTime *time.Time

	noSmithyDocumentSerde
}

// The details that identify a resource that is collected by Config aggregator,
// including the resource type, ID, (if available) the custom resource name, the
// source account, and source region.
type AggregateResourceIdentifier struct {

	// The ID of the Amazon Web Services resource.
	//
	// This member is required.
	ResourceId *string

	// The type of the Amazon Web Services resource.
	//
	// This member is required.
	ResourceType ResourceType

	// The 12-digit account ID of the source account.
	//
	// This member is required.
	SourceAccountId *string

	// The source region where data is aggregated.
	//
	// This member is required.
	SourceRegion *string

	// The name of the Amazon Web Services resource.
	ResourceName *string

	noSmithyDocumentSerde
}

// An object that represents the authorizations granted to aggregator accounts and
// regions.
type AggregationAuthorization struct {

	// The Amazon Resource Name (ARN) of the aggregation object.
	AggregationAuthorizationArn *string

	// The 12-digit account ID of the account authorized to aggregate data.
	AuthorizedAccountId *string

	// The region authorized to collect aggregated data.
	AuthorizedAwsRegion *string

	// The time stamp when the aggregation authorization was created.
	CreationTime *time.Time

	noSmithyDocumentSerde
}

// The detailed configurations of a specified resource.
type BaseConfigurationItem struct {

	// The 12-digit Amazon Web Services account ID associated with the resource.
	AccountId *string

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// The Availability Zone associated with the resource.
	AvailabilityZone *string

	// The region where the resource resides.
	AwsRegion *string

	// The description of the resource configuration.
	Configuration *string

	// The time when the recording of configuration changes was initiated for the
	// resource.
	ConfigurationItemCaptureTime *time.Time

	// The time when configuration changes for the resource were delivered.
	ConfigurationItemDeliveryTime *time.Time

	// The configuration item status. Valid values include:
	//   - OK – The resource configuration has been updated.
	//   - ResourceDiscovered – The resource was newly discovered.
	//   - ResourceNotRecorded – The resource was discovered, but its configuration
	//   was not recorded since the recorder doesn't record resources of this type.
	//   - ResourceDeleted – The resource was deleted
	//   - ResourceDeletedNotRecorded – The resource was deleted, but its
	//   configuration was not recorded since the recorder doesn't record resources of
	//   this type.
	ConfigurationItemStatus ConfigurationItemStatus

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string

	// The recording frequency that Config uses to record configuration changes for
	// the resource.
	RecordingFrequency RecordingFrequency

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string

	// The custom name of the resource, if available.
	ResourceName *string

	// The type of Amazon Web Services resource.
	ResourceType ResourceType

	// Configuration attributes that Config returns for certain resource types to
	// supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]string

	// The version number of the resource configuration.
	Version *string

	noSmithyDocumentSerde
}

// Indicates whether an Amazon Web Services resource or Config rule is compliant
// and provides the number of contributors that affect the compliance.
type Compliance struct {

	// The number of Amazon Web Services resources or Config rules that cause a result
	// of NON_COMPLIANT , up to a maximum number.
	ComplianceContributorCount *ComplianceContributorCount

	// Indicates whether an Amazon Web Services resource or Config rule is compliant.
	// A resource is compliant if it complies with all of the Config rules that
	// evaluate it. A resource is noncompliant if it does not comply with one or more
	// of these rules. A rule is compliant if all of the resources that the rule
	// evaluates comply with it. A rule is noncompliant if any of these resources do
	// not comply. Config returns the INSUFFICIENT_DATA value when no evaluation
	// results are available for the Amazon Web Services resource or Config rule. For
	// the Compliance data type, Config supports only COMPLIANT , NON_COMPLIANT , and
	// INSUFFICIENT_DATA values. Config does not support the NOT_APPLICABLE value for
	// the Compliance data type.
	ComplianceType ComplianceType

	noSmithyDocumentSerde
}

// Indicates whether an Config rule is compliant. A rule is compliant if all of
// the resources that the rule evaluated comply with it. A rule is noncompliant if
// any of these resources do not comply.
type ComplianceByConfigRule struct {

	// Indicates whether the Config rule is compliant.
	Compliance *Compliance

	// The name of the Config rule.
	ConfigRuleName *string

	noSmithyDocumentSerde
}

// Indicates whether an Amazon Web Services resource that is evaluated according
// to one or more Config rules is compliant. A resource is compliant if it complies
// with all of the rules that evaluate it. A resource is noncompliant if it does
// not comply with one or more of these rules.
type ComplianceByResource struct {

	// Indicates whether the Amazon Web Services resource complies with all of the
	// Config rules that evaluated it.
	Compliance *Compliance

	// The ID of the Amazon Web Services resource that was evaluated.
	ResourceId *string

	// The type of the Amazon Web Services resource that was evaluated.
	ResourceType *string

	noSmithyDocumentSerde
}

// The number of Amazon Web Services resources or Config rules responsible for the
// current compliance of the item, up to a maximum number.
type ComplianceContributorCount struct {

	// Indicates whether the maximum count is reached.
	CapExceeded bool

	// The number of Amazon Web Services resources or Config rules responsible for the
	// current compliance of the item.
	CappedCount int32

	noSmithyDocumentSerde
}

// The number of Config rules or Amazon Web Services resources that are compliant
// and noncompliant.
type ComplianceSummary struct {

	// The time that Config created the compliance summary.
	ComplianceSummaryTimestamp *time.Time

	// The number of Config rules or Amazon Web Services resources that are compliant,
	// up to a maximum of 25 for rules and 100 for resources.
	CompliantResourceCount *ComplianceContributorCount

	// The number of Config rules or Amazon Web Services resources that are
	// noncompliant, up to a maximum of 25 for rules and 100 for resources.
	NonCompliantResourceCount *ComplianceContributorCount

	noSmithyDocumentSerde
}

// The number of Amazon Web Services resources of a specific type that are
// compliant or noncompliant, up to a maximum of 100 for each.
type ComplianceSummaryByResourceType struct {

	// The number of Amazon Web Services resources that are compliant or noncompliant,
	// up to a maximum of 100 for each.
	ComplianceSummary *ComplianceSummary

	// The type of Amazon Web Services resource.
	ResourceType *string

	noSmithyDocumentSerde
}

// Provides status of the delivery of the snapshot or the configuration history to
// the specified Amazon S3 bucket. Also provides the status of notifications about
// the Amazon S3 delivery to the specified Amazon SNS topic.
type ConfigExportDeliveryInfo struct {

	// The time of the last attempted delivery.
	LastAttemptTime *time.Time

	// The error code from the last attempted delivery.
	LastErrorCode *string

	// The error message from the last attempted delivery.
	LastErrorMessage *string

	// Status of the last attempted delivery.
	LastStatus DeliveryStatus

	// The time of the last successful delivery.
	LastSuccessfulTime *time.Time

	// The time that the next delivery occurs.
	NextDeliveryTime *time.Time

	noSmithyDocumentSerde
}

// Config rules evaluate the configuration settings of your Amazon Web Services
// resources. A rule can run when Config detects a configuration change to an
// Amazon Web Services resource or at a periodic frequency that you choose (for
// example, every 24 hours). There are two types of rules: Config Managed Rules and
// Config Custom Rules. Config Managed Rules are predefined, customizable rules
// created by Config. For a list of managed rules, see List of Config Managed Rules (https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html)
// . Config Custom Rules are rules that you create from scratch. There are two ways
// to create Config custom rules: with Lambda functions ( Lambda Developer Guide (https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function)
// ) and with Guard ( Guard GitHub Repository (https://github.com/aws-cloudformation/cloudformation-guard)
// ), a policy-as-code language. Config custom rules created with Lambda are called
// Config Custom Lambda Rules and Config custom rules created with Guard are called
// Config Custom Policy Rules. For more information about developing and using
// Config rules, see Evaluating Resource with Config Rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the Config Developer Guide. You can use the Amazon Web Services CLI and
// Amazon Web Services SDKs if you want to create a rule that triggers evaluations
// for your resources when Config delivers the configuration snapshot. For more
// information, see ConfigSnapshotDeliveryProperties .
type ConfigRule struct {

	// Provides the rule owner ( Amazon Web Services for managed rules, CUSTOM_POLICY
	// for Custom Policy rules, and CUSTOM_LAMBDA for Custom Lambda rules), the rule
	// identifier, and the notifications that cause the function to evaluate your
	// Amazon Web Services resources.
	//
	// This member is required.
	Source *Source

	// The Amazon Resource Name (ARN) of the Config rule.
	ConfigRuleArn *string

	// The ID of the Config rule.
	ConfigRuleId *string

	// The name that you assign to the Config rule. The name is required if you are
	// adding a new rule.
	ConfigRuleName *string

	// Indicates whether the Config rule is active or is currently being deleted by
	// Config. It can also indicate the evaluation status for the Config rule. Config
	// sets the state of the rule to EVALUATING temporarily after you use the
	// StartConfigRulesEvaluation request to evaluate your resources against the Config
	// rule. Config sets the state of the rule to DELETING_RESULTS temporarily after
	// you use the DeleteEvaluationResults request to delete the current evaluation
	// results for the Config rule. Config temporarily sets the state of a rule to
	// DELETING after you use the DeleteConfigRule request to delete the rule. After
	// Config deletes the rule, the rule and all of its evaluations are erased and are
	// no longer available.
	ConfigRuleState ConfigRuleState

	// Service principal name of the service that created the rule. The field is
	// populated only if the service-linked rule is created by a service. The field is
	// empty if you create your own rule.
	CreatedBy *string

	// The description that you provide for the Config rule.
	Description *string

	// The modes the Config rule can be evaluated in. The valid values are distinct
	// objects. By default, the value is Detective evaluation mode only.
	EvaluationModes []EvaluationModeConfiguration

	// A string, in JSON format, that is passed to the Config rule Lambda function.
	InputParameters *string

	// The maximum frequency with which Config runs evaluations for a rule. You can
	// specify a value for MaximumExecutionFrequency when:
	//   - This is for an Config managed rule that is triggered at a periodic
	//   frequency.
	//   - Your custom rule is triggered when Config delivers the configuration
	//   snapshot. For more information, see ConfigSnapshotDeliveryProperties .
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	MaximumExecutionFrequency MaximumExecutionFrequency

	// Defines which resources can trigger an evaluation for the rule. The scope can
	// include one or more resource types, a combination of one resource type and one
	// resource ID, or a combination of a tag key and value. Specify a scope to
	// constrain the resources that can trigger an evaluation for the rule. If you do
	// not specify a scope, evaluations are triggered when any resource in the
	// recording group changes. The scope can be empty.
	Scope *Scope

	noSmithyDocumentSerde
}

// Filters the compliance results based on account ID, region, compliance type,
// and rule name.
type ConfigRuleComplianceFilters struct {

	// The 12-digit account ID of the source account.
	AccountId *string

	// The source region where the data is aggregated.
	AwsRegion *string

	// The rule compliance status. For the ConfigRuleComplianceFilters data type,
	// Config supports only COMPLIANT and NON_COMPLIANT . Config does not support the
	// NOT_APPLICABLE and the INSUFFICIENT_DATA values.
	ComplianceType ComplianceType

	// The name of the Config rule.
	ConfigRuleName *string

	noSmithyDocumentSerde
}

// Filters the results based on the account IDs and regions.
type ConfigRuleComplianceSummaryFilters struct {

	// The 12-digit account ID of the source account.
	AccountId *string

	// The source region where the data is aggregated.
	AwsRegion *string

	noSmithyDocumentSerde
}

// Status information for your Config Managed rules and Config Custom Policy
// rules. The status includes information such as the last time the rule ran, the
// last time it failed, and the related error for the last failure. This action
// does not return status information about Config Custom Lambda rules.
type ConfigRuleEvaluationStatus struct {

	// The Amazon Resource Name (ARN) of the Config rule.
	ConfigRuleArn *string

	// The ID of the Config rule.
	ConfigRuleId *string

	// The name of the Config rule.
	ConfigRuleName *string

	// The time that you first activated the Config rule.
	FirstActivatedTime *time.Time

	// Indicates whether Config has evaluated your resources against the rule at least
	// once.
	//   - true - Config has evaluated your Amazon Web Services resources against the
	//   rule at least once.
	//   - false - Config has not finished evaluating your Amazon Web Services
	//   resources against the rule at least once.
	FirstEvaluationStarted bool

	// The time that you last turned off the Config rule.
	LastDeactivatedTime *time.Time

	// The status of the last attempted delivery of a debug log for your Config Custom
	// Policy rules. Either Successful or Failed .
	LastDebugLogDeliveryStatus *string

	// The reason Config was not able to deliver a debug log. This is for the last
	// failed attempt to retrieve a debug log for your Config Custom Policy rules.
	LastDebugLogDeliveryStatusReason *string

	// The time Config last attempted to deliver a debug log for your Config Custom
	// Policy rules.
	LastDebugLogDeliveryTime *time.Time

	// The error code that Config returned when the rule last failed.
	LastErrorCode *string

	// The error message that Config returned when the rule last failed.
	LastErrorMessage *string

	// The time that Config last failed to evaluate your Amazon Web Services resources
	// against the rule.
	LastFailedEvaluationTime *time.Time

	// The time that Config last failed to invoke the Config rule to evaluate your
	// Amazon Web Services resources.
	LastFailedInvocationTime *time.Time

	// The time that Config last successfully evaluated your Amazon Web Services
	// resources against the rule.
	LastSuccessfulEvaluationTime *time.Time

	// The time that Config last successfully invoked the Config rule to evaluate your
	// Amazon Web Services resources.
	LastSuccessfulInvocationTime *time.Time

	noSmithyDocumentSerde
}

// Provides options for how often Config delivers configuration snapshots to the
// Amazon S3 bucket in your delivery channel. The frequency for a rule that
// triggers evaluations for your resources when Config delivers the configuration
// snapshot is set by one of two values, depending on which is less frequent:
//   - The value for the deliveryFrequency parameter within the delivery channel
//     configuration, which sets how often Config delivers configuration snapshots.
//     This value also sets how often Config invokes evaluations for Config rules.
//   - The value for the MaximumExecutionFrequency parameter, which sets the
//     maximum frequency with which Config invokes evaluations for the rule. For more
//     information, see ConfigRule .
//
// If the deliveryFrequency value is less frequent than the
// MaximumExecutionFrequency value for a rule, Config invokes the rule only as
// often as the deliveryFrequency value.
//   - For example, you want your rule to run evaluations when Config delivers the
//     configuration snapshot.
//   - You specify the MaximumExecutionFrequency value for Six_Hours .
//   - You then specify the delivery channel deliveryFrequency value for
//     TwentyFour_Hours .
//   - Because the value for deliveryFrequency is less frequent than
//     MaximumExecutionFrequency , Config invokes evaluations for the rule every 24
//     hours.
//
// You should set the MaximumExecutionFrequency value to be at least as frequent
// as the deliveryFrequency value. You can view the deliveryFrequency value by
// using the DescribeDeliveryChannnels action. To update the deliveryFrequency
// with which Config delivers your configuration snapshots, use the
// PutDeliveryChannel action.
type ConfigSnapshotDeliveryProperties struct {

	// The frequency with which Config delivers configuration snapshots.
	DeliveryFrequency MaximumExecutionFrequency

	noSmithyDocumentSerde
}

// A list that contains the status of the delivery of the configuration stream
// notification to the Amazon SNS topic.
type ConfigStreamDeliveryInfo struct {

	// The error code from the last attempted delivery.
	LastErrorCode *string

	// The error message from the last attempted delivery.
	LastErrorMessage *string

	// Status of the last attempted delivery. Note Providing an SNS topic on a
	// DeliveryChannel (https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html)
	// for Config is optional. If the SNS delivery is turned off, the last status will
	// be Not_Applicable.
	LastStatus DeliveryStatus

	// The time from the last status change.
	LastStatusChangeTime *time.Time

	noSmithyDocumentSerde
}

// The details about the configuration aggregator, including information about
// source accounts, regions, and metadata of the aggregator.
type ConfigurationAggregator struct {

	// Provides a list of source accounts and regions to be aggregated.
	AccountAggregationSources []AccountAggregationSource

	// The Amazon Resource Name (ARN) of the aggregator.
	ConfigurationAggregatorArn *string

	// The name of the aggregator.
	ConfigurationAggregatorName *string

	// Amazon Web Services service that created the configuration aggregator.
	CreatedBy *string

	// The time stamp when the configuration aggregator was created.
	CreationTime *time.Time

	// The time of the last update.
	LastUpdatedTime *time.Time

	// Provides an organization and list of regions to be aggregated.
	OrganizationAggregationSource *OrganizationAggregationSource

	noSmithyDocumentSerde
}

// A list that contains detailed configurations of a specified resource.
type ConfigurationItem struct {

	// The 12-digit Amazon Web Services account ID associated with the resource.
	AccountId *string

	// Amazon Resource Name (ARN) associated with the resource.
	Arn *string

	// The Availability Zone associated with the resource.
	AvailabilityZone *string

	// The region where the resource resides.
	AwsRegion *string

	// The description of the resource configuration.
	Configuration *string

	// The time when the recording of configuration changes was initiated for the
	// resource.
	ConfigurationItemCaptureTime *time.Time

	// The time when configuration changes for the resource were delivered.
	ConfigurationItemDeliveryTime *time.Time

	// Unique MD5 hash that represents the configuration item's state. You can use MD5
	// hash to compare the states of two or more configuration items that are
	// associated with the same resource.
	ConfigurationItemMD5Hash *string

	// The configuration item status. Valid values include:
	//   - OK – The resource configuration has been updated
	//   - ResourceDiscovered – The resource was newly discovered
	//   - ResourceNotRecorded – The resource was discovered but its configuration was
	//   not recorded since the recorder doesn't record resources of this type
	//   - ResourceDeleted – The resource was deleted
	//   - ResourceDeletedNotRecorded – The resource was deleted but its configuration
	//   was not recorded since the recorder doesn't record resources of this type
	ConfigurationItemStatus ConfigurationItemStatus

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string

	// The recording frequency that Config uses to record configuration changes for
	// the resource.
	RecordingFrequency RecordingFrequency

	// A list of CloudTrail event IDs. A populated field indicates that the current
	// configuration was initiated by the events recorded in the CloudTrail log. For
	// more information about CloudTrail, see What Is CloudTrail (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html)
	// . An empty field indicates that the current configuration was not initiated by
	// any event. As of Version 1.3, the relatedEvents field is empty. You can access
	// the LookupEvents API (https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html)
	// in the CloudTrail API Reference to retrieve the events for the resource.
	RelatedEvents []string

	// A list of related Amazon Web Services resources.
	Relationships []Relationship

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time

	// The ID of the resource (for example, sg-xxxxxx ).
	ResourceId *string

	// The custom name of the resource, if available.
	ResourceName *string

	// The type of Amazon Web Services resource.
	ResourceType ResourceType

	// Configuration attributes that Config returns for certain resource types to
	// supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]string

	// A mapping of key value tags associated with the resource.
	Tags map[string]string

	// The version number of the resource configuration.
	Version *string

	noSmithyDocumentSerde
}

// Records configuration changes to your specified resource types. For more
// information about the configuration recorder, see Managing the Configuration
// Recorder  (https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html)
// in the Config Developer Guide.
type ConfigurationRecorder struct {

	// The name of the configuration recorder. Config automatically assigns the name
	// of "default" when creating the configuration recorder. You cannot change the
	// name of the configuration recorder after it has been created. To change the
	// configuration recorder name, you must delete it and create a new configuration
	// recorder with a new name.
	Name *string

	// Specifies which resource types Config records for configuration changes. High
	// Number of Config Evaluations You may notice increased activity in your account
	// during your initial month recording with Config when compared to subsequent
	// months. During the initial bootstrapping process, Config runs evaluations on all
	// the resources in your account that you have selected for Config to record. If
	// you are running ephemeral workloads, you may see increased activity from Config
	// as it records configuration changes associated with creating and deleting these
	// temporary resources. An ephemeral workload is a temporary use of computing
	// resources that are loaded and run when needed. Examples include Amazon Elastic
	// Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling. If
	// you want to avoid the increased activity from running ephemeral workloads, you
	// can run these types of workloads in a separate account with Config turned off to
	// avoid increased configuration recording and rule evaluations.
	RecordingGroup *RecordingGroup

	// Specifies the default recording frequency that Config uses to record
	// configuration changes. Config supports Continuous recording and Daily recording.
	//
	//   - Continuous recording allows you to record configuration changes
	//   continuously whenever a change occurs.
	//   - Daily recording allows you to receive a configuration item (CI)
	//   representing the most recent state of your resources over the last 24-hour
	//   period, only if it’s different from the previous CI recorded.
	// Firewall Manager depends on continuous recording to monitor your resources. If
	// you are using Firewall Manager, it is recommended that you set the recording
	// frequency to Continuous. You can also override the recording frequency for
	// specific resource types.
	RecordingMode *RecordingMode

	// Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the
	// configuration recorder. While the API model does not require this field, the
	// server will reject a request without a defined roleARN for the configuration
	// recorder. Pre-existing Config role If you have used an Amazon Web Services
	// service that uses Config, such as Security Hub or Control Tower, and an Config
	// role has already been created, make sure that the IAM role that you use when
	// setting up Config keeps the same minimum permissions as the already created
	// Config role. You must do this so that the other Amazon Web Services service
	// continues to run as expected. For example, if Control Tower has an IAM role that
	// allows Config to read Amazon Simple Storage Service (Amazon S3) objects, make
	// sure that the same permissions are granted within the IAM role you use when
	// setting up Config. Otherwise, it may interfere with how Control Tower operates.
	// For more information about IAM roles for Config, see Identity and Access
	// Management for Config  (https://docs.aws.amazon.com/config/latest/developerguide/security-iam.html)
	// in the Config Developer Guide.
	RoleARN *string

	noSmithyDocumentSerde
}

// The current status of the configuration recorder. For a detailed status of
// recording events over time, add your Config events to CloudWatch metrics and use
// CloudWatch metrics.
type ConfigurationRecorderStatus struct {

	// The latest error code from when the recorder last failed.
	LastErrorCode *string

	// The latest error message from when the recorder last failed.
	LastErrorMessage *string

	// The time the recorder was last started.
	LastStartTime *time.Time

	// The status of the latest recording event processed by the recorder.
	LastStatus RecorderStatus

	// The time of the latest change in status of an recording event processed by the
	// recorder.
	LastStatusChangeTime *time.Time

	// The time the recorder was last stopped.
	LastStopTime *time.Time

	// The name of the configuration recorder.
	Name *string

	// Specifies whether or not the recorder is currently recording.
	Recording bool

	noSmithyDocumentSerde
}

// Filters the conformance pack by compliance types and Config rule names.
type ConformancePackComplianceFilters struct {

	// Filters the results by compliance. The allowed values are COMPLIANT and
	// NON_COMPLIANT . INSUFFICIENT_DATA is not supported.
	ComplianceType ConformancePackComplianceType

	// Filters the results by Config rule names.
	ConfigRuleNames []string

	noSmithyDocumentSerde
}

// A compliance score is the percentage of the number of compliant rule-resource
// combinations in a conformance pack compared to the number of total possible
// rule-resource combinations in the conformance pack. This metric provides you
// with a high-level view of the compliance state of your conformance packs. You
// can use it to identify, investigate, and understand the level of compliance in
// your conformance packs.
type ConformancePackComplianceScore struct {

	// The name of the conformance pack.
	ConformancePackName *string

	// The time that the conformance pack compliance score was last updated.
	LastUpdatedTime *time.Time

	// Compliance score for the conformance pack. Conformance packs with no evaluation
	// results will have a compliance score of INSUFFICIENT_DATA .
	Score *string

	noSmithyDocumentSerde
}

// A list of filters to apply to the conformance pack compliance score result set.
type ConformancePackComplianceScoresFilters struct {

	// The names of the conformance packs whose compliance scores you want to include
	// in the conformance pack compliance score result set. You can include up to 25
	// conformance packs in the ConformancePackNames array of strings, each with a
	// character limit of 256 characters for the conformance pack name.
	//
	// This member is required.
	ConformancePackNames []string

	noSmithyDocumentSerde
}

// Summary includes the name and status of the conformance pack.
type ConformancePackComplianceSummary struct {

	// The status of the conformance pack.
	//
	// This member is required.
	ConformancePackComplianceStatus ConformancePackComplianceType

	// The name of the conformance pack name.
	//
	// This member is required.
	ConformancePackName *string

	noSmithyDocumentSerde
}

// Returns details of a conformance pack. A conformance pack is a collection of
// Config rules and remediation actions that can be easily deployed in an account
// and a region.
type ConformancePackDetail struct {

	// Amazon Resource Name (ARN) of the conformance pack.
	//
	// This member is required.
	ConformancePackArn *string

	// ID of the conformance pack.
	//
	// This member is required.
	ConformancePackId *string

	// Name of the conformance pack.
	//
	// This member is required.
	ConformancePackName *string

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []ConformancePackInputParameter

	// The Amazon Web Services service that created the conformance pack.
	CreatedBy *string

	// The name of the Amazon S3 bucket where Config stores conformance pack
	// templates. This field is optional.
	DeliveryS3Bucket *string

	// The prefix for the Amazon S3 bucket. This field is optional.
	DeliveryS3KeyPrefix *string

	// The last time a conformation pack update was requested.
	LastUpdateRequestedTime *time.Time

	// An object that contains the name or Amazon Resource Name (ARN) of the Amazon
	// Web Services Systems Manager document (SSM document) and the version of the SSM
	// document that is used to create a conformance pack.
	TemplateSSMDocumentDetails *TemplateSSMDocumentDetails

	noSmithyDocumentSerde
}

// Filters a conformance pack by Config rule names, compliance types, Amazon Web
// Services resource types, and resource IDs.
type ConformancePackEvaluationFilters struct {

	// Filters the results by compliance. The allowed values are COMPLIANT and
	// NON_COMPLIANT . INSUFFICIENT_DATA is not supported.
	ComplianceType ConformancePackComplianceType

	// Filters the results by Config rule names.
	ConfigRuleNames []string

	// Filters the results by resource IDs. This is valid only when you provide
	// resource type. If there is no resource type, you will see an error.
	ResourceIds []string

	// Filters the results by the resource type (for example, "AWS::EC2::Instance" ).
	ResourceType *string

	noSmithyDocumentSerde
}

// The details of a conformance pack evaluation. Provides Config rule and Amazon
// Web Services resource type that was evaluated, the compliance of the conformance
// pack, related time stamps, and supplementary information.
type ConformancePackEvaluationResult struct {

	// The compliance type. The allowed values are COMPLIANT and NON_COMPLIANT .
	// INSUFFICIENT_DATA is not supported.
	//
	// This member is required.
	ComplianceType ConformancePackComplianceType

	// The time when Config rule evaluated Amazon Web Services resource.
	//
	// This member is required.
	ConfigRuleInvokedTime *time.Time

	// Uniquely identifies an evaluation result.
	//
	// This member is required.
	EvaluationResultIdentifier *EvaluationResultIdentifier

	// The time when Config recorded the evaluation result.
	//
	// This member is required.
	ResultRecordedTime *time.Time

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string

	noSmithyDocumentSerde
}

// Input parameters in the form of key-value pairs for the conformance pack, both
// of which you define. Keys can have a maximum character length of 255 characters,
// and values can have a maximum length of 4096 characters.
type ConformancePackInputParameter struct {

	// One part of a key-value pair.
	//
	// This member is required.
	ParameterName *string

	// Another part of the key-value pair.
	//
	// This member is required.
	ParameterValue *string

	noSmithyDocumentSerde
}

// Compliance information of one or more Config rules within a conformance pack.
// You can filter using Config rule names and compliance types.
type ConformancePackRuleCompliance struct {

	// Compliance of the Config rule.
	ComplianceType ConformancePackComplianceType

	// Name of the Config rule.
	ConfigRuleName *string

	// Controls for the conformance pack. A control is a process to prevent or detect
	// problems while meeting objectives. A control can align with a specific
	// compliance regime or map to internal controls defined by an organization.
	Controls []string

	noSmithyDocumentSerde
}

// Status details of a conformance pack.
type ConformancePackStatusDetail struct {

	// Amazon Resource Name (ARN) of comformance pack.
	//
	// This member is required.
	ConformancePackArn *string

	// ID of the conformance pack.
	//
	// This member is required.
	ConformancePackId *string

	// Name of the conformance pack.
	//
	// This member is required.
	ConformancePackName *string

	// Indicates deployment status of conformance pack. Config sets the state of the
	// conformance pack to:
	//   - CREATE_IN_PROGRESS when a conformance pack creation is in progress for an
	//   account.
	//   - CREATE_COMPLETE when a conformance pack has been successfully created in
	//   your account.
	//   - CREATE_FAILED when a conformance pack creation failed in your account.
	//   - DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
	//   - DELETE_FAILED when a conformance pack deletion failed in your account.
	//
	// This member is required.
	ConformancePackState ConformancePackState

	// Last time when conformation pack creation and update was requested.
	//
	// This member is required.
	LastUpdateRequestedTime *time.Time

	// Amazon Resource Name (ARN) of CloudFormation stack.
	//
	// This member is required.
	StackArn *string

	// The reason of conformance pack creation failure.
	ConformancePackStatusReason *string

	// Last time when conformation pack creation and update was successful.
	LastUpdateCompletedTime *time.Time

	noSmithyDocumentSerde
}

// Provides the runtime system, policy definition, and whether debug logging
// enabled. You can specify the following CustomPolicyDetails parameter values only
// for Config Custom Policy rules.
type CustomPolicyDetails struct {

	// The runtime system for your Config Custom Policy rule. Guard is a
	// policy-as-code language that allows you to write policies that are enforced by
	// Config Custom Policy rules. For more information about Guard, see the Guard
	// GitHub Repository (https://github.com/aws-cloudformation/cloudformation-guard) .
	//
	// This member is required.
	PolicyRuntime *string

	// The policy definition containing the logic for your Config Custom Policy rule.
	//
	// This member is required.
	PolicyText *string

	// The boolean expression for enabling debug logging for your Config Custom Policy
	// rule. The default value is false .
	EnableDebugLogDelivery bool

	noSmithyDocumentSerde
}

// The channel through which Config delivers notifications and updated
// configuration states.
type DeliveryChannel struct {

	// The options for how often Config delivers configuration snapshots to the Amazon
	// S3 bucket.
	ConfigSnapshotDeliveryProperties *ConfigSnapshotDeliveryProperties

	// The name of the delivery channel. By default, Config assigns the name "default"
	// when creating the delivery channel. To change the delivery channel name, you
	// must use the DeleteDeliveryChannel action to delete your current delivery
	// channel, and then you must use the PutDeliveryChannel command to create a
	// delivery channel that has the desired name.
	Name *string

	// The name of the Amazon S3 bucket to which Config delivers configuration
	// snapshots and configuration history files. If you specify a bucket that belongs
	// to another Amazon Web Services account, that bucket must have policies that
	// grant access permissions to Config. For more information, see Permissions for
	// the Amazon S3 Bucket (https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html)
	// in the Config Developer Guide.
	S3BucketName *string

	// The prefix for the specified Amazon S3 bucket.
	S3KeyPrefix *string

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key
	// (KMS key) used to encrypt objects delivered by Config. Must belong to the same
	// Region as the destination S3 bucket.
	S3KmsKeyArn *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which Config sends
	// notifications about configuration changes. If you choose a topic from another
	// account, the topic must have policies that grant access permissions to Config.
	// For more information, see Permissions for the Amazon SNS Topic (https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html)
	// in the Config Developer Guide.
	SnsTopicARN *string

	noSmithyDocumentSerde
}

// The status of a specified delivery channel. Valid values: Success | Failure
type DeliveryChannelStatus struct {

	// A list that contains the status of the delivery of the configuration history to
	// the specified Amazon S3 bucket.
	ConfigHistoryDeliveryInfo *ConfigExportDeliveryInfo

	// A list containing the status of the delivery of the snapshot to the specified
	// Amazon S3 bucket.
	ConfigSnapshotDeliveryInfo *ConfigExportDeliveryInfo

	// A list containing the status of the delivery of the configuration stream
	// notification to the specified Amazon SNS topic.
	ConfigStreamDeliveryInfo *ConfigStreamDeliveryInfo

	// The name of the delivery channel.
	Name *string

	noSmithyDocumentSerde
}

// Returns a filtered list of Detective or Proactive Config rules. By default, if
// the filter is not defined, this API returns an unfiltered list. For more
// information on Detective or Proactive Config rules, see Evaluation Mode  (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config-rules.html)
// in the Config Developer Guide.
type DescribeConfigRulesFilters struct {

	// The mode of an evaluation. The valid values are Detective or Proactive.
	EvaluationMode EvaluationMode

	noSmithyDocumentSerde
}

// Identifies an Amazon Web Services resource and indicates whether it complies
// with the Config rule that it was evaluated against.
type Evaluation struct {

	// The ID of the Amazon Web Services resource that was evaluated.
	//
	// This member is required.
	ComplianceResourceId *string

	// The type of Amazon Web Services resource that was evaluated.
	//
	// This member is required.
	ComplianceResourceType *string

	// Indicates whether the Amazon Web Services resource complies with the Config
	// rule that it was evaluated against. For the Evaluation data type, Config
	// supports only the COMPLIANT , NON_COMPLIANT , and NOT_APPLICABLE values. Config
	// does not support the INSUFFICIENT_DATA value for this data type. Similarly,
	// Config does not accept INSUFFICIENT_DATA as the value for ComplianceType from a
	// PutEvaluations request. For example, an Lambda function for a custom Config rule
	// cannot pass an INSUFFICIENT_DATA value to Config.
	//
	// This member is required.
	ComplianceType ComplianceType

	// The time of the event in Config that triggered the evaluation. For event-based
	// evaluations, the time indicates when Config created the configuration item that
	// triggered the evaluation. For periodic evaluations, the time indicates when
	// Config triggered the evaluation at the frequency that you specified (for
	// example, every 24 hours).
	//
	// This member is required.
	OrderingTimestamp *time.Time

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string

	noSmithyDocumentSerde
}

// Use EvaluationContext to group independently initiated proactive resource
// evaluations. For example, CFN Stack. If you want to check just a resource
// definition, you do not need to provide evaluation context.
type EvaluationContext struct {

	// A unique EvaluationContextIdentifier ID for an EvaluationContext.
	EvaluationContextIdentifier *string

	noSmithyDocumentSerde
}

// The configuration object for Config rule evaluation mode. The supported valid
// values are Detective or Proactive.
type EvaluationModeConfiguration struct {

	// The mode of an evaluation. The valid values are Detective or Proactive.
	Mode EvaluationMode

	noSmithyDocumentSerde
}

// The details of an Config evaluation. Provides the Amazon Web Services resource
// that was evaluated, the compliance of the resource, related time stamps, and
// supplementary information.
type EvaluationResult struct {

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string

	// Indicates whether the Amazon Web Services resource complies with the Config
	// rule that evaluated it. For the EvaluationResult data type, Config supports
	// only the COMPLIANT , NON_COMPLIANT , and NOT_APPLICABLE values. Config does not
	// support the INSUFFICIENT_DATA value for the EvaluationResult data type.
	ComplianceType ComplianceType

	// The time when the Config rule evaluated the Amazon Web Services resource.
	ConfigRuleInvokedTime *time.Time

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier

	// The time when Config recorded the evaluation result.
	ResultRecordedTime *time.Time

	// An encrypted token that associates an evaluation with an Config rule. The token
	// identifies the rule, the Amazon Web Services resource being evaluated, and the
	// event that triggered the evaluation.
	ResultToken *string

	noSmithyDocumentSerde
}

// Uniquely identifies an evaluation result.
type EvaluationResultIdentifier struct {

	// Identifies an Config rule used to evaluate an Amazon Web Services resource, and
	// provides the type and ID of the evaluated resource.
	EvaluationResultQualifier *EvaluationResultQualifier

	// The time of the event that triggered the evaluation of your Amazon Web Services
	// resources. The time can indicate when Config delivered a configuration item
	// change notification, or it can indicate when Config delivered the configuration
	// snapshot, depending on which event triggered the evaluation.
	OrderingTimestamp *time.Time

	// A Unique ID for an evaluation result.
	ResourceEvaluationId *string

	noSmithyDocumentSerde
}

// Identifies an Config rule that evaluated an Amazon Web Services resource, and
// provides the type and ID of the resource that the rule evaluated.
type EvaluationResultQualifier struct {

	// The name of the Config rule that was used in the evaluation.
	ConfigRuleName *string

	// The mode of an evaluation. The valid values are Detective or Proactive.
	EvaluationMode EvaluationMode

	// The ID of the evaluated Amazon Web Services resource.
	ResourceId *string

	// The type of Amazon Web Services resource that was evaluated.
	ResourceType *string

	noSmithyDocumentSerde
}

// Returns status details of an evaluation.
type EvaluationStatus struct {

	// The status of an execution. The valid values are In_Progress, Succeeded or
	// Failed.
	//
	// This member is required.
	Status ResourceEvaluationStatus

	// An explanation for failed execution status.
	FailureReason *string

	noSmithyDocumentSerde
}

// Specifies whether the configuration recorder excludes certain resource types
// from being recorded. Use the resourceTypes field to enter a comma-separated
// list of resource types you want to exclude from recording. By default, when
// Config adds support for a new resource type in the Region where you set up the
// configuration recorder, including global resource types, Config starts recording
// resources of that type automatically. How to use the exclusion recording
// strategy To use this option, you must set the useOnly field of RecordingStrategy (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html)
// to EXCLUSION_BY_RESOURCE_TYPES . Config will then record configuration changes
// for all supported resource types, except the resource types that you specify to
// exclude from being recorded. Global resource types and the exclusion recording
// strategy Unless specifically listed as exclusions, AWS::RDS::GlobalCluster will
// be recorded automatically in all supported Config Regions were the configuration
// recorder is enabled. IAM users, groups, roles, and customer managed policies
// will be recorded in the Region where you set up the configuration recorder if
// that is a Region where Config was available before February 2022. You cannot be
// record the global IAM resouce types in Regions supported by Config after
// February 2022. This list where you cannot record the global IAM resource types
// includes the following Regions:
//   - Asia Pacific (Hyderabad)
//   - Asia Pacific (Melbourne)
//   - Europe (Spain)
//   - Europe (Zurich)
//   - Israel (Tel Aviv)
//   - Middle East (UAE)
type ExclusionByResourceTypes struct {

	// A comma-separated list of resource types to exclude from recording by the
	// configuration recorder.
	ResourceTypes []ResourceType

	noSmithyDocumentSerde
}

// The controls that Config uses for executing remediations.
type ExecutionControls struct {

	// A SsmControls object.
	SsmControls *SsmControls

	noSmithyDocumentSerde
}

// Identifies an Amazon Web Services resource and indicates whether it complies
// with the Config rule that it was evaluated against.
type ExternalEvaluation struct {

	// The evaluated compliance resource ID. Config accepts only Amazon Web Services
	// account ID.
	//
	// This member is required.
	ComplianceResourceId *string

	// The evaluated compliance resource type. Config accepts AWS::::Account resource
	// type.
	//
	// This member is required.
	ComplianceResourceType *string

	// The compliance of the Amazon Web Services resource. The valid values are
	// COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE .
	//
	// This member is required.
	ComplianceType ComplianceType

	// The time when the compliance was recorded.
	//
	// This member is required.
	OrderingTimestamp *time.Time

	// Supplementary information about the reason of compliance. For example, this
	// task was completed on a specific date.
	Annotation *string

	noSmithyDocumentSerde
}

// List of each of the failed delete remediation exceptions with specific reasons.
type FailedDeleteRemediationExceptionsBatch struct {

	// Returns remediation exception resource key object of the failed items.
	FailedItems []RemediationExceptionResourceKey

	// Returns a failure message for delete remediation exception. For example, Config
	// creates an exception due to an internal error.
	FailureMessage *string

	noSmithyDocumentSerde
}

// List of each of the failed remediations with specific reasons.
type FailedRemediationBatch struct {

	// Returns remediation configurations of the failed items.
	FailedItems []RemediationConfiguration

	// Returns a failure message. For example, the resource is already compliant.
	FailureMessage *string

	noSmithyDocumentSerde
}

// List of each of the failed remediation exceptions with specific reasons.
type FailedRemediationExceptionBatch struct {

	// Returns remediation exception resource key object of the failed items.
	FailedItems []RemediationException

	// Returns a failure message. For example, the auto-remediation has failed.
	FailureMessage *string

	noSmithyDocumentSerde
}

// Details about the fields such as name of the field.
type FieldInfo struct {

	// Name of the field.
	Name *string

	noSmithyDocumentSerde
}

// The count of resources that are grouped by the group name.
type GroupedResourceCount struct {

	// The name of the group that can be region, account ID, or resource type. For
	// example, region1, region2 if the region was chosen as GroupByKey .
	//
	// This member is required.
	GroupName *string

	// The number of resources in the group.
	//
	// This member is required.
	ResourceCount int64

	noSmithyDocumentSerde
}

// Organization Config rule creation or deletion status in each member account.
// This includes the name of the rule, the status, error code and error message
// when the rule creation or deletion failed.
type MemberAccountStatus struct {

	// The 12-digit account ID of a member account.
	//
	// This member is required.
	AccountId *string

	// The name of Config rule deployed in the member account.
	//
	// This member is required.
	ConfigRuleName *string

	// Indicates deployment status for Config rule in the member account. When
	// management account calls PutOrganizationConfigRule action for the first time,
	// Config rule status is created in the member account. When management account
	// calls PutOrganizationConfigRule action for the second time, Config rule status
	// is updated in the member account. Config rule status is deleted when the
	// management account deletes OrganizationConfigRule and disables service access
	// for config-multiaccountsetup.amazonaws.com . Config sets the state of the rule
	// to:
	//   - CREATE_SUCCESSFUL when Config rule has been created in the member account.
	//   - CREATE_IN_PROGRESS when Config rule is being created in the member account.
	//   - CREATE_FAILED when Config rule creation has failed in the member account.
	//   - DELETE_FAILED when Config rule deletion has failed in the member account.
	//   - DELETE_IN_PROGRESS when Config rule is being deleted in the member account.
	//   - DELETE_SUCCESSFUL when Config rule has been deleted in the member account.
	//   - UPDATE_SUCCESSFUL when Config rule has been updated in the member account.
	//   - UPDATE_IN_PROGRESS when Config rule is being updated in the member account.
	//   - UPDATE_FAILED when Config rule deletion has failed in the member account.
	//
	// This member is required.
	MemberAccountRuleStatus MemberAccountRuleStatus

	// An error code that is returned when Config rule creation or deletion failed in
	// the member account.
	ErrorCode *string

	// An error message indicating that Config rule account creation or deletion has
	// failed due to an error in the member account.
	ErrorMessage *string

	// The timestamp of the last status update.
	LastUpdateTime *time.Time

	noSmithyDocumentSerde
}

// This object contains regions to set up the aggregator and an IAM role to
// retrieve organization details.
type OrganizationAggregationSource struct {

	// ARN of the IAM role used to retrieve Amazon Web Services Organization details
	// associated with the aggregator account.
	//
	// This member is required.
	RoleArn *string

	// If true, aggregate existing Config regions and future regions.
	AllAwsRegions bool

	// The source regions being aggregated.
	AwsRegions []string

	noSmithyDocumentSerde
}

// An organization Config rule that has information about Config rules that Config
// creates in member accounts.
type OrganizationConfigRule struct {

	// Amazon Resource Name (ARN) of organization Config rule.
	//
	// This member is required.
	OrganizationConfigRuleArn *string

	// The name that you assign to organization Config rule.
	//
	// This member is required.
	OrganizationConfigRuleName *string

	// A comma-separated list of accounts excluded from organization Config rule.
	ExcludedAccounts []string

	// The timestamp of the last update.
	LastUpdateTime *time.Time

	// An object that specifies metadata for your organization's Config Custom Policy
	// rule. The metadata includes the runtime system in use, which accounts have debug
	// logging enabled, and other custom rule metadata, such as resource type, resource
	// ID of Amazon Web Services resource, and organization trigger types that initiate
	// Config to evaluate Amazon Web Services resources against a rule.
	OrganizationCustomPolicyRuleMetadata *OrganizationCustomPolicyRuleMetadataNoPolicy

	// An OrganizationCustomRuleMetadata object.
	OrganizationCustomRuleMetadata *OrganizationCustomRuleMetadata

	// An OrganizationManagedRuleMetadata object.
	OrganizationManagedRuleMetadata *OrganizationManagedRuleMetadata

	noSmithyDocumentSerde
}

// Returns the status for an organization Config rule in an organization.
type OrganizationConfigRuleStatus struct {

	// The name that you assign to organization Config rule.
	//
	// This member is required.
	OrganizationConfigRuleName *string

	// Indicates deployment status of an organization Config rule. When management
	// account calls PutOrganizationConfigRule action for the first time, Config rule
	// status is created in all the member accounts. When management account calls
	// PutOrganizationConfigRule action for the second time, Config rule status is
	// updated in all the member accounts. Additionally, Config rule status is updated
	// when one or more member accounts join or leave an organization. Config rule
	// status is deleted when the management account deletes OrganizationConfigRule in
	// all the member accounts and disables service access for
	// config-multiaccountsetup.amazonaws.com . Config sets the state of the rule to:
	//   - CREATE_SUCCESSFUL when an organization Config rule has been successfully
	//   created in all the member accounts.
	//   - CREATE_IN_PROGRESS when an organization Config rule creation is in progress.
	//   - CREATE_FAILED when an organization Config rule creation failed in one or
	//   more member accounts within that organization.
	//   - DELETE_FAILED when an organization Config rule deletion failed in one or
	//   more member accounts within that organization.
	//   - DELETE_IN_PROGRESS when an organization Config rule deletion is in progress.
	//   - DELETE_SUCCESSFUL when an organization Config rule has been successfully
	//   deleted from all the member accounts.
	//   - UPDATE_SUCCESSFUL when an organization Config rule has been successfully
	//   updated in all the member accounts.
	//   - UPDATE_IN_PROGRESS when an organization Config rule update is in progress.
	//   - UPDATE_FAILED when an organization Config rule update failed in one or more
	//   member accounts within that organization.
	//
	// This member is required.
	OrganizationRuleStatus OrganizationRuleStatus

	// An error code that is returned when organization Config rule creation or
	// deletion has failed.
	ErrorCode *string

	// An error message indicating that organization Config rule creation or deletion
	// failed due to an error.
	ErrorMessage *string

	// The timestamp of the last update.
	LastUpdateTime *time.Time

	noSmithyDocumentSerde
}

// An organization conformance pack that has information about conformance packs
// that Config creates in member accounts.
type OrganizationConformancePack struct {

	// Last time when organization conformation pack was updated.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// Amazon Resource Name (ARN) of organization conformance pack.
	//
	// This member is required.
	OrganizationConformancePackArn *string

	// The name you assign to an organization conformance pack.
	//
	// This member is required.
	OrganizationConformancePackName *string

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []ConformancePackInputParameter

	// The name of the Amazon S3 bucket where Config stores conformance pack
	// templates. This field is optional.
	DeliveryS3Bucket *string

	// Any folder structure you want to add to an Amazon S3 bucket. This field is
	// optional.
	DeliveryS3KeyPrefix *string

	// A comma-separated list of accounts excluded from organization conformance pack.
	ExcludedAccounts []string

	noSmithyDocumentSerde
}

// Organization conformance pack creation or deletion status in each member
// account. This includes the name of the conformance pack, the status, error code
// and error message when the conformance pack creation or deletion failed.
type OrganizationConformancePackDetailedStatus struct {

	// The 12-digit account ID of a member account.
	//
	// This member is required.
	AccountId *string

	// The name of conformance pack deployed in the member account.
	//
	// This member is required.
	ConformancePackName *string

	// Indicates deployment status for conformance pack in a member account. When
	// management account calls PutOrganizationConformancePack action for the first
	// time, conformance pack status is created in the member account. When management
	// account calls PutOrganizationConformancePack action for the second time,
	// conformance pack status is updated in the member account. Conformance pack
	// status is deleted when the management account deletes
	// OrganizationConformancePack and disables service access for
	// config-multiaccountsetup.amazonaws.com . Config sets the state of the
	// conformance pack to:
	//   - CREATE_SUCCESSFUL when conformance pack has been created in the member
	//   account.
	//   - CREATE_IN_PROGRESS when conformance pack is being created in the member
	//   account.
	//   - CREATE_FAILED when conformance pack creation has failed in the member
	//   account.
	//   - DELETE_FAILED when conformance pack deletion has failed in the member
	//   account.
	//   - DELETE_IN_PROGRESS when conformance pack is being deleted in the member
	//   account.
	//   - DELETE_SUCCESSFUL when conformance pack has been deleted in the member
	//   account.
	//   - UPDATE_SUCCESSFUL when conformance pack has been updated in the member
	//   account.
	//   - UPDATE_IN_PROGRESS when conformance pack is being updated in the member
	//   account.
	//   - UPDATE_FAILED when conformance pack deletion has failed in the member
	//   account.
	//
	// This member is required.
	Status OrganizationResourceDetailedStatus

	// An error code that is returned when conformance pack creation or deletion
	// failed in the member account.
	ErrorCode *string

	// An error message indicating that conformance pack account creation or deletion
	// has failed due to an error in the member account.
	ErrorMessage *string

	// The timestamp of the last status update.
	LastUpdateTime *time.Time

	noSmithyDocumentSerde
}

// Returns the status for an organization conformance pack in an organization.
type OrganizationConformancePackStatus struct {

	// The name that you assign to organization conformance pack.
	//
	// This member is required.
	OrganizationConformancePackName *string

	// Indicates deployment status of an organization conformance pack. When
	// management account calls PutOrganizationConformancePack for the first time,
	// conformance pack status is created in all the member accounts. When management
	// account calls PutOrganizationConformancePack for the second time, conformance
	// pack status is updated in all the member accounts. Additionally, conformance
	// pack status is updated when one or more member accounts join or leave an
	// organization. Conformance pack status is deleted when the management account
	// deletes OrganizationConformancePack in all the member accounts and disables
	// service access for config-multiaccountsetup.amazonaws.com . Config sets the
	// state of the conformance pack to:
	//   - CREATE_SUCCESSFUL when an organization conformance pack has been
	//   successfully created in all the member accounts.
	//   - CREATE_IN_PROGRESS when an organization conformance pack creation is in
	//   progress.
	//   - CREATE_FAILED when an organization conformance pack creation failed in one
	//   or more member accounts within that organization.
	//   - DELETE_FAILED when an organization conformance pack deletion failed in one
	//   or more member accounts within that organization.
	//   - DELETE_IN_PROGRESS when an organization conformance pack deletion is in
	//   progress.
	//   - DELETE_SUCCESSFUL when an organization conformance pack has been
	//   successfully deleted from all the member accounts.
	//   - UPDATE_SUCCESSFUL when an organization conformance pack has been
	//   successfully updated in all the member accounts.
	//   - UPDATE_IN_PROGRESS when an organization conformance pack update is in
	//   progress.
	//   - UPDATE_FAILED when an organization conformance pack update failed in one or
	//   more member accounts within that organization.
	//
	// This member is required.
	Status OrganizationResourceStatus

	// An error code that is returned when organization conformance pack creation or
	// deletion has failed in a member account.
	ErrorCode *string

	// An error message indicating that organization conformance pack creation or
	// deletion failed due to an error.
	ErrorMessage *string

	// The timestamp of the last update.
	LastUpdateTime *time.Time

	noSmithyDocumentSerde
}

// An object that specifies metadata for your organization's Config Custom Policy
// rule. The metadata includes the runtime system in use, which accounts have debug
// logging enabled, and other custom rule metadata, such as resource type, resource
// ID of Amazon Web Services resource, and organization trigger types that initiate
// Config to evaluate Amazon Web Services resources against a rule.
type OrganizationCustomPolicyRuleMetadata struct {

	// The runtime system for your organization Config Custom Policy rules. Guard is a
	// policy-as-code language that allows you to write policies that are enforced by
	// Config Custom Policy rules. For more information about Guard, see the Guard
	// GitHub Repository (https://github.com/aws-cloudformation/cloudformation-guard) .
	//
	// This member is required.
	PolicyRuntime *string

	// The policy definition containing the logic for your organization Config Custom
	// Policy rule.
	//
	// This member is required.
	PolicyText *string

	// A list of accounts that you can enable debug logging for your organization
	// Config Custom Policy rule. List is null when debug logging is enabled for all
	// accounts.
	DebugLogDeliveryAccounts []string

	// The description that you provide for your organization Config Custom Policy
	// rule.
	Description *string

	// A string, in JSON format, that is passed to your organization Config Custom
	// Policy rule.
	InputParameters *string

	// The maximum frequency with which Config runs evaluations for a rule. Your
	// Config Custom Policy rule is triggered when Config delivers the configuration
	// snapshot. For more information, see ConfigSnapshotDeliveryProperties .
	MaximumExecutionFrequency MaximumExecutionFrequency

	// The type of notification that initiates Config to run an evaluation for a rule.
	// For Config Custom Policy rules, Config supports change-initiated notification
	// types:
	//   - ConfigurationItemChangeNotification - Initiates an evaluation when Config
	//   delivers a configuration item as a result of a resource change.
	//   - OversizedConfigurationItemChangeNotification - Initiates an evaluation when
	//   Config delivers an oversized configuration item. Config may generate this
	//   notification type when a resource changes and the notification exceeds the
	//   maximum size allowed by Amazon SNS.
	OrganizationConfigRuleTriggerTypes []OrganizationConfigRuleTriggerTypeNoSN

	// The ID of the Amazon Web Services resource that was evaluated.
	ResourceIdScope *string

	// The type of the Amazon Web Services resource that was evaluated.
	ResourceTypesScope []string

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	TagKeyScope *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	TagValueScope *string

	noSmithyDocumentSerde
}

// metadata for your organization Config Custom Policy rule including the runtime
// system in use, which accounts have debug logging enabled, and other custom rule
// metadata such as resource type, resource ID of Amazon Web Services resource, and
// organization trigger types that trigger Config to evaluate Amazon Web Services
// resources against a rule.
type OrganizationCustomPolicyRuleMetadataNoPolicy struct {

	// A list of accounts that you can enable debug logging for your organization
	// Config Custom Policy rule. List is null when debug logging is enabled for all
	// accounts.
	DebugLogDeliveryAccounts []string

	// The description that you provide for your organization Config Custom Policy
	// rule.
	Description *string

	// A string, in JSON format, that is passed to your organization Config Custom
	// Policy rule.
	InputParameters *string

	// The maximum frequency with which Config runs evaluations for a rule. Your
	// Config Custom Policy rule is triggered when Config delivers the configuration
	// snapshot. For more information, see ConfigSnapshotDeliveryProperties .
	MaximumExecutionFrequency MaximumExecutionFrequency

	// The type of notification that triggers Config to run an evaluation for a rule.
	// For Config Custom Policy rules, Config supports change triggered notification
	// types:
	//   - ConfigurationItemChangeNotification - Triggers an evaluation when Config
	//   delivers a configuration item as a result of a resource change.
	//   - OversizedConfigurationItemChangeNotification - Triggers an evaluation when
	//   Config delivers an oversized configuration item. Config may generate this
	//   notification type when a resource changes and the notification exceeds the
	//   maximum size allowed by Amazon SNS.
	OrganizationConfigRuleTriggerTypes []OrganizationConfigRuleTriggerTypeNoSN

	// The runtime system for your organization Config Custom Policy rules. Guard is a
	// policy-as-code language that allows you to write policies that are enforced by
	// Config Custom Policy rules. For more information about Guard, see the Guard
	// GitHub Repository (https://github.com/aws-cloudformation/cloudformation-guard) .
	PolicyRuntime *string

	// The ID of the Amazon Web Services resource that was evaluated.
	ResourceIdScope *string

	// The type of the Amazon Web Services resource that was evaluated.
	ResourceTypesScope []string

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	TagKeyScope *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	TagValueScope *string

	noSmithyDocumentSerde
}

// An object that specifies organization custom rule metadata such as resource
// type, resource ID of Amazon Web Services resource, Lambda function ARN, and
// organization trigger types that trigger Config to evaluate your Amazon Web
// Services resources against a rule. It also provides the frequency with which you
// want Config to run evaluations for the rule if the trigger type is periodic.
type OrganizationCustomRuleMetadata struct {

	// The lambda function ARN.
	//
	// This member is required.
	LambdaFunctionArn *string

	// The type of notification that triggers Config to run an evaluation for a rule.
	// You can specify the following notification types:
	//   - ConfigurationItemChangeNotification - Triggers an evaluation when Config
	//   delivers a configuration item as a result of a resource change.
	//   - OversizedConfigurationItemChangeNotification - Triggers an evaluation when
	//   Config delivers an oversized configuration item. Config may generate this
	//   notification type when a resource changes and the notification exceeds the
	//   maximum size allowed by Amazon SNS.
	//   - ScheduledNotification - Triggers a periodic evaluation at the frequency
	//   specified for MaximumExecutionFrequency .
	//
	// This member is required.
	OrganizationConfigRuleTriggerTypes []OrganizationConfigRuleTriggerType

	// The description that you provide for your organization Config rule.
	Description *string

	// A string, in JSON format, that is passed to your organization Config rule
	// Lambda function.
	InputParameters *string

	// The maximum frequency with which Config runs evaluations for a rule. Your
	// custom rule is triggered when Config delivers the configuration snapshot. For
	// more information, see ConfigSnapshotDeliveryProperties . By default, rules with
	// a periodic trigger are evaluated every 24 hours. To change the frequency,
	// specify a valid value for the MaximumExecutionFrequency parameter.
	MaximumExecutionFrequency MaximumExecutionFrequency

	// The ID of the Amazon Web Services resource that was evaluated.
	ResourceIdScope *string

	// The type of the Amazon Web Services resource that was evaluated.
	ResourceTypesScope []string

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	TagKeyScope *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	TagValueScope *string

	noSmithyDocumentSerde
}

// An object that specifies organization managed rule metadata such as resource
// type and ID of Amazon Web Services resource along with the rule identifier. It
// also provides the frequency with which you want Config to run evaluations for
// the rule if the trigger type is periodic.
type OrganizationManagedRuleMetadata struct {

	// For organization config managed rules, a predefined identifier from a list. For
	// example, IAM_PASSWORD_POLICY is a managed rule. To reference a managed rule,
	// see Using Config managed rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html)
	// .
	//
	// This member is required.
	RuleIdentifier *string

	// The description that you provide for your organization Config rule.
	Description *string

	// A string, in JSON format, that is passed to your organization Config rule
	// Lambda function.
	InputParameters *string

	// The maximum frequency with which Config runs evaluations for a rule. This is
	// for an Config managed rule that is triggered at a periodic frequency. By
	// default, rules with a periodic trigger are evaluated every 24 hours. To change
	// the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	MaximumExecutionFrequency MaximumExecutionFrequency

	// The ID of the Amazon Web Services resource that was evaluated.
	ResourceIdScope *string

	// The type of the Amazon Web Services resource that was evaluated.
	ResourceTypesScope []string

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	TagKeyScope *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	TagValueScope *string

	noSmithyDocumentSerde
}

// Status filter object to filter results based on specific member account ID or
// status type for an organization conformance pack.
type OrganizationResourceDetailedStatusFilters struct {

	// The 12-digit account ID of the member account within an organization.
	AccountId *string

	// Indicates deployment status for conformance pack in a member account. When
	// management account calls PutOrganizationConformancePack action for the first
	// time, conformance pack status is created in the member account. When management
	// account calls PutOrganizationConformancePack action for the second time,
	// conformance pack status is updated in the member account. Conformance pack
	// status is deleted when the management account deletes
	// OrganizationConformancePack and disables service access for
	// config-multiaccountsetup.amazonaws.com . Config sets the state of the
	// conformance pack to:
	//   - CREATE_SUCCESSFUL when conformance pack has been created in the member
	//   account.
	//   - CREATE_IN_PROGRESS when conformance pack is being created in the member
	//   account.
	//   - CREATE_FAILED when conformance pack creation has failed in the member
	//   account.
	//   - DELETE_FAILED when conformance pack deletion has failed in the member
	//   account.
	//   - DELETE_IN_PROGRESS when conformance pack is being deleted in the member
	//   account.
	//   - DELETE_SUCCESSFUL when conformance pack has been deleted in the member
	//   account.
	//   - UPDATE_SUCCESSFUL when conformance pack has been updated in the member
	//   account.
	//   - UPDATE_IN_PROGRESS when conformance pack is being updated in the member
	//   account.
	//   - UPDATE_FAILED when conformance pack deletion has failed in the member
	//   account.
	Status OrganizationResourceDetailedStatus

	noSmithyDocumentSerde
}

// An object that represents the account ID and region of an aggregator account
// that is requesting authorization but is not yet authorized.
type PendingAggregationRequest struct {

	// The 12-digit account ID of the account requesting to aggregate data.
	RequesterAccountId *string

	// The region requesting to aggregate data.
	RequesterAwsRegion *string

	noSmithyDocumentSerde
}

// Details about the query.
type QueryInfo struct {

	// Returns a FieldInfo object.
	SelectFields []FieldInfo

	noSmithyDocumentSerde
}

// Specifies which resource types Config records for configuration changes. By
// default, Config records configuration changes for all current and future
// supported resource types in the Amazon Web Services Region where you have
// enabled Config, excluding the global IAM resource types: IAM users, groups,
// roles, and customer managed policies. In the recording group, you specify
// whether you want to record all supported current and future supported resource
// types or to include or exclude specific resources types. For a list of supported
// resource types, see Supported Resource Types (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources)
// in the Config developer guide. If you don't want Config to record all current
// and future supported resource types (excluding the global IAM resource types),
// use one of the following recording strategies:
//   - Record all current and future resource types with exclusions (
//     EXCLUSION_BY_RESOURCE_TYPES ), or
//   - Record specific resource types ( INCLUSION_BY_RESOURCE_TYPES ).
//
// If you use the recording strategy to Record all current and future resource
// types ( ALL_SUPPORTED_RESOURCE_TYPES ), you can use the flag
// includeGlobalResourceTypes to include the global IAM resource types in your
// recording. Aurora global clusters are recorded in all enabled Regions The
// AWS::RDS::GlobalCluster resource type will be recorded in all supported Config
// Regions where the configuration recorder is enabled. If you do not want to
// record AWS::RDS::GlobalCluster in all enabled Regions, use the
// EXCLUSION_BY_RESOURCE_TYPES or INCLUSION_BY_RESOURCE_TYPES recording strategy.
type RecordingGroup struct {

	// Specifies whether Config records configuration changes for all supported
	// resource types, excluding the global IAM resource types. If you set this field
	// to true , when Config adds support for a new resource type, Config starts
	// recording resources of that type automatically. If you set this field to true ,
	// you cannot enumerate specific resource types to record in the resourceTypes
	// field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	// , or to exclude in the resourceTypes field of ExclusionByResourceTypes (https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html)
	// . Region availability Check Resource Coverage by Region Availability (https://docs.aws.amazon.com/config/latest/developerguide/what-is-resource-config-coverage.html)
	// to see if a resource type is supported in the Amazon Web Services Region where
	// you set up Config.
	AllSupported bool

	// An object that specifies how Config excludes resource types from being recorded
	// by the configuration recorder. Required fields To use this option, you must set
	// the useOnly field of RecordingStrategy (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html)
	// to EXCLUSION_BY_RESOURCE_TYPES .
	ExclusionByResourceTypes *ExclusionByResourceTypes

	// This option is a bundle which only applies to the global IAM resource types:
	// IAM users, groups, roles, and customer managed policies. These global IAM
	// resource types can only be recorded by Config in Regions where Config was
	// available before February 2022. You cannot be record the global IAM resouce
	// types in Regions supported by Config after February 2022. This list where you
	// cannot record the global IAM resource types includes the following Regions:
	//   - Asia Pacific (Hyderabad)
	//   - Asia Pacific (Melbourne)
	//   - Europe (Spain)
	//   - Europe (Zurich)
	//   - Israel (Tel Aviv)
	//   - Middle East (UAE)
	// Aurora global clusters are recorded in all enabled Regions The
	// AWS::RDS::GlobalCluster resource type will be recorded in all supported Config
	// Regions where the configuration recorder is enabled, even if
	// includeGlobalResourceTypes is not set to true . The includeGlobalResourceTypes
	// option is a bundle which only applies to IAM users, groups, roles, and customer
	// managed policies. If you do not want to record AWS::RDS::GlobalCluster in all
	// enabled Regions, use one of the following recording strategies:
	//   - Record all current and future resource types with exclusions (
	//   EXCLUSION_BY_RESOURCE_TYPES ), or
	//   - Record specific resource types ( INCLUSION_BY_RESOURCE_TYPES ).
	// For more information, see Selecting Which Resources are Recorded (https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-all)
	// in the Config developer guide. Before you set this field to true , set the
	// allSupported field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	// to true . Optionally, you can set the useOnly field of RecordingStrategy (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html)
	// to ALL_SUPPORTED_RESOURCE_TYPES . Overriding fields If you set this field to
	// false but list global IAM resource types in the resourceTypes field of
	// RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	// , Config will still record configuration changes for those specified resource
	// types regardless of if you set the includeGlobalResourceTypes field to false.
	// If you do not want to record configuration changes to the global IAM resource
	// types (IAM users, groups, roles, and customer managed policies), make sure to
	// not list them in the resourceTypes field in addition to setting the
	// includeGlobalResourceTypes field to false.
	IncludeGlobalResourceTypes bool

	// An object that specifies the recording strategy for the configuration recorder.
	//   - If you set the useOnly field of RecordingStrategy (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html)
	//   to ALL_SUPPORTED_RESOURCE_TYPES , Config records configuration changes for all
	//   supported resource types, excluding the global IAM resource types. You also must
	//   set the allSupported field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	//   to true . When Config adds support for a new resource type, Config
	//   automatically starts recording resources of that type.
	//   - If you set the useOnly field of RecordingStrategy (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html)
	//   to INCLUSION_BY_RESOURCE_TYPES , Config records configuration changes for only
	//   the resource types you specify in the resourceTypes field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	//   .
	//   - If you set the useOnly field of RecordingStrategy (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html)
	//   to EXCLUSION_BY_RESOURCE_TYPES , Config records configuration changes for all
	//   supported resource types except the resource types that you specify to exclude
	//   from being recorded in the resourceTypes field of ExclusionByResourceTypes (https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html)
	//   .
	// Required and optional fields The recordingStrategy field is optional when you
	// set the allSupported field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	// to true . The recordingStrategy field is optional when you list resource types
	// in the resourceTypes field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	// . The recordingStrategy field is required if you list resource types to exclude
	// from recording in the resourceTypes field of ExclusionByResourceTypes (https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html)
	// . Overriding fields If you choose EXCLUSION_BY_RESOURCE_TYPES for the recording
	// strategy, the exclusionByResourceTypes field will override other properties in
	// the request. For example, even if you set includeGlobalResourceTypes to false,
	// global IAM resource types will still be automatically recorded in this option
	// unless those resource types are specifically listed as exclusions in the
	// resourceTypes field of exclusionByResourceTypes . Global resources types and the
	// resource exclusion recording strategy By default, if you choose the
	// EXCLUSION_BY_RESOURCE_TYPES recording strategy, when Config adds support for a
	// new resource type in the Region where you set up the configuration recorder,
	// including global resource types, Config starts recording resources of that type
	// automatically. Unless specifically listed as exclusions, AWS::RDS::GlobalCluster
	// will be recorded automatically in all supported Config Regions were the
	// configuration recorder is enabled. IAM users, groups, roles, and customer
	// managed policies will be recorded in the Region where you set up the
	// configuration recorder if that is a Region where Config was available before
	// February 2022. You cannot be record the global IAM resouce types in Regions
	// supported by Config after February 2022. This list where you cannot record the
	// global IAM resource types includes the following Regions:
	//   - Asia Pacific (Hyderabad)
	//   - Asia Pacific (Melbourne)
	//   - Europe (Spain)
	//   - Europe (Zurich)
	//   - Israel (Tel Aviv)
	//   - Middle East (UAE)
	RecordingStrategy *RecordingStrategy

	// A comma-separated list that specifies which resource types Config records. For
	// a list of valid resourceTypes values, see the Resource Type Value column in
	// Supported Amazon Web Services resource Types (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources)
	// in the Config developer guide. Required and optional fields Optionally, you can
	// set the useOnly field of RecordingStrategy (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html)
	// to INCLUSION_BY_RESOURCE_TYPES . To record all configuration changes, set the
	// allSupported field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	// to true , and either omit this field or don't specify any resource types in this
	// field. If you set the allSupported field to false and specify values for
	// resourceTypes , when Config adds support for a new type of resource, it will not
	// record resources of that type unless you manually add that type to your
	// recording group. Region availability Before specifying a resource type for
	// Config to track, check Resource Coverage by Region Availability (https://docs.aws.amazon.com/config/latest/developerguide/what-is-resource-config-coverage.html)
	// to see if the resource type is supported in the Amazon Web Services Region where
	// you set up Config. If a resource type is supported by Config in at least one
	// Region, you can enable the recording of that resource type in all Regions
	// supported by Config, even if the specified resource type is not supported in the
	// Amazon Web Services Region where you set up Config.
	ResourceTypes []ResourceType

	noSmithyDocumentSerde
}

// Specifies the default recording frequency that Config uses to record
// configuration changes. Config supports Continuous recording and Daily recording.
//
//   - Continuous recording allows you to record configuration changes
//     continuously whenever a change occurs.
//   - Daily recording allows you to receive a configuration item (CI)
//     representing the most recent state of your resources over the last 24-hour
//     period, only if it’s different from the previous CI recorded.
//
// Firewall Manager depends on continuous recording to monitor your resources. If
// you are using Firewall Manager, it is recommended that you set the recording
// frequency to Continuous. You can also override the recording frequency for
// specific resource types.
type RecordingMode struct {

	// The default recording frequency that Config uses to record configuration
	// changes. Daily recording is not supported for the following resource types:
	//   - AWS::Config::ResourceCompliance
	//   - AWS::Config::ConformancePackCompliance
	//   - AWS::Config::ConfigurationRecorder
	// For the allSupported ( ALL_SUPPORTED_RESOURCE_TYPES ) recording strategy, these
	// resource types will be set to Continuous recording.
	//
	// This member is required.
	RecordingFrequency RecordingFrequency

	// An array of recordingModeOverride objects for you to specify your overrides for
	// the recording mode. The recordingModeOverride object in the
	// recordingModeOverrides array consists of three fields: a description , the new
	// recordingFrequency , and an array of resourceTypes to override.
	RecordingModeOverrides []RecordingModeOverride

	noSmithyDocumentSerde
}

// An object for you to specify your overrides for the recording mode.
type RecordingModeOverride struct {

	// The recording frequency that will be applied to all the resource types
	// specified in the override.
	//   - Continuous recording allows you to record configuration changes
	//   continuously whenever a change occurs.
	//   - Daily recording allows you to receive a configuration item (CI)
	//   representing the most recent state of your resources over the last 24-hour
	//   period, only if it’s different from the previous CI recorded.
	// Firewall Manager depends on continuous recording to monitor your resources. If
	// you are using Firewall Manager, it is recommended that you set the recording
	// frequency to Continuous.
	//
	// This member is required.
	RecordingFrequency RecordingFrequency

	// A comma-separated list that specifies which resource types Config includes in
	// the override. Daily recording is not supported for the following resource types:
	//
	//   - AWS::Config::ResourceCompliance
	//   - AWS::Config::ConformancePackCompliance
	//   - AWS::Config::ConfigurationRecorder
	//
	// This member is required.
	ResourceTypes []ResourceType

	// A description that you provide for the override.
	Description *string

	noSmithyDocumentSerde
}

// Specifies the recording strategy of the configuration recorder.
type RecordingStrategy struct {

	// The recording strategy for the configuration recorder.
	//   - If you set this option to ALL_SUPPORTED_RESOURCE_TYPES , Config records
	//   configuration changes for all supported resource types, excluding the global IAM
	//   resource types. You also must set the allSupported field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	//   to true . When Config adds support for a new resource type, Config
	//   automatically starts recording resources of that type. For a list of supported
	//   resource types, see Supported Resource Types (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources)
	//   in the Config developer guide.
	//   - If you set this option to INCLUSION_BY_RESOURCE_TYPES , Config records
	//   configuration changes for only the resource types that you specify in the
	//   resourceTypes field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	//   .
	//   - If you set this option to EXCLUSION_BY_RESOURCE_TYPES , Config records
	//   configuration changes for all supported resource types, except the resource
	//   types that you specify to exclude from being recorded in the resourceTypes
	//   field of ExclusionByResourceTypes (https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html)
	//   .
	// Required and optional fields The recordingStrategy field is optional when you
	// set the allSupported field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	// to true . The recordingStrategy field is optional when you list resource types
	// in the resourceTypes field of RecordingGroup (https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html)
	// . The recordingStrategy field is required if you list resource types to exclude
	// from recording in the resourceTypes field of ExclusionByResourceTypes (https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html)
	// . Overriding fields If you choose EXCLUSION_BY_RESOURCE_TYPES for the recording
	// strategy, the exclusionByResourceTypes field will override other properties in
	// the request. For example, even if you set includeGlobalResourceTypes to false,
	// global IAM resource types will still be automatically recorded in this option
	// unless those resource types are specifically listed as exclusions in the
	// resourceTypes field of exclusionByResourceTypes . Global resource types and the
	// exclusion recording strategy By default, if you choose the
	// EXCLUSION_BY_RESOURCE_TYPES recording strategy, when Config adds support for a
	// new resource type in the Region where you set up the configuration recorder,
	// including global resource types, Config starts recording resources of that type
	// automatically. Unless specifically listed as exclusions, AWS::RDS::GlobalCluster
	// will be recorded automatically in all supported Config Regions were the
	// configuration recorder is enabled. IAM users, groups, roles, and customer
	// managed policies will be recorded in the Region where you set up the
	// configuration recorder if that is a Region where Config was available before
	// February 2022. You cannot be record the global IAM resouce types in Regions
	// supported by Config after February 2022. This list where you cannot record the
	// global IAM resource types includes the following Regions:
	//   - Asia Pacific (Hyderabad)
	//   - Asia Pacific (Melbourne)
	//   - Europe (Spain)
	//   - Europe (Zurich)
	//   - Israel (Tel Aviv)
	//   - Middle East (UAE)
	UseOnly RecordingStrategyType

	noSmithyDocumentSerde
}

// The relationship of the related resource to the main resource.
type Relationship struct {

	// The type of relationship with the related resource.
	RelationshipName *string

	// The ID of the related resource (for example, sg-xxxxxx ).
	ResourceId *string

	// The custom name of the related resource, if available.
	ResourceName *string

	// The resource type of the related resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// An object that represents the details about the remediation configuration that
// includes the remediation action, parameters, and data to execute the action.
type RemediationConfiguration struct {

	// The name of the Config rule.
	//
	// This member is required.
	ConfigRuleName *string

	// Target ID is the name of the SSM document.
	//
	// This member is required.
	TargetId *string

	// The type of the target. Target executes remediation. For example, SSM document.
	//
	// This member is required.
	TargetType RemediationTargetType

	// Amazon Resource Name (ARN) of remediation configuration.
	Arn *string

	// The remediation is triggered automatically.
	Automatic bool

	// Name of the service that owns the service-linked rule, if applicable.
	CreatedByService *string

	// An ExecutionControls object.
	ExecutionControls *ExecutionControls

	// The maximum number of failed attempts for auto-remediation. If you do not
	// select a number, the default is 5. For example, if you specify
	// MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config
	// will put a RemediationException on your behalf for the failing resource after
	// the 5th failed attempt within 50 seconds.
	MaximumAutomaticAttempts *int32

	// An object of the RemediationParameterValue.
	Parameters map[string]RemediationParameterValue

	// The type of a resource.
	ResourceType *string

	// Time window to determine whether or not to add a remediation exception to
	// prevent infinite remediation attempts. If MaximumAutomaticAttempts remediation
	// attempts have been made under RetryAttemptSeconds , a remediation exception will
	// be added to the resource. If you do not select a number, the default is 60
	// seconds. For example, if you specify RetryAttemptSeconds as 50 seconds and
	// MaximumAutomaticAttempts as 5, Config will run auto-remediations 5 times within
	// 50 seconds before adding a remediation exception to the resource.
	RetryAttemptSeconds *int64

	// Version of the target. For example, version of the SSM document. If you make
	// backward incompatible changes to the SSM document, you must call
	// PutRemediationConfiguration API again to ensure the remediations can run.
	TargetVersion *string

	noSmithyDocumentSerde
}

// An object that represents the details about the remediation exception. The
// details include the rule name, an explanation of an exception, the time when the
// exception will be deleted, the resource ID, and resource type.
type RemediationException struct {

	// The name of the Config rule.
	//
	// This member is required.
	ConfigRuleName *string

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// This member is required.
	ResourceId *string

	// The type of a resource.
	//
	// This member is required.
	ResourceType *string

	// The time when the remediation exception will be deleted.
	ExpirationTime *time.Time

	// An explanation of an remediation exception.
	Message *string

	noSmithyDocumentSerde
}

// The details that identify a resource within Config, including the resource type
// and resource ID.
type RemediationExceptionResourceKey struct {

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string

	// The type of a resource.
	ResourceType *string

	noSmithyDocumentSerde
}

// Provides details of the current status of the invoked remediation action for
// that resource.
type RemediationExecutionStatus struct {

	// Start time when the remediation was executed.
	InvocationTime *time.Time

	// The time when the remediation execution was last updated.
	LastUpdatedTime *time.Time

	// The details that identify a resource within Config, including the resource type
	// and resource ID.
	ResourceKey *ResourceKey

	// ENUM of the values.
	State RemediationExecutionState

	// Details of every step.
	StepDetails []RemediationExecutionStep

	noSmithyDocumentSerde
}

// Name of the step from the SSM document.
type RemediationExecutionStep struct {

	// An error message if the step was interrupted during execution.
	ErrorMessage *string

	// The details of the step.
	Name *string

	// The time when the step started.
	StartTime *time.Time

	// The valid status of the step.
	State RemediationExecutionStepState

	// The time when the step stopped.
	StopTime *time.Time

	noSmithyDocumentSerde
}

// The value is either a dynamic (resource) value or a static value. You must
// select either a dynamic value or a static value.
type RemediationParameterValue struct {

	// The value is dynamic and changes at run-time.
	ResourceValue *ResourceValue

	// The value is static and does not change at run-time.
	StaticValue *StaticValue

	noSmithyDocumentSerde
}

// An object that contains the resource type and the number of resources.
type ResourceCount struct {

	// The number of resources.
	Count int64

	// The resource type (for example, "AWS::EC2::Instance" ).
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Filters the resource count based on account ID, region, and resource type.
type ResourceCountFilters struct {

	// The 12-digit ID of the account.
	AccountId *string

	// The region where the account is located.
	Region *string

	// The type of the Amazon Web Services resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Returns information about the resource being evaluated.
type ResourceDetails struct {

	// The resource definition to be evaluated as per the resource configuration
	// schema type.
	//
	// This member is required.
	ResourceConfiguration *string

	// A unique resource ID for an evaluation.
	//
	// This member is required.
	ResourceId *string

	// The type of resource being evaluated.
	//
	// This member is required.
	ResourceType *string

	// The schema type of the resource configuration. You can find the Resource type
	// schema (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html)
	// , or CFN_RESOURCE_SCHEMA , in "Amazon Web Services public extensions" within the
	// CloudFormation registry or with the following CLI commmand: aws cloudformation
	// describe-type --type-name "AWS::S3::Bucket" --type RESOURCE . For more
	// information, see Managing extensions through the CloudFormation registry (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view)
	// and Amazon Web Services resource and property types reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.
	ResourceConfigurationSchemaType ResourceConfigurationSchemaType

	noSmithyDocumentSerde
}

// Returns details of a resource evaluation.
type ResourceEvaluation struct {

	// The mode of an evaluation. The valid values are Detective or Proactive.
	EvaluationMode EvaluationMode

	// The starting time of an execution.
	EvaluationStartTimestamp *time.Time

	// The ResourceEvaluationId of a evaluation.
	ResourceEvaluationId *string

	noSmithyDocumentSerde
}

// Returns details of a resource evaluation based on the selected filter.
type ResourceEvaluationFilters struct {

	// Filters evaluations for a given infrastructure deployment. For example: CFN
	// Stack.
	EvaluationContextIdentifier *string

	// Filters all resource evaluations results based on an evaluation mode. the valid
	// value for this API is Proactive .
	EvaluationMode EvaluationMode

	// Returns a TimeWindow object.
	TimeWindow *TimeWindow

	noSmithyDocumentSerde
}

// Filters the results by resource account ID, region, resource ID, and resource
// name.
type ResourceFilters struct {

	// The 12-digit source account ID.
	AccountId *string

	// The source region.
	Region *string

	// The ID of the resource.
	ResourceId *string

	// The name of the resource.
	ResourceName *string

	noSmithyDocumentSerde
}

// The details that identify a resource that is discovered by Config, including
// the resource type, ID, and (if available) the custom resource name.
type ResourceIdentifier struct {

	// The time that the resource was deleted.
	ResourceDeletionTime *time.Time

	// The ID of the resource (for example, sg-xxxxxx ).
	ResourceId *string

	// The custom name of the resource (if available).
	ResourceName *string

	// The type of resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// The details that identify a resource within Config, including the resource type
// and resource ID.
type ResourceKey struct {

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// This member is required.
	ResourceId *string

	// The resource type.
	//
	// This member is required.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// The dynamic value of the resource.
type ResourceValue struct {

	// The value is a resource ID.
	//
	// This member is required.
	Value ResourceValueType

	noSmithyDocumentSerde
}

// An object with the name of the retention configuration and the retention period
// in days. The object stores the configuration for data retention in Config.
type RetentionConfiguration struct {

	// The name of the retention configuration object.
	//
	// This member is required.
	Name *string

	// Number of days Config stores your historical information. Currently, only
	// applicable to the configuration item history.
	//
	// This member is required.
	RetentionPeriodInDays *int32

	noSmithyDocumentSerde
}

// Defines which resources trigger an evaluation for an Config rule. The scope can
// include one or more resource types, a combination of a tag key and value, or a
// combination of one resource type and one resource ID. Specify a scope to
// constrain which resources trigger an evaluation for a rule. Otherwise,
// evaluations for the rule are triggered when any resource in your recording group
// changes in configuration.
type Scope struct {

	// The ID of the only Amazon Web Services resource that you want to trigger an
	// evaluation for the rule. If you specify a resource ID, you must specify one
	// resource type for ComplianceResourceTypes .
	ComplianceResourceId *string

	// The resource types of only those Amazon Web Services resources that you want to
	// trigger an evaluation for the rule. You can only specify one type if you also
	// specify a resource ID for ComplianceResourceId .
	ComplianceResourceTypes []string

	// The tag key that is applied to only those Amazon Web Services resources that
	// you want to trigger an evaluation for the rule.
	TagKey *string

	// The tag value applied to only those Amazon Web Services resources that you want
	// to trigger an evaluation for the rule. If you specify a value for TagValue , you
	// must also specify a value for TagKey .
	TagValue *string

	noSmithyDocumentSerde
}

// Provides the CustomPolicyDetails, the rule owner ( Amazon Web Services for
// managed rules, CUSTOM_POLICY for Custom Policy rules, and CUSTOM_LAMBDA for
// Custom Lambda rules), the rule identifier, and the events that cause the
// evaluation of your Amazon Web Services resources.
type Source struct {

	// Indicates whether Amazon Web Services or the customer owns and manages the
	// Config rule. Config Managed Rules are predefined rules owned by Amazon Web
	// Services. For more information, see Config Managed Rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html)
	// in the Config developer guide. Config Custom Rules are rules that you can
	// develop either with Guard ( CUSTOM_POLICY ) or Lambda ( CUSTOM_LAMBDA ). For
	// more information, see Config Custom Rules  (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html)
	// in the Config developer guide.
	//
	// This member is required.
	Owner Owner

	// Provides the runtime system, policy definition, and whether debug logging is
	// enabled. Required when owner is set to CUSTOM_POLICY .
	CustomPolicyDetails *CustomPolicyDetails

	// Provides the source and the message types that cause Config to evaluate your
	// Amazon Web Services resources against a rule. It also provides the frequency
	// with which you want Config to run evaluations for the rule if the trigger type
	// is periodic. If the owner is set to CUSTOM_POLICY , the only acceptable values
	// for the Config rule trigger message type are ConfigurationItemChangeNotification
	// and OversizedConfigurationItemChangeNotification .
	SourceDetails []SourceDetail

	// For Config Managed rules, a predefined identifier from a list. For example,
	// IAM_PASSWORD_POLICY is a managed rule. To reference a managed rule, see List of
	// Config Managed Rules (https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html)
	// . For Config Custom Lambda rules, the identifier is the Amazon Resource Name
	// (ARN) of the rule's Lambda function, such as
	// arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name . For Config
	// Custom Policy rules, this field will be ignored.
	SourceIdentifier *string

	noSmithyDocumentSerde
}

// Provides the source and the message types that trigger Config to evaluate your
// Amazon Web Services resources against a rule. It also provides the frequency
// with which you want Config to run evaluations for the rule if the trigger type
// is periodic. You can specify the parameter values for SourceDetail only for
// custom rules.
type SourceDetail struct {

	// The source of the event, such as an Amazon Web Services service, that triggers
	// Config to evaluate your Amazon Web Services resources.
	EventSource EventSource

	// The frequency at which you want Config to run evaluations for a custom rule
	// with a periodic trigger. If you specify a value for MaximumExecutionFrequency ,
	// then MessageType must use the ScheduledNotification value. By default, rules
	// with a periodic trigger are evaluated every 24 hours. To change the frequency,
	// specify a valid value for the MaximumExecutionFrequency parameter. Based on the
	// valid value you choose, Config runs evaluations once for each valid value. For
	// example, if you choose Three_Hours , Config runs evaluations once every three
	// hours. In this case, Three_Hours is the frequency of this rule.
	MaximumExecutionFrequency MaximumExecutionFrequency

	// The type of notification that triggers Config to run an evaluation for a rule.
	// You can specify the following notification types:
	//   - ConfigurationItemChangeNotification - Triggers an evaluation when Config
	//   delivers a configuration item as a result of a resource change.
	//   - OversizedConfigurationItemChangeNotification - Triggers an evaluation when
	//   Config delivers an oversized configuration item. Config may generate this
	//   notification type when a resource changes and the notification exceeds the
	//   maximum size allowed by Amazon SNS.
	//   - ScheduledNotification - Triggers a periodic evaluation at the frequency
	//   specified for MaximumExecutionFrequency .
	//   - ConfigurationSnapshotDeliveryCompleted - Triggers a periodic evaluation when
	//   Config delivers a configuration snapshot.
	// If you want your custom rule to be triggered by configuration changes, specify
	// two SourceDetail objects, one for ConfigurationItemChangeNotification and one
	// for OversizedConfigurationItemChangeNotification .
	MessageType MessageType

	noSmithyDocumentSerde
}

// Amazon Web Services Systems Manager (SSM) specific remediation controls.
type SsmControls struct {

	// The maximum percentage of remediation actions allowed to run in parallel on the
	// non-compliant resources for that specific rule. You can specify a percentage,
	// such as 10%. The default value is 10.
	ConcurrentExecutionRatePercentage *int32

	// The percentage of errors that are allowed before SSM stops running automations
	// on non-compliant resources for that specific rule. You can specify a percentage
	// of errors, for example 10%. If you do not specifiy a percentage, the default is
	// 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant
	// resources, then SSM stops running the automations when the fifth error is
	// received.
	ErrorPercentage *int32

	noSmithyDocumentSerde
}

// The static value of the resource.
type StaticValue struct {

	// A list of values. For example, the ARN of the assumed role.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Status filter object to filter results based on specific member account ID or
// status type for an organization Config rule.
type StatusDetailFilters struct {

	// The 12-digit account ID of the member account within an organization.
	AccountId *string

	// Indicates deployment status for Config rule in the member account. When
	// management account calls PutOrganizationConfigRule action for the first time,
	// Config rule status is created in the member account. When management account
	// calls PutOrganizationConfigRule action for the second time, Config rule status
	// is updated in the member account. Config rule status is deleted when the
	// management account deletes OrganizationConfigRule and disables service access
	// for config-multiaccountsetup.amazonaws.com . Config sets the state of the rule
	// to:
	//   - CREATE_SUCCESSFUL when Config rule has been created in the member account.
	//   - CREATE_IN_PROGRESS when Config rule is being created in the member account.
	//   - CREATE_FAILED when Config rule creation has failed in the member account.
	//   - DELETE_FAILED when Config rule deletion has failed in the member account.
	//   - DELETE_IN_PROGRESS when Config rule is being deleted in the member account.
	//   - DELETE_SUCCESSFUL when Config rule has been deleted in the member account.
	//   - UPDATE_SUCCESSFUL when Config rule has been updated in the member account.
	//   - UPDATE_IN_PROGRESS when Config rule is being updated in the member account.
	//   - UPDATE_FAILED when Config rule deletion has failed in the member account.
	MemberAccountRuleStatus MemberAccountRuleStatus

	noSmithyDocumentSerde
}

// Provides the details of a stored query.
type StoredQuery struct {

	// The name of the query.
	//
	// This member is required.
	QueryName *string

	// A unique description for the query.
	Description *string

	// The expression of the query. For example, SELECT resourceId, resourceType,
	// supplementaryConfiguration.BucketVersioningConfiguration.status WHERE
	// resourceType = 'AWS::S3::Bucket' AND
	// supplementaryConfiguration.BucketVersioningConfiguration.status = 'Off'.
	Expression *string

	// Amazon Resource Name (ARN) of the query. For example,
	// arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
	QueryArn *string

	// The ID of the query.
	QueryId *string

	noSmithyDocumentSerde
}

// Returns details of a specific query.
type StoredQueryMetadata struct {

	// Amazon Resource Name (ARN) of the query. For example,
	// arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
	//
	// This member is required.
	QueryArn *string

	// The ID of the query.
	//
	// This member is required.
	QueryId *string

	// The name of the query.
	//
	// This member is required.
	QueryName *string

	// A unique description for the query.
	Description *string

	noSmithyDocumentSerde
}

// The tags for the resource. The metadata that you apply to a resource to help
// you categorize and organize them. Each tag consists of a key and an optional
// value, both of which you define. Tag keys can have a maximum character length of
// 128 characters, and tag values can have a maximum length of 256 characters.
type Tag struct {

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	Key *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	Value *string

	noSmithyDocumentSerde
}

// This API allows you to create a conformance pack template with an Amazon Web
// Services Systems Manager document (SSM document). To deploy a conformance pack
// using an SSM document, first create an SSM document with conformance pack
// content, and then provide the DocumentName in the PutConformancePack API (https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html)
// . You can also provide the DocumentVersion . The TemplateSSMDocumentDetails
// object contains the name of the SSM document and the version of the SSM
// document.
type TemplateSSMDocumentDetails struct {

	// The name or Amazon Resource Name (ARN) of the SSM document to use to create a
	// conformance pack. If you use the document name, Config checks only your account
	// and Amazon Web Services Region for the SSM document. If you want to use an SSM
	// document from another Region or account, you must provide the ARN.
	//
	// This member is required.
	DocumentName *string

	// The version of the SSM document to use to create a conformance pack. By
	// default, Config uses the latest version. This field is optional.
	DocumentVersion *string

	noSmithyDocumentSerde
}

// Filters evaluation results based on start and end times.
type TimeWindow struct {

	// The end time of an execution. The end time must be after the start date.
	EndTime *time.Time

	// The start time of an execution.
	StartTime *time.Time

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
