/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2011 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMTRACKITEM_H
#define GMTRACKITEM_H

class GMTrackItem;

class GMDBTrackItem : public GMTrackItem {
public:
  static FXint max_time;
  static FXint max_queue;
  static FXint max_trackno;
  static FXint max_digits(FXint no);
protected:
  FXString title;         /* 4 - 8 */
  FXString artist;        /* 4 - 8 */
  FXString album_artist;  /* 4 - 8 */
  FXString album;         /* 4 - 8 */
  FXString genre;         /* 4 - 8 */
  FXint    time;          /* 4 - 4 */
  FXuint   no;            /* 4 - 4 */
  FXint    queue;         /* 4 - 4 */
  FXushort year;          /* 2 - 2 */
  FXushort album_year;    /* 2 - 2 */
  //FXuchar  filetype;      /* 1 - 1 */
public:
  static FXint browseSort(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingTitle(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingTitle(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingTrack(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingTrack(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingDisc(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingDisc(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingQueue(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingQueue(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingTime(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingTime(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingAlbum(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingAlbum(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingArtist(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingArtist(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingAlbumArtist(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingAlbumArtist(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingGenre(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingGenre(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingYear(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingYear(const GMTrackItem*,const GMTrackItem*);
protected:
  GMDBTrackItem(){}
protected:
  virtual const FXString * getColumnData(FXint i,FXString & t,FXuint &justify,FXint & max) const;
public:
  GMDBTrackItem(FXint id,const FXchar * title,const FXchar * artist,const FXchar * album_artist,const FXchar * album,const FXchar * genre,FXint time,FXuint no,FXint queue,FXushort year,FXushort ayear);

  void setTrackQueue(FXint q) { queue=q; }

  FXint getTrackQueue() const { return queue; }

  /// Return Track Number
  FXint getTrackNumber() const { return no; }

  /// Return Track Title
  FXString getTrackTitle() const { return title; }

  virtual ~GMDBTrackItem();
  };

class GMStreamTrackItem : public GMTrackItem {
public:
  static FXint max_trackno;
  static FXint max_digits(FXint no);
protected:
  FXString title;
  FXString artist;
  FXString genre;
  FXint    bitrate;
  FXint 	 no;
public:
  static FXint ascendingTitle(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingTitle(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingTrack(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingTrack(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingGenre(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingGenre(const GMTrackItem*,const GMTrackItem*);
  static FXint ascendingTime(const GMTrackItem*,const GMTrackItem*);
  static FXint descendingTime(const GMTrackItem*,const GMTrackItem*);
protected:
  GMStreamTrackItem(){}
protected:
  virtual const FXString * getColumnData(FXint i,FXString & t,FXuint &justify,FXint & max) const;
public:
  GMStreamTrackItem(FXint id,const FXchar * title,const FXchar * genre,FXint no,FXint bitrate);

  /// Return Track Number
  FXint getTrackNumber() const { return no; }

  /// Return Track Title
  FXString getTrackTitle() const { return title; }

  virtual ~GMStreamTrackItem() {}
  };
#endif
