# frozen_string_literal: true

class RemoveRedundantIndexOnVulnerabilityReads < Gitlab::Database::Migration[2.2]
  TABLE_NAME = :vulnerability_reads

  GROUP_LEVEL_INDEX = 'index_vulnerability_reads_common_attrs_and_detection_for_groups'
  GROUP_LEVEL_COLUMNS = [:resolved_on_default_branch, :state, :report_type, :severity, :traversal_ids,
    :vulnerability_id]

  PROJECT_LEVEL_INDEX = 'index_vulnerability_reads_common_finder_query_2'
  PROJECT_LEVEL_COLUMNS = [:project_id, :state, :report_type, :severity, :vulnerability_id, :dismissal_reason]

  disable_ddl_transaction!
  milestone '17.5'

  def up
    remove_concurrent_index_by_name TABLE_NAME, name: GROUP_LEVEL_INDEX
    remove_concurrent_index_by_name TABLE_NAME, name: PROJECT_LEVEL_INDEX
  end

  def down
    add_concurrent_index TABLE_NAME, GROUP_LEVEL_COLUMNS, name: GROUP_LEVEL_INDEX, where: 'archived = false'
    add_concurrent_index TABLE_NAME, PROJECT_LEVEL_COLUMNS, name: PROJECT_LEVEL_INDEX,
      order: { vulnerability_id: :desc }
  end
end
