// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/shopping/css/v1/css_products.proto

package csspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request message for the `GetCssProduct` method.
type GetCssProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CSS product to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCssProductRequest) Reset() {
	*x = GetCssProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_products_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCssProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCssProductRequest) ProtoMessage() {}

func (x *GetCssProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_products_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCssProductRequest.ProtoReflect.Descriptor instead.
func (*GetCssProductRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_products_proto_rawDescGZIP(), []int{0}
}

func (x *GetCssProductRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The processed CSS Product(a.k.a Aggregate Offer internally).
type CssProduct struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the CSS Product.
	// Format:
	// `"accounts/{account}/cssProducts/{css_product}"`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Your unique raw identifier for the product.
	RawProvidedId string `protobuf:"bytes,2,opt,name=raw_provided_id,json=rawProvidedId,proto3" json:"raw_provided_id,omitempty"`
	// Output only. The two-letter [ISO
	// 639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
	// product.
	ContentLanguage string `protobuf:"bytes,3,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
	// Output only. The feed label for the product.
	FeedLabel string `protobuf:"bytes,4,opt,name=feed_label,json=feedLabel,proto3" json:"feed_label,omitempty"`
	// Output only. A list of product attributes.
	Attributes *Attributes `protobuf:"bytes,5,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Output only. A list of custom (CSS-provided) attributes. It can also be
	// used to submit any attribute of the feed specification in its generic form
	// (for example,
	// `{ "name": "size type", "value": "regular" }`).
	// This is useful for submitting attributes not explicitly exposed by the
	// API, such as additional attributes used for Buy on Google.
	CustomAttributes []*typepb.CustomAttribute `protobuf:"bytes,6,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty"`
	// Output only. The status of a product, data validation issues, that is,
	// information about a product computed asynchronously.
	CssProductStatus *CssProductStatus `protobuf:"bytes,8,opt,name=css_product_status,json=cssProductStatus,proto3" json:"css_product_status,omitempty"`
}

func (x *CssProduct) Reset() {
	*x = CssProduct{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_products_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CssProduct) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CssProduct) ProtoMessage() {}

func (x *CssProduct) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_products_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CssProduct.ProtoReflect.Descriptor instead.
func (*CssProduct) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_products_proto_rawDescGZIP(), []int{1}
}

func (x *CssProduct) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CssProduct) GetRawProvidedId() string {
	if x != nil {
		return x.RawProvidedId
	}
	return ""
}

func (x *CssProduct) GetContentLanguage() string {
	if x != nil {
		return x.ContentLanguage
	}
	return ""
}

func (x *CssProduct) GetFeedLabel() string {
	if x != nil {
		return x.FeedLabel
	}
	return ""
}

func (x *CssProduct) GetAttributes() *Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *CssProduct) GetCustomAttributes() []*typepb.CustomAttribute {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

func (x *CssProduct) GetCssProductStatus() *CssProductStatus {
	if x != nil {
		return x.CssProductStatus
	}
	return nil
}

// Request message for the ListCssProducts method.
type ListCssProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account/domain to list processed CSS Products for.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of CSS Products to return. The service may return
	// fewer than this value.
	// The maximum value is 1000; values above 1000 will be coerced to 1000. If
	// unspecified, the maximum number of CSS products will be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCssProducts` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCssProducts`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCssProductsRequest) Reset() {
	*x = ListCssProductsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_products_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCssProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCssProductsRequest) ProtoMessage() {}

func (x *ListCssProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_products_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCssProductsRequest.ProtoReflect.Descriptor instead.
func (*ListCssProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_products_proto_rawDescGZIP(), []int{2}
}

func (x *ListCssProductsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCssProductsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCssProductsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the ListCssProducts method.
type ListCssProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The processed CSS products from the specified account. These are your
	// processed CSS products after applying rules and supplemental feeds.
	CssProducts []*CssProduct `protobuf:"bytes,1,rep,name=css_products,json=cssProducts,proto3" json:"css_products,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCssProductsResponse) Reset() {
	*x = ListCssProductsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_css_v1_css_products_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCssProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCssProductsResponse) ProtoMessage() {}

func (x *ListCssProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_css_products_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCssProductsResponse.ProtoReflect.Descriptor instead.
func (*ListCssProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_css_products_proto_rawDescGZIP(), []int{3}
}

func (x *ListCssProductsResponse) GetCssProducts() []*CssProduct {
	if x != nil {
		return x.CssProducts
	}
	return nil
}

func (x *ListCssProductsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_shopping_css_v1_css_products_proto protoreflect.FileDescriptor

var file_google_shopping_css_v1_css_products_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x51, 0x0a, 0x14, 0x47, 0x65, 0x74,
	0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x73, 0x73, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8b, 0x04, 0x0a,
	0x0a, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2b, 0x0a, 0x0f, 0x72, 0x61, 0x77, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72,
	0x61, 0x77, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x10,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x66, 0x65, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x12, 0x47, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x11, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x5b, 0x0a, 0x12, 0x63, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63,
	0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x3a,
	0x69, 0xea, 0x41, 0x66, 0x0a, 0x1d, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x12, 0x2c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x63, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x7d, 0x2a, 0x0b, 0x63, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x32, 0x0a,
	0x63, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x93, 0x01, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x63,
	0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x88, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0c,
	0x63, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x73, 0x73, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x0b, 0x63, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x98, 0x03, 0x0a, 0x12,
	0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x95, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x73, 0x73, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x32, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x73, 0x73, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa8, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x73, 0x73, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x73, 0x73, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x34, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25,
	0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x73, 0x73, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x1a, 0x3f, 0xca, 0x41, 0x12, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xb2, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63,
	0x73, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x43, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x63, 0x73, 0x73, 0x70, 0x62, 0x3b, 0x63, 0x73, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x16,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x43, 0x73, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5c, 0x43, 0x73, 0x73, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x3a, 0x3a, 0x43, 0x73, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_css_v1_css_products_proto_rawDescOnce sync.Once
	file_google_shopping_css_v1_css_products_proto_rawDescData = file_google_shopping_css_v1_css_products_proto_rawDesc
)

func file_google_shopping_css_v1_css_products_proto_rawDescGZIP() []byte {
	file_google_shopping_css_v1_css_products_proto_rawDescOnce.Do(func() {
		file_google_shopping_css_v1_css_products_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_css_v1_css_products_proto_rawDescData)
	})
	return file_google_shopping_css_v1_css_products_proto_rawDescData
}

var file_google_shopping_css_v1_css_products_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_shopping_css_v1_css_products_proto_goTypes = []interface{}{
	(*GetCssProductRequest)(nil),    // 0: google.shopping.css.v1.GetCssProductRequest
	(*CssProduct)(nil),              // 1: google.shopping.css.v1.CssProduct
	(*ListCssProductsRequest)(nil),  // 2: google.shopping.css.v1.ListCssProductsRequest
	(*ListCssProductsResponse)(nil), // 3: google.shopping.css.v1.ListCssProductsResponse
	(*Attributes)(nil),              // 4: google.shopping.css.v1.Attributes
	(*typepb.CustomAttribute)(nil),  // 5: google.shopping.type.CustomAttribute
	(*CssProductStatus)(nil),        // 6: google.shopping.css.v1.CssProductStatus
}
var file_google_shopping_css_v1_css_products_proto_depIdxs = []int32{
	4, // 0: google.shopping.css.v1.CssProduct.attributes:type_name -> google.shopping.css.v1.Attributes
	5, // 1: google.shopping.css.v1.CssProduct.custom_attributes:type_name -> google.shopping.type.CustomAttribute
	6, // 2: google.shopping.css.v1.CssProduct.css_product_status:type_name -> google.shopping.css.v1.CssProductStatus
	1, // 3: google.shopping.css.v1.ListCssProductsResponse.css_products:type_name -> google.shopping.css.v1.CssProduct
	0, // 4: google.shopping.css.v1.CssProductsService.GetCssProduct:input_type -> google.shopping.css.v1.GetCssProductRequest
	2, // 5: google.shopping.css.v1.CssProductsService.ListCssProducts:input_type -> google.shopping.css.v1.ListCssProductsRequest
	1, // 6: google.shopping.css.v1.CssProductsService.GetCssProduct:output_type -> google.shopping.css.v1.CssProduct
	3, // 7: google.shopping.css.v1.CssProductsService.ListCssProducts:output_type -> google.shopping.css.v1.ListCssProductsResponse
	6, // [6:8] is the sub-list for method output_type
	4, // [4:6] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_shopping_css_v1_css_products_proto_init() }
func file_google_shopping_css_v1_css_products_proto_init() {
	if File_google_shopping_css_v1_css_products_proto != nil {
		return
	}
	file_google_shopping_css_v1_css_product_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_css_v1_css_products_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCssProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_products_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CssProduct); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_products_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCssProductsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_css_v1_css_products_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCssProductsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_css_v1_css_products_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_css_v1_css_products_proto_goTypes,
		DependencyIndexes: file_google_shopping_css_v1_css_products_proto_depIdxs,
		MessageInfos:      file_google_shopping_css_v1_css_products_proto_msgTypes,
	}.Build()
	File_google_shopping_css_v1_css_products_proto = out.File
	file_google_shopping_css_v1_css_products_proto_rawDesc = nil
	file_google_shopping_css_v1_css_products_proto_goTypes = nil
	file_google_shopping_css_v1_css_products_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CssProductsServiceClient is the client API for CssProductsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CssProductsServiceClient interface {
	// Retrieves the processed CSS Product from your CSS Center account. After
	// inserting, updating, or deleting a product input, it may take several
	// minutes before the updated final product can be retrieved.
	GetCssProduct(ctx context.Context, in *GetCssProductRequest, opts ...grpc.CallOption) (*CssProduct, error)
	// Lists the processed CSS Products in your CSS Center account. The response
	// might contain fewer items than specified by pageSize. Rely on pageToken to
	// determine if there are more items to be requested.
	//
	// After inserting, updating, or deleting a CSS product input, it may
	// take several minutes before the updated processed CSS product can be
	// retrieved.
	ListCssProducts(ctx context.Context, in *ListCssProductsRequest, opts ...grpc.CallOption) (*ListCssProductsResponse, error)
}

type cssProductsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCssProductsServiceClient(cc grpc.ClientConnInterface) CssProductsServiceClient {
	return &cssProductsServiceClient{cc}
}

func (c *cssProductsServiceClient) GetCssProduct(ctx context.Context, in *GetCssProductRequest, opts ...grpc.CallOption) (*CssProduct, error) {
	out := new(CssProduct)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.CssProductsService/GetCssProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cssProductsServiceClient) ListCssProducts(ctx context.Context, in *ListCssProductsRequest, opts ...grpc.CallOption) (*ListCssProductsResponse, error) {
	out := new(ListCssProductsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.CssProductsService/ListCssProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CssProductsServiceServer is the server API for CssProductsService service.
type CssProductsServiceServer interface {
	// Retrieves the processed CSS Product from your CSS Center account. After
	// inserting, updating, or deleting a product input, it may take several
	// minutes before the updated final product can be retrieved.
	GetCssProduct(context.Context, *GetCssProductRequest) (*CssProduct, error)
	// Lists the processed CSS Products in your CSS Center account. The response
	// might contain fewer items than specified by pageSize. Rely on pageToken to
	// determine if there are more items to be requested.
	//
	// After inserting, updating, or deleting a CSS product input, it may
	// take several minutes before the updated processed CSS product can be
	// retrieved.
	ListCssProducts(context.Context, *ListCssProductsRequest) (*ListCssProductsResponse, error)
}

// UnimplementedCssProductsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCssProductsServiceServer struct {
}

func (*UnimplementedCssProductsServiceServer) GetCssProduct(context.Context, *GetCssProductRequest) (*CssProduct, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCssProduct not implemented")
}
func (*UnimplementedCssProductsServiceServer) ListCssProducts(context.Context, *ListCssProductsRequest) (*ListCssProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCssProducts not implemented")
}

func RegisterCssProductsServiceServer(s *grpc.Server, srv CssProductsServiceServer) {
	s.RegisterService(&_CssProductsService_serviceDesc, srv)
}

func _CssProductsService_GetCssProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCssProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CssProductsServiceServer).GetCssProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.CssProductsService/GetCssProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CssProductsServiceServer).GetCssProduct(ctx, req.(*GetCssProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CssProductsService_ListCssProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCssProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CssProductsServiceServer).ListCssProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.CssProductsService/ListCssProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CssProductsServiceServer).ListCssProducts(ctx, req.(*ListCssProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CssProductsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.css.v1.CssProductsService",
	HandlerType: (*CssProductsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCssProduct",
			Handler:    _CssProductsService_GetCssProduct_Handler,
		},
		{
			MethodName: "ListCssProducts",
			Handler:    _CssProductsService_ListCssProducts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/css/v1/css_products.proto",
}
