// Code generated by smithy-go-codegen DO NOT EDIT.

package neptunedata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/neptunedata/document"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Executes an openCypher query. See [Accessing the Neptune Graph with openCypher] for more information.
//
// Neptune supports building graph applications using openCypher, which is
// currently one of the most popular query languages among developers working with
// graph databases. Developers, business analysts, and data scientists like
// openCypher's declarative, SQL-inspired syntax because it provides a familiar
// structure in which to querying property graphs.
//
// The openCypher language was originally developed by Neo4j, then open-sourced in
// 2015 and contributed to the [openCypher project]under an Apache 2 open-source license.
//
// Note that when invoking this operation in a Neptune cluster that has IAM
// authentication enabled, the IAM user or role making the request must have a
// policy attached that allows one of the following IAM actions in that cluster,
// depending on the query:
//
// [neptune-db:ReadDataViaQuery]
//
// [neptune-db:WriteDataViaQuery]
//
// [neptune-db:DeleteDataViaQuery]
//
// Note also that the [neptune-db:QueryLanguage:OpenCypher] IAM condition key can be used in the policy document to
// restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements]).
//
// [neptune-db:DeleteDataViaQuery]: https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery
// [Accessing the Neptune Graph with openCypher]: https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html
// [Condition keys available in Neptune IAM data-access policy statements]: https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html
// [openCypher project]: https://opencypher.org/
// [neptune-db:ReadDataViaQuery]: https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery
// [neptune-db:WriteDataViaQuery]: https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery
// [neptune-db:QueryLanguage:OpenCypher]: https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys
func (c *Client) ExecuteOpenCypherQuery(ctx context.Context, params *ExecuteOpenCypherQueryInput, optFns ...func(*Options)) (*ExecuteOpenCypherQueryOutput, error) {
	if params == nil {
		params = &ExecuteOpenCypherQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ExecuteOpenCypherQuery", params, optFns, c.addOperationExecuteOpenCypherQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ExecuteOpenCypherQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ExecuteOpenCypherQueryInput struct {

	// The openCypher query string to be executed.
	//
	// This member is required.
	OpenCypherQuery *string

	// The openCypher query parameters for query execution. See [Examples of openCypher parameterized queries] for more information.
	//
	// [Examples of openCypher parameterized queries]: https://docs.aws.amazon.com/neptune/latest/userguide/opencypher-parameterized-queries.html
	Parameters *string

	noSmithyDocumentSerde
}

type ExecuteOpenCypherQueryOutput struct {

	// The openCypherquery results.
	//
	// This member is required.
	Results document.Interface

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationExecuteOpenCypherQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpExecuteOpenCypherQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpExecuteOpenCypherQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ExecuteOpenCypherQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpExecuteOpenCypherQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opExecuteOpenCypherQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opExecuteOpenCypherQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ExecuteOpenCypherQuery",
	}
}
