// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"github.com/jmespath/go-jmespath"
	"time"
)

// Retrieves the specified signal map.
func (c *Client) GetSignalMap(ctx context.Context, params *GetSignalMapInput, optFns ...func(*Options)) (*GetSignalMapOutput, error) {
	if params == nil {
		params = &GetSignalMapInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSignalMap", params, optFns, c.addOperationGetSignalMapMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSignalMapOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Placeholder documentation for GetSignalMapRequest
type GetSignalMapInput struct {

	// A signal map's identifier. Can be either be its id or current name.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

// Placeholder documentation for GetSignalMapResponse
type GetSignalMapOutput struct {

	// A signal map's ARN (Amazon Resource Name)
	Arn *string

	// Placeholder documentation for __listOf__stringMin7Max11PatternAws097
	CloudWatchAlarmTemplateGroupIds []string

	// Placeholder documentation for __timestampIso8601
	CreatedAt *time.Time

	// A resource's optional description.
	Description *string

	// A top-level supported AWS resource ARN to discovery a signal map from.
	DiscoveryEntryPointArn *string

	// Error message associated with a failed creation or failed update attempt of a
	// signal map.
	ErrorMessage *string

	// Placeholder documentation for __listOf__stringMin7Max11PatternAws097
	EventBridgeRuleTemplateGroupIds []string

	// A map representing an incomplete AWS media workflow as a graph.
	FailedMediaResourceMap map[string]types.MediaResource

	// A signal map's id.
	Id *string

	// Placeholder documentation for __timestampIso8601
	LastDiscoveredAt *time.Time

	// Represents the latest successful monitor deployment of a signal map.
	LastSuccessfulMonitorDeployment *types.SuccessfulMonitorDeployment

	// A map representing an AWS media workflow as a graph.
	MediaResourceMap map[string]types.MediaResource

	// Placeholder documentation for __timestampIso8601
	ModifiedAt *time.Time

	// If true, there are pending monitor changes for this signal map that can be
	// deployed.
	MonitorChangesPendingDeployment *bool

	// Represents the latest monitor deployment of a signal map.
	MonitorDeployment *types.MonitorDeployment

	// A resource's name. Names must be unique within the scope of a resource type in
	// a specific region.
	Name *string

	// A signal map's current status which is dependent on its lifecycle actions or
	// associated jobs.
	Status types.SignalMapStatus

	// Represents the tags associated with a resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSignalMapMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSignalMap{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSignalMap{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSignalMap"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetSignalMapValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSignalMap(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetSignalMapAPIClient is a client that implements the GetSignalMap operation.
type GetSignalMapAPIClient interface {
	GetSignalMap(context.Context, *GetSignalMapInput, ...func(*Options)) (*GetSignalMapOutput, error)
}

var _ GetSignalMapAPIClient = (*Client)(nil)

// SignalMapCreatedWaiterOptions are waiter options for SignalMapCreatedWaiter
type SignalMapCreatedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SignalMapCreatedWaiter will use default minimum delay of 5 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SignalMapCreatedWaiter will use default max delay of 120 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetSignalMapInput, *GetSignalMapOutput, error) (bool, error)
}

// SignalMapCreatedWaiter defines the waiters for SignalMapCreated
type SignalMapCreatedWaiter struct {
	client GetSignalMapAPIClient

	options SignalMapCreatedWaiterOptions
}

// NewSignalMapCreatedWaiter constructs a SignalMapCreatedWaiter.
func NewSignalMapCreatedWaiter(client GetSignalMapAPIClient, optFns ...func(*SignalMapCreatedWaiterOptions)) *SignalMapCreatedWaiter {
	options := SignalMapCreatedWaiterOptions{}
	options.MinDelay = 5 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = signalMapCreatedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SignalMapCreatedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SignalMapCreated waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *SignalMapCreatedWaiter) Wait(ctx context.Context, params *GetSignalMapInput, maxWaitDur time.Duration, optFns ...func(*SignalMapCreatedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SignalMapCreated waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *SignalMapCreatedWaiter) WaitForOutput(ctx context.Context, params *GetSignalMapInput, maxWaitDur time.Duration, optFns ...func(*SignalMapCreatedWaiterOptions)) (*GetSignalMapOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetSignalMap(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SignalMapCreated waiter")
}

func signalMapCreatedStateRetryable(ctx context.Context, input *GetSignalMapInput, output *GetSignalMapOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "CREATE_COMPLETE"
		value, ok := pathValue.(types.SignalMapStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "CREATE_IN_PROGRESS"
		value, ok := pathValue.(types.SignalMapStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "CREATE_FAILED"
		value, ok := pathValue.(types.SignalMapStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	return true, nil
}

// SignalMapMonitorDeletedWaiterOptions are waiter options for
// SignalMapMonitorDeletedWaiter
type SignalMapMonitorDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SignalMapMonitorDeletedWaiter will use default minimum delay of 5 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SignalMapMonitorDeletedWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetSignalMapInput, *GetSignalMapOutput, error) (bool, error)
}

// SignalMapMonitorDeletedWaiter defines the waiters for SignalMapMonitorDeleted
type SignalMapMonitorDeletedWaiter struct {
	client GetSignalMapAPIClient

	options SignalMapMonitorDeletedWaiterOptions
}

// NewSignalMapMonitorDeletedWaiter constructs a SignalMapMonitorDeletedWaiter.
func NewSignalMapMonitorDeletedWaiter(client GetSignalMapAPIClient, optFns ...func(*SignalMapMonitorDeletedWaiterOptions)) *SignalMapMonitorDeletedWaiter {
	options := SignalMapMonitorDeletedWaiterOptions{}
	options.MinDelay = 5 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = signalMapMonitorDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SignalMapMonitorDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SignalMapMonitorDeleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *SignalMapMonitorDeletedWaiter) Wait(ctx context.Context, params *GetSignalMapInput, maxWaitDur time.Duration, optFns ...func(*SignalMapMonitorDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SignalMapMonitorDeleted waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *SignalMapMonitorDeletedWaiter) WaitForOutput(ctx context.Context, params *GetSignalMapInput, maxWaitDur time.Duration, optFns ...func(*SignalMapMonitorDeletedWaiterOptions)) (*GetSignalMapOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetSignalMap(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SignalMapMonitorDeleted waiter")
}

func signalMapMonitorDeletedStateRetryable(ctx context.Context, input *GetSignalMapInput, output *GetSignalMapOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DELETE_COMPLETE"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DELETE_IN_PROGRESS"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DELETE_FAILED"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	return true, nil
}

// SignalMapMonitorDeployedWaiterOptions are waiter options for
// SignalMapMonitorDeployedWaiter
type SignalMapMonitorDeployedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SignalMapMonitorDeployedWaiter will use default minimum delay of 5 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SignalMapMonitorDeployedWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetSignalMapInput, *GetSignalMapOutput, error) (bool, error)
}

// SignalMapMonitorDeployedWaiter defines the waiters for SignalMapMonitorDeployed
type SignalMapMonitorDeployedWaiter struct {
	client GetSignalMapAPIClient

	options SignalMapMonitorDeployedWaiterOptions
}

// NewSignalMapMonitorDeployedWaiter constructs a SignalMapMonitorDeployedWaiter.
func NewSignalMapMonitorDeployedWaiter(client GetSignalMapAPIClient, optFns ...func(*SignalMapMonitorDeployedWaiterOptions)) *SignalMapMonitorDeployedWaiter {
	options := SignalMapMonitorDeployedWaiterOptions{}
	options.MinDelay = 5 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = signalMapMonitorDeployedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SignalMapMonitorDeployedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SignalMapMonitorDeployed waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *SignalMapMonitorDeployedWaiter) Wait(ctx context.Context, params *GetSignalMapInput, maxWaitDur time.Duration, optFns ...func(*SignalMapMonitorDeployedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SignalMapMonitorDeployed waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *SignalMapMonitorDeployedWaiter) WaitForOutput(ctx context.Context, params *GetSignalMapInput, maxWaitDur time.Duration, optFns ...func(*SignalMapMonitorDeployedWaiterOptions)) (*GetSignalMapOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetSignalMap(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SignalMapMonitorDeployed waiter")
}

func signalMapMonitorDeployedStateRetryable(ctx context.Context, input *GetSignalMapInput, output *GetSignalMapOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DRY_RUN_DEPLOYMENT_COMPLETE"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DEPLOYMENT_COMPLETE"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DRY_RUN_DEPLOYMENT_IN_PROGRESS"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DEPLOYMENT_IN_PROGRESS"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DRY_RUN_DEPLOYMENT_FAILED"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("MonitorDeployment.Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "DEPLOYMENT_FAILED"
		value, ok := pathValue.(types.SignalMapMonitorDeploymentStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapMonitorDeploymentStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	return true, nil
}

// SignalMapUpdatedWaiterOptions are waiter options for SignalMapUpdatedWaiter
type SignalMapUpdatedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SignalMapUpdatedWaiter will use default minimum delay of 5 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SignalMapUpdatedWaiter will use default max delay of 120 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetSignalMapInput, *GetSignalMapOutput, error) (bool, error)
}

// SignalMapUpdatedWaiter defines the waiters for SignalMapUpdated
type SignalMapUpdatedWaiter struct {
	client GetSignalMapAPIClient

	options SignalMapUpdatedWaiterOptions
}

// NewSignalMapUpdatedWaiter constructs a SignalMapUpdatedWaiter.
func NewSignalMapUpdatedWaiter(client GetSignalMapAPIClient, optFns ...func(*SignalMapUpdatedWaiterOptions)) *SignalMapUpdatedWaiter {
	options := SignalMapUpdatedWaiterOptions{}
	options.MinDelay = 5 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = signalMapUpdatedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SignalMapUpdatedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SignalMapUpdated waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *SignalMapUpdatedWaiter) Wait(ctx context.Context, params *GetSignalMapInput, maxWaitDur time.Duration, optFns ...func(*SignalMapUpdatedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SignalMapUpdated waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *SignalMapUpdatedWaiter) WaitForOutput(ctx context.Context, params *GetSignalMapInput, maxWaitDur time.Duration, optFns ...func(*SignalMapUpdatedWaiterOptions)) (*GetSignalMapOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetSignalMap(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SignalMapUpdated waiter")
}

func signalMapUpdatedStateRetryable(ctx context.Context, input *GetSignalMapInput, output *GetSignalMapOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "UPDATE_COMPLETE"
		value, ok := pathValue.(types.SignalMapStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "UPDATE_IN_PROGRESS"
		value, ok := pathValue.(types.SignalMapStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "UPDATE_FAILED"
		value, ok := pathValue.(types.SignalMapStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "UPDATE_REVERTED"
		value, ok := pathValue.(types.SignalMapStatus)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected types.SignalMapStatus value, got %T", pathValue)
		}

		if string(value) == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	return true, nil
}

func newServiceMetadataMiddleware_opGetSignalMap(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSignalMap",
	}
}
