// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockruntime

import (
	"bytes"
	"context"
	"fmt"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpInvokeModel struct {
}

func (*awsRestjson1_serializeOpInvokeModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInvokeModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model/{modelId}/invoke")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInvokeModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Body != nil {
		payload := bytes.NewReader(input.Body)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInvokeModelInput(v *InvokeModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Accept != nil && len(*v.Accept) > 0 {
		locationName := "Accept"
		encoder.SetHeader(locationName).String(*v.Accept)
	}

	if v.ContentType != nil && len(*v.ContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.GuardrailIdentifier != nil && len(*v.GuardrailIdentifier) > 0 {
		locationName := "X-Amzn-Bedrock-Guardrailidentifier"
		encoder.SetHeader(locationName).String(*v.GuardrailIdentifier)
	}

	if v.GuardrailVersion != nil && len(*v.GuardrailVersion) > 0 {
		locationName := "X-Amzn-Bedrock-Guardrailversion"
		encoder.SetHeader(locationName).String(*v.GuardrailVersion)
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("modelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	if len(v.Trace) > 0 {
		locationName := "X-Amzn-Bedrock-Trace"
		encoder.SetHeader(locationName).String(string(v.Trace))
	}

	return nil
}

type awsRestjson1_serializeOpInvokeModelWithResponseStream struct {
}

func (*awsRestjson1_serializeOpInvokeModelWithResponseStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInvokeModelWithResponseStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeModelWithResponseStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model/{modelId}/invoke-with-response-stream")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInvokeModelWithResponseStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Body != nil {
		payload := bytes.NewReader(input.Body)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInvokeModelWithResponseStreamInput(v *InvokeModelWithResponseStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Accept != nil && len(*v.Accept) > 0 {
		locationName := "X-Amzn-Bedrock-Accept"
		encoder.SetHeader(locationName).String(*v.Accept)
	}

	if v.ContentType != nil && len(*v.ContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.GuardrailIdentifier != nil && len(*v.GuardrailIdentifier) > 0 {
		locationName := "X-Amzn-Bedrock-Guardrailidentifier"
		encoder.SetHeader(locationName).String(*v.GuardrailIdentifier)
	}

	if v.GuardrailVersion != nil && len(*v.GuardrailVersion) > 0 {
		locationName := "X-Amzn-Bedrock-Guardrailversion"
		encoder.SetHeader(locationName).String(*v.GuardrailVersion)
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("modelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	if len(v.Trace) > 0 {
		locationName := "X-Amzn-Bedrock-Trace"
		encoder.SetHeader(locationName).String(string(v.Trace))
	}

	return nil
}
