// Code generated by smithy-go-codegen DO NOT EDIT.

package smithyrpcv2cbor

import (
	"bytes"
	"context"
	"encoding/base64"
	"github.com/aws/aws-sdk-go-v2/aws"
	protocoltesthttp "github.com/aws/aws-sdk-go-v2/internal/protocoltest"
	"github.com/aws/aws-sdk-go-v2/internal/protocoltest/smithyrpcv2cbor/types"
	"github.com/aws/smithy-go/middleware"
	smithyprivateprotocol "github.com/aws/smithy-go/private/protocol"
	"github.com/aws/smithy-go/ptr"
	smithytesting "github.com/aws/smithy-go/testing"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"testing"
)

func TestClient_OperationWithDefaults_smithyRpcv2cborSerialize(t *testing.T) {
	cases := map[string]struct {
		Params        *OperationWithDefaultsInput
		ExpectMethod  string
		ExpectURIPath string
		ExpectQuery   []smithytesting.QueryItem
		RequireQuery  []string
		ForbidQuery   []string
		ExpectHeader  http.Header
		RequireHeader []string
		ForbidHeader  []string
		Host          *url.URL
		BodyMediaType string
		BodyAssert    func(io.Reader) error
	}{
		// Client populates default values in input.
		"RpcV2CborClientPopulatesDefaultValuesInInput": {
			Params: &OperationWithDefaultsInput{
				Defaults: &types.Defaults{},
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/service/RpcV2Protocol/operation/OperationWithDefaults",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type":    []string{"application/cbor"},
				"smithy-protocol": []string{"rpc-v2-cbor"},
			},
			RequireHeader: []string{
				"Content-Length",
			},
			BodyMediaType: "application/cbor",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareCBOR(actual, `v21kZWZhdWx0U3RyaW5nYmhpbmRlZmF1bHRCb29sZWFu9WtkZWZhdWx0TGlzdIBwZGVmYXVsdFRpbWVzdGFtcMH7AAAAAAAAAABrZGVmYXVsdEJsb2JDYWJja2RlZmF1bHRCeXRlAWxkZWZhdWx0U2hvcnQBbmRlZmF1bHRJbnRlZ2VyCmtkZWZhdWx0TG9uZxhkbGRlZmF1bHRGbG9hdPo/gAAAbWRlZmF1bHREb3VibGX7P/AAAAAAAABqZGVmYXVsdE1hcKBrZGVmYXVsdEVudW1jRk9PbmRlZmF1bHRJbnRFbnVtAWtlbXB0eVN0cmluZ2BsZmFsc2VCb29sZWFu9GllbXB0eUJsb2JAaHplcm9CeXRlAGl6ZXJvU2hvcnQAa3plcm9JbnRlZ2VyAGh6ZXJvTG9uZwBpemVyb0Zsb2F0+gAAAABqemVyb0RvdWJsZfsAAAAAAAAAAP8=`)
			},
		},
		// Client skips top level default values in input.
		"RpcV2CborClientSkipsTopLevelDefaultValuesInInput": {
			Params:        &OperationWithDefaultsInput{},
			ExpectMethod:  "POST",
			ExpectURIPath: "/service/RpcV2Protocol/operation/OperationWithDefaults",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type":    []string{"application/cbor"},
				"smithy-protocol": []string{"rpc-v2-cbor"},
			},
			RequireHeader: []string{
				"Content-Length",
			},
			BodyMediaType: "application/cbor",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareCBOR(actual, `v/8=`)
			},
		},
		// Client uses explicitly provided member values over defaults
		"RpcV2CborClientUsesExplicitlyProvidedMemberValuesOverDefaults": {
			Params: &OperationWithDefaultsInput{
				Defaults: &types.Defaults{
					DefaultString:  ptr.String("bye"),
					DefaultBoolean: ptr.Bool(true),
					DefaultList: []string{
						"a",
					},
					DefaultTimestamp: ptr.Time(smithytime.ParseEpochSeconds(1)),
					DefaultBlob:      []byte("hi"),
					DefaultByte:      ptr.Int8(2),
					DefaultShort:     ptr.Int16(2),
					DefaultInteger:   ptr.Int32(20),
					DefaultLong:      ptr.Int64(200),
					DefaultFloat:     ptr.Float32(2.0),
					DefaultDouble:    ptr.Float64(2.0),
					DefaultMap: map[string]string{
						"name": "Jack",
					},
					DefaultEnum:    types.TestEnum("BAR"),
					DefaultIntEnum: 2,
					EmptyString:    ptr.String("foo"),
					FalseBoolean:   true,
					EmptyBlob:      []byte("hi"),
					ZeroByte:       1,
					ZeroShort:      1,
					ZeroInteger:    1,
					ZeroLong:       1,
					ZeroFloat:      1.0,
					ZeroDouble:     1.0,
				},
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/service/RpcV2Protocol/operation/OperationWithDefaults",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type":    []string{"application/cbor"},
				"smithy-protocol": []string{"rpc-v2-cbor"},
			},
			RequireHeader: []string{
				"Content-Length",
			},
			BodyMediaType: "application/cbor",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareCBOR(actual, `v2hkZWZhdWx0c7dtZGVmYXVsdFN0cmluZ2NieWVuZGVmYXVsdEJvb2xlYW71a2RlZmF1bHRMaXN0gWFhcGRlZmF1bHRUaW1lc3RhbXDB+z/wAAAAAAAAa2RlZmF1bHRCbG9iQmhpa2RlZmF1bHRCeXRlAmxkZWZhdWx0U2hvcnQCbmRlZmF1bHRJbnRlZ2VyFGtkZWZhdWx0TG9uZxjIbGRlZmF1bHRGbG9hdPpAAAAAbWRlZmF1bHREb3VibGX7QAAAAAAAAABqZGVmYXVsdE1hcKFkbmFtZWRKYWNra2RlZmF1bHRFbnVtY0JBUm5kZWZhdWx0SW50RW51bQJrZW1wdHlTdHJpbmdjZm9vbGZhbHNlQm9vbGVhbvVpZW1wdHlCbG9iQmhpaHplcm9CeXRlAWl6ZXJvU2hvcnQBa3plcm9JbnRlZ2VyAWh6ZXJvTG9uZwFpemVyb0Zsb2F0+j+AAABqemVyb0RvdWJsZfs/8AAAAAAAAP8=`)
			},
		},
		// Any time a value is provided for a member in the top level of input, it is
		// used, regardless of if its the default.
		"RpcV2CborClientUsesExplicitlyProvidedValuesInTopLevel": {
			Params: &OperationWithDefaultsInput{
				TopLevelDefault:      ptr.String("hi"),
				OtherTopLevelDefault: 0,
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/service/RpcV2Protocol/operation/OperationWithDefaults",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type":    []string{"application/cbor"},
				"smithy-protocol": []string{"rpc-v2-cbor"},
			},
			RequireHeader: []string{
				"Content-Length",
			},
			BodyMediaType: "application/cbor",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareCBOR(actual, `v290b3BMZXZlbERlZmF1bHRiaGl0b3RoZXJUb3BMZXZlbERlZmF1bHQA/w==`)
			},
		},
		// Typically, non top-level members would have defaults filled in, but if they
		// have the clientOptional trait, the defaults should be ignored.
		"RpcV2CborClientIgnoresNonTopLevelDefaultsOnMembersWithClientOptional": {
			Params: &OperationWithDefaultsInput{
				ClientOptionalDefaults: &types.ClientOptionalDefaults{},
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/service/RpcV2Protocol/operation/OperationWithDefaults",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type":    []string{"application/cbor"},
				"smithy-protocol": []string{"rpc-v2-cbor"},
			},
			RequireHeader: []string{
				"Content-Length",
			},
			BodyMediaType: "application/cbor",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareCBOR(actual, `v3ZjbGllbnRPcHRpb25hbERlZmF1bHRzoP8=`)
			},
		},
	}
	for name, c := range cases {
		t.Run(name, func(t *testing.T) {
			if name == "RpcV2CborClientPopulatesDefaultValuesInInput" {
				t.Skip("disabled test smithy.protocoltests.rpcv2Cbor#RpcV2Protocol smithy.protocoltests.rpcv2Cbor#OperationWithDefaults")
			}

			if name == "RpcV2CborClientSkipsTopLevelDefaultValuesInInput" {
				t.Skip("disabled test smithy.protocoltests.rpcv2Cbor#RpcV2Protocol smithy.protocoltests.rpcv2Cbor#OperationWithDefaults")
			}

			if name == "RpcV2CborClientUsesExplicitlyProvidedMemberValuesOverDefaults" {
				t.Skip("disabled test smithy.protocoltests.rpcv2Cbor#RpcV2Protocol smithy.protocoltests.rpcv2Cbor#OperationWithDefaults")
			}

			if name == "RpcV2CborClientUsesExplicitlyProvidedValuesInTopLevel" {
				t.Skip("disabled test smithy.protocoltests.rpcv2Cbor#RpcV2Protocol smithy.protocoltests.rpcv2Cbor#OperationWithDefaults")
			}

			if name == "RpcV2CborClientIgnoresNonTopLevelDefaultsOnMembersWithClientOptional" {
				t.Skip("disabled test smithy.protocoltests.rpcv2Cbor#RpcV2Protocol smithy.protocoltests.rpcv2Cbor#OperationWithDefaults")
			}

			actualReq := &http.Request{}
			serverURL := "http://localhost:8888/"
			if c.Host != nil {
				u, err := url.Parse(serverURL)
				if err != nil {
					t.Fatalf("expect no error, got %v", err)
				}
				u.Path = c.Host.Path
				u.RawPath = c.Host.RawPath
				u.RawQuery = c.Host.RawQuery
				serverURL = u.String()
			}
			client := New(Options{
				APIOptions: []func(*middleware.Stack) error{
					func(s *middleware.Stack) error {
						s.Finalize.Clear()
						s.Initialize.Remove(`OperationInputValidation`)
						return nil
					},
				},
				EndpointResolver: EndpointResolverFunc(func(region string, options EndpointResolverOptions) (e aws.Endpoint, err error) {
					e.URL = serverURL
					e.SigningRegion = "us-west-2"
					return e, err
				}),
				HTTPClient: protocoltesthttp.NewClient(),
				Region:     "us-west-2",
			})
			result, err := client.OperationWithDefaults(context.Background(), c.Params, func(options *Options) {
				options.APIOptions = append(options.APIOptions, func(stack *middleware.Stack) error {
					return smithyprivateprotocol.AddCaptureRequestMiddleware(stack, actualReq)
				})
			})
			if err != nil {
				t.Fatalf("expect nil err, got %v", err)
			}
			if result == nil {
				t.Fatalf("expect not nil result")
			}
			if e, a := c.ExpectMethod, actualReq.Method; e != a {
				t.Errorf("expect %v method, got %v", e, a)
			}
			if e, a := c.ExpectURIPath, actualReq.URL.RawPath; e != a {
				t.Errorf("expect %v path, got %v", e, a)
			}
			queryItems := smithytesting.ParseRawQuery(actualReq.URL.RawQuery)
			smithytesting.AssertHasQuery(t, c.ExpectQuery, queryItems)
			smithytesting.AssertHasQueryKeys(t, c.RequireQuery, queryItems)
			smithytesting.AssertNotHaveQueryKeys(t, c.ForbidQuery, queryItems)
			smithytesting.AssertHasHeader(t, c.ExpectHeader, actualReq.Header)
			smithytesting.AssertHasHeaderKeys(t, c.RequireHeader, actualReq.Header)
			smithytesting.AssertNotHaveHeaderKeys(t, c.ForbidHeader, actualReq.Header)
			if c.BodyAssert != nil {
				if err := c.BodyAssert(actualReq.Body); err != nil {
					t.Errorf("expect body equal, got %v", err)
				}
			}
		})
	}
}

func TestClient_OperationWithDefaults_smithyRpcv2cborDeserialize(t *testing.T) {
	cases := map[string]struct {
		StatusCode    int
		Header        http.Header
		BodyMediaType string
		Body          []byte
		ExpectResult  *OperationWithDefaultsOutput
	}{
		// Client populates default values when missing in response.
		"RpcV2CborClientPopulatesDefaultsValuesWhenMissingInResponse": {
			StatusCode: 200,
			Header: http.Header{
				"Content-Type":    []string{"application/cbor"},
				"smithy-protocol": []string{"rpc-v2-cbor"},
			},
			BodyMediaType: "application/cbor",
			Body: func() []byte {
				p, err := base64.StdEncoding.DecodeString(`v/8=`)
				if err != nil {
					panic(err)
				}

				return p
			}(),
			ExpectResult: &OperationWithDefaultsOutput{
				DefaultString:    ptr.String("hi"),
				DefaultBoolean:   ptr.Bool(true),
				DefaultList:      []string{},
				DefaultTimestamp: ptr.Time(smithytime.ParseEpochSeconds(0)),
				DefaultBlob:      []byte("abc"),
				DefaultByte:      ptr.Int8(1),
				DefaultShort:     ptr.Int16(1),
				DefaultInteger:   ptr.Int32(10),
				DefaultLong:      ptr.Int64(100),
				DefaultFloat:     ptr.Float32(1.0),
				DefaultDouble:    ptr.Float64(1.0),
				DefaultMap:       map[string]string{},
				DefaultEnum:      types.TestEnum("FOO"),
				DefaultIntEnum:   1,
				EmptyString:      ptr.String(""),
				FalseBoolean:     false,
				EmptyBlob:        []byte(""),
				ZeroByte:         0,
				ZeroShort:        0,
				ZeroInteger:      0,
				ZeroLong:         0,
				ZeroFloat:        0.0,
				ZeroDouble:       0.0,
			},
		},
		// Client ignores default values if member values are present in the response.
		"RpcV2CborClientIgnoresDefaultValuesIfMemberValuesArePresentInResponse": {
			StatusCode: 200,
			Header: http.Header{
				"Content-Type":    []string{"application/cbor"},
				"smithy-protocol": []string{"rpc-v2-cbor"},
			},
			BodyMediaType: "application/cbor",
			Body: func() []byte {
				p, err := base64.StdEncoding.DecodeString(`v21kZWZhdWx0U3RyaW5nY2J5ZW5kZWZhdWx0Qm9vbGVhbvRrZGVmYXVsdExpc3SBYWFwZGVmYXVsdFRpbWVzdGFtcMH7QAAAAAAAAABrZGVmYXVsdEJsb2JCaGlrZGVmYXVsdEJ5dGUCbGRlZmF1bHRTaG9ydAJuZGVmYXVsdEludGVnZXIUa2RlZmF1bHRMb25nGMhsZGVmYXVsdEZsb2F0+kAAAABtZGVmYXVsdERvdWJsZftAAAAAAAAAAGpkZWZhdWx0TWFwoWRuYW1lZEphY2trZGVmYXVsdEVudW1jQkFSbmRlZmF1bHRJbnRFbnVtAmtlbXB0eVN0cmluZ2Nmb29sZmFsc2VCb29sZWFu9WllbXB0eUJsb2JCaGloemVyb0J5dGUBaXplcm9TaG9ydAFremVyb0ludGVnZXIBaHplcm9Mb25nAWl6ZXJvRmxvYXT6P4AAAGp6ZXJvRG91Ymxl+z/wAAAAAAAA/w==`)
				if err != nil {
					panic(err)
				}

				return p
			}(),
			ExpectResult: &OperationWithDefaultsOutput{
				DefaultString:  ptr.String("bye"),
				DefaultBoolean: ptr.Bool(false),
				DefaultList: []string{
					"a",
				},
				DefaultTimestamp: ptr.Time(smithytime.ParseEpochSeconds(2)),
				DefaultBlob:      []byte("hi"),
				DefaultByte:      ptr.Int8(2),
				DefaultShort:     ptr.Int16(2),
				DefaultInteger:   ptr.Int32(20),
				DefaultLong:      ptr.Int64(200),
				DefaultFloat:     ptr.Float32(2.0),
				DefaultDouble:    ptr.Float64(2.0),
				DefaultMap: map[string]string{
					"name": "Jack",
				},
				DefaultEnum:    types.TestEnum("BAR"),
				DefaultIntEnum: 2,
				EmptyString:    ptr.String("foo"),
				FalseBoolean:   true,
				EmptyBlob:      []byte("hi"),
				ZeroByte:       1,
				ZeroShort:      1,
				ZeroInteger:    1,
				ZeroLong:       1,
				ZeroFloat:      1.0,
				ZeroDouble:     1.0,
			},
		},
	}
	for name, c := range cases {
		t.Run(name, func(t *testing.T) {
			if name == "RpcV2CborClientPopulatesDefaultsValuesWhenMissingInResponse" {
				t.Skip("disabled test smithy.protocoltests.rpcv2Cbor#RpcV2Protocol smithy.protocoltests.rpcv2Cbor#OperationWithDefaults")
			}

			if name == "RpcV2CborClientIgnoresDefaultValuesIfMemberValuesArePresentInResponse" {
				t.Skip("disabled test smithy.protocoltests.rpcv2Cbor#RpcV2Protocol smithy.protocoltests.rpcv2Cbor#OperationWithDefaults")
			}

			serverURL := "http://localhost:8888/"
			client := New(Options{
				HTTPClient: smithyhttp.ClientDoFunc(func(r *http.Request) (*http.Response, error) {
					headers := http.Header{}
					for k, vs := range c.Header {
						for _, v := range vs {
							headers.Add(k, v)
						}
					}
					if len(c.BodyMediaType) != 0 && len(headers.Values("Content-Type")) == 0 {
						headers.Set("Content-Type", c.BodyMediaType)
					}
					response := &http.Response{
						StatusCode: c.StatusCode,
						Header:     headers,
						Request:    r,
					}
					if len(c.Body) != 0 {
						response.ContentLength = int64(len(c.Body))
						response.Body = ioutil.NopCloser(bytes.NewReader(c.Body))
					} else {

						response.Body = http.NoBody
					}
					return response, nil
				}),
				APIOptions: []func(*middleware.Stack) error{
					func(s *middleware.Stack) error {
						s.Finalize.Clear()
						s.Initialize.Remove(`OperationInputValidation`)
						return nil
					},
				},
				EndpointResolver: EndpointResolverFunc(func(region string, options EndpointResolverOptions) (e aws.Endpoint, err error) {
					e.URL = serverURL
					e.SigningRegion = "us-west-2"
					return e, err
				}),
				Region: "us-west-2",
			})
			var params OperationWithDefaultsInput
			result, err := client.OperationWithDefaults(context.Background(), &params)
			if err != nil {
				t.Fatalf("expect nil err, got %v", err)
			}
			if result == nil {
				t.Fatalf("expect not nil result")
			}
			if err := smithytesting.CompareValues(c.ExpectResult, result); err != nil {
				t.Errorf("expect c.ExpectResult value match:\n%v", err)
			}
		})
	}
}
