//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// VolumeContainersClient contains the methods for the VolumeContainers group.
// Don't use this type directly, use NewVolumeContainersClient() instead.
type VolumeContainersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewVolumeContainersClient creates a new instance of VolumeContainersClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewVolumeContainersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VolumeContainersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &VolumeContainersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or updates the volume container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The name of the volume container.
// resourceGroupName - The resource group name
// managerName - The manager name
// parameters - The volume container to be added or updated.
// options - VolumeContainersClientBeginCreateOrUpdateOptions contains the optional parameters for the VolumeContainersClient.BeginCreateOrUpdate
// method.
func (client *VolumeContainersClient) BeginCreateOrUpdate(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, parameters VolumeContainer, options *VolumeContainersClientBeginCreateOrUpdateOptions) (*runtime.Poller[VolumeContainersClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, deviceName, volumeContainerName, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[VolumeContainersClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[VolumeContainersClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Creates or updates the volume container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
func (client *VolumeContainersClient) createOrUpdate(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, parameters VolumeContainer, options *VolumeContainersClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, deviceName, volumeContainerName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VolumeContainersClient) createOrUpdateCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, parameters VolumeContainer, options *VolumeContainersClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginDelete - Deletes the volume container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The name of the volume container.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumeContainersClientBeginDeleteOptions contains the optional parameters for the VolumeContainersClient.BeginDelete
// method.
func (client *VolumeContainersClient) BeginDelete(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumeContainersClientBeginDeleteOptions) (*runtime.Poller[VolumeContainersClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, deviceName, volumeContainerName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[VolumeContainersClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[VolumeContainersClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the volume container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
func (client *VolumeContainersClient) deleteOperation(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumeContainersClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, deviceName, volumeContainerName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *VolumeContainersClient) deleteCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumeContainersClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets the properties of the specified volume container name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The name of the volume container.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumeContainersClientGetOptions contains the optional parameters for the VolumeContainersClient.Get method.
func (client *VolumeContainersClient) Get(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumeContainersClientGetOptions) (VolumeContainersClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, deviceName, volumeContainerName, resourceGroupName, managerName, options)
	if err != nil {
		return VolumeContainersClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VolumeContainersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return VolumeContainersClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *VolumeContainersClient) getCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumeContainersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VolumeContainersClient) getHandleResponse(resp *http.Response) (VolumeContainersClientGetResponse, error) {
	result := VolumeContainersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VolumeContainer); err != nil {
		return VolumeContainersClientGetResponse{}, err
	}
	return result, nil
}

// NewListByDevicePager - Gets all the volume containers in a device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumeContainersClientListByDeviceOptions contains the optional parameters for the VolumeContainersClient.ListByDevice
// method.
func (client *VolumeContainersClient) NewListByDevicePager(deviceName string, resourceGroupName string, managerName string, options *VolumeContainersClientListByDeviceOptions) *runtime.Pager[VolumeContainersClientListByDeviceResponse] {
	return runtime.NewPager(runtime.PagingHandler[VolumeContainersClientListByDeviceResponse]{
		More: func(page VolumeContainersClientListByDeviceResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *VolumeContainersClientListByDeviceResponse) (VolumeContainersClientListByDeviceResponse, error) {
			req, err := client.listByDeviceCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return VolumeContainersClientListByDeviceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VolumeContainersClientListByDeviceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VolumeContainersClientListByDeviceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDeviceHandleResponse(resp)
		},
	})
}

// listByDeviceCreateRequest creates the ListByDevice request.
func (client *VolumeContainersClient) listByDeviceCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *VolumeContainersClientListByDeviceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDeviceHandleResponse handles the ListByDevice response.
func (client *VolumeContainersClient) listByDeviceHandleResponse(resp *http.Response) (VolumeContainersClientListByDeviceResponse, error) {
	result := VolumeContainersClientListByDeviceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VolumeContainerList); err != nil {
		return VolumeContainersClientListByDeviceResponse{}, err
	}
	return result, nil
}

// NewListMetricDefinitionPager - Gets the metric definitions for the specified volume container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The volume container name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumeContainersClientListMetricDefinitionOptions contains the optional parameters for the VolumeContainersClient.ListMetricDefinition
// method.
func (client *VolumeContainersClient) NewListMetricDefinitionPager(deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumeContainersClientListMetricDefinitionOptions) *runtime.Pager[VolumeContainersClientListMetricDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[VolumeContainersClientListMetricDefinitionResponse]{
		More: func(page VolumeContainersClientListMetricDefinitionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *VolumeContainersClientListMetricDefinitionResponse) (VolumeContainersClientListMetricDefinitionResponse, error) {
			req, err := client.listMetricDefinitionCreateRequest(ctx, deviceName, volumeContainerName, resourceGroupName, managerName, options)
			if err != nil {
				return VolumeContainersClientListMetricDefinitionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VolumeContainersClientListMetricDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VolumeContainersClientListMetricDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricDefinitionHandleResponse(resp)
		},
	})
}

// listMetricDefinitionCreateRequest creates the ListMetricDefinition request.
func (client *VolumeContainersClient) listMetricDefinitionCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumeContainersClientListMetricDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/metricsDefinitions"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricDefinitionHandleResponse handles the ListMetricDefinition response.
func (client *VolumeContainersClient) listMetricDefinitionHandleResponse(resp *http.Response) (VolumeContainersClientListMetricDefinitionResponse, error) {
	result := VolumeContainersClientListMetricDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionList); err != nil {
		return VolumeContainersClientListMetricDefinitionResponse{}, err
	}
	return result, nil
}

// NewListMetricsPager - Gets the metrics for the specified volume container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The volume container name.
// resourceGroupName - The resource group name
// managerName - The manager name
// filter - OData Filter options
// options - VolumeContainersClientListMetricsOptions contains the optional parameters for the VolumeContainersClient.ListMetrics
// method.
func (client *VolumeContainersClient) NewListMetricsPager(deviceName string, volumeContainerName string, resourceGroupName string, managerName string, filter string, options *VolumeContainersClientListMetricsOptions) *runtime.Pager[VolumeContainersClientListMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[VolumeContainersClientListMetricsResponse]{
		More: func(page VolumeContainersClientListMetricsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *VolumeContainersClientListMetricsResponse) (VolumeContainersClientListMetricsResponse, error) {
			req, err := client.listMetricsCreateRequest(ctx, deviceName, volumeContainerName, resourceGroupName, managerName, filter, options)
			if err != nil {
				return VolumeContainersClientListMetricsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VolumeContainersClientListMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VolumeContainersClientListMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricsHandleResponse(resp)
		},
	})
}

// listMetricsCreateRequest creates the ListMetrics request.
func (client *VolumeContainersClient) listMetricsCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, filter string, options *VolumeContainersClientListMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/metrics"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	reqQP.Set("$filter", filter)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricsHandleResponse handles the ListMetrics response.
func (client *VolumeContainersClient) listMetricsHandleResponse(resp *http.Response) (VolumeContainersClientListMetricsResponse, error) {
	result := VolumeContainersClientListMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricList); err != nil {
		return VolumeContainersClientListMetricsResponse{}, err
	}
	return result, nil
}
