//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServerVulnerabilityAssessmentsClient contains the methods for the ServerVulnerabilityAssessments group.
// Don't use this type directly, use NewServerVulnerabilityAssessmentsClient() instead.
type ServerVulnerabilityAssessmentsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewServerVulnerabilityAssessmentsClient creates a new instance of ServerVulnerabilityAssessmentsClient with the specified values.
// subscriptionID - The subscription ID that identifies an Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewServerVulnerabilityAssessmentsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServerVulnerabilityAssessmentsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ServerVulnerabilityAssessmentsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates the server's vulnerability assessment. Learn more about setting SQL vulnerability assessment
// with managed identity -
// https://docs.microsoft.com/azure/azure-sql/database/sql-database-vulnerability-assessment-storage
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server for which the vulnerability assessment is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// parameters - The requested resource.
// options - ServerVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters for the ServerVulnerabilityAssessmentsClient.CreateOrUpdate
// method.
func (client *ServerVulnerabilityAssessmentsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, parameters ServerVulnerabilityAssessment, options *ServerVulnerabilityAssessmentsClientCreateOrUpdateOptions) (ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, parameters, options)
	if err != nil {
		return ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ServerVulnerabilityAssessmentsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, parameters ServerVulnerabilityAssessment, options *ServerVulnerabilityAssessmentsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ServerVulnerabilityAssessmentsClient) createOrUpdateHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse, error) {
	result := ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessment); err != nil {
		return ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Removes the server's vulnerability assessment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server for which the vulnerability assessment is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// options - ServerVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the ServerVulnerabilityAssessmentsClient.Delete
// method.
func (client *ServerVulnerabilityAssessmentsClient) Delete(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ServerVulnerabilityAssessmentsClientDeleteOptions) (ServerVulnerabilityAssessmentsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, options)
	if err != nil {
		return ServerVulnerabilityAssessmentsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServerVulnerabilityAssessmentsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ServerVulnerabilityAssessmentsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ServerVulnerabilityAssessmentsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ServerVulnerabilityAssessmentsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets the server's vulnerability assessment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server for which the vulnerability assessment is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// options - ServerVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the ServerVulnerabilityAssessmentsClient.Get
// method.
func (client *ServerVulnerabilityAssessmentsClient) Get(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ServerVulnerabilityAssessmentsClientGetOptions) (ServerVulnerabilityAssessmentsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, options)
	if err != nil {
		return ServerVulnerabilityAssessmentsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerVulnerabilityAssessmentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServerVulnerabilityAssessmentsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ServerVulnerabilityAssessmentsClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ServerVulnerabilityAssessmentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ServerVulnerabilityAssessmentsClient) getHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentsClientGetResponse, error) {
	result := ServerVulnerabilityAssessmentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessment); err != nil {
		return ServerVulnerabilityAssessmentsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByServerPager - Lists the vulnerability assessment policies associated with a server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server.
// options - ServerVulnerabilityAssessmentsClientListByServerOptions contains the optional parameters for the ServerVulnerabilityAssessmentsClient.ListByServer
// method.
func (client *ServerVulnerabilityAssessmentsClient) NewListByServerPager(resourceGroupName string, serverName string, options *ServerVulnerabilityAssessmentsClientListByServerOptions) *runtime.Pager[ServerVulnerabilityAssessmentsClientListByServerResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServerVulnerabilityAssessmentsClientListByServerResponse]{
		More: func(page ServerVulnerabilityAssessmentsClientListByServerResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ServerVulnerabilityAssessmentsClientListByServerResponse) (ServerVulnerabilityAssessmentsClientListByServerResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByServerCreateRequest(ctx, resourceGroupName, serverName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ServerVulnerabilityAssessmentsClientListByServerResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ServerVulnerabilityAssessmentsClientListByServerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ServerVulnerabilityAssessmentsClientListByServerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByServerHandleResponse(resp)
		},
	})
}

// listByServerCreateRequest creates the ListByServer request.
func (client *ServerVulnerabilityAssessmentsClient) listByServerCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServerVulnerabilityAssessmentsClientListByServerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByServerHandleResponse handles the ListByServer response.
func (client *ServerVulnerabilityAssessmentsClient) listByServerHandleResponse(resp *http.Response) (ServerVulnerabilityAssessmentsClientListByServerResponse, error) {
	result := ServerVulnerabilityAssessmentsClientListByServerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessmentListResult); err != nil {
		return ServerVulnerabilityAssessmentsClientListByServerResponse{}, err
	}
	return result, nil
}
